(function e(t,n,r){function s(o,u){if(!n[o]){if(!t[o]){var a=typeof require=="function"&&require;if(!u&&a)return a(o,!0);if(i)return i(o,!0);var f=new Error("Cannot find module '"+o+"'");throw f.code="MODULE_NOT_FOUND",f}var l=n[o]={exports:{}};t[o][0].call(l.exports,function(e){var n=t[o][1][e];return s(n?n:e)},l,l.exports,e,t,n,r)}return n[o].exports}var i=typeof require=="function"&&require;for(var o=0;o<r.length;o++)s(r[o]);return s})({1:[function(require,module,exports){
(function (root, factory) {
    if (typeof define === 'function' && define.amd) {
        define(factory);
    } else if (typeof exports === 'object') {
        module.exports = factory();
    } else {
        root.deepmerge = factory();
    }
}(this, function () {

function isMergeableObject(val) {
    var nonNullObject = val && typeof val === 'object'

    return nonNullObject
        && Object.prototype.toString.call(val) !== '[object RegExp]'
        && Object.prototype.toString.call(val) !== '[object Date]'
}

function emptyTarget(val) {
    return Array.isArray(val) ? [] : {}
}

function cloneIfNecessary(value, optionsArgument) {
    var clone = optionsArgument && optionsArgument.clone === true
    return (clone && isMergeableObject(value)) ? deepmerge(emptyTarget(value), value, optionsArgument) : value
}

function defaultArrayMerge(target, source, optionsArgument) {
    var destination = target.slice()
    source.forEach(function(e, i) {
        if (typeof destination[i] === 'undefined') {
            destination[i] = cloneIfNecessary(e, optionsArgument)
        } else if (isMergeableObject(e)) {
            destination[i] = deepmerge(target[i], e, optionsArgument)
        } else if (target.indexOf(e) === -1) {
            destination.push(cloneIfNecessary(e, optionsArgument))
        }
    })
    return destination
}

function mergeObject(target, source, optionsArgument) {
    var destination = {}
    if (isMergeableObject(target)) {
        Object.keys(target).forEach(function (key) {
            destination[key] = cloneIfNecessary(target[key], optionsArgument)
        })
    }
    Object.keys(source).forEach(function (key) {
        if (!isMergeableObject(source[key]) || !target[key]) {
            destination[key] = cloneIfNecessary(source[key], optionsArgument)
        } else {
            destination[key] = deepmerge(target[key], source[key], optionsArgument)
        }
    })
    return destination
}

function deepmerge(target, source, optionsArgument) {
    var array = Array.isArray(source);
    var options = optionsArgument || { arrayMerge: defaultArrayMerge }
    var arrayMerge = options.arrayMerge || defaultArrayMerge

    if (array) {
        return Array.isArray(target) ? arrayMerge(target, source, optionsArgument) : cloneIfNecessary(source, optionsArgument)
    } else {
        return mergeObject(target, source, optionsArgument)
    }
}

deepmerge.all = function deepmergeAll(array, optionsArgument) {
    if (!Array.isArray(array) || array.length < 2) {
        throw new Error('first argument should be an array with at least two elements')
    }

    // we are sure there are at least 2 values, so it is safe to have no initial value
    return array.reduce(function(prev, next) {
        return deepmerge(prev, next, optionsArgument)
    })
}

return deepmerge

}));

},{}],2:[function(require,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /** @module agg-house */

var _aggRoom = require('./core/agg-room');

var _aggRoom2 = _interopRequireDefault(_aggRoom);

var _config = require('./core/config');

var _config2 = _interopRequireDefault(_config);

var _error = require('./types/error');

var _deepmerge = require('deepmerge');

var _deepmerge2 = _interopRequireDefault(_deepmerge);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/** Class that manages aggregators. */
var AggHouse = function () {
    /**
     * Initialize an AggHouse.
     * @param {Object} optionalConfigs Optional configurations.
     */
    function AggHouse(optionalConfigs) {
        _classCallCheck(this, AggHouse);

        /** @private {!Object} */
        this.aggregatorData_ = {};

        /** @private {!Array<AggRoom>} */
        this.aggregatorRooms_ = [];

        /** @private {!Object} */
        this.configs_ = _config2.default.initConfigs(optionalConfigs);
    }

    /**
     * Get a configuration value.
     * @param {string} name Configuration name.
     * @return {*} Configuration value.
     */


    _createClass(AggHouse, [{
        key: 'getConfig',
        value: function getConfig(name) {
            return this.configs_[name];
        }

        /**
         * Get data of an aggregator.
         * @param {string} aggregatorName Name of aggregator name to get data from.
         * @return {!Object} Aggregator data.
         * @throws {AggHouseInvalidArgumentError} Throw an error if an aggregator of
         * give name has not been loaded.
         */

    }, {
        key: 'getData',
        value: function getData(aggregatorName) {
            if (this.aggregatorRooms_.findIndex(function (ar) {
                return ar.name === aggregatorName;
            }) < 0) {
                throw new _error.AggHouseInvalidArgumentError('\'' + aggregatorName + '\' is not loaded!');
            }
            return Object.assign({}, this.aggregatorData_[aggregatorName]);
        }

        /**
         * Get a list of names and versions of loaded aggregators.
         * @return {!Array<Object>}
         */

    }, {
        key: 'getLoadedAggregators',
        value: function getLoadedAggregators() {
            return this.aggregatorRooms_.map(function (ar) {
                return {
                    'name': ar.name,
                    'version': ar.version
                };
            });
        }

        /**
         * Create an AggRoom for an aggregator add it to control list.
         * @param {!Aggregator} aggregator Aggregator to load.
         * @throws {AggHouseInvalidArgumentError} Throw an error if an aggregator of
         * the same name is already loaded.
         */

    }, {
        key: 'loadAggregator',
        value: function loadAggregator(aggregator) {
            var aggRoom = new _aggRoom2.default(aggregator, this);
            var aggName = aggRoom.name;

            if (this.aggregatorData_[aggRoom.name] !== undefined) {
                throw new _error.AggHouseInvalidArgumentError('\'' + aggName + '\' already loaded!');
            }

            this.aggregatorData_[aggName] = {};
            this.aggregatorRooms_.push(aggRoom);
        }

        /**
         * Process incoming update and deliver them to corresponding aggregators.
         * @param {!Object} update Update data.
         * @param {number} classId Class ID for data.
         */

    }, {
        key: 'processUpdate',
        value: function processUpdate(update, classId) {
            var matchedArCounts = 0;
            this.aggregatorRooms_.forEach(function (ar) {
                if (ar.containsClass(classId)) {
                    ar.sendUpdate(update);
                    matchedArCounts++;
                }
            });
            console.info('Sent update to ' + matchedArCounts + ' aggregator(s).');
        }

        /**
         * Unload an aggregator and dispose its AggRoom.
         * @param {!Aggregator|string} aggregator The aggregator to unload.
         */

    }, {
        key: 'unloadAggregator',
        value: function unloadAggregator(aggregator) {
            var aggName = typeof aggregator === 'string' ? aggName : aggName.name;
            var aggRoomIndex = this.aggregatorRooms_.findIndex(function (ar) {
                return ar.name === aggName;
            });
            if (aggRoomIndex >= 0) {
                this.aggregatorRooms_[aggRoomIndex].dispose();
                this.aggregatorRooms_.slice(aggRoomIndex, 1);
                delete this.aggregatorData_[aggName];
            } else {
                throw new _error.AggHouseInvalidArgumentError('\'' + aggName + '\' not found!');
            }
        }

        /**
         * Update data produced by an aggregator.
         * @param {string} aggregatorName Name of aggregator name to get data from.
         * @param {string} newData New data from aggregator.
         * @param {boolean|null} isAppending If is appending to or replacing
         * original.
         * @throws {AggHouseInvalidArgumentError} Throw an error if an aggregator of
         * give name has not been loaded.
         */

    }, {
        key: 'updateData',
        value: function updateData(aggregatorName, newData, isAppending) {
            if (this.aggregatorRooms_.findIndex(function (ar) {
                return ar.name === aggregatorName;
            }) < 0) {
                throw new _error.AggHouseInvalidArgumentError('\'' + aggregatorName + '\' is not loaded!');
            }
            if (isAppending) {
                this.aggregatorData_[aggregatorName] = (0, _deepmerge2.default)(this.aggregatorData_[aggregatorName], newData);
            } else {
                this.aggregatorData_[aggregatorName] = newData;
            }
        }
    }]);

    return AggHouse;
}();

exports.default = AggHouse;

},{"./core/agg-room":3,"./core/config":4,"./types/error":6,"deepmerge":1}],3:[function(require,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /** @module core/agg-room */


var _error = require('../types/error');

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/** Class that controls one aggregator. */
var AggRoom = function () {
    /**
     * Initialize an AggRoom.
     * @param {!Aggregator} aggregator The aggregator to manage.
     * @param {!AggHouse} aggHouse The AggHouse instance.
     */
    function AggRoom(aggregator, aggHouse) {
        var _this = this;

        _classCallCheck(this, AggRoom);

        /** @private {!AggHouse} */
        this.aggHouse_ = aggHouse;

        /** @private {!Array<Class>} */
        this.classIds_ = aggregator.classes;

        /** @private {boolean} */
        this.isDisposed_ = false;

        /** @private {string} */
        this.name_ = aggregator.name;

        /** @private {string} */
        this.version_ = aggregator.version;

        /** @private {Worker} */
        this.worker_ = null;

        if (this.aggHouse_.getConfig('serverMode')) {
            throw new _error.AggHouseUnavailableError('To be implemented.');
            // TODO(zacy1): Implement server mode behavior.
        } else {
            var workerURL = URL.createObjectURL(new Blob(['(', aggregator.worker.toString(), ')()'], { type: 'application/javascript' }));
            this.worker_ = new Worker(workerURL);
            URL.revokeObjectURL(workerURL);
        }

        this.worker_.onmessage = function (e) {
            return _this.saveData_(e);
        };
    }

    /**
     * Get aggregator name.
     * @return {string} Name of the aggregator this AggRoom manages.
     */


    _createClass(AggRoom, [{
        key: 'saveData_',


        /**
         * Save data sent by the aggregator.
         * @param {Event} e Event sent by aggregator.
         * @private
         */
        value: function saveData_(e) {
            var data = JSON.parse(e.data[0]);
            var isAppending = e.data[1];
            this.aggHouse_.updateData(this.name, data, isAppending);
        }

        /**
         * Check if the aggregator is responsible for some class.
         * @param {number} classId ID of class to check.
         * @return {boolean} Responsible or not.
         */

    }, {
        key: 'containsClass',
        value: function containsClass(classId) {
            return this.classIds_.includes(0) || this.classIds_.includes(classId);
        }

        /**
         * Send updated input to aggregator.
         * @param {Object} input Input data.
         */

    }, {
        key: 'sendUpdate',
        value: function sendUpdate(input) {
            if (this.isDisposed_) {
                throw new _error.AggHouseRoomError('AggRoom ' + this.toString() + ' has been disposed.');
            }
            this.worker_.postMessage(input);
        }

        /**
         * Dispose worker.
         */

    }, {
        key: 'dispose',
        value: function dispose() {
            this.worker_.terminate();
            this.isDisposed_ = true;
        }

        /**
         * Get AggHouse info string.
         * @return {string} AggHouse info string.
         * @override
         */

    }, {
        key: 'toString',
        value: function toString() {
            return this.name + '(version ' + this.version + ')';
        }
    }, {
        key: 'name',
        get: function get() {
            return this.name_;
        }

        /**
         * Get aggregator version.
         * @return {string} version string of the aggregator this AggRoom manages.
         */

    }, {
        key: 'version',
        get: function get() {
            return this.version_;
        }
    }]);

    return AggRoom;
}();

exports.default = AggRoom;

},{"../types/error":6}],4:[function(require,module,exports){
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
/** @module core/config */

var defaultConfigs = {
    serverMode: false
};

/**
 * Initialize and return configurations for AggHouse.
 * @param {Object} optionalConfigs Optional configurations.
 * @return {Object} Initialized configurations.
 */
function initConfigs(optionalConfigs) {
    return Object.assign({}, defaultConfigs, optionalConfigs);
}

exports.default = { initConfigs: initConfigs };

},{}],5:[function(require,module,exports){
(function (global){
'use strict';

var _aggHouse = require('./agg-house');

var _aggHouse2 = _interopRequireDefault(_aggHouse);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

(global || window).AggHouse = _aggHouse2.default; /* eslint-env node */

}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})

},{"./agg-house":2}],6:[function(require,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/** @module types/error */

/** Class containing AggHouse error info. */
var AggHouseError = exports.AggHouseError = function () {
    /**
     * Initialize an error.
     * @param {string} message Error message.
     * @param {boolean} isRecoverable If the error can be recovered.
     */
    function AggHouseError(message, isRecoverable) {
        _classCallCheck(this, AggHouseError);

        this.message_ = message;
        this.isRecoverable_ = isRecoverable;
    }

    /**
     * Get error name.
     * @return {string} Error name.
     */


    _createClass(AggHouseError, [{
        key: 'toString',


        /**
         * Get error string.
         * @return {string} Error string.
         * @override
         */
        value: function toString() {
            return (this.recoverable ? '[ ' : '[Fatal][') + this.name + '] ' + this.message;
        }
    }, {
        key: 'name',
        get: function get() {
            return 'AggHouseError';
        }

        /**
         * Get error message.
         * @return {string} Error message.
         */

    }, {
        key: 'message',
        get: function get() {
            return this.message_;
        }

        /**
         * Get if error is recoverable.
         * @return {boolean} Error recoverbility.
         */

    }, {
        key: 'recoverable',
        get: function get() {
            return this.isRecoverable_;
        }
    }]);

    return AggHouseError;
}();

/**
 * Class containing error info triggered by invalid arguments.
 * @extends AggHouseError
 */


var AggHouseInvalidArgumentError = exports.AggHouseInvalidArgumentError = function (_AggHouseError) {
    _inherits(AggHouseInvalidArgumentError, _AggHouseError);

    /**
     * Initialize an error.
     * @param {string} message Error message.
     */
    function AggHouseInvalidArgumentError(message) {
        _classCallCheck(this, AggHouseInvalidArgumentError);

        return _possibleConstructorReturn(this, (AggHouseInvalidArgumentError.__proto__ || Object.getPrototypeOf(AggHouseInvalidArgumentError)).call(this, message, true));
    }

    /**
     * Get error message.
     * @return {string} Error message.
     * @override
     */


    _createClass(AggHouseInvalidArgumentError, [{
        key: 'name',
        get: function get() {
            return 'AggHouseInvalidArgumentError';
        }
    }]);

    return AggHouseInvalidArgumentError;
}(AggHouseError);

/**
 * Class containing error info triggered by room error.
 * @extends AggHouseError
 */


var AggHouseRoomError = exports.AggHouseRoomError = function (_AggHouseError2) {
    _inherits(AggHouseRoomError, _AggHouseError2);

    /**
     * Initialize an error.
     * @param {string} message Error message.
     */
    function AggHouseRoomError(message) {
        _classCallCheck(this, AggHouseRoomError);

        return _possibleConstructorReturn(this, (AggHouseRoomError.__proto__ || Object.getPrototypeOf(AggHouseRoomError)).call(this, message, true));
    }

    /**
     * Get error message.
     * @return {string} Error message.
     * @override
     */


    _createClass(AggHouseRoomError, [{
        key: 'name',
        get: function get() {
            return 'AggHouseRoomError';
        }
    }]);

    return AggHouseRoomError;
}(AggHouseError);

/**
 * Class containing error info of unavailable operations.
 * @extends AggHouseError
 */


var AggHouseUnavailableError = exports.AggHouseUnavailableError = function (_AggHouseError3) {
    _inherits(AggHouseUnavailableError, _AggHouseError3);

    /**
     * Initialize an error.
     * @param {string} message Error message.
     */
    function AggHouseUnavailableError(message) {
        _classCallCheck(this, AggHouseUnavailableError);

        return _possibleConstructorReturn(this, (AggHouseUnavailableError.__proto__ || Object.getPrototypeOf(AggHouseUnavailableError)).call(this, message, false));
    }

    /**
     * Get error message.
     * @return {string} Error message.
     * @override
     */


    _createClass(AggHouseUnavailableError, [{
        key: 'name',
        get: function get() {
            return 'AggHouseUnavailableError';
        }
    }]);

    return AggHouseUnavailableError;
}(AggHouseError);

},{}]},{},[2,3,4,5,6])
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
