/*
 * Decompiled with CFR 0.152.
 */
package pact.CommWidgets.InputMethodFramework;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import pact.CommWidgets.InputMethodFramework.MouseFocusListener;

public class LWTextComponent
extends Component
implements KeyListener,
FocusListener {
    private transient boolean haveFocus;
    private String name;
    private StringBuffer committedText = new StringBuffer();
    private transient TextLayout textLayout = null;
    private transient boolean validTextLayout = false;
    private static final int LINE_OFFSET = 8;
    private int textOriginX;
    private int nameOriginY;
    private int textOriginY;

    public LWTextComponent(String name, boolean enableInputMethods) {
        this.name = name;
        this.setSize(300, 80);
        this.setForeground(Color.black);
        this.setBackground(Color.white);
        this.setFontSize(12);
        this.setVisible(true);
        this.setEnabled(true);
        this.addKeyListener(this);
        this.addFocusListener(this);
        this.addMouseListener(new MouseFocusListener(this));
        this.enableInputMethods(enableInputMethods);
    }

    public LWTextComponent(int height, int width, boolean enableInputMethods) {
        this.name = "";
        this.setSize(height, width);
        this.setForeground(Color.black);
        this.setBackground(Color.white);
        this.setFontSize(12);
        this.setVisible(true);
        this.setEnabled(true);
        this.addKeyListener(this);
        this.addFocusListener(this);
        this.addMouseListener(new MouseFocusListener(this));
        this.enableInputMethods(enableInputMethods);
    }

    public void setFontSize(int size) {
        this.setFont(new Font("Dialog", 0, size));
        this.nameOriginY = 8 + size;
        this.textOriginX = 10;
        this.textOriginY = 2 * (8 + size);
    }

    @Override
    public synchronized void paint(Graphics g) {
        g.setColor(this.getBackground());
        Dimension size = this.getSize();
        g.fillRect(0, 0, size.width, size.height);
        g.setColor(Color.black);
        g.drawRect(0, 0, size.width - 1, size.height - 1);
        if (this.haveFocus) {
            g.drawRect(1, 1, size.width - 3, size.height - 3);
        }
        g.setColor(this.getForeground());
        g.drawString(this.name, this.textOriginX, this.nameOriginY);
        TextLayout textLayout = this.getTextLayout();
        if (textLayout != null) {
            textLayout.draw((Graphics2D)g, this.textOriginX, this.textOriginY);
        }
        Rectangle rectangle = this.getCaretRectangle();
        if (this.haveFocus && rectangle != null) {
            g.setXORMode(this.getBackground());
            g.fillRect(rectangle.x, rectangle.y, 1, rectangle.height);
            g.setPaintMode();
        }
    }

    public AttributedCharacterIterator getCommittedText() {
        AttributedString string = new AttributedString(this.committedText.toString());
        return string.getIterator();
    }

    public AttributedCharacterIterator getCommittedText(int beginIndex, int endIndex) {
        AttributedString string = new AttributedString(this.committedText.toString());
        return string.getIterator(null, beginIndex, endIndex);
    }

    public int getCommittedTextLength() {
        return this.committedText.length();
    }

    public AttributedCharacterIterator getDisplayText() {
        AttributedString string = new AttributedString(this.committedText.toString());
        if (this.committedText.length() > 0) {
            string.addAttribute(TextAttribute.FONT, this.getFont());
        }
        return string.getIterator();
    }

    public synchronized TextLayout getTextLayout() {
        if (!this.validTextLayout) {
            this.textLayout = null;
            AttributedCharacterIterator text = this.getDisplayText();
            if (text.getEndIndex() > text.getBeginIndex()) {
                FontRenderContext context = ((Graphics2D)this.getGraphics()).getFontRenderContext();
                this.textLayout = new TextLayout(text, context);
            }
        }
        this.validTextLayout = true;
        return this.textLayout;
    }

    public synchronized void invalidateTextLayout() {
        this.validTextLayout = false;
    }

    public Point getTextOrigin() {
        return new Point(this.textOriginX, this.textOriginY);
    }

    public Rectangle getCaretRectangle() {
        TextHitInfo caret = this.getCaret();
        if (caret == null) {
            return null;
        }
        return this.getCaretRectangle(caret);
    }

    public Rectangle getCaretRectangle(TextHitInfo caret) {
        TextLayout textLayout = this.getTextLayout();
        int caretLocation = textLayout != null ? Math.round(textLayout.getCaretInfo(caret)[0]) : 0;
        FontMetrics metrics = this.getGraphics().getFontMetrics();
        return new Rectangle(this.textOriginX + caretLocation, this.textOriginY - metrics.getAscent(), 0, metrics.getAscent() + metrics.getDescent());
    }

    public TextHitInfo getCaret() {
        return TextHitInfo.trailing(this.committedText.length() - 1);
    }

    public void insertCharacter(char c) {
        this.committedText.append(c);
        this.invalidateTextLayout();
    }

    @Override
    public void keyTyped(KeyEvent event) {
        char keyChar = event.getKeyChar();
        if (keyChar == '\b') {
            int len = this.committedText.length();
            if (len > 0) {
                this.committedText.setLength(len - 1);
                this.invalidateTextLayout();
            }
        } else {
            this.insertCharacter(keyChar);
        }
        event.consume();
        this.repaint();
    }

    @Override
    public void keyPressed(KeyEvent event) {
    }

    @Override
    public void keyReleased(KeyEvent event) {
    }

    @Override
    public void focusGained(FocusEvent event) {
        this.haveFocus = true;
        this.repaint();
    }

    @Override
    public void focusLost(FocusEvent event) {
        this.haveFocus = false;
        this.repaint();
    }
}

