/*
 * Decompiled with CFR 0.152.
 */
package org.tiling.scheduling.examples;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.tiling.scheduling.Scheduler;
import org.tiling.scheduling.SchedulerTask;
import org.tiling.scheduling.examples.iterators.DailyIterator;

public class AlarmClock {
    private final Scheduler scheduler = new Scheduler();
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("dd MMM yyyy HH:mm:ss.SSS");
    private final int hourOfDay;
    private final int minute;
    private final int second;

    public AlarmClock(int hourOfDay, int minute, int second) {
        this.hourOfDay = hourOfDay;
        this.minute = minute;
        this.second = second;
    }

    public void start() {
        this.scheduler.schedule(new SchedulerTask(){

            @Override
            public void run() {
                this.soundAlarm();
            }

            private void soundAlarm() {
                System.out.println("Wake up! It's " + AlarmClock.this.dateFormat.format(new Date()));
            }
        }, new DailyIterator(this.hourOfDay, this.minute, this.second));
    }

    public static void main(String[] args) {
        AlarmClock alarmClock = new AlarmClock(7, 0, 0);
        alarmClock.start();
    }
}

