/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss;

import edu.cmu.pact.miss.HashMap;
import edu.cmu.pact.miss.WmePath;
import edu.cmu.pact.miss.WmePathNode;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.rmi.server.UID;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import java.util.regex.Pattern;
import jess.Deftemplate;
import jess.Fact;
import jess.Jesp;
import jess.JessException;
import jess.Rete;
import jess.Value;
import jess.ValueVector;

public class AmlRete
extends Rete
implements Cloneable {
    Hashtable wmePath = null;
    HashMap wmeChildSlots = new HashMap();
    private Vector terminalWmeType = new Vector();
    private Vector systemWmeType = new Vector();
    private HashMap lookupWmeCache = new HashMap();

    private Hashtable getWmePath() {
        return this.wmePath;
    }

    private void setWmePath(Hashtable wmePath) {
        this.wmePath = wmePath;
    }

    void addWmePath(Fact fact, WmePath path, String parentSlotName) {
        try {
            String type = fact.getName();
            String name = fact.getSlotValue("name").toString();
            String key = type + "|" + name;
            Vector<WmePath> v = (Vector<WmePath>)this.wmePath.get(key);
            if (v == null) {
                v = new Vector<WmePath>();
                this.wmePath.put(key, v);
            }
            v.add(path);
        }
        catch (JessException e) {
            e.printStackTrace();
        }
    }

    public Vector getWmePath(String wmeType, String wmeName) {
        if (this.wmePath == null) {
            this.initializeWmePath();
        }
        String wmeKey = wmeType + "|" + wmeName;
        return (Vector)this.wmePath.get(wmeKey);
    }

    Vector getWmeChildSlots(String wmeType) throws Exception {
        Vector childSlots = (Vector)this.wmeChildSlots.get(wmeType);
        return childSlots;
    }

    private Vector getTerminalWmeType() {
        return this.terminalWmeType;
    }

    private Vector getSystemWmeType() {
        return this.systemWmeType;
    }

    public String wmeType(String name) {
        Iterator facts = this.listFacts();
        while (facts.hasNext()) {
            Fact fact = (Fact)facts.next();
            try {
                if (!this.hasSlot(fact, "name") || !fact.getSlotValue("name").equals((Object)name)) continue;
                return fact.getName();
            }
            catch (JessException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private boolean hasSlot(Fact fact, String name) {
        boolean result = false;
        Deftemplate template = fact.getDeftemplate();
        String[] slotNames = template.getSlotNames();
        for (int i = 0; i < slotNames.length; ++i) {
            if (!slotNames[i].equals(name)) continue;
            result = true;
            break;
        }
        return result;
    }

    public Fact lookupWme(String type, String name) {
        String lookupKey = type + name;
        Fact fact = null;
        if (this.lookupWmeCacheContains(lookupKey)) {
            fact = this.getLookupWmeCache(lookupKey);
        } else {
            Iterator facts = this.listFacts();
            while (facts.hasNext()) {
                fact = (Fact)facts.next();
                try {
                    if (!fact.getName().equals(type) || !fact.getSlotValue("name").equals((Object)name)) continue;
                    break;
                }
                catch (JessException e) {
                    e.printStackTrace();
                }
            }
            this.putLookupWmeCache(lookupKey, fact);
        }
        return fact;
    }

    private boolean lookupWmeCacheContains(String key) {
        return this.lookupWmeCache.containsKey(key);
    }

    private Fact getLookupWmeCache(String key) {
        return (Fact)this.lookupWmeCache.get(key);
    }

    private void putLookupWmeCache(String key, Fact fact) {
        this.lookupWmeCache.put(key, fact);
    }

    public Fact lookupProblemWme() {
        Iterator facts = this.listFacts();
        while (facts.hasNext()) {
            Fact fact = (Fact)facts.next();
            if (!fact.getName().equals("MAIN::problem")) continue;
            return fact;
        }
        return null;
    }

    public Value lookupWmeValue(String wmeType, String wmeName) {
        Vector<String> constraint = new Vector<String>();
        constraint.add("name");
        constraint.add(wmeName);
        return this.lookupWmeValue(wmeType, "value", constraint);
    }

    public Value lookupWmeValue(String type, String slot, Vector constraint) {
        Value value = null;
        Iterator slotVals = constraint.iterator();
        Iterator facts = this.listFacts();
        while (facts.hasNext()) {
            Fact fact = (Fact)facts.next();
            String wmeType = null;
            try {
                wmeType = fact.getName();
                if (!wmeType.equals(type) || !this.constHold(fact, constraint)) continue;
                value = fact.getSlotValue(slot);
                break;
            }
            catch (JessException e) {
                e.printStackTrace();
            }
        }
        return value;
    }

    private boolean constHold(Fact fact, Vector constraint) {
        boolean result = true;
        Iterator slotValues = constraint.iterator();
        while (slotValues.hasNext()) {
            String slotName = (String)slotValues.next();
            String slotValue = (String)slotValues.next();
            try {
                if (fact.getSlotValue(slotName).equals((Object)slotValue)) continue;
                result = false;
                break;
            }
            catch (JessException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private void initializeWmePath() {
        this.setWmePath(new Hashtable());
        Value problem = new Value((Object)this.lookupProblemWme());
        this.searchWmePath(problem, new WmePath(this), null);
    }

    private void searchWmePath(Value wme, WmePath path, String parentSlotName) {
        if (wme.type() == 512) {
            try {
                ValueVector listValue = wme.listValue(this.getGlobalContext());
                for (int i = 0; i < listValue.size(); ++i) {
                    this.searchWmePath(listValue.get(i), (WmePath)path.clone(), parentSlotName);
                }
            }
            catch (JessException e) {
                e.printStackTrace();
            }
        } else if (this.isNotSystemWme(wme)) {
            try {
                Fact wmeFact = wme.factValue(this.getGlobalContext());
                path.add(wmeFact, parentSlotName);
                this.addWmePath(wmeFact, (WmePath)path.clone(), parentSlotName);
                Vector children = this.getWmeChildSlots(wmeFact.getName());
                if (children != null) {
                    Iterator iterator = children.iterator();
                    while (iterator.hasNext()) {
                        String child;
                        String childSlotName = child = (String)iterator.next();
                        this.searchWmePath(wmeFact.getSlotValue(childSlotName), path, childSlotName);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private boolean isNotSystemWme(Value wme) {
        boolean test = true;
        Fact fact = null;
        try {
            fact = wme.factValue(this.getGlobalContext());
        }
        catch (JessException e) {
            e.printStackTrace();
        }
        int index = this.getSystemWmeType().indexOf(fact.getName());
        if (index != -1) {
            test = false;
        }
        return test;
    }

    private boolean isTerminalWme(Value wme) {
        boolean test = false;
        if (wme.type() == 16) {
            Fact fact = null;
            try {
                fact = wme.factValue(this.getGlobalContext());
            }
            catch (JessException e) {
                e.printStackTrace();
            }
            if (this.isTerminalWmeType(fact.getName())) {
                test = true;
            }
        }
        return test;
    }

    boolean isTerminalWmeType(String type) {
        int index = this.getTerminalWmeType().indexOf(type);
        return index != -1;
    }

    public WmePath lookupWmePath(Fact fact) {
        WmePath targetPath = null;
        Enumeration vectors = this.getWmePath().elements();
        block0: while (vectors.hasMoreElements()) {
            Vector v = (Vector)vectors.nextElement();
            Enumeration paths = v.elements();
            while (paths.hasMoreElements()) {
                WmePath wmePath = (WmePath)paths.nextElement();
                if (!wmePath.hasNode(fact)) continue;
                targetPath = wmePath;
                continue block0;
            }
        }
        return targetPath;
    }

    public void readFile(String fileName) {
        fileName = "\"" + fileName + "\"";
        try {
            Value value = this.executeCommand("(batch " + fileName + ")");
        }
        catch (JessException e) {
            e.printStackTrace();
        }
    }

    public Object clone() {
        AmlRete amlRete = null;
        try {
            amlRete = (AmlRete)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.bsave(baos);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        byte[] byteArray = baos.toByteArray();
        ByteArrayInputStream bais = new ByteArrayInputStream(byteArray);
        try {
            amlRete.bload(bais);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return amlRete;
    }

    public Value parse(Reader rdr, boolean removeBuggyRules) throws JessException {
        UID uid = new UID();
        if (!(rdr instanceof BufferedReader) && !(rdr instanceof StringReader)) {
            rdr = new BufferedReader(rdr);
        }
        Jesp jesp = new Jesp(rdr, (Rete)this);
        Value result = jesp.parse(false, this.getGlobalContext());
        return result;
    }

    public boolean loadWMEStructureFromReader(BufferedReader reader) {
        String curLine;
        Vector<String> sensSlots = new Vector<String>();
        boolean loadStructure = true;
        boolean loadTerminals = false;
        boolean loadIgnore = false;
        Pattern whitespace = Pattern.compile("\\s+");
        do {
            try {
                curLine = reader.readLine();
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
            if (curLine == null) break;
            if (curLine.startsWith(";;") || whitespace.matcher(curLine).matches() || curLine.equals("")) continue;
            if ((curLine = curLine.trim()).startsWith("-")) {
                if (loadStructure) {
                    loadStructure = false;
                    loadTerminals = true;
                    continue;
                }
                if (!loadTerminals) continue;
                loadTerminals = false;
                loadIgnore = true;
                continue;
            }
            if (loadStructure) {
                String[] tmp;
                String[] contents = whitespace.split(curLine);
                String parent = contents[0];
                Vector children = new Vector();
                if (contents[1].contains(",")) {
                    tmp = contents[1].split(",");
                    Collections.addAll(children, tmp);
                } else {
                    children.add(contents[1]);
                }
                if (contents[1].contains(",")) {
                    tmp = contents[1].split(",");
                    Collections.addAll(sensSlots, tmp);
                } else {
                    sensSlots.add(contents[1]);
                }
                this.wmeChildSlots.put(parent, children);
                for (int childnum = 2; childnum < contents.length; ++childnum) {
                    String child = contents[childnum];
                    children = (Vector)this.wmeChildSlots.get(parent);
                    children.add(child);
                    sensSlots.add(child);
                }
            }
            if (loadTerminals) {
                this.terminalWmeType.add(curLine);
            }
            if (!loadIgnore) continue;
            this.systemWmeType.add(curLine);
        } while (curLine != null);
        WmePathNode.setSensitiveSlots(sensSlots.toArray(new String[1]));
        return true;
    }

    public boolean loadWMEStructureFromFile(String structureFilePath) {
        String curLine;
        BufferedReader reader;
        File file = new File(structureFilePath);
        try {
            reader = new BufferedReader(new FileReader(file));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        Vector<String> sensSlots = new Vector<String>();
        boolean loadStructure = true;
        boolean loadTerminals = false;
        boolean loadIgnore = false;
        Pattern whitespace = Pattern.compile("\\s+");
        do {
            try {
                curLine = reader.readLine();
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
            if (curLine == null) break;
            if (curLine.startsWith(";;") || whitespace.matcher(curLine).matches() || curLine.equals("")) continue;
            if ((curLine = curLine.trim()).startsWith("-")) {
                if (loadStructure) {
                    loadStructure = false;
                    loadTerminals = true;
                    continue;
                }
                if (!loadTerminals) continue;
                loadTerminals = false;
                loadIgnore = true;
                continue;
            }
            if (loadStructure) {
                String[] contents = whitespace.split(curLine);
                String parent = contents[0];
                Vector children = new Vector();
                children.add(contents[1]);
                sensSlots.add(contents[1]);
                this.wmeChildSlots.put(parent, children);
                for (int childnum = 2; childnum < contents.length; ++childnum) {
                    String child = contents[childnum];
                    children = (Vector)this.wmeChildSlots.get(parent);
                    children.add(child);
                    sensSlots.add(child);
                }
            }
            if (loadTerminals) {
                this.terminalWmeType.add(curLine);
            }
            if (!loadIgnore) continue;
            this.systemWmeType.add(curLine);
        } while (curLine != null);
        WmePathNode.setSensitiveSlots(sensSlots.toArray(new String[1]));
        return true;
    }

    public static void main(String[] args) {
        AmlRete amlRete = new AmlRete();
    }
}

