/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.jess;

import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.Matcher;
import edu.cmu.pact.Utilities.EventLogger;
import edu.cmu.pact.Utilities.TextOutput;
import edu.cmu.pact.Utilities.VersionInformation;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.jess.JessOracleRete;
import edu.cmu.pact.jess.MTRete;
import edu.cmu.pact.jess.SimStRete;
import edu.cmu.pact.jess.SimStRuleActivationNode;
import edu.cmu.pact.jess.Utils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import jess.Activation;
import jess.ActivationData;
import jess.Context;
import jess.Fact;
import jess.HasLHS;
import jess.JessException;
import jess.Rete;
import jess.Value;
import jess.ValueVector;

public class RuleActivationNode
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = 7915549455481477714L;
    private static long nodeIdGenerator = 0L;
    private byte[] reteState = null;
    private TextOutput errorOutput;
    private final String nodeId;
    private Matcher matcher = null;
    private boolean redoHtmlText = false;
    private String htmlText = "";
    private final int searchDepth;
    private int agendaIndex = -2;
    private ActivationData actData = null;
    private Activation activation;
    private final String ruleName;
    private final String displayName;
    private final boolean chainNode;
    private Vector hintMessages = new Vector();
    private Vector clHintMessages = new Vector();
    private Vector successMessages = new Vector();
    private Vector buggyMessages = new Vector();
    private String actualSelection = "NotSpecified";
    private String actualAction = "NotSpecified";
    private String actualInput = "NotSpecified";
    private String actualInputTestFunction = "NotSpecified";
    private String reqSelection = "NotSpecified";
    private String reqAction = "NotSpecified";
    private String reqInput = "NotSpecified";
    private Vector foas = null;
    private MTRete.Routers routers;
    public static final int SELECTION_FAILED = 5;
    public static final int RESULT_UNSET = 4;
    public static final int NOT_SPEC = 3;
    public static final int NO_MATCH = 2;
    public static final int MATCH = 1;
    public static final int ANY_MATCH = 0;
    private static final String[] matchStrings = new String[]{"ANY_MATCH", "MATCH", "NO_MATCH", "NOT_SPEC", "UNSET", "SELECTION_FAILED"};
    static final String CHAIN = "Chain";
    private int matchResult = 4;
    private boolean ruleSAIHasBeenSet = false;
    private String inputFunction = null;
    private int inputFunctionResult = 3;

    public int getAgendaIndex() {
        return this.agendaIndex;
    }

    public void setAgendaIndex(int index) {
        this.agendaIndex = index;
    }

    public void addRuleFoa(String foa) {
        if (this.foas == null) {
            this.foas = new Vector();
        }
        this.foas.add(foa);
    }

    public Vector getRuleFoas() {
        return this.foas;
    }

    public static RuleActivationNode create(Activation act, int depth) {
        return RuleActivationNode.create(act == null ? -1 : 0, act, depth, null);
    }

    static RuleActivationNode create(int agendaIndex, Activation act, int searchDepth, RuleActivationNode parent) {
        if (VersionInformation.isRunningSimSt() && !edu.cmu.pact.Utilities.Utils.isRuntime()) {
            return new SimStRuleActivationNode(act == null ? -1 : 0, act, searchDepth, parent);
        }
        return new RuleActivationNode(act == null ? -1 : 0, act, searchDepth, parent);
    }

    RuleActivationNode(int agendaIndex, Activation act, int searchDepth, RuleActivationNode parent) {
        this.agendaIndex = agendaIndex;
        this.activation = act;
        if (act != null) {
            try {
                this.actData = new ActivationData(act);
                if (trace.getDebugCode("mt")) {
                    trace.out("mt", "new RuleActivationNode[" + agendaIndex + "]: " + this.actData);
                }
            }
            catch (JessException je) {
                trace.err("error getting activation data from act[" + agendaIndex + "]=" + act + ": " + (Object)((Object)je));
            }
            this.chainNode = false;
            this.ruleName = act.getRule().getName();
            this.displayName = act.getRule().getDisplayName();
            this.errorOutput = TextOutput.getTextOutput(new StringWriter());
        } else {
            this.chainNode = true;
            this.displayName = CHAIN;
            this.ruleName = CHAIN;
            this.errorOutput = TextOutput.getNullOutput();
        }
        if (this.displayName.indexOf(38) >= 0) {
            Exception e = new Exception("ERROR: rule display name has \"&\": ruleName " + this.ruleName + ", displayName " + this.displayName);
            e.printStackTrace();
        }
        this.nodeId = this.ruleName + "_" + ++nodeIdGenerator;
        this.searchDepth = searchDepth;
        if (parent != null) {
            parent.insert(this, parent.getChildCount());
        }
    }

    public Activation getActivation() {
        return this.activation;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    String getNodeId() {
        return this.nodeId;
    }

    public String loadPriorState(MTRete rete) {
        try {
            if (this.isChainNode()) {
                this.loadState(rete);
            } else {
                ((RuleActivationNode)this.parent).loadState(rete);
            }
            return null;
        }
        catch (Exception e) {
            String errMsg = "Error loading prior engine state: " + e;
            trace.err("Node " + this.getNodeId() + ": " + errMsg);
            e.printStackTrace();
            return errMsg;
        }
    }

    public void setUpState(MTRete rete, int siblingIndex) throws Exception {
        if (!this.isChainNode()) {
            throw new UnsupportedOperationException("setUpState() called on on non-chain node " + this);
        }
        if (siblingIndex < 1) {
            return;
        }
        this.loadState(rete);
    }

    public void setUpStateOracle(JessOracleRete oracleRete, int siblingIndex) throws Exception {
        if (!this.isChainNode()) {
            throw new UnsupportedOperationException("setUpState() called on on non-chain node " + this);
        }
        if (siblingIndex < 1) {
            return;
        }
        this.loadStateOracle(oracleRete);
    }

    public boolean loadState(MTRete rete) throws IOException, ClassNotFoundException {
        if (this.reteState == null) {
            throw new IllegalStateException("load without prior save in node " + this);
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(this.reteState);
        rete.loadState(bais, this.routers);
        if (trace.getDebugCode("mt")) {
            trace.out("mt", "loaded state in node " + this.getNodeId());
        }
        return true;
    }

    public boolean loadStateOracle(JessOracleRete oracleRete) throws IOException, ClassNotFoundException {
        if (this.reteState == null) {
            throw new IllegalStateException("load without prior save in node " + this);
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(this.reteState);
        oracleRete.loadState(bais, this.routers);
        if (trace.getDebugCode("mt")) {
            trace.out("mt", "loaded state in node " + this.getNodeId());
        }
        return true;
    }

    MTRete getState() {
        if (this.reteState == null) {
            return null;
        }
        MTRete result = new MTRete();
        try {
            this.loadState(result);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
            return null;
        }
        return result;
    }

    public boolean saveState(MTRete rete) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.routers = rete.saveState(baos);
            this.reteState = baos.toByteArray();
            if (trace.getDebugCode("mt")) {
                trace.out("mt", "saved state in node " + this.getNodeId() + "; length=" + this.reteState.length);
            }
            return true;
        }
        catch (Exception e) {
            trace.err("saveState() error in node " + this + ": " + e);
            e.printStackTrace();
            return false;
        }
    }

    private String firstFewString(byte[] array) {
        String str = "";
        int num = Math.min(100, array.length);
        for (int i = 0; i < num; ++i) {
            str = str + array[i];
        }
        return str;
    }

    public void copyState(RuleActivationNode node) {
        this.reteState = node.reteState;
        this.routers = node.routers;
    }

    public String getName() {
        return this.ruleName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    TextOutput getErrorOutput() {
        return this.errorOutput;
    }

    void setErrorOutput(TextOutput errOutput) {
        this.errorOutput = errOutput;
    }

    public boolean isCorrectRule() {
        return MTRete.isCorrectRuleName(this.ruleName);
    }

    public int createChildren(List agenda, boolean omitBuggyRules) {
        this.children = new Vector();
        int j = 0;
        for (int i = 0; i < agenda.size(); ++i) {
            Activation act = (Activation)agenda.get(i);
            if (act == null || act.isInactive() || omitBuggyRules && !MTRete.isCorrectRule(act.getRule())) continue;
            RuleActivationNode ruleActivationNode = new RuleActivationNode(j++, act, this.searchDepth + 1, this);
        }
        return this.children.size();
    }

    public List getChildren() {
        return this.children;
    }

    int isStudentSAIFound(String selection, String action, String input, String actualInputTestFunction, boolean isHint, Context ctx) {
        this.setReqSelection(selection);
        this.setReqAction(action);
        this.setReqInput(input);
        return this.isSAIFound(selection, action, input, this.actualSelection, this.actualAction, this.actualInput, actualInputTestFunction, isHint, ctx);
    }

    public int isStudentSAIFound(String selection, String action, String input, boolean isHint, Context ctx) {
        return this.isStudentSAIFound(selection, action, input, "NotSpecified", isHint, ctx);
    }

    int isSAIFound(String selection, String action, String input, String predictedSelection, String predictedAction, String predictedInput, String predictedInputTestFunction, boolean isHint, Context ctx) {
        if (trace.getDebugCode("rr")) {
            trace.out("***isSAIFound() s " + selection + "=?" + predictedSelection + ", a " + action + "=?" + predictedAction + ", i " + input + "=?" + predictedInput + "," + predictedInputTestFunction + ";");
        }
        boolean S = true;
        int A = 2;
        int I = 4;
        int result = 0;
        int m = this.testSingleValue(predictedSelection, selection, "selection", "NotSpecified", isHint, ctx);
        if (m == 2) {
            if (isHint) {
                return predictedAction.equals("NotSpecified") || predictedInput.equals("NotSpecified") ? 5 : 2;
            }
            return 2;
        }
        if (m == 1) {
            if (isHint) {
                return predictedAction.equals("NotSpecified") || predictedInput.equals("NotSpecified") ? 3 : 1;
            }
            result |= 1;
        }
        if ((m = this.testSingleValue(predictedAction, action, "action", "NotSpecified", ctx)) == 2) {
            return 2;
        }
        if (m == 1) {
            result |= 2;
        }
        if ((m = this.testSingleValue(predictedInput, input, "input", predictedInputTestFunction, ctx)) == 2) {
            return 2;
        }
        if (m == 1) {
            result |= 4;
        }
        if ((result & 7) == 7) {
            return 1;
        }
        return 3;
    }

    int isSelectionFound(String studentSelection, String predictedSelection, Context ctx) {
        if (trace.getDebugCode("mt")) {
            trace.out("mt", "***isSelectionFound() s " + studentSelection + "=?" + predictedSelection);
        }
        return this.testSingleValue(predictedSelection, studentSelection, "selection", "NotSpecified", ctx);
    }

    private int testSingleValue(String rv, String sv, String label, String rf, Context ctx) {
        return this.testSingleValue(rv, sv, label, rf, false, ctx);
    }

    private int testSingleValue(String rv, String sv, String label, String rf, boolean emptyMatchesAll, Context ctx) {
        if (trace.getDebugCode("mt")) {
            trace.out("mt", "Jess testSingleValue " + rv + " " + sv);
        }
        int result = 2;
        String[] errorMessage = new String[1];
        if (rv.equals("NotSpecified")) {
            result = 3;
        } else if (rv.equals("DONT-CARE")) {
            result = 1;
        } else if (emptyMatchesAll && (sv == null || sv.length() < 1)) {
            result = 1;
        } else if (!"NotSpecified".equals(rf)) {
            this.inputFunction = rf;
            String rfCall = String.format("(%s %s %s)", rf, Utils.escapeString(rv, true), Utils.escapeString(sv, true));
            result = this.evalBooleanExpr(rfCall, ctx, errorMessage);
            this.inputFunctionResult = errorMessage[0] == null ? result : 3;
        } else {
            String cmpCall = String.format("(= %s %s)", Utils.escapeString(rv, true), Utils.escapeString(sv, true));
            result = this.evalBooleanExpr(cmpCall, ctx, errorMessage);
        }
        if (trace.getDebugCode("mt")) {
            trace.out("mt", "testSingleValue " + label + " returns " + RuleActivationNode.matchIntToString(result) + "(" + result + ")");
        }
        return result;
    }

    private int evalBooleanExpr(String cmd, Context ctx, String[] errorMessage) {
        int result;
        errorMessage[0] = null;
        try {
            Value v = ctx.getEngine().eval(cmd, ctx);
            if (v != null) {
                v = v.resolveValue(ctx);
            }
            if (trace.getDebugCode("mtt")) {
                trace.out("mtt", "after eval: " + cmd + " = " + v);
            }
            result = v != null && v.toString().equals("TRUE") ? 1 : 2;
        }
        catch (JessException je) {
            errorMessage[0] = "Error evaluating \"" + cmd + "\":" + (je.getDetail() == null ? "" : je.getDetail() + ". ") + (je.getData() == null ? "" : je.getData());
            trace.err(errorMessage[0]);
            if (ctx.getEngine() instanceof MTRete) {
                EventLogger eventLogger;
                MTRete mtRete = (MTRete)ctx.getEngine();
                TextOutput textOutput = mtRete.getTextOutput();
                if (textOutput != null) {
                    textOutput.append("\n" + errorMessage[0] + "\n");
                }
                if ((eventLogger = mtRete.getEventLogger()) != null) {
                    eventLogger.log(true, "JESS_CONSOLE", "RuleActivationNode.testSingleValue() function error", cmd, errorMessage[0], "");
                }
            }
            result = 2;
        }
        if (trace.getDebugCode("mt")) {
            trace.out("mt", "RAN.evalBooleanExpr(" + cmd + ") => " + RuleActivationNode.matchIntToString(result));
        }
        return result;
    }

    public int isStudentSelectionFound(String selection, Context ctx) {
        this.setReqSelection(selection);
        return this.isSelectionFound(selection, this.actualSelection, ctx);
    }

    public void setStudentSAI(String studentSelection, String studentAction, String studentInput) {
        this.setReqSelection(studentSelection);
        this.setReqAction(studentAction);
        this.setReqInput(studentInput);
    }

    public synchronized void setRuleSAI(String predictedSelection, String predictedAction, String predictedInput, String predictedInputTestFunction) {
        this.setRuleSAI(predictedSelection, predictedAction, predictedInput);
        this.setActualInputTestFunction(predictedInputTestFunction);
    }

    public synchronized void setRuleSAI(String predictedSelection, String predictedAction, String predictedInput) {
        if (trace.getDebugCode("mtt")) {
            trace.out("mtt", "RAN.setRuleSAI() ruleSAIHasBeenSet " + this.ruleSAIHasBeenSet);
        }
        if (this.ruleSAIHasBeenSet) {
            return;
        }
        this.setActualSelection(predictedSelection);
        this.setActualAction(predictedAction);
        this.setActualInput(predictedInput);
        this.ruleSAIHasBeenSet = true;
    }

    synchronized void setRuleSAI(MTRete rete) {
        if (this.ruleSAIHasBeenSet) {
            return;
        }
        this.setActualSelection("NotSpecified");
        this.setActualAction("NotSpecified");
        this.setActualInput("NotSpecified");
        this.ruleSAIHasBeenSet = true;
    }

    public int getMatchResult() {
        return this.matchResult;
    }

    void setMatchResult(int matchResult) {
        if (trace.getDebugCode("hints")) {
            trace.out("hints", "RAN.setMatchResult(" + RuleActivationNode.matchIntToString(matchResult) + "[" + matchResult + "])");
        }
        this.matchResult = matchResult;
    }

    public List fire(SimStRete ssRete) throws JessException {
        Activation act = null;
        HashSet priorActSet = new HashSet();
        List siblings = ((RuleActivationNode)this.getParent()).getChildren();
        ArrayList<Activation> newAgenda = new ArrayList<Activation>();
        ArrayList<Activation> debugAgenda = new ArrayList<Activation>();
        Iterator agenda = ssRete.listActivations();
        int ai = 0;
        while (agenda.hasNext()) {
            Activation priorAct = (Activation)agenda.next();
            debugAgenda.add(priorAct);
            if (priorAct.isInactive()) continue;
            if (this.actData.match(priorAct)) {
                act = priorAct;
            }
            RuleActivationNode sibling = ai < siblings.size() ? siblings.get(ai) : null;
            if (trace.getDebugCode("mt")) {
                trace.outNT("mt", "node.fire() at ai=" + ai + " agenda, sibling:\n" + priorAct.toString() + "\n" + (sibling == null ? "null sib" : sibling.getActivation().toString()));
            }
            ++ai;
        }
        if (ai <= this.agendaIndex) {
            throw new ArrayIndexOutOfBoundsException("agendaIndex (" + this.agendaIndex + ") beyond end of agenda (" + ai + "); ruleName " + this.ruleName);
        }
        if (act == null) {
            String errMsg = "RuleActivationNode not found on agenda: " + this;
            ssRete.dumpAgenda("err", errMsg, true);
            throw new IllegalStateException(errMsg);
        }
        if (act.isInactive()) {
            throw new IllegalStateException("activation inactive: ruleName " + this.ruleName);
        }
        try {
            ssRete.setActivationToFire(act);
            ssRete.dumpAgenda("node.fire(" + this.agendaIndex + "): agenda prior");
            int runResult = ssRete.run(1);
            ssRete.setActivationToFire(null);
            ssRete.dumpAgenda("node.fire() runResult " + runResult + ": agenda after");
            agenda = ssRete.listActivations();
            while (agenda.hasNext()) {
                Activation afterAct = (Activation)agenda.next();
                if (afterAct.isInactive() || priorActSet.contains(afterAct)) continue;
                newAgenda.add(afterAct);
            }
        }
        catch (JessException je) {
            trace.err("Exception running agenda[" + this.agendaIndex + "] " + this.ruleName + ": " + (Object)((Object)je));
            je.printStackTrace();
            je.printStackTrace(ssRete.getTextOutput().getWriter());
            je.printStackTrace(this.getErrorOutput().getWriter());
        }
        catch (RuntimeException re) {
            trace.err("Exception running agenda[" + this.agendaIndex + "] " + this.ruleName + ": " + re);
            re.printStackTrace();
            re.printStackTrace(this.getErrorOutput().getWriter());
            throw re;
        }
        return newAgenda;
    }

    public List fire(MTRete rete) throws JessException {
        Activation act = null;
        HashSet<Activation> priorActSet = new HashSet<Activation>();
        List siblings = ((RuleActivationNode)this.getParent()).getChildren();
        ArrayList<Activation> newAgenda = new ArrayList<Activation>();
        ArrayList<Activation> debugAgenda = new ArrayList<Activation>();
        Iterator agenda = rete.listActivations();
        int ai = 0;
        while (agenda.hasNext()) {
            Activation priorAct = (Activation)agenda.next();
            debugAgenda.add(priorAct);
            if (priorAct.isInactive()) continue;
            if (this.actData.match(priorAct)) {
                act = priorAct;
            }
            RuleActivationNode sibling = ai < siblings.size() ? siblings.get(ai) : null;
            if (trace.getDebugCode("mt")) {
                trace.outNT("mt", "node.fire() at ai=" + ai + " agenda, sibling:\n" + priorAct.toString() + "\n" + (sibling == null ? "null sib" : sibling.getActivation().toString()));
            }
            if (rete.getPrunePriorActivations()) {
                priorActSet.add(priorAct);
            }
            ++ai;
        }
        if (ai <= this.agendaIndex) {
            throw new ArrayIndexOutOfBoundsException("agendaIndex (" + this.agendaIndex + ") beyond end of agenda (" + ai + "); ruleName " + this.ruleName);
        }
        if (act == null) {
            String errMsg = "RuleActivationNode not found on agenda: " + this;
            rete.dumpAgenda("err", errMsg, true);
            throw new IllegalStateException(errMsg);
        }
        if (act.isInactive()) {
            throw new IllegalStateException("activation inactive: ruleName " + this.ruleName);
        }
        try {
            rete.setActivationToFire(act);
            rete.dumpAgenda("node.fire(" + this.agendaIndex + "): agenda prior");
            int runResult = rete.run(1);
            this.setRuleSAI(rete);
            rete.setActivationToFire(null);
            rete.dumpAgenda("node.fire() runResult " + runResult + ": agenda after");
            agenda = rete.listActivations();
            while (agenda.hasNext()) {
                Activation afterAct = (Activation)agenda.next();
                if (afterAct.isInactive() || priorActSet.contains(afterAct)) continue;
                newAgenda.add(afterAct);
            }
        }
        catch (JessException je) {
            trace.err("Exception running agenda[" + this.agendaIndex + "] " + this.ruleName + ": " + (Object)((Object)je));
            je.printStackTrace();
            je.printStackTrace(rete.getTextOutput().getWriter());
            je.printStackTrace(this.getErrorOutput().getWriter());
        }
        catch (RuntimeException re) {
            trace.err("Exception running agenda[" + this.agendaIndex + "] " + this.ruleName + ": " + re);
            re.printStackTrace();
            re.printStackTrace(this.getErrorOutput().getWriter());
            throw re;
        }
        return newAgenda;
    }

    public List fireOracle(JessOracleRete oracleRete) throws JessException {
        Activation act = null;
        HashSet<Activation> priorActSet = new HashSet<Activation>();
        if (this.getParent() == null) {
            return null;
        }
        List siblings = ((RuleActivationNode)this.getParent()).getChildren();
        ArrayList<Activation> newAgenda = new ArrayList<Activation>();
        ArrayList<Activation> debugAgenda = new ArrayList<Activation>();
        Iterator agenda = oracleRete.listActivations();
        int ai = 0;
        while (agenda.hasNext()) {
            Activation priorAct = (Activation)agenda.next();
            debugAgenda.add(priorAct);
            if (priorAct.isInactive()) continue;
            if (this.actData.match(priorAct)) {
                act = priorAct;
            }
            RuleActivationNode sibling = ai < siblings.size() ? siblings.get(ai) : null;
            if (trace.getDebugCode("mt")) {
                trace.outNT("mt", "node.fire() at ai=" + ai + " agenda, sibling:\n" + priorAct.toString() + "\n" + (sibling == null ? "null sib" : sibling.getActivation().toString()));
            }
            if (oracleRete.getPrunePriorActivations()) {
                priorActSet.add(priorAct);
            }
            ++ai;
        }
        if (ai <= this.agendaIndex) {
            throw new ArrayIndexOutOfBoundsException("agendaIndex (" + this.agendaIndex + ") beyond end of agenda (" + ai + "); ruleName " + this.ruleName);
        }
        if (act == null) {
            String errMsg = "RuleActivationNode not found on agenda: " + this;
            oracleRete.dumpAgenda("err", errMsg, true);
            throw new IllegalStateException(errMsg);
        }
        if (act.isInactive()) {
            throw new IllegalStateException("activation inactive: ruleName " + this.ruleName);
        }
        try {
            oracleRete.setActivationToFire(act);
            oracleRete.dumpAgenda("node.fire(" + this.agendaIndex + "): agenda prior");
            int runResult = oracleRete.run(1);
            this.setRuleSAI(oracleRete);
            oracleRete.setActivationToFire(null);
            oracleRete.dumpAgenda("node.fire() runResult " + runResult + ": agenda after");
            agenda = oracleRete.listActivations();
            while (agenda.hasNext()) {
                Activation afterAct = (Activation)agenda.next();
                if (afterAct.isInactive() || priorActSet.contains(afterAct)) continue;
                newAgenda.add(afterAct);
            }
        }
        catch (JessException je) {
            trace.err("Exception running agenda[" + this.agendaIndex + "] " + this.ruleName + ": " + (Object)((Object)je));
            je.printStackTrace();
            je.printStackTrace(oracleRete.getTextOutput().getWriter());
            je.printStackTrace(this.getErrorOutput().getWriter());
        }
        catch (RuntimeException re) {
            trace.err("Exception running agenda[" + this.agendaIndex + "] " + this.ruleName + ": " + re);
            re.printStackTrace();
            re.printStackTrace(this.getErrorOutput().getWriter());
            throw re;
        }
        return newAgenda;
    }

    void setSuccessMessages(ValueVector msgVV, Context ctx) throws JessException {
        if (this.successMessages == null) {
            this.successMessages = new Vector();
        }
        this.setMessages(this.successMessages, msgVV, ctx);
    }

    void setBuggyMessages(ValueVector msgVV, Context ctx) throws JessException {
        if (this.buggyMessages == null) {
            this.buggyMessages = new Vector();
        }
        this.setMessages(this.buggyMessages, msgVV, ctx);
    }

    public void setHintMessages(ValueVector msgVV, Context ctx) throws JessException {
        if (this.hintMessages == null) {
            this.hintMessages = new Vector();
        }
        this.setMessages(this.hintMessages, msgVV, ctx);
    }

    private void setMessages(List<String> tgtMsgList, ValueVector msgVV, Context ctx) throws JessException {
        for (int i = 0; i < msgVV.size(); ++i) {
            Value msgV = msgVV.get(i);
            Value resolvedV = msgV.resolveValue(ctx);
            String msg = resolvedV.stringValue(ctx);
            if (trace.getDebugCode("mt")) {
                trace.out("mt", "setMessages[" + i + "]: \"" + msg + "\"");
            }
            if (msg != null) {
                msg = msg.trim();
            }
            if (msg.length() <= 0) continue;
            tgtMsgList.add(msg);
        }
    }

    public void setCLHintMessages(ValueVector msgVV, Context ctx) throws JessException {
        if (this.clHintMessages == null) {
            this.clHintMessages = new Vector();
        }
        this.setMessages(this.clHintMessages, msgVV, ctx);
    }

    private int extractMessages(MTRete rete, Fact fact, String slotName, List msgList) {
        int count;
        block4: {
            count = 0;
            try {
                Value value = fact.getSlotValue(slotName);
                ValueVector vv = value.listValue(null);
                for (count = 0; count < vv.size(); ++count) {
                    String msg = vv.get(count).stringValue(null).trim();
                    if (msgList == null || msg.length() <= 0) continue;
                    if (trace.getDebugCode("mt")) {
                        trace.out("mt", "extractMessages() adding msg[" + msgList.size() + "]=" + msg);
                    }
                    msgList.add(msg);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                rete.getTextOutput().append("\n" + e.toString());
                if (!MTRete.breakOnExceptions) break block4;
                MTRete.stopModelTracing = true;
            }
        }
        return count;
    }

    public ArrayList<RuleActivationNode> getNodeSequence(ArrayList<RuleActivationNode> nodeSeq) {
        if (trace.getDebugCode("mtt")) {
            trace.out("mtt", "RAN.getNodeSequence() this " + this.getNodeId() + ", isChainNode " + this.isChainNode() + ", parent " + (this.parent instanceof RuleActivationNode ? ((RuleActivationNode)this.parent).getNodeId() : null));
        }
        if (this.parent != null) {
            nodeSeq = ((RuleActivationNode)this.parent).getNodeSequence(nodeSeq);
        } else if (nodeSeq == null) {
            nodeSeq = new ArrayList();
        } else {
            nodeSeq.clear();
        }
        if (!this.isChainNode()) {
            nodeSeq.add(this);
        }
        return nodeSeq;
    }

    private static String translate(String saiElementValue) {
        if (saiElementValue == null) {
            return "Not Specified";
        }
        if (saiElementValue.equals("NotSpecified")) {
            return "Not Specified";
        }
        if (saiElementValue.equals("DONT-CARE")) {
            return "Don't Care";
        }
        return saiElementValue;
    }

    public int getSearchDepth() {
        return this.searchDepth;
    }

    public void setActivation(Activation activation) {
        this.activation = activation;
    }

    public String getActualAction() {
        return this.actualAction;
    }

    private void setActualAction(String actualAction) {
        if (!this.actualAction.equals(actualAction)) {
            this.redoHtmlText = true;
        }
        this.actualAction = actualAction == null ? "NotSpecified" : actualAction;
    }

    public String getActualInput() {
        return this.actualInput;
    }

    private void setActualInput(String actualInput) {
        if (!this.actualInput.equals(actualInput)) {
            this.redoHtmlText = true;
        }
        this.actualInput = actualInput == null ? "NotSpecified" : actualInput;
    }

    public String getActualInputTestFunction() {
        return this.actualInputTestFunction;
    }

    private void setActualInputTestFunction(String actualInputTestFunction) {
        if (!this.actualInputTestFunction.equals(actualInputTestFunction)) {
            this.redoHtmlText = true;
        }
        this.actualInputTestFunction = actualInputTestFunction == null ? "NotSpecified" : actualInputTestFunction;
    }

    public Vector getBuggyMessages() {
        return this.buggyMessages;
    }

    Vector getSuccessMessages() {
        return this.successMessages;
    }

    public Vector getHintMessages() {
        return this.hintMessages;
    }

    public Vector getCLHintMessages() {
        return this.clHintMessages;
    }

    public String getActualSelection() {
        return this.actualSelection;
    }

    public void setActualSelection(String actualSelection) {
        if (!this.actualSelection.equals(actualSelection)) {
            this.redoHtmlText = true;
        }
        this.actualSelection = actualSelection == null ? "NotSpecified" : actualSelection;
    }

    public void setReqAction(String reqAction) {
        if (!this.reqAction.equals(reqAction)) {
            this.redoHtmlText = true;
        }
        this.reqAction = reqAction == null ? "NotSpecified" : reqAction;
    }

    public void setReqInput(String reqInput) {
        if (!this.reqInput.equals(reqInput)) {
            this.redoHtmlText = true;
        }
        this.reqInput = reqInput == null ? "NotSpecified" : reqInput;
    }

    public void setReqSelection(String reqSelection) {
        if (!this.reqSelection.equals(reqSelection)) {
            this.redoHtmlText = true;
        }
        this.reqSelection = reqSelection == null ? "NotSpecified" : reqSelection;
    }

    public String getReqAction() {
        return this.reqAction;
    }

    public String getReqInput() {
        return this.reqInput;
    }

    public String getReqSelection() {
        return this.reqSelection;
    }

    protected static String matchIntToString(int matchInt) {
        if (0 <= matchInt && matchInt < matchStrings.length) {
            return matchStrings[matchInt];
        }
        return "(undefined match int " + matchInt + ")";
    }

    public int selectionMatches() {
        if (this.matcher != null) {
            return this.testMatcherSelectionInternal();
        }
        if (!this.actualSelection.equals("NotSpecified")) {
            if (this.actualSelection.equals(this.reqSelection)) {
                return 1;
            }
            if (this.actualSelection.equals("DONT-CARE")) {
                return 0;
            }
            return 2;
        }
        return 3;
    }

    public int actionMatches() {
        if (this.matcher != null) {
            return this.testMatcherActionInternal();
        }
        if (!this.actualAction.equals("NotSpecified")) {
            if (this.actualAction.equals(this.reqAction)) {
                return 1;
            }
            if (this.actualAction.equals("DONT-CARE")) {
                return 0;
            }
            return 2;
        }
        return 3;
    }

    public int inputMatches() {
        if (this.matcher != null) {
            return this.testMatcherInputInternal();
        }
        if (this.inputFunction != null) {
            return this.inputFunctionResult;
        }
        if (!this.actualInput.equals("NotSpecified")) {
            if (this.actualInput.equals(this.reqInput)) {
                return 1;
            }
            if (this.actualInput.equals("DONT-CARE")) {
                return 0;
            }
            return 2;
        }
        return 3;
    }

    public String getNodeToolTipText() {
        if (!this.redoHtmlText) {
            return this.htmlText;
        }
        if (this.actualSelection.equals("NotSpecified") && this.actualAction.equals("NotSpecified") && this.actualInput.equals("NotSpecified")) {
            this.redoHtmlText = false;
            return "";
        }
        String pSelection = RuleActivationNode.translate(this.getActualSelection());
        String pAction = RuleActivationNode.translate(this.getActualAction());
        String pInput = RuleActivationNode.translate(this.getActualInput());
        String sSelection = RuleActivationNode.translate(this.getReqSelection());
        String sAction = RuleActivationNode.translate(this.getReqAction());
        String sInput = RuleActivationNode.translate(this.getReqInput());
        StringBuffer result = new StringBuffer("<html>");
        result.append("<table border=\"1\" bgcolor=\"white\">");
        result.append("<caption><b>Rule's Predicted vs. Student's Actual Values</b></caption>");
        result.append("<tr><th>&nbsp;</th><th>Selection (S)</th><th>Action (A)</th><th>Input (I)</th></tr>");
        result.append("<tr><th width=\"100\">Rule</th>");
        result.append("<td align=\"center\" width=\"100\"");
        int selectionMatch = this.selectionMatches();
        result.append(RuleActivationNode.getBackgroundColorText(selectionMatch) + ">");
        result.append(pSelection);
        result.append("</td>");
        result.append("<td align=\"center\" width=\"100\"");
        int actionMatch = this.actionMatches();
        result.append(RuleActivationNode.getBackgroundColorText(actionMatch) + ">");
        result.append(pAction);
        result.append("</td>");
        result.append("<td align=\"center\" width=\"100\"");
        int inputMatch = this.inputMatches();
        result.append(RuleActivationNode.getBackgroundColorText(inputMatch) + ">");
        result.append(pInput);
        result.append("</td>");
        result.append("</tr>");
        result.append("<tr><th width=\"100\">Student</th>");
        result.append("<td align=\"center\" width=\"100\"");
        result.append(RuleActivationNode.getBackgroundColorText(selectionMatch) + ">");
        result.append(sSelection);
        result.append("</td>");
        result.append("<td align=\"center\" width=\"100\"");
        result.append(RuleActivationNode.getBackgroundColorText(actionMatch) + ">");
        result.append(sAction);
        result.append("</td>");
        result.append("<td align=\"center\" width=\"100\"");
        result.append(RuleActivationNode.getBackgroundColorText(inputMatch) + ">");
        result.append(sInput);
        result.append("</td>");
        result.append("</tr>");
        result.append("</table></html>");
        this.htmlText = result.toString();
        this.redoHtmlText = false;
        return this.htmlText;
    }

    private static String getBackgroundColorText(int matchType) {
        if (matchType == 1 || matchType == 0) {
            return " bgcolor=\"rgb(85,255,85)\"";
        }
        if (matchType == 2) {
            return " bgcolor=\"rgb(255,85,85)\"";
        }
        if (matchType == 3) {
            return " bgcolor=\"white\"";
        }
        return "";
    }

    public boolean isChainNode() {
        return this.chainNode;
    }

    public Matcher getMatcher() {
        return this.matcher;
    }

    void setMatcher(Matcher matcher) {
        this.matcher = matcher;
    }

    public int testMatcherSelection() {
        int result = this.testMatcherParameterByIndex(this.matcher.getSelectionIndex(), this.getReqSelection());
        if (0 == result) {
            return 1;
        }
        return result;
    }

    private int testMatcherSelectionInternal() {
        return this.testMatcherParameterByIndex(this.matcher.getSelectionIndex(), this.getReqSelection());
    }

    private int testMatcherActionInternal() {
        return this.testMatcherParameterByIndex(this.matcher.getActionIndex(), this.getReqAction());
    }

    private int testMatcherInputInternal() {
        return this.testMatcherParameterByIndex(this.matcher.getInputIndex(), this.getReqInput());
    }

    private int testMatcherParameterByIndex(int i, String studentValue) {
        int result;
        if (this.matcher.isParamNotSpecified(i)) {
            result = 3;
        } else if (this.matcher.isParamDontCare(i)) {
            result = 0;
        } else {
            Vector<String> v = new Vector<String>();
            v.add(studentValue);
            result = this.matcher.match(i, v) ? 1 : 2;
        }
        if (trace.getDebugCode("mtt")) {
            trace.out("mtt", "testMatcherParameterByIndex(" + i + "," + studentValue + ") returns " + RuleActivationNode.matchIntToString(result));
        }
        return result;
    }

    public int testMatcherSAI(boolean isHint) {
        boolean S = true;
        int A = 2;
        int I = 4;
        int result = 0;
        int mv = this.testMatcherSelectionInternal();
        if (mv == 2) {
            return 2;
        }
        if (mv == 1 || mv == 0) {
            result |= 1;
        }
        if ((mv = this.testMatcherActionInternal()) == 2) {
            return 2;
        }
        if (mv == 1 || mv == 0) {
            result |= 2;
        }
        if ((mv = this.testMatcherInputInternal()) == 2) {
            return 2;
        }
        if (mv == 1 || mv == 0) {
            result |= 4;
        }
        if ((result & 7) == 7) {
            return 1;
        }
        return 3;
    }

    public List<String> getSkillNames(Rete rete, String defaultCategory) {
        String[] skills;
        ArrayList<String> result = new ArrayList<String>();
        HasLHS rule = rete.findDefrule(this.ruleName);
        if (rule == null) {
            return result;
        }
        String docStr = rule.getDocstring();
        if (docStr == null || docStr.length() < 1) {
            return result;
        }
        int tag = docStr.toLowerCase().lastIndexOf("skills:");
        if (tag < 0) {
            return result;
        }
        String previousCategory = null;
        for (String skill : skills = docStr.substring(tag + 7).split(";")) {
            int i;
            String[] nc = (skill = skill.trim()).split(" ");
            if (nc[i = 0] == null || nc[i].length() < 1) continue;
            String name = nc[i];
            String category = null;
            while (++i < nc.length && category == null) {
                if (nc[i] == null || nc[i].length() < 1) continue;
                category = nc[i];
            }
            if ("~".equals(category)) {
                category = previousCategory;
            }
            if (category == null) {
                category = defaultCategory != null ? defaultCategory : rule.getModule();
            }
            previousCategory = category;
            result.add(name + ' ' + category);
        }
        return result;
    }
}

