/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.ctat.model;

import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.model.Skills;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class ProblemSummary {
    public static final String PROBLEM_SUMMARY = "ProblemSummary";
    public static final String PROBLEM_NAME = "ProblemName";
    private static XMLOutputter outputter = new XMLOutputter(Format.getCompactFormat());
    private String problemName;
    private Skills skills;
    private int correct = 0;
    private int hints = 0;
    private int lastHints = 0;
    private int errors = 0;
    private CompletionValue completionStatus = CompletionValue.incomplete;
    private int uniqueCorrect = 0;
    private int uniqueCorrectUnassisted = 0;
    private int uniqueHints = 0;
    private int uniqueErrors = 0;
    private Map<String, Step> stepMap = new LinkedHashMap<String, Step>();
    private int uniqueSteps = 0;
    private int requiredSteps = Integer.MAX_VALUE;
    private Date startTime = new Date();
    private long timeElapsed = 0L;
    private int initialHintsOnly = 0;
    private int initialErrorsOnly = 0;
    private boolean countOnlyLastResults = false;

    private ProblemSummary(String problemName) {
        if (problemName == null || problemName.length() < 1) {
            throw new IllegalArgumentException("problemName null or empty");
        }
        this.problemName = problemName;
    }

    public ProblemSummary(String problemName, Skills skills, boolean countOnlyLastResults) {
        this(problemName);
        this.skills = skills;
        this.countOnlyLastResults = countOnlyLastResults;
    }

    public static ProblemSummary factory(String xmlParam) throws Exception {
        if (xmlParam == null) {
            return null;
        }
        try {
            String xml = "<?xml version=\"1.0\"?>";
            xml = xmlParam.trim().startsWith("<?") ? xmlParam : xml + xmlParam;
            SAXBuilder bob = new SAXBuilder();
            StringReader rdr = new StringReader(xml);
            Document doc = bob.build((Reader)rdr);
            Element root = doc.getRootElement();
            ProblemSummary ps = new ProblemSummary(root.getAttributeValue(PROBLEM_NAME));
            for (Object child : root.getChildren()) {
                if (!(child instanceof Element)) continue;
                Element elt = (Element)child;
                if ("step".equals(elt.getName())) {
                    ps.addStep(new Step(elt));
                    continue;
                }
                if (!"Skills".equalsIgnoreCase(elt.getName())) continue;
                try {
                    Skills skills = Skills.factory(elt);
                    ps.setSkills(skills);
                }
                catch (Exception e) {
                    String errMsg = "Error parsing skills from XML for ProblemSummary " + ps.getProblemName() + ": " + e;
                    trace.err(errMsg);
                    throw new Exception(errMsg, e);
                }
            }
            String reqSteps = root.getAttributeValue(AttrName.RequiredSteps.toString());
            try {
                ps.setRequiredSteps((int)Long.parseLong(reqSteps));
            }
            catch (Exception e) {
                trace.err("Warning: non-integer or missing value " + reqSteps + " on " + (Object)((Object)AttrName.RequiredSteps) + " attribute of ProblemSummary for " + ps.getProblemName() + "; setting default " + Integer.MAX_VALUE + ": " + e);
                ps.setRequiredSteps(Integer.MAX_VALUE);
            }
            if (ps.getUniqueSteps() < 1) {
                block24: for (AttrName attrName : AttrName.values()) {
                    String attrVal = root.getAttributeValue(attrName.toString());
                    if (attrVal == null) continue;
                    long iVal = -1L;
                    try {
                        iVal = Long.parseLong(attrVal);
                    }
                    catch (NumberFormatException nfe) {
                        if (!trace.getDebugCode("ps")) continue;
                        trace.outNT("ps", "Warning: non-integer value " + attrVal + " on " + (Object)((Object)attrName) + " attribute of ProblemSummary for " + ps.getProblemName() + ": " + nfe);
                        continue;
                    }
                    switch (attrName) {
                        case CompletionStatus: {
                            ps.completionStatus = CompletionValue.valueOf(attrVal);
                            continue block24;
                        }
                        case Correct: {
                            ps.correct = (int)iVal;
                            continue block24;
                        }
                        case UniqueCorrect: {
                            ps.uniqueCorrect = (int)iVal;
                            continue block24;
                        }
                        case UniqueCorrectUnassisted: {
                            ps.uniqueCorrectUnassisted = (int)iVal;
                            continue block24;
                        }
                        case Hints: {
                            ps.hints = (int)iVal;
                            continue block24;
                        }
                        case UniqueHints: {
                            ps.uniqueHints = (int)iVal;
                            continue block24;
                        }
                        case HintsOnly: {
                            ps.initialHintsOnly = (int)iVal;
                            continue block24;
                        }
                        case Errors: {
                            ps.errors = (int)iVal;
                            continue block24;
                        }
                        case UniqueErrors: {
                            ps.uniqueErrors = (int)iVal;
                            continue block24;
                        }
                        case ErrorsOnly: {
                            ps.initialErrorsOnly = (int)iVal;
                            continue block24;
                        }
                        case UniqueSteps: {
                            ps.uniqueSteps = (int)iVal;
                            continue block24;
                        }
                        case TimeElapsed: {
                            ps.timeElapsed = iVal;
                        }
                    }
                }
            }
            return ps;
        }
        catch (JDOMException je) {
            je.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return null;
    }

    private void addStep(Step step) {
        Step matchingStep = this.stepMap.get(step.getId());
        if (matchingStep != null) {
            matchingStep.merge(step);
        } else {
            this.stepMap.put(step.getId(), step);
            switch (step.getResult()) {
                case HINT: {
                    ++this.uniqueHints;
                    break;
                }
                case INCORRECT: {
                    ++this.uniqueErrors;
                }
            }
        }
        this.hints += step.getNFirstHints();
        this.lastHints += step.getNLastHints();
        this.errors += step.getNErrors();
    }

    public void setSkills(Skills skills) {
        this.skills = skills;
    }

    public void addError(String stepID) {
        Step trial = this.stepMap.get(stepID);
        if (trial != null) {
            if (trial.getNCorrect() < 1 && trial.getNErrors() < 1) {
                ++this.uniqueErrors;
            }
            trial.incrementErrors();
        } else {
            trial = new Step(stepID, StepResult.INCORRECT);
            this.stepMap.put(stepID, trial);
            ++this.uniqueErrors;
        }
        ++this.errors;
        trial.setLastResult(StepResult.INCORRECT);
    }

    public void addHint(String stepID) {
        Step trial = this.stepMap.get(stepID);
        if (trial != null) {
            if (trial.getNFirstHints() < 1) {
                ++this.uniqueHints;
            }
            trial.incrementFirstHints();
        } else {
            trial = new Step(stepID, StepResult.HINT);
            this.stepMap.put(stepID, trial);
            ++this.uniqueHints;
        }
        ++this.hints;
        trial.setLastResult(StepResult.HINT);
    }

    public void addCorrect(String stepID) {
        Step trial = this.stepMap.get(stepID);
        if (trial != null) {
            if (trial.getNCorrect() < 1 && trial.getNErrors() < 1) {
                ++this.uniqueCorrect;
                if (trial.getNFirstHints() < 1) {
                    ++this.uniqueCorrectUnassisted;
                }
            }
            trial.incrementNCorrect();
            if (trace.getDebugCode("solverdebug")) {
                trace.out("solverdebug", "addCorrect prior trial " + trial);
            }
        } else {
            trial = new Step(stepID, StepResult.CORRECT);
            this.stepMap.put(stepID, trial);
            ++this.uniqueCorrect;
            ++this.uniqueCorrectUnassisted;
            if (trace.getDebugCode("solverdebug")) {
                trace.out("solverdebug", "addCorrect new trial " + trial);
            }
        }
        ++this.correct;
        trial.setLastResult(StepResult.CORRECT);
    }

    public String getProblemName() {
        return this.problemName;
    }

    public Skills getSkills() {
        return this.skills;
    }

    public int getHints() {
        return this.hints;
    }

    public int getUniqueHints() {
        if (!this.getCountOnlyLastResults()) {
            return this.uniqueHints;
        }
        int n = 0;
        for (Step s : this.stepMap.values()) {
            if (s.getLastResult() != StepResult.HINT) continue;
            ++n;
        }
        return n;
    }

    public int getErrors() {
        return this.errors;
    }

    public int getUniqueErrors() {
        if (!this.getCountOnlyLastResults()) {
            return this.uniqueErrors;
        }
        int n = 0;
        for (Step s : this.stepMap.values()) {
            if (s.getLastResult() != StepResult.INCORRECT) continue;
            ++n;
        }
        return n;
    }

    public int getUniqueCorrect() {
        if (!this.getCountOnlyLastResults()) {
            return this.uniqueCorrect;
        }
        int n = 0;
        for (Step s : this.stepMap.values()) {
            if (s.getLastResult() != StepResult.CORRECT) continue;
            ++n;
        }
        return n;
    }

    public int getUniqueCorrectUnassisted() {
        return this.uniqueCorrectUnassisted;
    }

    public int getCorrect() {
        return this.correct;
    }

    public int getRequiredSteps() {
        return this.requiredSteps == Integer.MAX_VALUE ? 0 : this.requiredSteps;
    }

    public void setRequiredSteps(int nSteps) {
        this.requiredSteps = nSteps;
    }

    public int getUniqueSteps() {
        return this.uniqueSteps + this.stepMap.size();
    }

    public String toXML() {
        Element root = new Element(PROBLEM_SUMMARY);
        root.setAttribute(PROBLEM_NAME, this.problemName);
        root.setAttribute(AttrName.CompletionStatus.toString(), this.completionStatus.toString());
        root.setAttribute(AttrName.Correct.toString(), Integer.toString(this.correct));
        root.setAttribute(AttrName.UniqueCorrect.toString(), Integer.toString(this.getUniqueCorrect()));
        root.setAttribute(AttrName.UniqueCorrectUnassisted.toString(), Integer.toString(this.uniqueCorrectUnassisted));
        root.setAttribute(AttrName.Hints.toString(), Integer.toString(this.hints));
        root.setAttribute(AttrName.UniqueHints.toString(), Integer.toString(this.getUniqueHints()));
        root.setAttribute(AttrName.HintsOnly.toString(), Integer.toString(this.getHintsOnly()));
        root.setAttribute(AttrName.Errors.toString(), Integer.toString(this.errors));
        root.setAttribute(AttrName.UniqueErrors.toString(), Integer.toString(this.getUniqueErrors()));
        root.setAttribute(AttrName.ErrorsOnly.toString(), Integer.toString(this.getErrorsOnly()));
        root.setAttribute(AttrName.UniqueSteps.toString(), Integer.toString(this.getUniqueSteps()));
        root.setAttribute(AttrName.RequiredSteps.toString(), Integer.toString(this.getRequiredSteps()));
        root.setAttribute(AttrName.TimeElapsed.toString(), Long.toString(this.timeElapsed));
        if (this.skills != null) {
            root.addContent((Content)this.skills.toXMLElement());
        }
        String xml = outputter.outputString(root);
        return xml;
    }

    public void startTimer() {
        this.startTime = new Date();
    }

    public Date stopTimer() {
        Date stopTime = new Date();
        this.timeElapsed += stopTime.getTime() - this.startTime.getTime();
        return stopTime;
    }

    public long restartTimer() {
        this.startTime = this.stopTimer();
        return this.timeElapsed;
    }

    public long getTimeElapsed() {
        return this.timeElapsed;
    }

    public int getHintsOnly() {
        int s = this.initialHintsOnly;
        for (Step step : this.stepMap.values()) {
            if (StepResult.HINT != step.getResult() || step.getNErrors() >= 1) continue;
            ++s;
        }
        return s;
    }

    public int getErrorsOnly() {
        int s = this.initialErrorsOnly;
        for (Step step : this.stepMap.values()) {
            if (StepResult.INCORRECT != step.getResult() || step.getNFirstHints() >= 1) continue;
            ++s;
        }
        return s;
    }

    public CompletionValue getCompletionStatus() {
        return this.completionStatus;
    }

    public void setCompletionStatus(CompletionValue completionStatus, boolean canRevert) {
        if (CompletionValue.complete == this.completionStatus && !canRevert) {
            return;
        }
        this.completionStatus = completionStatus;
    }

    public boolean getCountOnlyLastResults() {
        return this.countOnlyLastResults;
    }

    public void setCountOnlyLastResults(boolean countOnlyLastResults) {
        this.countOnlyLastResults = countOnlyLastResults;
    }

    public static class Step {
        public static final String ELEMENT_NAME = "step";
        private final String id;
        private final StepResult result;
        private int nCorrect = 0;
        private int nFirstHints = 0;
        private int nLastHints = 0;
        private int nErrors = 0;
        private StepResult lastResult = null;

        public Step(String id, StepResult result) {
            this.id = id;
            this.result = result;
            switch (result) {
                case CORRECT: {
                    this.incrementNCorrect();
                    break;
                }
                case INCORRECT: {
                    this.incrementErrors();
                    break;
                }
                case HINT: {
                    this.incrementFirstHints();
                }
            }
        }

        public Step(Element elt) throws IllegalArgumentException {
            String aName = "element_name";
            String aVal = null;
            try {
                aVal = elt.getName();
                if (!ELEMENT_NAME.equals(aVal)) {
                    throw new IllegalArgumentException("not match step");
                }
                aName = "id";
                this.id = aVal = elt.getAttributeValue("id");
                if (null == this.id || this.id.length() < 1) {
                    throw new IllegalArgumentException("id null or empty");
                }
                aName = "result";
                aVal = elt.getAttributeValue("result");
                this.result = StepResult.valueOf(aVal);
                aName = "nFirstHints";
                aVal = elt.getAttributeValue("nFirstHints");
                if (null != aVal) {
                    this.nFirstHints = Integer.parseInt(aVal);
                }
                aName = "nLastHints";
                aVal = elt.getAttributeValue("nLastHints");
                if (null != aVal) {
                    this.nLastHints = Integer.parseInt(aVal);
                }
                aName = "nErrors";
                aVal = elt.getAttributeValue("nErrors");
                if (null != aVal) {
                    this.nErrors = Integer.parseInt(aVal);
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException("error on " + aName + "=" + aVal + ": " + e, e);
            }
        }

        public Element toXMLElement() {
            Element elt = new Element(ELEMENT_NAME);
            elt.setAttribute("id", this.id);
            elt.setAttribute("result", this.result.toString());
            elt.setAttribute("nFirstHints", Integer.toString(this.nFirstHints));
            elt.setAttribute("nLastHints", Integer.toString(this.nLastHints));
            elt.setAttribute("nErrors", Integer.toString(this.nErrors));
            return elt;
        }

        public void incrementNCorrect() {
            ++this.nCorrect;
        }

        public void incrementFirstHints() {
            ++this.nFirstHints;
        }

        public void incrementLastHints() {
            ++this.nLastHints;
        }

        public void incrementErrors() {
            ++this.nErrors;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("[");
            sb.append(this.id).append(" ").append((Object)this.result).append(":");
            sb.append(this.nFirstHints).append(",").append(this.nErrors).append("]");
            return sb.toString();
        }

        public String getId() {
            return this.id;
        }

        public StepResult getResult() {
            return this.result;
        }

        public int getNFirstHints() {
            return this.nFirstHints;
        }

        public int getNLastHints() {
            return this.nLastHints;
        }

        public int getNErrors() {
            return this.nErrors;
        }

        void merge(Step sameStep) {
            this.nFirstHints += sameStep.getNFirstHints();
            this.nLastHints += sameStep.getNLastHints();
            this.nErrors += sameStep.getNErrors();
        }

        public int getNCorrect() {
            return this.nCorrect;
        }

        public void setLastResult(StepResult result) {
            this.lastResult = result;
        }

        public StepResult getLastResult() {
            return this.lastResult;
        }
    }

    static enum StepResult {
        UNTRIED,
        INCORRECT,
        HINT,
        CORRECT;

    }

    public static enum CompletionValue {
        incomplete,
        complete;

    }

    private static enum AttrName {
        CompletionStatus,
        Correct,
        UniqueCorrect,
        UniqueCorrectUnassisted,
        Hints,
        UniqueHints,
        HintsOnly,
        Errors,
        UniqueErrors,
        ErrorsOnly,
        UniqueSteps,
        RequiredSteps,
        TimeElapsed;

    }
}

