/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.TutoringService;

import edu.cmu.pact.Utilities.SocketReader;
import edu.cmu.pact.Utilities.trace;
import java.io.BufferedReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.ServerSocket;
import java.net.Socket;

class TSLTListener {
    private static String usage = "TSLTListener accepts 0 or 1 arguments0 arguments-> Listener opens on port 15151 arguments-> Listener opens on port specified in first argument";

    public TSLTListener(int port) {
        CommunicationThread cthread = new CommunicationThread(port);
        cthread.start();
    }

    public static void main(String[] args) {
        if (args.length > 1) {
            System.out.println(usage);
        }
        int port = args.length == 1 ? Integer.parseInt(args[0]) : 1515;
        TSLTListener tslt = new TSLTListener(port);
    }

    class CommunicationThread
    extends Thread {
        private final int commPort;

        CommunicationThread(int commPort) {
            this.commPort = commPort;
        }

        @Override
        public void run() {
            try {
                ServerSocket commSocket = new ServerSocket(this.commPort);
                while (true) {
                    trace.out("tslt", "TSLT Listener : Listening");
                    Socket cs = commSocket.accept();
                    trace.out("tslt", "TSLT listener Got Connection");
                    CommThreadConsumer ctc = new CommThreadConsumer(cs);
                    ctc.start();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        }

        private class CommThreadConsumer
        extends Thread {
            Socket cSock;
            private String mutex = "";

            CommThreadConsumer(Socket sock) {
                this.cSock = sock;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    trace.out("tslt", "Entering conthreadconsumer run");
                    BufferedReader br = new BufferedReader(new InputStreamReader(this.cSock.getInputStream(), "UTF-8"));
                    String string = this.mutex;
                    synchronized (string) {
                        OutputStreamWriter fw = null;
                        String result = SocketReader.readToEom(br, 0);
                        String[] msgs = result.split("\n");
                        trace.out("tslt", "Read " + result.length() + " characters ");
                        for (int i = 0; i < msgs.length; ++i) {
                            String msg = msgs[i];
                            if (fw == null) {
                                String fName = msg.split("#")[0];
                                trace.out("tslt", "msgs.length = " + msgs.length);
                                fw = new FileWriter(fName + ".test");
                                trace.out("tslt", "Filename : " + fName + ".test");
                                if (msg.split("#").length <= 1) continue;
                                fw.write(msg.split("#")[1] + "\n");
                                continue;
                            }
                            fw.write(msg + "\n");
                        }
                        if (fw != null) {
                            fw.close();
                        }
                        trace.out("tslt", "File Written");
                    }
                    br.close();
                    this.cSock.close();
                }
                catch (IOException ioe) {
                    System.out.println("Exception in reading/writing (TSLT listener)");
                    ioe.printStackTrace();
                }
            }
        }
    }
}

