/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.ProblemModel;

public enum HintPolicyEnum {
    HINTS_UNBIASED("Always Follow Best Path"),
    HINTS_BIASED_BY_CURRENT_SELECTION_ONLY("Bias Hints by Current Selection Only"),
    HINTS_BIASED_BY_PRIOR_ERROR_ONLY("Bias Hints by Prior Error Only"),
    HINTS_BIASED_BY_ALL("Use Both Kinds of Bias");

    public static final HintPolicyEnum DEFAULT;
    private String description;

    private HintPolicyEnum(String description) {
        this.description = description;
    }

    public boolean isBiasedByCurrentSelection() {
        return this.equals((Object)HINTS_BIASED_BY_ALL) || this.equals((Object)HINTS_BIASED_BY_CURRENT_SELECTION_ONLY);
    }

    public boolean isBiasedByPriorError() {
        return this.equals((Object)HINTS_BIASED_BY_ALL) || this.equals((Object)HINTS_BIASED_BY_PRIOR_ERROR_ONLY);
    }

    public String toString() {
        return this.description;
    }

    public static HintPolicyEnum fromString(String text) {
        return HintPolicyEnum.fromString(text, false);
    }

    public static HintPolicyEnum fromString(String text, boolean strict) {
        if (text == null) {
            return strict ? null : DEFAULT;
        }
        for (HintPolicyEnum hbe : HintPolicyEnum.values()) {
            if (!text.equalsIgnoreCase(hbe.toString())) continue;
            return hbe;
        }
        return strict ? null : DEFAULT;
    }

    public static void main(String[] args) {
        HintPolicyEnum[] values = HintPolicyEnum.values();
        for (int i = 0; i < values.length; ++i) {
            System.out.printf(" %d. %s\n", new Object[]{i, values[i]});
        }
    }

    static {
        DEFAULT = HINTS_BIASED_BY_ALL;
    }
}

