/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.Controller;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.Controller.LinkEditFunctions;
import edu.cmu.pact.BehaviorRecorder.Dialogs.EditMinMaxLinkTraversals;
import edu.cmu.pact.BehaviorRecorder.Dialogs.EditStudentInputDialog;
import edu.cmu.pact.BehaviorRecorder.Dialogs.HelpSuccessPanel;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.DialogueSystemInfo;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.EdgeData;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemEdge;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemNode;
import edu.cmu.pact.BehaviorRecorder.View.ActionLabel;
import edu.cmu.pact.BehaviorRecorder.View.NodeView;
import edu.cmu.pact.Utilities.trace;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.MouseInputAdapter;

public class ActionLabelHandler
extends MouseInputAdapter
implements ActionListener,
ItemListener {
    public static final String CHANGE_ACTION_TYPE = "Change Action Type";
    public String jDialogResult;
    public static final String SET_AS_PREFERRED_PATH = "Set As Preferred Path";
    public static final String EDIT_HINT_AND_SUCCESS_MESSAGES = "Edit Hint and Success Messages...";
    public static final String SET_CALL_BACK_FUNCTION = "Set Callback Function";
    public static final String EDIT_BUG_MESSAGE = "Edit Bug Message...";
    public static final String INCORRECT_ACTION_NOT_IN_MODEL = "Incorrect Action not in Model (Untraceable Error)";
    public static final String SUBOPTIMAL_ACTION = "Suboptimal Action (Fireable Bug)";
    public static final String INCORRECT_ACTION = "Incorrect Action (Bug)";
    public static final String CORRECT_ACTION = "Correct Action";
    public static final String TEST_PRODUCTION_MODEL = "Test Cognitive Model";
    public static final String ATTACH_DIALOGUE = "Attach Dialogue...";
    public static final String EDIT_STUDENT_INPUT = "Edit Student Input Matching...";
    public static final String REUSEABLE_LINKS = "Set min/max traversals";
    public static final String DELETE_EDGE = "Delete...";
    public static final String INSERT_NODE_ABOVE = "Insert a Blank State in Link (Above)";
    public static final String INSERT_NODE_BELOW = "Insert a Blank State in Link (Below)";
    public static final String DEMONSTRATE_LINK = "Demonstrate this Link";
    public static final String DEMONSTRATE_LINK_DISABLED = "Demonstrate this Link (Disabled in 'Set Start State' mode)";
    public static final String CANCEL_DEMONSTRATE_LINK = "Cancel Demonstrate This Link Mode";
    private static final String TEST_TPA = "Test Tutor-Performed Action";
    public static final String COPY_LINK = "Copy Link";
    public static final String PASTE_LINK = "Paste Link";
    public static final String PASTE_SPECIAL_LINK = "Paste Link (Special)";
    public static final String CLIPBOARD_COPY_LINK = "Copy Link to Clipboard";
    public static final String CLIPBOARD_PASTE_LINK = "Paste Link to Clipboard";
    ActionLabel actionLabel;
    LinkEditFunctions functions;
    ProblemEdge problemEdge;
    ProblemNode parentNode;
    ProblemNode childNode;
    NodeView parentVertex;
    NodeView childVertex;
    JDialog displayDialog;
    private EdgeData edgeData;
    private transient BR_Controller controller;

    public void restoreTransients(BR_Controller controller) {
        this.controller = controller;
    }

    public ActionLabelHandler(ActionLabel actionLabelP, BR_Controller controller) {
        this.actionLabel = actionLabelP;
        this.controller = controller;
        this.controller.comeIntoFocus();
        controller.getProblemModel().printSelectedLinks();
        this.displayDialog = new JDialog(controller.getActiveWindow(), "Action Display", true);
        this.edgeData = actionLabelP.getEdge();
        this.problemEdge = controller.getProblemModel().getEdge(this.edgeData.getUniqueID());
        this.parentNode = this.problemEdge.getNodes()[0];
        this.childNode = this.problemEdge.getNodes()[1];
        this.parentVertex = this.parentNode.getNodeView();
        this.childVertex = this.childNode.getNodeView();
        this.functions = this.problemEdge.getLinkEditFunctions();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        ActionLabelHandler.evaluatePopup(e, this.controller, this);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
    }

    public static void evaluatePopup(MouseEvent e, BR_Controller controller, ActionLabelHandler handler) {
        trace.out("mg", "ActionLabelHandler (evaluatePopup): HERE");
        controller.getProblemModel().printSelectedLinks();
        controller.comeIntoFocus();
        String currentActionType = handler.problemEdge.getActionType();
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.setName("actionLabelPopupMenu");
        if (controller.getCtatModeModel().isDemonstrateThisLinkMode()) {
            JMenuItem menuItem = new JMenuItem(CANCEL_DEMONSTRATE_LINK);
            popupMenu.add(menuItem);
            menuItem.addActionListener(handler);
            popupMenu.show(e.getComponent(), e.getX(), e.getY());
            return;
        }
        JMenuItem menuItem = new JMenuItem(TEST_PRODUCTION_MODEL);
        menuItem.addActionListener(handler);
        popupMenu.add(menuItem);
        if (controller.getCtatModeModel().isExampleTracingMode()) {
            menuItem.setEnabled(false);
        }
        JMenu submenu = new JMenu(CHANGE_ACTION_TYPE);
        JCheckBoxMenuItem cbMenuItem1 = new JCheckBoxMenuItem(CORRECT_ACTION);
        cbMenuItem1.addActionListener(handler);
        submenu.add(cbMenuItem1);
        JCheckBoxMenuItem cbMenuItem2 = new JCheckBoxMenuItem(INCORRECT_ACTION);
        cbMenuItem2.addActionListener(handler);
        submenu.add(cbMenuItem2);
        JCheckBoxMenuItem cbMenuItem3 = new JCheckBoxMenuItem(SUBOPTIMAL_ACTION);
        cbMenuItem3.addActionListener(handler);
        submenu.add(cbMenuItem3);
        JCheckBoxMenuItem cbMenuItem4 = new JCheckBoxMenuItem(INCORRECT_ACTION_NOT_IN_MODEL);
        cbMenuItem4.addActionListener(handler);
        submenu.add(cbMenuItem4);
        if ((currentActionType.equalsIgnoreCase("Buggy Action") || currentActionType.equalsIgnoreCase("Untraceable Error")) && handler.childNode.getInDegree() > 1) {
            cbMenuItem1.setEnabled(false);
            cbMenuItem3.setEnabled(false);
            String toolTipText = "Cannot have a correct and an incorrect link leading to the same state";
            cbMenuItem1.setToolTipText(toolTipText);
            cbMenuItem3.setToolTipText(toolTipText);
        }
        popupMenu.add(submenu);
        if (currentActionType.equalsIgnoreCase(CORRECT_ACTION)) {
            menuItem = new JMenuItem(EDIT_HINT_AND_SUCCESS_MESSAGES);
            menuItem.addActionListener(handler);
            popupMenu.add(menuItem);
            cbMenuItem1.setSelected(true);
        } else if (currentActionType.equalsIgnoreCase("Buggy Action")) {
            cbMenuItem2.setSelected(true);
            menuItem = new JMenuItem(EDIT_BUG_MESSAGE);
            menuItem.addActionListener(handler);
            popupMenu.add(menuItem);
        } else if (currentActionType.equalsIgnoreCase("Fireable Buggy Action")) {
            cbMenuItem3.setSelected(true);
            menuItem = new JMenuItem(EDIT_BUG_MESSAGE);
            menuItem.addActionListener(handler);
            popupMenu.add(menuItem);
        } else if (currentActionType.equalsIgnoreCase("Untraceable Error")) {
            cbMenuItem4.setSelected(true);
        }
        if (controller.getShowCallbackFn()) {
            menuItem = new JMenuItem(SET_CALL_BACK_FUNCTION);
            popupMenu.add(menuItem);
            menuItem.addActionListener(handler);
            menuItem.setEnabled(true);
        }
        menuItem = new JMenuItem(EDIT_STUDENT_INPUT);
        popupMenu.add(menuItem);
        menuItem.addActionListener(handler);
        menuItem = new JMenuItem(REUSEABLE_LINKS);
        popupMenu.add(menuItem);
        menuItem.addActionListener(handler);
        if (DialogueSystemInfo.getUseDialogSystem(controller)) {
            JMenuItem dialogueItem = new JMenuItem(ATTACH_DIALOGUE);
            dialogueItem.addActionListener(handler);
            popupMenu.add(dialogueItem);
            dialogueItem.setEnabled(true);
        }
        menuItem = new JMenuItem(DELETE_EDGE);
        popupMenu.add(menuItem);
        menuItem.addActionListener(handler);
        menuItem.setEnabled(true);
        menuItem = new JMenuItem(INSERT_NODE_ABOVE);
        popupMenu.add(menuItem);
        menuItem.addActionListener(handler);
        menuItem = new JMenuItem(INSERT_NODE_BELOW);
        popupMenu.add(menuItem);
        menuItem.addActionListener(handler);
        if (controller.getCtatModeModel().isDefiningStartState()) {
            menuItem = new JMenuItem(DEMONSTRATE_LINK_DISABLED);
            menuItem.setEnabled(false);
        } else {
            menuItem = new JMenuItem(DEMONSTRATE_LINK);
            menuItem.setEnabled(true);
        }
        menuItem.addActionListener(handler);
        popupMenu.add(menuItem);
        menuItem = new JMenuItem(TEST_TPA);
        if (handler.edgeData.isTutorPerformed(null)) {
            menuItem.setEnabled(true);
            menuItem.setToolTipText("Show the effect of this step on the student interface.");
        } else {
            menuItem.setEnabled(false);
            menuItem.setToolTipText("This step is not tutor-performed.");
        }
        menuItem.addActionListener(handler);
        popupMenu.add(menuItem);
        int keyMask = System.getProperty("os.name").toUpperCase().startsWith("MAC") ? 5 : 3;
        menuItem = new JMenuItem(COPY_LINK);
        popupMenu.add(menuItem);
        menuItem.addActionListener(handler);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(67, keyMask));
        menuItem = new JMenuItem(PASTE_LINK);
        popupMenu.add(menuItem);
        menuItem.addActionListener(handler);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(86, keyMask));
        menuItem.setEnabled(EdgeData.getCopyData() != null);
        if (controller.isChangePreferredPath() && handler.edgeData.getActionType().equalsIgnoreCase(CORRECT_ACTION) && !handler.edgeData.isPreferredEdge()) {
            JMenuItem prefPathMenuItem = new JMenuItem(SET_AS_PREFERRED_PATH);
            prefPathMenuItem.addActionListener(handler);
            popupMenu.add(prefPathMenuItem);
        }
        if (trace.getDebugCode("LI_HeaderPanel")) {
            trace.outNT("LI_HeaderPanel", "Showing Popup menu.");
        }
        popupMenu.show(e.getComponent(), e.getX(), e.getY());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ActionEvent ae;
        if (trace.getDebugCode("key")) {
            trace.out("key", "ActionLabelHandler.actionPerformed() source " + e.getSource() + ", action " + e.getActionCommand());
        }
        BR_Controller.setCopySubgraphNode(null);
        String action = e.getActionCommand();
        String serializedBeforeEdit = this.problemEdge.toXMLString();
        if (trace.getDebugCode("undo")) {
            trace.out("undo", "ActionLabelHandler.actionPerformed(" + action + ") XML before:\n" + serializedBeforeEdit);
        }
        this.doLogEvent(action);
        if (action.equals(TEST_PRODUCTION_MODEL)) {
            this.checkWithProductionSystem();
        } else if (action.equals(EDIT_STUDENT_INPUT)) {
            EditStudentInputDialog.show(this.edgeData, this.controller);
        } else if (action.equals(CORRECT_ACTION) || action.equals(INCORRECT_ACTION) || action.equals(SUBOPTIMAL_ACTION) || action.equals(INCORRECT_ACTION_NOT_IN_MODEL)) {
            this.updateActionType(action);
        } else if (action.equals(EDIT_BUG_MESSAGE)) {
            this.problemEdge.getLinkEditFunctions().showEditBuggyMsgPanel();
        } else if (action.equals(EDIT_HINT_AND_SUCCESS_MESSAGES)) {
            new HelpSuccessPanel(this.controller, this.edgeData, false).setVisible(true);
            this.actionLabel.updateToolTip();
        } else if (action.equals(SET_CALL_BACK_FUNCTION)) {
            String ans = (String)JOptionPane.showInputDialog(null, "Set the callback function for the swf to execute upon traversing this link", SET_CALL_BACK_FUNCTION, -1, null, null, this.edgeData.getCallbackFn());
            System.out.println("ans = " + ans);
            if (ans != null) {
                this.edgeData.setCallbackFn(ans);
            }
        } else if (action.equals(ATTACH_DIALOGUE)) {
            new DialogueSystemInfoDialog(this.edgeData.getDialogueSystemInfo());
        } else if (action.equals(SET_AS_PREFERRED_PATH)) {
            this.functions.setPreferredArc(null);
        } else if (action.equals(REUSEABLE_LINKS)) {
            new EditMinMaxLinkTraversals(this.controller.getActiveWindow(), REUSEABLE_LINKS, true, this.edgeData, this.controller);
        } else if (action.equals(DELETE_EDGE)) {
            this.functions.processDeleteSingleEdge(false);
        } else if (action.equals(INSERT_NODE_ABOVE)) {
            this.functions.processInsertNodeAbove2(true);
            ae = new ActionEvent(this, 0, INSERT_NODE_ABOVE);
            this.controller.getUndoPacket().getCheckpointAction().actionPerformed(ae);
        } else if (action.equals(INSERT_NODE_BELOW)) {
            this.functions.processInsertNodeAbove2(false);
            ae = new ActionEvent(this, 0, INSERT_NODE_BELOW);
            this.controller.getUndoPacket().getCheckpointAction().actionPerformed(ae);
        } else if (action.equals(DEMONSTRATE_LINK)) {
            this.functions.processDemonstrateLink();
        } else if (action.equals(CANCEL_DEMONSTRATE_LINK)) {
            this.functions.processCancelDemonstrateLink();
        } else if (action.equals(TEST_TPA)) {
            this.edgeData.testTPA();
        } else if (action.equals(COPY_LINK)) {
            this.functions.processCopyLink();
        } else if (action.equals(PASTE_LINK)) {
            this.functions.processPasteLink();
            ae = new ActionEvent(this, 0, PASTE_LINK);
            this.controller.getUndoPacket().getCheckpointAction().actionPerformed(ae);
        } else if (action.equals(PASTE_SPECIAL_LINK)) {
            this.functions.processPasteSpecialLink();
            ae = new ActionEvent(this, 0, PASTE_SPECIAL_LINK);
            this.controller.getUndoPacket().getCheckpointAction().actionPerformed(ae);
        } else if (action.equals(CLIPBOARD_COPY_LINK)) {
            this.functions.processClipboardCopyLink();
        } else if (action.equals(CLIPBOARD_PASTE_LINK)) {
            this.functions.processClipboardPasteLink();
        }
        String serializedAfterEdit = this.problemEdge.toXMLString();
        if (!serializedBeforeEdit.equals(serializedAfterEdit) && trace.getDebugCode("undo")) {
            trace.out("undo", "ActionLabelHandler.actionPerformed(" + action + ") XML before:\n" + serializedBeforeEdit + "\nXML after:\n" + serializedAfterEdit);
        }
    }

    private void doLogEvent(String action) {
        this.controller.getLoggingSupport().authorActionLog("BEHAVIOR_RECORDER", "MENU_ITEM", action, "", (Object)"");
    }

    public void updateActionType(String action) {
        String newActionType = "";
        newActionType = action.equals(CORRECT_ACTION) ? CORRECT_ACTION : (action.equals(INCORRECT_ACTION) ? "Buggy Action" : (action.equals(SUBOPTIMAL_ACTION) ? "Fireable Buggy Action" : "Untraceable Error"));
        this.functions.changeActionType(newActionType);
    }

    private void checkWithProductionSystem() {
        if (this.parentNode != this.controller.getCurrentNode()) {
            this.controller.goToState(this.parentNode);
        }
        this.controller.checkWithLispSingle(this.problemEdge);
    }

    public static void doubleClick(MouseEvent e, BR_Controller controller, ActionLabelHandler actionHandler) {
        EditStudentInputDialog.show(actionHandler.edgeData, controller);
    }

    public class DialogueSystemInfoDialog
    extends JDialog
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        private JButton okButton;
        private JButton cancelButton;
        private JLabel hintJLabel;
        private JTextField hintJTextField;
        private JLabel successJLabel;
        private JTextField successJTextField;
        private JLabel errorJLabel;
        private JTextField errorJTextField;
        private DialogueSystemInfo dialogueSystemInfo;

        public DialogueSystemInfoDialog(DialogueSystemInfo dialogueSystemInfo) {
            super((Frame)ActionLabelHandler.this.controller.getActiveWindow(), true);
            this.hintJLabel = new JLabel("Student's Hint Request:");
            this.successJLabel = new JLabel("Succesful Completion of the Step:");
            this.errorJLabel = new JLabel("Student Error:");
            this.dialogueSystemInfo = dialogueSystemInfo;
            this.initComponents();
        }

        private void initComponents() {
            this.hintJTextField = new JTextField();
            this.successJTextField = new JTextField();
            this.errorJTextField = new JTextField();
            this.okButton = new JButton();
            this.cancelButton = new JButton();
            this.getContentPane().setLayout(null);
            this.setDefaultCloseOperation(2);
            this.getContentPane().add(this.hintJLabel);
            this.hintJLabel.setBounds(30, 30, 150, 20);
            this.getContentPane().add(this.hintJTextField);
            this.hintJTextField.setBounds(30, 55, 350, 20);
            this.getContentPane().add(this.successJLabel);
            this.successJLabel.setBounds(30, 80, 200, 20);
            this.getContentPane().add(this.successJTextField);
            this.successJTextField.setBounds(30, 105, 350, 20);
            this.getContentPane().add(this.errorJLabel);
            this.errorJLabel.setBounds(30, 130, 120, 20);
            this.getContentPane().add(this.errorJTextField);
            this.errorJTextField.setBounds(30, 155, 350, 20);
            String authorIntent = ActionLabelHandler.this.edgeData.getActionType();
            if (authorIntent.equalsIgnoreCase(ActionLabelHandler.CORRECT_ACTION)) {
                this.errorJTextField.setEditable(false);
                if (this.dialogueSystemInfo.isStudent_Hint_Request()) {
                    this.hintJTextField.setText(this.dialogueSystemInfo.getStudent_Hint_Request());
                }
                if (this.dialogueSystemInfo.isStep_Successful_Completion()) {
                    this.successJTextField.setText(this.dialogueSystemInfo.getStep_Successful_Completion());
                }
            } else {
                this.hintJTextField.setEditable(false);
                this.successJTextField.setEditable(false);
                if (this.dialogueSystemInfo.isStep_Student_Error()) {
                    this.errorJTextField.setText(this.dialogueSystemInfo.getStep_Student_Error());
                }
            }
            this.okButton.setText("OK");
            this.getContentPane().add(this.okButton);
            this.okButton.setBounds(120, 210, 65, 23);
            this.okButton.addActionListener(this);
            this.cancelButton.setText("Cancel");
            this.getContentPane().add(this.cancelButton);
            this.cancelButton.setBounds(240, 210, 65, 23);
            this.cancelButton.addActionListener(this);
            String title = "Attach Dialogue: ";
            NodeView tempNodeView = ActionLabelHandler.this.problemEdge.getNodes()[0].getNodeView();
            title = title + " from " + tempNodeView.getText();
            tempNodeView = ActionLabelHandler.this.problemEdge.getNodes()[1].getNodeView();
            title = title + " to " + tempNodeView.getText();
            this.setTitle(title);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    DialogueSystemInfoDialog.this.thisWindowClosing();
                }
            });
            this.setLocation(new Point(300, 100));
            this.setSize(430, 300);
            this.setResizable(false);
            this.setVisible(true);
        }

        public void thisWindowClosing() {
            this.setVisible(false);
            this.dispose();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.okButton) {
                String authorIntent = ActionLabelHandler.this.edgeData.getActionType();
                if (authorIntent.equalsIgnoreCase(ActionLabelHandler.CORRECT_ACTION)) {
                    this.dialogueSystemInfo.setStudent_Hint_Request(this.hintJTextField.getText().trim());
                    this.dialogueSystemInfo.setStep_Successful_Completion(this.successJTextField.getText().trim());
                } else {
                    this.dialogueSystemInfo.setStep_Student_Error(this.errorJTextField.getText().trim());
                }
            }
            this.thisWindowClosing();
        }
    }
}

