/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.ctat.wizard;

import edu.cmu.hcii.ctat.CTATBase;
import edu.cmu.hcii.ctat.env.CTATFileEntry;
import edu.cmu.hcii.ctat.wizard.CTATLMSConfiguration;
import edu.cmu.pact.Utilities.trace;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.swing.JOptionPane;

public class CTATPackageGeneratorBase
extends CTATBase {
    private String basePath = "";
    private static final int BUFFER_SIZE = 4096;
    protected ArrayList<File> internalList = new ArrayList();
    private CTATLMSConfiguration LMSConfiguration = null;
    protected ArrayList<File> tempFiles = new ArrayList();

    public CTATPackageGeneratorBase(CTATLMSConfiguration aConfiguration) {
        this.setClassName("CTATPackageGeneratorBase");
        this.debug("CTATPackageGeneratorBase ()");
        this.LMSConfiguration = aConfiguration;
    }

    protected void alert(String aMessage) {
        JOptionPane.showMessageDialog(null, aMessage);
    }

    public CTATLMSConfiguration getLMSConfiguration() {
        return this.LMSConfiguration;
    }

    public void setLMSConfiguration(CTATLMSConfiguration lMSConfiguration) {
        this.LMSConfiguration = lMSConfiguration;
    }

    public void listFilesAndFolders(String directoryName) {
        File[] fList;
        File directory = new File(directoryName);
        for (File file : fList = directory.listFiles()) {
            this.internalList.add(file);
        }
    }

    public void listFiles(String directoryName) {
        File[] fList;
        File directory = new File(directoryName);
        for (File file : fList = directory.listFiles()) {
            if (!file.isFile()) continue;
            this.internalList.add(file);
        }
    }

    public void listFolders(String directoryName) {
        File[] fList;
        File directory = new File(directoryName);
        for (File file : fList = directory.listFiles()) {
            if (!file.isDirectory()) continue;
            this.internalList.add(file);
        }
    }

    public void listFilesAndFilesSubDirectories(String directoryName) {
        File[] fList;
        File directory = new File(directoryName);
        for (File file : fList = directory.listFiles()) {
            if (file.isFile()) {
                this.internalList.add(file);
                continue;
            }
            if (!file.isDirectory()) continue;
            this.listFilesAndFilesSubDirectories(file.getAbsolutePath());
        }
    }

    protected CTATFileEntry addFileEntry(String anEntryBase, String anEntry) {
        this.debug("addFileEntry (" + anEntryBase + "," + anEntry + ")");
        CTATFileEntry newEntry = new CTATFileEntry();
        newEntry.basePath = anEntryBase;
        newEntry.filePath = anEntry;
        this.LMSConfiguration.getFileList().add(newEntry);
        return newEntry;
    }

    protected CTATFileEntry addFileEntry(File anEntry) {
        this.debug("addFileEntry ()");
        if (anEntry.isFile()) {
            this.debug("Adding regular file " + anEntry.getName() + " in: " + anEntry.getParent() + " ...");
            CTATFileEntry newEntry = new CTATFileEntry();
            newEntry.basePath = anEntry.getParent();
            newEntry.filePath = anEntry.getName();
            this.LMSConfiguration.getFileList().add(newEntry);
            return newEntry;
        }
        if (anEntry.isDirectory()) {
            this.debug("Expanding directory entry ...");
            this.internalList = new ArrayList();
            this.listFilesAndFilesSubDirectories(anEntry.getAbsolutePath());
            for (int i = 0; i < this.internalList.size(); ++i) {
                File testEntry = this.internalList.get(i);
                this.debug("Adding regular file (from subdir): " + testEntry.getName() + " ...");
                CTATFileEntry newEntry = new CTATFileEntry();
                newEntry.basePath = testEntry.getParent();
                newEntry.filePath = testEntry.getName();
                if (!this.basePath.isEmpty()) {
                    newEntry.relativePath = anEntry.getAbsolutePath().substring(this.basePath.length()).replace("\\", "/").replaceAll("^/+", "") + "/";
                    this.debug("Configured relative path for file in subdir to be: " + newEntry.relativePath);
                }
                this.LMSConfiguration.getFileList().add(newEntry);
            }
        }
        return null;
    }

    protected void addFileEntry(File anEntry, String aPath) {
        this.debug("addFileEntry ()");
        this.basePath = aPath;
        this.addFileEntry(anEntry);
    }

    protected CTATFileEntry addFileEntryAsIs(File anEntry, String aPath) {
        this.debug("addFileEntryAsIs (File," + aPath + ")");
        this.basePath = aPath;
        CTATFileEntry newEntry = new CTATFileEntry();
        newEntry.basePath = anEntry.getParent();
        newEntry.filePath = anEntry.getName();
        this.LMSConfiguration.getFileList().add(newEntry);
        return newEntry;
    }

    private void extractFile(ZipInputStream zipIn, String filePath) throws IOException {
        this.debug("extractFile (ZipInputStream," + filePath + ")");
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(filePath));
        byte[] bytesIn = new byte[4096];
        int read = 0;
        while ((read = zipIn.read(bytesIn)) != -1) {
            bos.write(bytesIn, 0, read);
        }
        bos.close();
    }

    public void unZipIt(String zipFile, String outputFolder) throws IOException {
        this.debug("unZipIt (" + zipFile + "," + outputFolder + ")");
        File destDir = new File(outputFolder);
        if (!destDir.exists()) {
            destDir.mkdir();
        }
        ZipInputStream zipIn = new ZipInputStream(new FileInputStream(zipFile));
        ZipEntry entry = zipIn.getNextEntry();
        while (entry != null) {
            String filePath = outputFolder + File.separator + entry.getName();
            if (!entry.isDirectory()) {
                this.extractFile(zipIn, filePath);
            } else {
                File dir = new File(filePath);
                dir.mkdir();
            }
            zipIn.closeEntry();
            entry = zipIn.getNextEntry();
        }
        zipIn.close();
        this.debug("unZipIt (" + zipFile + "," + outputFolder + ") done");
    }

    public void zipIt(String zipFile) {
        this.debug("zipIt (String)");
        byte[] buffer = new byte[1024];
        try {
            FileOutputStream fos = new FileOutputStream(zipFile);
            ZipOutputStream zos = new ZipOutputStream(fos);
            this.debug("Output to Zip : " + zipFile);
            if (trace.getDebugCode("wizard")) {
                trace.out("wizard", "LMSConfiguration.getFileList():\n" + this.LMSConfiguration.getFileList().toString().replaceAll(",", "\n "));
            }
            for (CTATFileEntry file : this.LMSConfiguration.getFileList()) {
                int len;
                file.makeSafe();
                this.debug("Adding file : " + file.filePath + " ...");
                String prefix = "";
                if (!file.getIsSystemEntry().booleanValue()) {
                    prefix = "ctatcontent/";
                }
                ZipEntry ze = null;
                if (!file.relativePath.isEmpty()) {
                    this.debug("Trying to add: (subfolder entry): " + file.relativePath + file.filePath);
                    ze = new ZipEntry(prefix + file.relativePath + file.filePath);
                } else {
                    this.debug("Trying to add (root entry): " + prefix + file.filePath);
                    ze = new ZipEntry(prefix + file.filePath);
                }
                zos.putNextEntry(ze);
                FileInputStream in = null;
                in = !file.fullPath.isEmpty() ? new FileInputStream(file.fullPath) : new FileInputStream(file.basePath + "/" + file.filePath);
                while ((len = in.read(buffer)) > 0) {
                    zos.write(buffer, 0, len);
                }
                in.close();
            }
            zos.closeEntry();
            zos.close();
            this.debug("Done");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public Boolean generatePackage(File outputZip) {
        this.debug("generatePackage ()");
        return true;
    }

    public String createManifest() {
        this.debug("createManifest ()");
        StringBuffer formatter = new StringBuffer();
        formatter.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        formatter.append("<Package name=\"" + this.LMSConfiguration.getName() + "\" label=\"" + this.LMSConfiguration.getName().toLowerCase() + "\" description=\"" + this.LMSConfiguration.getName().toLowerCase() + "\" tutor_type=\"server\">");
        formatter.append("<Problems>");
        String[] intList = this.LMSConfiguration.getInterfaceFiles();
        String[] brdList = this.LMSConfiguration.getBrdFiles();
        for (int i = 0; i < intList.length; ++i) {
            String anInterface = intList[i];
            String aBRD = brdList[i];
            formatter.append("<Problem name=\"" + i + "\" label=\"Problem" + i + "\" description=\"" + i + "\" tutor_flag=\"tutor\" problem_file=\"" + new File(aBRD).getName() + "\" student_interface=\"" + new File(anInterface).getName() + "\">");
            formatter.append("<Skills>");
            formatter.append("</Skills>");
            formatter.append("</Problem>");
        }
        formatter.append("</Problems>");
        formatter.append("<ProblemSets>");
        formatter.append("</ProblemSets>");
        formatter.append("<Assets>");
        formatter.append("</Assets>");
        formatter.append("</Package>");
        return formatter.toString();
    }

    protected Boolean cleanup() {
        this.debug("cleanup ()");
        for (int i = 0; i < this.tempFiles.size(); ++i) {
            File tempFile = this.tempFiles.get(i);
            this.debug("Removing : " + tempFile.getName());
            if (tempFile.delete()) continue;
            this.debug("Unable to remove temp file");
        }
        return false;
    }
}

