/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss;

import aima.search.framework.Successor;
import aima.search.framework.SuccessorFunction;
import edu.cmu.pact.jess.SimStRete;
import edu.cmu.pact.miss.AmlRete;
import edu.cmu.pact.miss.Instruction;
import edu.cmu.pact.miss.LhsState;
import edu.cmu.pact.miss.SimSt;
import edu.cmu.pact.miss.WMEConstraintPredicate;
import edu.cmu.pact.miss.WmeConstraint;
import edu.cmu.pact.miss.WmePath;
import edu.cmu.pact.miss.WmePathNode;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import jess.Fact;
import jess.JessException;
import jess.Value;

public class LhsSearchSuccessorFn
implements SuccessorFunction {
    private boolean generalWmePaths;
    private AmlRete rete = new AmlRete();
    private Vector constraintPredicates;
    private Vector wmeList = new Vector();
    private Vector instructions;
    private Vector instructionsCdr;
    SimStRete ssRete;
    final int FOA_NIL = 1;
    final int FOA_NOT_NIL = -1;
    final int FOA_BOTH = 0;

    AmlRete getRete() {
        return this.rete;
    }

    private void initRete(String wmeTypeFile, String initalWmeFile, String wmeStructureFile) {
        wmeTypeFile = wmeTypeFile.replace('\\', '/');
        initalWmeFile = initalWmeFile.replace('\\', '/');
        wmeStructureFile = wmeStructureFile.replace('\\', '/');
        try {
            this.getRete().reset();
            this.getRete().readFile(wmeTypeFile);
            this.getRete().readFile(initalWmeFile);
            this.getRete().loadWMEStructureFromFile(wmeStructureFile);
        }
        catch (JessException e) {
            e.printStackTrace();
        }
    }

    private void addWmeList(Fact fact) {
        this.wmeList.add(fact);
    }

    private void initWmeList(Instruction instruction) {
        Iterator facts = this.getRete().listFacts();
        while (facts.hasNext()) {
            this.addWmeList((Fact)facts.next());
        }
    }

    private Vector getInstructions() {
        return this.instructions;
    }

    private Instruction getFirstInstruction() {
        return (Instruction)this.getInstructions().elementAt(0);
    }

    private Vector getInstructionsCdr() {
        return this.instructionsCdr;
    }

    private void setInstructions(Vector instructions) {
        this.instructions = instructions;
        this.instructionsCdr = (Vector)instructions.clone();
        this.instructionsCdr.remove(0);
    }

    private void setSsRete(SimStRete ssRete) {
        this.ssRete = ssRete;
    }

    private SimStRete getSsRete() {
        return this.ssRete;
    }

    public LhsSearchSuccessorFn(String wmeTypeFile, String initialWmeFile, String wmeStructureFile, Vector instructions, Vector constraintPredicates, boolean generalWmePaths, SimStRete ssRete) {
        this.setSsRete(ssRete);
        this.generalWmePaths = generalWmePaths;
        try {
            this.getRete().reset();
        }
        catch (JessException e) {
            e.printStackTrace();
        }
        this.parse(wmeTypeFile);
        this.parse(initialWmeFile);
        this.loadWMEStructureFromReader(wmeStructureFile);
        this.initWmeList((Instruction)instructions.get(0));
        this.setInstructions(instructions);
        this.constraintPredicates = constraintPredicates;
    }

    public void parse(String fileName) {
        ClassLoader cl = this.getClass().getClassLoader();
        InputStream is = cl.getResourceAsStream(fileName);
        InputStreamReader isr = new InputStreamReader(is);
        BufferedReader br = new BufferedReader(isr);
        try {
            this.getRete().parse(br, false);
        }
        catch (JessException e) {
            e.printStackTrace();
        }
    }

    public void loadWMEStructureFromReader(String fileName) {
        ClassLoader cl = this.getClass().getClassLoader();
        InputStream is = cl.getResourceAsStream(fileName);
        InputStreamReader isr = new InputStreamReader(is);
        BufferedReader br = new BufferedReader(isr);
        this.getRete().loadWMEStructureFromReader(br);
    }

    private int getFoaOrderInWmePath(Instruction inst, String targetWme) {
        int returnValue = -1;
        for (int i = 0; i < inst.numFocusOfAttention(); ++i) {
            String str = inst.getFocusOfAttention(i);
            String[] token = str.split("\\|");
            if (!token[1].equals(inst.getInstructionValue(targetWme))) continue;
            returnValue = i;
        }
        return returnValue;
    }

    int getFoaValueConstraint(String targetWme, Vector<Instruction> instrunctions) {
        int returnValue = 1;
        boolean firstIteration = true;
        int order = this.getFoaOrderInWmePath((Instruction)this.instructions.get(0), targetWme);
        for (Instruction inst : instrunctions) {
            int curValue;
            String currentValue = inst.getValues().get(order).toString();
            this.getSsRete();
            int n = curValue = SimStRete.isNilVal(currentValue) ? 1 : -1;
            if (firstIteration) {
                returnValue = curValue;
                firstIteration = false;
                continue;
            }
            if (returnValue == curValue) continue;
            returnValue = 0;
            break;
        }
        return returnValue;
    }

    private String appendFoaConstraint(int foaConstraint, String wmeNilValue) {
        String returnValue = foaConstraint == 1 ? "&" + wmeNilValue : (foaConstraint == -1 ? "&~" + wmeNilValue : "");
        return returnValue;
    }

    private String getNewValueForFoa(String targetWme) {
        Instruction inst = (Instruction)this.getInstructions().get(0);
        int foaConstraintCategory = this.getFoaValueConstraint(targetWme, this.getInstructions());
        String nilVal = this.ssRete.nilValue(inst.getInstructionValue(targetWme));
        String newValue = this.appendFoaConstraint(foaConstraintCategory, nilVal);
        int orderInWmePath = this.getFoaOrderInWmePath((Instruction)this.getInstructions().get(0), targetWme);
        String genVal = "?val" + --orderInWmePath;
        newValue = genVal + newValue;
        return newValue;
    }

    public final List getSuccessors(Object object) {
        ArrayList<Successor> successors = new ArrayList<Successor>();
        LhsState lhs = (LhsState)object;
        String targetWme = lhs.nextTargetWme();
        if (targetWme == null && !SimSt.isRunningOutOfTime("LHS")) {
            return successors;
        }
        int numWmeDone = lhs.numWmeProcessed();
        Vector wmePaths = this.findWmePaths(targetWme);
        String newValue = this.getNewValueForFoa(targetWme);
        for (WmePath wmePath : wmePaths) {
            if (!this.isMakeSence(wmePath, this.getInstructionsCdr(), numWmeDone)) continue;
            Vector satisfiableWMEs = this.testWMEConstraint(lhs, wmePath, this.getInstructions());
            Vector Csw = this.powerSet(satisfiableWMEs);
            for (int i = 0; i < Csw.size(); ++i) {
                Vector constSet = (Vector)Csw.get(i);
                WmePathNode lastNode = wmePath.getLastNode();
                try {
                    Value gValue = new Value(newValue, 2);
                    lastNode.getWme().setSlotValue("value", gValue);
                }
                catch (JessException e) {
                    e.printStackTrace();
                }
                LhsState child = this.makeLhsState(lhs, wmePath, constSet);
                String action = this.actionStr(wmePath, constSet);
                Successor s = new Successor(action, (Object)child);
                successors.add(0, s);
            }
        }
        return successors;
    }

    private Vector powerSet(Vector satisfiableWMEs) {
        Vector wmeConsts = new Vector();
        Vector consts = satisfiableWMEs;
        int numConst = consts.size();
        for (int i = (1 << numConst) - 1; i > -1; --i) {
            Vector<WmeConstraint> tmpConst = new Vector<WmeConstraint>();
            for (int j = 0; j < numConst; ++j) {
                if ((i & 1 << j) == 0) continue;
                tmpConst.add((WmeConstraint)consts.get(j));
            }
            wmeConsts.add(tmpConst);
        }
        return wmeConsts;
    }

    private Vector testWMEConstraint(LhsState lhs, WmePath wmePath, Vector instructions) {
        Vector constrs = this.findWmeConstraints(lhs, wmePath);
        Vector<WmeConstraint> res = new Vector<WmeConstraint>();
        for (int i = 0; i < constrs.size(); ++i) {
            WmeConstraint constr = (WmeConstraint)constrs.get(i);
            if (!this.isGoodConstraint(lhs, constr)) continue;
            res.add(constr);
        }
        return res;
    }

    private boolean isGoodConstraint(LhsState lhs, WmeConstraint constr) {
        boolean test = true;
        Vector instructions = this.getInstructions();
        for (int i = 0; i < instructions.size(); ++i) {
            Instruction instruction = (Instruction)instructions.get(i);
            Fact[] args = this.identifyWmePathNode(constr, lhs, instruction);
            if (constr.apply(args)) continue;
            test = false;
            break;
        }
        return test;
    }

    private String actionStr(WmePath wmePath, Vector cv) {
        String str = wmePath.toString();
        for (int i = 0; i < cv.size(); ++i) {
            WmeConstraint wmeConst = (WmeConstraint)cv.get(i);
            str = str + "|" + wmeConst;
        }
        return str;
    }

    private Vector allSetsOfWmeConstraints(LhsState lhs, WmePath wmePath) {
        Vector wmeConsts = new Vector();
        Vector consts = this.findWmeConstraints(lhs, wmePath);
        int numConst = consts.size();
        for (int i = (1 << numConst) - 1; i > -1; --i) {
            Vector<WmeConstraint> tmpConst = new Vector<WmeConstraint>();
            for (int j = 0; j < numConst; ++j) {
                if ((i & 1 << j) == 0) continue;
                tmpConst.add((WmeConstraint)consts.get(j));
            }
            wmeConsts.add(tmpConst);
        }
        return wmeConsts;
    }

    private Vector findWmeConstraints(LhsState lhs, WmePath wmePath) {
        Vector<WmeConstraint> constraints = new Vector<WmeConstraint>();
        if (lhs.numWmePath() > 0) {
            WmePathNode leafNode = wmePath.getLastNode();
            for (int i = 0; i < lhs.numWmePath(); ++i) {
                WmePath lhsWmePath = lhs.getWmePath(i);
                WmePathNode lhsLeafNode = lhsWmePath.getLastNode();
                if (!lhsLeafNode.hasSameSymbol(leafNode) && lhsLeafNode.hasSameWmeType(leafNode)) {
                    for (int k = 0; k < this.constraintPredicates.size(); ++k) {
                        WmePathNode[] args = new WmePathNode[]{lhsLeafNode, leafNode};
                        WmeConstraint wmeConst = new WmeConstraint(this.getRete(), (WMEConstraintPredicate)this.constraintPredicates.get(k), args);
                        constraints.add(wmeConst);
                    }
                }
                for (int j = i + 1; j < lhs.numWmePath(); ++j) {
                    WmePath lhsWmePathJ = lhs.getWmePath(j);
                    WmePathNode lhsLeafNodeJ = lhsWmePathJ.getLastNode();
                    if (lhsLeafNode.hasSameSymbol(lhsLeafNodeJ) || !lhsLeafNode.hasSameWmeType(lhsLeafNodeJ)) continue;
                    for (int k = 0; k < this.constraintPredicates.size(); ++k) {
                        WmePathNode[] args = new WmePathNode[]{lhsLeafNode, lhsLeafNodeJ};
                        WmeConstraint wmeConst = new WmeConstraint(this.getRete(), (WMEConstraintPredicate)this.constraintPredicates.get(k), args);
                        constraints.add(wmeConst);
                    }
                }
            }
        }
        return constraints;
    }

    private Vector findWmePaths(String targetWme) {
        Vector<WmePath> paths = new Vector<WmePath>();
        StringTokenizer seedTokenizer = new StringTokenizer(targetWme, "|");
        String wmeType = seedTokenizer.nextToken();
        String wmeName = seedTokenizer.nextToken();
        Vector curPathSet = this.getRete().getWmePath(wmeType, wmeName);
        WmePath path = (WmePath)curPathSet.get(0);
        paths.add(path);
        int pathLength = 1 << path.length();
        for (int i = 2; i < pathLength; i += 2) {
            WmePath generalizedPath = path.generalize(i);
            if (generalizedPath == null) continue;
            if (this.generalWmePaths) {
                paths.add(0, generalizedPath);
                continue;
            }
            paths.add(generalizedPath);
        }
        return paths;
    }

    private boolean testConstraints(LhsState lhs, Vector constraints, Vector instructions) {
        boolean test = true;
        for (int i = 0; i < instructions.size(); ++i) {
            Instruction instruction = (Instruction)instructions.get(i);
            if (this.testConstraints(lhs, constraints, instruction)) continue;
            test = false;
            break;
        }
        return test;
    }

    private boolean testConstraints(LhsState lhs, Vector constraints, Instruction instruction) {
        boolean test = true;
        for (int i = 0; i < constraints.size(); ++i) {
            Fact[] args;
            WmeConstraint theConst = (WmeConstraint)constraints.get(i);
            if (theConst.apply(args = this.identifyWmePathNode(theConst, lhs, instruction))) continue;
            test = false;
            break;
        }
        return test;
    }

    private Fact[] identifyWmePathNode(WmeConstraint constraint, LhsState lhs, Instruction instruction) {
        Fact[] target = new Fact[constraint.getArity()];
        for (int i = 0; i < constraint.getArity(); ++i) {
            WmePathNode wmePathNode = constraint.getNthArg(i);
            int wmePathIndex = lhs.wmePathIndexOf(wmePathNode);
            if (wmePathIndex == -1) {
                wmePathIndex = lhs.numWmeProcessed();
            }
            if (++wmePathIndex == instruction.numFocusOfAttention()) {
                wmePathIndex = 0;
            }
            String targetFoA = instruction.getFocusOfAttention(wmePathIndex);
            int delimIndex = targetFoA.lastIndexOf(124);
            String wmeTypeName = targetFoA.substring(0, delimIndex);
            delimIndex = wmeTypeName.indexOf(124);
            String wmeType = wmeTypeName.substring(0, delimIndex);
            String wmeName = wmeTypeName.substring(delimIndex + 1);
            target[i] = this.getRete().lookupWme(wmeType, wmeName);
        }
        return target;
    }

    private boolean isMakeSence(WmePath wmePath, Vector instructions, int numWmeProcessed) {
        boolean theAnswer = true;
        Iterator instructionIterator = instructions.iterator();
        try {
            while (instructionIterator.hasNext()) {
                Instruction instruction = (Instruction)instructionIterator.next();
                if (this.isMakeSence(wmePath, instruction, numWmeProcessed)) continue;
                theAnswer = false;
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return theAnswer;
    }

    private boolean isMakeSence(WmePath wmePath, Instruction instruction, int numWmeProcessed) throws Exception {
        String targetWme = null;
        Vector seeds = instruction.getSeeds();
        if (numWmeProcessed < seeds.size()) {
            targetWme = (String)seeds.get(numWmeProcessed);
            targetWme = targetWme.substring(0, targetWme.lastIndexOf(124));
        } else if (numWmeProcessed == seeds.size()) {
            targetWme = instruction.getSelection();
        } else {
            throw new Exception("numWmeProceed out of index");
        }
        String wmeType = targetWme.substring(0, targetWme.indexOf(124));
        String wmeName = targetWme.substring(targetWme.indexOf(124) + 1);
        Vector wmePathVector = this.getRete().getWmePath(wmeType, wmeName);
        WmePath targetWmePath = (WmePath)wmePathVector.get(0);
        boolean test = wmePath.isUnifiable(targetWmePath);
        return test;
    }

    private LhsState makeLhsState(LhsState parent, WmePath path) {
        return this.makeLhsState(parent, path, null);
    }

    private LhsState makeLhsState(LhsState parent, WmePath path, Vector constraint) {
        LhsState child = (LhsState)parent.clone();
        child.addWmePath(path);
        child.addWmeConstraint(constraint);
        return child;
    }
}

