/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.ctat.model;

import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.CTATFunctions;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemModel;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.MessageObject;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Pattern;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class StartStateModel
implements Cloneable {
    public static final String SAME = "same";
    public static final String DIFFER = "differ";
    public static final String WIDGET_TYPE = "WidgetType";
    private static final String COMM_NAME = "CommName";
    private static final String GROUP = "group";
    private static final String CELL = "TableCell";
    private static final String SYSTEM = "system";
    private static final String SERIALIZED = "serialized";
    private static final String OMIT_FROM_BRD_START_STATE = "OmitFromBRDStartState";
    private LinkedHashMap<String, MessageObject> interfaceDescriptionsFromInterface = new LinkedHashMap();
    private List<MessageObject> nonInteractiveInterfaceActionsFromInterface = new ArrayList<MessageObject>();
    private List<MessageObject> otherMsgsFromInterface = new ArrayList<MessageObject>();
    private LinkedHashMap<String, MessageObject> interfaceDescriptionsToAdd = new LinkedHashMap();
    private Set<MessageObject> interfaceDescriptionsToDiscard = new HashSet<MessageObject>();
    private boolean userBeganStartStateEdit = false;
    private PropertyChangeSupport pcSupport = new PropertyChangeSupport(this);
    private final LinkedHashSet<String> systemSelectionNames;
    private final LinkedHashSet<String> defaultActionNames;
    private Map<String, Set<String>> selectionToActionNamesMap = new LinkedHashMap<String, Set<String>>();
    private Set<String> otherMsgsToDiscard = new LinkedHashSet<String>();
    private static final Map<String, Boolean> SinglesTypes = new HashMap<String, Boolean>();
    private static MsgComparator msgComparator;
    private static Set<String> msgTypesToOmitFromStartState;
    private static final XMLOutputter xmlOutputter;

    public StartStateModel(List<String> systemSelectionNames, List<String> defaultActionNames) {
        this.systemSelectionNames = new LinkedHashSet<String>(systemSelectionNames);
        this.defaultActionNames = new LinkedHashSet<String>(defaultActionNames);
    }

    public String toString() {
        return "StartStateModel: IntDescs from int " + (this.interfaceDescriptionsFromInterface == null ? "null" : Integer.valueOf(this.interfaceDescriptionsFromInterface.size())) + ", ~ to add " + (this.interfaceDescriptionsToAdd == null ? "null" : Integer.valueOf(this.interfaceDescriptionsToAdd.size())) + ", ~ to discard " + (this.interfaceDescriptionsToDiscard == null ? "null" : Integer.valueOf(this.interfaceDescriptionsToDiscard.size())) + ", IntActs from int " + (this.nonInteractiveInterfaceActionsFromInterface == null ? "null" : Integer.valueOf(this.nonInteractiveInterfaceActionsFromInterface.size())) + ", others from int " + (this.otherMsgsFromInterface == null ? "null" : Integer.valueOf(this.otherMsgsFromInterface.size())) + ", ~ to discard " + (this.otherMsgsToDiscard == null ? "null" : Integer.valueOf(this.otherMsgsToDiscard.size()));
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcSupport.removePropertyChangeListener(listener);
    }

    public StartStateModel clone() {
        try {
            return (StartStateModel)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            cnse.printStackTrace();
            return null;
        }
    }

    public boolean addStudentInterfaceMessage(MessageObject mo) {
        boolean result = this.addStudentInterfaceMessageInternal(mo, true);
        if (result) {
            this.pcSupport.firePropertyChange("Student Interface message added", null, mo);
        }
        return result;
    }

    private boolean addStudentInterfaceMessageInternal(MessageObject mo, boolean interactive) {
        if (trace.getDebugCode("startstate")) {
            trace.out("startstate", "SSM.addStuIntMsgInt(" + mo.summary() + ") isProper " + StartStateModel.isProperStartStateMessage(mo, new Boolean[0]));
        }
        if (trace.getDebugCode("startstateverbose")) {
            trace.out("startstate", "SSM.addStuIntMsgInt() msg:\n  " + mo.toXML());
        }
        if (!StartStateModel.isProperStartStateMessage(mo, new Boolean[0])) {
            return false;
        }
        String msgType = mo.getMessageType();
        if ("InterfaceDescription".equalsIgnoreCase(msgType)) {
            this.addInterfaceDescriptionFromInterface(mo);
        } else if ("InterfaceAction".equalsIgnoreCase(msgType) || "UntutoredAction".equalsIgnoreCase(msgType)) {
            if (trace.getDebugCode("startstate")) {
                trace.out("startstate", "SSM.addStuIntMsgInt(" + interactive + ") " + mo.summary());
            }
            this.addInterfaceActionFromInterface(mo, interactive);
        } else {
            this.addOtherMessageFromInterface(mo);
        }
        return true;
    }

    private synchronized void addOtherMessageFromInterface(MessageObject mo) {
        this.otherMsgsFromInterface.add(mo);
    }

    private synchronized void addInterfaceActionFromInterface(MessageObject mo, boolean interactive) {
        if (interactive) {
            this.otherMsgsFromInterface.add(mo);
        } else {
            String moStr = mo.toXML();
            boolean hasMassProdRef = ProblemModel.hasMassProductionVarPattern(moStr);
            if (!hasMassProdRef) {
                mo.setProperty(OMIT_FROM_BRD_START_STATE, true);
            }
            if (trace.getDebugCode("startstate")) {
                trace.out("startstate", "SSM.addIntActFromInterface(" + mo.summary() + ", " + interactive + ") **hasMassProdRef " + hasMassProdRef);
            }
            this.nonInteractiveInterfaceActionsFromInterface.add(mo);
        }
    }

    private synchronized void addInterfaceDescriptionFromInterface(MessageObject mo) {
        String name = this.getInstanceName(mo);
        if (name == null) {
            trace.err("StartStateModel.addInterfaceDescFromInterface(): no instance name (commName) found; message:\n  " + mo);
        } else {
            String key = name.toLowerCase();
            this.interfaceDescriptionsFromInterface.put(key, mo);
            this.selectionToActionNamesMap.put(key, this.getActionNamesFromInterfaceDescription(mo));
        }
    }

    private Set<String> getActionNamesFromInterfaceDescription(MessageObject mo) {
        Element tier0 = (Element)mo.getProperty(SERIALIZED);
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        if (tier0 == null) {
            return result;
        }
        int i = 0;
        int k = 0;
        for (Element tier1 : tier0.getChildren()) {
            List list2;
            if ("SAIs".equals(tier1.getName()) && (list2 = tier1.getChildren()).size() >= 1) {
                Element tier2 = (Element)list2.get(0);
                k = 0;
                for (Element saiElt : tier2.getChildren()) {
                    String action = this.getActionFromSAIElement(saiElt);
                    if (action != null) {
                        result.add(action);
                    }
                    ++k;
                }
            }
            ++i;
        }
        return result;
    }

    private String getActionFromSAIElement(Element saiElt) {
        int i = 0;
        for (Element actionElt : saiElt.getChildren()) {
            if ("action".equals(actionElt.getName())) {
                String action = actionElt.getValue();
                return action;
            }
            ++i;
        }
        return null;
    }

    private String getInstanceName(MessageObject mo) {
        String commName = (String)mo.getProperty(COMM_NAME);
        if (!(commName != null && commName.length() >= 1 || (commName = (String)mo.getProperty("DorminName")) != null && commName.length() >= 1)) {
            return null;
        }
        return commName;
    }

    public String compareStartStateMessages(ProblemModel pm) {
        if (pm == null) {
            return "";
        }
        List<CompareInterfaceDescriptions> compareList = this.compareInterfaceDescriptionMessages(pm);
        return this.compareListToHtmlTable(compareList);
    }

    private String compareListToHtmlTable(List<CompareInterfaceDescriptions> compareList) {
        if (compareList == null) {
            return null;
        }
        Collections.sort(compareList);
        StringBuilder sb = new StringBuilder("<html><p>Comparing component settings between the graph and user interface:</p>");
        sb.append("<br />\n<table cellpadding=\"1\" cell spacing=\"1\" border=\"1\">");
        sb.append("\n").append(new CompareInterfaceDescriptions(null).toHtmlHeader());
        for (CompareInterfaceDescriptions cid : compareList) {
            sb.append("\n").append(cid.toHtmlRow());
        }
        sb.append("\n").append("</table></html>");
        return sb.toString();
    }

    public List<CompareInterfaceDescriptions> compareInterfaceDescriptionMessages(ProblemModel pm) {
        if (this.interfaceDescriptionsFromInterface == null) {
            return null;
        }
        ArrayList<CompareInterfaceDescriptions> result = new ArrayList<CompareInterfaceDescriptions>();
        Map siDescs = (Map)this.interfaceDescriptionsFromInterface.clone();
        Iterator<MessageObject> it = pm.startNodeMessagesIteratorForStartStateModel();
        while (it.hasNext()) {
            MessageObject msg = it.next();
            if (!"InterfaceDescription".equalsIgnoreCase(msg.getMessageType())) continue;
            CompareInterfaceDescriptions cid = new CompareInterfaceDescriptions(msg);
            if (cid.pmCommName != null) {
                MessageObject siDesc = (MessageObject)siDescs.remove(cid.pmCommName.toLowerCase());
                try {
                    cid.setStudentInterfaceFields(siDesc);
                }
                catch (WidgetTypeException wte) {
                    trace.err("Component type mismatch in " + pm.getProblemName() + ": " + wte);
                    cid.setAlert("A component with this name has a different type in the student interface.");
                    CompareInterfaceDescriptions cidSI = new CompareInterfaceDescriptions(null);
                    cidSI.setStudentInterfaceFields(siDesc);
                    cidSI.setAlert("A component setting for this name has a different type in the graph.");
                    result.add(cidSI);
                }
            }
            result.add(cid);
            if (!trace.getDebugCode("startstate")) continue;
            trace.out("startstate", "SSM.compareIDMsgs() from graph " + cid);
        }
        for (String siCommName : siDescs.keySet()) {
            CompareInterfaceDescriptions cid = new CompareInterfaceDescriptions(null);
            cid.setStudentInterfaceFields((MessageObject)siDescs.get(siCommName));
            result.add(cid);
            if (!trace.getDebugCode("startstate")) continue;
            trace.out("startstate", "SSM.compareIDMsgs() from iface " + cid);
        }
        return result;
    }

    public Iterator<MessageObject> startNodeMessagesIterator(ProblemModel pm) {
        LinkedList<MessageObject> result = this.createStartStateMessageListInternal(pm, false, false);
        if (trace.getDebugCode("startstate")) {
            trace.out("startstate", "SSM.startNodeMessagesIterator() list size " + result.size());
        }
        return result.iterator();
    }

    public Vector<MessageObject> createStartStateMessageList(ProblemModel pm, boolean wantInterfaceDescriptions) {
        return this.createStartStateMessageList(pm, wantInterfaceDescriptions, false);
    }

    private Vector<MessageObject> createStartStateMessageList(ProblemModel pm, boolean wantInterfaceDescriptions, boolean preferUI) {
        Vector<MessageObject> result = new Vector<MessageObject>(this.createStartStateMessageListInternal(pm, wantInterfaceDescriptions, preferUI));
        if (trace.getDebugCode("startstate")) {
            trace.out("startstate", "SSM.createStartStateMessageList() list size " + result.size());
        }
        return result;
    }

    private synchronized LinkedList<MessageObject> createStartStateMessageListInternal(ProblemModel pm, boolean wantInterfaceDescriptions, boolean preferUI) {
        String key;
        if (trace.getDebugCode("startstate")) {
            trace.printStack("startstate", "SSM.createSSMsgListInternal(" + (pm == null ? null : pm.getProblemFullName()) + ", " + wantInterfaceDescriptions + ", " + preferUI + ")");
        }
        if (wantInterfaceDescriptions) {
            this.chooseAllInterfaceDescriptionsFromInterface();
        } else if (!pm.getStartNodeCreatedFlag()) {
            this.preloadDefaultInterfaceDescriptions(pm);
        }
        LinkedHashSet<String> interfaceActionKeys = new LinkedHashSet<String>();
        LinkedHashSet<String> untutoredActionKeys = new LinkedHashSet<String>();
        HashMap<String, MessageObject> startAndEnd = new HashMap<String, MessageObject>();
        LinkedList<MessageObject> result = new LinkedList<MessageObject>();
        Iterator<MessageObject> uiIter = this.nonInteractiveInterfaceActionsFromInterface.iterator();
        Iterator<MessageObject> pmIter = pm.startNodeMessagesIteratorForStartStateModel();
        Iterator<MessageObject> currIter = preferUI ? pmIter : uiIter;
        for (int nIter = 0; nIter < 2; ++nIter) {
            while (currIter.hasNext()) {
                MessageObject mo = currIter.next();
                if (trace.getDebugCode("startstate")) {
                    trace.out("startstate", "SSM.createSSMsgListInt()[" + nIter + "] from " + (currIter == pmIter ? "pmIter" : "uiIter") + ": " + mo.summary());
                }
                this.dumpSerialized(mo);
                if (this.toBeDiscarded(mo, currIter == pmIter)) continue;
                key = this.getInterfaceActionKey(mo);
                if (key != null) {
                    interfaceActionKeys.add(key);
                } else {
                    key = this.getUntutoredActionKey(mo);
                    if (key != null) {
                        untutoredActionKeys.add(key);
                    }
                }
                result.add(mo);
            }
            currIter = currIter == pmIter ? uiIter : pmIter;
        }
        Iterator<Object> it = this.interfaceDescriptionsToAdd.keySet().iterator();
        while (it.hasNext()) {
            String key2 = it.next();
            MessageObject mo = this.interfaceDescriptionsToAdd.get(key2);
            if (trace.getDebugCode("startstate")) {
                trace.out("startstate", "SSM.createSSMsgListInt() from intDescsToAdd: " + mo.summary());
            }
            result.add(mo);
            it.remove();
        }
        for (MessageObject mo : this.otherMsgsFromInterface) {
            key = this.getInterfaceActionKey(mo);
            if (key != null) {
                interfaceActionKeys.add(key);
            } else {
                key = this.getUntutoredActionKey(mo);
                if (key != null) {
                    untutoredActionKeys.add(key);
                }
            }
            if (trace.getDebugCode("startstate")) {
                trace.out("startstate", "SSM.createSSMsgListInt() from othMsgsToAdd: " + mo.summary());
            }
            result.add(mo);
        }
        int i = 0;
        int j = 0;
        ListIterator li = result.listIterator(result.size());
        while (li.hasPrevious()) {
            MessageObject mo = (MessageObject)li.previous();
            if (this.recordLastSingles(mo, startAndEnd)) {
                li.remove();
                ++j;
            } else {
                String key3 = this.getInterfaceActionKey(mo);
                if (key3 != null && !interfaceActionKeys.remove(key3)) {
                    ++j;
                    li.remove();
                    if (trace.getDebugCode("startstate")) {
                        trace.out("startstate", "SSM.createSSMsgListInt() removing IntAct " + mo.summary());
                    }
                } else {
                    key3 = this.getUntutoredActionKey(mo);
                    if (key3 != null && !untutoredActionKeys.remove(key3)) {
                        ++j;
                        li.remove();
                        if (trace.getDebugCode("startstate")) {
                            trace.out("startstate", "SSM.createSSMsgListInt() removing UntutoredAct " + mo.summary());
                        }
                    } else if (this.otherMsgsToDiscard.contains(mo.summary())) {
                        li.remove();
                        ++j;
                        if (trace.getDebugCode("startstate")) {
                            trace.out("startstate", "SSM.createSSMsgListInt() discarding other msg " + mo.summary());
                        }
                    }
                }
            }
            ++i;
        }
        j -= this.addSingles(result, startAndEnd, pm);
        if (trace.getDebugCode("startstate")) {
            trace.out("startstate", "SSM.createSSMsgListInt() removed " + j + " of " + i + " msgs");
        }
        Collections.sort(result, msgComparator);
        if (trace.getDebugCode("startstate")) {
            int k = 0;
            trace.out("startstate", String.format("SSM.createSSMsgListInt() returns %d msgs:\n", result.size()));
            for (MessageObject mo : result) {
                System.out.printf("  [%2d] %s\n", k++, mo.summary());
            }
        }
        return result;
    }

    private void dumpSerialized(MessageObject mo) {
        if (!trace.getDebugCode("startstate")) {
            return;
        }
        Object srzObj = mo.getProperty(SERIALIZED);
        if (!(srzObj instanceof Element)) {
            trace.out("startstate", "dumpSerialized: missing <serialized> element in " + mo.summary());
        } else {
            Element srzElt = (Element)srzObj;
            List srzChildren = srzElt.getChildren();
            trace.out("startstate", String.format("dumpSerialized: serialized: <%s>, nChildren = %d", srzElt.getName(), srzChildren == null ? -1 : srzChildren.size()));
            Iterator attrs = srzElt.getAttributes().iterator();
            int i = 0;
            while (attrs.hasNext()) {
                Attribute attr = (Attribute)attrs.next();
                trace.out("startstate", String.format("  [%2d] %-17s = \"%s\"", i, attr.getName(), attr.getValue()));
                ++i;
            }
        }
    }

    private int addSingles(LinkedList<MessageObject> result, Map<String, MessageObject> startAndEnd, ProblemModel pm) {
        for (Map.Entry<String, Boolean> singleType : SinglesTypes.entrySet()) {
            if (!singleType.getValue().booleanValue() || startAndEnd.containsKey(singleType.getKey())) continue;
            MessageObject mo = MessageObject.create(singleType.getKey());
            if ("StartProblem".equalsIgnoreCase(singleType.getKey())) {
                mo.setProperty("ProblemName", pm.getProblemName());
            }
            startAndEnd.put(singleType.getKey(), mo);
        }
        if (trace.getDebugCode("startstate")) {
            trace.out("startstate", "SSM.addStartAndEnd() msgs to add: " + startAndEnd.values());
        }
        result.addAll(startAndEnd.values());
        return startAndEnd.size();
    }

    private int preloadDefaultInterfaceDescriptions(ProblemModel pm) {
        int m = this.interfaceDescriptionsToAdd.size();
        boolean getAll = pm.getController().getUniversalToolProxy().getStoreAllInterfaceDescriptions();
        for (Map.Entry<String, MessageObject> entry : this.interfaceDescriptionsFromInterface.entrySet()) {
            if (getAll) {
                this.interfaceDescriptionsToAdd.put(entry.getKey(), entry.getValue());
                continue;
            }
            String moStr = entry.getValue().toXML();
            boolean interpolatable = CTATFunctions.interpolatable(moStr);
            boolean hasMassProdRef = ProblemModel.hasMassProductionVarPattern(moStr);
            if (trace.getDebugCode("startstate")) {
                trace.out("startstate", String.format("SSM.preloadDefaultIntDescs(): %s interpolatable %b hasMassProdRef %b", entry.getValue().summary(), interpolatable, hasMassProdRef));
            }
            if (!interpolatable && !hasMassProdRef) continue;
            this.interfaceDescriptionsToAdd.put(entry.getKey(), entry.getValue());
        }
        int n = this.interfaceDescriptionsToAdd.size();
        if (trace.getDebugCode("startstate")) {
            trace.out("startstate", "SSM.preloadDefaultIntDescs(): UTP.storeAllInterfaceDescriptions " + getAll + "; interfaceDescriptionsToAdd.size() was " + m + ", now " + n);
        }
        return n;
    }

    private boolean recordLastSingles(MessageObject mo, Map<String, MessageObject> startAndEnd) {
        String msgType = mo.getMessageType();
        if (!SinglesTypes.containsKey(msgType)) {
            return false;
        }
        startAndEnd.put(msgType, mo);
        return true;
    }

    private String getUntutoredActionKey(MessageObject mo) {
        return this.getKeepOnlyLastActionKey(mo, "UntutoredAction");
    }

    private String getInterfaceActionKey(MessageObject mo) {
        return this.getKeepOnlyLastActionKey(mo, "InterfaceAction");
    }

    private String getKeepOnlyLastActionKey(MessageObject mo, String msgType) {
        Vector<String> selection;
        if (!msgType.equalsIgnoreCase(mo.getMessageType())) {
            return null;
        }
        Vector<String> action = mo.getAction();
        if (action == null || action.size() < 1) {
            return null;
        }
        String action0 = ((String)action.get(0)).toLowerCase();
        if ("AddPoint".equalsIgnoreCase(action0)) {
            return null;
        }
        if (action0.startsWith("updatetext")) {
            action0 = "updatetext";
        }
        if ((selection = mo.getSelection()) == null || selection.size() < 1) {
            return null;
        }
        return ((Object)selection).toString().toLowerCase() + ' ' + action0;
    }

    private boolean toBeDiscarded(MessageObject mo, boolean fromProblemModel) {
        return fromProblemModel && "InterfaceDescription".equalsIgnoreCase(mo.getMessageType()) && this.interfaceDescriptionsToDiscard.contains(mo);
    }

    public void problemModelUpdated(boolean updated) {
        if (!updated) {
            return;
        }
        this.nonInteractiveInterfaceActionsFromInterface.clear();
        this.otherMsgsFromInterface.clear();
        this.interfaceDescriptionsFromInterface.clear();
        this.selectionToActionNamesMap.clear();
    }

    public boolean setUserBeganStartStateEdit(boolean beginning) {
        boolean result = this.userBeganStartStateEdit;
        this.userBeganStartStateEdit = beginning;
        return result;
    }

    public void applyEditsToProblemModel(ProblemModel pm, List<CompareInterfaceDescriptions> cidList, String undoActionName) {
        this.applyEditsToProblemModel(pm, cidList, null, false, undoActionName);
    }

    public void reviseWithSettingsFromUI(ProblemModel pm, String undoActionName) {
        this.applyEditsToProblemModel(pm, null, null, true, undoActionName);
    }

    public void applyEditsToProblemModel(ProblemModel pm, Set<MessageObject> otherMsgsToDiscard, String undoActionName) {
        this.applyEditsToProblemModel(pm, null, otherMsgsToDiscard, false, undoActionName);
    }

    private void applyEditsToProblemModel(ProblemModel pm, List<CompareInterfaceDescriptions> cidList, Set<MessageObject> otherMsgsToDiscard, boolean preferUI, String undoActionName) {
        if (pm == null) {
            return;
        }
        this.applyInterfaceDescriptionEdits(cidList);
        this.discardMessages(otherMsgsToDiscard);
        pm.setStartNodeMessageVector(this.createStartStateMessageList(pm, false, preferUI));
        ActionEvent ae = new ActionEvent(this, 0, undoActionName);
        pm.getController().getUndoPacket().getCheckpointAction().actionPerformed(ae);
        this.clearEdits();
    }

    private void clearEdits() {
        this.interfaceDescriptionsToDiscard.clear();
        this.interfaceDescriptionsToAdd.clear();
        this.otherMsgsToDiscard.clear();
    }

    private void applyInterfaceDescriptionEdits(List<CompareInterfaceDescriptions> cidList) {
        if (cidList == null) {
            return;
        }
        this.interfaceDescriptionsToDiscard.clear();
        this.interfaceDescriptionsToAdd.clear();
        for (CompareInterfaceDescriptions cid : cidList) {
            if (cid.getPmCommName() != null && cid.getPmCommName().length() > 0 && cid.getChoice() != Choice.keepPM) {
                this.interfaceDescriptionsToDiscard.add(cid.pmMsg);
            }
            if (cid.getSiCommName() == null || cid.getSiCommName().length() <= 0 || cid.getChoice() != Choice.saveSI) continue;
            this.interfaceDescriptionsToAdd.put(cid.getSiCommName().toLowerCase(), cid.siMsg);
        }
    }

    public boolean isStartStateModified() {
        if (trace.getDebugCode("startstate")) {
            trace.out("startstate", "SSM.isStartStateModified() nToDiscard " + this.interfaceDescriptionsToDiscard.size() + ", nToAdd " + this.interfaceDescriptionsToAdd.size() + ", nOthers " + this.otherMsgsFromInterface.size());
        }
        return this.interfaceDescriptionsToDiscard.size() > 0 || this.interfaceDescriptionsToAdd.size() > 0 || this.otherMsgsFromInterface.size() > 0;
    }

    public void commitSISettings(MessageObject siMsg, ProblemModel pm) {
        CompareInterfaceDescriptions cid = new CompareInterfaceDescriptions(null);
        cid.setStudentInterfaceFields(siMsg);
        cid.setChoice(Choice.saveSI);
        if (trace.getDebugCode("startstate")) {
            trace.printStack("startstate", "commitSISettings() cid " + cid);
        }
        this.commitCID(cid, pm);
    }

    private void commitCID(CompareInterfaceDescriptions cid, ProblemModel pm) {
    }

    public int nInterfaceDescriptionsFromInterface() {
        int result = this.interfaceDescriptionsFromInterface.size();
        if (trace.getDebugCode("startstate")) {
            trace.printStack("startstate", "SSM.nInterfaceDescriptionsFromInterface() returns " + result);
        }
        return result;
    }

    public int chooseAllInterfaceDescriptionsFromInterface() {
        int m = this.interfaceDescriptionsToAdd.size();
        for (Map.Entry<String, MessageObject> entry : this.interfaceDescriptionsFromInterface.entrySet()) {
            this.interfaceDescriptionsToAdd.put(entry.getKey(), entry.getValue());
        }
        int n = this.interfaceDescriptionsToAdd.size();
        if (trace.getDebugCode("startstate")) {
            trace.out("startstate", "SSM.chooseAllIntDescsFrInt.interfaceDescriptionsToBeAdded.size() was " + m + ", now " + n);
        }
        return n;
    }

    public void addStudentInterfaceMessageBundle(List<MessageObject> messages) {
        int i = 0;
        for (MessageObject msg : messages) {
            if (trace.getDebugCode("startstate")) {
                trace.out("startstate", "SSM.addAllStuIntMsgs[" + i + "] " + msg.summary());
            }
            this.addStudentInterfaceMessageInternal(msg, false);
            ++i;
        }
        this.pcSupport.firePropertyChange("Student Interface messages added", null, messages);
    }

    public static boolean isProperStartStateMessage(MessageObject mo, Boolean ... forSavingToBRD) {
        Boolean omit;
        String msgType = mo.getMessageType();
        if (msgType == null) {
            return false;
        }
        if (forSavingToBRD != null && forSavingToBRD.length > 0 && forSavingToBRD[0].booleanValue() && (omit = mo.getPropertyAsBoolean(OMIT_FROM_BRD_START_STATE)) != null && omit.booleanValue()) {
            return false;
        }
        return !msgTypesToOmitFromStartState.contains(msgType.toLowerCase());
    }

    public Set<String> getComponentNames() {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (MessageObject mo : this.interfaceDescriptionsFromInterface.values()) {
            String groupName;
            String instName = this.getInstanceName(mo);
            if (instName != null) {
                result.add(instName);
            }
            if ((groupName = this.getGroupName(mo)) != null) {
                result.add(groupName);
            }
            result.addAll(this.getTableCellNames(mo));
            result.addAll(this.systemSelectionNames);
        }
        return result;
    }

    private List<String> getTableCellNames(MessageObject msg) {
        LinkedList<String> cellNames = new LinkedList<String>();
        if (!"InterfaceDescription".equalsIgnoreCase(msg.getMessageType())) {
            return cellNames;
        }
        Object widgetType = msg.getProperty(WIDGET_TYPE);
        if (!(widgetType instanceof String) || !((String)widgetType).endsWith("Table")) {
            return cellNames;
        }
        String tblName = this.getInstanceName(msg);
        if (!(tblName instanceof String) || tblName.length() < 1) {
            trace.err(String.format("Error reading %s message for Table component: invalid table name \"%s\"; msg:\n  %s", "InterfaceDescription", tblName, msg));
            return cellNames;
        }
        Object rows = msg.getProperty("Rows");
        Object cols = msg.getProperty("Columns");
        try {
            int nR = Integer.parseInt(rows.toString());
            int nC = Integer.parseInt(cols.toString());
            for (int c = 1; c <= nC; ++c) {
                for (int r = 1; r <= nR; ++r) {
                    cellNames.add(String.format("%s_C%dR%d", tblName, c, r));
                }
            }
        }
        catch (Exception e) {
            trace.err(String.format("Error reading %s message for Table component: cannot parse number of rows \"%s\" or columns \"%s\" as integer: %s, cause %s; msg:\n  %s", "InterfaceDescription", rows, cols, e, e.getCause(), msg));
        }
        return cellNames;
    }

    private String getGroupName(MessageObject mo) {
        Object serialized = mo.getProperty(SERIALIZED);
        Element typeRoot = null;
        Element parameters = null;
        Element selection = null;
        Element componentParameter2 = null;
        Element name = null;
        Element value = null;
        try {
            if (!(serialized instanceof Element)) {
                return null;
            }
            typeRoot = (Element)serialized;
            parameters = typeRoot.getChild("Parameters");
            if (trace.getDebugCode("startstate")) {
                trace.out("startstate", "SSM.getGroupName(" + mo.summary() + ") typeRoot " + trace.nh(typeRoot) + ", parameters " + trace.nh(parameters));
            }
            if (parameters == null) {
                return null;
            }
            selection = parameters.getChild("selection");
            List selectionChildren = selection.getChildren("CTATComponentParameter");
            for (Element componentParameter2 : selectionChildren) {
                name = componentParameter2.getChild("name");
                if (!(name instanceof Element) || !GROUP.equalsIgnoreCase(name.getText())) continue;
                value = componentParameter2.getChild("value");
                String result = value.getText();
                if (result == null || result.length() < 1) {
                    return null;
                }
                return result;
            }
        }
        catch (Exception e) {
            trace.err(String.format("Error getting group name from %s element: typeRoot %s, parameters %s, selection %s, componentParameter %s, name %s, value %s", trace.nh(serialized), typeRoot, parameters, selection, componentParameter2, name, value));
        }
        return null;
    }

    public Set<String> getActionNames(String selection) {
        if (trace.getDebugCode("editstudentinput")) {
            trace.out("editstudentinput", "SSM.getActionNames(" + selection + ")");
        }
        if (selection == null || selection.trim().length() < 1) {
            return new HashSet<String>();
        }
        Set<String> result = this.selectionToActionNamesMap.get(selection.toLowerCase());
        if (result == null) {
            return new HashSet<String>();
        }
        return result;
    }

    public List<String> getAllActionNames() {
        return new ArrayList<String>(this.defaultActionNames);
    }

    public int pruneInterfaceDescriptions(ProblemModel pm, boolean execute) {
        int result = 0;
        if (pm == null) {
            return result;
        }
        if ("Java".equalsIgnoreCase(pm.getController().getUniversalToolProxy().getStudentInterfacePlatform())) {
            return result;
        }
        Iterator<MessageObject> pmIter = pm.startNodeMessagesIteratorForStartStateModel();
        while (pmIter.hasNext()) {
            MessageObject mo = pmIter.next();
            boolean isIntDesc = "InterfaceDescription".equalsIgnoreCase(mo.getMessageType());
            boolean interpolatable = true;
            boolean hasMassProdRef = true;
            if (isIntDesc) {
                String moStr = mo.toXML();
                interpolatable = CTATFunctions.interpolatable(moStr);
                hasMassProdRef = ProblemModel.hasMassProductionVarPattern(moStr);
            }
            if (trace.getDebugCode("startstate")) {
                trace.out("startstate", String.format("SSM.pruneInterfaceDescriptions(): %s interpolatable %b hasMassProdRef %b", mo.summary(), interpolatable, hasMassProdRef));
            }
            if (!isIntDesc || interpolatable || hasMassProdRef) continue;
            if (execute) {
                this.interfaceDescriptionsToDiscard.add(mo);
            }
            ++result;
        }
        return result;
    }

    public Map<String, String> getInterfaceComponentsMap() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (String name : this.interfaceDescriptionsFromInterface.keySet()) {
            String instName;
            MessageObject mo = this.interfaceDescriptionsFromInterface.get(name);
            if (!"InterfaceDescription".equals(mo.getMessageType()) || (instName = this.getInstanceName(mo)) == null) continue;
            Object type = mo.getProperty(WIDGET_TYPE);
            result.put(instName, type == null ? "" : type.toString());
            String groupName = this.getGroupName(mo);
            if (groupName != null) {
                result.put(groupName, GROUP);
            }
            for (String cellName : this.getTableCellNames(mo)) {
                result.put(cellName, CELL);
            }
            for (String systemComponent : this.systemSelectionNames) {
                result.put(systemComponent, SYSTEM);
            }
        }
        if (trace.getDebugCode("obssel")) {
            trace.out("obssel", "SSM.getInterfaceComponentsMap() returns\n    " + result);
        }
        return result;
    }

    public void discardMessages(Set<MessageObject> msgs) {
        if (msgs == null) {
            return;
        }
        for (MessageObject msg : msgs) {
            this.otherMsgsToDiscard.add(msg.summary());
        }
    }

    public void saveStudentInterfaceFile(File chosenFile) throws Exception {
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(chosenFile));
        Element root = new Element("StartStateMessages");
        for (MessageObject mo : this.interfaceDescriptionsFromInterface.values()) {
            root.addContent((Content)mo.toElement());
        }
        Document doc = new Document(root);
        xmlOutputter.output(doc, (OutputStream)bos);
        bos.close();
    }

    static {
        SinglesTypes.put("StartProblem", Boolean.TRUE);
        SinglesTypes.put("StartStateEnd", Boolean.TRUE);
        msgComparator = new MsgComparator();
        msgTypesToOmitFromStartState = new HashSet<String>();
        msgTypesToOmitFromStartState.add("GetAllInterfaceDescriptions".toLowerCase());
        msgTypesToOmitFromStartState.add("InterfaceIdentification".toLowerCase());
        msgTypesToOmitFromStartState.add("SetPreferences".toLowerCase());
        xmlOutputter = new XMLOutputter();
        Format fmt = Format.getCompactFormat();
        fmt.setExpandEmptyElements(false);
        fmt.setOmitDeclaration(true);
        fmt.setLineSeparator("\r\n");
        fmt.setIndent("  ");
        fmt.setTextMode(Format.TextMode.TRIM);
        xmlOutputter.setFormat(fmt);
    }

    static class MsgComparator
    implements Comparator<MessageObject> {
        static Map<String, Integer> types = new LinkedHashMap<String, Integer>();

        MsgComparator() {
        }

        @Override
        public int compare(MessageObject o1, MessageObject o2) {
            Integer i2;
            if (o1 == null) {
                return o2 == null ? 0 : 1;
            }
            if (o2 == null) {
                return -1;
            }
            String t1 = o1.getMessageType().toLowerCase();
            String t2 = o2.getMessageType().toLowerCase();
            if (t1 == null) {
                return t2 == null ? 0 : 1;
            }
            if (t2 == null) {
                return -1;
            }
            if (t1.equals(t2)) {
                return 0;
            }
            Integer i1 = types.get(t1);
            if (i1 == null) {
                i1 = types.get("");
            }
            if ((i2 = types.get(t2)) == null) {
                i2 = types.get("");
            }
            return i1.compareTo(i2);
        }

        static {
            types.put("StartProblem".toLowerCase(), 0);
            types.put("", 100);
            types.put("InterfaceDescription".toLowerCase(), 200);
            types.put("InterfaceAction".toLowerCase(), 300);
            types.put("StartStateEnd".toLowerCase(), 400);
        }
    }

    public static class CompareInterfaceDescriptions
    implements Comparable<CompareInterfaceDescriptions> {
        String widgetType = null;
        String pmCommName = null;
        String siCommName = null;
        MessageObject pmMsg = null;
        MessageObject siMsg = null;
        Choice choice = null;
        private String alert = null;
        String match = "";
        private static final Pattern removeCDATADelimiter = Pattern.compile("<!\\[CDATA\\[([^]]*)\\]\\]>");

        CompareInterfaceDescriptions(MessageObject pmMsg) {
            String pmCommName;
            if (trace.getDebugCode("startstate")) {
                trace.out("startstate", String.format("CompareInterfaceDescriptions(%s) type %s, name %s", pmMsg == null ? null : pmMsg.getMessageType(), pmMsg == null ? null : pmMsg.getProperty(StartStateModel.WIDGET_TYPE), pmMsg == null ? null : pmMsg.getProperty(StartStateModel.COMM_NAME)));
            }
            this.choice = Choice.omit;
            this.pmMsg = pmMsg;
            if (pmMsg == null) {
                return;
            }
            String widgetType = (String)pmMsg.getProperty(StartStateModel.WIDGET_TYPE);
            if (widgetType != null && widgetType.length() > 0) {
                this.widgetType = widgetType;
            }
            if ((pmCommName = (String)pmMsg.getProperty(StartStateModel.COMM_NAME)) != null && pmCommName.length() > 0) {
                this.pmCommName = pmCommName;
            }
            if (this.widgetType != null && this.pmCommName != null) {
                this.choice = Choice.keepPM;
            }
        }

        public String getWidgetType() {
            return this.widgetType;
        }

        public String getPmCommName() {
            return this.pmCommName;
        }

        public String getSiCommName() {
            return this.siCommName;
        }

        public MessageObject getPmMsg() {
            return this.pmMsg;
        }

        public MessageObject getSiMsg() {
            return this.siMsg;
        }

        public String getMatch() {
            return this.match;
        }

        public Choice getChoice() {
            return this.choice;
        }

        public Choice setChoice(Choice choice) {
            Choice result = this.choice;
            switch (choice) {
                case keepPM: {
                    if (this.getPmCommName() == null || this.getPmCommName().length() <= 0) break;
                    this.choice = choice;
                    break;
                }
                case saveSI: {
                    if (this.getSiCommName() == null || this.getSiCommName().length() <= 0) break;
                    this.choice = choice;
                    break;
                }
                default: {
                    this.choice = choice;
                }
            }
            return result;
        }

        public char setChoice(char chr) {
            Choice result = this.choice;
            this.choice = Choice.fromChar(chr);
            return result.toChar();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("[");
            sb.append(this.widgetType).append(',');
            sb.append(this.match).append(',');
            sb.append(this.pmCommName).append(',');
            sb.append(this.siCommName).append(',');
            sb.append(this.choice.toChar()).append(']');
            return sb.toString();
        }

        public String toHtmlRow() {
            String[] fields;
            StringBuilder sb = new StringBuilder("<tr>");
            for (String field : fields = new String[]{this.widgetType, this.match, this.pmCommName, "__", this.siCommName, "__"}) {
                if ("__".equals(field)) {
                    sb.append("<td align=\"center\">");
                } else {
                    sb.append("<td>");
                }
                sb.append(field == null ? "" : field).append("</td>");
            }
            sb.append("</tr>");
            return sb.toString();
        }

        public String toHtmlHeader() {
            String[] fields;
            StringBuilder sb = new StringBuilder("<tr>");
            for (String field : fields = new String[]{"Type", "Match", "Name in Graph", "Delete", "Name in Interface", "Retain"}) {
                sb.append("<th align=\"left\">").append(field).append("</th>");
            }
            sb.append("</tr>");
            return sb.toString();
        }

        @Override
        public int compareTo(CompareInterfaceDescriptions o) {
            String otherCommName;
            if (!this.match.equals(o.match)) {
                if (StartStateModel.SAME.equals(this.match)) {
                    return 1;
                }
                if (StartStateModel.DIFFER.equals(this.match)) {
                    return -1;
                }
                if (StartStateModel.SAME.equals(o.match)) {
                    return -1;
                }
                if (StartStateModel.DIFFER.equals(o.match)) {
                    return 1;
                }
            }
            String myCommName = this.pmCommName != null ? this.pmCommName : this.siCommName;
            String string = otherCommName = o.pmCommName != null ? o.pmCommName : o.siCommName;
            if (myCommName == null) {
                if (otherCommName != null) {
                    return 1;
                }
            } else {
                if (otherCommName == null) {
                    return -1;
                }
                int result = myCommName.compareTo(otherCommName);
                if (result != 0) {
                    return result;
                }
            }
            if (this.widgetType == null) {
                return o.widgetType != null ? 1 : 0;
            }
            if (o.widgetType == null) {
                return -1;
            }
            return this.widgetType.compareTo(o.widgetType);
        }

        private void setStudentInterfaceFields(MessageObject siDesc) {
            String siCommName;
            if (siDesc == null) {
                return;
            }
            String siWidgetType = (String)siDesc.getProperty(StartStateModel.WIDGET_TYPE);
            if (this.widgetType == null) {
                if (siWidgetType != null && siWidgetType.length() > 0) {
                    this.widgetType = siWidgetType;
                }
            } else if (!this.widgetType.equals(siWidgetType)) {
                throw new WidgetTypeException("CID " + this + " type mismatch: interface type " + siWidgetType);
            }
            if ((siCommName = (String)siDesc.getProperty(StartStateModel.COMM_NAME)) != null && siCommName.length() > 0) {
                this.siCommName = siCommName;
                this.siMsg = siDesc;
            }
            if (this.pmMsg != null) {
                String siMsgStr;
                String pmMsgStr = removeCDATADelimiter.matcher(this.pmMsg.toMinimalXML()).replaceAll("$1");
                String string = this.match = pmMsgStr.equals(siMsgStr = removeCDATADelimiter.matcher(this.siMsg.toMinimalXML()).replaceAll("$1")) ? StartStateModel.SAME : StartStateModel.DIFFER;
                if (trace.getDebugCode("startstatell") && StartStateModel.DIFFER.equals(this.match)) {
                    trace.out("startstatell", "CID.setStudentInterfaceFields() pm:\n    " + pmMsgStr + "\n  siMsg:\n    " + siMsgStr);
                }
            }
        }

        public String getAlert() {
            return this.alert;
        }

        private void setAlert(String alert) {
            this.alert = alert;
        }
    }

    public static enum Choice {
        keepPM("Keep Graph Settings", 'K'),
        saveSI("Save Interface Settings to Graph", 'S'),
        omit("Omit Settings from Graph", 'O');

        private final String display;
        private final char chr;

        private Choice(String display, char chr) {
            this.display = display;
            this.chr = chr;
        }

        public String toString() {
            return this.display;
        }

        public char toChar() {
            return this.chr;
        }

        public static Choice fromChar(char chr) throws IllegalArgumentException {
            for (Choice choice : Choice.values()) {
                if (choice.chr != Character.toUpperCase(chr)) continue;
                return choice;
            }
            throw new IllegalArgumentException("Invalid character '" + chr + "'");
        }
    }

    public static class WidgetTypeException
    extends RuntimeException {
        private static final long serialVersionUID = 201402201355L;

        public WidgetTypeException(String message) {
            super(message);
        }
    }

    public static interface Listener {
        public void startStateReceived(EventObject var1);
    }
}

