/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.ctat.model;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.Controller.CtatModeEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemNode;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemModelException;
import edu.cmu.pact.Utilities.Utils;
import edu.cmu.pact.Utilities.VersionInformation;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.view.CtatFrame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JOptionPane;

public class CtatModeModel
implements BR_Controller.WillNotifyListeners {
    public static final String DEFINING_START_STATE = "Set Start State";
    public static final String DEMONSTRATING_SOLUTION = "Demonstrate";
    public static final String TESTING_TUTOR = "Test Tutor";
    public static final String[] authorModes = new String[]{"Set Start State", "Demonstrate", "Test Tutor"};
    private boolean demonstrateThisLinkMode = false;
    private int currentEdgeID = -1;
    public static final String SIMULATED_STUDENT_MODE = "Simulated Student";
    public static final String TDK_MODE = "Cognitive Tutor (TDK)";
    public static final String JESS_MODE = "Cognitive Tutor (Jess)";
    public static final String EXAMPLE_TRACING_MODE = "Example-tracing Tutor";
    private static final String[] modeTypes = VersionInformation.includesJess() && VersionInformation.isRunningSimSt() ? new String[]{"Example-tracing Tutor", "Cognitive Tutor (Jess)", "Cognitive Tutor (TDK)", "Simulated Student"} : (VersionInformation.includesJess() ? new String[]{"Example-tracing Tutor", "Cognitive Tutor (Jess)", "Cognitive Tutor (TDK)"} : (VersionInformation.isRunningSimSt() ? new String[]{"Example-tracing Tutor", "Cognitive Tutor (TDK)", "Simulated Student"} : new String[]{"Example-tracing Tutor", "Cognitive Tutor (TDK)"}));
    private static final List<String> modeTypeList = Arrays.asList(modeTypes);
    private static final List<String> authorModeList = Arrays.asList(authorModes);
    private ComboBoxModel comboBoxModeModel;
    private ComboBoxAuthorModeModel comboBoxAuthorModeModel;
    private String currentMode = modeTypes[0];
    private String currentAuthorMode = authorModes[0];
    private BR_Controller controller;
    private String previousMode = "";
    private String previousAuthorMode = "";
    private boolean setStartStateLock = false;
    private boolean setDemonstrateLock = false;
    private boolean setTestTutorLock = false;
    private boolean noticesBlocked;

    public CtatModeModel(BR_Controller controller) {
        if (!Utils.isRuntime()) {
            this.comboBoxModeModel = new DefaultComboBoxModel<String>(new Vector<String>(modeTypeList));
            this.comboBoxAuthorModeModel = new ComboBoxAuthorModeModel(new Vector<String>(authorModeList));
        }
        this.controller = controller;
    }

    public ComboBoxModel getModeComboBoxModel() {
        return this.comboBoxModeModel;
    }

    public ComboBoxModel getAuthorModeComboBoxModel() {
        return this.comboBoxAuthorModeModel;
    }

    public static List<String> getModeTypeList() {
        return modeTypeList;
    }

    public static List<String> getAuthorModeList() {
        return authorModeList;
    }

    public void setAuthorMode(String newMode) {
        this.setAuthorMode(newMode, true);
    }

    public void setAuthorMode(String newMode, boolean goToStartState2) {
        if (!authorModeList.contains(newMode)) {
            throw new RuntimeException("Unknown CTAT author mode: " + newMode);
        }
        this.noticesBlocked = true;
        String errMsg = this.changeAuthorModeOk(newMode, this.controller.getProblemName(), false, goToStartState2);
        this.noticesBlocked = false;
        if (errMsg == null) {
            this.internalSetAuthorMode(newMode);
            this.notifyListeners();
        }
    }

    private FindProblemName findProblemName(String newMode, String problemName) {
        FindProblemName result = new FindProblemName();
        if (trace.getDebugCode("mode")) {
            trace.printStack("mode", "CtatModeModel.FPN(" + newMode + "," + problemName + ") prevMode " + this.previousAuthorMode + ", ctlr.isStartStateModified() " + this.controller.isStartStateModified() + ", startNode " + this.controller.getProblemModel().getStartNode());
        }
        if (!DEFINING_START_STATE.equalsIgnoreCase(this.previousAuthorMode)) {
            return result;
        }
        if (problemName == null) {
            result.abortOperation = true;
            return result;
        }
        ProblemNode startNode = this.controller.getProblemModel().getStartNode();
        if (startNode != null) {
            result.problemName = startNode.getName();
        }
        if (result.problemName != null) {
            result.shouldModifyStartState = true;
        } else {
            if (trace.getDebugCode("mode")) {
                trace.out("mode", "*! CMModel.findProblemName() would have queried for problem name");
            }
            result.problemName = problemName;
            if (result.problemName != null) {
                result.shouldCreateStartState = true;
            } else {
                result.abortOperation = true;
            }
        }
        return result;
    }

    protected String changeAuthorModeOk(String newMode, String problemName, boolean fromAuthorModeSwitch, boolean goToStartState2) {
        if (trace.getDebugCode("mode")) {
            trace.out("mode", "CtatModeModel.changeAuthorMode(" + newMode + ") current mode " + this.getCurrentAuthorMode());
        }
        if (newMode == DEFINING_START_STATE && this.setStartStateLock) {
            JOptionPane.showMessageDialog(this.controller.getActiveWindow(), "You have tried switching to 'Set Start State' mode.\nAn active feature may not work in 'Set Start State' mode.\nYou have been switched back to the previous mode", "Warning", 2);
            return "Tried Set Start State while setStartStateLock " + this.setStartStateLock;
        }
        if (newMode == DEMONSTRATING_SOLUTION && this.setDemonstrateLock) {
            JOptionPane.showMessageDialog(this.controller.getActiveWindow(), "You have tried switching to 'Demonstrate' mode.\nAn active feature may not work in 'Demonstrate' mode.\nYou have been switched back to the previous mode", "Warning", 2);
            return "Tried Demonstrate while setDemonstrateLock " + this.setDemonstrateLock;
        }
        if (newMode == TESTING_TUTOR && this.setTestTutorLock) {
            JOptionPane.showMessageDialog(this.controller.getActiveWindow(), "You have tried switching to 'Test Tutor' mode.\nAn active feature may not work in 'Test Tutor' mode.\nYou have been switched back to the previous mode", "Warning", 2);
            return "Tried Test Tutor while setTestTutorLock " + this.setTestTutorLock;
        }
        if (DEFINING_START_STATE.equalsIgnoreCase(newMode)) {
            if (fromAuthorModeSwitch && !newMode.equals(this.previousAuthorMode)) {
                this.controller.getUniversalToolProxy().setUserBeganStartStateEdit(true);
            }
            if (this.controller.getDockedFrame() != null) {
                ((CtatFrame)this.controller.getDockedFrame()).getCtatMenuBar().enableCreateStartStateMenus(true);
            }
        } else {
            FindProblemName fpn = this.findProblemName(newMode, problemName);
            if (trace.getDebugCode("mode")) {
                trace.out("mode", "CMM.changeAuthorModeOk(" + newMode + ") fpn " + fpn);
            }
            if (fpn.abortOperation) {
                return "User cancelled.";
            }
            if (this.controller.getDockedFrame() != null) {
                ((CtatFrame)this.controller.getDockedFrame()).getCtatMenuBar().enableCreateStartStateMenus(false);
            }
            if (fpn.shouldModifyStartState) {
                if (trace.getDebugCode("mode")) {
                    trace.out("mode", "*! CMModel.changeAuthorModeOk() fpn " + fpn + " to call BR_C.modifyStartState()");
                }
                this.controller.modifyStartState(fpn.problemName);
                if (!Utils.isRuntime()) {
                    if (trace.getDebugCode("mode")) {
                        trace.out("mode", "*! CMModel.changeAuthorModeOk() fpn " + fpn + (goToStartState2 ? ", will" : ", will not") + " call BR_C.goToStartState()");
                    }
                    if (goToStartState2) {
                        this.controller.goToStartState();
                    }
                }
            } else if (fpn.shouldCreateStartState) {
                try {
                    Object createResult = this.controller.createStartState(fpn.problemName, fromAuthorModeSwitch && this.isRuleEngineTracing(), this);
                    if (trace.getDebugCode("mode")) {
                        trace.out("mode", "CMM.changeAuthorModeOk(): createStartState returns " + createResult);
                    }
                    if (createResult instanceof String) {
                        return (String)createResult;
                    }
                }
                catch (ProblemModelException e) {
                    e.printStackTrace();
                    if (!Utils.isRuntime()) {
                        ((CtatFrame)this.controller.getDockedFrame()).getCtatMenuBar().enableCreateStartStateMenus(true);
                    }
                    return "Error from createStartState(): " + e;
                }
            }
        }
        if (trace.getDebugCode("mode")) {
            trace.out("mode", "*! CMModel.changeAuthorModeOk(" + newMode + ") prev " + this.previousAuthorMode + " rtns null==OK");
        }
        return null;
    }

    public void setMode(String newMode) {
        if (trace.getDebugCode("br")) {
            trace.printStack("br", "setMode(" + newMode + ") previousMode " + this.previousMode);
        }
        if (!modeTypeList.contains(newMode)) {
            throw new RuntimeException("Unknown CTAT mode: " + newMode);
        }
        this.noticesBlocked = true;
        this.userSetMode(newMode);
        this.noticesBlocked = false;
        this.notifyListeners();
    }

    public String userSetMode(String newMode) {
        String result = this.previousMode;
        if (SIMULATED_STUDENT_MODE.equals(newMode) && !newMode.equals(this.previousMode)) {
            this.internalSetAuthorMode(DEFINING_START_STATE);
        }
        this.internalSetMode(newMode);
        this.notifyListeners();
        return result;
    }

    private void internalSetMode(String newMode) {
        this.currentMode = newMode;
        if (!Utils.isRuntime()) {
            this.comboBoxModeModel.setSelectedItem(newMode);
        }
    }

    private void internalSetAuthorMode(String newAuthorMode) {
        if (trace.getDebugCode("replay")) {
            trace.printStack("replay", "internalSetAuthorMode(" + newAuthorMode + ") ");
        }
        this.currentAuthorMode = newAuthorMode;
        if (!Utils.isRuntime()) {
            this.comboBoxAuthorModeModel.nativeSetSelectedItem(newAuthorMode);
        }
    }

    public boolean isRuleEngineTracing() {
        return JESS_MODE.equals(this.getCurrentMode()) || TDK_MODE.equals(this.getCurrentMode()) || SIMULATED_STUDENT_MODE.equals(this.getCurrentMode());
    }

    public boolean isJessTracing() {
        return JESS_MODE.equals(this.getCurrentMode()) || SIMULATED_STUDENT_MODE.equals(this.getCurrentMode());
    }

    public boolean isJessMode() {
        return JESS_MODE.equals(this.getCurrentMode());
    }

    public boolean isExampleTracingMode() {
        return EXAMPLE_TRACING_MODE.equals(this.getCurrentMode());
    }

    public boolean isTDKMode() {
        return TDK_MODE.equals(this.getCurrentMode());
    }

    public boolean isSimStudentMode() {
        return SIMULATED_STUDENT_MODE.equals(this.getCurrentMode());
    }

    public String getModeTitle() {
        return this.getCurrentMode();
    }

    public String getCurrentMode() {
        if (Utils.isRuntime()) {
            return this.currentMode;
        }
        return (String)this.comboBoxModeModel.getSelectedItem();
    }

    public String getCurrentAuthorMode() {
        if (Utils.isRuntime()) {
            return this.currentAuthorMode;
        }
        return (String)this.comboBoxAuthorModeModel.getSelectedItem();
    }

    public boolean isDefiningStartState() {
        return DEFINING_START_STATE.equals(this.getCurrentAuthorMode());
    }

    public boolean isDemonstratingSolution() {
        return DEMONSTRATING_SOLUTION.equals(this.getCurrentAuthorMode());
    }

    public boolean isTestingTutor() {
        return TESTING_TUTOR.equals(this.getCurrentAuthorMode());
    }

    public void lockSetStartState() {
        this.setStartStateLock = true;
    }

    public void unlockSetStartState() {
        this.setStartStateLock = false;
    }

    public boolean isSetStartStateLocked() {
        return this.setStartStateLock;
    }

    public void lockDemonstrate() {
        this.setDemonstrateLock = true;
    }

    public void unlockDemonstrate() {
        this.setDemonstrateLock = false;
    }

    public boolean isDemonstrateLocked() {
        return this.setDemonstrateLock;
    }

    public void lockTestTutor() {
        this.setTestTutorLock = true;
    }

    public void unlockTestTutor() {
        this.setTestTutorLock = false;
    }

    public boolean isTestTutorLocked() {
        return this.setTestTutorLock;
    }

    public void enterDemonstrateThisLinkMode(int edgeID) {
        this.demonstrateThisLinkMode = true;
        this.currentEdgeID = edgeID;
        this.lockSetStartState();
    }

    public void exitDemonstrateThisLinkMode() {
        this.demonstrateThisLinkMode = false;
        this.currentEdgeID = -1;
        this.unlockSetStartState();
    }

    public boolean isDemonstrateThisLinkMode() {
        return this.demonstrateThisLinkMode;
    }

    public int getCurrentEdgeID() {
        return this.currentEdgeID;
    }

    @Override
    public void notifyListeners() {
        if (trace.getDebugCode("mode")) {
            trace.out("mode", "*! CMModel.notifyListeners() noticesBlocked " + this.noticesBlocked);
        }
        if (this.noticesBlocked) {
            return;
        }
        this.controller.fireCtatModeEvent(new CtatModeEvent.SetModeEvent(this.getCurrentMode(), this.previousMode, this.getCurrentAuthorMode(), this.previousAuthorMode));
        this.previousAuthorMode = this.getCurrentAuthorMode();
        this.previousMode = this.getCurrentMode();
    }

    public String getPreviousAuthorMode() {
        return this.previousAuthorMode;
    }

    public void setPreviousAuthorMode(String previousAuthorMode) {
        this.previousAuthorMode = previousAuthorMode;
    }

    public static boolean isDefinedModeType(String tutorType) {
        return modeTypeList.contains(tutorType);
    }

    private class FindProblemName {
        String problemName = null;
        boolean shouldModifyStartState = false;
        boolean shouldCreateStartState = false;
        boolean abortOperation = false;

        private FindProblemName() {
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("[");
            sb.append(this.problemName).append(", ");
            sb.append(this.shouldModifyStartState).append(", ");
            sb.append(this.shouldCreateStartState).append(", ");
            sb.append(this.abortOperation).append("]");
            return sb.toString();
        }
    }

    private class ComboBoxAuthorModeModel
    extends DefaultComboBoxModel {
        private static final long serialVersionUID = 201402201505L;

        public ComboBoxAuthorModeModel(Vector<String> vector) {
            super(vector);
        }

        @Override
        public void setSelectedItem(Object newAuthorMode) {
            String problemName = this.requestProblemNameForAuthorModeChange();
            String errMsg = CtatModeModel.this.changeAuthorModeOk((String)newAuthorMode, problemName, true, true);
            if (trace.getDebugCode("mode")) {
                trace.out("mode", "comboBoxAuthorModeModel.setSelectedItem(" + newAuthorMode + ") errMsg " + errMsg);
            }
            if (errMsg == null) {
                CtatModeModel.this.internalSetAuthorMode((String)newAuthorMode);
                CtatModeModel.this.notifyListeners();
                return;
            }
            PropertyChangeEvent evt = new PropertyChangeEvent(CtatModeModel.this, "selectedItem", CtatModeModel.this.getCurrentAuthorMode(), newAuthorMode);
            new PropertyVetoException(errMsg, evt);
        }

        private String requestProblemNameForAuthorModeChange() {
            ProblemNode n0 = CtatModeModel.this.controller.getProblemModel().getStartNode();
            String result = null;
            if ((n0 == null || (result = n0.getName()) == null) && CtatModeModel.this.isDefiningStartState()) {
                result = CtatModeModel.this.controller.getCtatFrameController().getDockedFrame().getCtatModePanel().queryForProblemName();
            }
            return result;
        }

        void nativeSetSelectedItem(String newAuthorMode) {
            super.setSelectedItem(newAuthorMode);
        }
    }
}

