/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.ctat;

import edu.cmu.pact.BehaviorRecorder.ProblemModel.FeedbackEnum;
import edu.cmu.pact.ctat.MessageObject;
import java.util.List;

public class MsgType {
    private static final String[] correctIncorrect = new String[]{"CorrectAction", "IncorrectAction", "LISPCheckAction"};
    private static final String[] textFeedbackTypes = new String[]{"ShowHintsMessage", "SuccessMessage", "BuggyMessage", "WrongUserMessage", "NoHintMessage", "HighlightMsg", "ShowHintsMessageFromLisp"};
    private static final String[] hintResponseTypes = new String[]{"ShowHintsMessage", "NoHintMessage", "ShowHintsMessageFromLisp"};
    public static final String DONE = "Done";
    public static final String BUTTON_PRESSED = "ButtonPressed";
    public static final String PROBLEM_NAME = "ProblemName";
    public static final String ASSOCIATED_RULES = "AssociatedRules";
    public static final String AUTHOR_MODE_CHANGE = "AuthorModeChange";
    public static final String BUGGY_MESSAGE = "BuggyMessage";
    public static final String GET_URL = "GetURL";
    public static final String GET_URL_RESPONSE = "GetURLResponse";
    public static final String CHANGE_WM_STATE = "ChangeWMState";
    public static final String CHECK_ALL_STATES_RESULT = "CheckAllStatesResult";
    public static final String COGNITIVE_LOAD = "CognitiveLoad";
    public static final String COMPONENT_INFO = "ComponentInfo";
    public static final String CONFIRM_DONE = "ConfirmDone";
    public static final String CORRECT_ACTION = "CorrectAction";
    public static final String GET_ALL_INTERFACE_DESCRIPTIONS = "GetAllInterfaceDescriptions";
    public static final String GLOSSARY = "Glossary";
    public static final String GO_TO_WM_STATE = "Go_To_WM_State";
    public static final String HIGHLIGHT_MSG = "HighlightMsg";
    public static final String INCORRECT_ACTION = "InCorrectAction";
    public static final String INTERFACE_ACTION = "InterfaceAction";
    public static final String INTERFACE_CONFIGURATION_END = "InterfaceConfigurationEnd";
    public static final String INTERFACE_DESCRIPTION = "InterfaceDescription";
    public static final String INTERFACE_FORCE_DISCONNECT = "InterfaceForceDisconnect";
    public static final String INTERFACE_IDENTIFICATION = "InterfaceIdentification";
    public static final String INTERFACE_REBOOT = "InterfaceReboot";
    public static final String LISP_CHECK = "LISPCheck";
    public static final String LISP_CHECK_ACTION = "LISPCheckAction";
    public static final String LISP_CHECK_RESULT = "LispCheckResult";
    public static final String LOAD_BRD_FILE_SUCCESS = "LoadBRDFileSuccess";
    public static final String MESSAGE_BUNDLE = "MessageBundle";
    public static final String MESSAGES = "messages";
    public static final String NEXT_HINT_MESSAGE = "NextHintMessage";
    public static final String NO_HINT_MESSAGE = "NoHintMessage";
    public static final String PREVIOUS_HINT_MESSAGE = "PreviousHintMessage";
    public static final String PROBLEM_RESTORE_END = "ProblemRestoreEnd";
    public static final String PROBLEM_SUMMARY_REQUEST = "ProblemSummaryRequest";
    public static final String PROBLEM_SUMMARY_RESPONSE = "ProblemSummaryResponse";
    public static final String RESET_ACTION = "ResetAction";
    public static final String RESTORE_INITIAL_WM_STATE = "RestorInitialWMState";
    public static final String RESTORE_JESS_INITIAL_WM_STATE = "RestorJessInitialWMState";
    public static final String RETRACT_STEPS = "RetractSteps";
    public static final String SEND_ESE_GRAPH = "Send_ESEGraph";
    public static final String SEND_WIDGET_LOCK = "SendWidgetLock";
    public static final String SET_MODE = "SetMode";
    public static final String SET_PREFERENCES = "SetPreferences";
    public static final String SHOW_HINTS_MESSAGE = "ShowHintsMessage";
    public static final String START_NEW_PROBLEM = "StartNewProblem";
    public static final String START_PROBLEM = "StartProblem";
    public static final String START_STATE_CREATED = "StartStateCreated";
    public static final String START_STATE_END = "StartStateEnd";
    public static final String StartStateMessages = "StartStateMessages";
    public static final String STATE_GRAPH = "StateGraph";
    public static final String SUCCESS_MESSAGE = "SuccessMessage";
    public static final String TUTORING_SERVICE_ERROR = "TutoringServiceError";
    public static final String UNLOCK_COMPOSER = "UnlockComposer";
    public static final String UNTUTORED_ACTION = "UntutoredAction";
    public static final String VERSION_INFO = "VersionInfo";
    public static final String WIDGET_LOCK_FLAG = "WidgetLockFlag";
    public static final String WRONG_USER_MESSAGE = "WrongUserMessage";
    public static final String TUTORING_SERVICE_COMMUNICATION = "tutoring_service_communication";

    public static boolean isCorrectOrIncorrect(MessageObject mo) {
        return mo.isMessageType(correctIncorrect);
    }

    public static boolean hasTextFeedback(MessageObject mo) {
        return mo.isMessageType(textFeedbackTypes);
    }

    public static boolean isDoneMessage(MessageObject mo) {
        Object sObj = mo.getProperty("Selection");
        Object aObj = mo.getProperty("Action");
        if (sObj == null || aObj == null) {
            return false;
        }
        String s = "";
        if (!(sObj instanceof List)) {
            s = sObj.toString();
        } else {
            String sElt = ((List)sObj).size() < 1 ? "" : ((List)sObj).get(0);
            s = sElt == null ? "" : sElt.toString();
        }
        String a = "";
        if (!(aObj instanceof List)) {
            a = aObj.toString();
        } else {
            String sElt = ((List)aObj).size() < 1 ? "" : ((List)aObj).get(0);
            a = sElt == null ? "" : sElt.toString();
        }
        return DONE.equalsIgnoreCase(s) && BUTTON_PRESSED.equalsIgnoreCase(a);
    }

    public static boolean isHintResponse(MessageObject mo) {
        return mo.isMessageType(hintResponseTypes);
    }

    public static FeedbackEnum suppressFeedback(MessageObject mo, FeedbackEnum suppress) {
        if (suppress == FeedbackEnum.SHOW_ALL_FEEDBACK) {
            return suppress;
        }
        if (MsgType.hasTextFeedback(mo)) {
            if (suppress == FeedbackEnum.HIDE_ALL_FEEDBACK) {
                return suppress;
            }
            String buggyMsg = (String)mo.getProperty("BuggyMsg");
            if ("I'm sorry, but you are not done yet. Please continue working.".equalsIgnoreCase(buggyMsg)) {
                return FeedbackEnum.SHOW_ALL_FEEDBACK;
            }
            return FeedbackEnum.HIDE_ALL_FEEDBACK;
        }
        if (MsgType.isCorrectOrIncorrect(mo)) {
            if (MsgType.isDoneMessage(mo)) {
                return FeedbackEnum.SHOW_ALL_FEEDBACK;
            }
            return suppress;
        }
        return FeedbackEnum.SHOW_ALL_FEEDBACK;
    }
}

