/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.ctat;

import edu.cmu.pact.CommManager.CommManager;
import edu.cmu.pact.TutoringService.TransactionInfo;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.Communicator;
import edu.cmu.pact.ctat.Target;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.Vector;
import java.util.regex.Pattern;
import org.jdom.CDATA;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class MessageObject
implements Cloneable {
    private static XMLOutputter outputter = new XMLOutputter(Format.getCompactFormat().setOmitDeclaration(true).setLineSeparator("").setIndent(""));
    public static final String MESSAGE_TYPE = "MessageType";
    public static final String SELECTION = "Selection";
    public static final String ACTION = "Action";
    public static final String INPUT = "Input";
    private static final String ROOT_TAG = "message";
    private static final String VERB_TAG = "verb";
    private static final String PROPERTIES_TAG = "properties";
    private static final String QUIT_MSG = "quit";
    public static final String DEFAULT_VERB = "SendNoteProperty";
    private static final XMLOutputter noWhiteSpaceOutputter = new XMLOutputter();
    private static final XMLOutputter singleLineOutputter;
    private static final XMLOutputter multiLineOutputter;
    private static final Element quitMsg;
    protected static final String TRANSACTION_ID_TAG = "transaction_id";
    public static final String VALUE_TAG = "value";
    public static final String SKILL_BAR_DELIMITER_TAG = "skillBarDelimiter";
    private Element root = null;
    private Map<String, NameValue> properties = null;
    private String text = null;
    private String messageType;
    private boolean doNotLog = false;
    private boolean isTransactionIdLocked = false;
    private static final Pattern hasControlChar;
    public static boolean showMessage;
    private transient TransactionInfo.Single transactionInfo;

    public static String makeTransactionId() {
        return "T" + UUID.randomUUID().toString();
    }

    public static Vector<String> s2v(String s) {
        if (s == null) {
            return null;
        }
        Vector<String> result = new Vector<String>();
        result.add(s);
        return result;
    }

    public static MessageObject parse(String text) {
        List bundledMsgs;
        if (text == null) {
            throw new IllegalArgumentException("message text is null");
        }
        MessageObject mo = new MessageObject();
        mo.text = text.trim();
        if (mo.isQuitMsg()) {
            mo.root = (Element)quitMsg.clone();
            return mo;
        }
        Document msgDoc = null;
        try {
            StringReader strIn = new StringReader(mo.text);
            SAXBuilder builder = new SAXBuilder(false);
            msgDoc = builder.build((Reader)strIn);
        }
        catch (Exception e) {
            throw new RuntimeException("error parsing XML message: document=" + msgDoc, e);
        }
        mo.root = msgDoc.getRootElement();
        if (!ROOT_TAG.equalsIgnoreCase(mo.root.getName()) && (bundledMsgs = mo.root.getChildren(ROOT_TAG)) != null && bundledMsgs.size() > 0) {
            mo.root = (Element)bundledMsgs.get(bundledMsgs.size() - 1);
        }
        mo.makeProperties(mo.root.getChild(PROPERTIES_TAG));
        return mo;
    }

    public static MessageObject fromElement(Element messageElement) {
        MessageObject mo = new MessageObject();
        mo.root = new Element(ROOT_TAG);
        mo.setVerb(messageElement.getChildText(VERB_TAG));
        mo.makeProperties(messageElement.getChild(PROPERTIES_TAG));
        return mo;
    }

    public static String element2String(Element elt) {
        return outputter.outputString(elt);
    }

    public static String getPropertyFromXML(String xml, String property) {
        if (xml == null) {
            return null;
        }
        String[] result = xml.split("<" + property + ">");
        if (result.length < 2) {
            return null;
        }
        return result[1].split("</" + property + ">")[0];
    }

    private void makeProperties(Element propertiesElt) {
        this.properties = new LinkedHashMap<String, NameValue>();
        if (propertiesElt == null) {
            return;
        }
        if (trace.getDebugCode("msg")) {
            trace.out("msg", "in makeProperties(Element)\npropertiesElt " + multiLineOutputter.outputString(propertiesElt));
        }
        int childIndex = -1;
        for (Object obj : propertiesElt.getChildren()) {
            ++childIndex;
            if (!(obj instanceof Element)) {
                trace.err("non-element child at properties child #" + childIndex + ":\n  " + this.text);
                continue;
            }
            Element propertyElt = (Element)obj;
            NameValue nv = null;
            String name = propertyElt.getName();
            if (name == null || name.length() < 1) {
                trace.err("tag name null or empty in properties element child #" + childIndex + ":\n  " + this.text);
                continue;
            }
            List childList = propertyElt.getChildren();
            if (childList == null || childList.size() < 1) {
                String text = propertyElt.getText();
                nv = new NameValue(name, text);
            } else if (!(childList.get(0) instanceof Element)) {
                trace.err("Message property child " + name + " not an element:\n  " + outputter.outputString(propertyElt));
            } else if (VALUE_TAG.equalsIgnoreCase(((Element)childList.get(0)).getName())) {
                Vector<String> values = new Vector<String>();
                for (Element valueElt : childList) {
                    String value = valueElt.getText();
                    values.add(value);
                }
                nv = new NameValue(name, values, true);
            } else if (childList.size() < 2) {
                nv = new NameValue(name, childList.get(0), true);
            } else {
                if (trace.getDebugCode("msg")) {
                    trace.out("msg", "Message property child " + name + " has > 1 child elements:\n  " + outputter.outputString(propertyElt));
                }
                nv = new NameValue(name, new Vector(childList), true);
            }
            this.properties.put(name.trim().toLowerCase(), nv);
        }
        if (trace.getDebugCode("msg")) {
            trace.out("msg", "makeProperties result:\n  " + this.properties);
        }
    }

    protected MessageObject() {
    }

    protected MessageObject(MessageObject mo) {
        if (trace.getDebugCode("msg")) {
            trace.out("msg", "in MessageObject(MessageObject mo)");
        }
        this.init(mo.getMessageType());
        this.setVerb(mo.getVerb());
        for (NameValue property : mo.properties.values()) {
            if (trace.getDebugCode("msg")) {
                trace.out("msg", "in MO, name: " + property.name + " value: " + property.value);
            }
            this.setProperty(property.name, property.value);
        }
    }

    public static MessageObject create(String messageType) {
        return MessageObject.create(messageType, null);
    }

    public static MessageObject create(String messageType, String verb) {
        MessageObject result = new MessageObject();
        result.init(messageType);
        if (verb != null) {
            result.setVerb(verb);
        }
        return result;
    }

    protected void init(String messageType) {
        this.text = null;
        this.root = new Element(ROOT_TAG);
        this.setVerb(DEFAULT_VERB);
        this.makeProperties(null);
        this.setMessageType(messageType);
    }

    public void setMessageType(String messageType) {
        this.setProperty(MESSAGE_TYPE, messageType);
        this.messageType = messageType;
        this.text = null;
    }

    public void setVerb(String verb) {
        Element elt = null;
        elt = this.root.getChild(VERB_TAG);
        if (elt == null) {
            elt = new Element(VERB_TAG);
            this.root.addContent((Content)elt);
        }
        elt.setText(verb);
        this.text = null;
    }

    public boolean isQuitMsg() {
        return QUIT_MSG.equalsIgnoreCase(this.text);
    }

    public static MessageObject makeQuitMessage() {
        return MessageObject.parse(QUIT_MSG);
    }

    public String summary() {
        return MessageObject.summary(this);
    }

    public static String summary(MessageObject mo) {
        if (mo == null) {
            return null;
        }
        String type = mo.getMessageType();
        StringBuilder sb = new StringBuilder(type);
        if ("InterfaceAction".equalsIgnoreCase(type) || "UntutoredAction".equalsIgnoreCase(type)) {
            sb.append(": SAI[").append(mo.getSelection());
            sb.append(',').append(mo.getAction());
            sb.append(',').append(mo.getInput()).append("]");
            sb.append(" TxID ").append(mo.getTransactionId());
        } else if ("InterfaceDescription".equalsIgnoreCase(type)) {
            sb.append(": ").append(mo.getProperty("WidgetType"));
            sb.append("[").append(mo.getProperty("CommName")).append("]");
        } else if ("StartProblem".equalsIgnoreCase(type)) {
            sb.append(": ").append(mo.getProperty("ProblemName"));
        } else if ("SetPreferences".equalsIgnoreCase(type)) {
            String brdFile = (String)mo.getProperty("question_file");
            if (brdFile == null) {
                brdFile = (String)mo.getProperty("ProblemName");
            }
            sb.append(": ").append(brdFile);
            sb.append(", ").append(mo.getProperty("user_guid"));
            sb.append(", ").append(mo.getProperty("session_id"));
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        if (this.text == null) {
            MessageObject messageObject = this;
            synchronized (messageObject) {
                if (this.text == null) {
                    this.makePropertiesElement();
                    this.text = singleLineOutputter.outputString(this.root);
                    if (trace.getDebugCode("msgtext")) {
                        trace.outNT("msgtext", "MO.toString()\n  map: " + this.properties + "\n  txt: " + this.text);
                    }
                }
            }
        }
        return this.text;
    }

    public String toMinimalXML() {
        Element root = this.makeXMLPropertiesElement();
        String result = noWhiteSpaceOutputter.outputString(root);
        if (trace.getDebugCode("msgtext")) {
            trace.outNT("msgtext", "MO.toMinimalXML()\n  map: " + this.properties + "\n  txt: " + result);
        }
        return result;
    }

    private Element makeXMLPropertiesElement() {
        boolean found = this.root.removeChild(PROPERTIES_TAG);
        if (trace.getDebugCode("msg")) {
            trace.out("msg", "old properties element " + (found ? "found" : "not found") + ", map:\n  " + this.properties);
        }
        Element pElt = new Element(PROPERTIES_TAG);
        for (String key : this.properties.keySet()) {
            NameValue nv = this.properties.get(key);
            Element elt = new Element(nv.name);
            if (nv.value == null) {
                elt.setText("");
            } else if (nv.value instanceof List && ((List)nv.value).size() > 0) {
                List values = (List)nv.value;
                Object value0 = values.get(0);
                if (value0 instanceof Element) {
                    for (Object v : values) {
                        elt.addContent((Content)((Element)((Element)v).clone()));
                    }
                } else {
                    for (Object v : values) {
                        Element vElt = new Element(VALUE_TAG);
                        vElt.setText(v == null ? "" : v.toString());
                        elt.addContent((Content)vElt);
                    }
                }
            } else if (nv.value instanceof Element) {
                elt.addContent((Content)((Element)((Element)nv.value).clone()));
            } else {
                elt.setText(nv.value.toString());
            }
            pElt.addContent((Content)elt);
        }
        this.root.addContent((Content)pElt);
        this.text = null;
        return pElt;
    }

    public String toXML() {
        if (this.text == null) {
            this.makePropertiesElement();
        }
        return multiLineOutputter.outputString(this.root);
    }

    public Element toElement() {
        if (this.text == null) {
            this.makePropertiesElement();
        }
        return (Element)this.root.clone();
    }

    public Element getPropertiesElement() {
        if (this.text == null) {
            this.makePropertiesElement();
        }
        return (Element)this.root.getChild(PROPERTIES_TAG).clone();
    }

    private synchronized void makePropertiesElement() {
        boolean found = this.root.removeChild(PROPERTIES_TAG);
        if (trace.getDebugCode("msg")) {
            trace.out("msg", "old properties element " + (found ? "found" : "not found") + ", map:\n  " + this.properties);
        }
        Element pElt = new Element(PROPERTIES_TAG);
        for (String key : this.properties.keySet()) {
            NameValue nv = this.properties.get(key);
            Element elt = new Element(nv.name);
            if (nv.value == null) {
                elt.setText("");
            } else if (nv.value instanceof List && ((List)nv.value).size() > 0) {
                List values = (List)nv.value;
                Object value0 = values.get(0);
                if (value0 instanceof Element) {
                    for (Object v : values) {
                        elt.addContent((Content)((Element)((Element)v).clone()));
                    }
                } else {
                    for (Object v : values) {
                        Element vElt = new Element(VALUE_TAG);
                        if (v == null) {
                            vElt.setText("");
                        } else {
                            String s = v.toString();
                            if (hasControlChar.matcher(s).find()) {
                                vElt.addContent((Content)new CDATA(s));
                            } else {
                                vElt.setText(s);
                            }
                        }
                        elt.addContent((Content)vElt);
                    }
                }
            } else if (nv.value instanceof Element) {
                elt.addContent((Content)((Element)((Element)nv.value).clone()));
            } else {
                elt.setText(nv.value.toString());
            }
            pElt.addContent((Content)elt);
        }
        this.root.addContent((Content)pElt);
        this.text = null;
    }

    public void lockTransactionId(String id) {
        if (id == null || id.length() < 1) {
            throw new IllegalArgumentException("lockTranactionId() argument \"" + id + "\" must be a valid id");
        }
        this.setPropertyInternal(TRANSACTION_ID_TAG, id, false);
        this.isTransactionIdLocked = true;
    }

    public void setTransactionId(String id) {
        if (this.isTransactionIdLocked) {
            return;
        }
        if (id == null || id.length() < 1) {
            if (trace.getDebugCode("msg")) {
                trace.out("msg", "setTranactionId() invalid id \"" + id + "\"; replacing with makeTransactionId()");
            }
            id = MessageObject.makeTransactionId();
        }
        this.setPropertyInternal(TRANSACTION_ID_TAG, id, false);
    }

    protected void setPropertyInternal(String propertyName, Object propertyValue, boolean useAsIs) {
        NameValue nv = new NameValue(propertyName, propertyValue, useAsIs);
        this.properties.put(propertyName.trim().toLowerCase(), nv);
        this.text = null;
    }

    public void setProperty(String propertyName, Object propertyValue) {
        this.setProperty(propertyName, propertyValue, propertyValue instanceof Element);
    }

    public void setProperty(String propertyName, Object propertyValue, boolean useAsIs) {
        if (TRANSACTION_ID_TAG.equalsIgnoreCase(propertyName)) {
            this.setTransactionId(propertyValue == null ? null : propertyValue.toString());
        } else {
            this.setPropertyInternal(propertyName, propertyValue, useAsIs);
        }
    }

    public Object getProperty(String propertyName) {
        if (this.properties == null) {
            return null;
        }
        NameValue nv = this.properties.get(propertyName.trim().toLowerCase());
        if (nv == null) {
            return null;
        }
        if (nv.value instanceof List && ((List)nv.value).get(0) instanceof String) {
            Vector newListValue = new Vector();
            newListValue.addAll((List)nv.value);
            return newListValue;
        }
        return nv.value;
    }

    public boolean isMessageType(String messageType) {
        String myMsgType = this.getMessageType();
        if (messageType == null) {
            return myMsgType == null;
        }
        return messageType.equalsIgnoreCase(myMsgType);
    }

    public String getMessageType() {
        if (this.messageType == null) {
            this.messageType = (String)this.getProperty(MESSAGE_TYPE);
        }
        return this.messageType;
    }

    public boolean isMessageType(String[] types) {
        for (String msgType : types) {
            if (!this.isMessageType(msgType)) continue;
            return true;
        }
        return false;
    }

    public String getTransactionId() {
        return (String)this.getProperty(TRANSACTION_ID_TAG);
    }

    public String getVerb() {
        Element vElt = null;
        if (this.root == null || (vElt = this.root.getChild(VERB_TAG)) == null) {
            return null;
        }
        return vElt.getText();
    }

    public void setSelection(Vector<String> selection) {
        this.setProperty(SELECTION, selection);
    }

    public void setSelection(String selection) {
        this.setProperty(SELECTION, MessageObject.s2v(selection));
    }

    public Vector<String> getSelection() {
        return (Vector)this.getProperty(SELECTION);
    }

    public void setAction(Vector<String> action) {
        this.setProperty(ACTION, action);
    }

    public void setAction(String action) {
        this.setProperty(ACTION, MessageObject.s2v(action));
    }

    public Vector<String> getAction() {
        return (Vector)this.getProperty(ACTION);
    }

    public void setInput(Vector<String> input) {
        this.setProperty(INPUT, input);
    }

    public void setInput(String input) {
        this.setProperty(INPUT, MessageObject.s2v(input));
    }

    public Vector<String> getInput() {
        return (Vector)this.getProperty(INPUT);
    }

    public MessageObject copy() {
        return (MessageObject)this.clone();
    }

    protected Object clone() {
        MessageObject result = MessageObject.parse(this.toString());
        return result;
    }

    public List getPropertyValues() {
        ArrayList<Object> values = new ArrayList<Object>();
        for (NameValue nv : this.properties.values()) {
            if (nv == null || nv.name == null) continue;
            values.add(nv.value);
        }
        return values;
    }

    public List<String> getPropertyNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (NameValue nv : this.properties.values()) {
            if (nv == null || nv.name == null) continue;
            names.add(nv.name);
        }
        return names;
    }

    public void suppressLogging(boolean b) {
        this.doNotLog = b;
    }

    public boolean isLoggingSuppressed() {
        return this.doNotLog;
    }

    public Integer getPropertyAsInteger(String propertyName) {
        try {
            Object obj = this.getProperty(propertyName);
            if (obj instanceof Integer) {
                return (Integer)obj;
            }
            Integer result = Integer.valueOf((String)obj);
            return result;
        }
        catch (Exception e) {
            trace.errStack("cannot convert property " + propertyName + " to int", e);
            return null;
        }
    }

    public Boolean getPropertyAsBoolean(String propertyName) {
        try {
            Object obj = this.getProperty(propertyName);
            if (obj == null) {
                return null;
            }
            Boolean result = Boolean.valueOf((String)obj);
            return result;
        }
        catch (Exception e) {
            trace.errStack("cannot convert property " + propertyName + " to Boolean", e);
            return null;
        }
    }

    public synchronized void send(Target destinationTarget) {
        Integer messageInt = new Integer(0);
        messageInt = (Integer)this.getProperty("MESSAGENUMBER");
        if (messageInt == null) {
            this.setProperty("MESSAGENUMBER", Communicator.messageNumber);
            Communicator.addMessage(Communicator.messageNumber, this);
            ++Communicator.messageNumber;
        }
        try {
            CommManager.instance().sendJavaMessage(this);
        }
        catch (NullPointerException e) {
            trace.err("Can't find CommManager: null pointer exception");
        }
        catch (NoClassDefFoundError e) {
            trace.err("Can't find CommManager: no class def found");
        }
        catch (Exception e) {
            trace.err("CommManager: exception = " + e);
        }
        if (showMessage && destinationTarget != null) {
            destinationTarget.transmitEvent(this);
        }
    }

    public String getParsedParameterString() {
        String outstring = "";
        List<String> Names = this.getPropertyNames();
        List Values2 = this.getPropertyValues();
        for (int i = 0; i < Names.size(); ++i) {
            outstring = outstring + Names.get(i) + "=" + Values2.get(i) + "|";
        }
        return outstring;
    }

    private static boolean cmp(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        if (o2 == null) {
            return o1 == null;
        }
        if (o1 instanceof String && o2 instanceof String) {
            return ((String)o1).equalsIgnoreCase((String)o2);
        }
        return o1.equals(o2);
    }

    public boolean matchProperty(String name, Object value) {
        Object property = this.getProperty(name);
        trace.out("sp", "matchProperty(" + name + ", " + value + ", (" + property.getClass() + ")" + property + ")");
        if (property instanceof Vector) {
            for (Object o : (Vector)property) {
                if (!MessageObject.cmp(value, o)) continue;
                return true;
            }
            return false;
        }
        return MessageObject.cmp(value, property);
    }

    public void addPropertyElement(String name, Object value) {
        Object prev = this.getProperty(name);
        trace.out("sp", "addPropertyElement(" + name + ", " + value + ") before: " + prev);
        if (prev instanceof Vector) {
            Vector v = (Vector)prev;
            v.add(value);
        } else if (prev == null) {
            Vector<Object> v = new Vector<Object>();
            v.add(value);
            this.setProperty(name, value, true);
        } else {
            throw new IllegalStateException("addPropertyElement(" + name + ", " + value + "): property already exists with value " + prev);
        }
        trace.out("sp", "addPropertyElement(" + name + ", " + value + ") after: " + this.getProperty(name));
    }

    public String getDataShopElementString() {
        try {
            throw new RuntimeException("Not yet implemented");
        }
        catch (Exception e) {
            trace.errStack("DataShop element for MessageObject", e);
            return null;
        }
    }

    public String getFirstSelection() {
        return this.getSelection0();
    }

    public String getSelection0() {
        Vector<String> selections = this.getSelection();
        if (selections == null || selections.size() < 1) {
            return null;
        }
        return selections.get(0);
    }

    public String getFirstAction() {
        return this.getAction0();
    }

    public String getAction0() {
        Vector<String> actions = this.getAction();
        if (actions == null || actions.size() < 1) {
            return null;
        }
        return actions.get(0);
    }

    public String getFirstInput() {
        return this.getInput0();
    }

    public String getInput0() {
        Vector<String> inputs = this.getInput();
        if (inputs == null || inputs.size() < 1) {
            return null;
        }
        return inputs.get(0);
    }

    public static Object getValue(Vector propertyNames, Vector propertyValues, String propertyName) {
        int pos = MessageObject.fieldPosition(propertyNames, propertyName);
        if (pos != -1) {
            return propertyValues.elementAt(pos);
        }
        return null;
    }

    public static int fieldPosition(Vector from, String fieldName) {
        int toret = -1;
        int s = from.size();
        for (int i = 0; i < s; ++i) {
            Object o = from.elementAt(i);
            if (!((String)o).equalsIgnoreCase(fieldName)) continue;
            return i;
        }
        return toret;
    }

    public void setTransactionInfo(TransactionInfo.Single transactionInfo) {
        if (this.transactionInfo == null) {
            this.transactionInfo = transactionInfo;
        }
    }

    public TransactionInfo.Single getTransactionInfo() {
        return this.transactionInfo;
    }

    static {
        Format fmt = Format.getCompactFormat();
        fmt.setExpandEmptyElements(false);
        fmt.setOmitDeclaration(true);
        fmt.setLineSeparator("");
        fmt.setIndent("");
        fmt.setTextMode(Format.TextMode.TRIM);
        noWhiteSpaceOutputter.setFormat(fmt);
        singleLineOutputter = new XMLOutputter();
        fmt = Format.getRawFormat();
        fmt.setOmitDeclaration(true);
        fmt.setLineSeparator("");
        fmt.setIndent("");
        fmt.setTextMode(Format.TextMode.PRESERVE);
        singleLineOutputter.setFormat(fmt);
        multiLineOutputter = new XMLOutputter();
        fmt = Format.getPrettyFormat();
        fmt.setOmitDeclaration(true);
        fmt.setLineSeparator("\r\n");
        fmt.setIndent("    ");
        fmt.setTextMode(Format.TextMode.PRESERVE);
        multiLineOutputter.setFormat(fmt);
        quitMsg = new Element(QUIT_MSG);
        hasControlChar = Pattern.compile("\\p{Cntrl}");
        showMessage = false;
    }

    private class NameValue
    implements Serializable {
        final String name;
        final Object value;

        NameValue(String name, Object value) {
            this(name, value, false);
        }

        NameValue(String name, Object value, boolean useValueAsIs) {
            this.name = name;
            if (value == null) {
                this.value = null;
            } else if (useValueAsIs) {
                this.value = value;
            } else if (!(value instanceof List)) {
                this.value = value.toString();
            } else if (((List)value).size() < 1) {
                this.value = new Vector();
            } else if (((List)value).get(0) instanceof String) {
                this.value = new Vector();
                ((List)this.value).addAll((List)value);
            } else {
                this.value = new Vector();
                ((List)this.value).addAll((List)value);
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("(");
            sb.append(this.name).append(',').append(this.value).append(")");
            return sb.toString();
        }
    }
}

