/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.TutoringService;

import edu.cmu.hcii.ctat.CTATBase;
import edu.cmu.hcii.ctat.CTATHTTPSServer;
import edu.cmu.hcii.ctat.ExitableServer;
import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.Controller.CTAT_Properties;
import edu.cmu.pact.BehaviorRecorder.Controller.SingleSessionLauncher;
import edu.cmu.pact.Preferences.PreferencesModel;
import edu.cmu.pact.SocketProxy.LogServlet;
import edu.cmu.pact.SocketProxy.SocketProxy;
import edu.cmu.pact.TutoringService.Collaborators;
import edu.cmu.pact.TutoringService.TSLogInfo;
import edu.cmu.pact.TutoringService.TransactionInfo;
import edu.cmu.pact.Utilities.EventLogger;
import edu.cmu.pact.Utilities.LoggingSupport;
import edu.cmu.pact.Utilities.NtpClient;
import edu.cmu.pact.Utilities.SocketReader;
import edu.cmu.pact.Utilities.Utils;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.MessageObject;
import edu.cmu.pslc.logging.LogContext;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.Socket;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.jdom.Element;
import pact.CommWidgets.RemoteToolProxy;

public abstract class TSLauncherServer
implements ExitableServer {
    public static final int DEFAULT_SERVER_PORT = 1502;
    public static final String KEYSTORE_ARG = "keystore";
    public static final String WEB_SOCKET_PORT_ARG = "wsPort";
    public static final String SECURE_WEB_SOCKET_PORT_ARG = "wssPort";
    public static final int DEFAULT_HTTP_SERVER_PORT = 12022;
    public static final int DEFAULT_HTTPS_SERVER_PORT = 12043;
    protected static final int DEFAULT_WEB_SOCKET_PORT = 20080;
    protected static final int DEFAULT_SECURE_WEB_SOCKET_PORT = 20443;
    protected static String keystore = null;
    protected Collaborators.All allCollaborators = new Collaborators.All();
    private CTAT_Properties properties;
    private final Random gen = new Random(System.currentTimeMillis());
    private LogContext logger;
    private EventLogger eventLogger;
    private PreferencesModel preferencesModel;
    protected TSLogInfo.Session httpLogInfo;
    protected LogServlet logServlet;
    protected TSLogInfo logInfo = new TSLogInfo();
    protected String sessionsMutex = "sessionsMutex";
    protected HashMap<String, Session> sessions = new HashMap();

    private void initLogging() {
        this.logger = new LoggingSupport(this);
        this.eventLogger = new EventLogger(this.getLogger());
        this.getProperties().addPropertyChangeListener(this.getLogger());
    }

    public PreferencesModel getPreferencesModel() {
        if (this.preferencesModel == null) {
            this.preferencesModel = new PreferencesModel();
            this.preferencesModel.setPreventSaves(Utils.isRuntime());
        }
        return this.preferencesModel;
    }

    public void setLogger(LogContext lc) {
        this.logger = lc;
    }

    public LoggingSupport getLoggingSupport() {
        return (LoggingSupport)this.logger;
    }

    public LoggingSupport getLogger() {
        return this.getLoggingSupport();
    }

    public CTAT_Properties getProperties() {
        return this.properties;
    }

    public Random getRandomGenerator() {
        return this.gen;
    }

    public EventLogger getEventLogger() {
        return this.eventLogger;
    }

    public void setEventLogger(EventLogger eventLogger) {
        this.eventLogger = eventLogger;
    }

    public abstract boolean removeSession(String var1);

    public abstract void updateTimeStamp(String var1);

    public abstract TransactionInfo.Single createTransactionInfo(String var1);

    public abstract void updateTransactionInfo(String var1, Object var2);

    public abstract NtpClient getNtpClient();

    public void startAuthorTimeCollaboration(int teamSize) {
    }

    public void stopAuthorTimeCollaboration() {
    }

    public String editGuidForCollaboration(String guid) {
        return guid;
    }

    public Collaborators checkForCollaborators(String sessionId, MessageObject setPrefs) throws Collaborators.NotReadyException {
        Session s = this.getSession(sessionId);
        if (s == null) {
            return null;
        }
        Collaborators result = Collaborators.create(s, setPrefs);
        return result;
    }

    public int enqueueToCollaborators(String guid, MessageObject mo) {
        if (trace.getDebugCode("collab")) {
            trace.out("collab", "enqueueToCollab(" + guid + ", " + mo.summary() + ") gets session " + this.getSession(guid));
        }
        if (!Collaborators.isMsgToBeShared(mo)) {
            return 0;
        }
        Session s = this.getSession(guid);
        if (s == null) {
            return -1;
        }
        return this.allCollaborators.enqueueToCollaborators(s, mo);
    }

    public void endCollaboration(String sessionId) {
        Session sess = this.getSession(sessionId);
        if (sess == null) {
            return;
        }
        Collaborators.remove(sess);
    }

    Collaborators.All getAllCollaborators() {
        return this.allCollaborators;
    }

    public Collaborators getCollaborators(String sessionId) {
        Session sess = this.getSession(sessionId);
        if (sess == null) {
            return null;
        }
        return this.getAllCollaborators().getCollaborators(sess);
    }

    public Collaborators.Collaborator findCollaborator(String sessionId) {
        Session sess = this.getSession(sessionId);
        if (sess == null) {
            return null;
        }
        return this.getAllCollaborators().findCollaborator(sess);
    }

    public MessageObject editSetPreferences(MessageObject setPrefs, String sessionID) {
        return setPrefs;
    }

    private void close(Reader br, Socket lSock) {
        try {
            if (br != null) {
                br.close();
            }
        }
        catch (Exception e) {
            trace.err("LauncherServer.close(): Error closing socket stream: " + e + "; cause " + e.getCause());
        }
        try {
            if (lSock != null) {
                lSock.close();
            }
        }
        catch (Exception es) {
            trace.err("Error closing socket: " + es + "; cause " + es.getCause());
        }
    }

    protected static void parseCmdLine(String[] args, List<Integer> jsonPorts, List<Integer> wsPorts, List<Integer> wssPorts, List<Integer> httpPorts, List<Integer> httpsPorts, List<Integer> tcpPorts, String tcpArgLabel) {
        List<Integer> currentList = tcpPorts;
        if (trace.getDebugCode("ls")) {
            trace.out("ls", String.format("TSLS.parseCmdLine(%s))", Arrays.asList(args).toString()));
        }
        int i = -1;
        try {
            int j;
            for (i = 0; i < args.length; ++i) {
                String arg = args[i];
                if (trace.getDebugCode("ls")) {
                    trace.out("ls", String.format("TSLS.parseCmdLine() arg[%2d]=%s;", i, arg));
                }
                if ("-json".equalsIgnoreCase(arg)) {
                    currentList = jsonPorts;
                    continue;
                }
                if ("-wsPort".equalsIgnoreCase(arg)) {
                    currentList = wsPorts;
                    continue;
                }
                if ("-wssPort".equalsIgnoreCase(arg)) {
                    currentList = wssPorts;
                    continue;
                }
                if ("-h".equalsIgnoreCase(arg)) {
                    currentList = httpPorts;
                    continue;
                }
                if ("-s".equalsIgnoreCase(arg)) {
                    currentList = httpsPorts;
                    continue;
                }
                if (tcpArgLabel.equalsIgnoreCase(arg)) {
                    currentList = tcpPorts;
                    continue;
                }
                if ("-keystore".equalsIgnoreCase(arg)) {
                    keystore = args[++i];
                    continue;
                }
                if (arg.startsWith("-")) {
                    currentList = null;
                    continue;
                }
                if (currentList == null) continue;
                currentList.add(new Integer(arg));
            }
            int n = j = jsonPorts == null ? -1 : jsonPorts.size() - 1;
            while (0 <= j) {
                Integer jp = jsonPorts.get(j);
                if (!(httpPorts.contains(jp) || httpsPorts.contains(jp) || wsPorts.contains(jp) || wssPorts.contains(jp))) {
                    throw new IllegalArgumentException("Bad command line argument: -json port " + jp + " is not an http or https or " + WEB_SOCKET_PORT_ARG + " or " + SECURE_WEB_SOCKET_PORT_ARG + " port");
                }
                --j;
            }
        }
        catch (Exception e) {
            trace.err("Fatal error: error at argument " + (i + 1) + " \"" + (i < args.length ? args[i] : "") + "\": " + e);
            System.err.printf("\nCommand-line arguments are\n    \"[-json jsonPort...] [-%s wsPort...] [-%s wssPort...] [-h httpPort...] [-s httpsPort...] [%s tcpPort...] [-keystore file.jks]\"\nwhere--\n    jsonPort... is a space-separated list of ports on which HTTP output should be in JSON;\n                default is XML output; each port must also be a wsPort, httpPort or httpsPort;\n    wsPort... is a space-separated list of ports on which to listen for Web Socket (WS) clients;\n    wssPort... is a space-separated list of ports on which to listen for Secure Web Socket (WSS) clients;\n    httpPort... is a space-separated list of ports on which to listen for HTTP clients;\n    httpsPort... is a space-separated list of ports on which to listen for HTTPS clients;\n    tcpPort... is a space-separated list of ports on which to listen for TCP socket clients;\n    file.jks is the full path to the JKS keystore file for https connections (default %s);\nby default, listens on HTTP port %d, HTTPS port %d, WS port %d, WSS port %d and TCP port %d.\n", WEB_SOCKET_PORT_ARG, SECURE_WEB_SOCKET_PORT_ARG, tcpArgLabel, CTATHTTPSServer.defaultKeystore, 12022, 12043, 20080, 20443, 1502);
            System.exit(2);
        }
    }

    public TSLauncherServer() {
        this.properties = new CTAT_Properties(this);
        this.initLogging();
        PreferencesModel prefs = new PreferencesModel();
        prefs.setPreventSaves(true);
        this.logServlet = new LogServlet(prefs, true);
        this.httpLogInfo = this.logInfo.create();
        this.logServlet.setLogInfo(this.httpLogInfo);
        if (trace.getDebugCode("ls")) {
            trace.out("ls", "TS LS constructor completed");
        }
    }

    TSLogInfo.Session getHttpLogInfo() {
        return this.httpLogInfo;
    }

    public TSLogInfo.Session getLogInfo(String sessionId) {
        TSLogInfo.Session result = null;
        Session session = this.getSession(sessionId);
        if (trace.getDebugCode("logservice")) {
            trace.out("logservice", "ls.getLogInfo: session variable is " + session);
        }
        if (session != null) {
            result = session.getLogInfo();
        }
        if (trace.getDebugCode("logservice")) {
            trace.out("logservice", "ls.getLogInfo(" + sessionId + ")  returns " + result);
        }
        return result;
    }

    TSLogInfo getSummaryLogInfo() {
        return this.logInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session getSession(String guid) {
        String string = this.sessionsMutex;
        synchronized (string) {
            return this.sessions.get(guid);
        }
    }

    public String addNewSession(String guid) {
        Session session = new Session(guid, null);
        this.addSession(session);
        if (trace.getDebugCode("tab")) {
            trace.out("tab", "TSLauncherServer.addNewSession: guid = " + guid + "\n    user_guid = " + null + "\n    session = " + session);
        }
        return session.getGuid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session addSession(Session session) {
        try {
            String string = this.sessionsMutex;
            synchronized (string) {
                String key = session.getGuid();
                if (key == null || key.trim().length() < 1) {
                    throw new IllegalArgumentException("null or empty key \"+key+\"");
                }
                Session result = this.sessions.put(key, session);
                if (trace.getDebugCode("ls")) {
                    trace.printStack("ls", "added session " + key + "; found prior entry " + result + "; sessions.size() now " + this.sessions.size());
                }
                return result;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getSessionKeys() {
        String string = this.sessionsMutex;
        synchronized (string) {
            return this.sessions.keySet();
        }
    }

    Element generateSessionElement(String guid) {
        CTATBase.debug("LauncherServer", "generateSessionElement(String guid)");
        Session sess = this.getSession(guid);
        if (sess == null) {
            trace.err("null session object for guid \"" + guid + "\"");
            return null;
        }
        Element session = new Element("session");
        session.setAttribute("guid", guid == null ? "null" : guid);
        session.setAttribute("lastMessage", String.format("%d", sess.getTimeStamp().getTime()));
        session.setAttribute("ip", sess.getIPAddr());
        Map<String, String> txInfo = sess.getTxInfo().toAttributesRaw();
        for (String key : txInfo.keySet()) {
            session.setAttribute(key, txInfo.get(key));
        }
        Map<String, String> logInfo = sess.getLogInfo().toAttributes();
        for (String key : logInfo.keySet()) {
            session.setAttribute(key, logInfo.get(key));
        }
        return session;
    }

    LogServlet getLogServlet() {
        return this.logServlet;
    }

    public void shutdown() {
    }

    @Override
    public boolean isExiting() {
        return false;
    }

    @Override
    public boolean startExiting() {
        return false;
    }

    public abstract boolean isAuthorMode();

    public int getWSPort() {
        return -1;
    }

    public class Session
    extends Thread {
        protected int serverPort;
        protected Socket lSock;
        protected MessageObject setPreferencesMsg = null;
        protected String brdFile;
        protected String guid;
        protected Date timeStamp;
        protected String ipAddr;
        protected SingleSessionLauncher launcher;
        protected BR_Controller controller;
        protected TransactionInfo txInfo = new TransactionInfo();
        protected TSLogInfo.Session logInfo;
        protected SocketProxy socketProxy;
        protected String userGuid;
        protected String schoolName;
        protected String team;
        protected int msgFormat = 1;
        private long lastReceiptTime = -1L;

        public int getServerPort() {
            return this.serverPort;
        }

        public void setServerPort(int serverPort) {
            this.serverPort = serverPort;
        }

        protected void clearFields() {
            if (this.getLauncherServer() == null) {
                trace.err("TSLauncherSession.clearFields(): getLauncherServer() returns null");
            } else if (!this.getLauncherServer().removeSession(this.guid)) {
                trace.err("TSLauncherSession.clearFields(): removeSession() didn't find my guid " + this.guid);
            }
            this.brdFile = null;
            this.controller = null;
            this.guid = null;
            this.ipAddr = null;
            this.launcher = null;
            this.logInfo = null;
            this.lSock = null;
            this.schoolName = null;
            this.setPreferencesMsg = null;
            this.socketProxy = null;
            this.team = null;
            this.timeStamp = null;
            this.txInfo = null;
            this.userGuid = null;
        }

        public Session(String guid, String userGuid) {
            this.guid = guid;
            this.userGuid = userGuid;
            if (TSLauncherServer.this.logInfo != null) {
                this.logInfo = TSLauncherServer.this.logInfo.create();
            }
        }

        Session(Socket sock) {
            this.lSock = sock;
            if (TSLauncherServer.this.logInfo != null) {
                this.logInfo = TSLauncherServer.this.logInfo.create();
            }
        }

        public String getGuid() {
            return this.guid;
        }

        private void setGuid(String guid) {
            this.guid = guid;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reviseGuid(String guid) {
            String string = TSLauncherServer.this.sessionsMutex;
            synchronized (string) {
                Session sessInTbl = TSLauncherServer.this.sessions.get(this.getGuid());
                if (sessInTbl != this) {
                    trace.err("For guid " + this.getGuid() + ", session in table not match this:\n  in table (" + trace.nh(sessInTbl) + "): " + sessInTbl + ";\n  this one (" + trace.nh(this) + "): " + this);
                }
                TSLauncherServer.this.sessions.remove(this.getGuid());
                this.setGuid(guid);
                TSLauncherServer.this.addSession(this);
                SingleSessionLauncher ssl = this.getLauncher();
                if (ssl != null) {
                    ssl.setSessionId(guid);
                    BR_Controller ctlr = ssl.getController();
                    if (ctlr != null) {
                        ctlr.getProperties().setProperty("guid", guid);
                    }
                }
            }
        }

        private void connectSocket(Socket sock, int msgFormat, BufferedReader br) {
            SocketProxy sp = new SocketProxy(sock, msgFormat);
            this.controller.setRemoteProxy(sp);
            sp.setController(this.controller, br);
            this.setSocketProxyParameters(sp);
            sp.start();
        }

        private void setSocketProxyParameters(SocketProxy sp) {
            sp.setEom(0);
            sp.setUseSingleSocket(true);
            sp.setOneMsgPerSocket(false);
            sp.setMsgFormat(Integer.toString(1));
            sp.setServerPort(this.serverPort);
        }

        protected void updateTimeStamp() {
            this.setTimeStamp(new Date());
        }

        public int getMsgFormat() {
            return this.msgFormat;
        }

        public MessageObject getSetPreferencesMsg() {
            return this.setPreferencesMsg;
        }

        public void setSetPreferencesMsg(MessageObject msg) {
            if (!"SetPreferences".equalsIgnoreCase(msg.getMessageType())) {
                throw new IllegalArgumentException("Session.setSetPreferencesMsg() Wrong message type " + msg.getMessageType() + ";\n  text: " + msg.toElement());
            }
            this.setPreferencesMsg = msg;
        }

        @Override
        public void run() {
            BufferedReader br = null;
            try {
                String result;
                if (trace.getDebugCode("ls")) {
                    trace.outNT("ls", "Trying to get GUID");
                }
                if (SocketProxy.handlePolicyFileRequest(result = SocketReader.readToEom(br = new BufferedReader(new InputStreamReader(this.lSock.getInputStream(), "UTF-8")), 0), this.lSock)) {
                    return;
                }
                if (LogServlet.handleLogRecord(result, TSLauncherServer.this.logServlet, this.lSock)) {
                    return;
                }
                if (trace.getDebugCode("ls")) {
                    trace.outNT("ls", "LauncherServer.Session possible Guid: " + result);
                }
                this.guid = MessageObject.getPropertyFromXML(result, "Guid");
                if (this.guid == null) {
                    if (trace.getDebugCode("ls")) {
                        trace.outNT("ls", "LauncherServer.Session: Null guid, closing socket");
                    }
                    TSLauncherServer.this.close(br, this.lSock);
                    return;
                }
                this.msgFormat = RemoteToolProxy.deriveMsgFormat(result);
                Session oldSession = TSLauncherServer.this.getSession(this.guid);
                if (oldSession == null || oldSession.controller == null) {
                    this.setGuid(this.guid);
                    result = SocketReader.readToEom(br, 0);
                    if (trace.getDebugCode("tsltsp")) {
                        trace.outNT("tsltsp", "" + this.guid + " " + result);
                    }
                    if (result.length() < 1) {
                        if (trace.getDebugCode("ls")) {
                            trace.outNT("ls", "LauncherServer.Session: empty SetPreferences, closing socket " + result.length());
                        }
                        TSLauncherServer.this.close(br, this.lSock);
                        return;
                    }
                    this.setPreferencesMsg = SocketProxy.convertMsg(result, this.msgFormat);
                    String s = "(none)";
                    if (this.setPreferencesMsg == null || !"SetPreferences".equalsIgnoreCase(s = this.setPreferencesMsg.getMessageType())) {
                        if (trace.getDebugCode("ls")) {
                            trace.outNT("ls", "Set pref msg turned out to be null or msg type " + s);
                        }
                        TSLauncherServer.this.close(br, this.lSock);
                        return;
                    }
                    this.getSetPreferencesMsg().setTransactionInfo(this.txInfo.create());
                    if (!this.findBRDFilename(this.getSetPreferencesMsg())) {
                        TSLauncherServer.this.close(br, this.lSock);
                        return;
                    }
                }
            }
            catch (Exception e) {
                trace.errStack("LauncherServer.Session.run() 1st half error, closing socket: ", e);
                if (trace.getDebugCode("ls")) {
                    trace.outNT("ls", "Exception in session.run : " + e);
                }
                TSLauncherServer.this.close(null, this.lSock);
                return;
            }
            try {
                Session oldSession = TSLauncherServer.this.addSession(this);
                if (oldSession == null || oldSession.controller == null) {
                    this.setLoggingProperties(this.getSetPreferencesMsg());
                    if (trace.getDebugCode("ls")) {
                        trace.out("ls", "LauncherServer: new session: guid " + this.guid + ", school " + this.schoolName + ", userGuid " + this.userGuid + "\n  BRD File = " + this.brdFile);
                    }
                    this.setupController(br);
                    this.setSocketProxy((SocketProxy)this.controller.getRemoteProxy());
                    this.controller.getRemoteProxy().setupLogServlet(this.getSetPreferencesMsg());
                    this.processSetPreferences();
                    this.setTimeStamp(new Date());
                } else {
                    trace.out("ls", "LauncherServer: session recovered: guid " + this.guid + ", getUserGuid() " + this.getUserGuid());
                    this.setTimeStamp(oldSession.getTimeStamp());
                    this.setUserGuid(oldSession.getUserGuid());
                    this.setTeam(oldSession.getTeam());
                    this.setSchoolName(oldSession.getSchoolName());
                    this.setLauncher(oldSession.getLauncher());
                    this.controller = oldSession.controller;
                    this.brdFile = oldSession.brdFile;
                    this.setSetPreferencesMsg(oldSession.getSetPreferencesMsg());
                    this.connectSocket(this.lSock, this.getMsgFormat(), br);
                    this.controller.getRemoteProxy().setupLogServlet(this.getSetPreferencesMsg());
                }
                this.setIPAddr(this.lSock.getInetAddress().getHostAddress());
            }
            catch (Exception e) {
                trace.errStack("LauncherServer.Session.run() 2nd half error on guid " + this.guid + ", closing socket", e);
                TSLauncherServer.this.close(null, this.lSock);
                return;
            }
        }

        protected void processSetPreferences() {
            if (this.getSetPreferencesMsg() != null && this.controller != null) {
                this.controller.handleCommMessage(this.getSetPreferencesMsg());
                this.getSetPreferencesMsg().getTransactionInfo().update(Boolean.TRUE);
            }
        }

        public BR_Controller setupController(BufferedReader br) {
            this.createLauncher(br);
            this.getLauncher().setSessionId(this.guid);
            this.controller = this.getLauncher().getController();
            trace.out("sp", "LauncherServer.Session.run() controller " + this.controller + ", setPreferencesMsg " + this.getSetPreferencesMsg());
            return this.controller;
        }

        protected void createLauncher(BufferedReader br) {
            String[] argv = new String[]{"-Dguid=" + this.guid, "-DisOnline=true", "-Dschool_name=School1", "-Dcourse_name=\"Course1\"", "-DBehaviorRecorderMode=Example-tracing Tutor", "-DBehaviorRecorderVisible=false", "-spEOM", "00", "-spUseSingleSocket", "true", "-spOneMsgPerSocket", "false", "-spMsgFormat", String.valueOf(this.getMsgFormat()), "-spServerPort", Integer.toString(this.serverPort), "-debugCodes"};
            this.setLauncher(new SingleSessionLauncher(this.lSock, br, argv, false, TSLauncherServer.this, this.getSetPreferencesMsg(), null));
        }

        protected void setLoggingProperties(MessageObject setPrefsMsg) {
            this.setTeam(Collaborators.getUserids(setPrefsMsg, null).toString());
            this.setSchoolName((String)setPrefsMsg.getProperty("school_name"));
            this.setUserGuid((String)setPrefsMsg.getProperty("user_guid"));
        }

        protected boolean findBRDFilename(MessageObject setPrefsMsg) {
            String brdFileP = (String)setPrefsMsg.getProperty("ProblemName");
            String brdFileQ = (String)setPrefsMsg.getProperty("question_file");
            String string = this.brdFile = brdFileP != null && brdFileP.length() > 0 ? brdFileP : brdFileQ;
            if (this.brdFile == null || this.brdFile.length() < 1) {
                if (trace.getDebugCode("ls")) {
                    trace.outNT("ls", "LauncherServer.Session: SetPreferences has no brdFile, exiting");
                }
                return false;
            }
            return true;
        }

        public String getSchoolName() {
            return this.schoolName;
        }

        public void setSchoolName(String schoolName) {
            this.schoolName = schoolName == null ? "" : schoolName;
        }

        public String getTeam() {
            return this.team;
        }

        public void setTeam(String team) {
            this.team = team;
        }

        public void setUserGuid(String userGuid) {
            this.userGuid = userGuid == null ? "" : userGuid;
        }

        public String getUserGuid() {
            return this.userGuid;
        }

        SocketProxy getSocketProxy() {
            return this.socketProxy;
        }

        void setSocketProxy(SocketProxy socketProxy) {
            this.socketProxy = socketProxy;
        }

        public void setTimeStamp(Date timeStamp) {
            this.timeStamp = timeStamp;
        }

        public Date getTimeStamp() {
            return this.timeStamp;
        }

        public String getIPAddr() {
            return this.ipAddr;
        }

        protected void setIPAddr(String ipAddr) {
            this.ipAddr = ipAddr;
        }

        public TransactionInfo getTxInfo() {
            return this.txInfo;
        }

        public TSLogInfo.Session getLogInfo() {
            return this.logInfo;
        }

        public BR_Controller getController() {
            return this.controller;
        }

        public void setController(BR_Controller controller) {
            this.controller = controller;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder("[guid=");
            sb.append(this.guid).append(", userguid=");
            sb.append(this.userGuid).append(", schoolName=");
            sb.append(this.schoolName).append(", getLogInfo=");
            sb.append(this.getLogInfo().toString()).append(", team=");
            sb.append(this.team).append(", super=");
            sb.append(super.toString()).append("]");
            return sb.toString();
        }

        protected TSLauncherServer getLauncherServer() {
            return TSLauncherServer.this;
        }

        public void setLauncher(SingleSessionLauncher launcher) {
            this.launcher = launcher;
        }

        protected SingleSessionLauncher getLauncher() {
            return this.launcher;
        }

        public long getLastReceiptTime() {
            return this.lastReceiptTime;
        }

        public void setLastReceiptTime(long currentTimeMillis) {
            this.lastReceiptTime = currentTimeMillis;
        }
    }
}

