/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.jgraphwindow;

import com.jgraph.layout.JGraphFacade;
import com.jgraph.layout.tree.JGraphTreeLayout;
import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.Controller.PseudoTutorMessageHandler;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemEdge;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemNode;
import edu.cmu.pact.BehaviorRecorder.View.ActionLabel;
import edu.cmu.pact.BehaviorRecorder.View.CheckLispLabel;
import edu.cmu.pact.BehaviorRecorder.View.NodeView;
import edu.cmu.pact.BehaviorRecorder.View.RuleLabel;
import edu.cmu.pact.BehaviorRecorder.jgraphwindow.BR_JGraphEdge;
import edu.cmu.pact.BehaviorRecorder.jgraphwindow.BR_JGraphEdgeView;
import edu.cmu.pact.BehaviorRecorder.jgraphwindow.BR_JGraphNode;
import edu.cmu.pact.BehaviorRecorder.jgraphwindow.BR_JGraphVertexView;
import edu.cmu.pact.BehaviorRecorder.jgraphwindow.MarathonElement;
import edu.cmu.pact.BehaviorRecorder.jgraphwindow.Utils;
import edu.cmu.pact.Utilities.trace;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import org.jgraph.JGraph;
import org.jgraph.event.GraphModelEvent;
import org.jgraph.event.GraphModelListener;
import org.jgraph.graph.CellView;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.DefaultPort;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;
import org.jgraph.plaf.GraphUI;
import org.jgraph.plaf.basic.BasicGraphUI;

public class BR_JGraph
extends JGraph
implements KeyListener,
GraphModelListener {
    private static final long serialVersionUID = 8334138326832536564L;
    private BR_JGraphNode rootCell;
    private JGraphTreeLayout jgraphTreeLayout;
    private GraphLayoutCache graphView;
    private BR_Controller brController;
    private Rectangle clip;
    private boolean ignoreGraphModelEvents = false;
    private ProblemEdge problemEdge;
    private Object mousePressedCell;
    private Point mouseDownPoint;
    private DefaultGraphCell mouseOverCell;
    private ProblemNode mergeCandidate;
    private ProblemNode currentVisitNode;
    private int startX = -1;
    private int startY = -1;
    public PseudoTutorMessageHandler pseudoTutorMessageHandler;
    int keyMask;

    public BR_JGraph(GraphModel graphModel, GraphLayoutCache graphView, BR_Controller brController) {
        super(graphModel, graphView);
        this.graphView = graphView;
        this.graphModel = graphModel;
        this.brController = brController;
        ToolTipManager.sharedInstance().registerComponent((JComponent)((Object)this));
        this.setLayout();
        this.setOpaque(false);
        this.keyMask = System.getProperty("os.name").toUpperCase().startsWith("MAC") ? 256 : 128;
    }

    public String getToolTipText(MouseEvent e) {
        Object c;
        String tooltipText = "";
        String click = "Right-click";
        if (System.getProperty("os.name").startsWith("Mac")) {
            click = "Ctrl-click";
        }
        if (e != null && (c = this.getFirstCellForLocation(e.getX(), e.getY())) != null) {
            if (this.mouseOverCell != null && this.mouseOverCell instanceof BR_JGraphEdge) {
                this.problemEdge = ((BR_JGraphEdge)this.mouseOverCell).getProblemEdge();
                tooltipText = this.problemEdge.getEdgeData().getTooltipText();
            } else {
                tooltipText = "<html><b>Problem State \"" + this.convertValueToString(c) + "\"</b><br>" + click + " to edit, drag to move, click to go to state.</html>";
            }
            return tooltipText;
        }
        return null;
    }

    public void updateUI() {
        this.setUI((GraphUI)new BasicGraphUI());
        this.invalidate();
        this.addMouseListener();
        this.addKeyListener(this);
        this.addMouseMotionListener();
        this.setHandleColor(Color.RED);
    }

    private void addMouseMotionListener() {
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                BR_JGraph.this.handleMouseDragged(e);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                BR_JGraph.this.handleMouseMoved(e);
            }
        });
    }

    protected void handleMouseDragged(MouseEvent e) {
        int y;
        this.mergeCandidate = null;
        if (this.mousePressedCell == null) {
            return;
        }
        if (!(this.mousePressedCell instanceof BR_JGraphNode)) {
            return;
        }
        BR_JGraphNode sourceNode = (BR_JGraphNode)this.mousePressedCell;
        int x = e.getX();
        List list = this.getAllCellsForLocation(x, y = e.getY());
        if (list.size() == 0) {
            return;
        }
        Object topCell = list.get(0);
        if (!(topCell instanceof BR_JGraphNode)) {
            return;
        }
        BR_JGraphNode targetNode = (BR_JGraphNode)topCell;
        ProblemNode targetProblemNode = targetNode.getProblemNode();
        ProblemNode sourceProblemNode = sourceNode.getProblemNode();
        boolean validCandidate = this.brController.getProblemModel().canNodesBeMerged(targetProblemNode, sourceProblemNode, this.brController);
        if (!validCandidate) {
            return;
        }
        this.mergeCandidate = targetProblemNode;
        BR_JGraphVertexView view = (BR_JGraphVertexView)this.graphView.getMapping((Object)targetNode, false);
        this.graphView.update((CellView)view);
        this.repaint();
    }

    private List getAllCellsForLocation(int x, int y) {
        Object cell;
        ArrayList<Object> list = new ArrayList<Object>();
        Object topmostCell = cell = this.getFirstCellForLocation(x, y);
        while (cell != null) {
            list.add(cell);
            if (topmostCell != (cell = this.getNextCellForLocation(cell, x, y))) continue;
            break;
        }
        return list;
    }

    protected void handleMouseMoved(MouseEvent e) {
        Object[] selectedEdge = new Object[1];
        Object cell = this.getFirstCellForLocation(e.getX(), e.getY());
        if (this.mouseOverCell != null && this.mouseOverCell instanceof BR_JGraphEdge) {
            selectedEdge[0] = this.mouseOverCell;
            this.toFront(selectedEdge);
        }
        this.mouseOverCell = (DefaultGraphCell)cell;
        this.repaint();
    }

    private void addMouseListener() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent arg0) {
                BR_JGraph.this.handleMousePressed(arg0);
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
                BR_JGraph.this.handleMouseReleased(arg0);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                BR_JGraph.this.handleMouseClicked(e);
            }
        });
    }

    protected void handleMouseClicked(MouseEvent e) {
        class ClickHandler
        implements Runnable {
            private final MouseEvent e;

            ClickHandler(MouseEvent e) {
                this.e = e;
            }

            @Override
            public void run() {
                Object cell = BR_JGraph.this.getFirstCellForLocation(this.e.getX(), this.e.getY());
                if (trace.getDebugCode("jgraph")) {
                    trace.out("jgraph", " << cell = " + cell + " x: " + this.e.getX() + " y: " + this.e.getY());
                }
                if (cell == null) {
                    return;
                }
                if (cell instanceof BR_JGraphNode) {
                    BR_JGraphNode node = (BR_JGraphNode)cell;
                    if (BR_JGraph.wasRightClick(this.e)) {
                        NodeView.evaluatePopup(this.e, node.getProblemNode(), BR_JGraph.this.brController, true);
                        BR_JGraph.this.mousePressedCell = null;
                        BR_JGraph.this.mouseDownPoint = null;
                    }
                } else if (cell instanceof BR_JGraphEdge) {
                    if (trace.getDebugCode("jgraph")) {
                        trace.out("jgraph", "It is an edge");
                    }
                    if (trace.getDebugCode("jgraph")) {
                        trace.out("jgraph", "cell = " + cell + " x: " + this.e.getX() + " y: " + this.e.getY());
                    }
                    BR_JGraphEdge edge = (BR_JGraphEdge)cell;
                    BR_JGraphEdgeView view = (BR_JGraphEdgeView)BR_JGraph.this.graphView.getMapping((Object)edge, false);
                    view.doClick(this.e);
                }
            }
        }
        ClickHandler clickHandler = new ClickHandler(e);
        SwingUtilities.invokeLater(clickHandler);
    }

    public static boolean wasRightClick(MouseEvent e) {
        int button = e.getButton();
        if (trace.getDebugCode("jgraph")) {
            trace.out("jgraph", "button = " + button);
        }
        return button == 3 || button == 1 && e.isControlDown();
    }

    public JGraphTreeLayout getTreeLayout() {
        return this.jgraphTreeLayout;
    }

    private void setLayout() {
        Object[] roots = new Object[]{this.rootCell};
        this.jgraphTreeLayout = new JGraphTreeLayout();
        this.jgraphTreeLayout.setOrientation(1);
        this.jgraphTreeLayout.setAlignment(0);
        this.jgraphTreeLayout.setPositionMultipleTrees(false);
        this.jgraphTreeLayout.setLevelDistance(60.0);
    }

    public void runTreeLayout(Object rootCell) {
        Object[] roots = new Object[]{rootCell};
        JGraphFacade facade = new JGraphFacade((JGraph)this, roots);
        this.getTreeLayout().run(facade);
        Map nested = facade.createNestedMap(true, false);
        this.graphView.edit(nested);
    }

    private void handleMousePressed(MouseEvent e) {
        if ((e.getModifiersEx() & 0x200) == 512) {
            return;
        }
        this.mousePressedCell = this.getFirstCellForLocation(e.getX(), e.getY());
        if (trace.getDebugCode("jgraph")) {
            trace.out("jgraph", "mouse pressed cell: " + this.mousePressedCell);
        }
        this.mouseDownPoint = new Point(e.getX(), e.getY());
        if (this.mousePressedCell != null && this.mousePressedCell instanceof BR_JGraphNode) {
            Point loc = this.getLocation((BR_JGraphNode)this.mousePressedCell);
            this.startX = (int)loc.getX();
            this.startY = (int)loc.getY();
        }
    }

    private void handleMouseReleased(MouseEvent e) {
        boolean merge = false;
        Point mouseUpPoint = new Point(e.getX(), e.getY());
        if (trace.getDebugCode("jgraph")) {
            trace.out("jgraph", "mouse released: mousepressedCell = " + this.mousePressedCell);
        }
        if (BR_JGraph.wasRightClick(e)) {
            return;
        }
        if (this.mousePressedCell == null) {
            return;
        }
        if (!(this.mousePressedCell instanceof BR_JGraphNode)) {
            return;
        }
        BR_JGraphNode node = (BR_JGraphNode)this.mousePressedCell;
        this.currentVisitNode = (ProblemNode)node.getUserObject();
        this.currentVisitNode.getNodeView().setLocation(mouseUpPoint);
        if (!this.wasMouseMoved(this.mouseDownPoint, mouseUpPoint)) {
            this.brController.problemNodeClicked(this.currentVisitNode);
            return;
        }
        Set descendants = Utils.findDescendants(this.mousePressedCell, this.graphView, this.graphModel);
        if (!e.isMetaDown()) {
            this.moveTree(descendants, this.mouseDownPoint, mouseUpPoint);
        }
        if (this.mergeCandidate != null) {
            merge = true;
            this.brController.mergeStates2(node.getProblemNode(), this.mergeCandidate, true, true, this.mergeCandidate.hasOutGoingPreferredEdge(null));
            this.mergeCandidate = null;
        }
        if (this.mousePressedCell != null && this.mousePressedCell instanceof BR_JGraphNode && !merge) {
            final BR_JGraphNode jgraphNode = (BR_JGraphNode)this.mousePressedCell;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Point loc = BR_JGraph.this.getLocation(jgraphNode);
                    int endX = (int)loc.getX();
                    int endY = (int)loc.getY();
                    if (endX != BR_JGraph.this.startX || endY != BR_JGraph.this.startY) {
                        ActionEvent ae = new ActionEvent(this, 0, "Move Node");
                        BR_JGraph.this.brController.getUndoPacket().getCheckpointAction().actionPerformed(ae);
                    }
                }
            });
        }
    }

    private boolean wasMouseMoved(Point dn, Point up) {
        int D = 10;
        int dx = Math.abs(dn.x - up.x);
        int dy = Math.abs(dn.y - up.y);
        return dx > D || dy > D;
    }

    private void moveTree(Set descendants, Point mouseDownPoint, Point mouseUpPoint) {
        double deltaX = mouseUpPoint.getX() - mouseDownPoint.getX();
        double deltaY = mouseUpPoint.getY() - mouseDownPoint.getY();
        HashMap nestedAttributes = new HashMap();
        for (DefaultGraphCell cell : descendants) {
            Object[] cells = new Object[]{cell};
            CellView[] cellViews = this.graphView.getMapping(cells);
            HashMap attributeMap = new HashMap();
            Rectangle2D bounds = cellViews[0].getBounds();
            Rectangle2D.Double bounds2 = new Rectangle2D.Double(bounds.getX() + deltaX, bounds.getY() + deltaY, bounds.getWidth(), bounds.getHeight());
            GraphConstants.setBounds(attributeMap, (Rectangle2D)bounds2);
            nestedAttributes.put(cells[0], attributeMap);
        }
        this.graphView.edit(nestedAttributes);
    }

    public void paint(Graphics g) {
        this.clip = g.getClipBounds();
        if (this.graphView != null) {
            this.graphView.update(this.graphView.getRoots());
        }
        super.paint(g);
    }

    public Rectangle getClipBounds() {
        return this.clip;
    }

    public DefaultGraphCell getMouseOverCell() {
        return this.mouseOverCell;
    }

    public MarathonElement getMarathonElement(Point location) {
        Object firstCellForLocation = this.getFirstCellForLocation(location.getX(), location.getY());
        if (firstCellForLocation instanceof BR_JGraphNode) {
            return (MarathonElement)firstCellForLocation;
        }
        if (firstCellForLocation instanceof BR_JGraphEdge) {
            return ((BR_JGraphEdge)firstCellForLocation).getMarathonElement(location);
        }
        return null;
    }

    public MarathonElement getMarathonElement(String uniqueIdentifier) {
        Object[] roots = this.getRoots();
        for (int i = 0; i < roots.length; ++i) {
            BR_JGraphEdge edge;
            String marathonIdentifier;
            Object root = roots[i];
            if (root instanceof MarathonElement && (marathonIdentifier = ((MarathonElement)root).getMarathonIdentifier()).equals(uniqueIdentifier)) {
                return (MarathonElement)root;
            }
            if (!(root instanceof BR_JGraphEdge) || !(edge = (BR_JGraphEdge)root).matchesMarathonIdentifier(uniqueIdentifier)) continue;
            return edge.getMarathonElement(uniqueIdentifier);
        }
        return null;
    }

    public Point getMarathonElementLocation(MarathonElement marathonElement, String uniqueIdentifier) {
        if (marathonElement instanceof BR_JGraphNode) {
            BR_JGraphNode node = (BR_JGraphNode)marathonElement;
            CellView nodeView = this.graphView.getMapping((Object)node, true);
            Rectangle2D bounds = nodeView.getBounds();
            int BoundsX = (int)bounds.getX() + (int)bounds.getWidth() / 2;
            int BoundsY = (int)bounds.getY() + (int)bounds.getHeight() / 2;
            Point p = new Point(BoundsX, BoundsY);
            return p;
        }
        if (marathonElement instanceof BR_JGraphEdge) {
            BR_JGraphEdge edge = (BR_JGraphEdge)marathonElement;
            CellView edgeView = this.graphView.getMapping((Object)edge, true);
            Rectangle2D bounds = edgeView.getBounds();
            int BoundsX = (int)bounds.getX() + (int)bounds.getWidth() / 2;
            int BoundsY = (int)bounds.getY() + (int)bounds.getHeight() / 2;
            Point p = new Point(BoundsX, BoundsY);
            return p;
        }
        if (marathonElement instanceof ActionLabel) {
            ActionLabel actionLabel = (ActionLabel)marathonElement;
            BR_JGraphEdge graphEdge = actionLabel.getEdge().getEdge().getJGraphEdge();
            BR_JGraphEdgeView edgeView = (BR_JGraphEdgeView)this.graphView.getMapping((Object)graphEdge, true);
            Rectangle2D bounds = edgeView.getActionLabelBounds();
            int BoundsX = (int)bounds.getX() + (int)bounds.getWidth() / 2;
            int BoundsY = (int)bounds.getY() + (int)bounds.getHeight() / 2;
            Point p = new Point(BoundsX, BoundsY);
            return p;
        }
        if (marathonElement instanceof RuleLabel) {
            BR_JGraphEdge foundEdge = null;
            Object[] roots = this.getRoots();
            for (int i = 0; i < roots.length; ++i) {
                BR_JGraphEdge edge;
                Object root = roots[i];
                if (!(root instanceof BR_JGraphEdge) || !(edge = (BR_JGraphEdge)root).matchesMarathonIdentifier(uniqueIdentifier)) continue;
                foundEdge = edge;
                break;
            }
            BR_JGraphEdgeView edgeView = (BR_JGraphEdgeView)this.graphView.getMapping(foundEdge, true);
            int ruleIndex = foundEdge.getRuleIndex(uniqueIdentifier);
            Rectangle2D bounds = edgeView.getRuleBoundsList().get(ruleIndex);
            int BoundsX = (int)bounds.getX() + (int)bounds.getWidth() / 2;
            int BoundsY = (int)bounds.getY() + (int)bounds.getHeight() / 2;
            Point p = new Point(BoundsX, BoundsY);
            return p;
        }
        if (marathonElement instanceof CheckLispLabel) {
            BR_JGraphEdge foundEdge = null;
            Object[] roots = this.getRoots();
            for (int i = 0; i < roots.length; ++i) {
                BR_JGraphEdge edge;
                Object root = roots[i];
                if (!(root instanceof BR_JGraphEdge) || !(edge = (BR_JGraphEdge)root).matchesMarathonIdentifier(uniqueIdentifier)) continue;
                foundEdge = edge;
                break;
            }
            BR_JGraphEdgeView edgeView = (BR_JGraphEdgeView)this.graphView.getMapping(foundEdge, true);
            Rectangle2D bounds = edgeView.getLispCheckLabelBounds();
            int BoundsX = (int)bounds.getX() + (int)bounds.getWidth() / 2;
            int BoundsY = (int)bounds.getY() + (int)bounds.getHeight() / 2;
            Point p = new Point(BoundsX, BoundsY);
            return p;
        }
        return null;
    }

    public void toFront(Object[] c) {
        this.getGraphLayoutCache().toFront(c);
    }

    public void toBack(Object[] c) {
        this.getGraphLayoutCache().toBack(c);
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (trace.getDebugCode("key")) {
            trace.out("key", "BR_JGraph.keyPressed(" + e + ") mousePressedCell " + trace.nh(this.mousePressedCell));
        }
        if (this.mousePressedCell == null) {
            return;
        }
        if (this.mousePressedCell instanceof BR_JGraphNode && e.getModifiersEx() == this.keyMask && e.getKeyCode() != 40 && e.getKeyCode() == 38) {
            this.currentVisitNode = this.brController.MoveToPrevStepOnPreferredPath(this.currentVisitNode);
        }
        if (this.mousePressedCell instanceof BR_JGraphEdge) {
            ProblemEdge edge = ((BR_JGraphEdge)this.mousePressedCell).getProblemEdge();
            if (edge == null || edge.getActionHandler() == null) {
                return;
            }
            String actionCommand = null;
            int mask = this.keyMask | 0x40;
            if ((e.getModifiersEx() & mask) == mask) {
                if (e.getKeyCode() == 67) {
                    actionCommand = "Copy Link";
                } else if (e.getKeyCode() == 86) {
                    actionCommand = "Paste Link";
                }
            }
            if (trace.getDebugCode("key")) {
                trace.out("key", String.format("BR_JGraph.keyPressed() mods 0x%x, mask 0x%x, keyCode 0x%x, C 0x%x, V 0x%x, actionCommand %s", e.getModifiersEx(), mask, e.getKeyCode(), 67, 86, actionCommand));
            }
            if (actionCommand != null) {
                edge.getActionHandler().actionPerformed(new ActionEvent(this, 1001, actionCommand));
            }
        }
    }

    public void graphChanged(GraphModelEvent e) {
        if (this.ignoreGraphModelEvents) {
            return;
        }
        if (e.getChange() instanceof DefaultGraphModel.GraphModelEdit) {
            Object[] changes = ((DefaultGraphModel.GraphModelEdit)e.getChange()).getChanged();
            boolean sourceChanged = false;
            boolean destChanged = false;
            if (changes.length == 1 && changes[0] instanceof BR_JGraphEdge) {
                boolean resetToPrevious = false;
                String errorMsg = null;
                boolean addNewEdgeToCTAT = false;
                BR_JGraphEdge edge = (BR_JGraphEdge)changes[0];
                ProblemNode sourceFromPE = edge.getProblemEdge().getSource();
                ProblemNode destFromPE = edge.getProblemEdge().getDest();
                ProblemNode sourceFromPort = null;
                ProblemNode destFromPort = null;
                if (edge.getSource() != null && edge.getTarget() != null) {
                    sourceFromPort = ((BR_JGraphNode)((Object)((DefaultPort)edge.getSource()).getParent())).getProblemNode();
                    destFromPort = ((BR_JGraphNode)((Object)((DefaultPort)edge.getTarget()).getParent())).getProblemNode();
                    if (sourceFromPE != sourceFromPort) {
                        sourceChanged = true;
                    }
                    if (destFromPE != destFromPort) {
                        destChanged = true;
                    }
                    if (sourceChanged || destChanged) {
                        addNewEdgeToCTAT = true;
                        errorMsg = sourceChanged ? this.brController.getProblemModel().testNewSourceNodeForLink(edge.getProblemEdge(), sourceFromPort) : this.brController.getProblemModel().testNewDestNodeForLink(edge.getProblemEdge(), destFromPort);
                        resetToPrevious = errorMsg != null;
                    } else {
                        addNewEdgeToCTAT = false;
                    }
                } else {
                    resetToPrevious = true;
                }
                if (resetToPrevious) {
                    Object[] edges = new BR_JGraphEdge[]{edge};
                    if (errorMsg != null && !errorMsg.equalsIgnoreCase("ignore")) {
                        JOptionPane.showMessageDialog((Component)((Object)this), errorMsg);
                    }
                    System.out.println("DONE");
                    System.out.flush();
                    this.ignoreGraphModelEvents = true;
                    this.graphView.remove(edges);
                    edge.setSource(sourceFromPE.getJGraphNode().getChildAt(0));
                    edge.setTarget(destFromPE.getJGraphNode().getChildAt(0));
                    edges[0] = edge;
                    this.graphView.insert(edges);
                    this.brController.getJGraphWindow().repaint();
                } else if (addNewEdgeToCTAT) {
                    BR_JGraphEdge[] edges = new BR_JGraphEdge[]{edge};
                    this.ignoreGraphModelEvents = true;
                    if (sourceChanged) {
                        this.brController.changeEdgeSourceNode(edge.getProblemEdge(), sourceFromPort);
                    } else {
                        this.brController.changeEdgeDestNode(edge.getProblemEdge(), destFromPort);
                    }
                    System.out.println();
                }
            }
        }
        if (e.getChange() instanceof DefaultGraphModel.GraphModelLayerEdit) {
            // empty if block
        }
        this.ignoreGraphModelEvents = false;
    }

    private Point getLocation(BR_JGraphNode node) {
        if (node == null) {
            System.out.println("null parameter to getLocation() in BR_JGraph");
            return new Point(0, 0);
        }
        GraphLayoutCache graphView = this.brController.getJGraphWindow().getJGraphController().getGraphView();
        BR_JGraphVertexView jgraphNodeView = (BR_JGraphVertexView)graphView.getMapping((Object)node, false);
        Rectangle2D rect = jgraphNodeView.getBounds();
        int x = (int)rect.getX();
        int y = (int)rect.getY();
        return new Point(x, y);
    }
}

