/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.View.GraphInspector;

import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.Groups.GroupModel;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Arrays;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class GroupNameEditor
extends JComboBox
implements DocumentListener,
KeyListener {
    private static final long serialVersionUID = 1L;
    private static final String INVALIDNAMEMESSAGE = "Invalid Group Name";
    private static final String VALIDNAMEMESSAGE = "Valid Group Name";
    JButton targetButton;
    JTextField editField;
    JTextField groupNameMessageField;
    GroupModel groupModel;

    public GroupNameEditor(GroupModel groupModel) {
        this.setEditable(true);
        this.editField = (JTextField)this.getEditor().getEditorComponent();
        this.editField.addKeyListener(this);
        this.editField.getDocument().addDocumentListener(this);
        this.groupNameMessageField = new JTextField(INVALIDNAMEMESSAGE);
        this.groupNameMessageField.setEditable(false);
        this.groupModel = groupModel;
    }

    public void setTargetButton(JButton button) {
        this.targetButton = button;
    }

    public void redoNamesList() {
        this.removeAllItems();
        Set<String> names = this.groupModel.getAllGroupNames();
        Object[] sortedNames = names.toArray(new String[0]);
        Arrays.sort(sortedNames);
        for (Object name : sortedNames) {
            if (this.groupModel.getGroupName(this.groupModel.getTopLevelGroup()).equals(name)) continue;
            this.addItem(name);
        }
        if (this.targetButton != null) {
            this.targetButton.setEnabled(false);
        }
        this.checkInput();
        this.editField.selectAll();
    }

    public String getGroupName() {
        return this.editField.getText();
    }

    public JTextField getMessageField() {
        return this.groupNameMessageField;
    }

    private void checkInput() {
        if (this.groupModel.isGroupNameValid(this.editField.getText())) {
            if (this.targetButton != null) {
                this.targetButton.setEnabled(true);
            }
            this.groupNameMessageField.setText(VALIDNAMEMESSAGE);
        } else {
            if (this.targetButton != null) {
                this.targetButton.setEnabled(false);
            }
            this.groupNameMessageField.setText(INVALIDNAMEMESSAGE);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.checkInput();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.checkInput();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.checkInput();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10 && this.targetButton != null) {
            this.targetButton.doClick();
        }
    }

    @Override
    public void keyReleased(KeyEvent arg0) {
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
    }
}

