/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.ProblemModel;

import edu.cmu.pact.BehaviorRecorder.ProblemModel.VariableTable;
import edu.cmu.pact.Utilities.trace;
import java.util.Comparator;
import java.util.Set;
import javax.swing.table.AbstractTableModel;

public class VariableTableModel
extends AbstractTableModel {
    private VariableTable vt;
    private String[] keys;
    private Comparator<String> listCompare;
    private static int count = 0;
    private int instance;

    public VariableTableModel(VariableTable vartab) {
        if (trace.getDebugCode("vtm")) {
            trace.outNT("vtm", "VariableTableModel Constructor");
        }
        this.instance = count++;
        if (trace.getDebugCode("vtm")) {
            trace.outNT("vtm", "VariableTableModel #" + this.instance);
        }
        this.vt = vartab;
        vartab.setModel(this);
        Set set = this.vt.keySet();
        this.keys = new String[0];
        this.keys = set.toArray(this.keys);
        if (trace.getDebugCode("vtm")) {
            trace.outNT("vtm", "vt = " + this.vt);
        }
        if (trace.getDebugCode("vtm")) {
            trace.outNT("vtm", "table/model circle is " + (this.vt.getModel() == this ? "true" : "false"));
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!trace.getDebugCode("vtm")) continue;
            trace.outNT("vtm", "keys[" + i + "] = " + this.keys[i]);
        }
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this.keys.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.keys[rowIndex];
            }
            case 1: {
                Object value = this.vt.get(this.keys[rowIndex]);
                return value == null ? null : value.toString();
            }
        }
        return null;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Variable";
            }
            case 1: {
                return "Value";
            }
        }
        return "Other";
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public Class getColumnClass(int index) {
        return String.class;
    }

    public void updateTable(boolean replace, Object key, int vtNum) {
        if (trace.getDebugCode("vtm")) {
            trace.outNT("vtm", "updateTableModel #" + this.instance + " which is part of vt #" + this.vt.getInstance() + " called from vt #" + vtNum);
        }
        Set set = this.vt.keySet();
        this.keys = new String[set.size()];
        this.keys = set.toArray(this.keys);
        if (trace.getDebugCode("vtm")) {
            trace.outNT("vtm", "keys.length = " + this.keys.length);
        }
        if (trace.getDebugCode("vtm")) {
            trace.outNT("vtm", "getRowCount = " + this.getRowCount());
        }
        if (replace) {
            this.fireTableCellUpdated(this.indexOf(key.toString()), 1);
        } else {
            this.fireTableRowsInserted(this.keys.length, this.keys.length);
        }
    }

    public void updateTableCleared() {
        if (trace.getDebugCode("vtm")) {
            trace.outNT("vtm", "TableModel #" + this.instance + "'s vt #" + this.vt.getInstance() + " cleared");
        }
        this.fireTableDataChanged();
    }

    private int indexOf(String key) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!this.keys[i].equalsIgnoreCase(key)) continue;
            return i;
        }
        return -1;
    }

    public void setVariableTable(VariableTable vtNew) {
        this.vt = vtNew;
        this.fireTableDataChanged();
    }

    public int getVTInstance() {
        return this.vt.getInstance();
    }

    public int getInstance() {
        return this.instance;
    }
}

