/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph;

import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.EdgeData;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ExampleTracerGraph;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ExampleTracerLink;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ExampleTracerNode;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ExampleTracerPath;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ExampleTracerSAI;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ExampleTracerTracer;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.Matcher;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.VariableTable;
import edu.cmu.pact.Utilities.trace;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class ExampleTracerInterpretation
implements Cloneable {
    private ArrayList<ExampleTracerLink> traversedLinks = new ArrayList();
    private Map<Integer, int[]> linkIdTraversalCountMap = new HashMap<Integer, int[]>();
    private VariableTable vt;
    private Set<ExampleTracerPath> validPaths = new HashSet<ExampleTracerPath>();
    private ExampleTracerPath pathToDone = null;
    private String worstLinkType = "Correct Action";

    ExampleTracerInterpretation(Set<ExampleTracerPath> validPaths) {
        this.validPaths.addAll(validPaths);
        this.vt = new VariableTable();
    }

    public void updateVariableTable(ExampleTracerSAI student_sai, Vector replacementInput, ExampleTracerLink link) {
        String sel;
        String inputStr = student_sai.getInputAsString();
        if (replacementInput != null && replacementInput.size() > 0) {
            inputStr = (String)replacementInput.get(0);
        }
        this.vt.put(this.nameLink(link, "selection"), (Object)student_sai.getSelectionAsString());
        this.vt.put(this.nameLink(link, "action"), (Object)student_sai.getActionAsString());
        this.vt.put(this.nameLink(link, "input"), (Object)inputStr);
        EdgeData edgeData = link.getEdge();
        if (trace.getDebugCode("ET")) {
            trace.out("ET", "interp " + this + ".updateVT(" + student_sai + "," + link + "): " + edgeData.getActionType());
        }
        if (("Correct Action".equalsIgnoreCase(edgeData.getActionType()) || "Fireable Buggy Action".equalsIgnoreCase(edgeData.getActionType())) && (sel = student_sai.getSelectionAsString()) != null && sel.length() > 0) {
            this.vt.put(sel, (Object)inputStr);
        }
    }

    private String nameLink(ExampleTracerLink link, String s) {
        return "link" + link.getUniqueID() + "." + s;
    }

    public ExampleTracerInterpretation clone() {
        ExampleTracerInterpretation interp = new ExampleTracerInterpretation(this.validPaths);
        interp.traversedLinks.addAll(this.traversedLinks);
        for (Map.Entry<Integer, int[]> entry : this.linkIdTraversalCountMap.entrySet()) {
            interp.linkIdTraversalCountMap.put(new Integer(entry.getKey()), (int[])entry.getValue().clone());
        }
        interp.worstLinkType = this.worstLinkType;
        VariableTable vtCopy = (VariableTable)this.vt.clone();
        interp.setVariableTable(vtCopy);
        return interp;
    }

    void setVariableTable(VariableTable vt) {
        this.vt = vt;
    }

    public VariableTable getVariableTable() {
        return this.vt;
    }

    public String getType() {
        return this.worstLinkType;
    }

    public Set<ExampleTracerPath> getPaths() {
        return this.validPaths;
    }

    public void removePath(ExampleTracerPath path) {
        this.validPaths.remove(path);
    }

    void addLink(ExampleTracerLink link) {
        if (link.isTraversable() && (this.pathToDone == null || !this.pathToDone.getLinks().contains(link))) {
            this.pathToDone = null;
        }
        this.traversedLinks.add(link);
        Matcher matcher = link.getMatcher();
        int increment = matcher == null ? 1 : matcher.getTraversalIncrement();
        int[] traversalCount = this.linkIdTraversalCountMap.get(new Integer(link.getUniqueID()));
        if (trace.getDebugCode("ett")) {
            trace.out("ett", "addLink: matcher " + matcher + ", old count " + (traversalCount == null ? -1 : traversalCount[0]) + ", increment " + increment + " " + link.getID());
        }
        if (traversalCount != null) {
            traversalCount[0] = traversalCount[0] + increment;
        } else {
            traversalCount = new int[]{increment};
            this.linkIdTraversalCountMap.put(link.getUniqueID(), traversalCount);
        }
        String linkType = link.getType();
        if (ExampleTracerTracer.compareLinkTypes(this.worstLinkType, linkType) < 0) {
            this.worstLinkType = linkType;
        }
    }

    public int countStepsForScore(ExampleTracerGraph graph) {
        Set<ExampleTracerLink> links;
        int result = Integer.MAX_VALUE;
        ExampleTracerPath path = this.getPathToDone(graph);
        if (path != null && (links = path.getLinks()) != null) {
            result = 0;
            for (ExampleTracerLink link : links) {
                int minTraversals;
                if (Matcher.isTutorActor(link.getEdge().getActor(), true)) continue;
                int actualTraversals = this.getTraversalCount(link);
                if (actualTraversals > (minTraversals = link.getEdge().getMinTraversals())) {
                    result += actualTraversals;
                    continue;
                }
                result += minTraversals;
            }
        }
        return result;
    }

    public ExampleTracerPath getPathToDone(ExampleTracerGraph graph) {
        if (this.pathToDone != null) {
            return this.pathToDone;
        }
        if (graph == null) {
            return null;
        }
        ExampleTracerNode startNode = graph.getStartNode();
        if (startNode != null) {
            for (Integer ds : graph.getDoneStates()) {
                if (this.pathToDone != null) break;
                this.pathToDone = graph.getBestSubpath(startNode, ds, this.traversedLinks);
            }
        }
        return this.pathToDone;
    }

    public boolean isTraversed(ExampleTracerLink link, boolean countOptionalAsTraversed) {
        int[] traversalCount = this.linkIdTraversalCountMap.get(new Integer(link.getUniqueID()));
        if (traversalCount == null) {
            if (countOptionalAsTraversed) {
                return link.getEdge().getMinTraversals() <= 0;
            }
            return false;
        }
        return traversalCount[0] >= link.getEdge().getMinTraversals();
    }

    public boolean isVisited(int uniqueID) {
        return this.linkIdTraversalCountMap.containsKey(new Integer(uniqueID));
    }

    public ArrayList<ExampleTracerLink> getMatchedLinks() {
        return this.traversedLinks;
    }

    ExampleTracerLink getLastMatchedLink() {
        if (this.traversedLinks.size() == 0) {
            return null;
        }
        return this.traversedLinks.get(this.traversedLinks.size() - 1);
    }

    int getNumberOfPreferredPrefixLinks() {
        int numberOfLinks = 0;
        for (ExampleTracerLink link : this.getMatchedLinks()) {
            if (!link.getEdge().isPreferredEdge()) break;
            ++numberOfLinks;
        }
        return numberOfLinks;
    }

    int getNumberOfPreferredLinks() {
        int numberOfLinks = 0;
        for (ExampleTracerLink link : this.traversedLinks) {
            if (!link.getEdge().isPreferredEdge()) continue;
            ++numberOfLinks;
        }
        return numberOfLinks;
    }

    public int getTraversalCount(ExampleTracerLink target) {
        int[] traversalCount;
        if (target == null) {
            // empty if block
        }
        return (traversalCount = this.linkIdTraversalCountMap.get(new Integer(target.getUniqueID()))) == null ? 0 : traversalCount[0];
    }

    public String toString() {
        StringBuffer s = new StringBuffer("{");
        for (ExampleTracerLink link : this.traversedLinks) {
            s.append(link.getUniqueID()).append(", ");
        }
        if (s.toString().endsWith(", ")) {
            s.delete(s.lastIndexOf(", "), s.length());
        }
        s.append(" (").append(this.validPaths == null ? -1 : this.validPaths.size()).append(" paths)");
        s.append(" var tbl " + this.vt);
        s.append("}");
        return s.toString();
    }

    public void setPaths(Set<ExampleTracerPath> paths) {
        this.validPaths.addAll(paths);
    }
}

