/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.Dialogs;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.Controller.DemonstrateModeMessageHandler;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemNode;
import edu.cmu.pact.BehaviorRecorder.View.NodeView;
import edu.cmu.pact.ctat.MessageObject;
import edu.cmu.pact.ctat.view.ViewUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class MatchedStatesDialog
extends JDialog
implements ActionListener {
    private final Vector matchedNodes;
    private Vector selection;
    private Vector action;
    private Vector input;
    private MessageObject CommMsg;
    private String actionType;
    JTextArea displayJTextArea;
    private JPanel contentPanel = new JPanel();
    private JPanel optionPanel = new JPanel();
    private JPanel okPanel = new JPanel();
    private JLabel optionJLabel = new JLabel("Please make your selection:");
    private JComboBox optionJComboBox;
    private JCheckBox checkOption = new JCheckBox("Always keep my choice.");
    private JButton okButton = new JButton("OK");
    private final BR_Controller controller;
    private final DemonstrateModeMessageHandler demonstrateModeMessageHandler;

    public MatchedStatesDialog(BR_Controller controller, DemonstrateModeMessageHandler demonstrateModeMessageHandler, Vector matchedNodesP, Vector selectionP, Vector actionP, Vector inputP, MessageObject CommMsgP, String authorIntentP) {
        super(controller.getActiveWindow(), "Matched States", true);
        this.controller = controller;
        this.demonstrateModeMessageHandler = demonstrateModeMessageHandler;
        this.matchedNodes = (Vector)matchedNodesP.clone();
        this.selection = selectionP;
        this.action = actionP;
        this.input = inputP;
        this.CommMsg = CommMsgP;
        this.actionType = authorIntentP;
        this.setLocationRelativeTo(null);
        this.setSize(300, 300);
        this.setResizable(false);
        this.contentPanel.setLayout(new BorderLayout());
        ViewUtils.setStandardBorder(this.contentPanel);
        int sizeOfMatchedNodes = this.matchedNodes.size();
        String[] optionList = new String[sizeOfMatchedNodes + 1];
        optionList[0] = "Create a New State";
        for (int i = 0; i < sizeOfMatchedNodes; ++i) {
            ProblemNode tempNode = (ProblemNode)this.matchedNodes.elementAt(i);
            NodeView Vertex = tempNode.getNodeView();
            optionList[i + 1] = "Link to \"" + Vertex.getText() + "\"";
        }
        this.optionJComboBox = new JComboBox<String>(optionList);
        String displayText = "This state is the same as " + sizeOfMatchedNodes + " existing states. You could link to one of them as the same state. Or you could create a new state if you think that students would act differently later on, depending on how they got to the current state.";
        this.displayJTextArea = new JTextArea(displayText);
        this.contentPanel.add((Component)this.displayJTextArea, "North");
        this.displayJTextArea.setEditable(false);
        this.displayJTextArea.setOpaque(false);
        this.displayJTextArea.setLineWrap(true);
        this.displayJTextArea.setWrapStyleWord(true);
        this.optionPanel.setLayout(new GridLayout(3, 1));
        this.optionPanel.add(this.optionJLabel);
        this.optionPanel.add(this.optionJComboBox);
        this.optionPanel.add(this.checkOption);
        this.contentPanel.add((Component)this.optionPanel, "Center");
        this.okPanel.setLayout(new FlowLayout(1));
        this.okPanel.add(this.okButton);
        this.contentPanel.add((Component)this.okPanel, "South");
        this.getContentPane().add(this.contentPanel);
        this.okButton.addActionListener(this);
        final BR_Controller controller1 = controller;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ProblemNode currentNode = controller1.getExampleTracer() != null ? controller1.getExampleTracer().getCurrentNode(true) : controller1.getSolutionState().getCurrentNode();
                ProblemNode newNode = controller1.addNewState(currentNode, MatchedStatesDialog.this.selection, MatchedStatesDialog.this.action, MatchedStatesDialog.this.input, MatchedStatesDialog.this.CommMsg, MatchedStatesDialog.this.actionType);
                if (MatchedStatesDialog.this.actionType.equalsIgnoreCase("Correct Action") || MatchedStatesDialog.this.actionType.equalsIgnoreCase("Fireable Buggy Action")) {
                    controller1.setCurrentNode(newNode);
                }
                controller1.setAllowCurrentStateChange(true);
                MatchedStatesDialog.this.setVisible(false);
                MatchedStatesDialog.this.dispose();
            }
        });
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        int selectedIndex = this.optionJComboBox.getSelectedIndex();
        if (selectedIndex == 0) {
            ProblemNode currentNode = this.controller.getExampleTracer() != null ? this.controller.getExampleTracer().getCurrentNode(true) : this.controller.getSolutionState().getCurrentNode();
            ProblemNode newNode = this.controller.addNewState(currentNode, this.selection, this.action, this.input, this.CommMsg, this.actionType);
            if (this.actionType.equalsIgnoreCase("Correct Action") || this.actionType.equalsIgnoreCase("Fireable Buggy Action")) {
                if (this.demonstrateModeMessageHandler != null) {
                    this.demonstrateModeMessageHandler.tryTrace(this.selection, this.action, this.input);
                }
                this.controller.setCurrentNode(newNode);
            }
            this.controller.setAllowCurrentStateChange(true);
            this.setVisible(false);
            this.dispose();
        } else if (selectedIndex > 0) {
            ProblemNode checkedNode = (ProblemNode)this.matchedNodes.elementAt(selectedIndex - 1);
            this.controller.treatAsSameStates(checkedNode, this.selection, this.action, this.input, this.CommMsg, this.actionType);
            this.controller.setAllowCurrentStateChange(true);
            this.setVisible(false);
            this.dispose();
        } else {
            JOptionPane.showMessageDialog(this, "Please make your option selection.", "", 2);
        }
    }
}

