/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.Controller;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.Controller.CtatModeEvent;
import edu.cmu.pact.BehaviorRecorder.Controller.MessageTank;
import edu.cmu.pact.BehaviorRecorder.Controller.PseudoTutorMessageBuilder;
import edu.cmu.pact.BehaviorRecorder.Controller.TankMessageHandler;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.EdgeData;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ExampleTracerEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ExampleTracerGraph;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ExampleTracerLink;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ExampleTracerPath;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ExampleTracerSAI;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ExampleTracerTracer;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemEdge;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemNode;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.Matcher;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.NewProblemEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemModel;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemModelEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemModelListener;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.MessageObject;
import edu.cmu.pact.ctat.model.ProblemSummary;
import edu.cmu.pact.ctat.model.Skill;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import pact.CommWidgets.FocusModel;

public class PseudoTutorMessageHandler
extends TankMessageHandler
implements ProblemModelListener {
    public static boolean USE_NEW_EXAMPLE_TRACER = true;
    public static final int FIND_HINT = 0;
    public static final int FIND_SKILLS = 1;
    public static final int FIND_HIGHLIGHT = 2;
    public static final int FIRST_SELECTED_WIDGET_NAME = 0;
    public static final int NONE_HINT_FIRST_SELECTED_WIDGET_NAME = 1;
    BR_Controller controller;
    private ExampleTracerGraph exampleTracerGraph;
    private List traversedEdges;

    public PseudoTutorMessageHandler(BR_Controller controller) {
        this.controller = controller;
        this.messageTank = new MessageTank(controller);
        this.exampleTracerGraph = controller.getExampleTracerGraph();
        if (controller.getCtatModeModel() != null) {
            this.exampleTracerGraph.getExampleTracer().setDemonstrateMode(controller.getCtatModeModel().isDemonstratingSolution());
        }
        this.traversedEdges = new ArrayList();
    }

    public ExampleTracerTracer getExampleTracer() {
        return this.exampleTracerGraph.getExampleTracer();
    }

    public void initializePseudoTutorAndSendStartState(boolean delayStartStateEnd) {
        this.initializePseudoTutor();
        this.controller.sendStartNodeMessages(null, delayStartStateEnd);
        if (this.controller.getProblemModel().isUseCommWidgetFlag()) {
            this.controller.setPreferredWidgetFocus();
        }
        this.exampleTracerGraph.getExampleTracer().initialize(this.controller.getProblemModel().getVariableTable());
    }

    public void initializePseudoTutor() {
        this.exampleTracerGraph.getExampleTracer().initialize(null);
        this.traversedEdges = new ArrayList();
        trace.out("inter", "initializePseudoTutor()");
        this.controller.getHintMessagesManager().cleanUpHintOnChange();
        FocusModel.setLastFocus(null);
        if (trace.getDebugCode("hint")) {
            trace.out("hint", "PseudoTutorMsgHndlr.initzePseudoTutor() lastFocus " + FocusModel.getLastFocus());
        }
        if (this.controller.getLogger() != null) {
            this.controller.getLogger().setProblemName(this.controller.getProblemModel().getProblemName());
        }
        this.controller.sendResetBeforeTraverseToClickedNode();
        if (this.controller.getProblemModel().getStartNode() != null) {
            this.controller.setCurrentNode(this.controller.getProblemModel().getStartNode());
        }
    }

    private boolean isHighLightRightSelection() {
        boolean highlightRightSelectionFlag = false;
        ProblemModel pm = this.controller.getProblemModel();
        if (pm != null) {
            highlightRightSelectionFlag = pm.getHighlightRightSelection();
        }
        return highlightRightSelectionFlag;
    }

    public void traverseEdge(EdgeData edgeData, Vector selection, Vector action, Vector input, String actor) {
        this.doNewExampleTrace(edgeData, selection, action, input, actor, false);
        if (trace.getDebugCode("et")) {
            trace.out("et", "*******************Should have advanced");
        }
    }

    public ExampleTracerPath advanceToNode(ProblemNode toNode) {
        if (this.controller == null) {
            return null;
        }
        ProblemNode currentNode = this.controller.getCurrentNode();
        if (trace.getDebugCode("sai")) {
            trace.out("sai", "advanceToNode(" + currentNode + "=>" + toNode + ")");
        }
        if (toNode == currentNode) {
            return null;
        }
        ExampleTracerPath bestPathToNode = this.controller.getProblemModel().findPath(toNode);
        int i = 0;
        int n = bestPathToNode.size();
        for (ExampleTracerLink link : bestPathToNode) {
            EdgeData edgeData = link.getEdge();
            if (trace.getDebugCode("sai")) {
                trace.out("sai", "advanceToNode[" + i++ + " of " + n + "](" + currentNode + "=>" + toNode + ")");
            }
            if (edgeData == null || edgeData.getEdge() == null) break;
            if (edgeData.getMinTraversals() < 1 && edgeData.getMaxTraversals() <= edgeData.getTraversalCount()) continue;
            this.controller.getPseudoTutorMessageHandler().traverseEdge(edgeData, edgeData.getSelection(), edgeData.getAction(), edgeData.getInput(), edgeData.getActor());
        }
        return bestPathToNode;
    }

    public List<ExampleTracerEvent> traversePath(ExampleTracerPath newUserVisitedStates) {
        if (trace.getDebugCode("br")) {
            trace.out("br", "traversePath(" + newUserVisitedStates + ")");
        }
        ArrayList<ExampleTracerEvent> results = new ArrayList<ExampleTracerEvent>();
        this.traversedEdges = this.getExampleTracer().evaluateEdges(newUserVisitedStates, results);
        return results;
    }

    String enqueueToolActionToStudent(Vector selection, Vector action, Vector input) {
        return this.messageTank.enqueueToolActionToStudent(selection, action, input, "tutor-performed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int advanceToStudentBeginsHere(ProblemNode targetState) {
        ProblemModel pm;
        int result = 0;
        if (this.controller == null || (pm = this.controller.getProblemModel()) == null) {
            return result;
        }
        ProblemNode currentNode = this.controller.getCurrentNode();
        if (trace.getDebugCode("pm")) {
            trace.out("pm", "advanceToStudentBeginsHere(" + currentNode + "=>" + targetState + ")");
        }
        ProblemNode lastEdgeDest = null;
        try {
            this.messageTank.setSuppressLogging(Boolean.TRUE);
            this.messageTank.setBundleName("StartStateMessages");
            this.controller.sendStartStateMsg(PseudoTutorMessageBuilder.createInterfaceConfigurationEnd());
            if (trace.getDebugCode("br")) {
                trace.out("br", "advanceToStudentBeginsHere() *NOT* sending SendWidgetLock");
            }
            if (targetState != currentNode) {
                ExampleTracerPath bestPathToNode = pm.findPath(targetState);
                if (trace.getDebugCode("pm")) {
                    trace.out("pm", "advanceToStudentBeginsHere() path " + bestPathToNode);
                }
                for (ExampleTracerLink link : bestPathToNode) {
                    EdgeData edgeData = link.getEdge();
                    lastEdgeDest = edgeData.getEndProblemNode();
                    if (edgeData == null || edgeData.getEdge() == null) break;
                    if (edgeData.getMinTraversals() < 1 && edgeData.getMaxTraversals() <= edgeData.getTraversalCount()) continue;
                    String actor = edgeData.getActor();
                    if (!Matcher.isTutorActor(actor, false)) {
                        actor = "Tutor";
                    }
                    if (trace.getDebugCode("actor")) {
                        trace.out("actor", "PsMH.advanceToStudentBeginsHere() edgeData.getActor() " + edgeData.getActor() + ", actor " + actor);
                    }
                    this.traverseEdge(edgeData, edgeData.getSelection(), edgeData.getAction(), edgeData.getInput(), actor);
                    ++result;
                }
            }
            this.checkForTutorAction(lastEdgeDest, this.getExampleTracer().getCurrentNode(false, false), null, null, null);
            if (trace.getDebugCode("br")) {
                trace.out("br", "advanceToStudentBeginsHere() *NOT* sending StartStateEnd");
            }
            this.controller.advanceToTargetNode(true);
            if (!this.controller.isRestoringProblemState(null, false)) {
                this.messageTank.addToMessageTank(this.controller.closeTransaction(null));
            }
            this.messageTank.flushMessageTank(this.controller.getProblemSummary(), this.endTransaction(true));
        }
        finally {
            this.messageTank.setSuppressLogging(null);
            this.messageTank.setBundleName(null);
        }
        return result;
    }

    public void processPseudoTutorInterfaceAction(Vector selection, Vector action, Vector input) {
        this.processPseudoTutorInterfaceAction(selection, action, input, "Student");
    }

    void processPseudoTutorInterfaceAction(Vector selection, Vector action, Vector input, String actor) {
        ProblemModel pm = null;
        if (this.controller != null && (pm = this.controller.getProblemModel()) != null) {
            this.controller.getProblemModel().startSkillTransaction();
        }
        boolean allowHintBias = this.messageTank.editSelectionAndAction("InterfaceAction", selection, action) || pm.areHintsBiasedByCurrentSelection();
        this.resetMessageTank(this.controller);
        ExampleTracerEvent result = this.doNewExampleTrace(selection, action, input, actor, allowHintBias);
        this.confirmDoneAction(selection);
        this.messageTank.flushMessageTank(this.controller.getProblemSummary(), this.endTransaction(true));
        this.controller.fireCtatModeEvent(CtatModeEvent.REPAINT);
    }

    private ExampleTracerEvent doNewExampleTrace(Vector selection, Vector action, Vector input, String actor, boolean allowHintBias) {
        String firstSelection;
        if (trace.getDebugCode("et")) {
            trace.out("et", "doNewExampleTrace: selection = " + selection + " action = " + action + " input = " + input + " actor = " + actor);
        }
        if ((firstSelection = (String)selection.get(0)).equalsIgnoreCase("Help") || firstSelection.equalsIgnoreCase("Hint")) {
            ExampleTracerEvent result = new ExampleTracerEvent(this);
            ProblemEdge hintLink = this.getExampleTracer().doHint(selection, action, input, actor, result, allowHintBias);
            ProblemSummary ps = this.controller.getProblemSummary();
            if (hintLink != null) {
                if (result.isSolverResult()) {
                    String stepID = Skill.makeStepID(result.getTutorSelection(), result.getTutorAction());
                    this.controller.getProblemModel().updateSkills("hint", result.getSkillNames(), stepID);
                    MessageObject mo = PseudoTutorMessageBuilder.buildHintsMsg(result.getTutorAdvice(), result.getTutorSelection(), result.getTutorAction(), result.getTutorInput(), Integer.toString(hintLink.getUniqueID()), null, null, this.controller);
                    this.messageTank.addToMessageTank(mo);
                    this.messageTank.addToMessageTank(PseudoTutorMessageBuilder.buildAssocRulesFromEvent(result, this.controller), result);
                } else {
                    hintLink.getEdgeData().updateSkills("hint");
                    MessageObject mo = PseudoTutorMessageBuilder.buildHintsMsg(hintLink, this.controller);
                    this.messageTank.addToMessageTank(mo);
                    mo = PseudoTutorMessageBuilder.buildAssociatedRules(hintLink, "Hint", actor, this.controller, null);
                    this.messageTank.addToMessageTank(mo);
                }
            } else {
                MessageObject mo = PseudoTutorMessageBuilder.buildNoHintMessage(this.controller);
                this.messageTank.addToMessageTank(mo);
                Vector<String> noHints = new Vector<String>();
                noHints.add("No hint available.");
                mo = PseudoTutorMessageBuilder.buildAssociatedRulesMsg("Hint", selection, action, input, null, null, null, null, "", actor, this.controller, null, noHints);
                this.messageTank.addToMessageTank(mo);
            }
            this.messageTank.flushMessageTank(ps, this.endTransaction(false));
            return result;
        }
        this.getExampleTracer().evaluate(selection, action, input, actor);
        return this.finishNewExampleTrace(selection, action, input, actor, true);
    }

    private ExampleTracerEvent doNewExampleTrace(EdgeData edgeData, Vector selection, Vector action, Vector input, String actor, boolean doTutorPerformedSteps) {
        ProblemModel pm;
        if (trace.getDebugCode("actor")) {
            trace.out("actor", "PSMH.doNewExampleTrace(edge" + edgeData.getUniqueID() + "," + selection + "," + action + "," + input + "," + actor + ")");
        }
        ProblemModel problemModel = pm = this.controller == null ? null : this.controller.getProblemModel();
        if (pm != null) {
            pm.startSkillTransaction();
        }
        this.getExampleTracer().evaluate(edgeData.getUniqueID(), edgeData.getSelection(), edgeData.getAction(), input, actor);
        ExampleTracerEvent result = this.getExampleTracer().getLastResult();
        String transaction_id = this.enqueueToolActionToStudent(result.getTutorSelection(), result.getTutorAction(), result.getTutorInput());
        this.setTransactionId(transaction_id);
        return this.finishNewExampleTrace(result.getTutorSelection(), result.getTutorAction(), result.getTutorInput(), actor, doTutorPerformedSteps);
    }

    ExampleTracerEvent finishNewExampleTrace(Vector selection, Vector action, Vector input, String actor, boolean doTutorPerformedSteps) {
        ExampleTracerEvent result = this.getExampleTracer().getLastResult();
        int depthSoFar = -1;
        ProblemModel pm = this.controller.getProblemModel();
        if (trace.getDebugCode("et")) {
            trace.out("et", "finishNewExampleTrace() result = " + result + ", outOfOrder " + result.isOutOfOrder());
        }
        if (result.getReportableVariableTable() != null && pm != null) {
            pm.setVariableTable(result.getReportableVariableTable());
        }
        ProblemEdge[] edges = new ProblemEdge[]{result.getReportableLink() != null ? result.getReportableLink().getEdge().getEdge() : null};
        trace.out("et", "edges = " + Arrays.asList(edges));
        EdgeData edgeData = null;
        if (edges[0] != null) {
            edgeData = edges[0].getEdgeData();
        }
        if (result.isSolverResult()) {
            ExampleTracerEvent tpaResult;
            String transactionResult;
            String string = transactionResult = "Correct Action".equals(result.getResult()) ? "correct" : "incorrect";
            if (pm != null) {
                pm.updateSkills(transactionResult, result.getSkillNames(), Skill.makeStepID(result.getTutorSelection(), result.getTutorAction()));
            }
            ProblemNode newCurrentNode = this.getExampleTracer().getCurrentNode(false, false);
            if (result.isSolverDone() && newCurrentNode != null) {
                this.controller.setCurrentNode(newCurrentNode);
            }
            this.sendSolverResponse(result);
            if (pm != null) {
                pm.addStudentSAI(result);
            }
            if (result.isSolverDone() && doTutorPerformedSteps && (tpaResult = this.checkForTutorAction(edges[0] == null ? null : edges[0].getDest(), newCurrentNode, selection, action, input)) != null) {
                result = tpaResult;
            }
        } else if ("Correct Action".equals(result.getResult())) {
            ExampleTracerEvent tpaResult;
            MessageObject message = null;
            Vector replacementInput = this.replaceInput(edgeData, selection, action, input, result);
            if (!"Tutor (unevaluated)".equalsIgnoreCase(actor)) {
                message = PseudoTutorMessageBuilder.buildCommCorrectMessage(selection, action, replacementInput == null ? input : replacementInput, this.controller);
                this.messageTank.addToMessageTank(message, result);
            }
            if (edges[0] != null) {
                this.controller.getProcessTraversedLinks().addLinkNode(edges[0].getUniqueID(), selection, action, input, "Correct Action");
                this.controller.getSolutionState().addUserVisitedEdge(edges[0]);
                ProblemNode newCurrentNode = this.getExampleTracer().getCurrentNode(false);
                if (newCurrentNode != null) {
                    this.controller.setCurrentNode(newCurrentNode);
                }
            }
            if (edgeData != null && !Matcher.isTutorActor(actor, false)) {
                edgeData.updateSkills("correct");
            }
            String successMessage = edgeData.getInterpolatedSuccessOrBuggyMsg(true).trim();
            trace.out("success message = " + successMessage);
            if (successMessage.length() > 0) {
                message = PseudoTutorMessageBuilder.buildCommSuccessMessage(successMessage, this.controller);
                this.messageTank.addToMessageTank(message, result);
            }
            this.createAssocRulesCorrectMsg(edges[0], selection, action, input, actor, replacementInput, result);
            this.messageTank.flushMessageTank(this.controller.getProblemSummary(), this.endTransaction(false));
            if (pm != null) {
                pm.addStudentSAI(result);
                pm.checkReplayState(result);
                doTutorPerformedSteps &= !pm.checkRequestGoToState();
            }
            if (doTutorPerformedSteps && (tpaResult = this.checkForTutorAction(edges[0] == null ? null : edges[0].getDest(), this.getExampleTracer().getCurrentNode(false, false), selection, action, input)) != null) {
                result = tpaResult;
            }
        } else {
            MessageObject message = null;
            Vector replacementInput = null;
            if ("Fireable Buggy Action".equals(result.getResult())) {
                replacementInput = this.replaceInput(edgeData, selection, action, input, result);
            }
            message = PseudoTutorMessageBuilder.buildCommIncorrectMessage(selection, action, replacementInput == null ? input : replacementInput, this.controller);
            this.messageTank.addToMessageTank(message);
            String buggyMessage = null;
            if (edgeData != null && (buggyMessage = edgeData.getInterpolatedSuccessOrBuggyMsg(false).trim()).length() != 0) {
                message = PseudoTutorMessageBuilder.buildCommBuggyMessage(buggyMessage, selection, action, this.controller);
                if (trace.getDebugCode("et")) {
                    trace.out("et", "finishNewExampleTrace() buggy message: " + message);
                }
                this.messageTank.addToMessageTank(message, result);
            }
            ExampleTracerEvent hintResult = new ExampleTracerEvent(this, new ExampleTracerSAI(selection, action, input, actor));
            hintResult.setFeedback(this.getExampleTracerGraph().getFeedback());
            ProblemEdge hintLink = this.getExampleTracer().traceForHint(hintResult);
            int n = depthSoFar = hintResult.getReportableLink() == null ? -1 : hintResult.getReportableLink().getDepth();
            if (hintLink == null) {
                hintLink = this.getExampleTracer().getBestNextLink(false, new ExampleTracerEvent(this));
            }
            if (hintLink != null && hintLink.getEdgeData() != null && !Matcher.isTutorActor(actor, false)) {
                hintLink.getEdgeData().updateSkills("incorrect");
            }
            if (trace.getDebugCode("et")) {
                trace.out("et", "finishNewExampleTrace() hinkLink " + hintLink);
            }
            if ("Fireable Buggy Action".equals(result.getResult())) {
                if (edges[0] != null) {
                    this.controller.getProcessTraversedLinks().addLinkNode(edges[0].getUniqueID(), selection, action, input, "Fireable Buggy Action");
                    this.controller.getSolutionState().addUserVisitedEdge(edges[0]);
                    ProblemNode newCurrentNode = this.getExampleTracer().getCurrentNode(false);
                    if (newCurrentNode != null) {
                        this.controller.setCurrentNode(newCurrentNode);
                    }
                }
                MessageObject newMessage = PseudoTutorMessageBuilder.buildAssociatedRules(hintLink == null ? edges[0] : hintLink, "InCorrect", actor, this.controller, result.getStudentSAI() == null ? null : result.getStudentSAI().getSelectionAsString());
                this.messageTank.addToMessageTank(newMessage, result);
                this.messageTank.flushMessageTank(this.controller.getProblemSummary(), this.endTransaction(false));
                if (pm != null) {
                    pm.addStudentSAI(result);
                    pm.checkReplayState(result);
                    doTutorPerformedSteps &= !pm.checkRequestGoToState();
                }
                if (doTutorPerformedSteps) {
                    result = this.checkForTutorAction(edges[0] == null ? null : edges[0].getDest(), this.getExampleTracer().getCurrentNode(false, false), selection, action, input);
                }
            } else {
                Vector hintAction;
                Vector hintSelection = hintLink != null ? hintLink.getEdgeData().getSelection() : null;
                String hintSelection0 = hintSelection != null && hintSelection.size() > 0 ? hintSelection.get(0) : null;
                Vector vector = hintAction = hintLink != null ? hintLink.getEdgeData().getAction() : null;
                if (buggyMessage == null) {
                    if (result.isDoneStepFailed()) {
                        this.messageTank.flushDelayedFeedback();
                        message = PseudoTutorMessageBuilder.buildCommBuggyMessage("I'm sorry, but you are not done yet. Please continue working.", null, null, this.controller);
                        this.messageTank.addToMessageTank(message, result);
                    } else {
                        if (trace.getDebugCode("et")) {
                            trace.outNT("et", "before out-of-order test result " + result.getResult() + " ?= " + "NO-MODEL" + "&& (result.isOutOfOrder() " + result.isOutOfOrder() + " || hintResult.isOutOfOrder() " + hintResult.isOutOfOrder() + ") && (hintSelection0 " + hintSelection0 + " !=  result.getSelectionAsString() " + result.getSelectionAsString() + ")");
                        }
                        if ("NO-MODEL".equals(result.getResult()) && result.isOutOfOrder() && hintSelection0 != null && !hintSelection0.equalsIgnoreCase(result.getSelectionAsString())) {
                            message = this.isHighLightRightSelection() ? PseudoTutorMessageBuilder.buildCommHighLightWidgetMessage(hintSelection, hintAction, this.controller) : PseudoTutorMessageBuilder.buildCommBuggyMessage("You need to do other steps first, before doing the step you just worked on. You might request a hint for more help.", null, null, this.controller);
                            if (trace.getDebugCode("et")) {
                                trace.out("et", "doNewExampleTrace() out-of-order message: " + message);
                            }
                            this.messageTank.addToMessageTank(message, result);
                        } else {
                            String defaultBuggyMsg = pm.getDefaultBuggyMsg();
                            if (defaultBuggyMsg != null && defaultBuggyMsg.length() > 0) {
                                message = PseudoTutorMessageBuilder.buildCommBuggyMessage(defaultBuggyMsg, null, null, this.controller);
                                this.messageTank.addToMessageTank(message, result);
                            }
                        }
                    }
                }
                MessageObject newMessage = null;
                newMessage = hintLink != null ? PseudoTutorMessageBuilder.buildAssociatedRules(hintLink, "InCorrect", actor, this.controller, result.getStudentSAI() == null ? null : result.getStudentSAI().getSelectionAsString()) : PseudoTutorMessageBuilder.buildAssociatedRulesMsg("InCorrect", selection, action, input, null, null, null, null, "", actor, this.controller, null, null);
                this.messageTank.addToMessageTank(newMessage, result);
                this.messageTank.flushMessageTank(this.controller.getProblemSummary(), this.endTransaction(false));
                if (pm != null) {
                    pm.addStudentSAI(result);
                }
            }
        }
        if (depthSoFar < 0) {
            if (trace.getDebugCode("hints")) {
                trace.out("hints", "finishNewExampleTrace() result " + result + " .reportableLink " + (result == null ? null : result.getReportableLink()) + " .depth " + (result == null || result.getReportableLink() == null ? null : Integer.toString(result.getReportableLink().getDepth())));
            }
            depthSoFar = result == null || result.getReportableLink() == null ? -1 : result.getReportableLink().getDepth() + 1;
        }
        this.doUnrequestedHints(null, depthSoFar);
        return result;
    }

    private Vector replaceInput(EdgeData edgeData, Vector selection, Vector action, Vector input, ExampleTracerEvent result) {
        if (edgeData == null || !edgeData.replaceInput()) {
            return null;
        }
        String vName = "link" + edgeData.getUniqueID() + ".input";
        Object vValue = result.getVariableValue(vName);
        Vector<String> replacementInput = null;
        if (vValue == null) {
            trace.err("replaceInput for " + vName + " found null");
            return null;
        }
        replacementInput = !(vValue instanceof Vector) ? PseudoTutorMessageBuilder.s2v(vValue.toString()) : (Vector<String>)vValue;
        if (trace.getDebugCode("br")) {
            trace.out("br", "replaceInput for " + vName + " found (" + (vValue == null ? "" : vValue.getClass().getSimpleName()) + ") \"" + vValue + "\"");
        }
        return replacementInput;
    }

    private void sendSolverResponse(ExampleTracerEvent result) {
        Vector<String> s = result.getStudentSAI().getSelectionAsVector();
        Vector<String> a = result.getStudentSAI().getActionAsVector();
        Vector<String> i = result.getStudentSAI().getInputAsVector();
        ArrayList<MessageObject> resps = new ArrayList<MessageObject>();
        ExampleTracerEvent.InterfaceAction ia = null;
        while (result.hasGradeableIAMsgs()) {
            ia = result.dequeueInterfaceAction();
            if (trace.getDebugCode("solverdebug")) {
                trace.out("solverdebug", "sendSolverResponse() result " + result.getResult() + ", " + ia.getIaAction() + ", " + ia.getIaOutput() + ", \"" + ia.getPrompt() + "\", " + ia.getSolverProperties());
            }
            i = ia.getIaOutput();
            resps.add(PseudoTutorMessageBuilder.buildInterfaceActionMsg(s, ia.getIaAction(), i, ia.getPrompt(), this.controller, MessageObject.makeTransactionId(), true));
        }
        this.messageTank.addToMessageTank(resps);
        resps.clear();
        if (result.isTransaction()) {
            String tutorAdvice;
            String string = tutorAdvice = result.getTutorAdvice() == null || result.getTutorAdvice().size() < 1 ? null : result.getTutorAdvice().get(0);
            if ("Correct Action".equalsIgnoreCase(result.getResult())) {
                resps.add(PseudoTutorMessageBuilder.buildCommCorrectMessage(s, a, i, this.controller));
                if (tutorAdvice != null) {
                    resps.add(PseudoTutorMessageBuilder.buildCommSuccessMessage(tutorAdvice, this.controller));
                }
            } else {
                resps.add(PseudoTutorMessageBuilder.buildCommIncorrectMessage(s, a, i, this.controller));
                if (tutorAdvice != null) {
                    resps.add(PseudoTutorMessageBuilder.buildCommBuggyMessage(tutorAdvice, s, a, this.controller));
                }
            }
            this.messageTank.addToMessageTank(resps);
            this.messageTank.addToMessageTank(PseudoTutorMessageBuilder.buildAssocRulesFromEvent(result, this.controller), result);
            resps.clear();
        }
        while (null != (ia = result.dequeueInterfaceAction())) {
            resps.add(PseudoTutorMessageBuilder.buildInterfaceActionMsg(s, ia.getIaAction(), ia.getIaOutput(), ia.getPrompt(), this.controller, MessageObject.makeTransactionId(), true));
        }
        this.messageTank.addToMessageTank(resps);
        this.messageTank.flushMessageTank(this.controller.getProblemSummary(), this.endTransaction(false));
    }

    private boolean confirmDoneAction(Vector selection) {
        String firstSelection = (String)selection.elementAt(0);
        if (!firstSelection.equalsIgnoreCase("Done")) {
            return false;
        }
        ProblemModel pm = this.controller.getProblemModel();
        if (pm == null) {
            return false;
        }
        if (!pm.getEffectiveConfirmDone()) {
            return false;
        }
        MessageObject msg = PseudoTutorMessageBuilder.buildConfirmDoneMsg(this.controller);
        this.messageTank.addToMessageTank(msg);
        return true;
    }

    private ExampleTracerEvent checkForTutorAction(ProblemNode priorEdgeDest, ProblemNode currNode, Vector selection, Vector action, Vector input) {
        EdgeData[] edges = new EdgeData[]{this.nodeTutorActionFires(priorEdgeDest, true), this.nodeTutorActionFires(currNode, false)};
        int i = 0;
        if (edges[0] == edges[1]) {
            edges[1] = null;
        } else if (edges[0] == null) {
            i = 1;
        }
        ExampleTracerEvent result = null;
        while (i < edges.length && edges[i] != null) {
            result = selection == null ? this.doNewExampleTrace(edges[i], edges[i].getSelection(), edges[i].getAction(), edges[i].getInput(), edges[i].getActor(), true) : this.doNewExampleTrace(edges[i], selection, action, input, edges[i].getActor(), true);
            ++i;
        }
        return result;
    }

    private EdgeData nodeTutorActionFires(ProblemNode src, boolean linkTriggered) {
        if (src == null) {
            return null;
        }
        List<ProblemEdge> correctChildren = src.getCorrectOutgoingEdges();
        if (correctChildren.size() != 1) {
            return null;
        }
        EdgeData nextEdgeData = correctChildren.get(0).getEdgeData();
        if (nextEdgeData.isTutorPerformed(linkTriggered)) {
            return nextEdgeData;
        }
        return null;
    }

    private void createAssocRulesCorrectMsg(ProblemEdge targetEdge, Vector selection, Vector action, Vector input, String actor, Vector replacementInput, ExampleTracerEvent result) {
        MessageObject newMessage = PseudoTutorMessageBuilder.buildAssociatedRules(targetEdge, selection, action, replacementInput == null ? input : replacementInput, result.getStudentSAI(), "Correct", actor, this.controller, (String)selection.get(0));
        this.messageTank.addToMessageTank(newMessage, result);
    }

    public ExampleTracerGraph getExampleTracerGraph() {
        return this.exampleTracerGraph;
    }

    public void resetExampleTracer(ExampleTracerGraph graph, ProblemModel problemModel) {
    }

    public List<ExampleTracerEvent> advanceTracerThroughPath(ExampleTracerPath newUserVisitedStates) {
        ExampleTracerEvent lastResult;
        if (trace.getDebugCode("br")) {
            trace.out("br", "traversePath(" + newUserVisitedStates + ")");
        }
        ArrayList<ExampleTracerEvent> results = new ArrayList<ExampleTracerEvent>();
        this.traversedEdges = this.getExampleTracer().evaluateEdges(newUserVisitedStates, results);
        if (results.size() > 0 && (lastResult = (ExampleTracerEvent)results.get(results.size() - 1)).getReportableVariableTable() != null) {
            this.controller.getProblemModel().setVariableTable(lastResult.getReportableVariableTable());
        }
        return results;
    }

    public List getTraversedEdges() {
        return this.traversedEdges;
    }

    public void setTransactionId(String semanticEventId) {
        if (semanticEventId != null) {
            this.messageTank.setTransaction_id(semanticEventId);
        }
    }

    @Override
    public void problemModelEventOccurred(ProblemModelEvent e) {
        int tryToGoToState;
        this.exampleTracerGraph = this.controller.getProblemModel().getExampleTracerGraph();
        ProblemNode oldState = this.controller.getCurrentNode();
        boolean resetToOldState = this.exampleTracerGraph.handleProblemModelEvent(e);
        if (e instanceof NewProblemEvent) {
            this.exampleTracerGraph.getExampleTracer().setDemonstrateMode(false);
        }
        if ((tryToGoToState = e.getTryToSetCurrentStateTo()) != -1) {
            this.getExampleTracer().resetTracer();
            this.controller.goToStartState(false, false);
            this.controller.goToState(this.exampleTracerGraph.getNode(tryToGoToState).getProblemNode());
        } else if (resetToOldState) {
            if (this.controller.getCtatModeModel().isRuleEngineTracing()) {
                return;
            }
            this.getExampleTracer().resetTracer();
            this.controller.goToStartState(false, false);
            this.controller.goToState(oldState);
        }
    }

    @Override
    public MessageTank getMessageTank() {
        return this.messageTank;
    }

    public void doUnrequestedHints(ProblemNode currentNode, int depthSoFar) {
        List<MessageObject> unrequestedHintMsgs;
        ProblemModel pm = this.controller.getProblemModel();
        if (pm == null) {
            return;
        }
        List<MessageObject> list = unrequestedHintMsgs = currentNode == null ? pm.getUnrequestedHint(depthSoFar) : pm.getUnrequestedHint(currentNode, depthSoFar);
        if (unrequestedHintMsgs != null) {
            this.messageTank.addToMessageTank(unrequestedHintMsgs);
            this.messageTank.flushMessageTank(null, this.endTransaction(false));
            pm.cancelUnrequestedHint(depthSoFar);
        }
    }
}

