/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.ctat;

import edu.cmu.hcii.ctat.CTATCharsetFunctions;
import edu.cmu.pact.Utilities.trace;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;

public class CTATWSFrameData {
    public static final int CAPACITY = 65558;
    public static final int NORMAL_CLOSE = 1000;
    public static final int ERROR_CLOSE = 1008;
    private static byte[] emptyarray = new byte[0];
    private boolean fin;
    private Opcode opcode;
    private ByteBuffer unmaskedpayload;
    private boolean masked;
    private static byte[] emptyByteArray = new byte[0];

    public void fromStream(BufferedInputStream inFromClient) throws IOException {
        int i = 0;
        byte[] fOmL = this.readStream(inFromClient, 2, i);
        i += 2;
        this.fin = fOmL[0] >>> 7 != 0;
        this.opcode = CTATWSFrameData.toOpcode(fOmL[0]);
        this.masked = fOmL[1] >>> 7 != 0;
        int payloadlength = fOmL[1] & 0x7F;
        if (payloadlength < 0 || payloadlength > 125) {
            byte[] sizebytes;
            if (payloadlength == 126) {
                sizebytes = this.readStream(inFromClient, 2, i);
                i += 2;
                byte[] sb3 = new byte[]{0, sizebytes[0], sizebytes[1]};
                payloadlength = new BigInteger(sb3).intValue();
            } else {
                sizebytes = this.readStream(inFromClient, 8, i);
                i += 8;
                long length = new BigInteger(sizebytes).longValue();
                if (length > Integer.MAX_VALUE) {
                    throw new IOException("WebSocket payload length " + payloadlength + " exceeds max size " + Integer.MAX_VALUE);
                }
                payloadlength = (int)length;
            }
        }
        if (trace.getDebugCode("ws")) {
            trace.out("ws", "Exchange.fromStream() fin " + this.fin + ", opcode " + (Object)((Object)this.opcode) + ", masked " + this.masked + ", payloadlength " + payloadlength);
        }
        this.unmaskedpayload = ByteBuffer.allocate(Math.max(payloadlength, 65558));
        int nRead = 0;
        if (this.masked) {
            byte[] mask = this.readStream(inFromClient, 4, i);
            i += 4;
            if (trace.getDebugCode("ws")) {
                trace.out("ws", String.format("fromStream mask %02X %02X %02X %02X", mask[0], mask[1], mask[2], mask[3]));
            }
            int c = -1;
            while (nRead < payloadlength && (c = inFromClient.read()) != -1) {
                int d = (c ^ mask[nRead % 4]) & 0xFF;
                if (trace.getDebugCode("ws") && nRead >= Math.max(payloadlength - 15, 0)) {
                    trace.out("ws", String.format("fromStream read loop c %02X d %02X '%c', mask %02X, readCount %d , position %d", c, d, Character.valueOf(new Character((char)d).charValue()), mask[nRead % 4], nRead, this.unmaskedpayload.position()));
                }
                this.unmaskedpayload.put((byte)d);
                ++nRead;
                ++i;
            }
        } else {
            int c = -1;
            while (nRead < payloadlength && (c = inFromClient.read()) != -1) {
                this.unmaskedpayload.put((byte)c);
                ++nRead;
                ++i;
            }
        }
        if (trace.getDebugCode("ws")) {
            this.traceDump("fromStream() payload readCount " + nRead, this.unmaskedpayload.array(), nRead);
        }
    }

    private byte[] readStream(BufferedInputStream in, int n, int offset) throws IOException {
        byte[] result = new byte[n];
        int c = -1;
        int i = 0;
        PrintStream dump = null;
        if (trace.getDebugCode("ws")) {
            dump = System.out;
            dump.printf("CTATWSFrameData.readStream %d at offset %d:", n, offset);
        }
        while (i < n && (c = in.read()) != -1) {
            if (dump != null) {
                dump.printf(" %02X", c);
            }
            result[i++] = (byte)c;
        }
        if (dump != null) {
            dump.printf("; %d read, last %02X\n", i, c);
        }
        if (i < n) {
            throw new IOException("CTATWSFrameData.readStream length " + n + " truncated to " + i + " starting at offset " + offset);
        }
        return result;
    }

    private void traceDump(String label, byte[] buffer, int count) {
        StringBuilder sb = new StringBuilder(label);
        sb.append(", size ").append(buffer.length).append(", actual length ").append(count);
        for (int i = 0; i < count; ++i) {
            sb.append(String.format(" %02X", buffer[i]));
        }
        trace.out("ws", "traceDump: " + sb);
    }

    public boolean isFin() {
        return this.fin;
    }

    public Opcode getOpcode() {
        return this.opcode;
    }

    public boolean getMasked() {
        return this.masked;
    }

    public byte[] getPayloadData() {
        return CTATWSFrameData.getPayloadData(this.unmaskedpayload);
    }

    static byte[] getPayloadData(ByteBuffer payload) {
        if (payload.position() <= 0) {
            return emptyByteArray;
        }
        payload.flip();
        byte[] result = new byte[payload.limit()];
        payload.get(result);
        payload.compact();
        return result;
    }

    public void setFin(boolean fin) {
        this.fin = fin;
    }

    public void setOpcode(Opcode optcode) {
        this.opcode = optcode;
    }

    public void setPayload(byte[] payload) {
        if (payload != null) {
            this.unmaskedpayload = ByteBuffer.wrap(payload);
            this.unmaskedpayload.position(payload.length);
        }
    }

    public void setMasked(boolean transferemasked) {
        this.masked = transferemasked;
    }

    public void append(CTATWSFrameData nextframe) {
        int available = this.unmaskedpayload == null ? 0 : this.unmaskedpayload.capacity() - this.unmaskedpayload.position();
        int needed = nextframe.unmaskedpayload.position();
        if (trace.getDebugCode("ws")) {
            trace.out("ws", "CTATWSFrameData.append() available " + available + ", needed " + needed);
        }
        if (available < needed) {
            ByteBuffer oldPayload = this.unmaskedpayload;
            this.unmaskedpayload = ByteBuffer.allocate(oldPayload.position() + needed + 65558);
            this.unmaskedpayload.put(CTATWSFrameData.getPayloadData(oldPayload));
            this.unmaskedpayload.put((ByteBuffer)oldPayload.flip());
        }
        this.unmaskedpayload.put(nextframe.getPayloadData());
        this.setFin(nextframe.isFin());
    }

    public String toString() {
        return "Framedata{ opcode:" + (Object)((Object)this.getOpcode()) + ", fin:" + this.isFin() + ", masked:" + this.getMasked() + ", payloadlength:" + this.unmaskedpayload.limit() + ", payload:" + CTATCharsetFunctions.utf8Bytes(new String(this.unmaskedpayload.array())) + "}";
    }

    static Opcode toOpcode(byte b) {
        switch (b & 0x7F) {
            case 0: {
                return Opcode.CONTINUATION;
            }
            case 1: {
                return Opcode.TEXT;
            }
            case 2: {
                return Opcode.BINARY;
            }
            case 8: {
                return Opcode.CLOSING;
            }
            case 9: {
                return Opcode.PING;
            }
            case 10: {
                return Opcode.PONG;
            }
        }
        return null;
    }

    static byte fromOpcode(Opcode opcode) {
        switch (opcode) {
            case CONTINUATION: {
                return 0;
            }
            case TEXT: {
                return 1;
            }
            case BINARY: {
                return 2;
            }
            case CLOSING: {
                return 8;
            }
            case PING: {
                return 9;
            }
            case PONG: {
                return 10;
            }
        }
        throw new RuntimeException("Don't know how to handle " + opcode.toString());
    }

    static byte[] formatClosePayload(int status, String text) {
        if (status < 0) {
            return emptyByteArray;
        }
        if (status < 1000 || 4999 < status) {
            trace.err("CTATWSFrameData.formatClosePayload(): Invalid status code " + status + "; must be in range 1000-4999");
            status = 1008;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            baos.write(status >> 8 & 0xFF);
            baos.write(status & 0xFF);
            if (text != null) {
                baos.write(text.getBytes("UTF-8"));
            }
        }
        catch (Exception e) {
            trace.errStack("Error formatting web socket CLOSE frame payload from status " + status + ", text " + text, e);
            return emptyByteArray;
        }
        return baos.toByteArray();
    }

    static enum Opcode {
        CONTINUATION,
        TEXT,
        BINARY,
        PING,
        PONG,
        CLOSING;

    }

    public static class IncompleteException
    extends IOException {
        private static final long serialVersionUID = 3681798537411014757L;
        private int preferedsize;

        public IncompleteException(int preferedsize) {
            this.preferedsize = preferedsize;
        }

        @Override
        public String getMessage() {
            return "Minimum number of bytes " + this.preferedsize + " not reached";
        }
    }
}

