/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.ctat;

import edu.cmu.hcii.ctat.CTATCurriculum;
import edu.cmu.hcii.ctat.CTATDataShop;
import edu.cmu.hcii.ctat.CTATFlashDriver;
import edu.cmu.hcii.ctat.CTATHTML5Driver;
import edu.cmu.hcii.ctat.CTATHTTPExchange;
import edu.cmu.hcii.ctat.CTATHTTPHandlerBase;
import edu.cmu.hcii.ctat.CTATHTTPHandlerInterface;
import edu.cmu.hcii.ctat.CTATLink;
import edu.cmu.hcii.ctat.CTATObjectTagDriver;
import edu.cmu.hcii.ctat.CTATProblem;
import edu.cmu.hcii.ctat.CTATProblemSet;
import edu.cmu.hcii.ctat.CTATWebTools;
import edu.cmu.hcii.ctat.UserProgressDatabase;
import edu.cmu.pact.Utilities.Utils;
import edu.cmu.pact.Utilities.trace;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;

public class CTATHTTPLocalHandler
extends CTATHTTPHandlerBase
implements CTATHTTPHandlerInterface {
    private List<String> problemSummaries = new ArrayList<String>();
    public String currentAssignment;
    private static String updateProgressPage = "<html><header></header><body><center><table width=\"100%\" height=\"100%\"><tr><td valign=\"middle\" align=\"center\"><h1>System update in progress, can't run student assignments at this point. Please try again later</h1></td></tr></table></center></body></html>";
    private static String templateFileNotFound = "<html><body><center><table width=100% height=100%><tr><td align=center valign=middle></td></tr></table></center></body></html>";
    protected CTATObjectTagDriver fTagGenerator = null;
    private CTATCurriculum curriculum = null;
    private CTATProblemSet fProblemSet = null;
    private CTATWebTools fWebTools = null;
    Pattern remoteSocketURL = Pattern.compile("remoteSocketURL\\s*=\\s*[^&]*");
    Pattern remoteSocketPort = Pattern.compile("remoteSocketPort\\s*=\\s*\\d*");
    Pattern htdocs_remoteBRDs = Pattern.compile(CTATLink.htdocs + "remoteBRDs.");
    protected UserProgressDatabase localUserDB = null;

    public CTATHTTPLocalHandler(String logFileName, UserProgressDatabase aDB) {
        super(logFileName);
        this.setClassName("CTATHTTPLocalHandler");
        this.debug("CTATHTTPLocalHandler (" + logFileName + "," + CTATLink.allowWriting + ")");
        this.localUserDB = aDB;
        System.setProperty("sun.net.http.allowRestrictedHeaders", "true");
        if (CTATLink.deployType == CTATLink.DEPLOYFLASH) {
            this.fTagGenerator = new CTATFlashDriver();
        }
        if (CTATLink.deployType == CTATLink.DEPLOYHTML5) {
            this.fTagGenerator = new CTATHTML5Driver();
        }
        this.fProblemSet = new CTATProblemSet();
        this.fWebTools = new CTATWebTools();
        this.debug("CTATHTTPLocalHandler() Done");
    }

    public CTATCurriculum getCurriculum() {
        return this.curriculum;
    }

    public void setCurriculum(CTATCurriculum aCurriculum) {
        this.curriculum = aCurriculum;
    }

    protected String directoryToMenu() {
        this.debug("directoryToMenu ()");
        StringBuffer composite = new StringBuffer();
        composite.append("<ul class=\"collapsibleList\" id=\"curriculum\">");
        if (this.curriculum != null) {
            this.debug("We have a curriculum, distilling problem sets ...");
            this.debug("Building directory listing for first problem set");
            ArrayList<CTATProblemSet> entries = this.curriculum.getProblemSets(this.curriculum.getFirstAssignment());
            this.debug("Proceeding (" + entries.size() + ") ...");
            for (int i = 0; i < entries.size(); ++i) {
                CTATProblemSet entry = entries.get(i);
                if (entry != null) {
                    StringBuffer builder = new StringBuffer();
                    builder.append("<li>");
                    builder.append(entry.getDirectory());
                    builder.append(" : ");
                    builder.append(entry.getDescription());
                    builder.append(entry.listProblemSetHTML());
                    builder.append("</li>");
                    this.debug(builder.toString());
                    composite.append(builder.toString());
                    continue;
                }
                this.debug("Internal error: entry object for index " + i + " is null!");
            }
        } else {
            this.debug("The curriculum object is null!");
            ArrayList<CTATProblemSet> entries = CTATLink.fDirectoryTXT.getEntries();
            for (int i = 0; i < entries.size(); ++i) {
                CTATProblemSet entry = entries.get(i);
                composite.append("<li>" + entry.getDirectory() + " : " + entry.getDescription());
                composite.append(entry.listProblemSetHTML());
                composite.append("</li>");
            }
        }
        composite.append("</ul>");
        return composite.toString();
    }

    public String createRoot(String aProblemSet) {
        this.debug("createRoot (" + aProblemSet + ")");
        String composite = "";
        String problemMenu = "";
        Boolean showInfo = false;
        String indexFile = CTATObjectTagDriver.createIndexFile();
        String indexTemplate = CTATLink.fManager.getContents(CTATLink.htdocs + indexFile);
        if (indexTemplate == null) {
            this.debug("Error: can't process root template");
            return null;
        }
        showInfo = indexTemplate.indexOf("flashtags-full") != -1 ? Boolean.valueOf(true) : Boolean.valueOf(false);
        problemMenu = this.directoryToMenu();
        ArrayList<CTATProblemSet> problemSets = null;
        if (this.curriculum != null) {
            this.debug("We have a curriculum, loading first problem set in assignment ...");
            problemSets = this.curriculum.getProblemSets(this.curriculum.getFirstAssignment());
        } else {
            this.debug("We don't have a valid curriculum, using directory.txt ...");
            problemSets = CTATLink.fDirectoryTXT.getEntries();
        }
        if (problemSets.size() == 0) {
            Utils.showExceptionOccuredDialog(null, "No problem sets could be found in the FlashTutors directory (under htdocs). This may be because tutors were not installed locally or the required problem_set.xml files are missing.", "No tutors found");
            System.exit(0);
        }
        this.fProblemSet = problemSets.get(0);
        if (this.fProblemSet != null) {
            this.fProblemSet.reset();
            CTATProblem startProblem = this.fProblemSet.getNextProblem();
            if (startProblem == null) {
                String lastproblemTemplate = CTATLink.fManager.getContents(CTATLink.htdocs + "templates/endofproblemset.html");
                if (lastproblemTemplate == null) {
                    this.debug("Error: can't process \"end of problem set\" template");
                    lastproblemTemplate = "You have reached the end of the problem set.";
                }
                this.processProblemSetEnd(this.problemSummaries);
                composite = lastproblemTemplate.replaceFirst("directory.txt", this.directoryToMenu());
                return composite;
            }
            this.fTagGenerator.setIncludeMenu(showInfo);
            String flashTags = this.fTagGenerator.generateObjectTags(startProblem, this.fProblemSet);
            composite = showInfo == true ? indexTemplate.replaceFirst("flashtags-full", flashTags) : indexTemplate.replaceFirst("flashtags", flashTags);
            composite = composite.replaceFirst("ProblemSetTitle", startProblem.name + " : " + this.fProblemSet.getDescription() + " : " + this.fProblemSet.getName());
            composite = composite.replaceFirst("directory.txt", problemMenu);
        } else {
            composite = showInfo == true ? indexTemplate.replaceFirst("flashtags-full", "Error: unable to obtain first problem set from repository") : indexTemplate.replaceFirst("flashtags", "Error: unable to obtain first problem set from repository");
        }
        return composite;
    }

    public String createPage(CTATProblem aProblem) {
        this.debug("createPage ()");
        String composite = "";
        Boolean showInfo = false;
        if (aProblem == null) {
            String lastproblemTemplate = CTATLink.fManager.getContents(CTATLink.htdocs + "templates/endofproblemset.html");
            if (lastproblemTemplate == null) {
                this.debug("Error: can't process \"end of problem set\" template");
                lastproblemTemplate = "You have reached the end of the problem set.";
            }
            this.processProblemSetEnd(this.problemSummaries);
            composite = lastproblemTemplate.replaceFirst("directory.txt", this.directoryToMenu());
            return composite;
        }
        String indexTemplate = CTATLink.fManager.getContents(CTATLink.htdocs + CTATObjectTagDriver.createIndexFile());
        if (indexTemplate == null) {
            this.debug("Error: can't process root template");
            return null;
        }
        showInfo = indexTemplate.indexOf("flashtags-full") != -1 ? Boolean.valueOf(true) : Boolean.valueOf(false);
        this.fProblemSet.setCurrentIndex(aProblem.index);
        String problemMenu = this.directoryToMenu();
        String flashTags = this.fTagGenerator.generateObjectTags(aProblem, this.fProblemSet);
        composite = showInfo == true ? indexTemplate.replaceFirst("flashtags-full", flashTags) : indexTemplate.replaceFirst("flashtags", flashTags);
        composite = composite.replaceFirst("ProblemSetTitle", aProblem.name + " : " + this.fProblemSet.getDescription() + " : " + this.fProblemSet.getName());
        composite = composite.replaceFirst("directory.txt", problemMenu);
        return composite;
    }

    private boolean processProblemEnd(String summary) {
        if (CTATLink.problemEndHandler == null) {
            return false;
        }
        return CTATLink.problemEndHandler.problemEnd(summary);
    }

    private boolean processProblemSetEnd(List<String> summaries) {
        if (CTATLink.problemSetEndHandler == null) {
            return false;
        }
        return CTATLink.problemSetEndHandler.problemSetEnd(summaries);
    }

    @Override
    public synchronized boolean handle(CTATHTTPExchange arg0, String requestBody) {
        String fileURI;
        this.debug("handle (" + arg0.getRequestURI().getPath() + "); active threads " + Thread.activeCount());
        Boolean processed = false;
        String requestMethod = arg0.getRequestMethod();
        this.debug("Request method: " + requestMethod + ", Request URI: " + arg0.getRequestURI());
        if (requestMethod.equalsIgnoreCase("options")) {
            this.debug("Processing OPTIONS ...");
            arg0.sendOptions();
            processed = true;
        }
        if (requestMethod.equalsIgnoreCase("post")) {
            this.debug("Processing POST ...");
            if (this.getLogging().booleanValue() || !CTATLink.allowWriting) {
                processed = this.doPOST(arg0);
            } else {
                this.debug("Requested post, but HTTPServer wasn't called with logfile");
                arg0.sendResponseHeaders(501, 0L);
            }
        }
        if (requestMethod.equalsIgnoreCase("get") && !(processed = this.doGET(arg0)).booleanValue() && !(processed = Boolean.valueOf(this.sendLocalFile(fileURI = arg0.getRequestURI().toString(), CTATLink.htdocs, arg0))).booleanValue()) {
            arg0.send404("Error: Did not understand GET request (" + CTATLink.lastError + ")");
        }
        arg0.close();
        return processed;
    }

    public Boolean doGET(CTATHTTPExchange arg0) {
        this.debug("doGET ()");
        String fileURI = arg0.getRequestURI().toString();
        this.debug("File uri = " + fileURI);
        boolean found = false;
        if (fileURI.equalsIgnoreCase("/exittutorshop.cgi") || fileURI.equalsIgnoreCase("/exitclient.cgi")) {
            this.debug("Processing exit TutorShop request ...");
            found = true;
            if (trace.getDebugCode("kill")) {
                trace.printStack("kill", "handle(" + arg0 + ") for /exittutorshop.cgi");
            }
            this.sendHTMLResponse(arg0, "<html>\n  <head>\n    <title>TutorShop Exiting</title>\n    <style>body { background-color: #DDDDDD; font-family: Verdana, sans-serif; }</style>\n  </head>\n  <body>\n    <table width=\"100%\" height=\"100%\" cellpadding=\"0\" cellspacing=\"0\">\n      <tr>\n        <td valign=\"middle\" align=\"center\">\n          <h2>This session has ended. Local TutorShop exiting...</h2>\n        </td>\n      </tr>\n    </table>\n  </body>\n</html>\n", 200);
            if (fileURI.contains("exittutorshop")) {
                System.exit(0);
            } else {
                return true;
            }
        }
        if (CTATLink.appState.compareTo("updating") == 0) {
            try {
                arg0.addResponseHeader("Content-Type", "text/html");
                arg0.sendResponseHeaders(200, updateProgressPage.getBytes().length);
                arg0.writeBytesString(updateProgressPage, false);
                this.debug("Wrote back update in progress message to browser");
                arg0.close();
                this.writeToAccessLog("<update in progress>");
            }
            catch (Exception e) {
                this.debug("Exception in trying to write back root index file");
            }
            return true;
        }
        if (fileURI.equalsIgnoreCase("/crossdomain.xml")) {
            this.debug("Processing crossdomain request ...");
            found = true;
            this.debug("Writing back the crossdomain policy...");
            try {
                arg0.addResponseHeader("Content-Type", "application/xml");
                arg0.sendResponseHeaders(200, CTATLink.crossDomainPolicy.getBytes().length);
                arg0.getOutputStream().write(CTATLink.crossDomainPolicy.getBytes());
                this.debug("Wrote back Crossdomain.xml..");
                arg0.close();
            }
            catch (Exception e) {
                this.debug("Exception in trying to write back crossdomain.xml");
            }
        }
        if (fileURI.contains("/getpush.cgi")) {
            found = true;
            this.debug("Processing 'getpush' GET request ...");
            String responseBody = "<p>get<b>push</b> response</p>";
            this.sendHTMLResponse(arg0, responseBody, 200);
        }
        if (fileURI.equalsIgnoreCase("/index.html") || fileURI.equalsIgnoreCase("/index.htm") || fileURI.equalsIgnoreCase("/")) {
            this.debug("Processing root request ...");
            found = true;
            String rootResponse = this.createRoot("");
            if (rootResponse != null) {
                try {
                    arg0.addResponseHeader("Content-Type", "text/html");
                    arg0.sendResponseHeaders(200, rootResponse.getBytes().length);
                    arg0.getOutputStream().write(rootResponse.getBytes());
                    this.debug("Wrote back root index file");
                    arg0.close();
                    this.writeToAccessLog("/");
                }
                catch (Exception e) {
                    this.debug("Exception in trying to write back root index file");
                }
            } else {
                try {
                    arg0.addResponseHeader("Content-Type", "text/html");
                    arg0.sendResponseHeaders(404, templateFileNotFound.getBytes().length);
                    arg0.getOutputStream().write(templateFileNotFound.getBytes());
                    this.debug("Wrote back root index file");
                    arg0.close();
                }
                catch (Exception e) {
                    this.debug("Exception in trying to write back root index file");
                }
            }
        }
        if (fileURI.indexOf("showproblemset.cgi") != -1) {
            this.debug("Processing 'show problem set' request ...");
            found = true;
            this.fWebTools.showURI(arg0.getRequestURI());
            Map<String, String> map = this.fWebTools.getQueryMap(arg0.getRequestURI().getRawQuery());
            String selectedProblemSet = map.get("problemname");
            String rootResponse = this.createRoot(selectedProblemSet);
            if (rootResponse != null) {
                try {
                    arg0.addResponseHeader("Content-Type", "text/html");
                    arg0.sendResponseHeaders(200, rootResponse.getBytes().length);
                    arg0.getOutputStream().write(rootResponse.getBytes());
                    this.debug("Wrote back root index file");
                    arg0.close();
                    this.writeToAccessLog("/");
                }
                catch (Exception e) {
                    this.debug("Exception in trying to write back root index file");
                }
            } else {
                try {
                    arg0.addResponseHeader("Content-Type", "text/html");
                    arg0.sendResponseHeaders(404, templateFileNotFound.getBytes().length);
                    arg0.getOutputStream().write(templateFileNotFound.getBytes());
                    this.debug("Wrote back root index file");
                    arg0.close();
                }
                catch (Exception e) {
                    this.debug("Exception in trying to write back root index file");
                }
            }
        }
        if (fileURI.contains("gotoproblem.cgi") || fileURI.contains("problemselect.cgi")) {
            this.debug("Processing " + fileURI + " request ...");
            found = true;
            CTATWebTools urltools = new CTATWebTools();
            Map<String, String> map = urltools.parseQuery(arg0.getRequestURI().getRawQuery());
            int problemNum = Integer.valueOf(map.get("position"));
            this.fProblemSet.setCurrentIndex(problemNum);
            String responseBody = this.createPage(this.fProblemSet.getNextProblem());
            this.debug("Sending: " + responseBody);
            arg0.addResponseHeader("Content-Type", "text/html");
            arg0.sendResponseHeaders(200, responseBody.length());
            BufferedOutputStream buf = arg0.getOutputStream();
            try {
                buf.write(responseBody.getBytes(), 0, responseBody.length());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                buf.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.debug("Response written to client.");
        }
        if (fileURI.contains("/stats.cgi")) {
            found = true;
            if (CTATLink.adminLogin) {
                StringBuilder responseBuilder = new StringBuilder("<h1>Statistics</h1>");
                boolean result = true;
                if (!CTATLink.fDirectoryTXT.isLoaded()) {
                    result = CTATLink.fDirectoryTXT.loadDirectoryTXT(CTATLink.htdocs + "FlashTutors/directory.txt");
                }
                if (result) {
                    ArrayList<CTATProblemSet> problemSets = CTATLink.fDirectoryTXT.getEntries();
                    int numProblemSets = problemSets.size();
                    int totalProblems = 0;
                    for (int i = 0; i < numProblemSets; ++i) {
                        CTATProblemSet probSet = problemSets.get(i);
                        totalProblems += probSet.getNumProblems();
                        responseBuilder.append("Problem set \"" + probSet.getName() + "\": " + probSet.getNumProblems() + " problems<br/>");
                    }
                    responseBuilder.append("<hr/>");
                    responseBuilder.append("Number of problem sets: " + numProblemSets + "<br/>");
                    responseBuilder.append("Total problems: " + totalProblems + "<br/>");
                } else {
                    responseBuilder.append("Error: The problem sets could not be loaded.<br/>");
                }
                responseBuilder.append("<hr/>");
                Date lastUpload = CTATDataShop.getLastUploadTime();
                if (lastUpload != null) {
                    SimpleDateFormat df = new SimpleDateFormat("dd MMM yyyy HH:mm:ss");
                    responseBuilder.append("Last upload of log data to DataShop was " + df.format(lastUpload) + "<br/>");
                } else {
                    responseBuilder.append("Log data has not been uploaded to DataShop during this session.<br/>");
                }
                responseBuilder.append("Size of local log file: " + new File(CTATLink.datashopFile).length() + " bytes<br/>");
                responseBuilder.append("<a href=\"/admin.html\">Return to administrator page</a>");
                String responseBody = responseBuilder.toString();
                try {
                    arg0.addResponseHeader("Content-Type", "text/html");
                    arg0.sendResponseHeaders(200, responseBody.length());
                    BufferedOutputStream buf = arg0.getOutputStream();
                    buf.write(responseBody.getBytes(), 0, responseBody.length());
                    buf.flush();
                }
                catch (IOException e) {
                    this.debug("IOError writing back response: " + e);
                }
            } else {
                arg0.sendResponseHeaders(403, 0L);
            }
        }
        if (fileURI.contains("/nextproblem.cgi")) {
            found = true;
            this.debug("Processing 'next problem' request ...");
            CTATProblem nextProblem = this.fProblemSet.getNextProblem();
            if (nextProblem == null) {
                this.debug("nextProblem==null, attempting to roll over to the next problem set");
                ArrayList<CTATProblemSet> problemSets = null;
                if (this.curriculum != null) {
                    this.debug("We have a curriculum, loading next problem set in assignment ...");
                    problemSets = this.curriculum.getProblemSets(this.curriculum.getNextStudentAssignment(this.fProblemSet.getName()));
                    if (this.fProblemSet != null) {
                        this.fProblemSet = problemSets.get(0);
                    }
                } else {
                    this.debug("We don't have a valid curriculum, using directory.txt ...");
                    this.fProblemSet = CTATLink.fDirectoryTXT.getNextEntry();
                }
                if (this.fProblemSet != null) {
                    this.debug("We appear to have more problem sets to go through, booting: " + this.fProblemSet.getName());
                    nextProblem = this.fProblemSet.getNextProblem();
                } else {
                    this.debug("It appears we've reached the end of the assignment");
                }
            }
            this.fProblemSet.deActivate();
            nextProblem.setActive(true);
            String responseBody = this.createPage(nextProblem);
            this.sendHTMLResponse(arg0, responseBody, 200);
        }
        return found;
    }

    public Boolean doPOST(CTATHTTPExchange arg0) {
        Map<String, String> map;
        String queryString;
        this.debug("doPOST ()");
        boolean found = false;
        CTATWebTools urltools = new CTATWebTools();
        String fileURI = arg0.getRequestURI().toString();
        URI queryURI = arg0.getRequestURI();
        urltools.showURI(queryURI);
        String responseBody = "";
        if (fileURI.contains("/log/server")) {
            found = true;
            this.debug("Logging DataShop traffic to disk ...");
            String logMessage = this.getPOSTContent(arg0);
            if (logMessage != null) {
                this.writeToLog(logMessage);
                arg0.sendResponseHeaders(500, 0L);
                responseBody = responseBody + "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n";
                responseBody = responseBody + "<log-result>\n";
                responseBody = responseBody + "  <read-request success=\"true\" length=\"" + this.getPOSTContentSize(arg0) + "\" />\n";
                responseBody = responseBody + "  <write-file success=\"true\">\n    ";
                responseBody = responseBody + CTATLink.logdir + "/log/server";
                responseBody = responseBody + "\n  </write-file>\n";
                responseBody = responseBody + "</log-result>\n";
                arg0.addResponseHeader("Content-Type", "text/xml");
                CTATHTTPLocalHandler.sendResponse(arg0, responseBody, 200);
            }
        }
        if (fileURI.contains("/problemselect.cgi") || fileURI.contains("/lastproblem.cgi")) {
            found = true;
            this.debug("Processing '/problemselect.cgi or /lastproblem.cgi' request ...");
            queryString = this.getPOSTContent(arg0);
            if (queryString != null) {
                map = urltools.parseQuery(queryString);
                String summary = map.get("summary");
                try {
                    if (summary != null) {
                        summary = URLDecoder.decode(summary, "UTF-8");
                        this.debug("Storing problem summary ...");
                        this.problemSummaries.add(summary);
                        this.debug("Notifying handlers ...");
                        this.processProblemEnd(summary);
                    }
                }
                catch (UnsupportedEncodingException uee) {
                    System.out.println("Exception decoding UTF-8:" + uee);
                }
                this.sendHTMLResponse(arg0, " ", 200);
            }
        }
        if (fileURI.contains("/gotoproblem.cgi")) {
            found = true;
            this.debug("Processing 'goto problem' request ...");
            if (!CTATLink.adminLogin && !CTATLink.getAdminPassword()) {
                arg0.sendResponseHeaders(204, 0L);
                return false;
            }
            queryString = this.getPOSTContent(arg0);
            if (queryString != null) {
                map = urltools.parseQuery(queryString);
                String nextProblem = map.get("position");
                this.fProblemSet.setCurrentIndex(Integer.parseInt(nextProblem.trim()));
                responseBody = this.fTagGenerator.generateFlashVars(this.fProblemSet.getNextProblem(), this.fProblemSet);
                this.sendHTMLResponse(arg0, responseBody, 200);
            }
        }
        if (fileURI.contains("datashop.cgi")) {
            found = true;
            if (CTATLink.adminLogin) {
                String postContent = this.getPOSTContent(arg0);
                if (postContent.contains("=QA")) {
                    CTATLink.datashopURL = "http://pslc-qa.andrew.cmu.edu/log/server";
                } else if (postContent.contains("=Main")) {
                    int response = JOptionPane.showConfirmDialog(null, "You have chosen to upload the log to the main DataShop server. Only actual student data should be sent to this server. Are you sure you want to continue?", "Please confirm your selection", 0);
                    if (response == 1) {
                        arg0.sendResponseHeaders(204, 0L);
                        arg0.close();
                        return false;
                    }
                    CTATLink.datashopURL = "http://learnlab.web.cmu.edu/log/server";
                } else if (postContent.contains("=Test")) {
                    CTATLink.datashopURL = "http://digger.pslc.cs.cmu.edu/log/server/sandboxlogger.php";
                }
                responseBody = "<html>Currently uploading data to DataShop. This may take a few minutes. You will be notified when the data transfer is complete.<br/><a href=\"/admin.html\">Return to administrator page</a></html>";
                this.sendHTMLResponse(arg0, responseBody, 200);
                CTATDataShop datashop = new CTATDataShop();
                boolean success = datashop.migrateData();
                if (success) {
                    JOptionPane.showMessageDialog(null, "The data transfer you requested is complete.");
                } else {
                    JOptionPane.showMessageDialog(null, "An exception occurred which prevented the data from being transferred.");
                }
            } else {
                arg0.sendResponseHeaders(403, 0L);
            }
        }
        if (fileURI.equalsIgnoreCase("/changeadminpassword.cgi")) {
            this.debug("Processing change admin password request ...");
            found = true;
            if (CTATLink.adminLogin) {
                int statusCode;
                String newPassword = JOptionPane.showInputDialog(null, (Object)"Please enter a new administrator password.");
                if (newPassword != null) {
                    CTATLink.fManager.setContentsEncrypted(CTATLink.adminPasswordFilename, newPassword);
                    responseBody = "<html>Your password has been changed successfully.<br/><a href=\"/admin.html\">Return to administrator page</a><html>";
                    statusCode = 200;
                } else {
                    responseBody = "";
                    statusCode = 204;
                }
                this.sendHTMLResponse(arg0, responseBody, statusCode);
            } else {
                arg0.sendResponseHeaders(403, 0L);
            }
        }
        if (fileURI.equalsIgnoreCase("/exittutorshop.cgi")) {
            this.debug("Processing exit TutorShop request ...");
            found = true;
            responseBody = "<html>\n  <head>\n    <title>TutorShop Exiting</title>\n    <style>body { background-color: #DDDDDD; font-family: Verdana, sans-serif; }</style>\n  </head>\n  <body>\n    <table width=\"100%\" height=\"100%\" cellpadding=\"0\" cellspacing=\"0\">\n      <tr>\n        <td valign=\"middle\" align=\"center\">\n          <h2>This session has ended. Local TutorShop exiting...</h2>\n        </td>\n      </tr>\n    </table>\n  </body>\n</html>\n";
            this.sendHTMLResponse(arg0, responseBody, 200);
            arg0.close();
            System.exit(0);
        }
        return found;
    }
}

