/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.ctat;

import edu.cmu.hcii.ctat.CTATContentCache;
import edu.cmu.hcii.ctat.CTATHTTPExchange;
import edu.cmu.hcii.ctat.CTATHTTPHandlerBase;
import edu.cmu.hcii.ctat.CTATHTTPHandlerInterface;
import edu.cmu.hcii.ctat.CTATLink;
import edu.cmu.hcii.ctat.CTATWebTools;
import edu.cmu.hcii.ctat.UserProgressDatabase;
import edu.cmu.pact.Utilities.Utils;
import edu.cmu.pact.Utilities.trace;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;

class CTATHTTPHandler
extends CTATHTTPHandlerBase
implements CTATHTTPHandlerInterface {
    private PollAlarm pushAlarm = new PollAlarm();
    private static final String SO_LONG = "<html>\n  <head>\n    <title>TutorShop Exiting</title>\n    <style>body { background-color: #DDDDDD; font-family: Verdana, sans-serif; }</style>\n  </head>\n  <body>\n    <table width=\"100%\" height=\"100%\" cellpadding=\"0\" cellspacing=\"0\">\n      <tr>\n        <td valign=\"middle\" align=\"center\">\n          <h2>This session has ended. Local TutorShop exiting...</h2>\n        </td>\n      </tr>\n    </table>\n  </body>\n</html>\n";
    private UserProgressDatabase userProgressDatabase = new UserProgressDatabase();
    private String currentAssignment;
    private static final String TUTORSHOP_FORWARD_TO = "tutorshop_forward_to";
    private static String updateProgressPage = "<html><header></header><body><center><table width=\"100%\" height=\"100%\"><tr><td valign=\"middle\" align=\"center\"><h1>System update in progress, can't run student assignments at this point. Please try again later</h1></td></tr></table></center></body></html>";
    private String pathToRoot;
    private CTATContentCache cache;
    private Queue<PushResponse> pushQueue = new LinkedList<PushResponse>();
    private static long totalBytesReceivedRemotely = 0L;
    Pattern remoteSocketURL = Pattern.compile("remoteSocketURL\\s*=\\s*[^&]*");
    Pattern remoteSocketPort = Pattern.compile("remoteSocketPort\\s*=\\s*\\d*");
    Pattern htdocs_remoteBRDs = Pattern.compile(CTATLink.htdocs + "remoteBRDs.");

    public CTATHTTPHandler(String pathToRoot, String logFileName) throws IOException {
        super(logFileName);
        this.setClassName("CTATHTTPHandler");
        this.debug("CTATHTTPHandler ()");
        System.setProperty("sun.net.http.allowRestrictedHeaders", "true");
        this.pathToRoot = pathToRoot;
        if (!CTATLink.remoteHost.equals("") && !CTATLink.remoteHost.equals("local")) {
            if (CTATLink.cache == null) {
                File cacheDirectory = new File(CTATLink.htdocs + "/cache/");
                if (!cacheDirectory.exists()) {
                    cacheDirectory.mkdir();
                }
                CTATLink.cache = this.cache = new CTATContentCache(cacheDirectory, CTATLink.allowWriting);
            } else {
                this.cache = CTATLink.cache;
            }
        } else {
            this.cache = new CTATContentCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String convertStreamToString(InputStream is) throws IOException {
        this.debug("convertStreamToString ()");
        if (is != null) {
            StringWriter writer = new StringWriter();
            char[] buffer = new char[1024];
            try {
                int n;
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                while ((n = reader.read(buffer)) != -1) {
                    ((Writer)writer).write(buffer, 0, n);
                }
            }
            finally {
                is.close();
            }
            return ((Object)writer).toString();
        }
        return "";
    }

    @Override
    public int getPOSTContentSize(CTATHTTPExchange arg0) {
        this.debug("getPOSTContent ()");
        List<String> contentLength = arg0.getRequestHeaders().get("Content-Length");
        if (contentLength != null) {
            int bodySize = Integer.parseInt(contentLength.get(0));
            return bodySize;
        }
        return 0;
    }

    @Override
    public InputStream getPOSTContentRaw(CTATHTTPExchange arg0) {
        this.debug("getPOSTContentRaw ()");
        InputStream inStream = arg0.getRequestBody();
        return inStream;
    }

    @Override
    public String getPOSTContent(CTATHTTPExchange arg0) {
        this.debug("getPOSTContent ()");
        InputStream inStream = arg0.getRequestBody();
        String logMessage = "";
        try {
            logMessage = this.convertStreamToString(inStream);
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return null;
        }
        return logMessage;
    }

    public void doPost(CTATHTTPExchange arg0) {
        boolean success;
        this.debug("doPost ()");
        boolean found = false;
        CTATWebTools urltools = new CTATWebTools();
        String fileURI = arg0.getRequestURI().toString();
        URI queryURI = arg0.getRequestURI();
        urltools.showURI(queryURI);
        String responseBody = "";
        if (fileURI.contains("/log/server")) {
            found = true;
            this.debug("Logging DataShop traffic to disk ...");
            String logMessage = this.getPOSTContent(arg0);
            if (logMessage != null) {
                Boolean result = this.writeToLog(logMessage);
                if (!result.booleanValue()) {
                    arg0.sendResponseHeaders(500, 0L);
                } else {
                    responseBody = responseBody + "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n";
                    responseBody = responseBody + "<log-result>\n";
                    responseBody = responseBody + "  <read-request success=\"true\" length=\"" + this.getPOSTContentSize(arg0) + "\" />\n";
                    responseBody = responseBody + "  <write-file success=\"true\">\n    ";
                    responseBody = responseBody + this.pathToRoot + "/log/server";
                    responseBody = responseBody + "\n  </write-file>\n";
                    responseBody = responseBody + "</log-result>\n";
                    arg0.addResponseHeader("Content-Type", "text/xml");
                    CTATHTTPHandler.sendResponse(arg0, responseBody, 200);
                }
                arg0.close();
            }
        }
        if (fileURI.contains("/refreshcache")) {
            found = true;
            if (CTATLink.adminLogin) {
                boolean success2;
                if (CTATLink.remoteHost.equals("") || CTATLink.remoteHost.equals("local")) {
                    JOptionPane.showMessageDialog(null, "The content cannot be refreshed because no remote server is specified in the configuration file. To change this, run the program in config mode.");
                    arg0.sendResponseHeaders(204, 0L);
                    arg0.close();
                    return;
                }
                int choice = JOptionPane.showConfirmDialog(null, "You have chosen to refresh the local cache using content on another server. This should only be done with a reliable and fast Internet connection. Are you sure you want to do this?", "Please confirm", 0);
                if (choice == 1) {
                    arg0.sendResponseHeaders(204, 0L);
                    arg0.close();
                    return;
                }
                responseBody = "<html>Currently refreshing the cache. This may take a few minutes. You will be notified when the refresh process is complete.<br/><a href=\"/admin.html\">Return to administrator page</a></html>";
                this.sendHTMLResponse(arg0, responseBody, 200);
                try {
                    URL url = new URL("http", CTATLink.remoteHost, "/filesToDownload.php");
                    HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                    if (conn.getResponseCode() >= 400) {
                        success2 = this.cache.refreshCache(CTATLink.remoteHost);
                    } else {
                        String thisLine;
                        BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                        ArrayList<String> lines = new ArrayList<String>();
                        while ((thisLine = reader.readLine()) != null) {
                            if (thisLine.length() <= 0) continue;
                            lines.add("/" + thisLine);
                        }
                        success2 = this.cache.refreshCertainFiles(CTATLink.remoteHost, lines.toArray(new String[0]), true, true);
                    }
                }
                catch (MalformedURLException e) {
                    this.debug(e.toString());
                    success2 = false;
                }
                catch (IOException e) {
                    this.debug(e.toString());
                    success2 = false;
                }
                if (success2) {
                    JOptionPane.showMessageDialog(null, "The refreshing is complete.");
                } else {
                    JOptionPane.showMessageDialog(null, "An exception occurred which prevented the data from being transferred. You may want to try refreshing the cache at a later date.");
                }
            } else {
                arg0.sendResponseHeaders(403, 0L);
            }
            arg0.close();
        }
        if (fileURI.equalsIgnoreCase("/changeadminpassword.cgi")) {
            this.debug("Processing change admin password request ...");
            found = true;
            if (CTATLink.adminLogin) {
                int statusCode;
                String newPassword = JOptionPane.showInputDialog(null, (Object)"Please enter a new administrator password.");
                if (newPassword != null) {
                    CTATLink.fManager.setContentsEncrypted(CTATLink.adminPasswordFilename, newPassword);
                    responseBody = "<html>Your password has been changed successfully.<br/><a href=\"/admin.html\">Return to administrator page</a><html>";
                    statusCode = 200;
                } else {
                    responseBody = "";
                    statusCode = 204;
                }
                this.sendHTMLResponse(arg0, responseBody, statusCode);
            } else {
                arg0.sendResponseHeaders(403, 0L);
            }
            arg0.close();
        }
        if (fileURI.equalsIgnoreCase("/exittutorshop.cgi")) {
            this.debug("Processing exit TutorShop request ...");
            found = true;
            responseBody = SO_LONG;
            this.sendHTMLResponse(arg0, responseBody, 200);
            arg0.close();
            System.exit(0);
        }
        if (!found && (success = this.handleViaRemoteServer(arg0, fileURI, false))) {
            this.debug("POST request has been satisfied via the remote server");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyPush(AlarmState newState) {
        PollAlarm pollAlarm = this.pushAlarm;
        synchronized (pollAlarm) {
            switch (newState) {
                case POLL: {
                    this.pushAlarm.state = AlarmState.POLL;
                    this.pushAlarm.notifyAll();
                    break;
                }
                case SNOOZE: {
                    this.pushAlarm.state = AlarmState.SNOOZE;
                    this.pushAlarm.alarm = new Thread(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            PollAlarm pollAlarm = CTATHTTPHandler.this.pushAlarm;
                            synchronized (pollAlarm) {
                                long ms = CTATLink.pushPollingInterval + 600000L;
                                long then = System.currentTimeMillis() + ms;
                                while (((CTATHTTPHandler)CTATHTTPHandler.this).pushAlarm.state == AlarmState.SNOOZE && 0L < (ms = then - System.currentTimeMillis())) {
                                    try {
                                        CTATHTTPHandler.this.pushAlarm.wait(ms);
                                    }
                                    catch (InterruptedException interruptedException) {}
                                }
                                if (((CTATHTTPHandler)CTATHTTPHandler.this).pushAlarm.state == AlarmState.SNOOZE) {
                                    CTATHTTPHandler.this.notifyPush(AlarmState.TIMEOUT);
                                }
                            }
                        }
                    };
                    this.pushAlarm.alarm.start();
                    break;
                }
                case TIMEOUT: {
                    if (trace.getDebugCode("kill")) {
                        trace.printStack("kill", "notifyPush(" + (Object)((Object)newState) + ") to exit");
                    }
                    System.exit(0);
                    break;
                }
                default: {
                    this.pushAlarm.state = AlarmState.INACTIVE;
                    this.pushAlarm.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueuePushResponse(PushResponse pr) {
        Queue<PushResponse> queue = this.pushQueue;
        synchronized (queue) {
            this.pushQueue.add(pr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handle(CTATHTTPExchange arg0, String requestBody) {
        this.debug("CTATHTTPHandler.handle (" + arg0 + ", " + requestBody + ")");
        String path = arg0.getRequestURI().getPath();
        CTATHTTPHandler cTATHTTPHandler = this;
        synchronized (cTATHTTPHandler) {
            String details;
            String[] split;
            if (path.startsWith("/run_assignment") && !path.endsWith("getpush.cgi")) {
                this.currentAssignment = path.substring(path.lastIndexOf(47) + 1);
            }
            if (path.startsWith("/run_student_assignment") && !path.endsWith("getpush.cgi") && (split = (details = path.substring("run_student_assignment".length())).split("/")).length == 3) {
                String studentAssignment = split[1];
                String problem = split[2];
                if (CTATLink.userID != null) {
                    if (this.currentAssignment == null) {
                        this.debug("received run_student_assignment request when currentAssignment was null; cannot update userProgressDatabase");
                    }
                    try {
                        this.userProgressDatabase.setCurrentProblem(CTATLink.userID, this.currentAssignment, studentAssignment, Integer.valueOf(problem), true);
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        this.debug("handle () cont ...");
        String requestMethod = arg0.getRequestMethod();
        this.debug("Request method: " + requestMethod + ", Request URI: " + arg0.getRequestURI());
        if (requestMethod.equalsIgnoreCase("post")) {
            this.debug("Processing POST ...");
            if (this.getLogging().booleanValue() || !CTATLink.allowWriting) {
                this.doPost(arg0);
            } else {
                this.debug("Requested post, but HTTPServer wasn't called with logfile");
                arg0.sendResponseHeaders(501, 0L);
                arg0.close();
            }
            return true;
        }
        String fileURI = arg0.getRequestURI().toString();
        this.debug("File uri = " + fileURI + ", with request method: " + requestMethod);
        boolean found = false;
        if (requestMethod.equalsIgnoreCase("get")) {
            this.debug("Processing GET request: " + arg0);
            if (fileURI.equalsIgnoreCase("/exittutorshop.cgi") || fileURI.equalsIgnoreCase("/exitclient.cgi")) {
                this.debug("Processing exit TutorShop request ...");
                found = true;
                if (trace.getDebugCode("kill")) {
                    trace.printStack("kill", "handle(" + arg0 + ") for /exittutorshop.cgi");
                }
                this.sendHTMLResponse(arg0, SO_LONG, 200);
                arg0.close();
                if (fileURI.contains("exittutorshop")) {
                    System.exit(0);
                } else {
                    return true;
                }
            }
            if (CTATLink.appState.compareTo("updating") == 0) {
                try {
                    arg0.addResponseHeader("Content-Type", "text/html");
                    arg0.sendResponseHeaders(200, updateProgressPage.getBytes().length);
                    arg0.writeBytesString(updateProgressPage, false);
                    this.debug("Wrote back update in progress message to brwoser");
                    arg0.close();
                    this.writeToAccessLog("<update in progress>");
                }
                catch (Exception e) {
                    this.debug("Exception in trying to write back root index file");
                }
                return true;
            }
            if (fileURI.equalsIgnoreCase("/crossdomain.xml")) {
                this.debug("Processing crossdomain request ...");
                found = true;
                this.debug("Writing back the crossdomain policy...");
                try {
                    arg0.addResponseHeader("Content-Type", "application/xml");
                    arg0.sendResponseHeaders(200, CTATLink.crossDomainPolicy.getBytes().length);
                    arg0.getOutputStream().write(CTATLink.crossDomainPolicy.getBytes());
                    this.debug("Wrote back Crossdomain.xml..");
                    arg0.close();
                }
                catch (Exception e) {
                    this.debug("Exception in trying to write back crossdomain.xml");
                }
            }
            if (fileURI.equalsIgnoreCase("/index.html") || fileURI.equalsIgnoreCase("/index.htm") || fileURI.equalsIgnoreCase("/")) {
                this.debug("Processing root request ...");
                boolean success = this.handleViaRemoteServer(arg0, "/", false);
                if (success) {
                    this.debug("GET request was satisfied via the remote server.");
                } else {
                    this.debug("Error when attempting to satisfy GET request via remote server.");
                    arg0.sendResponseHeaders(500, 0L);
                    arg0.close();
                }
            }
            if (!found) {
                this.sendLocalFile(fileURI, this.pathToRoot, arg0);
            }
        } else {
            boolean success = this.handleViaRemoteServer(arg0, fileURI, false);
            if (success) {
                this.debug(requestMethod + " request was satisfied via the remote server.");
            } else {
                this.debug("Error when attempting to satisfy " + requestMethod + " request via remote server.");
                arg0.sendResponseHeaders(500, 0L);
                arg0.close();
            }
        }
        return true;
    }

    @Override
    protected synchronized boolean handleViaRemoteServer(CTATHTTPExchange exchange, String fileURI, boolean addToCache) {
        String requestMethod;
        this.debug("handleViaRemoteServer ()");
        long contentLength = 0L;
        int bytesTransferred = 0;
        if (exchange.getRequestMethod().equalsIgnoreCase("GET")) {
            requestMethod = "GET";
        } else if (exchange.getRequestMethod().equalsIgnoreCase("HEAD")) {
            requestMethod = "HEAD";
            addToCache = false;
        } else if (exchange.getRequestMethod().equalsIgnoreCase("POST")) {
            requestMethod = "POST";
            addToCache = false;
        } else {
            return false;
        }
        String cookie = exchange.getRequestCookie("_cs2n_uid");
        if (cookie != null) {
            CTATLink.userID = cookie;
        }
        try {
            String lastModified;
            String responseHeaderKey;
            BufferedInputStream requestIn;
            HttpURLConnection.setFollowRedirects(false);
            URL url = this.determineRemoteURL(exchange, fileURI);
            HttpURLConnection remoteConn = (HttpURLConnection)url.openConnection();
            remoteConn.setRequestMethod(requestMethod);
            Map<String, List<String>> requestHeaders = exchange.getRequestHeaders();
            Set<String> requestHeaderKeys = requestHeaders.keySet();
            for (String key : requestHeaderKeys) {
                if (key.equalsIgnoreCase("Accept-Encoding")) continue;
                List<String> values = requestHeaders.get(key);
                for (String value : values) {
                    value = this.translateProxyRequest(value);
                    remoteConn.addRequestProperty(Utils.upperCaseInitials(key), value);
                }
            }
            this.addViaHeading(remoteConn);
            if (requestMethod.equals("POST")) {
                int b;
                remoteConn.setDoOutput(true);
                requestIn = new BufferedInputStream(exchange.getRequestBody());
                BufferedOutputStream requestOut = new BufferedOutputStream(remoteConn.getOutputStream());
                while ((b = requestIn.read()) != -1) {
                    requestOut.write(b);
                }
                requestIn.close();
                requestOut.close();
            } else {
                requestIn = new BufferedInputStream(exchange.getRequestBody());
                while (requestIn.read() != -1) {
                }
                requestIn.close();
            }
            int i = 1;
            while ((responseHeaderKey = remoteConn.getHeaderFieldKey(i)) != null) {
                String responseHeaderValue = remoteConn.getHeaderField(i);
                responseHeaderValue = this.translateProxyResponse(responseHeaderKey, responseHeaderValue);
                if (!responseHeaderKey.equalsIgnoreCase("Transfer-Encoding") || !responseHeaderValue.equalsIgnoreCase("chunked")) {
                    exchange.addResponseHeader(responseHeaderKey, responseHeaderValue);
                }
                if (responseHeaderKey.equalsIgnoreCase("Content-Length")) {
                    contentLength = Long.valueOf(responseHeaderValue);
                }
                if (responseHeaderKey.equalsIgnoreCase("Set-Cookie")) {
                    this.debug("via remote server: Set-Cookie: " + responseHeaderValue);
                }
                ++i;
            }
            int responseCode = remoteConn.getResponseCode();
            if (300 <= responseCode && responseCode < 400) {
                this.checkRedirectTo3rdParty(remoteConn, exchange);
            }
            if ((lastModified = remoteConn.getHeaderField("Last-Modified")) == null && (lastModified = remoteConn.getHeaderField("Date")) == null) {
                lastModified = CTATWebTools.headerDateFmt.format(new Date());
            }
            if (requestMethod.equals("HEAD")) {
                this.debug("Sending response headers ...");
                exchange.sendResponseHeaders(responseCode, -1L);
            } else {
                exchange.sendResponseHeaders(responseCode, contentLength);
                BufferedInputStream responseIn = new BufferedInputStream(remoteConn.getInputStream());
                BufferedOutputStream responseOut = exchange.getOutputStream();
                InputStream responseInResult = this.translateProxyHtml(responseIn);
                this.debug("Sending data to browser ...");
                if (addToCache && responseCode == 200) {
                    int b;
                    ByteArrayOutputStream cacheOut = new ByteArrayOutputStream();
                    while ((b = responseInResult.read()) != -1) {
                        responseOut.write(b);
                        cacheOut.write(b);
                        ++bytesTransferred;
                    }
                    this.cache.addToCache(fileURI, cacheOut.toByteArray(), lastModified, true);
                } else {
                    int b;
                    while ((b = responseInResult.read()) != -1) {
                        responseOut.write(b);
                        ++bytesTransferred;
                    }
                }
                ((InputStream)responseIn).close();
            }
            exchange.close();
        }
        catch (Exception e) {
            this.debug("Exception in proxy server: " + e);
            e.printStackTrace();
            this.debug("bytes transferred: " + bytesTransferred + "; contentLength: " + contentLength);
            totalBytesReceivedRemotely += (long)bytesTransferred;
            return false;
        }
        this.debug("totalBytesReceivedRemotely: " + (totalBytesReceivedRemotely += (long)bytesTransferred));
        return true;
    }

    private URL determineRemoteURL(CTATHTTPExchange exchange, String fileURI) throws MalformedURLException {
        String result = exchange.getRequestCookie(TUTORSHOP_FORWARD_TO);
        if (result == null) {
            result = "http://" + CTATLink.remoteHost + fileURI;
        }
        try {
            this.debug("determineRemoteURL() to return " + result);
            return new URL(result);
        }
        catch (MalformedURLException mue) {
            trace.err("Error creating remoteURL with address \"" + result + "\": " + mue + (mue.getCause() == null ? "" : "\ncause: " + mue.getCause()));
            throw mue;
        }
    }

    private void checkRedirectTo3rdParty(HttpURLConnection remoteConn, CTATHTTPExchange exchange) {
        this.debug("checkRedirectTo3rdParty ()");
        String location = remoteConn.getHeaderField("Location");
        URI uri = null;
        URI newURI = null;
        try {
            uri = new URI(location);
        }
        catch (Exception e) {
            trace.err("checkRedirectTo3rdParty: Location header \"" + location + "\" not a URI: " + e);
            return;
        }
        if (this.same2ndLevelDomain(uri.getHost(), CTATLink.remoteHost)) {
            exchange.setResponseCookie(TUTORSHOP_FORWARD_TO, null);
            return;
        }
        this.debug("checkRedirectTo3rdParty() setting cookie tutorshop_forward_to=" + location);
        exchange.setResponseCookie(TUTORSHOP_FORWARD_TO, location);
        try {
            newURI = new URI(uri.getScheme(), uri.getUserInfo(), CTATLink.hostName, CTATLink.wwwPort, uri.getPath(), uri.getQuery(), uri.getFragment());
            exchange.setResponseHeader("Location", newURI.toString());
            exchange.setResponseHeader("Pragma", "no-cache");
            exchange.setResponseHeader("Cache-Control", "no-cache");
        }
        catch (Exception e) {
            trace.err("checkRedirectTo3rdParty: error setting local Location to replace \"" + location + "\": " + e);
        }
    }

    private void addViaHeading(HttpURLConnection remoteConn) {
        remoteConn.addRequestProperty("Via", "1.1 localhost:8080 (ClientSideTutorShop)");
    }

    private String translateProxyRequest(String original) {
        this.debug("translateProxyRequest (" + original + ")");
        String result = original.replace(CTATLink.hostName + ":" + CTATLink.wwwPort, CTATLink.remoteHost + ":80");
        result = result.replace(CTATLink.hostName, CTATLink.remoteHost);
        return result;
    }

    private String translateProxyResponse(String key, String original) {
        this.debug("translateProxyRequest (" + key + "," + original + ")");
        String result = original.replaceAll("\\Q" + CTATLink.remoteHost + "\\E(:\\d*)?", CTATLink.hostName + ":" + CTATLink.wwwPort);
        return result;
    }

    private boolean same2ndLevelDomain(String h1, String h2) {
        int j;
        if (h1 == null || h2 == null) {
            return false;
        }
        String[] a1 = h1.split("\\.");
        String[] a2 = h2.split("\\.");
        int i = a1.length - 1;
        if (i < 1 || j < 1) {
            return false;
        }
        for (j = a2.length - 1; i > a1.length - 3 && j > a2.length - 3; --i, --j) {
            if (a1[i].equalsIgnoreCase(a2[j])) continue;
            return false;
        }
        return true;
    }

    private InputStream translateProxyHtml(InputStream original) {
        byte[] bytes;
        String str;
        this.debug("translateProxyHtml");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BufferedInputStream bis = new BufferedInputStream(original);
        try {
            int b;
            while ((b = bis.read()) != -1) {
                baos.write(b);
            }
            str = new String(baos.toByteArray(), "ISO-8859-1");
        }
        catch (Exception e) {
            this.debug(e.toString());
            e.printStackTrace();
            return null;
        }
        str = str.replaceAll("http://\\Q" + CTATLink.remoteHost + "\\E(:80)?/", "http://" + CTATLink.hostName + ":" + CTATLink.wwwPort + "/");
        if (CTATLink.useLocalTutoringService) {
            str = this.remoteSocketURL.matcher(str).replaceAll("remoteSocketURL=" + CTATLink.hostName);
            str = this.remoteSocketPort.matcher(str).replaceAll("remoteSocketPort=" + CTATLink.tsPort);
            str = this.translateQuestionFile(str);
        }
        try {
            bytes = str.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
        return new ByteArrayInputStream(bytes);
    }

    private synchronized String translateQuestionFile(String originalHtml) {
        this.debug("translateQuestionFile");
        String str = originalHtml;
        int questionFileIndex = originalHtml.indexOf("question_file");
        if (questionFileIndex < 0) {
            return str;
        }
        int st = str.indexOf("=", questionFileIndex) + 1;
        int end = str.indexOf("&", questionFileIndex);
        if (st < questionFileIndex || st > questionFileIndex + "question_file".length() + 2) {
            st = str.indexOf(">", questionFileIndex) + 1;
            end = str.indexOf("<", questionFileIndex);
        }
        this.debug("questionFileIndex, st, end " + questionFileIndex + "," + st + "," + end + "; originalHtml\n  " + originalHtml);
        String question_file = originalHtml.substring(st, end);
        question_file = question_file.trim();
        File localQuestionFile = null;
        this.debug("***question_file " + question_file + ", pattern \"" + this.htdocs_remoteBRDs.pattern() + "\"");
        Matcher m = this.htdocs_remoteBRDs.matcher(question_file);
        localQuestionFile = m.find() ? new File(question_file) : new File(new File(CTATLink.htdocs, "remoteBRDs"), question_file);
        this.debug("localQuestionFile " + localQuestionFile);
        if (!localQuestionFile.exists()) {
            URL brdURL;
            this.debug("Making new local BRD file: " + question_file);
            if (!CTATLink.allowWriting) {
                JOptionPane.showMessageDialog(null, "The local tutoring service requires a local BRD that does not exist and cannot be written because writing to disk is disabled.\nThis problem may be solved by configuring the program to use a remote tutoring service or to allow writing to disk.");
                return str;
            }
            localQuestionFile.getParentFile().mkdirs();
            try {
                localQuestionFile.createNewFile();
            }
            catch (IOException e) {
                this.debug(e.toString());
                return str;
            }
            try {
                brdURL = new URL("http://" + CTATLink.remoteHost + "/" + question_file);
            }
            catch (MalformedURLException e) {
                this.debug(e.toString());
                return str;
            }
            try {
                int b;
                BufferedInputStream brdIn = new BufferedInputStream(brdURL.openStream());
                BufferedOutputStream brdOut = new BufferedOutputStream(new FileOutputStream(localQuestionFile));
                while ((b = ((InputStream)brdIn).read()) != -1) {
                    ((OutputStream)brdOut).write(b);
                }
                ((InputStream)brdIn).close();
                ((OutputStream)brdOut).close();
            }
            catch (IOException e) {
                this.debug(e.toString());
                return str;
            }
            this.debug("Local BRD " + localQuestionFile + " successfully created.");
        }
        str = str.replace(question_file, localQuestionFile.getPath().replace('\\', '/'));
        return str;
    }

    public static enum PushResponse {
        Nothing,
        Exit,
        ClientExit;

    }

    private class PollAlarm {
        volatile AlarmState state = AlarmState.INACTIVE;
        Thread alarm = null;

        private PollAlarm() {
        }
    }

    public static enum AlarmState {
        INACTIVE,
        SNOOZE,
        POLL,
        TIMEOUT,
        INTERRUPT,
        CANCEL;

    }
}

