/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.ctat;

import edu.cmu.hcii.ctat.CTATBase;
import edu.cmu.hcii.ctat.CTATDiagnostics;
import edu.cmu.hcii.ctat.CTATLink;
import edu.cmu.hcii.ctat.CTATVisualProgressTask;
import edu.cmu.hcii.ctat.CTATWebTools;
import edu.cmu.hcii.ctat.LocalTSSystemTray;
import edu.cmu.pact.Utilities.trace;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;

public class CTATContentCache
extends CTATBase {
    private static final Pattern RailsTimeStampPattern = Pattern.compile("\\?[0-9]+$");
    private static final Pattern UIDSuffixPattern = Pattern.compile("\\-[0-9a-fA-F]{30,}");
    private final File cacheDirectory;
    private final long maxBytesOnDisk;
    private volatile long bytesOnDisk;
    private final long maxBytesInMemory;
    private volatile long bytesInMemory;
    private Object lock = new Object();
    private CacheDiskReader initializer = null;
    private CacheDiskWriter diskWriter = null;
    private HashMap<String, CacheRecord> records;
    private LinkedList<CacheRecord> mruInMemoryQ = null;
    private FrequencyTable freqtable;
    private int maxCachedContents = CTATLink.maxCachedFiles;
    private UI ui = null;
    private static final Pattern uriPattern = Pattern.compile("^([a-z][-a-z0-9+.]+):(//.+)");

    public CTATContentCache() {
        this(null, false);
        this.setClassName("CTATContentCache");
        this.debug("CTATContentCache ()");
    }

    public CTATContentCache(File cacheDirectory, boolean write) {
        long maxBytesTemp;
        this.setClassName("CTATContentCache");
        this.debug("CTATContentCache ()");
        this.debug("CTATContentCache( dir=" + cacheDirectory + ", write=" + write + "");
        this.cacheDirectory = cacheDirectory;
        if (cacheDirectory != null && !cacheDirectory.exists()) {
            cacheDirectory.mkdirs();
        }
        try {
            maxBytesTemp = CTATDiagnostics.writableBytes(cacheDirectory);
        }
        catch (NoSuchMethodError e) {
            try {
                maxBytesTemp = cacheDirectory.getUsableSpace();
            }
            catch (NoSuchMethodError e2) {
                maxBytesTemp = Integer.MAX_VALUE;
            }
        }
        this.maxBytesOnDisk = maxBytesTemp;
        try {
            maxBytesTemp = CTATDiagnostics.inMemoryCacheSize();
        }
        catch (NoSuchMethodError e) {
            maxBytesTemp = Runtime.getRuntime().freeMemory();
        }
        this.maxBytesInMemory = maxBytesTemp;
        this.bytesOnDisk = 0L;
        this.bytesInMemory = 0L;
        this.records = new HashMap();
        this.mruInMemoryQ = new LinkedList();
        this.maxCachedContents = CTATLink.maxCachedFiles;
        if (cacheDirectory != null && cacheDirectory.isDirectory()) {
            this.initializer = new CacheDiskReader();
            this.initializer.initializeCache();
            File freqfile = new File(cacheDirectory, "frequencies.txt");
            if (freqfile.exists()) {
                try {
                    this.freqtable = new FrequencyTable(freqfile);
                }
                catch (IOException e) {
                    this.debug(e.toString());
                    this.freqtable = new FrequencyTable();
                }
            } else {
                this.freqtable = new FrequencyTable();
            }
            if (write) {
                this.diskWriter = new CacheDiskWriter();
                this.diskWriter.setDaemon(true);
                this.diskWriter.start();
                Runtime.getRuntime().addShutdownHook(new FrequenciesWriter());
            }
        } else {
            this.freqtable = new FrequencyTable();
        }
    }

    public void setConsole(Object console) {
        this.debug("setConsole ()");
        if (console == null) {
            this.debug("Error: console is null!");
            return;
        }
        if (this.ui != null) {
            this.debug("Creating new UI object ...");
            this.ui = new UI();
        }
        if (this.ui != null) {
            this.ui.setConsole(console);
        }
    }

    public void setProgressBar(Object aBar) {
        if (this.ui != null) {
            this.ui = new UI();
        }
        if (this.ui != null) {
            this.ui.setProgressBar(aBar);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToCache(String fileURI, byte[] contents, String lastModifiedStr, boolean stripOutUID) {
        int numRecords;
        this.debug("addToCache ()");
        if (fileURI == null || contents == null) {
            return;
        }
        String theFileURI = fileURI;
        if (this.ui != null) {
            this.ui.appendToConsole("Adding to cache: " + theFileURI + "\n");
        }
        if ((fileURI = this.alterForQueryString(fileURI)) == null) {
            return;
        }
        if (stripOutUID) {
            fileURI = CTATContentCache.stripOutUID(fileURI);
        }
        HashMap<String, CacheRecord> hashMap = this.records;
        synchronized (hashMap) {
            numRecords = this.records.size();
        }
        if (numRecords >= this.maxCachedContents) {
            this.removeLFU();
        }
        for (int count = 0; this.bytesInMemory + (long)contents.length > this.maxBytesInMemory && count < 10; ++count) {
            this.freeSomeMemory();
        }
        CacheRecord newRecord = new CacheRecord(fileURI, contents, lastModifiedStr);
        Object object = this.records;
        synchronized (object) {
            this.records.put(newRecord.fileURI, newRecord);
        }
        if (this.diskWriter != null) {
            object = this.diskWriter.recordsToWrite;
            synchronized (object) {
                this.diskWriter.recordsToWrite.add(newRecord);
            }
        }
        object = this.lock;
        synchronized (object) {
            this.bytesInMemory += (long)contents.length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void freeSomeMemory() {
        Set<Map.Entry<String, CacheRecord>> entrySet;
        int bytesFreed = 0;
        HashMap<String, CacheRecord> hashMap = this.records;
        synchronized (hashMap) {
            entrySet = this.records.entrySet();
        }
        for (Map.Entry linkedList : entrySet) {
            CacheRecord cr;
            CacheRecord cacheRecord = cr = (CacheRecord)linkedList.getValue();
            synchronized (cacheRecord) {
                if (cr.contents != null && (cr.isOnDisk || this.diskWriter == null)) {
                    bytesFreed += cr.contents.length;
                    cr.contents = null;
                    break;
                }
            }
        }
        if (bytesFreed == 0 && this.diskWriter != null) {
            boolean shouldInterrupt = false;
            LinkedList linkedList = this.diskWriter.recordsToWrite;
            synchronized (linkedList) {
                shouldInterrupt = !this.diskWriter.recordsToWrite.isEmpty();
            }
            if (shouldInterrupt) {
                this.diskWriter.interrupt();
            }
        }
        Object object = this.lock;
        synchronized (object) {
            this.bytesInMemory -= (long)bytesFreed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status isFileUpToDate(String fileURI, String lastModifiedStr, boolean stripOutUID) {
        this.debug("isFileUpToDate (" + fileURI + "," + lastModifiedStr + ")");
        if (stripOutUID) {
            fileURI = CTATContentCache.stripOutUID(fileURI);
        }
        if ((fileURI = this.alterForQueryString(fileURI)) == null) {
            return Status.CACHE_INVALID;
        }
        CacheRecord cr = null;
        HashMap<String, CacheRecord> hashMap = this.records;
        synchronized (hashMap) {
            cr = this.records.get(fileURI);
        }
        this.debug("isFileUpToDate(" + fileURI + "," + lastModifiedStr + "): " + CTATContentCache.record2String(cr));
        if (cr == null || cr.lastModified == null) {
            return Status.CACHE_INVALID;
        }
        Date lastModified = null;
        try {
            lastModified = CTATWebTools.headerDateFmt.parse(lastModifiedStr);
        }
        catch (Exception e) {
            if (lastModifiedStr != null) {
                trace.err("Error parsing last-modified date \"" + lastModifiedStr + "\": " + e);
            }
            return Status.READ_FROM_CACHE;
        }
        if (lastModified.getTime() < cr.lastModified.getTime()) {
            return Status.READ_FROM_CACHE;
        }
        return Status.NOT_MODIFIED;
    }

    public byte[] getBytesFromCache(String fileURI, boolean stripOutUID) {
        return this.getBytesFromCache(fileURI, null, stripOutUID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytesFromCache(String fileURI, String[] lastModified, boolean stripOutUID) {
        if (lastModified != null) {
            lastModified[0] = null;
        }
        if (stripOutUID) {
            fileURI = CTATContentCache.stripOutUID(fileURI);
        }
        if ((fileURI = this.alterForQueryString(fileURI)) == null) {
            return null;
        }
        if (this.initializer != null) {
            try {
                this.initializer.join();
                this.initializer = null;
            }
            catch (InterruptedException e) {
                return null;
            }
        }
        CacheRecord current = null;
        byte[] contents = null;
        long bytesRead = 0L;
        Object object = this.records;
        synchronized (object) {
            current = this.records.get(fileURI);
            if (current != null) {
                CacheRecord cacheRecord = current;
                synchronized (cacheRecord) {
                    this.setAsMRU(current);
                    this.freqtable.increaseFrequency(current.fileURI);
                    if (current.contents != null) {
                        contents = current.contents;
                    } else if (this.cacheDirectory != null && current.contentsFilename != null) {
                        try {
                            ObjectInputStream contentsIn = new ObjectInputStream(new FileInputStream(new File(this.cacheDirectory, current.contentsFilename)));
                            current.contents = (byte[])contentsIn.readObject();
                            bytesRead += (long)current.contents.length;
                            contentsIn.close();
                        }
                        catch (Exception e) {
                            return null;
                        }
                        contents = current.contents;
                    } else {
                        if (this.cacheDirectory != null) {
                            trace.err("getBytesFromCache(" + fileURI + "): CacheRecord found but contents[] and contentsFilename null");
                        }
                        return null;
                    }
                }
            }
        }
        this.debug("getBytesFromCache(" + fileURI + ") rtns " + (contents == null ? -1 : contents.length) + " bytes, " + bytesRead + " read from disk");
        if (lastModified != null) {
            lastModified[0] = CTATWebTools.headerDateFmt.format(current.lastModified);
        }
        object = this.lock;
        synchronized (object) {
            this.bytesInMemory += bytesRead;
        }
        for (int count = 0; this.bytesInMemory > this.maxBytesInMemory && count < 10; ++count) {
            this.freeSomeMemory();
        }
        return contents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<CacheEntryInfo> getInfoOnEntries() {
        if (this.initializer != null) {
            try {
                this.initializer.join();
            }
            catch (InterruptedException e) {
                return null;
            }
            this.initializer = null;
        }
        HashSet<CacheEntryInfo> set = new HashSet<CacheEntryInfo>();
        HashMap<String, CacheRecord> hashMap = this.records;
        synchronized (hashMap) {
            Set<Map.Entry<String, CacheRecord>> recordsSet = this.records.entrySet();
            for (Map.Entry<String, CacheRecord> entry : recordsSet) {
                CacheRecord record;
                CacheRecord cacheRecord = record = entry.getValue();
                synchronized (cacheRecord) {
                    int size;
                    String fileURI = record.fileURI;
                    int accessFrequency = this.freqtable.getFrequencyOf(fileURI);
                    if (record.contents != null) {
                        size = record.contents.length;
                    } else if (record.contentsFilename != null) {
                        try {
                            ObjectInputStream contentsIn = new ObjectInputStream(new FileInputStream(new File(this.cacheDirectory, record.contentsFilename)));
                            byte[] bytes = (byte[])contentsIn.readObject();
                            size = bytes.length;
                            contentsIn.close();
                        }
                        catch (Exception e) {
                            size = 0;
                        }
                    } else {
                        size = 0;
                    }
                    set.add(new CacheEntryInfo(fileURI, accessFrequency, size));
                }
            }
        }
        return set;
    }

    private String alterForQueryString(String fileURI) {
        if (!fileURI.contains("?")) {
            return fileURI;
        }
        Matcher m = RailsTimeStampPattern.matcher(fileURI);
        if (!m.find()) {
            return null;
        }
        String result = fileURI.substring(0, m.start());
        this.debug("Stripped query string \"" + fileURI.substring(m.start()) + "\" from " + result);
        return result;
    }

    public static String stripOutUID(String fileURI) {
        String altered = fileURI;
        if (altered != null) {
            Matcher m = UIDSuffixPattern.matcher(fileURI);
            altered = m.replaceAll("");
        }
        return altered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAsMRU(CacheRecord current) {
        long bytesFreed = 0L;
        Object object = this.mruInMemoryQ;
        synchronized (object) {
            if (!this.mruInMemoryQ.remove(current) && this.maxCachedContents <= this.mruInMemoryQ.size()) {
                CacheRecord bounced = this.mruInMemoryQ.removeLast();
                if (bounced.contents != null) {
                    CacheRecord cacheRecord = bounced;
                    synchronized (cacheRecord) {
                        bytesFreed += (long)bounced.contents.length;
                        bounced.contents = null;
                    }
                }
            }
            this.mruInMemoryQ.addFirst(current);
        }
        object = this.lock;
        synchronized (object) {
            this.bytesInMemory -= bytesFreed;
        }
        this.debug("setAsMRU(" + current.fileURI + "): mruInMemoryQ.size " + this.mruInMemoryQ.size() + ", bytesFreed " + bytesFreed);
    }

    public String getStringFromCache(String fileURI, boolean stripOutUID) {
        byte[] bytes = this.getBytesFromCache(fileURI, stripOutUID);
        if (bytes == null) {
            return null;
        }
        try {
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean refreshCache(String serverName) {
        System.err.println("refreshCache(" + serverName + ")");
        if (this.cacheDirectory == null || !this.cacheDirectory.isDirectory()) {
            return false;
        }
        if (this.initializer != null) {
            try {
                this.initializer.join();
                this.initializer = null;
            }
            catch (InterruptedException e) {
                return false;
            }
        }
        boolean success = true;
        HttpURLConnection.setFollowRedirects(false);
        HashMap<String, CacheRecord> hashMap = this.records;
        synchronized (hashMap) {
            if (this.records.size() == 0) {
                return true;
            }
        }
        if (UI.isEventDispatchThread()) {
            if (this.ui == null) {
                this.ui = new UI();
            }
            this.ui.updateInBackgroud(this, serverName);
        } else {
            hashMap = this.records;
            synchronized (hashMap) {
                int i = 0;
                for (CacheRecord record : this.records.values()) {
                    success = this.refreshSingleRecord(serverName, record) && success;
                    int newval = ++i * 100 / this.records.size();
                    UI.setVisualProgressOrProgressBar(newval);
                }
            }
        }
        success = this.refreshRemoteBRDs("http://" + serverName, new File(CTATLink.htdocs, "remoteBRDs"), false) && success;
        return success;
    }

    public boolean refreshCertainFiles(String serverName, String[] fileURIs, boolean deleteOtherFiles, boolean stripOutUIDs) {
        return this.refreshCertainFiles(serverName, fileURIs, deleteOtherFiles, stripOutUIDs, 0, fileURIs.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean refreshCertainFiles(String serverName, String[] fileURIs, boolean deleteOtherFiles, boolean stripOutUIDs, int startProgressBarAt, int totalProgressBarTasks) {
        this.debug("refreshCertainFiles (" + fileURIs.length + ")");
        if (serverName == null) {
            this.debug("in refreshCertainFiles, serverName is null");
            return false;
        }
        if (startProgressBarAt < 0) {
            startProgressBarAt = 0;
        }
        if (totalProgressBarTasks < startProgressBarAt + fileURIs.length) {
            totalProgressBarTasks = startProgressBarAt + fileURIs.length;
        }
        boolean success = true;
        HashSet<String> fileURIsHash = new HashSet<String>();
        for (String string : fileURIs) {
            fileURIsHash.add(string);
        }
        UI.setVisualProgress(0);
        this.debug("Fetching files ...");
        int i = 0;
        if (this.ui != null) {
            this.ui.initializeProgressBar(0, totalProgressBarTasks, startProgressBarAt);
        }
        for (String fileURI : fileURIsHash) {
            CacheRecord cacheRecord;
            fileURI = this.alterForQueryString(fileURI);
            HashMap<String, CacheRecord> hashMap = this.records;
            synchronized (hashMap) {
                cacheRecord = this.records.get(fileURI);
            }
            if (cacheRecord == null) {
                HttpURLConnection conn;
                URL url;
                this.debug("Obtaining: http://" + serverName + "/" + fileURI);
                try {
                    url = new URI("http", serverName, fileURI, null).toURL();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    success = false;
                    return false;
                }
                try {
                    conn = (HttpURLConnection)url.openConnection();
                    HttpURLConnection.setFollowRedirects(false);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    success = false;
                    return false;
                }
                String lastModified = conn.getHeaderField("Last-Modified");
                if (lastModified == null && (lastModified = conn.getHeaderField("Date")) == null) {
                    lastModified = CTATWebTools.headerDateFmt.format(new Date());
                }
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try {
                    int b;
                    BufferedInputStream bis = new BufferedInputStream(conn.getInputStream());
                    while ((b = bis.read()) != -1) {
                        baos.write(b);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    success = false;
                    return false;
                }
                byte[] bytes = baos.toByteArray();
                this.addToCache(fileURI, bytes, lastModified, stripOutUIDs);
            } else {
                success = this.refreshSingleRecord(serverName, cacheRecord) && success;
            }
            UI.setVisualProgress(i * 100 / fileURIsHash.size());
            ++i;
            if (this.ui == null) continue;
            this.ui.updateProgressBar(startProgressBarAt + i, totalProgressBarTasks);
        }
        if (deleteOtherFiles) {
            ArrayList<CacheRecord> recordsToDelete = new ArrayList<CacheRecord>();
            HashMap<String, CacheRecord> hashMap = this.records;
            synchronized (hashMap) {
                for (CacheRecord cr : this.records.values()) {
                    if (fileURIsHash.contains(cr.fileURI)) continue;
                    recordsToDelete.add(cr);
                }
            }
            for (CacheRecord cacheRecord : recordsToDelete) {
                this.removeFromCache(cacheRecord);
            }
        }
        return success;
    }

    public boolean refreshRemoteBRDs(String remoteURL, File fileToRefresh, boolean forceRefresh) {
        this.debug("refreshRemoteBRDs (" + remoteURL + "," + fileToRefresh + "," + forceRefresh + ")");
        if (!fileToRefresh.exists()) {
            return true;
        }
        if (fileToRefresh.isDirectory()) {
            File[] subfiles = fileToRefresh.listFiles();
            boolean success = true;
            for (File subfile : subfiles) {
                success = this.refreshRemoteBRDs(remoteURL + "/" + subfile.getName(), subfile, forceRefresh) && success;
            }
            return success;
        }
        if (fileToRefresh.toString().endsWith(".brd")) {
            URL url = null;
            HttpURLConnection conn = null;
            try {
                url = this.makeURL(remoteURL);
                conn = (HttpURLConnection)url.openConnection();
            }
            catch (MalformedURLException e) {
                this.debug("MalformedURLException downloading BRD \"" + url + "\": " + e);
                e.printStackTrace();
                return false;
            }
            catch (IOException e) {
                this.debug("IOException downloading BRD \"" + url + "\"");
                e.printStackTrace();
                return false;
            }
            String lastModified = CTATWebTools.headerDateFmt.format(new Date(fileToRefresh.lastModified()));
            if (!forceRefresh) {
                conn.setRequestProperty("If-Modified-Since", lastModified);
            }
            int responseCode = 0;
            try {
                responseCode = conn.getResponseCode();
            }
            catch (IOException e) {
                this.debug("IOException obtaining response code from connection for \"" + url + "\"");
                e.printStackTrace();
                return false;
            }
            if (responseCode != 200) {
                if (responseCode == 304) {
                    this.debug(url + " has not been modified since " + lastModified);
                    return true;
                }
                this.debug(url + " returned response code " + responseCode);
                return false;
            }
            BufferedInputStream brdIn = null;
            try {
                brdIn = new BufferedInputStream(conn.getInputStream());
            }
            catch (IOException e) {
                this.debug("IOException obtaining input stream from connection for \"" + url + "\"");
                e.printStackTrace();
                return false;
            }
            BufferedOutputStream brdOut = null;
            try {
                brdOut = new BufferedOutputStream(new FileOutputStream(fileToRefresh));
            }
            catch (FileNotFoundException e) {
                this.debug("FileNotFoundException attempting to create output stream for BRD on disk for \"" + url + "\"");
                e.printStackTrace();
                return false;
            }
            try {
                int b;
                while ((b = ((InputStream)brdIn).read()) != -1) {
                    ((OutputStream)brdOut).write(b);
                }
            }
            catch (IOException e) {
                this.debug("IOException writing bytes to disk \"" + url + "\"");
                e.printStackTrace();
                return false;
            }
            try {
                ((InputStream)brdIn).close();
                ((OutputStream)brdOut).close();
            }
            catch (IOException e) {
                this.debug("IOException closing input or output stream for BRD \"" + url + "\"");
                e.printStackTrace();
                return false;
            }
        }
        this.debug(remoteURL + " successfully refreshed.");
        return true;
    }

    URL makeURL(String url) throws MalformedURLException {
        if (url == null) {
            throw new MalformedURLException("null host");
        }
        Matcher m = uriPattern.matcher(url);
        if (!m.find()) {
            throw new MalformedURLException("missing scheme or authority");
        }
        String scheme = m.group(1);
        String ssp = m.group(2);
        try {
            this.debug("makeURL() new URI(" + scheme + "," + ssp + ",null)");
            URI uri = new URI(scheme, ssp, null);
            return uri.toURL();
        }
        catch (URISyntaxException e) {
            throw new MalformedURLException("Error " + e + " on new URI(" + scheme + "," + ssp + ",null)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean refreshSingleRecord(String serverName, CacheRecord record) {
        this.debug("refreshSingleRecord ()");
        if (serverName == null || record == null) {
            return false;
        }
        int memorySizeChange = 0;
        int diskSizeChange = 0;
        Object object = record;
        synchronized (object) {
            BufferedInputStream contentIn;
            int responseCode;
            HttpURLConnection conn;
            URL url;
            try {
                url = new URL("http", serverName, record.fileURI);
            }
            catch (MalformedURLException e) {
                return false;
            }
            try {
                conn = (HttpURLConnection)url.openConnection();
                conn.setReadTimeout(5000);
            }
            catch (IOException e) {
                return false;
            }
            if (record.lastModified != null) {
                conn.setRequestProperty("If-Modified-Since", CTATWebTools.headerDateFmt.format(record.lastModified));
            }
            try {
                responseCode = conn.getResponseCode();
            }
            catch (IOException e) {
                responseCode = 0;
            }
            if (responseCode != 200) {
                if (responseCode == 304) {
                    this.debug(record.fileURI + " has not been modified since " + record.lastModified);
                    return true;
                }
                this.debug(record.fileURI + " returned response code " + responseCode);
                return false;
            }
            String newLastModified = conn.getHeaderField("Last-Modified");
            if (newLastModified == null && (newLastModified = conn.getHeaderField("Date")) == null) {
                newLastModified = CTATWebTools.headerDateFmt.format(new Date());
            }
            try {
                contentIn = new BufferedInputStream(conn.getInputStream());
            }
            catch (IOException e) {
                return false;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                int b;
                while ((b = ((InputStream)contentIn).read()) != -1) {
                    baos.write(b);
                }
            }
            catch (IOException e) {
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    ((InputStream)contentIn).close();
                }
                catch (IOException iOException) {}
            }
            byte[] newContents = baos.toByteArray();
            if (record.contents != null) {
                memorySizeChange -= record.contents.length;
            }
            record.contents = newContents;
            try {
                record.lastModified = CTATWebTools.headerDateFmt.parse(newLastModified);
            }
            catch (ParseException e) {
                this.debug("Could not parse date " + newLastModified);
                this.debug(e.toString());
                record.lastModified = null;
            }
            if (record.contentsFilename != null) {
                ObjectOutputStream contentsOut = null;
                try {
                    File f = new File(this.cacheDirectory, record.contentsFilename);
                    long bytesOverwritten = f.length();
                    contentsOut = new ObjectOutputStream(new FileOutputStream(f));
                    contentsOut.writeObject(record.contents);
                    record.contents = null;
                    record.isOnDisk = true;
                    diskSizeChange = (int)((long)diskSizeChange + (f.length() - bytesOverwritten));
                }
                catch (IOException e) {
                    boolean bl = false;
                    return bl;
                }
                finally {
                    if (contentsOut != null) {
                        try {
                            contentsOut.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
        object = this.lock;
        synchronized (object) {
            this.bytesInMemory += (long)memorySizeChange;
            this.bytesOnDisk += (long)diskSizeChange;
        }
        this.debug(record.fileURI + " successfully refreshed.");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromCache(CacheRecord cr) {
        this.debug("removeFromCache (" + cr + ")");
        Cloneable cloneable = this.records;
        synchronized (cloneable) {
            this.records.remove(cr.fileURI);
            this.freqtable.remove(cr.fileURI);
            if (cr.contents != null) {
                this.bytesInMemory -= (long)cr.contents.length;
            }
        }
        if (this.diskWriter != null) {
            cloneable = this.diskWriter.recordsToWrite;
            synchronized (cloneable) {
                this.diskWriter.recordsToWrite.remove(cr);
            }
        }
        if (cr.isOnDisk) {
            this.deleteFromDisk(cr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteFromDisk(CacheRecord cr) {
        if (this.cacheDirectory != null) {
            long bytesDeleted = 0L;
            Object object = cr;
            synchronized (object) {
                if (cr.recordFilename != null) {
                    File recordFile = new File(this.cacheDirectory, cr.recordFilename);
                    bytesDeleted += recordFile.length();
                    recordFile.delete();
                }
                if (cr.contentsFilename != null) {
                    File contentsFile = new File(this.cacheDirectory, cr.contentsFilename);
                    bytesDeleted += contentsFile.length();
                    contentsFile.delete();
                }
            }
            object = this.lock;
            synchronized (object) {
                this.bytesOnDisk -= bytesDeleted;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeLFU() {
        CacheRecord cr;
        this.debug("removeLFU ()");
        String LFU = this.freqtable.getLeastFrequent();
        if (LFU == null) {
            return;
        }
        HashMap<String, CacheRecord> hashMap = this.records;
        synchronized (hashMap) {
            cr = this.records.get(LFU);
        }
        if (cr == null) {
            return;
        }
        this.removeFromCache(cr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForWrite() {
        this.debug("waitForWrite ()");
        if (this.diskWriter != null) {
            boolean empty;
            LinkedList linkedList = this.diskWriter.recordsToWrite;
            synchronized (linkedList) {
                empty = this.diskWriter.recordsToWrite.isEmpty();
            }
            while (!empty) {
                try {
                    this.diskWriter.lock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                linkedList = this.diskWriter.recordsToWrite;
                synchronized (linkedList) {
                    empty = this.diskWriter.recordsToWrite.isEmpty();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void immediateWrite() {
        this.debug("immediateWrite ()");
        if (this.diskWriter != null) {
            this.debug("We have a disk writer");
            if (this.diskWriter.recordsToWrite.isEmpty()) {
                this.debug("Nothing to write, exiting ...");
                return;
            }
            this.debug("Do interrupt ()");
            this.diskWriter.interrupt();
            Object object = this.diskWriter.lock;
            synchronized (object) {
                try {
                    this.debug("Waiting for write to be completed ...");
                    this.diskWriter.lock.wait();
                    this.debug("Disk writer should be finished now");
                }
                catch (InterruptedException e) {
                    this.debug("Caught InterruptedException, ignoring ...");
                    return;
                }
            }
        }
    }

    private void freeSomeDiskSpace() {
        this.removeLFU();
    }

    private static void usageExit(String errMsg) {
        if (errMsg != null) {
            System.out.printf("\n%s. ", errMsg);
        }
        System.out.println("Usage:\n  " + CTATContentCache.class.getSimpleName() + " [-d dir] -cmd file...\nwhere--\n  dir     is the cache directory; default is htdocs/cache;\n  cmd is one of--\n  " + (Object)((Object)Command.showall) + "     means list all files in the cache directory;\n  " + (Object)((Object)Command.list) + "        means list the named files in the cache;\n  " + (Object)((Object)Command.remove) + "      means remove the named files from the cache;\n  " + (Object)((Object)Command.output) + "      means output the named files in the cache to stdout;\n  " + (Object)((Object)Command.update) + "      means update (replace) the named files in the cache;\n  file... are individual file(s) to list, output or replace (ignored with -a).\n  N.B.: always use the URI for files: if there is a leading slash, show it.\n");
        System.exit(2);
    }

    public static String record2String(CacheRecord record) {
        if (record == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(91);
        sb.append(record.fileURI).append(',');
        sb.append(record.contents == null ? -1 : record.contents.length).append(',');
        sb.append(record.recordFilename).append(',');
        sb.append(record.contentsFilename).append(',');
        sb.append(record.lastModified == null ? null : CTATWebTools.headerDateFmt.format(record.lastModified)).append(']');
        return sb.toString();
    }

    /*
     * Unable to fully structure code
     */
    public static void main(String[] args) {
        cacheDirectory = "htdocs" + File.separator + "cache";
        cmd = Command.showall;
        block15: for (i = 0; i < args.length && args[i].charAt(0) == '-'; ++i) {
            if (args[i].length() < 2) {
                CTATContentCache.usageExit("Invalid switch argument \"" + args[i] + "\"");
            }
            switch (args[i].charAt(1)) {
                case 'D': 
                case 'd': {
                    if (++i >= args.length) {
                        CTATContentCache.usageExit("No directory specified with \"-d\"");
                    }
                    cacheDirectory = args[i];
                    continue block15;
                }
                case 'H': 
                case 'h': {
                    cmd = Command.help;
                    CTATContentCache.usageExit("Help message");
                    continue block15;
                }
                default: {
                    cmd = Command.valueOf(args[i].substring(1).toLowerCase());
                    if (cmd != null) continue block15;
                    CTATContentCache.usageExit("Unknown switch argument \"" + args[i] + "\"");
                }
            }
        }
        if (i >= args.length && cmd != Command.showall) {
            CTATContentCache.usageExit("No files to check");
        }
        CTATContentCache.outStream = null;
        ccc = new CTATContentCache(new File(cacheDirectory), cmd == Command.update || cmd == Command.remove);
        while (true) {
            try {
                ccc.initializer.join();
            }
            catch (InterruptedException ie) {
                System.err.println("Exception awaiting initializer: " + ie + (ie.getCause() == null ? "" : ";\n  cause " + ie.getCause()));
                continue;
            }
            break;
        }
        if (cmd == Command.showall) {
            for (String name : ccc.records.keySet()) {
                record = ccc.records.get(name);
                System.out.println(CTATContentCache.record2String(record));
            }
            return;
        }
        while (i < args.length) {
            alteredName = null;
            record = null;
            if (cmd == Command.update) ** GOTO lbl-1000
            alteredName = ccc.alterForQueryString(args[i]);
            v0 = record = alteredName == null ? null : ccc.records.get(alteredName);
            if (record == null) {
                System.err.printf("%s: skipping missing record for %s\n", new Object[]{cmd.toString(), args[i]});
            } else lbl-1000:
            // 2 sources

            {
                switch (1.$SwitchMap$edu$cmu$hcii$ctat$CTATContentCache$Command[cmd.ordinal()]) {
                    case 1: {
                        if (record == null) {
                            System.err.printf("\n%-18s => %-18s => %s\n", new Object[]{args[i], alteredName, CTATContentCache.record2String(record)});
                            break;
                        }
                        ccc.writeToStdout(record);
                        break;
                    }
                    case 2: {
                        ccc.removeFromCache(record);
                        break;
                    }
                    case 3: {
                        System.out.printf("\n%-18s => %-18s => %s\n", new Object[]{args[i], alteredName, CTATContentCache.record2String(record)});
                        break;
                    }
                    case 4: {
                        try {
                            path = new StringBuilder(args[i]);
                            if ('/' == path.charAt(0)) {
                                path.deleteCharAt(0);
                            }
                            fileInfo = new File[1];
                            contents = CTATContentCache.readFromDisk(path.toString(), fileInfo);
                            ccc.addToCache(args[i], contents, CTATWebTools.headerDateFmt.format(new Date(fileInfo[0].lastModified())), true);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        break;
                    }
                    case 5: {
                        break;
                    }
                }
            }
            ++i;
        }
        ccc.immediateWrite();
        ccc.waitForWrite();
    }

    private void writeToStdout(CacheRecord record) {
        String[] lastModified = new String[1];
        byte[] content = this.getBytesFromCache(record.fileURI, lastModified, false);
        if (content == null) {
            System.err.printf("Null result retrieving %s; record:\n  %s\n", record.fileURI, CTATContentCache.record2String(record));
            return;
        }
        if (content.length < 1) {
            System.err.printf("Empty result retrieving %s; record:\n  %s\n", record.fileURI, CTATContentCache.record2String(record));
            return;
        }
        try {
            System.out.write(content);
        }
        catch (Exception e) {
            System.err.printf("Error %s writing retrieving %s; cause, record:\n  %s\n;\n  %s\n", e.toString(), record.fileURI, e.getCause().toString(), CTATContentCache.record2String(record));
            e.printStackTrace();
        }
    }

    private static byte[] readFromDisk(String fileName, File[] fileInfo) throws Exception {
        try {
            File f = new File(fileName);
            if (fileInfo != null) {
                fileInfo[0] = f;
            }
            byte[] result = new byte[(int)f.length()];
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(f));
            long readLen = ((InputStream)is).read(result);
            if (trace.getDebugCode("cache")) {
                trace.out("cache", "readFromDisk(" + fileName + ") readLen " + readLen);
            }
            ((InputStream)is).close();
            return result;
        }
        catch (Exception e) {
            throw new Exception("readFromDisk(" + fileName + ") error: " + e + "; cause " + e.getCause(), e);
        }
    }

    static enum Command {
        showall,
        list,
        help,
        output,
        remove,
        update;

    }

    private static class FrequencyTable {
        private static final String charset = "UTF-8";
        private FrequencyTableEntry head = null;
        private FrequencyTableEntry tail = null;
        private HashMap<String, FrequencyTableEntry> entries = new HashMap();

        public FrequencyTable() {
        }

        public FrequencyTable(File input) throws IOException {
            this();
            if (input == null) {
                return;
            }
            IOException exception = new IOException("Frequency table input file " + input + " is not formatted correctly.");
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(input), charset));){
                int b = reader.read();
                if (b == -1) {
                    return;
                }
                do {
                    StringBuilder sb = new StringBuilder();
                    while (b >= 48 && b <= 57) {
                        sb.append((char)b);
                        b = reader.read();
                    }
                    int uriLength = Integer.valueOf(sb.toString());
                    if (b != 32) {
                        throw exception;
                    }
                    char[] uriChars = new char[uriLength];
                    int charsRead = reader.read(uriChars);
                    if (charsRead != uriLength) {
                        throw exception;
                    }
                    if (reader.read() != 32) {
                        throw exception;
                    }
                    sb = new StringBuilder();
                    b = reader.read();
                    while (b >= 48 && b <= 57) {
                        sb.append((char)b);
                        b = reader.read();
                    }
                    int frequency = Integer.valueOf(sb.toString());
                    FrequencyTableEntry fte = new FrequencyTableEntry();
                    fte.fileURI = new String(uriChars);
                    fte.frequency = frequency;
                    this.addToList(fte);
                    while (b == 10 || b == 13) {
                        b = reader.read();
                    }
                } while (b != -1);
            }
        }

        public synchronized void increaseFrequency(String fileURI) {
            if (fileURI == null || fileURI.length() == 0) {
                return;
            }
            FrequencyTableEntry fte = this.entries.get(fileURI);
            if (fte == null) {
                fte = new FrequencyTableEntry();
                fte.fileURI = fileURI;
                fte.frequency = 1;
                this.addToList(fte);
            } else if (fte.frequency < Integer.MAX_VALUE || this.reduceAllFrequencies() > 0) {
                ++fte.frequency;
                this.floatUp(fte);
            }
        }

        public synchronized String getLeastFrequent() {
            return this.tail == null ? null : this.tail.fileURI;
        }

        public synchronized boolean remove(String s) {
            FrequencyTableEntry fte = this.entries.remove(s);
            if (fte == null) {
                return false;
            }
            if (fte != this.head && fte != this.tail) {
                fte.prev.next = fte.next;
                fte.next.prev = fte.prev;
            } else if (fte == this.head && fte != this.tail) {
                this.head = fte.next;
                this.head.prev = null;
            } else if (fte != this.head && fte == this.tail) {
                this.tail = fte.prev;
                this.tail.next = null;
            } else {
                this.tail = null;
                this.head = null;
            }
            return true;
        }

        public synchronized int getFrequencyOf(String s) {
            FrequencyTableEntry fte = this.entries.get(s);
            if (fte == null) {
                return -1;
            }
            return fte.frequency;
        }

        public synchronized void writeTo(File output) throws IOException {
            if (output == null) {
                return;
            }
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(output), charset));
            if (this.tail == null) {
                writer.close();
                return;
            }
            FrequencyTableEntry fte = this.head;
            while (fte != null) {
                String line = fte.fileURI.length() + " " + fte.fileURI + " " + fte.frequency + "\n";
                writer.write(line);
                fte = fte.next;
            }
            writer.close();
        }

        private synchronized void addToList(FrequencyTableEntry fte) {
            this.entries.put(fte.fileURI, fte);
            if (this.tail != null) {
                fte.prev = this.tail;
                this.tail.next = fte;
                fte.next = null;
                this.tail = fte;
            } else {
                fte.prev = null;
                fte.next = null;
                this.head = this.tail = fte;
            }
            this.floatUp(fte);
        }

        private synchronized int reduceAllFrequencies() {
            if (this.head == null) {
                return 0;
            }
            int reduction = this.tail.frequency;
            if (reduction <= 0) {
                return 0;
            }
            FrequencyTableEntry fte = this.head;
            while (fte != null) {
                fte.frequency -= reduction;
                fte = fte.next;
            }
            return reduction;
        }

        private synchronized void floatUp(FrequencyTableEntry fte) {
            while (fte.prev != null && fte.prev.frequency < fte.frequency) {
                this.swapWithPrev(fte);
            }
        }

        private synchronized void swapWithPrev(FrequencyTableEntry fte) {
            FrequencyTableEntry other = fte.prev;
            if (other == null) {
                return;
            }
            other.next = fte.next;
            if (other.next != null) {
                other.next.prev = other;
            } else {
                this.tail = other;
            }
            fte.prev = other.prev;
            other.prev = fte;
            fte.next = other;
            if (fte.prev != null) {
                fte.prev.next = fte;
            } else {
                this.head = fte;
            }
        }

        private class FrequencyTableEntry {
            public FrequencyTableEntry prev;
            public FrequencyTableEntry next;
            public String fileURI;
            public int frequency;

            private FrequencyTableEntry() {
            }
        }
    }

    private class FrequenciesWriter
    extends Thread {
        private FrequenciesWriter() {
        }

        @Override
        public void run() {
            if (CTATContentCache.this.cacheDirectory == null || !CTATContentCache.this.cacheDirectory.isDirectory()) {
                return;
            }
            try {
                CTATContentCache.this.freqtable.writeTo(new File(CTATContentCache.this.cacheDirectory, "frequencies.txt"));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private class CacheDiskWriter
    extends Thread {
        private LinkedList<CacheRecord> recordsToWrite = new LinkedList();
        private final int sleepTime = 10000;
        private Object lock = new Object();

        private CacheDiskWriter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.setPriority(1);
            if (CTATContentCache.this.cacheDirectory == null) {
                return;
            }
            if (CTATContentCache.this.initializer != null) {
                try {
                    CTATContentCache.this.initializer.join();
                }
                catch (InterruptedException e) {
                    return;
                }
            }
            while (true) {
                ArrayList<CacheRecord> toWriteThisIteration = null;
                Object object = this.recordsToWrite;
                synchronized (object) {
                    toWriteThisIteration = new ArrayList<CacheRecord>(this.recordsToWrite);
                    this.recordsToWrite.clear();
                }
                CTATContentCache.this.debug("Records to write: " + this.recordsToWrite.size());
                for (CacheRecord record : toWriteThisIteration) {
                    long bytesWritten = 0L;
                    int bytesRemovedFromMemory = 0;
                    Object object2 = record;
                    synchronized (object2) {
                        if (record.recordFilename == null || record.contentsFilename == null) {
                            if (record.contents == null) {
                                continue;
                            }
                            long estimatedSizeOnDisk = record.contents.length + 6144;
                            for (int count = 0; CTATContentCache.this.bytesOnDisk + estimatedSizeOnDisk > CTATContentCache.this.maxBytesOnDisk && count < 10; ++count) {
                                CTATContentCache.this.freeSomeDiskSpace();
                            }
                            if (CTATContentCache.this.bytesOnDisk + estimatedSizeOnDisk > CTATContentCache.this.maxBytesOnDisk) {
                                CTATContentCache.this.removeFromCache(record);
                            }
                            try {
                                CTATContentCache.this.debug("Writing cache contents with file URI " + record.fileURI + " to disk.");
                                if (!CTATContentCache.this.cacheDirectory.exists()) {
                                    CTATContentCache.this.cacheDirectory.mkdirs();
                                }
                                File contentsFile = File.createTempFile("content", ".file", CTATContentCache.this.cacheDirectory);
                                record.contentsFilename = contentsFile.getName();
                                ObjectOutputStream contentsOut = new ObjectOutputStream(new FileOutputStream(contentsFile));
                                contentsOut.writeObject(record.contents);
                                contentsOut.close();
                                bytesWritten += contentsFile.length();
                            }
                            catch (Exception e) {
                                trace.err("Error writing cache contents for file URI " + record.fileURI + " to disk:\n  " + e + (e.getCause() == null ? "" : "; cause " + e.getCause()));
                                continue;
                            }
                            bytesRemovedFromMemory += record.contents.length;
                            record.contents = null;
                            try {
                                CTATContentCache.this.debug("Writing cache record with file URI " + record.fileURI + " to disk.");
                                if (!CTATContentCache.this.cacheDirectory.exists()) {
                                    CTATContentCache.this.cacheDirectory.mkdirs();
                                }
                                File recordFile = File.createTempFile("record", ".file", CTATContentCache.this.cacheDirectory);
                                record.recordFilename = recordFile.getName();
                                ObjectOutputStream recordOut = new ObjectOutputStream(new FileOutputStream(recordFile));
                                recordOut.writeObject(record);
                                recordOut.close();
                                bytesWritten += recordFile.length();
                            }
                            catch (Exception e) {
                                trace.err("Error writing cache record for file URI " + record.fileURI + " to disk:\n  " + e + (e.getCause() == null ? "" : "; cause " + e.getCause()));
                                continue;
                            }
                            record.isOnDisk = true;
                        }
                    }
                    object2 = this.lock;
                    synchronized (object2) {
                        CTATContentCache.this.bytesOnDisk = CTATContentCache.this.bytesOnDisk + bytesWritten;
                        CTATContentCache.this.bytesInMemory = CTATContentCache.this.bytesInMemory - (long)bytesRemovedFromMemory;
                    }
                }
                try {
                    object = this.lock;
                    synchronized (object) {
                        CTATContentCache.this.debug("lock.notifyAll();");
                        this.lock.notifyAll();
                    }
                    CTATContentCache.this.debug("Going into sleep mode ...");
                    CacheDiskWriter.sleep(10000L);
                }
                catch (InterruptedException e) {
                }
            }
        }
    }

    private class CacheDiskReader
    extends Thread {
        private CacheDiskReader() {
        }

        @Override
        public void run() {
            CTATContentCache.this.debug("run ()");
            this.initializeCache();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void initializeCache() {
            if (CTATContentCache.this.cacheDirectory == null) {
                return;
            }
            CTATContentCache.this.bytesOnDisk = 0L;
            if (CTATContentCache.this.cacheDirectory.isDirectory()) {
                File[] cacheFiles = CTATContentCache.this.cacheDirectory.listFiles();
                if (cacheFiles == null) {
                    return;
                }
                for (File cacheFile : cacheFiles) {
                    if (!cacheFile.isFile() || !cacheFile.getName().startsWith("rec")) continue;
                    try {
                        ObjectInputStream cacheRecordIn = new ObjectInputStream(new FileInputStream(cacheFile));
                        CacheRecord cacheRecord = (CacheRecord)cacheRecordIn.readObject();
                        cacheRecord.isOnDisk = true;
                        Object object = CTATContentCache.this.lock;
                        synchronized (object) {
                            CTATContentCache.this.bytesOnDisk = CTATContentCache.this.bytesOnDisk + cacheFile.length();
                            CTATContentCache.this.bytesOnDisk = CTATContentCache.this.bytesOnDisk + new File(CTATContentCache.this.cacheDirectory, cacheRecord.contentsFilename).length();
                        }
                        object = CTATContentCache.this.records;
                        synchronized (object) {
                            CacheRecord prev = CTATContentCache.this.records.put(cacheRecord.fileURI, cacheRecord);
                            if (prev != null) {
                                CacheRecord recordToDelete;
                                if (cacheRecord.lastModified.compareTo(prev.lastModified) >= 0) {
                                    recordToDelete = prev;
                                } else {
                                    CTATContentCache.this.records.put(cacheRecord.fileURI, prev);
                                    recordToDelete = cacheRecord;
                                }
                                CTATContentCache.this.deleteFromDisk(recordToDelete);
                            }
                        }
                        cacheRecordIn.close();
                    }
                    catch (Exception e) {
                        CTATContentCache.this.debug(e.toString());
                    }
                }
                CTATContentCache.this.debug("cache initializer: " + CTATContentCache.this.records.size() + " cache records stored");
            }
        }
    }

    static enum Status {
        CACHE_INVALID,
        READ_FROM_CACHE,
        NOT_MODIFIED;

    }

    public static class UI {
        private JTextArea console = null;
        private JProgressBar progressBar = null;
        public static CTATVisualProgressTask visualProgress = null;
        public static JProgressBar refreshprogbar = null;

        public JTextArea getConsole() {
            return this.console;
        }

        public void setConsole(Object aConsole) {
            if (!(aConsole instanceof JTextArea)) {
                throw new IllegalArgumentException("Console of wrong type: " + aConsole.getClass());
            }
            this.console = (JTextArea)aConsole;
        }

        public void setProgressBar(Object aBar) {
            if (!(aBar instanceof JProgressBar)) {
                throw new IllegalArgumentException("ProgressBar of wrong type: " + aBar.getClass());
            }
            this.progressBar = (JProgressBar)aBar;
        }

        public void appendToConsole(final String string) {
            if (this.console != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        UI.this.console.append(string);
                    }
                });
            }
        }

        public void initializeProgressBar(int i, int totalProgressBarTasks, int startProgressBarAt) {
            if (this.progressBar != null) {
                this.progressBar.setMinimum(0);
                this.progressBar.setMaximum(totalProgressBarTasks);
                this.progressBar.setValue(startProgressBarAt);
            }
        }

        public void updateProgressBar(int current, int totalProgressBarTasks) {
            if (this.progressBar != null) {
                this.progressBar.setValue(current);
                this.progressBar.setString(current + " out of " + totalProgressBarTasks);
            }
        }

        public static boolean isEventDispatchThread() {
            return SwingUtilities.isEventDispatchThread();
        }

        public void updateInBackgroud(final CTATContentCache ccc, final String serverName) {
            SwingWorker<Boolean, Void> sw = new SwingWorker<Boolean, Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Boolean doInBackground() {
                    this.setProgress(0);
                    boolean swSuccess = true;
                    HashMap hashMap = ccc.records;
                    synchronized (hashMap) {
                        int i = 0;
                        for (CacheRecord record : ccc.records.values()) {
                            swSuccess = ccc.refreshSingleRecord(serverName, record) && swSuccess;
                            int oldval = this.getProgress();
                            int newval = ++i * 100 / ccc.records.size();
                            this.setProgress(newval);
                            this.firePropertyChange("progress", oldval, newval);
                        }
                    }
                    return swSuccess;
                }

                @Override
                public void done() {
                    LocalTSSystemTray systray = LocalTSSystemTray.getInstance();
                    systray.doneRefreshing();
                    systray.showBubbleIfPossible("The requested refresh operation is complete.");
                }
            };
            sw.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("progress".equals(evt.getPropertyName())) {
                        if (visualProgress != null) {
                            visualProgress.setValue((Integer)evt.getNewValue());
                        } else if (refreshprogbar != null) {
                            refreshprogbar.setValue((Integer)evt.getNewValue());
                            refreshprogbar.repaint();
                        }
                    }
                }
            });
            sw.execute();
        }

        public static void setVisualProgressOrProgressBar(int newval) {
            if (visualProgress != null) {
                visualProgress.setValue(newval);
            } else if (refreshprogbar != null) {
                refreshprogbar.setValue(newval);
            }
        }

        public static void setVisualProgress(int i) {
            if (visualProgress != null) {
                visualProgress.setValue(i);
            }
        }
    }

    public static class CacheEntryInfo {
        public final String fileURI;
        public final int accessFrequency;
        public final int size;

        public CacheEntryInfo(String fileURI, int accessFrequency, int size) {
            this.fileURI = fileURI;
            this.accessFrequency = accessFrequency;
            this.size = size;
        }
    }

    private static class CacheRecord
    implements Serializable {
        static final long serialVersionUID = 5051897423718905202L;
        public String fileURI;
        public byte[] contents;
        public String recordFilename;
        public String contentsFilename;
        public Date lastModified;
        public volatile transient boolean isOnDisk = false;

        public CacheRecord(String fileURI, byte[] contents, String lastModifiedStr) {
            this(fileURI, contents, (Date)null);
            try {
                if (lastModifiedStr != null) {
                    this.lastModified = CTATWebTools.headerDateFmt.parse(lastModifiedStr);
                }
            }
            catch (Exception e) {
                trace.err("Error parsing last-modified string as Date: " + e);
            }
        }

        public CacheRecord(String fileURI, byte[] contents, Date lastModified) {
            this.fileURI = fileURI;
            this.contents = contents;
            this.contentsFilename = null;
            this.recordFilename = null;
            this.lastModified = lastModified;
        }
    }
}

