/*
 * Decompiled with CFR 0.152.
 */
package pact.CommWidgets;

import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.MessageObject;
import edu.cmu.pact.ctat.TutorController;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import pact.CommWidgets.Clock;
import pact.CommWidgets.CyclingSpinnerListModel;
import pact.CommWidgets.JCommWidget;

public class AnalogClock
extends JCommWidget
implements ActionListener,
Serializable {
    protected Clock clock;
    protected JSpinner hourSpinner;
    protected JSpinner minuteSpinner;
    protected JButton toggleAMPMButton;
    protected JLabel AMPMLabel;
    protected JLabel hourLabel;
    protected JLabel minuteLabel;
    protected boolean studentMode = false;

    public AnalogClock() {
        this.initialized = false;
        this.actionName = "UpdateClock";
        this.setLayout(new FlowLayout());
        JPanel main = new JPanel();
        main.setLayout(new GridLayout(1, 2, 10, 10));
        JPanel one = new JPanel();
        this.clock = new Clock();
        this.clock.setHour(12);
        this.clock.setMinutes(0);
        this.clock.setAMPM("AM");
        one.add(this.clock);
        main.add(one);
        SpinnerChange spc = new SpinnerChange();
        JPanel configPanel = new JPanel();
        JPanel two = new JPanel();
        two.setLayout(new GridLayout(3, 2, 0, 0));
        this.hourLabel = new JLabel("H");
        two.add(this.hourLabel);
        this.hourSpinner = new JSpinner();
        Object[] hour = new Object[12];
        for (int i = 0; i < 12; ++i) {
            hour[i] = new Integer(i + 1);
        }
        CyclingSpinnerListModel cslmHour = new CyclingSpinnerListModel(hour);
        cslmHour.setValue(new Integer(12));
        this.hourSpinner.setModel(cslmHour);
        this.hourSpinner.addChangeListener(spc);
        two.add(this.hourSpinner);
        this.minuteLabel = new JLabel("M");
        two.add(this.minuteLabel);
        this.minuteSpinner = new JSpinner();
        Object[] minutes = new Object[12];
        for (int i = 0; i < 12; ++i) {
            minutes[i] = new Integer(i * 5);
        }
        CyclingSpinnerListModel cslmMinutes = new CyclingSpinnerListModel(minutes);
        cslmMinutes.setValue(new Integer(0));
        this.minuteSpinner.setModel(cslmMinutes);
        this.minuteSpinner.addChangeListener(spc);
        two.add(this.minuteSpinner);
        this.AMPMLabel = new JLabel("AM");
        two.add(this.AMPMLabel);
        this.toggleAMPMButton = new JButton("AM/PM");
        this.toggleAMPMButton.addActionListener(new ToggleAMPM());
        two.add(this.toggleAMPMButton);
        configPanel.add(two);
        main.add(configPanel);
        this.add(main);
    }

    public void setStudentMode(boolean b) {
        this.studentMode = b;
        if (this.studentMode) {
            this.hideConfigComponents();
        }
    }

    @Override
    public MessageObject getDescriptionMessage() {
        if (!this.initialize(this.getController())) {
            trace.out(5, this, "Error!!!!!!!!!!!!!!!!!");
            return null;
        }
        MessageObject mo = MessageObject.create("InterfaceDescription");
        mo.setVerb("SendNoteProperty");
        mo.setProperty("WidgetType", "AnalogClock");
        mo.setProperty("CommName", this.commName);
        mo.setProperty("UpdateEachCycle", new Boolean(this.updateEachCycle));
        Vector deftemplates = this.createJessDeftemplates();
        Vector instances = this.createJessInstances();
        if (deftemplates != null) {
            mo.setProperty("jessDeftemplates", deftemplates);
        }
        if (instances != null) {
            mo.setProperty("jessInstances", instances);
        }
        this.serializeGraphicalProperties(mo);
        if (!this.studentMode) {
            this.hideConfigComponents();
        }
        return mo;
    }

    public Vector createJessDeftemplates() {
        Vector<String> deftemplates = new Vector<String>();
        String deftemplateStr = "(deftemplate analogclock (slot name) (slot hour) (slot minutes) (slot AMPM) (slot value))";
        deftemplates.add(deftemplateStr);
        return deftemplates;
    }

    public Vector createJessInstances() {
        Vector<String> instances = new Vector<String>();
        String instanceStr = "(assert (analogclock (name " + this.commName + ") (hour " + this.clock.getHour() + ") (minutes " + this.clock.getMinutes() + ") (AMPM " + this.clock.getAMPM() + ") (value " + this.clock.getHour() + "-" + this.clock.getMinutes() + "-" + this.clock.getAMPM() + ")))";
        instances.add(instanceStr);
        return instances;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    @Override
    public void doCorrectAction(String str, String str2, String str3) {
    }

    @Override
    public void doIncorrectAction(String str, String str1) {
    }

    @Override
    public void doInterfaceAction(String str, String str1, String str2) {
        if (str1.equals("UpdateClock")) {
            String[] values = str2.split("-");
            this.clock.setHour(Integer.parseInt(values[0]));
            this.clock.setMinutes(Integer.parseInt(values[1]));
            this.clock.setAMPM(values[2]);
            this.AMPMLabel.setText(values[2]);
        }
        this.repaint();
    }

    @Override
    public void doLISPCheckAction(String str, String str1) {
    }

    @Override
    public Object getValue() {
        return "" + this.clock.getHour() + "-" + this.clock.getMinutes() + "-" + this.clock.getAMPM();
    }

    @Override
    public boolean isChangedFromResetState() {
        return true;
    }

    @Override
    public void reset(TutorController controller) {
        this.initialize(controller);
        this.hideConfigComponents();
    }

    public int getHour() {
        return this.clock.getHour();
    }

    public int getMinutes() {
        return this.clock.getMinutes();
    }

    public String getAMPM() {
        return this.clock.getAMPM();
    }

    public void hideConfigComponents() {
        this.hourLabel.setVisible(false);
        this.minuteLabel.setVisible(false);
        this.minuteSpinner.setVisible(false);
        this.hourSpinner.setVisible(false);
        this.toggleAMPMButton.setVisible(false);
        this.studentMode = true;
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    protected class ToggleAMPM
    implements ActionListener {
        protected ToggleAMPM() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (AnalogClock.this.AMPMLabel.getText().equals("PM")) {
                AnalogClock.this.AMPMLabel.setText("AM");
                AnalogClock.this.clock.setAMPM("AM");
            } else {
                AnalogClock.this.AMPMLabel.setText("PM");
                AnalogClock.this.clock.setAMPM("PM");
            }
        }
    }

    protected class SpinnerChange
    implements ChangeListener {
        protected SpinnerChange() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (e.getSource() == AnalogClock.this.minuteSpinner) {
                AnalogClock.this.clock.setMinutes((Integer)AnalogClock.this.minuteSpinner.getValue());
            } else if (e.getSource() == AnalogClock.this.hourSpinner) {
                AnalogClock.this.clock.setHour((Integer)AnalogClock.this.hourSpinner.getValue());
            }
        }
    }
}

