/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.ctat.model;

import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.model.Skill;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public class Skills
implements Serializable {
    private static final long serialVersionUID = -7981908596528542627L;
    public static final String SKILLS = "Skills";
    private static XMLOutputter xmlOutputter = new XMLOutputter();
    private HashMap<String, Skill> skillMap = new LinkedHashMap<String, Skill>();
    private Set<String> updatedStepIDs = new HashSet<String>();
    private int transactionNumber = 0;
    private boolean externallyDefined = false;
    private String version;

    public Skills() {
        this(new LinkedList<Skill>());
    }

    public Skills(List<Skill> skillList) {
        for (Skill skill : skillList) {
            this.skillMap.put(skill.getSkillName().toLowerCase(), skill);
        }
    }

    public Skill getSkill(String skillName) {
        return this.skillMap.get(skillName == null ? null : skillName.toLowerCase());
    }

    public List<Skill> getAllSkills() {
        ArrayList<Skill> skillList = new ArrayList<Skill>();
        for (Skill skill : this.skillMap.values()) {
            skillList.add(skill);
        }
        return skillList;
    }

    public int size() {
        return this.skillMap.size();
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            return;
        }
        File inputFile = new File(args[0]);
        Skills skills = Skills.factory(inputFile);
        System.out.printf("%2s. %-30s %-30s %s\n", "No", "Category", "Name", "pKnown");
        int i = 0;
        for (Skill skill : skills.getAllSkills()) {
            System.out.printf("%2d. %-30s %-30s %4.2f\n", ++i, skill.getCategory(), skill.getName(), skill.getPKnown());
        }
        System.out.println();
        System.out.println(skills.toXMLString());
    }

    public static Skills factory(File inputFile) throws Exception {
        SAXBuilder xmlParser = new SAXBuilder();
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(inputFile));
        Document doc = xmlParser.build((InputStream)is);
        Element root = doc.getRootElement();
        if (SKILLS.equalsIgnoreCase(root.getName())) {
            return Skills.factory(doc.getRootElement());
        }
        Element skillsElt = root.getChild(SKILLS);
        if (skillsElt != null) {
            return Skills.factory(skillsElt);
        }
        return null;
    }

    public static Skills factory(String inputString) throws Exception {
        SAXBuilder xmlParser = new SAXBuilder();
        Document doc = xmlParser.build((Reader)new StringReader(inputString));
        Element root = doc.getRootElement();
        if (SKILLS.equalsIgnoreCase(root.getName())) {
            return Skills.factory(doc.getRootElement());
        }
        Element skillsElt = root.getChild(SKILLS);
        if (skillsElt != null) {
            return Skills.factory(skillsElt);
        }
        return null;
    }

    public static Skills factory(Element elt) throws Exception {
        List<Element> childElts = null;
        if (trace.getDebugCode("skills")) {
            trace.out("skills", "Skills.factory(" + xmlOutputter.outputString(elt) + ")");
        }
        if ("Skill".equalsIgnoreCase(elt.getName())) {
            childElts = new ArrayList();
            childElts.add(elt);
        } else {
            childElts = elt.getChildren("Skill");
            if (childElts == null || childElts.isEmpty()) {
                childElts = elt.getChildren("Skill".toLowerCase());
            }
        }
        return Skills.factory(childElts);
    }

    public static Skills factory(List skillElts) throws Exception {
        ArrayList<Skill> skillList = new ArrayList<Skill>();
        for (Object child : skillElts) {
            if (!(child instanceof Element)) continue;
            try {
                Skill skill = Skill.factory((Element)child);
                if (skill == null) continue;
                skillList.add(skill);
            }
            catch (Exception e) {
                trace.err("Error parsing skill: " + e + "; cause " + e.getCause() + "\n  skill: " + xmlOutputter.outputString((Element)child));
            }
        }
        if (trace.getDebugCode("skills")) {
            trace.out("skills", "Skills.factory skillList: " + skillList);
        }
        return new Skills(skillList);
    }

    public String toXMLString() {
        Element skillsElt = this.toXMLElement();
        return Skill.xmlOutputter.outputString(skillsElt);
    }

    public Element toXMLElement() {
        Element skillsElt = new Element(SKILLS);
        for (Skill sk : this.getAllSkills()) {
            skillsElt.addContent((Content)sk.toXMLElement());
        }
        return skillsElt;
    }

    public Vector<String> getSkillBarVector() {
        return this.getSkillBarVector(false);
    }

    public Vector<String> getSkillBarVector(boolean includeLabels) {
        return this.getSkillBarVector(includeLabels, false);
    }

    public Vector<String> getSkillBarVector(boolean includeLabels, boolean includeAll) {
        Vector<String> result = new Vector<String>();
        for (Skill skill : this.skillMap.values()) {
            if (!includeAll && skill.getTransactionNumber() != this.transactionNumber) continue;
            result.add(skill.getSkillBarString(includeLabels));
        }
        return result;
    }

    public Skill updateSkill(String transactionResult, String skillName, String stepID) {
        Skill result = null;
        boolean newStep = false;
        Skill skill = this.getSkill(skillName);
        if (skill != null) {
            skill.setTransactionNumber(this.transactionNumber);
            String key = stepID + " " + skillName;
            newStep = this.updatedStepIDs.add(key);
            if (newStep) {
                skill.updatePKnown(transactionResult);
                skill.updateHistory(transactionResult);
                skill.changeOpportunityCount(1);
            }
            if ("correct".equalsIgnoreCase(transactionResult)) {
                this.updatedStepIDs.remove(key);
            }
            result = skill;
        }
        if (trace.getDebugCode("skills")) {
            trace.out("skills", "updateSkill[" + skillName + "]=>" + skill + " " + (newStep ? "new" : "not new") + ": " + transactionResult);
        }
        return result;
    }

    public void add(Skill skill) {
        if (skill == null || skill.getSkillName() == null) {
            return;
        }
        if (this.skillMap.get(skill.getSkillName().toLowerCase()) == null) {
            skill.setVersion(this.version);
            if (trace.getDebugCode("skill")) {
                trace.out("skill", "Skills.add(" + skill + ") setting version to: " + this.version);
            }
            this.skillMap.put(skill.getSkillName().toLowerCase(), skill);
        }
    }

    public void startTransaction() {
        ++this.transactionNumber;
    }

    public int getTransactionNumber() {
        return this.transactionNumber;
    }

    public boolean isExternallyDefined() {
        return this.externallyDefined;
    }

    public void setExternallyDefined(boolean externallyDefined) {
        this.externallyDefined = externallyDefined;
    }

    public void setVersion(String version) {
        if (trace.getDebugCode("skills")) {
            trace.out("skills", "Skills.setVersion(" + version + "): version was " + this.version);
        }
        this.version = version;
        for (Skill sk : this.skillMap.values()) {
            sk.setVersion(version);
        }
    }

    public String getSkillBarDelimiter() {
        String result = Skill.versionToSkillBarDelimiter(this.version);
        if (trace.getDebugCode("skills")) {
            trace.out("skills", "Skills.getSkillBarDelimiter() result " + result);
        }
        return result;
    }
}

