/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.Utilities;

import edu.cmu.pact.Utilities.trace;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.SwingWorker;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public abstract class TextOutput {
    private static int MAXSIZE = 32768;
    protected boolean promptShowing = false;
    private PrintWriter writer;
    private transient Set<OutputEventListener> listeners = new HashSet<OutputEventListener>();

    public TextOutput append(String s) {
        this.internalAppend(s);
        this.fireOutputEvent(s);
        this.promptShowing = false;
        return this;
    }

    public synchronized void addOutputEventListener(OutputEventListener listener) {
        this.listeners.add(listener);
    }

    public synchronized void removeOutputEventListener(OutputEventListener listener) {
        this.listeners.remove(listener);
    }

    private void fireOutputEvent(String s) {
        OutputEvent e = new OutputEvent(this, s);
        Iterator<OutputEventListener> it = this.listeners.iterator();
        while (it.hasNext()) {
            it.next().outputOccurred(e);
        }
    }

    protected abstract TextOutput internalAppend(String var1);

    public TextOutput println(String s) {
        this.append(s);
        this.append("\n");
        return this;
    }

    public TextOutput prompt(String s) {
        if (this.promptShowing) {
            return this;
        }
        this.append(s);
        this.promptShowing = true;
        return this;
    }

    public void clear() {
        this.promptShowing = false;
    }

    public PrintWriter getWriter() {
        if (this.writer == null) {
            this.writer = this.createWriter();
        }
        return this.writer;
    }

    protected abstract PrintWriter createWriter();

    public static final TextOutput getNullOutput() {
        return new NullOutput();
    }

    public static TextOutput getTextOutput(Document doc) {
        return new TextDocument(doc);
    }

    public static TextOutput getTextOutput(StringWriter sw) {
        return new StringOutput(sw);
    }

    public static TextOutput getTextOutput(java.io.PrintStream ps) {
        return new PrintStream(ps);
    }

    public abstract Document getDocument();

    private static class NullOutput
    extends TextOutput {
        private NullOutput() {
        }

        @Override
        protected TextOutput internalAppend(String s) {
            return this;
        }

        @Override
        public Document getDocument() {
            return null;
        }

        @Override
        protected PrintWriter createWriter() {
            return new PrintWriter(new NullWriter());
        }

        private class NullWriter
        extends Writer {
            private NullWriter() {
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() {
            }

            @Override
            public void write(char[] cbuf, int off, int len) {
            }
        }
    }

    private static class StringOutput
    extends TextOutput {
        private StringWriter delegate;

        private StringOutput(StringWriter sw) {
            this.delegate = sw;
        }

        @Override
        public Document getDocument() {
            return null;
        }

        @Override
        protected TextOutput internalAppend(String s) {
            StringBuffer sb = this.delegate.getBuffer();
            int len = sb.length() + s.length();
            if (len > MAXSIZE * 2) {
                sb.replace(0, MAXSIZE, "");
            }
            this.delegate.write(s);
            return this;
        }

        @Override
        public void clear() {
            this.delegate.getBuffer().setLength(0);
        }

        @Override
        protected PrintWriter createWriter() {
            return new PrintWriter(this.delegate);
        }
    }

    private static class TextDocument
    extends TextOutput {
        private static final String CLEAR_DOCUMENT = "***[[[weird string telling process to clear]]]***";
        private Document delegate;
        private PrintWriter writer;
        private Appender worker;

        private TextDocument(Document doc) {
            this.delegate = doc;
            this.writer = new PrintWriter(new TextDocumentWriter());
            this.worker = new Appender();
            if (trace.getDebugCode("jc")) {
                trace.printStack("jc", this.getClass().getSimpleName() + " constructor() about to call SwingWorker.execute()");
            }
            this.worker.execute();
        }

        @Override
        protected TextOutput internalAppend(String s) {
            this.worker.enqueue(s);
            return this;
        }

        @Override
        public void clear() {
            this.worker.enqueue(CLEAR_DOCUMENT);
        }

        @Override
        public Document getDocument() {
            return this.delegate;
        }

        @Override
        protected PrintWriter createWriter() {
            return this.writer;
        }

        private class TextDocumentWriter
        extends Writer {
            private TextDocumentWriter() {
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() {
            }

            @Override
            public void write(char[] cbuf, int off, int len) {
                String s = new String(cbuf, off, len);
                try {
                    TextDocument.this.append(s);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        private class Appender
        extends SwingWorker<Void, String> {
            private LinkedList<String> linesQueued = new LinkedList();

            private Appender() {
            }

            @Override
            protected Void doInBackground() {
                if (trace.getDebugCode("jc")) {
                    trace.printStack("jc", this.getClass().getSimpleName() + ".doInBackground() starting");
                }
                while (!this.isCancelled()) {
                    try {
                        this.publish(this.dequeue());
                    }
                    catch (Exception ie) {
                        ie.printStackTrace();
                    }
                }
                if (trace.getDebugCode("jc")) {
                    trace.out("jc", this.getClass().getSimpleName() + ".doInBackground() exiting isCancelled " + this.isCancelled());
                }
                return null;
            }

            @Override
            protected void process(List<String> lines) {
                for (String s : lines) {
                    try {
                        int len = TextDocument.this.delegate.getLength();
                        if (TextDocument.CLEAR_DOCUMENT.equals(s)) {
                            TextDocument.this.delegate.remove(0, len);
                            continue;
                        }
                        if (len + s.length() > MAXSIZE * 2) {
                            TextDocument.this.delegate.remove(0, MAXSIZE);
                        }
                        TextDocument.this.delegate.insertString(TextDocument.this.delegate.getLength(), s, null);
                    }
                    catch (BadLocationException e) {
                        trace.errStack(String.format("Error inserting string \"%.90s\" into document " + TextDocument.this.delegate, s), e);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private String dequeue() {
                LinkedList<String> linkedList = this.linesQueued;
                synchronized (linkedList) {
                    while (this.linesQueued.isEmpty()) {
                        try {
                            this.linesQueued.wait();
                        }
                        catch (Exception ie) {
                            ie.printStackTrace();
                        }
                    }
                    if (trace.getDebugCode("jc")) {
                        trace.out("jc", this.getClass().getSimpleName() + ".dequeue() linesQueued.size " + this.linesQueued.size());
                    }
                    return this.linesQueued.removeFirst();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            synchronized int enqueue(String line) {
                LinkedList<String> linkedList = this.linesQueued;
                synchronized (linkedList) {
                    this.linesQueued.addLast(line);
                    int result = this.linesQueued.size();
                    this.linesQueued.notifyAll();
                    return result;
                }
            }
        }
    }

    private static class PrintStream
    extends TextOutput {
        private java.io.PrintStream delegate;

        private PrintStream(java.io.PrintStream ta) {
            this.delegate = ta;
        }

        @Override
        protected PrintWriter createWriter() {
            return new PrintWriter(this.delegate);
        }

        @Override
        public Document getDocument() {
            return null;
        }

        @Override
        protected TextOutput internalAppend(String s) {
            this.delegate.print(s);
            return this;
        }
    }

    public static class OutputEvent
    extends EventObject {
        private static final long serialVersionUID = 3235450617896682604L;
        private final String output;

        private OutputEvent(TextOutput source, String output) {
            super(source);
            this.output = output;
        }

        public String getOutput() {
            return this.output;
        }
    }

    public static interface OutputEventListener {
        public void outputOccurred(OutputEvent var1);
    }
}

