/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.ProblemModel;

import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.EdgeData;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemEdge;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemModel;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.VariableTableModel;
import edu.cmu.pact.Utilities.trace;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Pattern;

public class VariableTable
extends LinkedHashMap<String, Object> {
    private static final long serialVersionUID = 201403071830L;
    private transient VariableTableModel model;
    private static int count = 0;
    private int instance;
    static final Pattern STUDENT_SELECTION_KEY = Pattern.compile("link[0-9]+\\.selection");
    static final Pattern STUDENT_ACTION_KEY = Pattern.compile("link[0-9]+\\.action");
    static final Pattern STUDENT_INPUT_KEY = Pattern.compile("link[0-9]+\\.input");
    static final Pattern STUDENT_ACTOR_KEY = Pattern.compile("link[0-9]+\\.actor");
    private transient Set<String> _keyPath;

    public VariableTable() {
        if (trace.getDebugCode("vtm")) {
            trace.outNT("vtm", "VariableTable default constructor");
        }
        this.instance = count++;
        if (trace.getDebugCode("vtm")) {
            trace.outNT("vtm", "VariableTable #" + this.instance);
        }
    }

    public VariableTable(boolean isStudentTime) {
        if (trace.getDebugCode("vtm")) {
            trace.outNT("vtm", "VariableTable overloaded constructor");
        }
        this.instance = count++;
        if (trace.getDebugCode("vtm")) {
            trace.outNT("vtm", "VariableTable #" + this.instance);
        }
        if (isStudentTime) {
            this.model = null;
            if (trace.getDebugCode("vtm")) {
                trace.out("vtm", "model is null");
            }
        } else {
            this.model = new VariableTableModel(this);
            if (trace.getDebugCode("vtm")) {
                trace.out("vtm", "model is not null");
            }
        }
    }

    private VariableTable(VariableTable original) {
        super(original);
        this.instance = count++;
    }

    public static boolean isFloatingPoint(Object input) {
        String Digits = "(\\p{Digit}+)";
        String HexDigits = "(\\p{XDigit}+)";
        String Exp = "[eE][+-]?(\\p{Digit}+)";
        String fpRegex = "[\\x00-\\x20]*[+-]?(NaN|Infinity|((((\\p{Digit}+)(\\.)?((\\p{Digit}+)?)([eE][+-]?(\\p{Digit}+))?)|(\\.((\\p{Digit}+))([eE][+-]?(\\p{Digit}+))?)|(((0[xX](\\p{XDigit}+)(\\.)?)|(0[xX](\\p{XDigit}+)?(\\.)(\\p{XDigit}+)))[pP][+-]?(\\p{Digit}+)))[fFdD]?))[\\x00-\\x20]*";
        return input instanceof String && Pattern.matches("[\\x00-\\x20]*[+-]?(NaN|Infinity|((((\\p{Digit}+)(\\.)?((\\p{Digit}+)?)([eE][+-]?(\\p{Digit}+))?)|(\\.((\\p{Digit}+))([eE][+-]?(\\p{Digit}+))?)|(((0[xX](\\p{XDigit}+)(\\.)?)|(0[xX](\\p{XDigit}+)?(\\.)(\\p{XDigit}+)))[pP][+-]?(\\p{Digit}+)))[fFdD]?))[\\x00-\\x20]*", (String)input);
    }

    private Object evaluateInput(Object input) {
        if (VariableTable.isFloatingPoint(input)) {
            return Double.valueOf((String)input);
        }
        return input;
    }

    private boolean isStudentSAI(String keyStr) {
        return STUDENT_SELECTION_KEY.matcher(keyStr).matches() || STUDENT_ACTION_KEY.matcher(keyStr).matches() || STUDENT_INPUT_KEY.matcher(keyStr).matches() || STUDENT_ACTOR_KEY.matcher(keyStr).matches();
    }

    public void clearStudentSAI() {
        if (trace.getDebugCode("functions")) {
            trace.outln("functions", "clearStudentSAI");
        }
        HashSet keys = new HashSet(this.keySet());
        for (String keyStr : keys) {
            if (!this.isStudentSAI(keyStr)) continue;
            this.remove(keyStr);
        }
        if (this.model != null) {
            this.model.updateTableCleared();
        }
    }

    public void clearNotStudentSAI() {
        if (trace.getDebugCode("functions")) {
            trace.outln("functions", "clearNotStudentSAI");
        }
        HashSet keys = new HashSet(this.keySet());
        for (String keyStr : keys) {
            if (this.isStudentSAI(keyStr)) continue;
            this.remove(keyStr);
        }
        if (this.model != null) {
            this.model.updateTableCleared();
        }
    }

    @Override
    public Object get(Object key) {
        return this.get(key, null);
    }

    public Object get(Object key, ProblemModel problemModel) {
        if (trace.getDebugCode("functions")) {
            trace.outln("functions", "VariableTable.get(" + key + ")");
        }
        if (this.containsKey(key)) {
            return super.get(key);
        }
        if (key instanceof String && problemModel != null) {
            String[] path;
            Object value = null;
            if (this._keyPath == null) {
                this._keyPath = new LinkedHashSet<String>();
            }
            if (this._keyPath.contains(key)) {
                throw new IllegalStateException("ERROR: reference cycle on variable \"" + key + "\"; path\n " + this._keyPath);
            }
            this._keyPath.add((String)key);
            if (trace.getDebugCode("functions")) {
                trace.outln("functions", "keypath is " + this._keyPath.toString());
            }
            if ((path = ((String)key).split("\\.")).length > 1) {
                String edgeName = path[0];
                String suffix = path[1];
                boolean isAuthorVar = suffix.startsWith("author");
                Enumeration<ProblemEdge> edges = problemModel.getProblemGraph().edges();
                while (isAuthorVar && edges.hasMoreElements()) {
                    EdgeData edge = edges.nextElement().getEdgeData();
                    if (!edgeName.equals(edge.getName())) continue;
                    if (suffix.equals("authorSelection")) {
                        value = edge.getMatcher().getDefaultSelection();
                        break;
                    }
                    if (suffix.equals("authorAction")) {
                        value = edge.getMatcher().getDefaultAction();
                        break;
                    }
                    if (!suffix.equals("authorInput")) continue;
                    if (trace.getDebugCode("functions")) {
                        trace.outln("functions", "Evaluating authorInput on " + edgeName);
                    }
                    value = this.evaluateInput(edge.getMatcher().evaluate());
                    break;
                }
            }
            this._keyPath = null;
            return value;
        }
        return null;
    }

    @Override
    public Object put(String key, Object value) {
        if (trace.getDebugCode("vt")) {
            trace.outNT("vt", "VariableTable #" + this.instance + ": **KEY** " + key + "**VALUE** " + value);
        }
        boolean replace = this.containsKey(key);
        Object returnVal = super.put(key, value);
        if (this.model != null) {
            this.model.updateTable(replace, key, this.instance);
        }
        return returnVal;
    }

    public VariableTableModel getModel() {
        return this.model;
    }

    public void setModel(VariableTableModel mod2) {
        this.model = mod2;
    }

    public boolean hasModel() {
        return this.model != null;
    }

    public int getInstance() {
        return this.instance;
    }

    @Override
    public void clear() {
        if (trace.getDebugCode("vt")) {
            trace.printStack("vt", "clear() VariableTable #" + this.getInstance());
        }
        super.clear();
        if (this.model != null) {
            this.model.fireTableDataChanged();
        }
    }

    @Override
    public Object remove(Object key) {
        if (trace.getDebugCode("vt")) {
            trace.outNT("vt", "remove(" + key + ") VariableTable #" + this.getInstance());
        }
        Object returnVal = super.remove(key);
        if (this.model != null) {
            this.model.fireTableDataChanged();
        }
        return returnVal;
    }

    @Override
    public Object clone() {
        if (trace.getDebugCode("vt")) {
            trace.printStack("vt", "calling clone() on VariableTable #" + this.getInstance() + " which has " + (this.model == null ? "no TableModel" : "TableModel #" + this.getModel().getInstance()));
        }
        VariableTable copy = new VariableTable(this);
        if (trace.getDebugCode("vt")) {
            trace.outNT("vt", "returning VariableTable #" + copy.getInstance());
        }
        return copy;
    }
}

