/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.Controller;

import edu.cmu.hcii.utilities.HttpToolEmulator;
import edu.cmu.pact.Utilities.ProcessRunner;
import edu.cmu.pact.Utilities.Utils;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.MessageObject;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class JSExampleTracer {
    static final String DEFAULT_URL = "http://localhost:8888/sendToTutor";
    private static String prologue = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private static final String messageClose = "</message>";
    private static final String messageOpen = "<message>";
    private static Pattern messageDelimiter = Pattern.compile("</message>\\s*<message>");
    private ProcessRunner jsProcess = null;
    private final HttpToolEmulator hte;
    private static int instanceNo = 0;

    JSExampleTracer(String url) {
        this(url, true);
    }

    JSExampleTracer(String url, boolean startChild) {
        ++instanceNo;
        if (trace.getDebugCode("js")) {
            trace.printStack("js", "instance[" + instanceNo + "] JSExampleTracer(" + url + "," + startChild + ")");
        }
        if (startChild) {
            StringBuffer firstOutput = new StringBuffer();
            this.jsProcess = new ProcessRunner(trace.getDebugCode("js"));
            this.jsProcess.exec(new String[]{"nodejs", "../HTML5/src/Node/server.js"}, false, firstOutput);
            long now = System.currentTimeMillis();
            long then = now + 20000L;
            long begin = now;
            while (now < then) {
                if (trace.getDebugCode("js")) {
                    trace.out("js", "JSExampleTracer waiting up to " + (then - now) + " ms for child process to start");
                }
                try {
                    Thread.sleep(then - now);
                }
                catch (Exception ie) {
                    trace.err(String.format("Exception after %d ms; firstOutput \"%s\": %s; cause %s", System.currentTimeMillis() - begin, firstOutput, ie, ie.getCause()));
                    if (firstOutput.length() > 0) break;
                }
                now = System.currentTimeMillis();
            }
        }
        this.hte = new HttpToolEmulator(url);
    }

    List<MessageObject> getExampleTracerResponses(MessageObject req) {
        ArrayList<MessageObject> result = new ArrayList<MessageObject>();
        int i = -1;
        try {
            String response = this.hte.sendAndWait(prologue + req.toString());
            String[] msgTexts = messageDelimiter.split(response);
            for (i = 0; i < msgTexts.length; ++i) {
                String msgText = msgTexts[i];
                if (i > 0) {
                    msgText = messageOpen + msgText;
                }
                if (i < msgTexts.length - 1) {
                    msgText = msgText + messageClose;
                }
                if (trace.getDebugCode("js")) {
                    trace.out("js", String.format("response[%2d] of %2d: %s", i, msgTexts.length, msgText));
                }
                if (msgText.length() < messageDelimiter.pattern().length()) continue;
                MessageObject msg = MessageObject.parse(msgText);
                result.add(msg);
            }
        }
        catch (Exception e) {
            trace.errStack("Error on response[" + i + "]: " + e + "; cause " + e.getCause() + ";\n  request was " + req, e);
        }
        return result;
    }

    public List<MessageObject> openBRD(String problemFileLocation) {
        URL url = Utils.getURL(problemFileLocation, this);
        trace.out("js", "openBRD(" + problemFileLocation + ") url = " + url);
        MessageObject setPrefs = MessageObject.create("SetPreferences");
        String path = url.getPath();
        int colon = path.indexOf(58);
        if (colon >= 0) {
            path = path.substring(colon + 1);
        }
        setPrefs.addPropertyElement("question_file", "http://localhost:8888/" + path);
        setPrefs.setProperty("problem_name", path);
        return this.getExampleTracerResponses(setPrefs);
    }

    public int killChild() {
        if (this.jsProcess == null) {
            return -1;
        }
        long now = System.currentTimeMillis();
        int result = this.jsProcess.kill(2000L);
        if (trace.getDebugCode("js")) {
            trace.out("js", String.format("jsProcess.kill() returns exit status %d after %d ms", result, System.currentTimeMillis() - now));
        }
        return result;
    }
}

