/*
 MIT License - https://bitbucket.org/pellepim/jstimezonedetect/src/default/LICENCE.txt

 For usage and examples, visit:
 http://pellepim.bitbucket.org/jstz/

 Copyright (c) Jon Nylander
*/
var jstz = function() {
  var HEMISPHERE_SOUTH = "s", consts = {DAY:864E5, HOUR:36E5, MINUTE:6E4, SECOND:1E3, BASELINE_YEAR:2014, MAX_SCORE:864E6, AMBIGUITIES:{"America/Denver":["America/Mazatlan"], "Europe/London":["Africa/Casablanca"], "America/Chicago":["America/Mexico_City"], "America/Asuncion":["America/Campo_Grande", "America/Santiago"], "America/Montevideo":["America/Sao_Paulo", "America/Santiago"], "Asia/Beirut":["Asia/Amman", "Asia/Jerusalem", "Europe/Helsinki", "Asia/Damascus", "Africa/Cairo", "Asia/Gaza", "Europe/Minsk"], 
  "Pacific/Auckland":["Pacific/Fiji"], "America/Los_Angeles":["America/Santa_Isabel"], "America/New_York":["America/Havana"], "America/Halifax":["America/Goose_Bay"], "America/Godthab":["America/Miquelon"], "Asia/Dubai":["Asia/Yerevan"], "Asia/Jakarta":["Asia/Krasnoyarsk"], "Asia/Shanghai":["Asia/Irkutsk", "Australia/Perth"], "Australia/Sydney":["Australia/Lord_Howe"], "Asia/Tokyo":["Asia/Yakutsk"], "Asia/Dhaka":["Asia/Omsk"], "Asia/Baku":["Asia/Yerevan"], "Australia/Brisbane":["Asia/Vladivostok"], 
  "Pacific/Noumea":["Asia/Vladivostok"], "Pacific/Majuro":["Asia/Kamchatka", "Pacific/Fiji"], "Pacific/Tongatapu":["Pacific/Apia"], "Asia/Baghdad":["Europe/Minsk", "Europe/Moscow"], "Asia/Karachi":["Asia/Yekaterinburg"], "Africa/Johannesburg":["Asia/Gaza", "Africa/Cairo"]}}, get_date_offset = function get_date_offset(date) {
    var offset = -date.getTimezoneOffset();
    return offset !== null ? offset : 0;
  }, lookup_key = function lookup_key() {
    var january_offset = get_date_offset(new Date(consts.BASELINE_YEAR, 0, 2)), june_offset = get_date_offset(new Date(consts.BASELINE_YEAR, 5, 2)), diff = january_offset - june_offset;
    if (diff < 0) {
      return january_offset + ",1";
    } else {
      if (diff > 0) {
        return june_offset + ",1," + HEMISPHERE_SOUTH;
      }
    }
    return january_offset + ",0";
  }, get_from_internationalization_api = function get_from_internationalization_api() {
    var format, timezone;
    if (typeof Intl === "undefined" || typeof Intl.DateTimeFormat === "undefined") {
      return;
    }
    format = Intl.DateTimeFormat();
    if (typeof format === "undefined" || typeof format.resolvedOptions === "undefined") {
      return;
    }
    timezone = format.resolvedOptions().timeZone;
    if (timezone && (timezone.indexOf("/") > -1 || timezone === "UTC")) {
      return timezone;
    }
  }, dst_dates = function dst_dates(year) {
    var yearstart = (new Date(year, 0, 1, 0, 0, 1, 0)).getTime();
    var yearend = (new Date(year, 12, 31, 23, 59, 59)).getTime();
    var current = yearstart;
    var offset = (new Date(current)).getTimezoneOffset();
    var dst_start = null;
    var dst_end = null;
    while (current < yearend - 864E5) {
      var dateToCheck = new Date(current);
      var dateToCheckOffset = dateToCheck.getTimezoneOffset();
      if (dateToCheckOffset !== offset) {
        if (dateToCheckOffset < offset) {
          dst_start = dateToCheck;
        }
        if (dateToCheckOffset > offset) {
          dst_end = dateToCheck;
        }
        offset = dateToCheckOffset;
      }
      current += 864E5;
    }
    if (dst_start && dst_end) {
      return {s:find_dst_fold(dst_start).getTime(), e:find_dst_fold(dst_end).getTime()};
    }
    return false;
  }, find_dst_fold = function find_dst_fold(a_date, padding, iterator) {
    if (typeof padding === "undefined") {
      padding = consts.DAY;
      iterator = consts.HOUR;
    }
    var date_start = (new Date(a_date.getTime() - padding)).getTime();
    var date_end = a_date.getTime() + padding;
    var offset = (new Date(date_start)).getTimezoneOffset();
    var current = date_start;
    var dst_change = null;
    while (current < date_end - iterator) {
      var dateToCheck = new Date(current);
      var dateToCheckOffset = dateToCheck.getTimezoneOffset();
      if (dateToCheckOffset !== offset) {
        dst_change = dateToCheck;
        break;
      }
      current += iterator;
    }
    if (padding === consts.DAY) {
      return find_dst_fold(dst_change, consts.HOUR, consts.MINUTE);
    }
    if (padding === consts.HOUR) {
      return find_dst_fold(dst_change, consts.MINUTE, consts.SECOND);
    }
    return dst_change;
  }, windows7_adaptations = function windows7_adaptions(rule_list, preliminary_timezone, score, sample) {
    if (score !== "N/A") {
      return score;
    }
    if (preliminary_timezone === "Asia/Beirut") {
      if (sample.name === "Africa/Cairo") {
        if (rule_list[6].s === 13983768E5 && rule_list[6].e === 14116788E5) {
          return 0;
        }
      }
      if (sample.name === "Asia/Jerusalem") {
        if (rule_list[6].s === 13959648E5 && rule_list[6].e === 14118588E5) {
          return 0;
        }
      }
    } else {
      if (preliminary_timezone === "America/Santiago") {
        if (sample.name === "America/Asuncion") {
          if (rule_list[6].s === 14124816E5 && rule_list[6].e === 1397358E6) {
            return 0;
          }
        }
        if (sample.name === "America/Campo_Grande") {
          if (rule_list[6].s === 14136912E5 && rule_list[6].e === 13925196E5) {
            return 0;
          }
        }
      } else {
        if (preliminary_timezone === "America/Montevideo") {
          if (sample.name === "America/Sao_Paulo") {
            if (rule_list[6].s === 14136876E5 && rule_list[6].e === 1392516E6) {
              return 0;
            }
          }
        } else {
          if (preliminary_timezone === "Pacific/Auckland") {
            if (sample.name === "Pacific/Fiji") {
              if (rule_list[6].s === 14142456E5 && rule_list[6].e === 13961016E5) {
                return 0;
              }
            }
          }
        }
      }
    }
    return score;
  }, best_dst_match = function best_dst_match(rule_list, preliminary_timezone) {
    var score_sample = function score_sample(sample) {
      var score = 0;
      for (var j = 0;j < rule_list.length;j++) {
        if (!!sample.rules[j] && !!rule_list[j]) {
          if (rule_list[j].s >= sample.rules[j].s && rule_list[j].e <= sample.rules[j].e) {
            score = 0;
            score += Math.abs(rule_list[j].s - sample.rules[j].s);
            score += Math.abs(sample.rules[j].e - rule_list[j].e);
          } else {
            score = "N/A";
            break;
          }
          if (score > consts.MAX_SCORE) {
            score = "N/A";
            break;
          }
        }
      }
      score = windows7_adaptations(rule_list, preliminary_timezone, score, sample);
      return score;
    };
    var scoreboard = {};
    var dst_zones = jstz.olson.dst_rules.zones;
    var dst_zones_length = dst_zones.length;
    var ambiguities = consts.AMBIGUITIES[preliminary_timezone];
    for (var i = 0;i < dst_zones_length;i++) {
      var sample = dst_zones[i];
      var score = score_sample(dst_zones[i]);
      if (score !== "N/A") {
        scoreboard[sample.name] = score;
      }
    }
    for (var tz in scoreboard) {
      if (scoreboard.hasOwnProperty(tz)) {
        for (var j = 0;j < ambiguities.length;j++) {
          if (ambiguities[j] === tz) {
            return tz;
          }
        }
      }
    }
    return preliminary_timezone;
  }, get_by_dst = function get_by_dst(preliminary_timezone) {
    var get_rules = function get_rules() {
      var rule_list = [];
      for (var i = 0;i < jstz.olson.dst_rules.years.length;i++) {
        var year_rules = dst_dates(jstz.olson.dst_rules.years[i]);
        rule_list.push(year_rules);
      }
      return rule_list;
    };
    var check_has_dst = function check_has_dst(rules) {
      for (var i = 0;i < rules.length;i++) {
        if (rules[i] !== false) {
          return true;
        }
      }
      return false;
    };
    var rules = get_rules();
    var has_dst = check_has_dst(rules);
    if (has_dst) {
      return best_dst_match(rules, preliminary_timezone);
    }
    return preliminary_timezone;
  }, determine = function determine() {
    var preliminary_tz = get_from_internationalization_api();
    if (!preliminary_tz) {
      preliminary_tz = jstz.olson.timezones[lookup_key()];
      if (typeof consts.AMBIGUITIES[preliminary_tz] !== "undefined") {
        preliminary_tz = get_by_dst(preliminary_tz);
      }
    }
    return {name:function() {
      return preliminary_tz;
    }};
  };
  return {determine:determine};
}();
jstz.olson = jstz.olson || {};
jstz.olson.timezones = {"-720,0":"Etc/GMT+12", "-660,0":"Pacific/Pago_Pago", "-660,1,s":"Pacific/Apia", "-600,1":"America/Adak", "-600,0":"Pacific/Honolulu", "-570,0":"Pacific/Marquesas", "-540,0":"Pacific/Gambier", "-540,1":"America/Anchorage", "-480,1":"America/Los_Angeles", "-480,0":"Pacific/Pitcairn", "-420,0":"America/Phoenix", "-420,1":"America/Denver", "-360,0":"America/Guatemala", "-360,1":"America/Chicago", "-360,1,s":"Pacific/Easter", "-300,0":"America/Bogota", "-300,1":"America/New_York", 
"-270,0":"America/Caracas", "-240,1":"America/Halifax", "-240,0":"America/Santo_Domingo", "-240,1,s":"America/Asuncion", "-210,1":"America/St_Johns", "-180,1":"America/Godthab", "-180,0":"America/Argentina/Buenos_Aires", "-180,1,s":"America/Montevideo", "-120,0":"America/Noronha", "-120,1":"America/Noronha", "-60,1":"Atlantic/Azores", "-60,0":"Atlantic/Cape_Verde", "0,0":"UTC", "0,1":"Europe/London", "60,1":"Europe/Berlin", "60,0":"Africa/Lagos", "60,1,s":"Africa/Windhoek", "120,1":"Asia/Beirut", 
"120,0":"Africa/Johannesburg", "180,0":"Asia/Baghdad", "180,1":"Europe/Moscow", "210,1":"Asia/Tehran", "240,0":"Asia/Dubai", "240,1":"Asia/Baku", "270,0":"Asia/Kabul", "300,1":"Asia/Yekaterinburg", "300,0":"Asia/Karachi", "330,0":"Asia/Kolkata", "345,0":"Asia/Kathmandu", "360,0":"Asia/Dhaka", "360,1":"Asia/Omsk", "390,0":"Asia/Rangoon", "420,1":"Asia/Krasnoyarsk", "420,0":"Asia/Jakarta", "480,0":"Asia/Shanghai", "480,1":"Asia/Irkutsk", "525,0":"Australia/Eucla", "525,1,s":"Australia/Eucla", "540,1":"Asia/Yakutsk", 
"540,0":"Asia/Tokyo", "570,0":"Australia/Darwin", "570,1,s":"Australia/Adelaide", "600,0":"Australia/Brisbane", "600,1":"Asia/Vladivostok", "600,1,s":"Australia/Sydney", "630,1,s":"Australia/Lord_Howe", "660,1":"Asia/Kamchatka", "660,0":"Pacific/Noumea", "690,0":"Pacific/Norfolk", "720,1,s":"Pacific/Auckland", "720,0":"Pacific/Majuro", "765,1,s":"Pacific/Chatham", "780,0":"Pacific/Tongatapu", "780,1,s":"Pacific/Apia", "840,0":"Pacific/Kiritimati"};
jstz.olson.dst_rules = {"years":[2008, 2009, 2010, 2011, 2012, 2013, 2014], "zones":[{"name":"Africa/Cairo", "rules":[{"e":12199572E5, "s":12090744E5}, {"e":1250802E6, "s":1240524E6}, {"e":12858804E5, "s":12840696E5}, false, false, false, {"e":14116788E5, "s":1406844E6}]}, {"name":"Africa/Casablanca", "rules":[{"e":12202236E5, "s":12122784E5}, {"e":12508092E5, "s":12438144E5}, {"e":1281222E6, "s":12727584E5}, {"e":13120668E5, "s":13017888E5}, {"e":13489704E5, "s":1345428E6}, {"e":13828392E5, "s":13761E8}, 
{"e":14142888E5, "s":14069448E5}]}, {"name":"America/Asuncion", "rules":[{"e":12050316E5, "s":12243888E5}, {"e":12364812E5, "s":12558384E5}, {"e":12709548E5, "s":12860784E5}, {"e":13024044E5, "s":1317528E6}, {"e":1333854E6, "s":13495824E5}, {"e":1364094E6, "s":1381032E6}, {"e":13955436E5, "s":14124816E5}]}, {"name":"America/Campo_Grande", "rules":[{"e":12032172E5, "s":12243888E5}, {"e":12346668E5, "s":12558384E5}, {"e":12667212E5, "s":1287288E6}, {"e":12981708E5, "s":13187376E5}, {"e":13302252E5, 
"s":1350792E6}, {"e":136107E7, "s":13822416E5}, {"e":13925196E5, "s":14136912E5}]}, {"name":"America/Goose_Bay", "rules":[{"e":122559486E4, "s":120503526E4}, {"e":125704446E4, "s":123648486E4}, {"e":128909886E4, "s":126853926E4}, {"e":13205556E5, "s":129998886E4}, {"e":13520052E5, "s":13314456E5}, {"e":13834548E5, "s":13628952E5}, {"e":14149044E5, "s":13943448E5}]}, {"name":"America/Havana", "rules":[{"e":12249972E5, "s":12056436E5}, {"e":12564468E5, "s":12364884E5}, {"e":12885012E5, "s":12685428E5}, 
{"e":13211604E5, "s":13005972E5}, {"e":13520052E5, "s":13332564E5}, {"e":13834548E5, "s":13628916E5}, {"e":14149044E5, "s":13943412E5}]}, {"name":"America/Mazatlan", "rules":[{"e":1225008E6, "s":12074724E5}, {"e":12564576E5, "s":1238922E6}, {"e":1288512E6, "s":12703716E5}, {"e":13199616E5, "s":13018212E5}, {"e":13514112E5, "s":13332708E5}, {"e":13828608E5, "s":13653252E5}, {"e":14143104E5, "s":13967748E5}]}, {"name":"America/Mexico_City", "rules":[{"e":12250044E5, "s":12074688E5}, {"e":1256454E6, 
"s":12389184E5}, {"e":12885084E5, "s":1270368E6}, {"e":1319958E6, "s":13018176E5}, {"e":13514076E5, "s":13332672E5}, {"e":13828572E5, "s":13653216E5}, {"e":14143068E5, "s":13967712E5}]}, {"name":"America/Miquelon", "rules":[{"e":12255984E5, "s":12050388E5}, {"e":1257048E6, "s":12364884E5}, {"e":12891024E5, "s":12685428E5}, {"e":1320552E6, "s":12999924E5}, {"e":13520016E5, "s":1331442E6}, {"e":13834512E5, "s":13628916E5}, {"e":14149008E5, "s":13943412E5}]}, {"name":"America/Santa_Isabel", "rules":[{"e":12250116E5, 
"s":1207476E6}, {"e":12564612E5, "s":12389256E5}, {"e":12885156E5, "s":12703752E5}, {"e":13199652E5, "s":13018248E5}, {"e":13514148E5, "s":13332744E5}, {"e":13828644E5, "s":13653288E5}, {"e":1414314E6, "s":13967784E5}]}, {"name":"America/Santiago", "rules":[{"e":1206846E6, "s":1223784E6}, {"e":1237086E6, "s":12552336E5}, {"e":127035E7, "s":12866832E5}, {"e":13048236E5, "s":13138992E5}, {"e":13356684E5, "s":13465584E5}, {"e":1367118E6, "s":13786128E5}, {"e":13985676E5, "s":14100624E5}]}, {"name":"America/Sao_Paulo", 
"rules":[{"e":12032136E5, "s":12243852E5}, {"e":12346632E5, "s":12558348E5}, {"e":12667176E5, "s":12872844E5}, {"e":12981672E5, "s":1318734E6}, {"e":13302216E5, "s":13507884E5}, {"e":13610664E5, "s":1382238E6}, {"e":1392516E6, "s":14136876E5}]}, {"name":"Asia/Amman", "rules":[{"e":1225404E6, "s":12066552E5}, {"e":12568536E5, "s":12381048E5}, {"e":12883032E5, "s":12695544E5}, {"e":13197528E5, "s":13016088E5}, false, false, {"e":14147064E5, "s":13959576E5}]}, {"name":"Asia/Damascus", "rules":[{"e":12254868E5, 
"s":120726E7}, {"e":125685E7, "s":12381048E5}, {"e":12882996E5, "s":12701592E5}, {"e":13197492E5, "s":13016088E5}, {"e":13511988E5, "s":13330584E5}, {"e":13826484E5, "s":1364508E6}, {"e":14147028E5, "s":13959576E5}]}, {"name":"Asia/Dubai", "rules":[false, false, false, false, false, false, false]}, {"name":"Asia/Gaza", "rules":[{"e":12199572E5, "s":12066552E5}, {"e":12520152E5, "s":12381048E5}, {"e":1281474E6, "s":126964086E4}, {"e":1312146E6, "s":130160886E4}, {"e":13481784E5, "s":13330584E5}, {"e":13802292E5, 
"s":1364508E6}, {"e":1414098E6, "s":13959576E5}]}, {"name":"Asia/Irkutsk", "rules":[{"e":12249576E5, "s":12068136E5}, {"e":12564072E5, "s":12382632E5}, {"e":12884616E5, "s":12697128E5}, false, false, false, false]}, {"name":"Asia/Jerusalem", "rules":[{"e":12231612E5, "s":12066624E5}, {"e":1254006E6, "s":1238112E6}, {"e":1284246E6, "s":12695616E5}, {"e":131751E7, "s":1301616E6}, {"e":13483548E5, "s":13330656E5}, {"e":13828284E5, "s":13645152E5}, {"e":1414278E6, "s":13959648E5}]}, {"name":"Asia/Kamchatka", 
"rules":[{"e":12249432E5, "s":12067992E5}, {"e":12563928E5, "s":12382488E5}, {"e":12884508E5, "s":12696984E5}, false, false, false, false]}, {"name":"Asia/Krasnoyarsk", "rules":[{"e":12249612E5, "s":12068172E5}, {"e":12564108E5, "s":12382668E5}, {"e":12884652E5, "s":12697164E5}, false, false, false, false]}, {"name":"Asia/Omsk", "rules":[{"e":12249648E5, "s":12068208E5}, {"e":12564144E5, "s":12382704E5}, {"e":12884688E5, "s":126972E7}, false, false, false, false]}, {"name":"Asia/Vladivostok", "rules":[{"e":12249504E5, 
"s":12068064E5}, {"e":12564E8, "s":1238256E6}, {"e":12884544E5, "s":12697056E5}, false, false, false, false]}, {"name":"Asia/Yakutsk", "rules":[{"e":1224954E6, "s":120681E7}, {"e":12564036E5, "s":12382596E5}, {"e":1288458E6, "s":12697092E5}, false, false, false, false]}, {"name":"Asia/Yekaterinburg", "rules":[{"e":12249684E5, "s":12068244E5}, {"e":1256418E6, "s":1238274E6}, {"e":12884724E5, "s":12697236E5}, false, false, false, false]}, {"name":"Asia/Yerevan", "rules":[{"e":1224972E6, "s":1206828E6}, 
{"e":12564216E5, "s":12382776E5}, {"e":1288476E6, "s":12697272E5}, {"e":13199256E5, "s":13011768E5}, false, false, false]}, {"name":"Australia/Lord_Howe", "rules":[{"e":12074076E5, "s":12231342E5}, {"e":12388572E5, "s":12545838E5}, {"e":12703068E5, "s":12860334E5}, {"e":13017564E5, "s":1317483E6}, {"e":1333206E6, "s":13495374E5}, {"e":13652604E5, "s":1380987E6}, {"e":139671E7, "s":14124366E5}]}, {"name":"Australia/Perth", "rules":[{"e":12068136E5, "s":12249576E5}, false, false, false, false, false, 
false]}, {"name":"Europe/Helsinki", "rules":[{"e":12249828E5, "s":12068388E5}, {"e":12564324E5, "s":12382884E5}, {"e":12884868E5, "s":1269738E6}, {"e":13199364E5, "s":13011876E5}, {"e":1351386E6, "s":13326372E5}, {"e":13828356E5, "s":13646916E5}, {"e":14142852E5, "s":13961412E5}]}, {"name":"Europe/Minsk", "rules":[{"e":12249792E5, "s":12068352E5}, {"e":12564288E5, "s":12382848E5}, {"e":12884832E5, "s":12697344E5}, false, false, false, false]}, {"name":"Europe/Moscow", "rules":[{"e":12249756E5, "s":12068316E5}, 
{"e":12564252E5, "s":12382812E5}, {"e":12884796E5, "s":12697308E5}, false, false, false, false]}, {"name":"Pacific/Apia", "rules":[false, false, false, {"e":13017528E5, "s":13168728E5}, {"e":13332024E5, "s":13489272E5}, {"e":13652568E5, "s":13803768E5}, {"e":13967064E5, "s":14118264E5}]}, {"name":"Pacific/Fiji", "rules":[false, false, {"e":12696984E5, "s":12878424E5}, {"e":13271544E5, "s":1319292E6}, {"e":1358604E6, "s":13507416E5}, {"e":139005E7, "s":1382796E6}, {"e":14215032E5, "s":14148504E5}]}, 
{"name":"Europe/London", "rules":[{"e":12249828E5, "s":12068388E5}, {"e":12564324E5, "s":12382884E5}, {"e":12884868E5, "s":1269738E6}, {"e":13199364E5, "s":13011876E5}, {"e":1351386E6, "s":13326372E5}, {"e":13828356E5, "s":13646916E5}, {"e":14142852E5, "s":13961412E5}]}]};
(function(root, factory) {
  if (typeof module == "object" && module.exports) {
    module.exports = factory();
  } else {
    if (typeof define == "function" && define.amd) {
      define(factory);
    } else {
      root.Spinner = factory();
    }
  }
})(this, function() {
  var prefixes = ["webkit", "Moz", "ms", "O"], animations = {}, useCssAnimations, sheet;
  function createEl(tag, prop) {
    var el = document.createElement(tag || "div"), n;
    for (n in prop) {
      el[n] = prop[n];
    }
    return el;
  }
  function ins(parent) {
    for (var i = 1, n = arguments.length;i < n;i++) {
      parent.appendChild(arguments[i]);
    }
    return parent;
  }
  function addAnimation(alpha, trail, i, lines) {
    var name = ["opacity", trail, ~~(alpha * 100), i, lines].join("-"), start = .01 + i / lines * 100, z = Math.max(1 - (1 - alpha) / trail * (100 - start), alpha), prefix = useCssAnimations.substring(0, useCssAnimations.indexOf("Animation")).toLowerCase(), pre = prefix && "-" + prefix + "-" || "";
    if (!animations[name]) {
      sheet.insertRule("@" + pre + "keyframes " + name + "{" + "0%{opacity:" + z + "}" + start + "%{opacity:" + alpha + "}" + (start + .01) + "%{opacity:1}" + (start + trail) % 100 + "%{opacity:" + alpha + "}" + "100%{opacity:" + z + "}" + "}", sheet.cssRules.length);
      animations[name] = 1;
    }
    return name;
  }
  function vendor(el, prop) {
    var s = el.style, pp, i;
    prop = prop.charAt(0).toUpperCase() + prop.slice(1);
    if (s[prop] !== undefined) {
      return prop;
    }
    for (i = 0;i < prefixes.length;i++) {
      pp = prefixes[i] + prop;
      if (s[pp] !== undefined) {
        return pp;
      }
    }
  }
  function css(el, prop) {
    for (var n in prop) {
      el.style[vendor(el, n) || n] = prop[n];
    }
    return el;
  }
  function merge(obj) {
    for (var i = 1;i < arguments.length;i++) {
      var def = arguments[i];
      for (var n in def) {
        if (obj[n] === undefined) {
          obj[n] = def[n];
        }
      }
    }
    return obj;
  }
  function getColor(color, idx) {
    return typeof color == "string" ? color : color[idx % color.length];
  }
  var defaults = {lines:12, length:7, width:5, radius:10, scale:1, corners:1, color:"#000", opacity:1 / 4, rotate:0, direction:1, speed:1, trail:100, fps:20, zIndex:2E9, className:"spinner", top:"50%", left:"50%", shadow:false, hwaccel:false, position:"absolute"};
  function Spinner(o) {
    this.opts = merge(o || {}, Spinner.defaults, defaults);
  }
  Spinner.defaults = {};
  merge(Spinner.prototype, {spin:function(target) {
    this.stop();
    var self = this, o = self.opts, el = self.el = createEl(null, {className:o.className});
    css(el, {position:o.position, width:0, zIndex:o.zIndex, left:o.left, top:o.top});
    if (target) {
      target.insertBefore(el, target.firstChild || null);
    }
    el.setAttribute("role", "progressbar");
    self.lines(el, self.opts);
    if (!useCssAnimations) {
      var i = 0, start = (o.lines - 1) * (1 - o.direction) / 2, alpha, fps = o.fps, f = fps / o.speed, ostep = (1 - o.opacity) / (f * o.trail / 100), astep = f / o.lines;
      (function anim() {
        i++;
        for (var j = 0;j < o.lines;j++) {
          alpha = Math.max(1 - (i + (o.lines - j) * astep) % f * ostep, o.opacity);
          self.opacity(el, j * o.direction + start, alpha, o);
        }
        self.timeout = self.el && setTimeout(anim, ~~(1E3 / fps));
      })();
    }
    return self;
  }, stop:function() {
    var el = this.el;
    if (el) {
      clearTimeout(this.timeout);
      if (el.parentNode) {
        el.parentNode.removeChild(el);
      }
      this.el = undefined;
    }
    return this;
  }, lines:function(el, o) {
    var i = 0, start = (o.lines - 1) * (1 - o.direction) / 2, seg;
    function fill(color, shadow) {
      return css(createEl(), {position:"absolute", width:o.scale * (o.length + o.width) + "px", height:o.scale * o.width + "px", background:color, boxShadow:shadow, transformOrigin:"left", transform:"rotate(" + ~~(360 / o.lines * i + o.rotate) + "deg) translate(" + o.scale * o.radius + "px" + ",0)", borderRadius:(o.corners * o.scale * o.width >> 1) + "px"});
    }
    for (;i < o.lines;i++) {
      seg = css(createEl(), {position:"absolute", top:1 + ~(o.scale * o.width / 2) + "px", transform:o.hwaccel ? "translate3d(0,0,0)" : "", opacity:o.opacity, animation:useCssAnimations && addAnimation(o.opacity, o.trail, start + i * o.direction, o.lines) + " " + 1 / o.speed + "s linear infinite"});
      if (o.shadow) {
        ins(seg, css(fill("#000", "0 0 4px #000"), {top:"2px"}));
      }
      ins(el, ins(seg, fill(getColor(o.color, i), "0 0 1px rgba(0,0,0,.1)")));
    }
    return el;
  }, opacity:function(el, i, val) {
    if (i < el.childNodes.length) {
      el.childNodes[i].style.opacity = val;
    }
  }});
  function initVML() {
    function vml(tag, attr) {
      return createEl("<" + tag + ' xmlns="urn:schemas-microsoft.com:vml" class="spin-vml">', attr);
    }
    sheet.addRule(".spin-vml", "behavior:url(#default#VML)");
    Spinner.prototype.lines = function(el, o) {
      var r = o.scale * (o.length + o.width), s = o.scale * 2 * r;
      function grp() {
        return css(vml("group", {coordsize:s + " " + s, coordorigin:-r + " " + -r}), {width:s, height:s});
      }
      var margin = -(o.width + o.length) * o.scale * 2 + "px", g = css(grp(), {position:"absolute", top:margin, left:margin}), i;
      function seg(i, dx, filter) {
        ins(g, ins(css(grp(), {rotation:360 / o.lines * i + "deg", left:~~dx}), ins(css(vml("roundrect", {arcsize:o.corners}), {width:r, height:o.scale * o.width, left:o.scale * o.radius, top:-o.scale * o.width >> 1, filter:filter}), vml("fill", {color:getColor(o.color, i), opacity:o.opacity}), vml("stroke", {opacity:0}))));
      }
      if (o.shadow) {
        for (i = 1;i <= o.lines;i++) {
          seg(i, -2, "progid:DXImageTransform.Microsoft.Blur(pixelradius=2,makeshadow=1,shadowopacity=.3)");
        }
      }
      for (i = 1;i <= o.lines;i++) {
        seg(i);
      }
      return ins(el, g);
    };
    Spinner.prototype.opacity = function(el, i, val, o) {
      var c = el.firstChild;
      o = o.shadow && o.lines || 0;
      if (c && i + o < c.childNodes.length) {
        c = c.childNodes[i + o];
        c = c && c.firstChild;
        c = c && c.firstChild;
        if (c) {
          c.opacity = val;
        }
      }
    };
  }
  if (typeof document !== "undefined") {
    sheet = function() {
      var el = createEl("style", {type:"text/css"});
      ins(document.getElementsByTagName("head")[0], el);
      return el.sheet || el.styleSheet;
    }();
    var probe = css(createEl("group"), {behavior:"url(#default#VML)"});
    if (!vendor(probe, "transform") && probe.adj) {
      initVML();
    } else {
      useCssAnimations = vendor(probe, "animation");
    }
  }
  return Spinner;
});
goog.provide("CTATConfig");
CTATConfig = {};
CTATConfig.Options = {};
CTATConfig.addProperty = function(property_name, possible_values, default_value, is_constant) {
  default_value = default_value || possible_values[0];
  Object.defineProperty(CTATConfig, property_name, {enumerable:true, configurable:false, writable:!is_constant, value:default_value.toLowerCase()});
  var opts = {};
  possible_values.forEach(function(opt) {
    opts[opt] = opt.toLowerCase();
    Object.defineProperty(CTATConfig, property_name + "_is_" + opt, {enumerable:false, writable:false, value:function() {
      return CTATConfig[this.prop].toLowerCase() == this.val;
    }.bind({prop:property_name, val:opts[opt]})});
  });
  CTATConfig.Options[property_name] = opts;
};
CTATConfig.addProperty("platform", ["CTAT", "Google", "Undefined"], "CTAT", true);
CTATConfig.addProperty("external", ["Google", "LTI", "SCORM", "None"], "None");
CTATConfig.addProperty("parserType", ["XML", "JSON"], "XML");
if (typeof module !== "undefined") {
  module.exports = CTATConfig;
}
if (window && window.console) {
}
;goog.provide("CTATGlobals");
CTATGlobals = {tutorRunning:false, Tab:{Tracker:1, Focus:null, previousFocus:null}, NameSpace:{svg:"http://www.w3.org/2000/svg", xml:"http://www.w3.org/2000/xmlns/", xlink:"http://www.w3.org/1999/xlink", ev:"http://www.w3.org/2001/xml-events", mathml:"http://www.w3.org/1998/Math/MathML"}, EncodedParams:{authenticity_token:"authenticity_token", info:"info", question_file:"question_file", skills:"skills"}, CommDisabled:false, orientation:"portrait", ignoreInterfaceDescriptions:true};
var useDebugging;
if (useDebugging === undefined) {
  useDebugging = false;
}
var useDebuggingBasic;
if (useDebuggingBasic === undefined) {
  useDebuggingBasic = false;
}
var version = "3.2.1";
var ctatcontainer = "container";
var movieclips = [];
var canvasCalibrate = 5;
var flashVars = null;
var mobileAPI = null;
var aVars = null;
CTATGlobals.interfaceElement = null;
CTATGlobals.selectedTextInput = null;
var commMessageHandler = null;
var commLoggingLibrary = null;
var logHintSAI = null;
var nameTranslator = null;
var hints = [];
var hintIndex = 0;
var caseInsensitive = true;
var unordered = true;
var lockWidget = true;
var highlightRightSelection = true;
CTATGlobals.suppressStudentFeedback = false;
CTATGlobals.confirmDone = false;
var incompatibleBrowserMessage = "Your browser does not support CTAT. Please update or replace your browser.";
goog.provide("CTATSandboxDriver");
function getSafeElementById(anID) {
  return document.getElementById(anID);
}
;goog.provide("CTATGlobalFunctions");
goog.require("CTATConfig");
goog.require("CTATGlobals");
goog.require("CTATSandboxDriver");
CTATGlobalFunctions = {};
function unhighlightall(dummy) {
  if (!CTATShellTools.component_descriptions) {
    return;
  }
  var comps = CTATShellTools.getAllComponents();
  for (var i = 0;i < comps.length;i++) {
    var ref = comps[i];
    if (ref["setHintHighlight"]) {
      ref.setHintHighlight(false, null);
    }
  }
}
CTATGlobalFunctions.stringToBoolean = function stringToBoolean(str) {
  switch(String(str).toLowerCase()) {
    case "true":
    ;
    case "yes":
    ;
    case "1":
      return true;
    case "false":
    ;
    case "no":
    ;
    case "0":
    ;
    case "":
    ;
    case null:
      return false;
    default:
      return Boolean(str);
  }
};
CTATGlobalFunctions.isInstructorMode = function() {
  var vars = flashVars ? flashVars.getRawFlashVars() : null;
  if (vars && vars["deliverymode"]) {
    return vars["deliverymode"] == "delivery" ? false : true;
  } else {
    return false;
  }
};
CTATGlobalFunctions.getLoggingLibrary = function(getLoggingLibrary) {
  if (commLoggingLibrary == null) {
    commLoggingLibrary = new CTATLoggingLibrary(true);
  }
  return commLoggingLibrary;
};
CTATGlobalFunctions.setPreviewMode = function(aConfigurationObject, aValue) {
  if (!CTATGlobalFunctions.isCTATObject(aConfigurationObject)) {
    aConfigurationObject["previewMode"] = aValue;
    return;
  }
  aConfigurationObject.setPreviewMode(aValue);
};
CTATGlobalFunctions.setCenterTutor = function(aConfigurationObject, aValue) {
  if (!CTATGlobalFunctions.isCTATObject(aConfigurationObject)) {
    aConfigurationObject["centerTutor"] = aValue;
    return;
  }
  aConfigurationObject.setCenterTutor(aValue);
};
CTATGlobalFunctions.setTutorWidth = function(aConfigurationObject, w) {
  if (!CTATGlobalFunctions.isCTATObject(aConfigurationObject)) {
    aConfigurationObject["width"] = w;
    return;
  }
  aConfigurationObject.setTutorWidth(w);
};
CTATGlobalFunctions.setTutorHeight = function(aConfigurationObject, h) {
  if (!CTATGlobalFunctions.isCTATObject(aConfigurationObject)) {
    aConfigurationObject["height"] = h;
    return;
  }
  aConfigurationObject.setTutorHeight(h);
};
CTATGlobalFunctions.setTutorDimensions = function(aConfigurationObject, w, h) {
  if (!CTATGlobalFunctions.isCTATObject(aConfigurationObject)) {
    aConfigurationObject["width"] = w;
    aConfigurationObject["height"] = h;
    return;
  }
  aConfigurationObject.setTutorDimensions(w, h);
};
CTATGlobalFunctions.setTutorValue = function(aConfigurationObject, aKey, aValue) {
  if (!CTATGlobalFunctions.isCTATObject(aConfigurationObject)) {
    aConfigurationObject[aKey] = aValue;
    return;
  }
  aConfigurationObject.setTutorValue(aKey, aValue);
};
CTATGlobalFunctions.setCommunicationMode = function(aConfigurationObject, aMode) {
  if (!CTATGlobalFunctions.isCTATObject(aConfigurationObject)) {
    aConfigurationObject["tutoring_service_communication"] = aMode;
    return;
  }
  aConfigurationObject.setCommunicationMode(aMode);
};
CTATGlobalFunctions.setRemoteSocketURL = function(aConfigurationObject, aURL) {
  if (!CTATGlobalFunctions.isCTATObject(aConfigurationObject)) {
    aConfigurationObject["remoteSocketURL"] = aURL;
    return;
  }
  aConfigurationObject.setRemoteSocketURL(aURL);
};
CTATGlobalFunctions.setRemoteSocketPort = function(aConfigurationObject, aPort) {
  if (!CTATGlobalFunctions.isCTATObject(aConfigurationObject)) {
    aConfigurationObject["remoteSocketPort"] = aPort;
    return;
  }
  aConfigurationObject.setRemoteSocketPort(aPort);
};
CTATGlobalFunctions.setProblemSummary = function(aSummary) {
};
CTATGlobalFunctions.isCTATObject = function(aVariable) {
  if (typeof testConfig == "object") {
    if (testConfig["getClassName"]) {
      return true;
    } else {
    }
  }
  return false;
};
CTATGlobalFunctions.getCTATClassname = function(aVariable) {
  if (typeof testConfig == "object") {
    if (testConfig["getClassName"]) {
      return testConfig.getClassName();
    } else {
    }
  }
  return "object";
};
CTATGlobalFunctions.toBoolean = function(value) {
  if (typeof value === "boolean") {
    return value;
  } else {
    if (typeof value === "string") {
      return CTATGlobalFunctions.stringToBoolean(value);
    } else {
      if (typeof value === "number") {
        return value > 0;
      } else {
        if (value) {
          return true;
        } else {
          return false;
        }
      }
    }
  }
};
function noenter(e) {
  if (CTATConfig.platform_is_Google()) {
    return 0;
  }
  e = e || window.event;
  var key = e.keyCode || e.charCode;
  return key !== 13;
}
CTATGlobalFunctions.isBlank = function isBlank(str) {
  return !str || /^\s*$/.test(str);
};
function componentToHex(c) {
  var hex = c.toString(16);
  return hex.length == 1 ? "0" + hex : hex;
}
function rgbToHex(r, g, b) {
  return "#" + componentToHex(r) + componentToHex(g) + componentToHex(b);
}
function hexToRgb(hex) {
  var result = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(hex);
  return result ? {r:parseInt(result[1], 16), g:parseInt(result[2], 16), b:parseInt(result[3], 16)} : null;
}
function parseQueryStringArgs(aQuerySet) {
  ctatdebug("parseQueryStringArgs ()");
  var str = aQuerySet;
  ctatdebug("Query String: " + str);
  var query = str.charAt(0) == "?" ? str.substring(1) : str;
  var args = {};
  if (query) {
    var fields = query.split("&");
    for (var f = 0;f < fields.length;f++) {
      var field = fields[f].split("=");
      args[decodeURIComponent(field[0])] = decodeURIComponent(field[1].replace(/\+/g, " "));
    }
  }
  return args;
}
function setOrientation(anOrientation) {
  ctatdebug("setOrientation (" + anOrientation + ")");
  switch(anOrientation) {
    case -90:
    ;
    case 90:
      if (mobileAPI) {
        mobileAPI.processOrientationChange("landscape");
      }
      break;
    case 180:
    ;
    default:
      if (mobileAPI) {
        mobileAPI.processOrientationChange("portrait");
      }
      break;
  }
}
if (!Object.hasOwnProperty("create")) {
  Object.create = function() {
    function F() {
    }
    return function(o) {
      if (arguments.length != 1) {
        throw new Error("Object.create implementation only accepts one parameter.");
      }
      F.prototype = o;
      return new F;
    };
  }();
}
function thisMovie(movieName) {
  if (navigator.appName.indexOf("Microsoft") != -1) {
    return window[movieName];
  } else {
    return document[movieName];
  }
}
function introspect(name, obj, indent, levels) {
  indent = indent || "";
  if (this.typeOf(levels) !== "number") {
    levels = 1;
  }
  var objType = this.typeOf(obj);
  var result = [indent, name, " ", objType, " :"].join("");
  if (objType === "object") {
    if (levels > 0) {
      indent = [indent, "  "].join("");
      for (var prop in obj) {
        var property = this.introspect(prop, obj[prop], indent, levels - 1);
        result = [result, "\n", property].join("");
      }
      return result;
    } else {
      return [result, " ..."].join("");
    }
  } else {
    if (objType === "null") {
      return [result, " null"].join("");
    }
  }
  return [result, " ", obj].join("");
}
function findPointOfAttachment(anInstance) {
  ctatdebug("findPointOfAttachment (" + anInstance + ")");
  for (var t = 0;t < movieclips.length;t++) {
    var aMovieClip = movieclips[t];
    ctatdebug("Examining: " + aMovieClip.getName() + "...");
    if (aMovieClip.isRegistered(anInstance) === true) {
      return aMovieClip;
    }
  }
  return null;
}
function findMovieClip(anInstance) {
  var formatted = anInstance.trim();
  ctatdebug("findMovieClip (" + formatted.trim() + ")");
  for (var t = 0;t < movieclips.length;t++) {
    var aMovieClip = movieclips[t];
    ctatdebug("Examining: " + aMovieClip.getName() + "...");
    if (aMovieClip.getName() == formatted) {
      return aMovieClip;
    }
  }
  return null;
}
function colName(n, toUpperCase) {
  ctatdebug("colName (" + n + ")");
  var s = "";
  while (n >= 0) {
    s = String.fromCharCode(n % 26 + 97) + s;
    n = Math.floor(n / 26) - 1;
  }
  if (toUpperCase === true) {
    s.toUpperCase();
  }
  return s;
}
function selectText(target) {
}
function urldecode(str) {
  return decodeURIComponent(("" + str).replace(/\+/g, "%20"));
}
function detectIE() {
  var ua = window.navigator.userAgent;
  var msie = ua.indexOf("MSIE ");
  var trident = ua.indexOf("Trident/");
  if (msie > 0) {
    return parseInt(ua.substring(msie + 5, ua.indexOf(".", msie)), 10);
  }
  if (trident > 0) {
    var rv = ua.indexOf("rv:");
    return parseInt(ua.substring(rv + 3, ua.indexOf(".", rv)), 10);
  }
  return false;
}
function listProperties(anObject) {
  ctatdebug("listProperties (l: " + anObject.length + ")");
  for (var propertyName in anObject) {
    ctatdebug("[" + propertyName + "]");
  }
}
function listPropertiesKV(anObject, asArray) {
  ctatdebug("listPropertiesKV (size: " + anObject.length + ")");
  if (asArray == true) {
    for (var i = 0;i < anObject.length;i++) {
      ctatdebug("[" + i + "]: " + anObject[i]);
    }
  } else {
    for (var propertyName in anObject) {
      ctatdebug("[" + propertyName + "]: " + anObject[propertyName]);
    }
  }
}
function listAllDivAttributes(aDivObject) {
  ctatdebug("listAllDivAttributes ()");
  for (var i = 0, atts = aDivObject.attributes, n = atts.length, arr = [];i < n;i++) {
    pointer.ctatdebug("Attribute: " + atts[i].nodeName + ", with value: " + atts[i].nodeValue);
  }
}
var getBackgroundDimensions = function(item) {
  ctatdebug("Using url: " + $(item).css("background-image"));
  var img = new Image;
  img.src = $(item).css("background-image").replace(/url\(|\)$|"/ig, "");
  return img.width + " " + img.height;
};
var getBackgroundWidth = function(item) {
  ctatdebug("Using url: " + $(item).css("background-image"));
  var img = new Image;
  img.src = $(item).css("background-image").replace(/url\(|\)$|"/ig, "");
  return img.width;
};
var getBackgroundHeight = function(item) {
  ctatdebug("Using url: " + $(item).css("background-image"));
  var img = new Image;
  img.src = $(item).css("background-image").replace(/url\(|\)$|"/ig, "");
  return img.height;
};
function getIndicesOf(searchStr, str, caseSensitive) {
  var startIndex = 0, searchStrLen = searchStr.length;
  var index, indices = [];
  if (!caseSensitive) {
    str = str.toLowerCase();
    searchStr = searchStr.toLowerCase();
  }
  while ((index = str.indexOf(searchStr, startIndex)) > -1) {
    indices.push(index);
    startIndex = index + searchStrLen;
  }
  return indices;
}
CTATGlobalFunctions.formatColor = function(aColor) {
  if (/^#[0-9a-f]{6}$/i.test(aColor)) {
    return aColor;
  }
  var rgb = aColor.match(/rgb\s*\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*\)/i);
  if (rgb !== null) {
    return rgbToHex(Number(rgb[1]), Number(rgb[2]), Number(rgb[3]));
  }
  var hex = aColor.match(/^#?([0-9a-f]{0,6})$/i);
  if (hex !== null) {
    var c = hex[1];
    while (c.length < 6) {
      c = "0" + c;
    }
    return "#" + c;
  }
  return aColor;
};
CTATGlobalFunctions.Gensym = function() {
  this.make_gensym = function() {
    var prefix = "";
    var index = 0;
    return {set_prefix:function(p) {
      prefix = String(p);
    }, set_index:function(i) {
      index = i;
    }, gensym:function() {
      var result = prefix + index;
      index += 1;
      return result;
    }};
  };
  var z_index = this.make_gensym();
  z_index.set_index(2);
  var id_index = this.make_gensym();
  id_index.set_index(1);
  id_index.set_prefix("ctatdiv");
  return {z_index:z_index.gensym, div_id:id_index.gensym};
};
CTATGlobalFunctions.gensym = CTATGlobalFunctions.Gensym();
goog.provide("CTATBase");
goog.require("CTATConfig");
goog.require("CTATGlobalFunctions");
goog.require("CTATGlobals");
goog.require("CTATSandboxDriver");
CTATBase = function(aClassName, aName) {
  var className = aClassName;
  var name = aName;
  var pointer = this;
  var myDebugging = true;
  if (CTATBase["DebuggingFilter"][className] != "undefined" && CTATBase["DebuggingFilter"][className]) {
    myDebugging = false;
  }
  this.getClassName = function getClassName() {
    return className;
  };
  this.getClassname = function getClassname() {
    return className;
  };
  this.setClassName = function setClassName(aClass) {
    className = aClass;
  };
  this.setName = function setName(sName) {
    name = sName;
  };
  this.getName = function getName() {
    return name;
  };
  this.getUseDebugging = function getUseDebugging() {
    return useDebugging;
  };
  this.setUseDebugging = function setUseDebugging(aValue) {
    useDebugging = aValue;
  };
  this.toHHMMSS = function(aValue) {
    var sec_num = parseInt(aValue, 10);
    var hours = Math.floor(sec_num / 3600);
    var minutes = Math.floor((sec_num - hours * 3600) / 60);
    var seconds = sec_num - hours * 3600 - minutes * 60;
    if (hours < 10) {
      hours = "0" + hours;
    }
    if (minutes < 10) {
      minutes = "0" + minutes;
    }
    if (seconds < 10) {
      seconds = "0" + seconds;
    }
    return hours + ":" + minutes + ":" + seconds;
  };
  this.ctatdebug = function ctatdebug(msg) {
    if (!myDebugging) {
      return;
    }
    var aMessage = msg;
    if (useDebuggingBasic) {
      pointer.ctatdebugInternal(aMessage, "UnknownClass");
      return;
    }
    if (msg === null) {
      aMessage = "No message provided";
    }
    if (useDebugging) {
      pointer.ctatdebugInternal(aMessage, pointer.getClassName());
    }
  };
  this.ctatdebugObject = function debugObject(object) {
    var index = 0;
    for (var property in object) {
      this.ctatdebug("(" + index + ")" + property + ": " + object[property]);
      index++;
    }
  };
  this.ctatdebugInternal = function debugInternal(msg, sClassName) {
    var aMessage = msg;
    var txt = "No msg assigned yet";
    if (aMessage === null || aMessage === undefined) {
      aMessage = "No message!";
    }
    if (aMessage === "") {
      aMessage = "Empty message!";
    }
    if (useDebuggingBasic) {
      txt = formatLogMessage("Unknown", "undefined", aMessage);
      if (!CTATBase.customconsole) {
        CTATBase.customconsole = getSafeElementById("customconsole");
      }
      if (CTATBase.customconsole) {
        CTATBase.customconsole.innerHTML += txt + "<br>";
        CTATBase.customconsole.scrollTop = CTATBase.customconsole.scrollHeight;
      } else {
        console.log(txt);
      }
      return;
    }
    if (sClassName === null) {
      sClassName = "UndefinedClass";
    }
    if (aMessage === null) {
      aMessage = "No message";
    }
    txt = formatLogMessage(sClassName, pointer.getName(), aMessage);
    try {
      console.trace(txt);
    } catch (err) {
    }
    if (CTATConfig.platform == "google") {
      Logger.log(txt);
      return;
    }
    if (!CTATBase.customconsole) {
      CTATBase.customconsole = getSafeElementById("customconsole");
    }
    if (CTATBase.customconsole !== null) {
      CTATBase.customconsole.innerHTML += txt + "<br>";
      CTATBase.customconsole.scrollTop = CTATBase.customconsole.scrollHeight;
    }
  };
  this.ctatdebugObjectShallow = function debugObjectShallow(object) {
    var output = "";
    for (var property in object) {
      output += property + ", ";
    }
    pointer.ctatdebugInternal("Object: " + output, "Global");
  };
  this.urldecode = function urldecode(str) {
    return decodeURIComponent((str + "").replace(/\+/g, "%20"));
  };
  this.entitiesConvert = function entitiesConvert(str) {
    this.ctatdebug("entitiesConvert ()");
    return this.urldecode(unescape(str));
  };
  this.entitiesGenerate = function entitiesGenerate(str) {
    var temper = str;
    return temper;
  };
  function formatLogMessage(aClass, anInstance, aMessage) {
    if (aClass === null) {
      aClass = "unknownclass";
    }
    if (anInstance === null) {
      anInstance = "nullinstance";
    }
    var formatted = aMessage;
    var txt = "[" + aClass + ":" + anInstance + "] " + formatted;
    return txt;
  }
};
function formatLogMessageGoogle(aClass, anInstance, aMessage) {
  var base = new CTATBase(aClass, anInstance);
  var formatted = base.htmlEncode(aMessage);
  var txt = "[" + aClass + ":" + anInstance + "] " + formatted;
  return txt;
}
function ctatdebug(aMessage) {
  if (!useDebugging && !useDebuggingBasic) {
    return;
  }
  if (aMessage === null) {
    aMessage = "Empty message!";
    return;
  }
  if (CTATConfig.platform == "google") {
    Logger.log(formatLogMessageGoogle("CTATTutor", "tutor", aMessage));
    return;
  }
  if (!ctatdebug.debugPointer) {
    ctatdebug.debugPointer = new CTATBase("CTATTutor", "tutor");
  }
  ctatdebug.debugPointer.ctatdebug(aMessage, "CTATTutor");
}
Object.defineProperty(CTATBase, "DebuggingFilter", {enumerable:false, configurable:false, writable:true, value:[]});
if (typeof module !== "undefined") {
  module.exports = CTATBase;
}
;goog.provide("CTATXML");
goog.require("CTATBase");
CTATXML = function() {
  CTATBase.call(this, "CTATXML", "xmlparser");
  this.parse = function parse(aMessage) {
    return this.parseXML(aMessage);
  };
  this.parseXML = function parseXML(aMessage) {
    this.ctatdebug("parseXML ()");
    var xmlDoc = null;
    try {
      if (typeof $ !== "undefined") {
        xmlDoc = $.parseXML(aMessage);
      } else {
        if (typeof XMLParser !== "undefined") {
          xmlDoc = (new XMLParser).parseFromString(aMessage);
        } else {
          this.ctatdebug("Bottoming out, no parser configured!");
        }
      }
    } catch (err) {
      if (xmlDoc != null) {
        this.ctatdebug("JQuery could not process the provided XML: " + err.message + " (" + xmlDoc.parseError.errorCode + ") (" + xmlDoc.parseError.reason + ") (" + xmlDoc.parseError.line + ")");
      } else {
        this.ctatdebug("JQuery could not process the provided XML (xmlDoc==null): " + err.message);
      }
      return null;
    }
    if (xmlDoc == null) {
      this.ctatdebug("Unspecified error parsing xml message. xmlDoc is null");
      return null;
    }
    return xmlDoc.documentElement;
  };
  this.getElementName = function getElementName(anElement) {
    return anElement.nodeName;
  };
  this.getElementValue = function getElementValue(anElement) {
    return anElement.nodeValue;
  };
  this.getElementChildren = function getElementChildren(anElement) {
    var children = [];
    for (var i = 0;i < anElement.childNodes.length;i++) {
      if (anElement.childNodes[i].nodeType == 1) {
        children.push(anElement.childNodes[i]);
      }
    }
    return children;
  };
  this.getNodeTextValue = function getNodeTextValue(aNode) {
    if (aNode == null) {
      return "";
    }
    if (aNode.childNodes == null) {
      return aNode.nodeValue;
    }
    if (aNode.childNodes.length == 0) {
      return "";
    }
    var entries = aNode.childNodes;
    for (var t = 0;t < entries.length;t++) {
      var entry = entries[t];
      if (entry.nodeName == "value" || entry.nodeName == "Value") {
        if (entry.childNodes.length == 1) {
          return entry.childNodes[0].nodeValue;
        } else {
          if (entry.childNodes.length == 0) {
            return aNode.childNodes[0].nodeValue;
          } else {
            return entry.childNodes[1].nodeValue;
          }
        }
      }
    }
    return aNode.childNodes[0].nodeValue;
  };
  this.getElementAttr = function getElementAttr(anElement, attr) {
    if (!anElement.attributes) {
      this.ctatdebug("Warning: Element " + anElement.nodeName + " does not have any attributes");
      return "";
    }
    for (var i = 0;i < anElement.attributes.length;i++) {
      if (anElement.attributes[i].nodeName == attr) {
        return anElement.attributes[i].nodeValue;
      }
    }
    return "";
  };
  this.listElementAttr = function listElementAttr(anElement) {
    this.ctatdebug("Listing " + anElement.attributes.length + " attributes for element " + anElement.nodeName + " ...");
    for (var i = 0;i < anElement.attributes.length;i++) {
      this.ctatdebug(i + " name: " + anElement.attributes[i].nodeName + ", value: " + anElement.attributes[i].nodeValue);
    }
  };
  this.stringify = function(anObject) {
    return this.xmlToString(anObject);
  };
  this.xmlToString = function xmlToString(xmlData) {
    this.ctatdebug("xmlToString ()");
    if (xmlData == null) {
      this.ctatdebug("Error: xml data is null");
      return null;
    }
    var output = (new XMLSerializer).serializeToString(xmlData);
    return output;
  };
};
CTATXML.prototype = Object.create(CTATBase.prototype);
CTATXML.prototype.constructor = CTATXML;
if (typeof module !== "undefined") {
  module.exports = CTATXML;
}
;goog.provide("CTATLanguageManager");
goog.require("CTATBase");
var CTATDefaultLanguagePack = {"HORIZONTAL":"LR", "VERTICAL":"TB", "LOADING":"Please wait while the tutor is being loaded", "NEXTPROBLEM":"Retrieving the Next Problem...", "CONGRATULATIONS_YOU_ARE_DONE":"Congratulations, you are done with this problem.", "DONE_WITH_PROBLEM_SET":"You are done with this problem set.", "SURE_YOU_ARE_DONE":"Are you sure you are done?", "TUTORDISCONNECTED":"The tutor has disconnected. Please refresh the page.", "OUTOFORDER":"You need to do other steps first, before doing the step you just worked on. You might request a hint for more help.", 
"DONE":"Done", "HINT":"Hint", "NEXT":"Next", "PREVIOUS":"Previous", "HIGHLIGHTEDSTEP":"Instead of the step you are working on, please work on the highlighted step.", "NO_HINT_AVAILABLE":"No hint is available at this step.", "NOTDONE":"I'm sorry, but you are not done yet. Please continue working.", "AUTHORPLEASECLOSE":"Authoring Tools disconnected. Please close this page.", "ERROR_502":"Error contacting the server, please refresh the page and try again (HTTP status 502: gateway response).", "ERROR_CONN_TS":"Connection refused by tutoring service, please check your server or contact an administrator.", 
"ERROR_CONN_LS":"Connection refused by the logging server, please check your connection or contact an administrator.", "AWAITING_OTHER_COLLABORATORS":"Waiting for other team members...", "YOUR_COLLABORATOR":"Your team member ", "COLLABORATOR_QUIT_CLICK_OK":"has quit. Please click OK to exit, then restart the problem.", "COLLABORATOR_QUIT_CLICK_X":"has quit. Please the red X at top right to exit, then restart the problem."};
CTATLanguageManager = function() {
  CTATBase.call(this, "CTATLanguageManager", "theLanguagePack");
  var pointer = this;
  this.getString = function getString(anIdentifier) {
    pointer.ctatdebug("getString (" + anIdentifier + ") -> " + typeof CTATLanguagePack);
    if (typeof CTATLanguagePack !== "undefined") {
      if (CTATLanguagePack[anIdentifier]) {
        return CTATLanguagePack[anIdentifier];
      }
    } else {
      pointer.ctatdebug("No custom language pack defined, using default...");
    }
    return CTATDefaultLanguagePack[anIdentifier];
  };
  this.filterString = function filterString(aString) {
    pointer.ctatdebug("filterString (" + aString + ") -> " + typeof CTATLanguagePack);
    if (typeof CTATLanguagePack !== "undefined") {
      if (CTATLanguagePack[aString]) {
        pointer.ctatdebug("Found tag in provided language pack, returning: " + CTATLanguagePack[aString]);
        return CTATLanguagePack[aString];
      }
    } else {
      pointer.ctatdebug("No custom language pack defined, using default...");
    }
    if (typeof CTATDefaultLanguagePack !== "undefined") {
      if (CTATDefaultLanguagePack[aString]) {
        pointer.ctatdebug("Found tag in default language pack, returning: " + CTATDefaultLanguagePack[aString]);
        return CTATDefaultLanguagePack[aString];
      }
    }
    return aString;
  };
};
CTATLanguageManager.prototype = Object.create(CTATBase.prototype);
CTATLanguageManager.prototype.constructor = CTATLanguageManager;
CTATLanguageManager.theSingleton = new CTATLanguageManager;
goog.provide("CTATMsgType");
goog.require("CTATBase");
goog.require("CTATXML");
goog.require("CTATLanguageManager");
CTATMsgType = function() {
  CTATBase.call(this, "CTATMsgType", "");
};
CTATMsgType.findProperty = function(aMessage, propertyName) {
  var msgLC = aMessage.toLowerCase();
  var tag = "<" + propertyName.toLowerCase() + ">";
  var start = msgLC.indexOf(tag) + tag.length;
  var end = msgLC.indexOf("</" + propertyName.toLowerCase() + ">");
  if (start < tag.length || end < 0) {
    return null;
  }
  var result = {};
  result.start = start;
  result.end = end;
  return result;
};
CTATMsgType.makeValues = function(v) {
  if (v == null) {
    return "";
  }
  if (typeof v == "string") {
    return v;
  }
  if (v.constructor && v.constructor.name == "Array") {
    if (!v.length) {
      return "";
    }
    var i = 0;
    var vi;
    var result = "<value>" + ((vi = v[i++]) == null ? "" : vi.toString());
    while (i < v.length) {
      result += "</value><value>" + ((vi = v[i++]) == null ? "" : vi.toString());
    }
    return result += "</value>";
  }
  if (v.outerHTML) {
    return v.outerHTML;
  }
  return v.toString();
};
CTATMsgType.setProperty = function(aMessage, propertyName, propertyValue) {
  var indices = CTATMsgType.findProperty(aMessage, propertyName);
  var result = "";
  if (indices) {
    result = aMessage.slice(0, indices.start);
    result += CTATMsgType.makeValues(propertyValue);
    result += aMessage.slice(indices.end, aMessage.length);
  } else {
    var endProps = aMessage.indexOf("</properties>");
    result = aMessage.slice(0, endProps);
    result += "<" + propertyName + ">" + CTATMsgType.makeValues(propertyValue) + "</" + propertyName + ">";
    result += aMessage.slice(endProps, aMessage.length);
  }
  return result;
};
CTATMsgType.getProperty = function(aMessage, propertyName) {
  var indices = CTATMsgType.findProperty(aMessage, propertyName);
  if (indices) {
    return aMessage.slice(indices.start, indices.end);
  }
  return "";
};
CTATMsgType.valueToArray = function(str) {
  if (!str.startsWith("<value>")) {
    return null;
  }
  var s = str.substring("<value>".length);
  if (!str.endsWith("</value>")) {
    return null;
  }
  s = s.substring(0, s.length - "</value>".length);
  var sA = s.split("</value><value>");
  ctatdebug("valueToArray(" + str + ") returns " + sA);
  return sA;
};
CTATMsgType.getValue = function(str, i) {
  var sA = CTATMsgType.valueToArray(str);
  if (!sA) {
    return null;
  }
  if (sA.length <= i) {
    return null;
  }
  return sA[i];
};
CTATMsgType.getMessageType = function(aMessage) {
  return CTATMsgType.getProperty(aMessage, "MessageType");
};
CTATMsgType.getTransactionID = function(aMessage) {
  return CTATMsgType.getProperty(aMessage, CTATMessage.TRANSACTION_ID_TAG);
};
CTATMsgType.setTransactionID = function(aMessage, transaction_id) {
  return CTATMsgType.setProperty(aMessage, CTATMessage.TRANSACTION_ID_TAG, transaction_id);
};
CTATMsgType.isCorrectOrIncorrect = function(mt) {
  return typeof mt == "string" ? CTATMsgType.CorrectTypes[mt.toLowerCase()] ? true : false : false;
};
CTATMsgType.hasTextFeedback = function(mt) {
  return typeof mt == "string" ? CTATMsgType.TextFeedbackTypes[mt.toLowerCase()] ? true : false : false;
};
CTATMsgType.isHintResponse = function(mt) {
  return typeof mt == "string" ? CTATMsgType.HintResponseTypes[mt.toLowerCase()] ? true : false : false;
};
CTATMsgType.isDoneMessage = function(msg) {
  var s = CTATMsgType.getProperty(msg, "Selection");
  var a = CTATMsgType.getProperty(msg, "Action");
  if (!s || !a) {
    return false;
  }
  s = s.toString().toLowerCase();
  a = a.toString().toLowerCase();
  var doneLC = CTATMsgType.DONE.toLowerCase();
  if (doneLC != s && doneLC != CTATMsgType.getValue(s, 0)) {
    return false;
  }
  var bpLC = CTATMsgType.BUTTON_PRESSED.toLowerCase();
  if (bpLC != a && bpLC != CTATMsgType.getValue(a, 0)) {
    return false;
  }
  return true;
};
CTATMsgType.getSAIArraysFromElement = function(propertiesElement, parser) {
  var sai = {selection:[], action:[], input:[]};
  var messageChildren = parser.getElementChildren(propertiesElement);
  for (var k = 0;k < messageChildren.length;k++) {
    var childElt = messageChildren[k];
    var childEltName = parser.getElementName(childElt);
    switch(childEltName) {
      case "Selection":
        var selections = parser.getElementChildren(childElt);
        for (var j = 0;j < selections.length;j++) {
          sai.selection.push(parser.getNodeTextValue(selections[j]));
        }
        break;
      case "Action":
        var actions = parser.getElementChildren(childElt);
        for (var m = 0;m < actions.length;m++) {
          sai.action.push(parser.getNodeTextValue(actions[m]));
        }
        break;
      case "Input":
        var inputs = parser.getElementChildren(childElt);
        for (var n = 0;n < inputs.length;n++) {
          sai.input.push(parser.getNodeTextValue(inputs[n]));
        }
        break;
      case "properties":
        return CTATMsgType.getSAIArraysFromElement(childElt, parser);
      default:
        break;
    }
  }
  return sai;
};
Object.defineProperty(CTATMsgType, "CorrectTypes", {enumerable:false, configurable:false, writable:false, value:{correctaction:1, incorrectaction:1, lispcheckaction:1}});
Object.defineProperty(CTATMsgType, "TextFeedbackTypes", {enumerable:false, configurable:false, writable:false, value:{showhintsmessage:1, successmessage:1, buggymessage:1, wrongusermessage:1, nohintmessage:1, highlightmsg:1, showhintsmessagefromlisp:1}});
Object.defineProperty(CTATMsgType, "HintResponseTypes", {enumerable:false, configurable:false, writable:false, value:{showhintsmessage:1, nohintmessage:1, showhintsmessagefromlisp:1}});
Object.defineProperty(CTATMsgType, "BUGGY_MSG", {enumerable:false, configurable:false, writable:false, value:"BuggyMsg"});
Object.defineProperty(CTATMsgType, "DONE", {enumerable:false, configurable:false, writable:false, value:"Done"});
Object.defineProperty(CTATMsgType, "BUTTON_PRESSED", {enumerable:false, configurable:false, writable:false, value:"ButtonPressed"});
Object.defineProperty(CTATMsgType, "DEFAULT_STUDENT_ACTOR", {enumerable:false, configurable:false, writable:false, value:"Student"});
Object.defineProperty(CTATMsgType, "DEFAULT_TOOL_ACTOR", {enumerable:false, configurable:false, writable:false, value:"Tutor"});
Object.defineProperty(CTATMsgType, "UNGRADED_TOOL_ACTOR", {enumerable:false, configurable:false, writable:false, value:"Tutor (unevaluated)"});
Object.defineProperty(CTATMsgType, "DEFAULT_ACTOR", {enumerable:false, configurable:false, writable:false, value:CTATMsgType.DEFAULT_STUDENT_ACTOR});
Object.defineProperty(CTATMsgType, "ANY_ACTOR", {enumerable:false, configurable:false, writable:false, value:"Any"});
Object.defineProperty(CTATMsgType, "SHOW_ALL_FEEDBACK", {enumerable:false, configurable:false, writable:false, value:"Show All Feedback"});
Object.defineProperty(CTATMsgType, "DELAY_FEEDBACK", {enumerable:false, configurable:false, writable:false, value:"Delay Feedback"});
Object.defineProperty(CTATMsgType, "HIDE_ALL_FEEDBACK", {enumerable:false, configurable:false, writable:false, value:"Hide All Feedback"});
Object.defineProperty(CTATMsgType, "HIDE_BUT_COMPLETE", {enumerable:false, configurable:false, writable:false, value:"Hide feedback but require all steps"});
Object.defineProperty(CTATMsgType, "HIDE_BUT_ENFORCE", {enumerable:false, configurable:false, writable:false, value:"Hide feedback but enforce constraints"});
Object.defineProperty(CTATMsgType, "DEFAULT_OUT_OF_ORDER_MESSAGE", {enumerable:false, configurable:false, writable:false, value:CTATLanguageManager.theSingleton.filterString("HIGHLIGHTEDSTEP")});
Object.defineProperty(CTATMsgType, "NOT_DONE_MSG", {enumerable:false, configurable:false, writable:false, value:CTATLanguageManager.theSingleton.filterString("NOTDONE")});
Object.defineProperty(CTATMsgType, "TRACE_OUTCOME", {enumerable:false, configurable:false, writable:false, value:"TraceOutcome"});
Object.defineProperty(CTATMsgType, "PREVIOUS_FOCUS", {enumerable:false, configurable:false, writable:false, value:"PreviousFocus"});
Object.defineProperty(CTATMsgType, "ASSOCIATED_RULES", {enumerable:false, configurable:false, writable:false, value:"AssociatedRules"});
Object.defineProperty(CTATMsgType, "BEGIN_RESTORE", {enumerable:false, configurable:false, writable:false, value:"BeginRestore"});
Object.defineProperty(CTATMsgType, "BEGIN_GO_TO_STATE", {enumerable:false, configurable:false, writable:false, value:"BeginGoToState"});
Object.defineProperty(CTATMsgType, "END_GO_TO_STATE", {enumerable:false, configurable:false, writable:false, value:"EndGoToState"});
Object.defineProperty(CTATMsgType, "BUGGY_MESSAGE", {enumerable:false, configurable:false, writable:false, value:"BuggyMessage"});
Object.defineProperty(CTATMsgType, "CORRECT_ACTION", {enumerable:false, configurable:false, writable:false, value:"CorrectAction"});
Object.defineProperty(CTATMsgType, "HINT_REQUEST", {enumerable:false, configurable:false, writable:false, value:"HintRequest"});
Object.defineProperty(CTATMsgType, "INCORRECT_ACTION", {enumerable:false, configurable:false, writable:false, value:"InCorrectAction"});
Object.defineProperty(CTATMsgType, "INTERFACE_ACTION", {enumerable:false, configurable:false, writable:false, value:"InterfaceAction"});
Object.defineProperty(CTATMsgType, "INTERFACE_IDENTIFICATION", {enumerable:false, configurable:false, writable:false, value:"InterfaceIdentification"});
Object.defineProperty(CTATMsgType, "PROBLEM_RESTORE_END", {enumerable:false, configurable:false, writable:false, value:"ProblemRestoreEnd"});
Object.defineProperty(CTATMsgType, "PROBLEM_SUMMARY_REQUEST", {enumerable:false, configurable:false, writable:false, value:"ProblemSummaryRequest"});
Object.defineProperty(CTATMsgType, "PROBLEM_SUMMARY_RESPONSE", {enumerable:false, configurable:false, writable:false, value:"ProblemSummaryResponse"});
Object.defineProperty(CTATMsgType, "SET_PREFERENCES", {enumerable:false, configurable:false, writable:false, value:"SetPreferences"});
Object.defineProperty(CTATMsgType, "SHOW_HINTS_MESSAGE", {enumerable:false, configurable:false, writable:false, value:"ShowHintsMessage"});
Object.defineProperty(CTATMsgType, "SUCCESS_MESSAGE", {enumerable:false, configurable:false, writable:false, value:"SuccessMessage"});
Object.defineProperty(CTATMsgType, "START_STATE_END", {enumerable:false, configurable:false, writable:false, value:"StartStateEnd"});
Object.defineProperty(CTATMsgType, "STATE_GRAPH", {enumerable:false, configurable:false, writable:false, value:"StateGraph"});
Object.defineProperty(CTATMsgType, "UNTUTORED_ACTION", {enumerable:false, configurable:false, writable:false, value:"UntutoredAction"});
Object.defineProperty(CTATMsgType, "GO_TO_STATE", {enumerable:false, configurable:false, writable:false, value:"GoToState"});
Object.defineProperty(CTATMsgType, "INTERFACE_REBOOT", {enumerable:false, configurable:false, writable:false, value:"InterfaceReboot"});
Object.defineProperty(CTATMsgType, "CompletionValue", {enumerable:false, configurable:false, writable:false, value:["incomplete", "complete"]});
CTATMsgType.prototype = Object.create(CTATBase.prototype);
CTATMsgType.prototype.constructor = CTATMsgType;
if (typeof module !== "undefined") {
  module.exports = CTATMsgType;
}
;goog.provide("CTATVersionComparator");
goog.require("CTATBase");
CTATVersionComparator = function() {
  CTATBase.call(this, "CTATVersionComparator", "");
  var that = this;
  this.compare = function(o1, o2) {
    if (o1 === null || typeof o1 === "undefined") {
      return o2 === null || typeof o2 === "undefined" ? 0 : -1;
    } else {
      if (o2 === null || typeof o2 === "undefined") {
        return 1;
      }
    }
    var result = 0;
    var a1 = o1.split(".");
    var a2 = o2.split(".");
    var i;
    for (i = 0;i < Math.min(a1.length, a2.length);i++) {
      try {
        var i1 = parseInt(a1[i]);
        var i2 = parseInt(a2[i]);
        if (i1 < i2) {
          result = -1;
        } else {
          if (i1 > i2) {
            result = 1;
          } else {
            result = 0;
          }
        }
        if (0 !== result) {
          return result;
        }
      } catch (e) {
        if (a1[i].toString() < a2[i].toString()) {
          result = -1;
        } else {
          if (a1[i].toString() > a2[i].toString()) {
            result = 1;
          } else {
            result = 0;
          }
        }
        if (0 !== result) {
          return result;
        }
      }
    }
    if (i < a1.length) {
      return 1;
    }
    if (i < a2.length) {
      return -1;
    }
    if (o1.toString() < o2.toString()) {
      return -1;
    } else {
      if (o1.toString() > o2.toString()) {
        return 1;
      } else {
        return 0;
      }
    }
  };
};
CTATVersionComparator.prototype = Object.create(CTATBase.prototype);
CTATVersionComparator.prototype.constructor = CTATVersionComparator;
CTATVersionComparator.vc = new CTATVersionComparator;
if (typeof module !== "undefined") {
  module.exports = CTATVersionComparator;
}
;goog.provide("CTATExampleTracerSkill");
goog.require("CTATBase");
goog.require("CTATMsgType");
goog.require("CTATVersionComparator");
CTATExampleTracerSkill = function(givenCategory, givenSkillName, p_guess, p_known, p_slip, p_learn, _history) {
  CTATBase.call(this, "CTATExampleTracerSkill", givenSkillName);
  var that = this;
  var transactionNumber = 0;
  var skillBarDelimiter = CTATExampleTracerSkill.SKILL_BAR_DELIMITER_v2_11;
  this.skillName = givenCategory == null || givenCategory.trim() == "" ? givenSkillName : givenSkillName + " " + givenCategory;
  this.pGuess = Number(p_guess);
  if (Number.isNaN(that.pGuess)) {
    that.pGuess = CTATExampleTracerSkill.DEFAULT_P_GUESS;
  }
  this.pKnown = Number(p_known);
  if (Number.isNaN(that.pKnown)) {
    that.pKnown = CTATExampleTracerSkill.DEFAULT_P_KNOWN;
  }
  this.pLearn = Number(p_learn);
  if (Number.isNaN(that.pLearn)) {
    that.pLearn = CTATExampleTracerSkill.DEFAULT_P_LEARN;
  }
  this.pSlip = Number(p_slip);
  if (Number.isNaN(that.pSlip)) {
    that.pSlip = CTATExampleTracerSkill.DEFAULT_P_SLIP;
  }
  this.history = /^0*[xX]([0-9a-fA-F]+)$/.test(_history) ? parseInt(_history, 16) : /^(\-|\+)?[0-9]+$/.test(_history) ? parseInt(_history, 10) : CTATExampleTracerSkill.DEFAULT_HISTORY;
  this.opportunityCount = 0;
  this.masteryThreshold = CTATExampleTracerSkill.DEFAULT_MASTERY_THRESHOLD;
  this.label = null;
  this.description = null;
  this.getSkillName = function() {
    return that.skillName;
  };
  this.getCategory = function() {
    var spPos = that.skillName.indexOf(" ");
    return spPos < 0 ? "" : that.skillName.substring(spPos + 1);
  };
  this.setTransactionNumber = function(givenTransactionNumber) {
    transactionNumber = givenTransactionNumber;
  };
  this.updatePKnown = function(status) {
    that.pKnown = CTATExampleTracerSkill.updatePKnownStatic(status, that.pGuess, that.pKnown, that.pSlip, that.pLearn);
    return that.pKnown;
  };
  this.updateHistory = function(status) {
    that.history = CTATExampleTracerSkill.updateHistoryStatic(status, that.history);
    return that.history;
  };
  this.changeOpportunityCount = function(delta) {
    that.opportunityCount += delta;
    return that.opportunityCount;
  };
  this.getTransactionNumber = function() {
    return transactionNumber;
  };
  this.getSkillBarString = function(includeLabels) {
    var sb = this.getSkillName();
    sb = sb + this.getSkillBarDelimiter() + that.pKnown;
    sb = sb + this.getSkillBarDelimiter() + (this.hasReachedMastery() ? "1" : "0");
    if (includeLabels === true) {
      sb = sb + this.getSkillBarDelimiter() + this.getLabel();
    }
    return sb.toString();
  };
  this.getSkillBarDelimiter = function() {
    return skillBarDelimiter;
  };
  this.toXML = function(escape) {
    var attrs = "";
    attrs += ' name="' + CTATExampleTracerSkill.getName(that.skillName) + '"';
    attrs += ' category="' + that.getCategory() + '"';
    attrs += ' label="' + that.getLabel() + '"';
    attrs += ' description="' + that.getDescription() + '"';
    attrs += ' pKnown="' + Number(that.pKnown).toString() + '"';
    attrs += ' pLearn="' + Number(that.pLearn).toString() + '"';
    attrs += ' pGuess="' + Number(that.pGuess).toString() + '"';
    attrs += ' pSlip="' + Number(that.pSlip).toString() + '"';
    attrs += ' history="' + that.history + '"';
    attrs += ' opportunityCount="' + that.opportunityCount + '"';
    if (escape) {
      return "&lt;Skill" + attrs + " /&gt;";
    } else {
      return "<Skill" + attrs + " />";
    }
  };
  this.getPKnown = function() {
    return that.pKnown;
  };
  this.getPLearn = function() {
    return that.pLearn;
  };
  this.getPGuess = function() {
    return that.pGuess;
  };
  this.getPSlip = function() {
    return that.pSlip;
  };
  this.getHistory = function() {
    return that.history;
  };
  this.getOpportunityCount = function() {
    return that.opportunityCount;
  };
  this.hasReachedMastery = function() {
    if (that.pKnown === null || typeof that.pKnown === "undefined") {
      return false;
    } else {
      return that.pKnown >= that.masteryThreshold;
    }
  };
  this.getLabel = function() {
    return !that.label || that.label.length < 1 ? CTATExampleTracerSkill.getName(that.skillName) : that.label;
  };
  this.getDescription = function() {
    return !that.description || that.description.length < 1 ? that.skillName : that.description;
  };
  this.setVersion = function(givenVersion) {
    if (givenVersion !== null && typeof givenVersion !== "undefined" && givenVersion.length > 0) {
      skillBarDelimiter = CTATExampleTracerSkill.versionToSkillBarDelimiter(givenVersion);
    }
  };
  this.setLabel = function(givenLabel) {
    that.label = givenLabel;
  };
  this.setDescription = function(givenDescription) {
    that.description = givenDescription;
  };
  CTATExampleTracerSkill.makeStepID = function(selection, action) {
    var sb = "";
    var i = 0;
    for (var v = selection;i++ < 2;v = action) {
      if (v === null || typeof v === "undefined" || v.length < 1) {
        continue;
      }
      var vStarted = false;
      for (var j = 0;j < v.length;j++) {
        if (v[j] === null || typeof v[j] === "undefined") {
          continue;
        }
        var s = v[j].toString();
        if (s.length < 1) {
          continue;
        }
        if (v === selection && ("hint".toString().toUpperCase() === s.toString().toUpperCase() || "help".toString().toUpperCase() === s.toString().toUpperCase())) {
          continue;
        }
        if (v === action && CTATMsgType.PREVIOUS_FOCUS.toString().toUpperCase() === s.toString().toUpperCase()) {
          continue;
        }
        var res = vStarted ? "," : "[";
        sb = sb + res + s;
        vStarted = true;
      }
      if (vStarted === true) {
        sb = sb + "]";
      }
    }
    return sb.toString();
  };
  CTATExampleTracerSkill.updateHistoryStatic = function(givenStatus, givenHistory) {
    var h = givenHistory << 1, msb = 1 << CTATExampleTracerSkill.MAX_INTEGER_SHIFT;
    h |= givenStatus.toString().toUpperCase() === CTATExampleTracerSkill.CORRECT.toString().toUpperCase() ? 1 : 0;
    return h & msb ? h ^ msb : h;
  };
  CTATExampleTracerSkill.updatePKnownStatic = function(givenStatus, givenP_guess, givenP_known, givenP_slip, givenP_learn) {
    var knewIt = 0;
    if (givenStatus.toString().toUpperCase() === CTATExampleTracerSkill.CORRECT.toString().toUpperCase()) {
      var guessedIt = +(givenP_guess * (1 - givenP_known));
      var knewAndPerformed = +(givenP_known * (1 - givenP_slip));
      knewIt = +(knewAndPerformed / (knewAndPerformed + guessedIt));
    } else {
      if (givenStatus.toString().toUpperCase() === CTATExampleTracerSkill.INCORRECT.toString().toUpperCase() || givenStatus.toString().toUpperCase() === CTATExampleTracerSkill.HINT.toString().toUpperCase()) {
        var choked = +(givenP_known * givenP_slip);
        var dontKnowDontGuess = +((1 - givenP_known) * (1 - givenP_guess));
        knewIt = +(choked / (choked + dontKnowDontGuess));
      } else {
      }
    }
    return +(knewIt + givenP_learn * (1 - knewIt));
  };
  CTATExampleTracerSkill.getName = function(givenSkillName) {
    var spPos = givenSkillName.indexOf(" ");
    if (spPos < 0) {
      return givenSkillName;
    } else {
      return givenSkillName.substring(0, spPos);
    }
  };
  CTATExampleTracerSkill.versionToSkillBarDelimiter = function(givenVersion) {
    if (givenVersion === null || typeof givenVersion === "undefined") {
      return CTATExampleTracerSkill.SKILL_BAR_DELIMITER_v2_10;
    }
    if (CTATVersionComparator.vc.compare(givenVersion, "2.11") >= 0) {
      return CTATExampleTracerSkill.SKILL_BAR_DELIMITER_v2_11;
    } else {
      return CTATExampleTracerSkill.SKILL_BAR_DELIMITER_v2_10;
    }
  };
};
CTATExampleTracerSkill.fromJSON = function(jsonObj) {
  if (!jsonObj) {
    return null;
  }
  var result = new CTATExampleTracerSkill("", "");
  for (var p in jsonObj) {
    if (!jsonObj.hasOwnProperty(p) || typeof jsonObj[p] == "function") {
      continue;
    }
    result[p] = jsonObj[p];
  }
  return result;
};
Object.defineProperty(CTATExampleTracerSkill, "MAX_INTEGER_SHIFT", {enumerable:false, configurable:false, writable:false, value:31});
Object.defineProperty(CTATExampleTracerSkill, "HINT", {enumerable:false, configurable:false, writable:false, value:"hint"});
Object.defineProperty(CTATExampleTracerSkill, "CORRECT", {enumerable:false, configurable:false, writable:false, value:"correct"});
Object.defineProperty(CTATExampleTracerSkill, "INCORRECT", {enumerable:false, configurable:false, writable:false, value:"incorrect"});
Object.defineProperty(CTATExampleTracerSkill, "SKILL_BAR_DELIMITER_v2_10", {enumerable:false, configurable:false, writable:false, value:"="});
Object.defineProperty(CTATExampleTracerSkill, "SKILL_BAR_DELIMITER_v2_11", {enumerable:false, configurable:false, writable:false, value:"`"});
Object.defineProperty(CTATExampleTracerSkill, "DEFAULT_MASTERY_THRESHOLD", {enumerable:false, configurable:false, writable:false, value:.95});
Object.defineProperty(CTATExampleTracerSkill, "DEFAULT_P_GUESS", {enumerable:false, configurable:false, writable:false, value:.2});
Object.defineProperty(CTATExampleTracerSkill, "DEFAULT_P_KNOWN", {enumerable:false, configurable:false, writable:false, value:.3});
Object.defineProperty(CTATExampleTracerSkill, "DEFAULT_P_SLIP", {enumerable:false, configurable:false, writable:false, value:.3});
Object.defineProperty(CTATExampleTracerSkill, "DEFAULT_P_LEARN", {enumerable:false, configurable:false, writable:false, value:.15});
Object.defineProperty(CTATExampleTracerSkill, "DEFAULT_HISTORY", {enumerable:false, configurable:false, writable:false, value:0});
CTATExampleTracerSkill.prototype = Object.create(CTATBase.prototype);
CTATExampleTracerSkill.prototype.constructor = CTATExampleTracerSkill;
if (typeof module !== "undefined") {
  module.exports = CTATExampleTracerSkill;
}
;goog.provide("CTATProblem");
goog.require("CTATBase");
goog.require("CTATExampleTracerSkill");
CTATProblem = function() {
  CTATBase.call(this, "CTATProblem", "problem");
  var label = "";
  var description = "";
  var tutor_flag = "tutor";
  var problem_file = "";
  var student_interface = "";
  var skill_opps = [];
  var skills = [];
  var state = "notstarted";
  this.setState = function setState(aValue) {
    state = aValue;
  };
  this.getState = function getState() {
    return state;
  };
  this.setLabel = function setLabel(aValue) {
    label = aValue;
  };
  this.getLabel = function getLabel() {
    return label;
  };
  this.setDescription = function setDescription(aValue) {
    description = aValue;
  };
  this.getDescription = function getDescription() {
    return description;
  };
  this.setTutorFlag = function setTutorFlag(aValue) {
    tutor_flag = aValue;
  };
  this.getTutorFlag = function getTutorFlag() {
    return tutor_flag;
  };
  this.setProblemFile = function setProblemFile(aValue) {
    problem_file = aValue;
  };
  this.getProblemFile = function getProblemFile() {
    return problem_file;
  };
  this.setStudentInterface = function setStudentInterface(aValue) {
    student_interface = aValue;
  };
  this.getStudentInterface = function getStudentInterface() {
    return student_interface;
  };
  this.addSkillOpps = function addSkillOpps(cno) {
    skill_opps.push(cno);
    var skName = cno.category ? cno.name : cno.name + " " + cno.category;
    skills.push(new CTATExampleTracerSkill(cno.category, cno.name));
  };
  this.getSkillOpps = function getSkillOpps() {
    return skill_opps;
  };
  this.getSkills = function getSkills() {
    return skills;
  };
};
CTATProblem.prototype = Object.create(CTATBase.prototype);
CTATProblem.prototype.constructor = CTATProblem;
CTATProblem.prototype.toString = function() {
  return this.getProblemFile() + " on " + this.getStudentInterface();
};
goog.provide("CTATProblemSet");
goog.require("CTATBase");
goog.require("CTATProblem");
CTATProblemSet = function() {
  CTATBase.call(this, "CTATProblemSet", "problemset");
  var pointer = this;
  var problems = new Array;
  this.addProblem = function addProblem(aProblem) {
    problems.push(aProblem);
  };
  this.getProblems = function getProblems() {
    return problems;
  };
  this.getProblemSize = function getProblemSize() {
    return problems.length;
  };
  this.getFirstProblem = function getFirstProblem() {
    pointer.ctatdebug("getFirstProblem () problems.length " + problems.length);
    if (problems.length == 0) {
      return null;
    }
    return problems[0];
  };
};
CTATProblemSet.prototype = Object.create(CTATBase.prototype);
CTATProblemSet.prototype.constructor = CTATProblemSet;
goog.provide("CTATPackage");
goog.require("CTATBase");
goog.require("CTATXML");
goog.require("CTATProblem");
goog.require("CTATProblemSet");
CTATPackage = function() {
  CTATBase.call(this, "CTATPackage", "packagemanager");
  var pointer = this;
  var root = null;
  var parser = new CTATXML;
  var packageURL = "";
  var urlPrefix = "";
  var defaultStudentInterface = "";
  var problems = new CTATProblemSet;
  var problemSets = [problems];
  var assetPaths = {};
  this.init = function init(aDocRoot) {
    pointer.ctatdebug("init ()");
    if (aDocRoot == null) {
      pointer.ctatdebug("Error: document root to be parsed is null.");
      return;
    }
    var rootName = parser.getElementName(aDocRoot);
    pointer.ctatdebug("Root name: " + rootName);
    if (!/Package/i.test(rootName)) {
      var problemName = packageURL.substring(packageURL.lastIndexOf("/") + 1);
      return pointer.addProblem(packageURL, defaultStudentInterface, problemName, problemName, problemName);
    }
    var packageContent = parser.getElementChildren(aDocRoot);
    for (var i = 0;i < packageContent.length;i++) {
      var rootEntity = packageContent[i];
      var rootEntityName = parser.getElementName(rootEntity);
      pointer.ctatdebug("Examining element: " + parser.getElementName(rootEntity));
      switch(rootEntityName) {
        case "Problems":
          pointer.processProblemsElement(rootEntity);
          break;
        case "ProblemSets":
          pointer.processProblemSetsElement(rootEntity);
          break;
        case "Assets":
          assetPaths = pointer.processAssetsElement(rootEntity, assetPaths);
          break;
      }
    }
  };
  this.processProblemsElement = function(topElt) {
    var problemList = parser.getElementChildren(topElt);
    pointer.ctatdebug("CTATPackage.processProblemsElement ... nChildren=" + problemList.length);
    var result = [];
    for (var j = 0;j < problemList.length;j++) {
      var aProblemElement = problemList[j];
      var brd = parser.getElementAttr(aProblemElement, "problem_file");
      var ui = parser.getElementAttr(aProblemElement, "student_interface");
      var name = parser.getElementAttr(aProblemElement, "name");
      var label$2 = parser.getElementAttr(aProblemElement, "label");
      var desc = parser.getElementAttr(aProblemElement, "description");
      assetPaths[brd] = brd;
      assetPaths[ui] = ui;
      pointer.ctatdebug("Problem [" + j + "] desc: " + desc + ", ui: " + ui + ", brd: " + brd);
      var newProblem = pointer.addProblem(brd, ui, name, label$2, desc);
      newProblem.setTutorFlag(parser.getElementAttr(aProblemElement, "tutor_flag"));
      var prChildren = parser.getElementChildren(aProblemElement);
      for (var k$3 = 0;k$3 < prChildren.length;k$3++) {
        if (parser.getElementName(prChildren[k$3]) != "Skills") {
          continue;
        }
        var skList = parser.getElementChildren(prChildren[k$3]);
        for (var s$4 = 0;s$4 < skList.length;s$4++) {
          var sk = skList[s$4];
          var opps = 0;
          newProblem.addSkillOpps({name:parser.getElementAttr(sk, "name"), category:parser.getElementAttr(sk, "category"), opportunities:Number.isNaN(opps = Number.parseInt(parser.getElementAttr(sk, "occurrences")), 10) ? 0 : opps});
        }
      }
      result.push(newProblem);
    }
    console.log("CTATPackage.processProblemsElement result", result);
    return result;
  };
  this.processProblemSetsElement = function(topElt) {
    var psList = parser.getElementChildren(topElt);
    pointer.ctatdebug("CTATPackage.processProblemSetsElement ... nChildren=" + psList.length);
    var result = [];
    for (var j = 0;j < psList.length;j++) {
      var psElt = psList[j]
    }
    return [];
  };
  this.processAssetsElement = function(topElt, assets) {
    var aList = parser.getElementChildren(topElt);
    pointer.ctatdebug("CTATPackage.processAssetsElement ... nChildren=" + aList.length);
    var result = {};
    for (var j = 0;j < aList.length;j++) {
      var aElt = aList[j], name = "";
      if (parser.getElementName(aElt) != "Asset") {
        continue;
      }
      if (assets[name = parser.getElementAttr(aElt, "name")] != "undefined") {
        assets[name] = parser.getElementAttr(aElt, "asset_locator");
      }
    }
    return assets;
  };
  this.addProblem = function(problemFile, studentInterface, name, label, description) {
    var newProblem = new CTATProblem;
    newProblem.setProblemFile(problemFile);
    newProblem.setStudentInterface(studentInterface);
    newProblem.setName(name ? name : problemFile);
    newProblem.setLabel(label ? label : problemFile);
    newProblem.setDescription(description ? description : problemFile);
    pointer.ctatdebug("Adding problem ...");
    var pSets = pointer.getProblemSets();
    pSets[0].addProblem(newProblem);
    return newProblem;
  };
  this.getRelativePath = function(src, dest) {
    if (dest) {
      return CTATPackage.makeRelativePath(assetPaths[src], assetPaths[dest]);
    } else {
      return assetPaths[src];
    }
  };
  this.setURLPrefix = function setURLPrefix(aValue) {
    urlPrefix = aValue;
  };
  this.getURLPrefix = function getURLPrefix() {
    return urlPrefix;
  };
  this.setPackageURL = function setPackageURL(aValue) {
    packageURL = aValue;
  };
  this.getPackageURL = function getPackageURL() {
    return packageURL;
  };
  this.setDefaultStudentInterface = function setDefaultStudentInterface(aValue) {
    defaultStudentInterface = aValue;
  };
  this.getDefaultStudentInterface = function getDefaultStudentInterface() {
    return defaultStudentInterface;
  };
  this.getProblems = function getProblems() {
    return problems;
  };
  this.getProblemSets = function getProblemSets() {
    return problemSets;
  };
};
CTATPackage.prototype = Object.create(CTATBase.prototype);
CTATPackage.prototype.constructor = CTATPackage;
CTATPackage.makeRelativePath = function(from, dest) {
  if (!dest) {
    return from;
  }
  if (!from) {
    return dest;
  }
  var fA = String(from).split("/"), dA = String(dest).split("/");
  var i = 0, j = 0, result = "";
  while (i < fA.length && j < dA.length && fA[i] == dA[j]) {
    j = ++i;
  }
  while (i++ < fA.length - 1) {
    result = result + "../";
  }
  while (j < dA.length - 1) {
    result = result + dA[j++] + "/";
  }
  return result + dA[j];
};
goog.provide("CTATConnectionBase");
goog.require("CTATBase");
CTATConnectionBase = function(aClassName, aName) {
  CTATBase.call(this, "CTATConnectionBase", "ctatconnection");
  var id = -1;
  var url = "";
  var socketType = "http";
  this.setURL = function setURL(aURL) {
    url = aURL;
  };
  this.getURL = function getURL() {
    return url;
  };
  this.setID = function setID(anID) {
    id = anID;
  };
  this.getID = function getID() {
    return id;
  };
  this.setSocketType = function setSocketType(aType) {
    socketType = aType;
  };
  this.getSocketType = function getSocketType() {
    return socketType;
  };
};
CTATConnectionBase.prototype = Object.create(CTATBase.prototype);
CTATConnectionBase.prototype.constructor = CTATConnectionBase;
goog.provide("CTATConnection");
goog.require("CTATBase");
goog.require("CTATConnectionBase");
CTATConnection = function(substVars) {
  CTATConnectionBase.call(this, "CTATConnection");
  var substituteFlashVars = substVars;
  var httpObject = null;
  var settings = {contentType:"text/plain", data:null, processData:false, method:"POST", mimeType:"text/html", headers:{}};
  var consumed = false;
  var pointer = this;
  var receiveFunction = null;
  pointer.setSocketType("http");
  this.setContentType = function setContentType(aVal) {
    settings.contentType = aVal;
  };
  this.getContentType = function getContentType() {
    return settings.contentType;
  };
  this.setConsumed = function setConsumed(aVal) {
    consumed = aVal;
    pointer.ctatdebug("consumed: " + consumed);
  };
  this.getConsumed = function getConsumed() {
    pointer.ctatdebug("consumed: " + consumed);
    return consumed;
  };
  this.assignReceiveFunction = function assignReceiveFunction(aFunction) {
    receiveFunction = aFunction;
    if (httpObject && typeof httpObject.onreadystatechange != "undefined") {
      httpObject.onreadystatechange = aFunction;
    }
  };
  this.assignFailFunction = function assignFailFunction(aFunction) {
    settings.error = aFunction;
    if (httpObject && typeof httpObject.error == "function") {
      httpObject.error(aFunction);
    }
  };
  this.setData = function setData(aData) {
    settings.data = aData;
  };
  this.getData = function getData() {
    return settings.data;
  };
  this.getHTTPObject = function getHTTPObject() {
    return httpObject;
  };
  function createHTTPObject() {
    pointer.ctatdebug("createHTTPObject ()");
    httpObject = new XMLHttpRequest;
    if (typeof $ != "undefined") {
      httpObject = null;
    } else {
      if (window.XMLHttpRequest) {
        pointer.ctatdebug("Creating regular XMLHttpRequest ...");
        httpObject = new XMLHttpRequest;
        if (httpObject.overrideMimeType) {
          httpObject.overrideMimeType("text/html");
        }
      } else {
        pointer.ctatdebug("Trying alternative HTTP object creation ...");
        if (window.ActiveXObject) {
          pointer.ctatdebug("Detected window.ActiveXObject ...");
          try {
            pointer.ctatdebug("Creating Msxml2.XMLHTTP ...");
            httpObject = new ActiveXObject("Msxml2.XMLHTTP");
          } catch (e$5) {
            try {
              pointer.ctatdebug("Creating Microsoft.XMLHTTP ...");
              httpObject = new ActiveXObject("Microsoft.XMLHTTP");
            } catch (e) {
              alert("Error: Unable to create HTTP Request Object: " + e.message);
            }
          }
        } else {
          alert("Internal error: an HTTP connection object could not be created");
        }
      }
    }
  }
  function init() {
    pointer.ctatdebug("init ()");
    var fVars = flashVars ? flashVars.getRawFlashVars() : substituteFlashVars ? substituteFlashVars : {};
    var aSession = fVars["session_id"] ? fVars["session_id"] : "dummySession";
    if (httpObject !== null) {
      if (aSession == "dummySession") {
        pointer.ctatdebug("Unable to find CTAT session information from environment, trying OLI ...");
      }
      try {
        httpObject.setRequestHeader("Content-type", settings.contentType);
        httpObject.setRequestHeader("ctatsession", aSession);
      } catch (err) {
        alert("HTTP object creation error: " + err.message);
      }
    } else {
      if (typeof $ == "undefined") {
        alert("Internal error: http object is null right after creation");
      } else {
        settings.headers.ctatsession = aSession;
      }
    }
    pointer.ctatdebug("init () done");
  }
  this.getMethod = function() {
    return settings.method;
  };
  this.setMethod = function(newMethod) {
    settings.method = newMethod;
  };
  this.send = function send() {
    pointer.ctatdebug("send ()");
    var xhr = pointer.getHTTPObject();
    var fail = function() {
      pointer.ctatdebug("Networking error!");
    };
    if (xhr) {
      xhr.onerror = fail;
    }
    try {
      if (xhr) {
        xhr.open(pointer.getMethod(), pointer.getURL(), true);
      }
    } catch (err) {
      pointer.ctatdebug("Error in newConnection.httpObject.open: " + err.message);
      return;
    }
    init();
    try {
      if (typeof $ != "undefined") {
        xhr = $.ajax(pointer.getURL(), settings).done(receiveFunction).fail(fail);
        httpObject = xhr;
      } else {
        if (settings.data) {
          xhr.send(settings.data);
        } else {
          xhr.send();
        }
      }
    } catch (err$6) {
      this.ctatdebug("Error in newConnection.httpObject.send: " + err$6.message);
      return;
    }
  };
  this.then = function(done, fail) {
    var thenSupported = httpObject && typeof httpObject.then == "function";
    pointer.ctatdebug("CTATConnection.then() supported " + thenSupported + ", done & fail:\n  " + done + ",\n  " + fail);
    return thenSupported ? httpObject.then(done, fail) : Promise.resolve("CTATConnection.then() not supported").then(done, fail);
  };
  createHTTPObject();
};
CTATConnection.prototype = Object.create(CTATConnectionBase.prototype);
CTATConnection.prototype.constructor = CTATConnection;
goog.provide("CTATWSConnection");
goog.require("CTATBase");
goog.require("CTATConnectionBase");
CTATWSConnection = function(substVars) {
  CTATConnectionBase.call(this, "CTATWSConnection");
  var substituteFlashVars = substVars;
  var data = "";
  var consumed = false;
  var pointer = this;
  var output;
  var websocket = null;
  var outgoingQueue = [];
  var ready = false;
  var before = 0;
  var after = 0;
  var receiveFunction = null;
  var closeFunction = null;
  pointer.setSocketType("ws");
  this.setConsumed = function setConsumed(aVal) {
    consumed = aVal;
    pointer.ctatdebug("consumed: " + consumed);
  };
  this.getConsumed = function getConsumed() {
    pointer.ctatdebug("consumed: " + consumed);
    return consumed;
  };
  this.assignReceiveFunction = function assignReceiveFunction(aFunction) {
    receiveFunction = aFunction;
  };
  this.assignCloseFunction = function(aFunction) {
    closeFunction = aFunction;
  };
  this.setData = function setData(aData) {
    data = aData;
  };
  this.getData = function getData() {
    return data;
  };
  this.init = function init() {
    ctatdebug("init (" + pointer.getURL() + "); websocket " + websocket);
    if (websocket != null) {
      return;
    }
    websocket = new WebSocket(pointer.getURL());
    websocket.addEventListener("open", function(e) {
      ctatdebug("STATUS: open");
      ready = true;
      ctatdebug("Connection open, flushing outgoing queue ...");
      var timeDriver = new Date;
      before = timeDriver.getTime();
      if (outgoingQueue.length > 0) {
        for (var i = 0;i < outgoingQueue.length;i++) {
          websocket.send(outgoingQueue[i]);
        }
        outgoingQueue = [];
      }
    });
    websocket.addEventListener("message", function(e) {
      var timeDriver = new Date;
      after = timeDriver.getTime();
      ctatdebug("STATUS: message after " + (after - before) + " ms");
      ctatdebug("Received: " + e.data);
      if (receiveFunction) {
        receiveFunction(e.data);
      } else {
        ctatdebug("Error: no processing function provided");
      }
    });
    websocket.addEventListener("close", function(e) {
      ctatdebug("STATUS: close; " + (e ? "code " + e.code + ", reason " + e.reason : "no event"));
      ready = false;
      var reason = e ? e.reason ? e.reason : "received close code " + e.code : "no close event received";
      websocket.close(1E3, reason);
      if (closeFunction) {
        closeFunction(e);
      }
    });
    websocket.addEventListener("error", function(e) {
      ctatdebug("STATUS: error; " + (e ? e.type : "no event"));
      ready = false;
      websocket.close(1E3, "client closing in response to error");
    });
    ctatdebug("init () done");
  };
  this.send = function send() {
    ctatdebug("send ()");
    pointer.init();
    if (ready === false) {
      ctatdebug("Connection not ready yet, storing ...");
      outgoingQueue.push(data);
    } else {
      ctatdebug("Connection ready, sending data ...");
      var timeDriver = new Date;
      before = timeDriver.getTime();
      websocket.send(data);
    }
  };
  this.getWebSocket = function() {
    return websocket;
  };
  this.close = function(opt_reason, opt_cbk) {
    ready = false;
    opt_reason = opt_reason || "no reason";
    closeFunction = opt_cbk || closeFunction;
    websocket.close(1E3, opt_reason);
  };
};
CTATWSConnection.prototype = Object.create(CTATConnectionBase.prototype);
CTATWSConnection.prototype.constructor = CTATWSConnection;
goog.provide("CTATCanvasComponent");
CTATCanvasComponent = function(aName) {
  var pointer = this;
  var shapes = [];
  var componentName = aName || "__undefined__";
  this.addShape = function addShape(aShape) {
    shapes.push(aShape);
  };
  this.hideShape = function hideShape(aShapeName) {
    for (var i = 0;i < shapes.length;i++) {
      if (shapes[i].getName() == aShapeName) {
        shapes[i].modifyCanvasCSS("visibility", "hidden");
        break;
      }
    }
  };
  this.showShape = function showShape(aShapeName) {
    for (var i = 0;i < shapes.length;i++) {
      if (shapes[i].getName() == aShapeName) {
        shapes[i].modifyCanvasCSS("visibility", "visible");
        break;
      }
    }
  };
  this.hideComponent = function hideComponent() {
    for (var i = 0;i < shapes.length;i++) {
      shapes[i].modifyCanvasCSS("visibility", "hidden");
    }
  };
  this.showComponent = function showComponent() {
    for (var i = 0;i < shapes.length;i++) {
      shapes[i].modifyCanvasCSS("visibility", "visible");
    }
  };
  this.moveShape = function moveShape(aShapeName, toX, toY) {
    for (var i = 0;i < shapes.length;i++) {
      if (shapes[i].getName() == aShapeName) {
        shapes[i].modifyCanvasCSS("left", toX + "px");
        shapes[i].modifyCanvasCSS("top", toY + "px");
        break;
      }
    }
  };
  this.moveComponent = function moveComponent(toX, toY) {
    for (var i = 0;i < shapes.length;i++) {
      shapes[i].modifyCanvasCSS("left", toX + "px");
      shapes[i].modifyCanvasCSS("top", toY + "px");
    }
  };
  this.removeShape = function removeShape(aShapeName) {
    var removeIndex = 0;
    for (var i = 0;i < shapes.length;i++) {
      if (shapes[i].getName() == aShapeName) {
        removeIndex = i;
        break;
      }
    }
    shapes[removeIndex].detatchCanvas();
    shapes.splice(removeIndex, 1);
  };
  this.removeComponent = function removeComponent() {
    while (shapes.length > 0) {
      pointer.removeShape(shapes[0].getName());
    }
  };
};
goog.provide("CTATScrim");
goog.require("CTATBase");
goog.require("CTATCanvasComponent");
goog.require("CTATConfig");
goog.require("CTATSandboxDriver");
goog.require("CTATLanguageManager");
var scrimIsUp = false;
var errorScrim = false;
var waitScrim = true;
var warnScrim = false;
var connectionScrim = false;
var authorTimeSet = true;
var inAuthorTime = true;
CTATScrim = function() {
  CTATBase.call(this, "CTATScrim", "__undefined__");
  var messageList = [];
  var tempList = [];
  var padding = 4;
  var message = "";
  var hasYesButton = false;
  var hasNoButton = false;
  var hasCloseButton = false;
  var yesPtr = null;
  var noPtr = null;
  var scrimComponent = new CTATCanvasComponent("CTAT Scrim");
  var scrim = null;
  var dialog = null;
  var scrimMessage = null;
  var errorsAndWarnings = [];
  var scrimColor = "rgba(0, 0, 0, 0.25)";
  var errorColor = "rgb(255, 0, 0)";
  var warningColor = "rgb(255, 255, 0)";
  var defaultColor = "#CCCCCC";
  var scrimBorderColor = defaultColor;
  var dialogWidthRatio = 6 / 8;
  var dialogHeightRatio = 2 / 8;
  var mainLeft = 0;
  var img = null;
  var yesButton = null;
  var noButton = null;
  var closeButton = null;
  var okButton = null;
  var scrimBorderWidth = 5;
  var pointer = this;
  function closeFunction() {
    warnScrim = false;
    pointer.scrimDown();
  }
  function clearScrim() {
    scrimComponent.removeComponent();
    pointer.removeHTMLElements();
  }
  function displayDialog() {
    if (CTATConfig.platform == "google") {
      return;
    }
    $("#scrimpanel").empty();
    $("#scrim").append('<div class="css3-windows-7"><div class="fenster"><h4 class="titel">CTAT Info Panel</h4><div id="scrimpanel" class="inhalt"><br>' + message + "<br><br></div></div></div>");
    if (hasCloseButton === true) {
      waitScrim = false;
      closeButton = makeHTMLButton(closeFunction, "close");
      $(closeButton).appendTo("#scrimpanel");
    }
    if (hasYesButton === true) {
      waitScrim = false;
      yesButton = makeHTMLButton(yesPtr, "yes");
      $(yesButton).appendTo("#scrimpanel");
      hasYesButton = false;
    }
    if (hasNoButton === true) {
      waitScrim = false;
      noButton = makeHTMLButton(noPtr, "no");
      $(noButton).appendTo("#scrimpanel");
      hasNoButton = false;
    }
    if (waitScrim === true) {
      pointer.ctatdebug("Adding spinner ...");
      $("#scrimpanel").append("<br>");
      var spin_div = $('<div id="scrim_spin">');
      spin_div.css("width", "100%");
      spin_div.css("position", "relative");
      $("#scrimpanel").append(spin_div);
      try {
        var spinner = (new Spinner({className:"scrim_spinner"})).spin();
        $("#scrim_spin").append(spinner.el);
      } catch (err) {
        if (err instanceof ReferenceError || err instanceof TypeError) {
          pointer.ctatdebug('Spinner is not available, please include it in the build or add <script src="node_modules/spin.js/spin.min.js">\x3c/script> to the html file.', err, typeof err);
        }
      }
    }
  }
  function drawScrim() {
    pointer.ctatdebug("drawScrim ()");
    if (CTATConfig.platform == "google") {
      pointer.ctatdebug("This is not available for now when we're in this environment");
      return;
    }
    $('<div id="scrim" class="ctatpageoverlay"></div>').appendTo("body");
    $("#scrim").css("z-index", 1E3);
    displayDialog();
  }
  this.scrimUp = function scrimUp(aMessage) {
    if (CTATConfig.platform == "google") {
      return;
    }
    pointer.ctatdebug("scrimUp ()");
    var mapped = CTATGlobals.languageManager.filterString(aMessage);
    pointer.ctatdebug("Message: " + mapped);
    if (scrimIsUp === true) {
      if (waitScrim === true) {
        message = mapped;
      } else {
        message += " \n " + mapped;
      }
      scrimComponent.removeComponent();
      messageList = [];
      tempList = [];
      pointer.removeHTMLElements();
    } else {
      message = mapped;
      scrimIsUp = true;
    }
    pointer.ctatdebug("scrimUp() to call drawScrim() scrimIsUp " + scrimIsUp);
    drawScrim();
  };
  this.waitScrimUp = function waitScrimUp() {
    pointer.ctatdebug("waitScrimUp () CTATConfig.platform " + CTATConfig.platform + ", scrimIsUp " + scrimIsUp);
    if (CTATConfig.platform == "google") {
      return;
    }
    if (scrimIsUp === true) {
      pointer.scrimDownForced();
    }
    scrimBorderColor = defaultColor;
    waitScrim = true;
    pointer.scrimUp(CTATGlobals.languageManager.getString("LOADING"));
    pointer.ctatdebug("return from waitScrimUp(): scrimIsUp " + scrimIsUp);
  };
  this.nextProblemScrimUp = function nextProblemScrimUp() {
    if (CTATConfig.platform == "google") {
      return;
    }
    if (scrimIsUp === true) {
      pointer.scrimDownForced();
    }
    pointer.ctatdebug("nextProblemScrimUp ()");
    scrimBorderColor = defaultColor;
    pointer.scrimUp(CTATGlobals.languageManager.getString("NEXTPROBLEM"));
  };
  this.OKScrimUp = function OKScrimUp(aMessage, aFunction) {
    if (CTATConfig.platform == "google") {
      return;
    }
    if (scrimIsUp === true) {
      pointer.scrimDownForced();
    }
    pointer.ctatdebug("OKScrimUp (" + aMessage + "," + aFunction + ")");
    errorScrim = false;
    warnScrim = false;
    hasCloseButton = false;
    hasYesButton = false;
    hasNoButton = false;
    scrimBorderColor = "black";
    waitScrim = false;
    pointer.scrimUp(aMessage);
    okButton = makeHTMLButton(aFunction, "OK");
    $(okButton).appendTo("#scrimpanel");
  };
  this.confirmScrimUp = function confirmScrimUp(prompt, onYes, onNo) {
    if (CTATConfig.platform == "google") {
      return;
    }
    if (scrimIsUp === true) {
      pointer.scrimDownForced();
    }
    pointer.ctatdebug("confirmScrimUp (" + prompt + "," + onYes + "," + onNo + ")");
    scrimBorderColor = defaultColor;
    hasYesButton = true;
    hasNoButton = true;
    noPtr = onNo;
    yesPtr = onYes;
    pointer.scrimUp(prompt);
  };
  function errScrimUp(aMessage) {
    if (CTATConfig.platform == "google") {
      return;
    }
    if (scrimIsUp === true) {
      pointer.scrimDownForced();
    }
    pointer.ctatdebug("errScrimUp (" + aMessage + ")");
    if (errorScrim === true) {
      scrimBorderColor = errorColor;
      if (hasCloseButton === true) {
        hasCloseButton = false;
        getSafeElementById(ctatcontainer).removeChild(closeButton);
      }
    } else {
      if (warnScrim === true) {
        scrimBorderColor = warningColor;
        hasCloseButton = true;
      }
    }
    pointer.scrimUp(aMessage);
  }
  this.errorScrimUp = function errorScrimUp(aMessage) {
    if (CTATConfig.platform == "google") {
      return;
    }
    if (scrimIsUp === true) {
      pointer.scrimDownForced();
    }
    if (authorTimeSet === false) {
      pointer.ctatdebug("we don't know if we're in authorTime or not yet so we're just going to hold onto the messasge");
      errorsAndWarnings.push("ERROR: " + aMessage);
      errorScrim = true;
      return;
    } else {
      if (inAuthorTime === false) {
        pointer.ctatdebug("We're not in authorTime, student's don't need to see our design mistakes");
        return;
      }
    }
    errorScrim = true;
    errScrimUp("ERROR: " + aMessage);
  };
  this.warningScrimUp = function warningScrimUp(aMessage) {
    if (CTATConfig.platform == "google") {
      return;
    }
    if (scrimIsUp === true) {
      pointer.scrimDownForced();
    }
    if (authorTimeSet === false) {
      pointer.ctatdebug("we don't know if we're in authorTime or not yet so we're just going to hold onto the messasge");
      errorsAndWarnings.push("WARNING: " + aMessage);
      warnScrim = true;
      return;
    } else {
      if (inAuthorTime === false) {
        pointer.ctatdebug("We're not in authorTime, student's don't need to see our design mistakes");
        return;
      }
    }
    warnScrim = true;
    errScrimUp("WARNING: " + aMessage);
  };
  this.handleTSDisconnect = function handleTSDisconnect() {
    connectionScrim = true;
    pointer.scrimUp(CTATGlobals.languageManager.getString("TUTORDISCONNECTED"));
  };
  this.removeHTMLElements = function removeHTMLElements() {
  };
  this.scrimDown = function scrimDown() {
    if (CTATConfig.platform == "google") {
      return;
    }
    if (scrimIsUp === false) {
      pointer.ctatdebug("The scrim isn't up, returning");
      return;
    }
    if (errorScrim === true) {
      pointer.ctatdebug("The scrim is up to describe errors to the user, leave it up!");
      return;
    }
    if (warnScrim === true) {
      pointer.ctatdebug("The scrim is up to display warnings to the user, leave it up!");
      return;
    }
    if (connectionScrim === true) {
      pointer.ctatdebug("The scrim is up for a connection issue leave it up!");
      return;
    }
    pointer.scrimDownForced();
  };
  this.scrimDownForced = function scrimDownForced() {
    pointer.ctatdebug("enter scrimDownForced() scrimIsUp " + scrimIsUp);
    $("#scrim").remove();
    scrimComponent.removeComponent();
    pointer.removeHTMLElements();
    scrimIsUp = false;
    waitScrim = false;
    message = "";
    pointer.ctatdebug("exit scrimDownForced() scrimIsUp " + scrimIsUp);
  };
  this.defaultClickHandler = function defaultClickHandler() {
    pointer.ctatdebug("defaultClickHandler ()");
    pointer.scrimDown();
  };
  function makeHTMLButton(clickHandle, btnType) {
    pointer.ctatdebug("makeHTMLButton ()");
    var btn = document.createElement("input");
    btn.type = "button";
    btn.value = btnType;
    if (clickHandle) {
      pointer.ctatdebug("clickHandle!=null");
      btn.onclick = clickHandle;
    } else {
      pointer.ctatdebug("clickHandle==null");
      btn.onclick = pointer.defaultClickHandler;
    }
    btn.id = btnType;
    btn.setAttribute("class", "scrimButton");
    return btn;
  }
  this.setInAuthorTime = function setInAuthorTime(theValue) {
    pointer.ctatdebug("setting inAuthorTime = " + theValue);
    authorTimeSet = true;
    inAuthorTime = theValue;
    if (!theValue) {
      errorScrim = false;
      warnScrim = false;
      if (hasCloseButton) {
        scrim.removeChild(closeButton);
      }
      scrimBorderColor = defaultColor;
    } else {
      if (errorScrim || warnScrim) {
        for (var mess in errorsAndWarnings) {
          errScrimUp(mess);
        }
      }
    }
  };
  this.getInAuthorTime = function getInAuthorTime() {
    return inAuthorTime;
  };
};
CTATScrim.prototype = Object.create(CTATBase.prototype);
CTATScrim.prototype.constructor = CTATScrim;
CTATGlobals.languageManager = CTATLanguageManager.theSingleton;
CTATScrim.scrim = new CTATScrim;
goog.provide("CTAT.ToolTutor");
goog.require("CTATGlobals");
CTAT.ToolTutor = {interfaceMessages:[], tutorMessages:[]};
Object.defineProperty(CTAT.ToolTutor, "message_handler", {enumerable:true, get:function() {
  if (window.hasOwnProperty("getInterfaceObject") && typeof window["getInterfaceObject"] === "function") {
    return window["getInterfaceObject"]();
  }
  if (window.hasOwnProperty("interfaceObject")) {
    return window["interfaceObject"];
  }
  if (!this.hasOwnProperty("_interface")) {
    this["_interface"] = null;
  }
  return this["_interface"];
}, set:function(obj) {
  if (window.hasOwnProperty("interfaceObject")) {
    window["interfaceObject"] = obj;
  } else {
    this["_interface"] = obj;
  }
  return obj;
}});
Object.defineProperty(CTAT.ToolTutor, "tutor", {enumerable:true, get:function() {
  if (window.hasOwnProperty("getTutorObject") && typeof window["getTutorObject"] === "function") {
    return window["getTutorObject"]();
  }
  if (window.hasOwnProperty("tutorObject")) {
    return window["tutorObject"];
  }
  if (!this.hasOwnProperty("_tutor")) {
    this["_tutor"] = null;
  }
  return this["_tutor"];
}, set:function(obj) {
  if (window.hasOwnProperty("tutorObject")) {
    window["tutorObject"] = obj;
  } else {
    this["_tutor"] = obj;
  }
  return obj;
}});
CTAT.ToolTutor.registerTutor = function(tutor) {
  if (window.hasOwnProperty("registerTutor") && typeof window["registerTutor"] === "function") {
    return window["registerTutor"](tutor);
  }
  this.tutor = tutor;
  if (this.tutor) {
    while (this.tutorMessages.length > 0) {
      this.sendToTutor(this.tutorMessages.shift());
    }
  }
};
CTAT.ToolTutor.sendToInterface = function(message) {
  ctatdebug("CTAT.ToolTutor.sendToInterface()\n  " + message);
  if (window.hasOwnProperty("sendToInterface") && typeof window["sendToInterface"] === "function") {
    return window["sendToInterface"].apply(null, arguments);
  }
  if (this.message_handler) {
    return this.message_handler.receiveFromTutor(message);
  } else {
    if (commMessageHandler) {
      return commMessageHandler.processMessage(message);
    } else {
      return this.interfaceMessages.push(message);
    }
  }
};
CTAT.ToolTutor.registerInterfaceMessageHandler = function(message_handler) {
  ctatdebug("CTAT.ToolTutor.registerInterfaceMessageHandler(" + message_handler + ")");
  if (typeof message_handler === "string") {
    message_handler = document.getElementById(message_handler);
  }
  this.message_handler = message_handler;
  if (this.message_handler) {
    while (this.interfaceMessages.length > 0) {
      this.sendToInterface(this.interfaceMessages.shift());
    }
  }
};
CTAT.ToolTutor.registerInterface = function(message_handler) {
  if (window.hasOwnProperty("registerInterface") && typeof window["registerInterface"] === "function") {
    return window.registerInterface(message_handler);
  }
  this.registerInterfaceMessageHandler(message_handler);
};
CTAT.ToolTutor.sendToTutor = function(message) {
  if (window.hasOwnProperty("sendToTutor") && typeof window["sendToTutor"] === "function") {
    return window["sendToTutor"](message);
  }
  if (this.tutor) {
    return this.tutor.receiveFromInterface(message);
  } else {
    return this.tutorMessages.push(message);
  }
};
CTAT.ToolTutor.reboot = function(reason) {
  var href = typeof location != "undefined" && location && location.href ? location.href : null;
  href && console.log("ToolTutor.reboot(), setting location to " + href);
  if (href && !CTATConfiguration.get("editorMode")) {
    if (typeof setTimeout == "function") {
      setTimeout(location.replace.bind(location), 600, href);
    } else {
      location.replace(href);
    }
    return true;
  } else {
    return false;
  }
};
goog.provide("CTATGuid");
CTATGuid = {s4:function s4() {
  return Math.floor((1 + Math.random()) * 65536).toString(16).substring(1);
}, guid:function guid() {
  return this.s4() + this.s4() + "-" + this.s4() + "-" + this.s4() + "-" + this.s4() + "-" + this.s4() + this.s4() + this.s4();
}};
goog.provide("CTATConfiguration");
goog.require("CTATBase");
goog.require("CTATGuid");
CTATConfiguration = function() {
  CTATBase.call(this, "CTATConfiguration", "config");
  var pointer = this;
  var custom_fields = {};
  var tNames = null;
  var tTypes = null;
  var tDescNames = null;
  var tDescTypes = null;
  var tDesc = null;
  this.raw = {"admit_code":"ies", "authenticity_token":"", "auth_token":"none", "BehaviorRecorderMode":"AuthorTimeTutoring", "class_name":"DefaultClass", "curriculum_service_url":"", "connection":"javascript", "dataset_level_name":"none", "dataset_level_type":"ProblemSet", "dataset_name":"none", "expire_logout_url":"none", "info":"", "instructor_name":"none", "instrumentation_log":"off", "lcId":"none", "Logging":"None", "log_service_url":"http://pslc-qa.andrew.cmu.edu/log/server", "log_to_disk_directory":".", 
  "problem_name":"none", "problem_position":"none", "problem_started_url":"none", "problem_state_status":"empty", "question_file":"none", "refresh_session_url":"none", "remoteSocketPort":"20080", "remoteSocketSecurePort":"20443", "remoteSocketURL":"127.0.0.1", "restore_problem_url":"", "reuse_swf":"false", "run_problem_url":"none", "school_name":"none", "SessionLog":"true", "session_id":CTATGuid.guid(), "session_timeout":"none", "show_debug_traces":"false", "skills":"", "source_id":"PACT_CTAT_HTML5", 
  "student_interface":"none", "student_problem_id":"none", "study_condition_name":"none", "study_condition_type":"none", "study_condition_description":"none", "study_name":"Study1", "target_frame":"_parent", "TutorShopDeliveryMethod":"sendandload", "tutoring_service_communication":"javascript", "user_guid":"none", "wmode":"opaque", "ssl":"off", "sui":"", "centerTutor":false, "previewMode":false, "width":550, "height":450};
  function parseQueryString() {
    ctatdebug("parseQueryString ()");
    var str = location.search;
    ctatdebug("Query String: " + str);
    var query = str.charAt(0) == "?" ? str.substring(1) : str;
    var args = {};
    if (query) {
      var fields = query.split("&");
      for (var f = 0;f < fields.length;f++) {
        var field = fields[f].split("=");
        ctatdebug("Setting flashvar " + field[0] + ", to: " + decodeURIComponent(field[1].replace(/\+/g, " ")));
        args[decodeURIComponent(field[0])] = "";
        for (var i = 1;i < field.length;i++) {
          args[decodeURIComponent(field[0])] += (i > 1 ? "=" : "") + decodeURIComponent(field[i].replace(/\+/g, " "));
        }
        ctatdebug("Decoded args: " + args[decodeURIComponent(field[0])]);
      }
    }
    return args;
  }
  function tutorPrep(aVars) {
    ctatdebug("tutorPrep (" + aVars + ")");
    var args = {};
    if (aVars === null || aVars === undefined) {
      ctatdebug("tutorPrep(): Internal error: null argument passed");
      return args;
    }
    var tArgs = parseQueryString();
    if (tArgs !== null) {
      ctatdebug("tutorPrep(): Assigning parsed arguments ...");
      args = tArgs;
    }
    var generated = false;
    for (var arg in args) {
      if (args.hasOwnProperty(arg)) {
        ctatdebug("Processing external FlashVar " + arg + "(" + args[arg] + ")");
        switch(arg) {
          case "GENERATED":
            if (args[arg] == "on") {
              aVars["session_id"] = CTATGuid.guid();
              generated = true;
            }
            break;
          case "BRD":
            aVars["question_file"] = args[arg];
            break;
          case "BRMODE":
            aVars["BehaviorRecorderMode"] = args[arg];
            break;
          case "PROBLEM":
            aVars["problem_name"] = args[arg];
            break;
          case "DATASET":
            aVars["dataset_name"] = args[arg];
            break;
          case "LEVEL1":
            aVars["dataset_level_name1"] = args[arg];
            break;
          case "TYPE1":
            aVars["dataset_level_type1"] = args[arg];
            break;
          case "LEVEL2":
            aVars["dataset_level_name2"] = args[arg];
            break;
          case "TYPE2":
            aVars["dataset_level_type2"] = args[arg];
            break;
          case "LEVEL3":
            aVars["dataset_level_name3"] = args[arg];
            break;
          case "TYPE3":
            aVars["dataset_level_type3"] = args[arg];
            break;
          case "LEVEL4":
            aVars["dataset_level_name4"] = args[arg];
            break;
          case "TYPE4":
            aVars["dataset_level_type4"] = args[arg];
            break;
          case "USER":
            aVars["user_guid"] = args[arg];
            break;
          case "SESSION":
            if (generated === false) {
              aVars["session_id"] = args[arg];
            }
            break;
          case "SOURCE":
            aVars["source_id"] = args[arg];
            break;
          case "LOGTYPE":
            aVars["Logging"] = args[arg];
            break;
          case "PORT":
            aVars["remoteSocketPort"] = args[arg];
            break;
          case "REMOTEURL":
            aVars["remoteSocketURL"] = args[arg];
            break;
          case "DISKDIR":
            aVars["log_to_disk_directory"] = args[arg];
            break;
          case "log_service_url":
            aVars["log_service_url"] = args[arg];
            break;
          case "URL":
            aVars["log_service_url"] = args[arg];
            break;
          case "LOGURL":
            aVars["log_service_url"] = args[arg];
            break;
          case "CONNECTION":
            aVars["tutoring_service_communication"] = args[arg];
            break;
          case "SUI":
            aVars["sui"] = args[arg];
            break;
          case "VAR1":
            aVars["var1"] = args[arg];
            break;
          case "VAL1":
            aVars["val1"] = args[arg];
            break;
          case "VAR2":
            aVars["var2"] = args[arg];
            break;
          case "VAL2":
            aVars["val2"] = args[arg];
            break;
          case "VAR3":
            aVars["var3"] = args[arg];
            break;
          case "VAL3":
            aVars["val3"] = args[arg];
            break;
          case "VAR4":
            aVars["var4"] = args[arg];
            break;
          case "VAL4":
            aVars["val4"] = args[arg];
            break;
          case "SLOG":
          ;
          case "SessionLog":
            aVars["SessionLog"] = args[arg];
            break;
          case "KEYBOARDGROUP":
            if (args[arg] == "Disabled") {
              aVars["keyboard"] = "disabled";
            }
            if (args[arg] == "Auto") {
              aVars["keyboard"] = "auto";
            }
            if (args[arg] == "On") {
              aVars["keyboard"] = "on";
            }
            break;
          default:
            aVars[arg] = args[arg];
            break;
        }
      }
    }
    return aVars;
  }
  this.assignRawFlashVars = function assignRawFlashVars(aData) {
    pointer.ctatdebug("assignRawFlashVars() raw['session_id'] " + pointer.raw["session_id"] + ", aData['session_id'] " + aData["session_id"]);
    pointer.raw = aData;
    pointer.preParse();
  };
  this.getRawFlashVars = function getRawFlashVars() {
    return pointer.raw;
  };
  this.getSingleParameterValues = function(paramNames) {
    var result = [];
    if (!paramNames) {
      return result;
    }
    var nameList = pointer.getRawFlashVars();
    for (var i in paramNames) {
      var n = paramNames[i];
      if (nameList[n] && nameList[n] != "none") {
        result.push(nameList[n]);
      }
    }
    return result;
  };
  this.usingFlash = function() {
    var paramNames = ["student_interface", "swf_name"];
    return this.getSingleParameterValues(paramNames).some(function(val) {
      return val.search(/[.]swf$/i) >= 0;
    });
  };
  this.generateDefaultConfiguration = function(defaults, localVars) {
    var result = {};
    var nDefaults = 0, nLocalVars = 0;
    if (defaults) {
      for (var v in defaults) {
        result[v] = defaults[v];
        nDefaults++;
      }
    }
    pointer.ctatdebug("generateDefaultConfiguration() nDefaults " + nDefaults + ", result['session_id'] " + result["session_id"]);
    if (typeof localVars != "undefined" && localVars != null) {
      for (var v in localVars) {
        result[v] = localVars[v];
        nLocalVars++;
      }
    }
    pointer.ctatdebug("generateDefaultConfiguration() nLocalVars " + nLocalVars);
    var dataParams = null, dataParamsAttr = null;
    if (window && window.frameElement && (dataParamsAttr = window.frameElement.getAttribute("data-params"))) {
      dataParams = jQuery.parseJSON(dataParamsAttr);
      console.log("setting data params from iframe attr");
      for (var dp in dataParams) {
        result[dp] = CTATGlobals.EncodedParams[dp] ? decodeURIComponent(dataParams[dp].replace(/\+/g, "%20")) : dataParams[dp];
        console.log("set " + dp + " to " + result[dp]);
      }
    }
    if (dataParams === null) {
      var objs = $('object param[name="flashvars"]');
      pointer.ctatdebug("generateDefaultConfiguration() objs " + objs);
      for (var i = 0;i < objs.length;++i) {
        var fVarsAsString = $(objs[i]).attr("value");
        pointer.ctatdebug("generateDefaultConfiguration() fVarsAsString " + fVarsAsString);
        if (fVarsAsString) {
          var fVars = parseQueryStringArgs(fVarsAsString);
          if (fVars && fVars["question_file"]) {
            for (var fv in fVars) {
              result[fv] = fVars[fv];
            }
          }
        }
      }
    }
    tutorPrep(result);
    return result;
  };
  this.getCustomFields = function getCustomFields() {
    return custom_fields;
  };
  this.setTimeZone = function setTimeZone(zone) {
    pointer.ctatdebug("setTimeZone (" + zone + ")");
    var timeZone = "";
    if (zone == null || zone == "" || zone == undefined) {
      var tz = jstz.determine();
      pointer.ctatdebug("Assigning detected timezone: " + tz.name());
      timeZone = tz.name();
    } else {
      if (zone.length > 50) {
        zone = zone.substr(0, 50);
      }
      if (zone.length == 3 || zone.length == 4) {
        pointer.ctatdebug("3 and 4 letter time zone abbreviations are deprecated. See list of tz database zone names for better options");
      }
      timeZone = zone;
    }
    if (pointer.raw != null) {
      pointer.raw["timezone"] = timeZone;
    }
  };
  this.getTimeZone = function getTimeZone() {
    if (pointer.raw != null) {
      if (pointer.raw["timezone"]) {
        return pointer.raw["timezone"];
      }
    }
    return "UTC";
  };
  this.listWithAmpersands = function() {
    var result = "";
    for (var propertyName in pointer.raw) {
      var newProp = propertyName + "=" + encodeURIComponent(pointer.raw[propertyName]);
      if (result != "") {
        result = result + "&" + newProp;
      } else {
        result = newProp;
      }
    }
    pointer.ctatdebug("CTATConfiguration.listWithAmpersands() result " + result.substring(0, 25) + "...");
    return result;
  };
  this.listFlashVars = function listFlashVars() {
    ctatdebug("listFlashVars ()");
    for (var propertyName in pointer.raw) {
      ctatdebug("[" + propertyName + "]: " + pointer.raw[propertyName]);
    }
  };
  this.preParse = function preParse() {
    ctatdebug("preParse ()");
    if (pointer.raw["dataset_name"] == undefined || pointer.raw["dataset_name"] == undefined) {
      pointer.raw["dataset_name"] = "DefaultDataset";
    }
    var nRaw = 0;
    for (var propertyName in pointer.raw) {
      if (propertyName == "VAR" || propertyName == "var") {
        custom_fields[propertyName] = pointer.raw[propertyName];
      }
      nRaw++;
    }
    pointer.ctatdebug("preParse() nRaw " + nRaw);
    var index = 0;
    var valid = true;
    while (valid == true) {
      valid = false;
      var aName = "custom_field_name" + (index + 1);
      var aValue = "custom_field_value" + (index + 1);
      pointer.ctatdebug("Trying : " + pointer.raw[aName] + "," + pointer.raw[aValue]);
      if (pointer.raw[aName] != null) {
        pointer.ctatdebug("Adding: " + aName + "," + pointer.raw[aValue]);
        custom_fields[pointer.raw[aName]] = pointer.raw[aValue];
        valid = true;
        index++;
      }
    }
  };
  this.getDatasetNames = function getDatasetNames() {
    pointer.ctatdebug("getDatasetNames ()");
    if (tNames != null) {
      return tNames;
    }
    tNames = new Object;
    tNames = [];
    var index = 0;
    var valid = true;
    while (valid == true) {
      valid = false;
      var aName = "dataset_level_name" + (index + 1);
      if (pointer.raw[aName] != null) {
        pointer.ctatdebug("Adding: " + aName + "," + pointer.raw[aName]);
        tNames[index] = pointer.raw[aName];
        valid = true;
        index++;
      }
    }
    return tNames;
  };
  this.getDatasetTypes = function getDatasetTypes() {
    pointer.ctatdebug("getDatasetTypes ()");
    if (tTypes != null) {
      return tTypes;
    }
    tTypes = [];
    var index = 0;
    var valid = true;
    while (valid == true) {
      valid = false;
      var aType = "dataset_level_type" + (index + 1);
      if (pointer.raw[aType] != null) {
        pointer.ctatdebug("Adding: " + aType + "," + pointer.raw[aType]);
        tTypes[index] = pointer.raw[aType];
        valid = true;
        index++;
      }
    }
    return tTypes;
  };
  this.getConditionNames = function getConditionNames() {
    var tDescNames = [];
    var totalIndex = 0;
    if (pointer.raw["study_condition_name"] != undefined) {
      if (pointer.raw["study_condition_name"] != "") {
        tDescNames.push(pointer.raw["study_condition_name"]);
        totalIndex++;
      }
    }
    var index = 0;
    var valid = true;
    while (valid == true) {
      valid = false;
      var aName = "study_condition_name" + (index + 1);
      if (pointer.raw[aName] != null) {
        pointer.ctatdebug("Adding: " + aName + "," + pointer.raw[aName]);
        tDescNames[index + totalIndex] = pointer.raw[aName];
        valid = true;
        index++;
      }
    }
    return tDescNames;
  };
  this.getConditionTypes = function getConditionTypes() {
    tDescTypes = [];
    var totalIndex = 0;
    if (pointer.raw["study_condition_type"] != undefined) {
      if (pointer.raw["study_condition_type"] != "") {
        tDescTypes.push(pointer.raw["study_condition_type"]);
        totalIndex++;
      }
    }
    var index = 0;
    var valid = true;
    while (valid == true) {
      valid = false;
      var aName = "study_condition_type" + (index + 1);
      if (pointer.raw[aName] != null) {
        pointer.ctatdebug("Adding: " + aName + "," + pointer.raw[aName]);
        tDescTypes[index + totalIndex] = pointer.raw[aName];
        valid = true;
        index++;
      }
    }
    return tDescTypes;
  };
  this.getConditionDescriptions = function getConditionDescriptions() {
    pointer.ctatdebug("getConditionDescriptions ()");
    tDesc = [];
    var totalIndex = 0;
    if (pointer.raw["study_condition_description"]) {
      if (pointer.raw["study_condition_description"] !== "") {
        pointer.ctatdebug("Adding study_condition_description: " + pointer.raw["study_condition_description"]);
        tDesc.push(pointer.raw["study_condition_description"]);
        totalIndex++;
      }
    }
    var index = 0;
    var valid = true;
    while (valid === true) {
      valid = false;
      var aName = "study_condition_description" + (index + 1);
      if (pointer.raw[aName] != null) {
        pointer.ctatdebug("Adding: " + aName + "," + pointer.raw[aName]);
        tDesc[index + totalIndex] = pointer.raw[aName];
        valid = true;
        index++;
      }
    }
    return tDesc;
  };
  this.get = function(name) {
    return pointer.raw[name];
  };
  this.set = function(name, value) {
    if (name) {
      pointer.raw[name] = value;
    }
  };
  this.setParams = function(newParams) {
    if (newParams) {
      for (var name in newParams) {
        pointer.set(name, newParams[name]);
      }
    }
  };
  this.isInstructorMode = function isInstructorMode() {
    var vars = this.getRawFlashVars();
    if (vars && vars["deliverymode"]) {
      return vars["deliverymode"] == "delivery" ? false : true;
    } else {
      return false;
    }
  };
  this.getLoggingLibrary = function getLoggingLibrary() {
    if (commLoggingLibrary === null) {
      commLoggingLibrary = new CTATLoggingLibrary(true);
    }
    return commLoggingLibrary;
  };
  this.setPreviewMode = function setPreviewMode(aConfigurationObject, aValue) {
    pointer.raw["previewMode"] = aValue;
  };
  this.setCenterTutor = function setCenterTutor(aConfigurationObject, aValue) {
    pointer.raw["centerTutor"] = aValue;
  };
  this.setTutorWidth = function setTutorWidth(aConfigurationObject, w) {
    pointer.raw["width"] = w;
  };
  this.setTutorHeight = function setTutorHeight(aConfigurationObject, h) {
    pointer.raw["height"] = h;
  };
  this.setTutorDimensions = function setTutorDimensions(aConfigurationObject, w, h) {
    pointer.raw["width"] = w;
    pointer.raw["height"] = h;
  };
  this.setTutorValue = function setTutorValue(aConfigurationObject, aKey, aValue) {
    pointer.raw[aKey] = aValue;
  };
  this.setCommunicationMode = function setCommunicationMode(aConfigurationObject, aMode) {
    pointer.raw["tutoring_service_communication"] = aMode;
  };
  this.setRemoteSocketURL = function setRemoteSocketURL(aConfigurationObject, aURL) {
    pointer.raw["remoteSocketURL"] = aURL;
  };
  this.setRemoteSocketPort = function setRemoteSocketPort(aConfigurationObject, aPort) {
    pointer.raw["remoteSocketPort"] = aPort;
  };
};
CTATConfiguration.prototype = Object.create(CTATBase.prototype);
CTATConfiguration.prototype.constructor = CTATConfiguration;
CTATConfiguration.theConfObject = null;
flashVars = null;
CTATConfiguration.generateDefaultConfigurationObject = function(localVars, targetEnv) {
  if (!CTATConfiguration.theConfObject) {
    CTATConfiguration.theConfObject = new CTATConfiguration;
    var rawList = CTATConfiguration.theConfObject.generateDefaultConfiguration(CTATConfiguration.theConfObject.raw, localVars);
    CTATConfiguration.theConfObject.assignRawFlashVars(rawList);
    if (CTATConfiguration.theConfObject.get("session_id") == "none") {
      CTATConfiguration.theConfObject.set("session_id", CTATGuid.guid());
    }
    flashVars = CTATConfiguration.theConfObject;
    console.log("CTATConfiguration.generateDefaultConfigurationObject() flashVars.getRawFlashVars()['session_id'] " + flashVars.getRawFlashVars()["session_id"]);
    console.log("flashVars.getRawFlashVars()['remoteSocketPort'] " + flashVars.getRawFlashVars()["remoteSocketPort"]);
  }
  if (targetEnv == "Default" || targetEnv == "OLI") {
    CTATConfiguration.theConfObject.setParams(localVars);
  }
  return CTATConfiguration.theConfObject;
};
CTATConfiguration.getRawFlashVars = function() {
  CTATConfiguration.generateDefaultConfigurationObject();
  return CTATConfiguration.theConfObject.getRawFlashVars();
};
CTATConfiguration.get = function(name) {
  CTATConfiguration.generateDefaultConfigurationObject();
  return CTATConfiguration.theConfObject.get(name);
};
CTATConfiguration.set = function(name, value) {
  CTATConfiguration.generateDefaultConfigurationObject();
  CTATConfiguration.theConfObject.set(name, value);
};
CTATConfiguration.getCustomFields = function() {
  CTATConfiguration.generateDefaultConfigurationObject();
  return CTATConfiguration.theConfObject.getCustomFields();
};
CTATConfiguration.setParams = function(newParams) {
  CTATConfiguration.generateDefaultConfigurationObject();
  CTATConfiguration.theConfObject.setParams(newParams);
};
CTATConfiguration.getSingleParameterValues = function(paramNames) {
  CTATConfiguration.generateDefaultConfigurationObject();
  return CTATConfiguration.theConfObject.getSingleParameterValues(paramNames);
};
CTATConfiguration.usingFlash = function() {
  CTATConfiguration.generateDefaultConfigurationObject();
  return CTATConfiguration.theConfObject.usingFlash();
};
CTATConfiguration.prototype["set"] = CTATConfiguration.prototype.set;
CTATConfiguration.prototype["get"] = CTATConfiguration.prototype.get;
goog.provide("CTATTutorMessageBuilder");
goog.require("CTATBase");
CTATTutorMessageBuilder = function() {
  CTATBase.call(this, "CTATTutorMessageBuilder", "__undefined__");
};
CTATTutorMessageBuilder.isHint = function(indicatorObj) {
  if (indicatorObj === null || typeof indicatorObj === "undefined") {
    return false;
  }
  var indicator = indicatorObj.toString().toLowerCase();
  return indicator.indexOf(CTATTutorMessageBuilder.HINT.toLowerCase()) === 0;
};
CTATTutorMessageBuilder.isCorrect = function(indicatorObj) {
  if (indicatorObj === null || typeof indicatorObj === "undefined") {
    return false;
  }
  var indicator = indicatorObj.toString().toLowerCase();
  if (indicator.indexOf(CTATTutorMessageBuilder.CORRECT.toLowerCase()) === 0) {
    return true;
  }
  return indicator.indexOf(CTATExampleTracerLink.SUCCESS.toLowerCase()) === 0;
};
CTATTutorMessageBuilder.prototype = Object.create(CTATBase.prototype);
CTATTutorMessageBuilder.prototype.createInCorrectActionMessage = function(transactionID, sai) {
  this.ctatdebug("createInCorrectActionMessage ()");
  var message = "<message><verb>SendNoteProperty</verb><properties><MessageType>InCorrectAction</MessageType>";
  message += "<transaction_id>" + transactionID + "</transaction_id>";
  this.ctatdebug("In CTATTutorMessageBuilder " + sai);
  message += sai.toXMLString(false);
  message += "</properties></message>";
  return message;
};
CTATTutorMessageBuilder.prototype.createCorrectActionMessage = function(transactionID, sai) {
  this.ctatdebug("createCorrectActionMessage ()");
  var message = "<message><verb>SendNoteProperty</verb><properties><MessageType>CorrectAction</MessageType>";
  message += "<transaction_id>" + transactionID + "</transaction_id>";
  message += sai.toXMLString(false);
  message += "</properties></message>";
  return message;
};
CTATTutorMessageBuilder.prototype.createAssociatedRulesMessageForHint = function(hints, sai, actor, skillBarVector, stepID, transactionID, nTotalHints, currentHint, customFields) {
  nTotalHints = nTotalHints == undefined ? hints.length : nTotalHints;
  currentHint = currentHint == undefined ? 1 : currentHint;
  var message = "<message><verb>SendNoteProperty</verb><properties><MessageType>AssociatedRules</MessageType>";
  message += "<Indicator>Hint</Indicator>";
  message += (sai ? sai : new CTATSAI("", "", "")).toXMLString();
  message += "<TutorAdvice>";
  for (var index = 0;index < hints.length;index++) {
    message += "<value><![CDATA[" + hints[index] + "]]\x3e</value>";
  }
  message += "</TutorAdvice><TotalHintsAvailable>" + nTotalHints + "</TotalHintsAvailable>" + "<CurrentHintNumber>" + currentHint + "</CurrentHintNumber>";
  message += "<Actor>" + actor + "</Actor>";
  message += this.fmtSkillBarVector(skillBarVector);
  message += "<skillBarDelimiter><![CDATA[`]]\x3e</skillBarDelimiter>";
  if (stepID || stepID === 0) {
    message += "<StepID>" + stepID + "</StepID>";
  }
  message += "<transaction_id>" + transactionID + "</transaction_id>";
  message += "<LogAsResult>true</LogAsResult>";
  message += this.formatCustomFields(customFields);
  message += "</properties></message>";
  return message;
};
CTATTutorMessageBuilder.prototype.createAssociatedRulesMessageForAction = function(indicator, sai, actor, studentSAI, skillBarVector, stepID, transactionID, tutorAdvice, outOfOrder, customFields, traceOutcome) {
  this.ctatdebug("TMB.createAssociatedRulesMessageForAction(indicator " + indicator + ", sai " + sai + ", actor " + actor + ", studentSAI " + studentSAI + ",\n  skillBarVector " + skillBarVector + ", stepID " + stepID + ", transactionID " + transactionID + ",\n  tutorAdvice " + tutorAdvice + ", outOfOrder " + outOfOrder + ", traceOutcome " + traceOutcome);
  var message = "<message><verb>SendNoteProperty</verb><properties><MessageType>AssociatedRules</MessageType>";
  message += "<Indicator>" + (CTATTutorMessageBuilder.isCorrect(indicator) ? "Correct" : "InCorrect") + "</Indicator>";
  message += (sai ? sai : new CTATSAI("", "", "")).toXMLString();
  var temp = studentSAI.toXMLString().replace("<Selection>", "<StudentSelection>").replace("<Action>", "<StudentAction>").replace("<Input>", "<StudentInput>");
  temp = temp.replace("</Selection>", "</StudentSelection>").replace("</Action>", "</StudentAction>").replace("</Input>", "</StudentInput>");
  message += temp;
  message += "<Actor>" + actor + "</Actor>";
  message += this.fmtSkillBarVector(skillBarVector);
  message += "<skillBarDelimiter><![CDATA[`]]\x3e</skillBarDelimiter>";
  message += "<StepID>" + stepID + "</StepID>";
  message += "<transaction_id>" + transactionID + "</transaction_id>";
  if (tutorAdvice) {
    message += "<TutorAdvice><![CDATA[" + tutorAdvice + "]]\x3e</TutorAdvice>";
  }
  message += "<LogAsResult>true</LogAsResult>";
  message += "<end_of_transaction>" + (tutorAdvice ? false : true) + "</end_of_transaction>";
  message += typeof outOfOrder == "undefined" || !outOfOrder ? "" : "<OutOfOrder>true</OutOfOrder>";
  message += traceOutcome ? "<" + CTATMsgType.TRACE_OUTCOME + ">" + traceOutcome + "</" + CTATMsgType.TRACE_OUTCOME + ">" : "";
  message += this.formatCustomFields(customFields);
  message += "</properties></message>";
  return message;
};
CTATTutorMessageBuilder.prototype.formatCustomFields = function(customFields) {
  var result = "";
  if (customFields) {
    for (var name in customFields) {
      if (!customFields.hasOwnProperty(name)) {
        continue;
      }
      var value = customFields[name] == null ? "" : customFields[name].toString();
      result += "<custom_field><name>" + name + "</name><value>" + value + "</value></custom_field>";
    }
  }
  return result ? "<custom_fields>" + result + "</custom_fields>" : "";
};
CTATTutorMessageBuilder.prototype.isDoneStep = function(assocRulesResp, correct) {
  correct[0] = false;
  var indicatorObj = assocRulesResp.getIndicator();
  if (!indicatorObj) {
    return false;
  }
  var selectionObj = assocRulesResp.getStudentSelection();
  if (!selectionObj) {
    selectionObj = assocRulesResp.getProperty("tool_selection");
  }
  correct[0] = CTATTutorMessageBuilder.isCorrect(indicator);
  var result = "done" == selectionObj;
  this.ctatdebug("isDoneStep() indicatorObj " + indicatorObj + ", selectionObj " + selectionObj + ", correct[0] " + correct[0] + ", result " + result);
  return result;
};
CTATTutorMessageBuilder.prototype.createHintMessage = function(hints, sai, stepID, transactionID) {
  var message = "<message><verb>SendNoteProperty</verb><properties><MessageType>ShowHintsMessage</MessageType>";
  message += "<HintsMessage>";
  for (var index = 0;index < hints.length;index++) {
    message += "<value><![CDATA[" + hints[index] + "]]\x3e</value>";
  }
  message += "</HintsMessage>";
  if (sai && sai["toXMLString"]) {
    message += sai.toXMLString();
  }
  message += "<transaction_id>" + transactionID + "</transaction_id>";
  message += "</properties></message>";
  return message;
};
CTATTutorMessageBuilder.prototype.createErrorMessage = function(errorType, details) {
  var message = "<message><verb>SendNoteProperty</verb><properties><MessageType>TutoringServiceError</MessageType><ErrorType>";
  message += errorType;
  message += "</ErrorType><Details>";
  message += details ? details : "";
  message += "</Details></properties></message>";
  return message;
};
CTATTutorMessageBuilder.prototype.createSuccessMessage = function(txnID, successMsg) {
  var message = "<message><verb>SendNoteProperty</verb><properties><MessageType>SuccessMessage</MessageType>";
  message += "<SuccessMsg><![CDATA[" + successMsg + "]]\x3e</SuccessMsg>";
  message += "<transaction_id>" + txnID + "</transaction_id>";
  message += "<end_of_transaction>true</end_of_transaction>";
  message += "</properties></message>";
  return message;
};
CTATTutorMessageBuilder.prototype.createBuggyMessage = function(txnID, buggyMsg) {
  var message = "<message><verb>SendNoteProperty</verb><properties><MessageType>BuggyMessage</MessageType>";
  message += "<BuggyMsg><![CDATA[" + buggyMsg + "]]\x3e</BuggyMsg>";
  message += "<transaction_id>" + txnID + "</transaction_id>";
  message += "<end_of_transaction>true</end_of_transaction>";
  message += "</properties></message>";
  return message;
};
CTATTutorMessageBuilder.prototype.createLockWidgetMsg = function(lockWidget) {
  var message = "<message><verb>SendNoteProperty</verb><properties><MessageType>SendWidgetLock</MessageType>";
  message += "<WidgetLockFlag>" + lockWidget + "</WidgetLockFlag>";
  message += "</properties></message>";
  return message;
};
CTATTutorMessageBuilder.prototype.createMessage = function(messageType, props) {
  var message = "<message><verb>SendNoteProperty</verb><properties><MessageType>" + messageType + "</MessageType>";
  if (props) {
    for (var prop in props) {
      message += "<" + prop + ">" + props[prop] + "</" + prop + ">";
    }
  }
  message += "</properties></message>";
  this.ctatdebug("CTATTutorMessageBuilder.createMessage(" + messageType + ", " + props + ") returns " + message);
  return message;
};
CTATTutorMessageBuilder.prototype.createStateGraphMessage = function(caseInsensitive, isUnordered, lockWidget, suppressStudentFeedback, highlightRightSelection, tracerConfirmDone, skillBars) {
  var message = "<message><verb>SendNoteProperty</verb><properties><MessageType>StateGraph</MessageType>";
  message += "<caseInsensitive>" + caseInsensitive + "</caseInsensitive>";
  message += "<unordered>" + isUnordered + "</unordered>";
  message += "<lockWidget>" + lockWidget + "</lockWidget>";
  message += "<suppressStudentFeedback>" + suppressStudentFeedback + "</suppressStudentFeedback>";
  message += "<highlightRightSelection>" + highlightRightSelection + "</highlightRightSelection>";
  message += "<confirmDone>" + tracerConfirmDone + "</confirmDone>";
  message += "<skillBarDelimiter><![CDATA[`]]\x3e</skillBarDelimiter>";
  message += this.fmtSkillBarVector(skillBars);
  message += "</properties></message>";
  return message;
};
CTATTutorMessageBuilder.prototype.fmtSkillBarVector = function(skillBars) {
  var result = "";
  if (skillBars !== undefined && skillBars !== null && skillBars.length > 0) {
    result += "<Skills>";
    for (var i = 0;i < skillBars.length;i++) {
      result += "<value><![CDATA[" + skillBars[i] + "]]\x3e</value>";
    }
    result += "</Skills>";
  }
  return result;
};
CTATTutorMessageBuilder.prototype.createHighlightWidgetMessage = function(selection, action, highlightMsgText, txnID) {
  var message = "<message><verb>SendNoteProperty</verb><properties><MessageType>HighlightMsg</MessageType>";
  message += "<HighlightMsgText>" + highlightMsgText + "</HighlightMsgText>";
  message += "<Selection><value>" + selection + "</value></Selection>";
  message += "<Action><value>" + action + "</value></Action>";
  message += "<transaction_id>" + txnID + "</transaction_id>";
  message += "<end_of_transaction>true</end_of_transaction>";
  message += "</properties></message>";
  return message;
};
Object.defineProperty(CTATTutorMessageBuilder, "TRIGGER", {enumerable:false, configurable:false, writable:false, value:"trigger"});
Object.defineProperty(CTATTutorMessageBuilder, "SUBTYPE", {enumerable:false, configurable:false, writable:false, value:"subtype"});
Object.defineProperty(CTATTutorMessageBuilder, "TUTOR_PERFORMED", {enumerable:false, configurable:false, writable:false, value:"tutor-performed"});
Object.defineProperty(CTATTutorMessageBuilder, "HINT", {enumerable:false, configurable:false, writable:false, value:"Hint"});
Object.defineProperty(CTATTutorMessageBuilder, "CORRECT", {enumerable:false, configurable:false, writable:false, value:"Correct"});
CTATTutorMessageBuilder.prototype.constructor = CTATTutorMessageBuilder;
if (typeof module !== "undefined") {
  module.exports = CTATTutorMessageBuilder;
}
;goog.provide("CTATLMS");
goog.require("CTATConfiguration");
goog.require("CTATTutorMessageBuilder");
goog.require("CTAT.ToolTutor");
CTATLMS = {};
CTATLMS.identifier = null;
CTATLMS.initLMSConnection = function() {
};
CTATLMS.closeLMSConnection = function() {
};
CTATLMS.setValue = function(key, value) {
};
CTATLMS.getValue = function(key) {
  return null;
};
CTATLMS.saveProblemState = function(data) {
};
CTATLMS.getProblemState = function(handler) {
  if (CTATConfiguration.get("restoreProblemUrl")) {
    $.get(CTATConfiguration.get("restoreProblemUrl"), "", null, "text").done(function(data) {
      handler(data);
    }).fail(function(jqxhr, status, thrownError) {
      handler(null);
      var msg = (new CTATTutorMessageBuilder).createErrorMessage("Load ProblemState Error", status + " " + thrownError);
      CTAT.ToolTutor.sendToInterface(msg, true);
    });
  } else {
    handler(null);
  }
};
CTATLMS.gradeStudent = function(correct_steps, required_steps) {
};
CTATLMS.logEvent = function(aMessage) {
};
CTATLMS.processProblemSummary = function(problem_summary_xml) {
};
CTATLMS.is = {};
CTATLMS.init = {};
CTATLMS.init.StandAlone = function() {
  CTATLMS.identifier = null;
  CTATLMS.initLMSConnection = function() {
  };
  CTATLMS.closeLMSConnection = function() {
  };
  CTATLMS.commit = function() {
  };
  CTATLMS.setValue = function() {
  };
  CTATLMS.getValue = function() {
    return null;
  };
  CTATLMS.logEvent = function(aMessage) {
  };
  CTATLMS.saveProblemState = function() {
  };
  CTATLMS.getProblemState = function(handler) {
    return handler(null);
  };
  CTATLMS.gradeStudent = function() {
  };
  CTATLMS.processProblemSummary = function() {
  };
};
CTATLMS.is.SCORM = function() {
  return window.location.search && /[?&;]mode=SCORM/i.test(window.location.search);
};
CTATLMS.init.SCORM = function() {
  var sInit = false;
  CTATLMS.identifier = "SCORM";
  CTATLMS.initLMSConnection = function() {
    if (sInit === true) {
      return;
    }
    window.parent.doLMSInitialize();
    var pRestoreStatus = CTATLMS.getValue("cmi.core.lesson_status");
    CTATConfiguration.set("problem_state_status", pRestoreStatus);
    if (pRestoreStatus == "not attempted") {
      CTATConfiguration.set("problem_state_status", "incomplete");
    }
    if (pRestoreStatus == "passed") {
      CTATConfiguration.set("problem_state_status", "completed");
    }
    if (pRestoreStatus == "failed") {
      CTATConfiguration.set("problem_state_status", "incomplete");
    }
    if (pRestoreStatus == "browsed") {
      CTATConfiguration.set("problem_state_status", "incomplete");
    }
    CTATLMS.setValue("cmi.core.lesson_status", "incomplete");
    sInit = true;
  };
  CTATLMS.commit = window.parent.doLMSCommit;
  CTATLMS.closeLMSConnection = window.parent.doLMSFinish;
  CTATLMS.setValue = window.parent.doLMSSetValue;
  CTATLMS.getValue = window.parent.doLMSGetValue;
  CTATLMS.logEvent = function(aMessage) {
  };
  CTATLMS.saveProblemState = function(data) {
    var pResult = CTATLMS.setValue("cmi.suspend_data", data.problem_state);
    return pResult;
  };
  CTATLMS.getProblemState = function(handler) {
    var pResult = CTATLMS.getValue("cmi.suspend_data");
    if (!pResult && window.parent && typeof window.parent.doLMSGetLastError == "function") {
      var lastError = window.parent.doLMSGetLastError();
      if (lastError != 0) {
        console.log("Empty result with error " + lastError + " from LMS.getValue('cmi.suspend_data'):", window.parent.doLMSGetErrorString ? window.parent.doLMSGetErrorString(lastError) : "");
        return handler(null);
      }
    }
    return handler(pResult);
  };
  CTATLMS.gradeStudent = function(correct_steps, required_steps) {
    CTATLMS.setValue("cmi.core.score.min", 0);
    CTATLMS.setValue("cmi.core.score.max", 100);
    return CTATLMS.setValue("cmi.core.score.raw", Number((correct_steps / required_steps).toFixed(2).replace(/[.]/, "")));
  };
  CTATLMS.processProblemSummary = function(problemXML) {
    var cmi = ["cmi.core.lesson_status", "cmi.core.score.raw", "cmi.core.exit", "cmi.core.session_time"];
    cmi.forEach(function(key) {
      var value = this.getElementsByTagName(key);
      CTATLMS.setValue(key, $("<div>").html(value[0].innerHTML).text());
    }, problemXML);
    CTATLMS.commit();
    CTATLMS.closeLMSConnection();
  };
  CTATLMS.initLMSConnection();
};
CTATLMS.is.XBlock = function() {
  return window.location.search && /[?&;]mode=XBlock/i.test(window.location.search);
};
CTATLMS.init.XBlock = function() {
  var porigin = document.referrer ? (new URL(document.referrer)).origin : "";
  CTATLMS.identifier = "XBlock";
  CTATLMS.initLMSConnection = function() {
  };
  CTATLMS.closeLMSConnection = function() {
  };
  CTATLMS.commit = function() {
  };
  CTATLMS.setValue = function(key, value) {
  };
  CTATLMS.getValue = function(key) {
    return null;
  };
  CTATLMS.saveProblemState = function(state) {
    parent.postMessage({"action":"save_problem_state", "input":window.btoa(state.problem_state)}, porigin);
  };
  CTATLMS.getProblemState = function(handler) {
    return handler(window.atob(CTATConfiguration.get("saveandrestore")));
  };
  CTATLMS.gradeStudent = function(correct_steps, total_steps) {
    parent.postMessage({"action":"grade", "input":{"value":correct_steps, "max":total_steps}}, porigin);
  };
  CTATLMS.logEvent = function(aMessage) {
    parent.postMessage({"action":"log", "input":aMessage}, porigin);
  };
  CTATLMS.processProblemSummary = function(problemXML) {
  };
};
CTATLMS.is.Authoring = function() {
  return window.location.search && /[?&;]mode=AUTH(ORING)?/i.test(window.location.search);
};
CTATLMS.is.ToolsListener = function() {
  return window.location.search && /[?&;]mode=ctatAsListener/i.test(window.location.search);
};
CTATLMS.is.OLI = function() {
  return window.frameElement && window.frameElement.getAttribute("data-superactivityserver") || typeof CTATTarget != "undefined" && CTATTarget == "OLI";
};
CTATLMS.is.TutorShop = function() {
  return window.frameElement && /"LMS":\s*"TutorShop"/i.test(window.frameElement.getAttribute("data-params"));
};
CTATLMS.init.TutorShop = function() {
  CTATLMS.identifier = "TutorShop";
  CTATLMS.initLMSConnection = function() {
  };
  CTATLMS.closeLMSConnection = function() {
  };
  CTATLMS.commit = function() {
  };
  CTATLMS.setValue = function(key, value) {
  };
  CTATLMS.getValue = function(key) {
    return null;
  };
  CTATLMS.logEvent = function(aMessage) {
  };
  CTATLMS.saveProblemState = function(data) {
    if (CTATConfiguration.get("restoreProblemUrl") && CTATConfiguration.get("curriculum_service_url")) {
      data["session_id"] = data["session_id"] ? data["session_id"] : "dummySession";
      var postVars = [];
      for (var prop in data) {
        postVars.push(prop + "=" + encodeURIComponent(data[prop]));
      }
      $.post(CTATConfiguration.get("curriculum_service_url"), postVars.join("&"), null, "application/x-www-form-urlencoded");
    }
  };
  CTATLMS.getProblemState = function(handler) {
    if (CTATConfiguration.get("restoreProblemUrl")) {
      $.get(CTATConfiguration.get("restoreProblemUrl"), "", null, "text").done(function(data) {
        handler(data);
      }).fail(function(jqxhr, status, thrownError) {
        handler(null);
        var msg = (new CTATTutorMessageBuilder).createErrorMessage("Load ProblemState Error", status + " " + thrownError);
        CTAT.ToolTutor.sendToInterface(msg, true);
      });
    } else {
      handler(null);
    }
  };
  CTATLMS.gradeStudent = function() {
  };
  CTATLMS.processProblemSummary = function() {
  };
};
CTATLMS.is.Assistments = function() {
  return CTATTarget && CTATTarget == "ASSISTMENTS";
};
var evt = new Event("ctatlms");
console.log("CTATLMS.js dispatch send evt", evt);
parent.dispatchEvent(evt);
useDebuggingBasic = true;
console.log("CTATLMS.js dispatch return from evt", evt);
goog.provide("CTATCommLibrary");
goog.require("CTATBase");
goog.require("CTATConnection");
goog.require("CTATGlobals");
goog.require("CTATWSConnection");
goog.require("CTATScrim");
goog.require("CTAT.ToolTutor");
goog.require("CTATLanguageManager");
goog.require("CTATLMS");
var bundleFormatter = "";
var inBundle = false;
var useBundling = false;
var useOLIEncoding = false;
CTATCommLibrary = function(aHandler, aUseScrim) {
  CTATBase.call(this, "CTATCommLibrary", aHandler);
  authenticityToken = "";
  var xmlHeader = '<?xml version="1.0" encoding="UTF-8"?>';
  var fixedURL = "";
  var httpreqindex = 0;
  var httprequests = [];
  var thenRequest = null;
  var httphandler = aHandler ? aHandler : null;
  var useScrim = aUseScrim == null ? true : aUseScrim;
  var useCommSettings = true;
  var messageListener = null;
  var pointer = this;
  var socketType = "http";
  var connectionRefusedMessage = "ERROR_CONN_TS";
  var fileTobeLoaded = "";
  this.teamMembers = {};
  this.setUseCommSettings = function setUseCommSettings(aValue) {
    useCommSettings = aValue;
  };
  this.getUseCommSettings = function getUseCommSettings() {
    return useCommSettings;
  };
  this.setConnectionRefusedMessage = function setConnectionRefusedMessage(aValue) {
    connectionRefusedMessage = aValue;
  };
  this.sendTutorReady = function(otm) {
    var collaborators = CTATConfiguration.get("collaborators");
    var me = CTATConfiguration.get("user_guid");
    var gPRE = CTATCommShell.commShell.getGotProblemRestoreEnd();
    console.log("sendTutorReady collaborators", collaborators, "otm", otm, "teamMembers", this.teamMembers, "gotProblemRestoreEnd", gPRE);
    if (otm && otm[me] && otm[me].subscribed != -1) {
      return otm;
    }
    if (!gPRE) {
      return otm;
    } else {
      var tmObj = this.teamMembers[me] || {};
      if (!tmObj.subscribed) {
        tmObj.subscribed = Date.now();
        this.teamMembers[me] = tmObj;
      }
    }
    for (var c in this.teamMembers) {
      if (this.teamMembers[c].subscribed == -1) {
        return otm;
      }
    }
    parent.postMessage({command:"tutorready", username:CTATConfiguration.get("user_guid"), teamMembers:this.teamMembers}, "*");
    return otm;
  };
  this.interpretCollab = function(data) {
    ctatdebug("Interpret collab:", data.command, data);
    var result = null;
    if (data.command == "tutorready" && data.username != CTATConfiguration.get("user_guid")) {
      var collaborators = CTATConfiguration.get("collaborators");
      var c = 0, cNames = (collaborators || "").split(",");
      console.log("interpretCollab", collaborators, "teamMembers", this.teamMembers, "cNames", cNames);
      for (;c < cNames.length;++c) {
        var tmObj = this.teamMembers[cNames[c]] || {};
        if (tmObj.subscribed == -1) {
          console.log("collaborator quit:", cNames[c], tmObj, new Date);
          break;
        }
        if (data.username == cNames[c]) {
          tmObj.subscribed = Date.now();
          this.teamMembers[cNames[c]] = tmObj;
        }
        if (!tmObj.subscribed) {
          console.log("collaborator still missing:", cNames[c], tmObj, new Date);
          break;
        }
      }
      this.sendTutorReady(data.teamMembers);
      if (c >= cNames.length) {
        CTATScrim.scrim.scrimDown();
      }
    } else {
      if (data.command == "message") {
        if (data.user_guid != CTATConfiguration.get("user_guid")) {
          result = data.data;
        } else {
          ctatdebug("Own message echoed " + data.data);
        }
      } else {
        if (data.command == "unsubscribed") {
          var tmObj$7 = this.teamMembers[data.from || ","];
          if (tmObj$7 && tmObj$7.subscribed != -1) {
            tmObj$7.subscribed = -1;
            var msgPrefix = CTATGlobals.languageManager.filterString("YOUR_COLLABORATOR") + (data.from || "") + " ";
            if (typeof exitTutor == "function") {
              var toDisplay = msgPrefix + CTATGlobals.languageManager.filterString("COLLABORATOR_QUIT_CLICK_OK");
              console.log("scrimUp(" + toDisplay + ")", new Date, exitTutor);
              CTATScrim.scrim.OKScrimUp(toDisplay, exitTutor);
            } else {
              var toDisplay$8 = msgPrefix + CTATGlobals.languageManager.filterString("COLLABORATOR_QUIT_CLICK_X");
              console.log("scrimUp(" + toDisplay$8 + ")", new Date, typeof exitTutor);
              CTATScrim.scrim.scrimUp(toDisplay$8);
            }
          }
        } else {
          if (data.command == "subscribed") {
            if (!data.team_members) {
              console.log("interpretCollab: team_members property missing", data);
            } else {
              console.log("subscribed from " + data.from + ": teamMembers", this.teamMembers, "data.team_members", data.team_members);
            }
          }
        }
      }
    }
    typeof document.dispatchEvent == "function" && document.dispatchEvent(new CustomEvent("receiveFromCollaborator", {detail:data}));
    return result;
  };
  this.setSocketType = function setSocketType(aType) {
    socketType = aType;
    if (pointer.hasWebSocket() || pointer.hasPostMessage()) {
      $(window).on("message", function(event) {
        if (event.originalEvent.origin !== window.location.origin) {
          return;
        }
        var data = event.originalEvent ? event.originalEvent.data : null;
        console.log("message from " + data.from + ":", data);
        if (!data) {
          return;
        }
        if (httphandler) {
          var message = pointer.interpretCollab(data);
          if (message) {
            httphandler.processMessage(message);
            if (!pointer.hasPostMessage()) {
              CTAT.ToolTutor.sendToTutor(message);
            }
          }
        } else {
          console.log("No http handler defined for websocket listener.");
        }
      });
    }
  };
  this.hasSecureSocket = function() {
    return /https/i.test(socketType) || /wss/i.test(socketType);
  };
  this.hasJavaScriptConnection = function() {
    return /javascript/i.test(socketType);
  };
  this.hasWebSocket = function() {
    return /websocket/i.test(socketType);
  };
  this.hasPostMessage = function() {
    return /postmessage/i.test(socketType);
  };
  this.assignHandler = function assignHandler(aHandler) {
    httphandler = aHandler;
  };
  this.assignMessageListener = function assignMessageListener(aListener) {
    messageListener = aListener;
  };
  this.encodeVariables = function encodeVariables(variables) {
    pointer.ctatdebug("encodeVariables ()");
    var parameterString = "";
    for (var i = 0;i < variables.length;i++) {
      var variable = variables[i];
      if (i > 0) {
        parameterString += "&";
      }
      parameterString += variable.name;
      parameterString += "=";
      parameterString += encodeURIComponent(variable.value);
    }
    return parameterString;
  };
  this.encodeVariablesOLI = function encodeVariablesOLI(variables) {
    pointer.ctatdebug("encodeVariablesOLI ()");
    var parameterString = "";
    for (var i = 0;i < variables.length;i++) {
      var variable = variables[i];
      if (i > 0) {
        parameterString += "&";
      }
      parameterString += variable.name;
      parameterString += "=";
      parameterString += encodeURIComponent(variable.value);
    }
    return parameterString;
  };
  this.createConnection = function createConnection(aVars, aURL, canBeWebSocket) {
    pointer.ctatdebug("createConnection () canBeWebSocket " + canBeWebSocket);
    canBeWebSocket = typeof canBeWebSocket == "undefined" ? true : canBeWebSocket !== false;
    if (!aURL) {
      return new CTATConnection(aVars);
    }
    var newConnection = null;
    if (canBeWebSocket && pointer.hasWebSocket()) {
      newConnection = this.findWSConnection(aURL);
      if (!newConnection) {
        newConnection = new CTATWSConnection(aVars);
        newConnection.setID(httpreqindex);
        newConnection.setURL(aURL);
        newConnection.assignReceiveFunction(this.processWSReply);
        newConnection.assignCloseFunction(this.processWSClose);
        httprequests.push(newConnection);
        httpreqindex++;
      }
      return newConnection;
    }
    newConnection = new CTATConnection(aVars);
    newConnection.setID(httpreqindex);
    newConnection.setURL(aURL);
    newConnection.assignReceiveFunction(pointer.processReply);
    httprequests.push(newConnection);
    httpreqindex++;
    thenRequest = newConnection;
    return newConnection;
  };
  this.findWSConnection = function(aURL) {
    ctatdebug("findWSConnection( " + aURL + " )");
    var sURL = pointer.editSocketURLForHTTPS(aURL);
    for (var request = 0;request < httprequests.length;request++) {
      var testConnection = httprequests[request];
      ctatdebug("checking: socketType = " + testConnection.getSocketType() + " URL = " + testConnection.getURL());
      if (testConnection.getSocketType() == "ws" && testConnection.getURL() == sURL) {
        return testConnection;
      }
    }
    return null;
  };
  this.startBundle = function startBundle() {
    pointer.ctatdebug("startBundle ()");
    if (useBundling === false) {
      this.ctatdebug("Not using bundling, bump");
      return;
    }
    bundleFormatter = xmlHeader + "<message><verb/><properties><MessageType>MessageBundle</MessageType><messages>";
    inBundle = true;
  };
  this.endBundle = function endBundle() {
    pointer.ctatdebug("endBundle ()");
    if (useBundling === false) {
      pointer.ctatdebug("Not using bundling, bump");
      return;
    }
    inBundle = false;
    bundleFormatter += "</messages></properties></message>";
    pointer.sendXML(bundleFormatter);
  };
  this.setFixedURL = function setFixedURL(aURL) {
    fixedURL = aURL;
  };
  this.getURL = function getURL() {
    pointer.ctatdebug("getURL ()");
    if (fixedURL !== "") {
      pointer.ctatdebug("Returning fixedURL: " + fixedURL);
      return fixedURL;
    }
    var vars = flashVars.getRawFlashVars();
    var prefix = "http://";
    if (pointer.hasSecureSocket()) {
      prefix = "https://";
    }
    var url = prefix + vars["remoteSocketURL"] + ":" + vars["remoteSocketPort"];
    if (vars["remoteSocketURL"] && vars["remoteSocketURL"].indexOf("http") != -1) {
      url = vars["remoteSocketURL"] + ":" + vars["remoteSocketPort"];
    }
    return url;
  };
  this.sendXML = function sendXML(aMessage, sendToCollaborators) {
    pointer.ctatdebug("Sending: " + aMessage);
    pointer.ctatdebug("sendXML (" + aMessage + ")");
    if (httphandler["updateLastActionTimestamp"]) {
      httphandler.updateLastActionTimestamp();
    }
    if (useBundling === true) {
      if (inBundle === true) {
        pointer.ctatdebug("Bundling ...");
        bundleFormatter += aMessage;
        return;
      } else {
        bundleFormatter = aMessage;
      }
    } else {
      bundleFormatter = aMessage;
    }
    var vars = flashVars.getRawFlashVars();
    var url = this.getURL();
    var formatted = bundleFormatter;
    if (bundleFormatter.indexOf("<?xml") == -1) {
      formatted = '<?xml version="1.0" encoding="UTF-8"?>' + bundleFormatter;
    }
    if (pointer.getUseCommSettings() && pointer.hasJavaScriptConnection()) {
      pointer.sendToToolsOrCollaborators(url, formatted, sendToCollaborators);
      CTAT.ToolTutor.sendToTutor(formatted);
    } else {
      pointer.send_post(url, formatted);
    }
  };
  this.sendToToolsOrCollaborators = function(url, aMessage, sendToCollaborators) {
    if (pointer.hasWebSocket()) {
      if (CTATConfiguration.get("mode") == "ctatAsListener") {
        this.send_post(url, aMessage);
        return true;
      }
      if (typeof sendToCollaborators == "undefined" ? true : sendToCollaborators !== false) {
        this.send_post(url, aMessage);
        return true;
      }
    }
    return false;
  };
  this.sendXMLNoBundle = function sendXMLNoBundle(aMessage) {
    pointer.ctatdebug("sendXMLNoBundle (" + aMessage + ")");
    bundleFormatter = aMessage;
    if (httphandler["updateLastActionTimestamp"]) {
      httphandler.updateLastActionTimestamp();
    }
    var url = this.getURL();
    var formatted = aMessage;
    if (aMessage.indexOf("<?xml") == -1) {
      formatted = '<?xml version="1.0" encoding="UTF-8"?>' + aMessage;
    }
    var vars = flashVars.getRawFlashVars();
    if (pointer.getUseCommSettings() && pointer.hasJavaScriptConnection()) {
      pointer.sendToToolsOrCollaborators(url, formatted);
      CTAT.ToolTutor.sendToTutor(formatted);
    } else {
      this.send_post(url, formatted);
    }
  };
  this.sendXMLURL = function sendXMLURL(aMessage, aURL, sendOnlyToCollaborators) {
    ctatdebug("sendXMLURL (" + aURL + ", " + sendOnlyToCollaborators + ")");
    var formatted = aMessage;
    if (aMessage.indexOf("<?xml") == -1) {
      formatted = '<?xml version="1.0" encoding="UTF-8"?>' + aMessage;
    }
    var vars = flashVars.getRawFlashVars();
    pointer.ctatdebug("Sending: " + formatted);
    if (httphandler["updateLastActionTimestamp"]) {
      httphandler.updateLastActionTimestamp();
    }
    if (this.getUseCommSettings() && pointer.hasJavaScriptConnection()) {
      pointer.sendToToolsOrCollaborators(aURL, formatted);
      if (sendOnlyToCollaborators) {
        return;
      }
      CTAT.ToolTutor.sendToTutor(formatted);
    } else {
      this.send_post(aURL, formatted);
    }
  };
  this.send_post_variables = function send_post_variables(url, variables) {
    pointer.ctatdebug("send_post_variables (" + url + ")");
    var vars = flashVars.getRawFlashVars();
    var res = url;
    var data = "";
    if (useOLIEncoding === false) {
      data = this.encodeVariables(variables);
    } else {
      data = this.encodeVariablesOLI(variables);
    }
    this.ctatdebug("Sending: " + data);
    if (httphandler["updateLastActionTimestamp"]) {
      httphandler.updateLastActionTimestamp();
    }
    if (CTATGlobals.CommDisabled === true) {
      pointer.ctatdebug("Communications globally disabled, please check your settings");
      return;
    }
    var newConnection = pointer.createConnection(CTATConfiguration.getRawFlashVars(), url, false);
    newConnection.setContentType("application/x-www-form-urlencoded");
    pointer.ctatdebug("CTATCommLibrary.send_post_variables() data to send:\n  " + data);
    if (messageListener !== null) {
      messageListener.processOutgoing(data);
    }
    newConnection.setURL(res);
    newConnection.setData(data);
    newConnection.assignReceiveFunction(pointer.processReply);
    newConnection.send();
  };
  this.formPostMessage = function(data) {
    var postObject = {command:"message", user_guid:CTATConfiguration.get("user_guid"), data:data};
    return postObject;
  };
  this.send_post = function send_post(url, data) {
    var newConnection = null;
    ctatdebug("send_post (" + url + ")");
    if (CTATGlobals.CommDisabled === true) {
      pointer.ctatdebug("Communications globally disabled, please check your settings");
      return;
    }
    ctatdebug("Outgoing on wire, " + (pointer.hasPostMessage() ? "to post" : "no post") + "; data " + data);
    var vars = flashVars.getRawFlashVars();
    var res = url;
    if (pointer.hasPostMessage()) {
      var m = pointer.formPostMessage(data);
      m.dest = "sendToTutor";
      parent.postMessage(m, parent.location.origin);
      return;
    }
    if (pointer.hasWebSocket()) {
      if (CTATCommShell.commShell.hasTutorShopCable()) {
        parent.postMessage(pointer.formPostMessage(data), "*");
        return;
      } else {
        if (url) {
          ctatdebug("opening websocket connection: url " + url);
          res = url.replace(/https?:/, "ws:");
          res = pointer.editSocketURLForHTTPS(res);
          ctatdebug("opening websocket connection to " + res);
        }
      }
    }
    newConnection = pointer.createConnection(vars, res);
    newConnection.setData(data);
    if (messageListener !== null) {
      messageListener.processOutgoing(data);
    }
    newConnection.send();
  };
  this.processReply = function processReply(dataOrEvent, textStatus, xmlhttp) {
    pointer.ctatdebug("processReply (" + httprequests.length + "," + dataOrEvent + ", ...)");
    if (typeof xmlhttp == "undefined") {
      xmlhttp = typeof this.getHTTPObject == "function" && this.getHTTPObject();
    }
    var i = 0;
    var found = false;
    var stringDelivery = [];
    var request = 0;
    for (request = 0;request < httprequests.length;request++) {
      var testConnection = httprequests[request];
      if (!testConnection || typeof testConnection.getHTTPObject != "function") {
        continue;
      }
      var testObject = testConnection.getHTTPObject();
      pointer.ctatdebug("Testing connection entry[" + request + "]: readyState & status: " + (testObject ? testObject.readyState + " & " + testObject.status : "null") + ", consumed: " + testConnection.getConsumed());
      if (!testObject) {
        continue;
      }
      if (testObject.readyState == 4 && testConnection.getConsumed() === false) {
        pointer.ctatdebug("Investigating request response: " + i + " -> " + testObject.status + ", for: " + testConnection.getURL());
        found = false;
        if (testObject.status === 0) {
          found = true;
          pointer.ctatdebug("Received message (status 0): (" + testObject.responseText + "), status: " + testObject.status);
          if (useScrim) {
            CTATScrim.scrim.errorScrimUp(CTATGlobals.languageManager.filterString(connectionRefusedMessage));
          }
        }
        if (testObject.status == 408) {
          found = true;
          pointer.ctatdebug("Received message (status 408): " + testObject.responseText);
          if (useScrim) {
            CTATScrim.scrim.scrimDown();
          }
        }
        if (testObject.status == 502) {
          found = true;
          pointer.ctatdebug("Received message (status 502): " + testObject.responseText);
          if (useScrim) {
            CTATScrim.scrim.errorScrimUp(CTATGlobals.languageManager.filterString(ERROR_502));
          }
        }
        if (testObject.status == 200) {
          found = true;
          pointer.ctatdebug("Processing 200 response ...");
          if (httphandler !== null) {
            stringDelivery.push(testObject.responseText);
            if (messageListener !== null) {
              messageListener.processIncoming(testObject.responseText);
            }
          } else {
            pointer.ctatdebug("Error: httphandler is null, can't process response!");
          }
        } else {
          if (httphandler && httphandler.processError) {
            found = true;
            pointer.ctatdebug("Processing non-200 response, status " + testObject.status);
            httphandler.processError(testObject.status, testObject.responseText);
          }
        }
        if (found === false) {
          pointer.ctatdebug("Error: status not handled for: " + testObject.status);
        }
        pointer.ctatdebug("Marking connection as consumed ...");
        testConnection.setConsumed(true);
      } else {
        if (testObject.readyState === 0) {
          pointer.ctatdebug("Received message (status 0, request not initialized)");
        }
        if (testObject.readyState === 1) {
          pointer.ctatdebug("Received message (status 1, server connection established)");
        }
        if (testObject.readyState === 2) {
          pointer.ctatdebug("Received message (status 2, request received)");
        }
        if (testObject.readyState === 3) {
          pointer.ctatdebug("Received message (status 3, processing request)");
        }
      }
      i++;
    }
    pointer.cleanup();
    for (var t = 0;t < stringDelivery.length;t++) {
      pointer.ctatdebug("Processing incoming message: " + t);
      var aMessage = stringDelivery[t];
      if (aMessage.indexOf("status=success") != -1) {
        pointer.ctatdebug("Info: logging success message received, not propagating to message handler");
      } else {
        pointer.ctatdebug("Processing incoming message: " + aMessage);
        httphandler.processMessage(aMessage);
      }
    }
  };
  this.processWSReply = function(aMessage) {
    pointer.ctatdebug("processWSReply() length " + (aMessage === null ? null : aMessage.toString().length));
    if (typeof aMessage == "string") {
      if (messageListener !== null) {
        messageListener.processIncoming(aMessage);
      }
      if (aMessage.indexOf("status=success") != -1) {
        pointer.ctatdebug("processWSReply() logging success message received, not propagating to message handler: " + aMessage);
      } else {
        pointer.ctatdebug("Processing incoming message: " + aMessage);
        httphandler.processMessage(aMessage);
      }
    }
  };
  this.processWSClose = function(evt) {
    pointer.ctatdebug("processWSClose(" + evt + ")");
    if (evt instanceof CloseEvent) {
      pointer.ctatdebug("CloseEvent: code " + evt.code + ", reason " + evt.reason + ", wasClean " + evt.wasClean);
    }
    if (CTATLMS.is.Authoring() || CTATLMS.is.ToolsListener()) {
      CTATScrim.scrim.scrimUp(CTATGlobals.languageManager.filterString("AUTHORPLEASECLOSE"));
    } else {
      CTATScrim.scrim.handleTSDisconnect();
    }
  };
  this.cleanup = function cleanup() {
    pointer.ctatdebug("cleanup ()");
    var count = checkEntries();
    pointer.ctatdebug("Removed " + count + " entries");
  };
  function checkEntries() {
    pointer.ctatdebug("checkEntries() httprequests.length " + httprequests.length);
    var count = 0;
    for (var requests = httprequests.length - 1;requests >= 0;requests--) {
      var testConnection = httprequests[requests];
      if (!testConnection) {
        continue;
      } else {
        if (testConnection.getConsumed() === true) {
          pointer.ctatdebug("checkEntries() removing[" + requests + "] ID: " + testConnection.getID());
          httprequests.splice(requests, 1);
          count++;
        } else {
          if (typeof testConnection.getHTTPObject == "function") {
            var testObject = testConnection.getHTTPObject();
            pointer.ctatdebug("checkEntries() checking[" + requests + "], readyState: " + (testObject ? testObject.readyState : "null") + ", consumed: " + testConnection.getConsumed());
          }
        }
      }
    }
    return count;
  }
  this.retrieveProblemFile = function(fileName, parser, handler) {
    if (typeof CTATScrim == "function" && CTATScrim.scrim) {
      CTATScrim.scrim.waitScrimUp();
    }
    var exRegex = /\.([A-z]*)$/;
    var extensionMatch = exRegex.exec(fileName);
    if (extensionMatch && extensionMatch[1] && extensionMatch[1].toLowerCase() === "nools") {
      console.log("got a nools file:", fileName);
      handler.processNools(fileName);
    } else {
      console.log("got an xml file, maybe:", fileName);
      pointer.retrieveXMLFile(fileName, parser, handler);
    }
  };
  this.getFileRequest = function(fileName, successCbk, errCbk) {
    var toCheck = location.href ? location.href : fileName, isFileProto = toCheck.indexOf("file://") != -1 ? true : false;
    if (!location.href) {
      pointer.ctatdebug("We can't check location.href in the current configuration");
    }
    if (isFileProto) {
      var errXFile = (new CTATTutorMessageBuilder).createErrorMessage("", "Unable to load: " + fileName + " - You are trying to use the file:// protocol, which is not allowed in this browser.");
      pointer.ctatdebug("onerror GET for fileName " + errXFile);
      CTAT.ToolTutor.sendToInterface(errXFile, true);
      return;
    }
    fileTobeLoaded = fileName;
    var newConnection = new CTATConnection;
    newConnection.assignReceiveFunction(function(dataOrEvent, textStatus, xmlhttp) {
      if (typeof xmlhttp == "undefined") {
        xmlhttp = typeof this.getHTTPObject == "function" && this.getHTTPObject();
      }
      pointer.ctatdebug("onready... GET for xmlFile xmlhttp " + xmlhttp + ", .readyState & .status " + (xmlhttp ? xmlhttp.readyState + " & " + xmlhttp.status : ""));
      if (xmlhttp && xmlhttp.readyState != 4) {
        return;
      }
      if (xmlhttp && xmlhttp.status == 200) {
        successCbk(xmlhttp);
      }
      if (xmlhttp && xmlhttp.status == 404) {
        var err404 = (new CTATTutorMessageBuilder).createErrorMessage("Unable to download file", "(" + fileTobeLoaded + ") not found");
        pointer.ctatdebug("Error loading xmlFile " + fileTobeLoaded + ": " + err404);
        CTAT.ToolTutor.sendToInterface(err404, true);
        return;
      }
    });
    newConnection.assignFailFunction(errCbk);
    return newConnection;
  };
  this.retrieveXMLFile = function retrieveXMLFile(xmlFile, parser, handler) {
    pointer.ctatdebug("retrieveXMLFile (" + xmlFile + ")");
    var newConn = this.getFileRequest(xmlFile, function(req) {
      var xmlDoc = null;
      if (!req.responseXML) {
        pointer.ctatdebug("parsing brd xml using node");
        xmlDoc = (parser = new CTATXML).parseXML(req.responseText);
      } else {
        pointer.ctatdebug("parsing brd xml using something else");
        xmlDoc = req.responseXML.documentElement;
      }
      if (xmlDoc === null) {
        var errXNull = (new CTATTutorMessageBuilder).createErrorMessage("Error parsing xmlFile " + fileTobeLoaded);
        pointer.ctatdebug("Error parsing xmlFile " + fileTobeLoaded + ": " + errXNull);
        CTAT.ToolTutor.sendToInterface(errXNull, true);
        return;
      }
      handler.processXML(xmlDoc);
    }, function() {
      var errHTTP = (new CTATTutorMessageBuilder).createErrorMessage("", "Unable to load: " + fileTobeLoaded + " - Either you are trying to use the  file:// protocol, there is a firewall between the tutor and BRD, or the BRD is on a different domain and permission to retrieve data from that server is denied.");
      pointer.ctatdebug("onerror GET for xmlFile " + errHTTP);
      CTAT.ToolTutor.sendToInterface(errHTTP, true);
      handler.processXML(null);
    });
    newConn.setMethod("GET");
    newConn.setURL(xmlFile);
    newConn.setContentType("text/plain");
    newConn.send();
  };
  this.retrieveJSONFile = function retrieveJSONFile(jsonFile, handler) {
    pointer.ctatdebug("retrieveJSONFile (" + jsonFile + ")");
    var req = this.getFileRequest(jsonFile, function() {
      if (req.readyState != 4) {
        return;
      }
      if (req.status == 200) {
        pointer.ctatdebug("Successfully retrieved file: " + jsonFile);
        handler(JSON.parse(req.responseText));
        return;
      }
    }, function() {
      var errMsg = (new CTATTutorMessageBuilder).createErrorMessage("", "Unable to load: " + fileTobeLoaded + " - Either you are trying to use the  file:// protocol, there is a firewall between the tutor and BRD, or the BRD is on a different domain and permission to retrieve data from that server is denied.");
      pointer.ctatdebug("onerror GET for xmlFile " + errMsg);
      CTAT.ToolTutor.sendToInterface(errMsg, true);
      return;
    });
    req.open("GET", jsonFile, true);
    req.setRequestHeader("Content-type", "text/plain");
    req.send();
  };
  this.retrieveFile = function retrieveFile(txtFile, handler) {
    pointer.ctatdebug("retrieveFile (" + txtFile + ")");
    var txthttp = this.getFileRequest(txtFile, function() {
      if (txthttp.readyState != 4) {
        return;
      }
      if (txthttp.status == 200) {
        pointer.ctatdebug("Successfully retrieved file: " + txtFile);
        handler(txthttp.responseText);
        return;
      }
    }, function() {
      var errHTTP = (new CTATTutorMessageBuilder).createErrorMessage("", "Unable to load: " + fileTobeLoaded + " - Either you are trying to use the  file:// protocol, there is a firewall between the tutor and BRD, or the BRD is on a different domain and permission to retrieve data from that server is denied.");
      pointer.ctatdebug("onerror GET for xmlFile " + errHTTP);
      CTAT.ToolTutor.sendToInterface(errHTTP, true);
      return;
    });
    txthttp.open("GET", txtFile, true);
    txthttp.setRequestHeader("Content-type", "text/plain");
    txthttp.send();
  };
  this.then = function(done, fail) {
    return thenRequest && typeof thenRequest.then == "function" ? thenRequest.then(done, fail) : Promise.resolve("CTATCommLibrary.then() not supported").then(done, fail);
  };
};
CTATCommLibrary.setAuthenticityToken = function(token) {
  if (Array.isArray(token)) {
    token = token.length > 0 ? token[0] : "";
  }
  if (token) {
    CTATCommLibrary.authenticityToken = decodeURIComponent(token);
  }
};
CTATCommLibrary.getAuthenticityToken = function(data) {
  return CTATCommLibrary.authenticityToken;
};
CTATCommLibrary.addAuthenticityToken = function(data) {
  if (CTATCommLibrary.authenticityToken && (data === "" || data.search(/authenticity_token=/) < 0 && data.search(/^[?]?[^?&=><]+=?[^&=]*(&[^?&=><]+=?[^&=]*)*$/) >= 0)) {
    return "" + data + (data ? "&" : "") + "authenticity_token=" + encodeURIComponent(CTATCommLibrary.authenticityToken);
  }
  return data;
};
CTATCommLibrary.prototype = Object.create(CTATBase.prototype);
CTATCommLibrary.prototype.constructor = CTATCommLibrary;
CTATCommLibrary.prototype.editSocketURLForHTTPS = function(url) {
  if (url && !/[^0-9]127[.]0[.]0[.]1[^0-9]/.test(url) && window.top.location.protocol === "https:") {
    ctatdebug("We're embedded in an https window, using wss...");
    url = url.replace("ws:", "wss:");
    var securePort = CTATConfiguration.get("remoteSocketSecurePort");
    if (securePort) {
      var regex = /(wss:\/\/[^:]{1,}:)\d{1,}/;
      url = url.replace(regex, "$1" + securePort);
    }
    ctatdebug("url after replace: " + url);
  }
  return url;
};
goog.provide("CTATArgument");
CTATArgument = function() {
  var name = "";
  var value = "Undefined";
  var type = "String";
  var format = "text";
  this.setValue = function setValue(aValue) {
    value = aValue;
  };
  this.getValue = function getValue() {
    return value;
  };
  this.setName = function setName(aValue) {
    name = aValue;
  };
  this.getName = function getName() {
    return name;
  };
  this.setType = function setType(aType) {
    type = aType;
  };
  this.getType = function getType() {
    return type;
  };
  this.setFormat = function setFormat(aFormat) {
    format = aFormat;
  };
  this.getFormat = function getFormat() {
    return format;
  };
};
CTATArgument.prototype.clone = function() {
  var result = new CTATArgument;
  result.setValue(this.getValue());
  result.setType(this.getType());
  result.setFormat(this.getFormat());
  return result;
};
if (typeof module !== "undefined") {
  module.exports = CTATArgument;
}
;goog.provide("CTATHTMLManager");
goog.require("CTATGlobalFunctions");
CTATHTMLManager = function() {
  var aryEntities = null;
  var temper = "";
  var singleQuoteEscape = true;
  var maxEntities = 50;
  this.urldecode = function urldecode(str) {
    return decodeURIComponent((str + "").replace(/\+/g, "%20"));
  };
  this.showEntities = function showEntities() {
    ctatdebug("showEntities ()");
    var entity = null;
    for (var i = 0;i < aryEntities.length;i++) {
      entity = aryEntities[i];
      ctatdebug(entity);
    }
  };
  this.initEntities = function initEntities() {
    if (aryEntities == null) {
      aryEntities = [];
      aryEntities["&amp;"] = "*!*";
      aryEntities["&nbsp;"] = "\u00a0";
      aryEntities["&iexcl;"] = "\u00a1";
      aryEntities["&cent;"] = "\u00a2";
      aryEntities["&pound;"] = "\u00a3";
      aryEntities["&curren;"] = "\u00a4";
      aryEntities["&yen;"] = "\u00a5";
      aryEntities["&brvbar;"] = "\u00a6";
      aryEntities["&sect;"] = "\u00a7";
      aryEntities["&uml;"] = "\u00a8";
      aryEntities["&copy;"] = "\u00a9";
      aryEntities["&reg;"] = "\u00ae";
      aryEntities["&deg;"] = "\u00b0";
      aryEntities["&plusmn;"] = "\u00b1";
      aryEntities["&sup1;"] = "\u00b9";
      aryEntities["&sup2;"] = "\u00b2";
      aryEntities["&sup3;"] = "\u00b3";
      aryEntities["&acute;"] = "\u00b4";
      aryEntities["&micro;"] = "\u00b5";
      aryEntities["&frac14;"] = "\u00bc";
      aryEntities["&frac12;"] = "\u00bd";
      aryEntities["&frac34;"] = "\u00be";
      aryEntities["&iquest;"] = "\u00bf";
      aryEntities["&Agrave;"] = "\u00c0";
      aryEntities["&Aacute;"] = "\u00c1";
      aryEntities["&Acirc;"] = "\u00c2";
      aryEntities["&Atilde;"] = "\u00c3";
      aryEntities["&Auml;"] = "\u00c4";
      aryEntities["&Aring;"] = "\u00c5";
      aryEntities["&AElig;"] = "\u00c6";
      aryEntities["&Ccedil;"] = "\u00c7";
      aryEntities["&Egrave;"] = "\u00c8";
      aryEntities["&Eacute;"] = "\u00c9";
      aryEntities["&Ecirc;"] = "\u00ca";
      aryEntities["&Euml;"] = "\u00cb";
      aryEntities["&Igrave;"] = "\u00cc";
      aryEntities["&Iacute;"] = "\u00cd";
      aryEntities["&Icirc;"] = "\u00ce";
      aryEntities["&Iuml;"] = "\u00cf";
      aryEntities["&ETH;"] = "\u00d0";
      aryEntities["&Ntilde;"] = "\u00d1";
      aryEntities["&Ograve;"] = "\u00d2";
      aryEntities["&Oacute;"] = "\u00d3";
      aryEntities["&Ocirc;"] = "\u00d4";
      aryEntities["&Otilde;"] = "\u00d5";
      aryEntities["&Ouml;"] = "\u00d6";
      aryEntities["&Oslash;"] = "\u00d8";
      aryEntities["&Ugrave;"] = "\u00d9";
      aryEntities["&Uacute;"] = "\u00da";
      aryEntities["&Ucirc;"] = "\u00db";
      aryEntities["&Uuml;"] = "\u00dc";
      aryEntities["&Yacute;"] = "\u00dd";
      aryEntities["&THORN;"] = "\u00de";
      aryEntities["&szlig;"] = "\u00df";
      aryEntities["&agrave;"] = "\u00e0";
      aryEntities["&aacute;"] = "\u00e1";
      aryEntities["&acirc;"] = "\u00e2";
      aryEntities["&atilde;"] = "\u00e3";
      aryEntities["&auml;"] = "\u00e4";
      aryEntities["&aring;"] = "\u00e5";
      aryEntities["&aelig;"] = "\u00e6";
      aryEntities["&ccedil;"] = "\u00e7";
      aryEntities["&egrave;"] = "\u00e8";
      aryEntities["&eacute;"] = "\u00e9";
      aryEntities["&ecirc;"] = "\u00ea";
      aryEntities["&euml;"] = "\u00eb";
      aryEntities["&igrave;"] = "\u00ec";
      aryEntities["&iacute;"] = "\u00ed";
      aryEntities["&icirc;"] = "\u00ee";
      aryEntities["&iuml;"] = "\u00ef";
      aryEntities["&eth;"] = "\u00f0";
      aryEntities["&ntilde;"] = "\u00f1";
      aryEntities["&ograve;"] = "\u00f2";
      aryEntities["&oacute;"] = "\u00f3";
      aryEntities["&ocirc;"] = "\u00f4";
      aryEntities["&otilde;"] = "\u00f5";
      aryEntities["&ouml;"] = "\u00f6";
      aryEntities["&oslash;"] = "\u00f8";
      aryEntities["&ugrave;"] = "\u00f9";
      aryEntities["&uacute;"] = "\u00fa";
      aryEntities["&ucirc;"] = "\u00fb";
      aryEntities["&uuml;"] = "\u00fc";
      aryEntities["&yacute;"] = "\u00fd";
      aryEntities["&thorn;"] = "\u00fe";
      aryEntities["&yuml;"] = "\u00ff";
      aryEntities["&gt;"] = ">";
      aryEntities["&lt;"] = "<";
      aryEntities["&#61;"] = "=";
      aryEntities["&361;"] = "=";
      aryEntities["&quot;"] = '"';
    }
    if (singleQuoteEscape == true) {
      ctatdebug("(singleQuoteEscape==true) Replacing &apos; with: \\'");
      aryEntities["&apos;"] = "\\'";
    } else {
      ctatdebug("(singleQuoteEscape==false) Replacing &apos; with: '");
      aryEntities["&apos;"] = "'";
    }
  };
  this.entitiesConvert = function entitiesConvert(str) {
    ctatdebug("entitiesConvert ()");
    return this.urldecode(unescape(str));
  };
  this.entitiesGenerate = function entitiesGenerate(str) {
    temper = str;
    return temper;
  };
  this.htmlEncode = function htmlEncode(value) {
    return value;
  };
  this.htmlDecode = function htmlDecode(value) {
    if (typeof $ !== "undefined") {
      return $("<div/>").html(value).text();
    } else {
      if (typeof Entities !== "undefined") {
        return (new Entities).decode(value);
      }
    }
    return value;
  };
};
if (typeof module !== "undefined") {
  module.exports = CTATHTMLManager;
}
;goog.provide("CTATStringUtil");
CTATStringUtil = function() {
  this.String2Boolean = function String2Boolean(aString) {
    switch(aString) {
      case "1":
      ;
      case "true":
      ;
      case "yes":
      ;
      case "TRUE":
      ;
      case "YES":
      ;
      case "Yes":
        return true;
      case "0":
      ;
      case "false":
      ;
      case "no":
      ;
      case "FALSE":
      ;
      case "NO":
      ;
      case "No":
        return false;
    }
    return true;
  };
  this.replaceString = function replaceString(thisStr, searchStr, replaceStr) {
    return thisStr.replace(searchStr, replaceStr);
  };
};
if (typeof module !== "undefined") {
  module.exports = CTATStringUtil;
}
;goog.provide("CTATSAI");
goog.require("CTATArgument");
goog.require("CTATBase");
goog.require("CTATHTMLManager");
goog.require("CTATStringUtil");
goog.require("CTATXML");
CTATSAI = function(aSelection, anAction, anInput, aPrompt) {
  CTATBase.call(this, "CTATSAI", "sai");
  var tools = new CTATStringUtil;
  var prompt = "undefined";
  var selectionArray = [];
  var actionArray = [];
  var inputArray = [];
  var inputFlattened = "";
  var tempArray = [];
  var messageParser = null;
  var pointer = this;
  if (CTATConfig.parserType == "xml") {
    messageParser = new CTATXML;
  } else {
    messageParser = new CTATJSON;
  }
  this.getArguments = function getArguments() {
    return inputArray;
  };
  this.getArgument = function getArgument(anIndex) {
    if (inputArray.length == 0) {
      var newArgument = new CTATArgument;
      inputArray.push(newArgument);
    }
    return inputArray[anIndex];
  };
  this.getArgumentsTyped = function getArgumentsTyped() {
    pointer.ctatdebug("getArgumentsTyped");
    var i = 0;
    var sai_arguments = [];
    for (i = 0;i < inputArray.length;i++) {
      var arg = inputArray[i];
      if (arg.getType() === "Boolean") {
        pointer.ctatdebug("Adding Boolean argument (" + arg.getValue() + ") ...");
        sai_arguments.push(tools.String2Boolean(arg.getValue()));
      } else {
        if (arg.getType() === "Number") {
          pointer.ctatdebug("Adding Number argument (" + arg.getValue() + ") ...");
          sai_arguments.push(Number(arg.getValue()));
        } else {
          if (arg.getType() === "String") {
            if (arg.getValue() === "No_Value") {
              pointer.ctatdebug("Detected default argument (" + arg.getValue() + "), setting contents to null instead");
              sai_arguments.push(null);
            } else {
              sai_arguments.push(String(arg.getValue()));
            }
          } else {
            pointer.ctatdebug("Unrecognized argument type: " + arg.getType() + " in " + pointer.toSerializedString() + " IGNORING IT!!!");
          }
        }
      }
    }
    pointer.ctatdebug("Resulting arguments: " + sai_arguments);
    return sai_arguments;
  };
  this.addSelection = function addSelection(aSelection, aType) {
    var newSelection = new CTATArgument;
    newSelection.setValue(aSelection);
    if (aType != undefined && aType != null) {
      newSelection.setType(aType);
    }
    selectionArray.push(newSelection);
  };
  this.addAction = function addAction(a) {
    actionArray.push(a);
  };
  this.checkDefaultArgument = function checkDefaultArgument() {
    pointer.ctatdebug("checkDefaultArgument ()");
    if (inputArray.length === 0) {
      pointer.ctatdebug("Adding default argument ...");
      var defaultArgument = new CTATArgument;
      inputArray.push(defaultArgument);
    }
  };
  this.setArgument = function setArgument(anIndex, aValue) {
    pointer.checkDefaultArgument();
    for (var i = inputArray.length;i <= anIndex;++i) {
      inputArray.push(new CTATArgument);
    }
    var tempArgument = inputArray[anIndex];
    tempArgument.setValue(aValue);
    return tempArgument;
  };
  this.addArgument = function addArgument(aValue, aType, aFormat) {
    this.ctatdebug("addArgument (" + aValue + "," + aType + "," + aFormat + ")");
    var tempArgument = new CTATArgument;
    tempArgument.setValue(aValue);
    tempArgument.setType(aType);
    tempArgument.setFormat(aFormat);
    inputArray.push(tempArgument);
    return tempArgument;
  };
  this.addExistingArgument = function addExistingArgument(anArgument) {
    inputArray.push(anArgument);
    return anArgument;
  };
  this.setSAI = function setSAI(newSelection, newAction, newInput, aType, aPrompt) {
    pointer.setSelection(Array.isArray(newSelection) ? newSelection.length > 0 ? newSelection[0] : "" : newSelection);
    pointer.setAction(Array.isArray(newAction) ? newAction.length > 0 ? newAction[0] : "" : newAction);
    pointer.setInput(Array.isArray(newInput) ? newInput.length > 0 ? newInput[0] : "" : newInput);
    pointer.setType(aType);
    prompt = aPrompt;
  };
  this.setInput = function setInput(newInput) {
    pointer.ctatdebug("setInput(" + newInput + ")");
    pointer.checkDefaultArgument();
    var arg = pointer.getArgument(0);
    arg.setValue(newInput);
  };
  this.getInputObject = function getInputObject() {
    if (inputArray.length === 0) {
      return null;
    }
    return inputArray[0];
  };
  this.getInput = function getInput() {
    if (inputArray.length === 0) {
      return "";
    }
    var arg = pointer.getArgument(0);
    return arg.getValue();
  };
  this.setType = function setType(aType) {
    pointer.checkDefaultArgument();
    var arg = pointer.getArgument(0);
    arg.type = aType;
  };
  this.getType = function getType() {
    if (inputArray.length === 0) {
      return "";
    }
    var arg = pointer.getArgument(0);
    return arg.type;
  };
  this.setFormat = function setFormat(aFormat) {
    pointer.checkDefaultArgument();
    var arg = pointer.getArgument(0);
    arg.setFormat(aFormat);
  };
  this.getFormat = function getFormat() {
    if (inputArray.length === 0) {
      return "";
    }
    var arg = pointer.getArgument(0);
    return arg.getFormat();
  };
  this.toString = function() {
    return "[" + String(pointer.getSelection()) + "," + String(pointer.getAction()) + "," + String(pointer.getInput()) + "]";
  };
  this.setSelection = function setSelection(newSelection, aType) {
    var tempSelection = pointer.getSelectionObject();
    if (tempSelection == null) {
      tempSelection = new CTATArgument;
      tempSelection.setValue(newSelection);
      if (aType != undefined && aType != null) {
        tempSelection.setType(aType);
      }
      selectionArray.push(tempSelection);
    } else {
      tempSelection.setValue(newSelection);
    }
  };
  this.getSelectionObject = function getSelectionObject() {
    if (selectionArray.length == 0) {
      return null;
    }
    return selectionArray[0];
  };
  this.getSelection = function getSelection() {
    if (selectionArray.length == 0) {
      return null;
    }
    var tempSelection = selectionArray[0];
    if (typeof tempSelection === "object") {
      return tempSelection.getValue();
    }
    return tempSelection;
  };
  this.setAction = function setAction(newInput) {
    if (actionArray.length > 0) {
      actionArray[0] = newInput;
    } else {
      actionArray.push(newInput);
    }
  };
  this.getAction = function getAction() {
    if (actionArray.length == 0) {
      return null;
    }
    return actionArray[0];
  };
  this.appendToSelectionArray = function appendToSelectionArray(newVal, aType) {
    var tempSelection = new CTATArgument;
    tempSelection.setValue(String(newVal));
    if (aType != undefined && aType != null) {
      tempSelection.setType(aType);
    }
    selectionArray.push(tempSelection);
  };
  this.setSelectionArray = function setSelectionArray(newArr) {
    selectionArray = [];
    for (var i = 0;i < newArr.length;i++) {
      var newSelection = newArr[i];
      pointer.appendToSelectionArray(newSelection, "String");
    }
  };
  this.getSelectionArray = function getSelectionArray() {
    var tempArray = [];
    for (var i = 0;i < selectionArray.length;i++) {
      var tempSelection = selectionArray[i];
      if (typeof tempSelection === "object") {
        tempArray.push(selectionArray[i].getValue());
      } else {
        tempArray.push(tempSelection);
      }
    }
    return tempArray;
  };
  this.appendToActionArray = function appendToActionArray(newVal) {
    if (newVal == null) {
      actionArray.push("");
    } else {
      actionArray.push(String(newVal));
    }
  };
  this.setActionArray = function setActionArray(newArr) {
    if (newArr == null) {
      actionArray = [];
    } else {
      if (Array.isArray(newArr)) {
        actionArray = newArr.slice();
      } else {
        actionArray = [String(newArr)];
      }
    }
  };
  this.getActionArray = function getActionArray() {
    return actionArray;
  };
  this.appendToInputArray = function appendToInputArray(newVal) {
    pointer.ctatdebug("appendToInputArray (" + newVal + ")");
    if (newVal == null) {
      pointer.addArgument("", "String", "text");
    } else {
      pointer.addArgument(newVal, "String", "text");
    }
  };
  this.setInputArray = function setInputArray(newArr) {
    inputArray = [];
    if (newArr == null) {
      return;
    }
    for (var i = 0;i < newArr.length;i++) {
      pointer.appendToInputArray(newArr[i]);
    }
  };
  this.getInputArray = function getInputArray() {
    pointer.ctatdebug("getInputArray (" + inputArray.length + ")");
    tempArray = [];
    for (var i = 0;i < inputArray.length;i++) {
      var arg = inputArray[i];
      if (typeof arg === "object") {
        pointer.ctatdebug("Adding object value (" + arg.getValue() + ") to temp input array");
        tempArray.push(arg.getValue());
      } else {
        pointer.ctatdebug("Adding string value (" + arg + ") to temp input array");
        tempArray.push(arg);
      }
    }
    return tempArray;
  };
  this.setPrompt = function setPrompt(newInput) {
    prompt = newInput;
  };
  this.getPrompt = function getPrompt() {
    return prompt;
  };
  this.propagate = function propagate(source) {
    pointer.ctatdebug("propagate ()");
    var sourceArguments = source.getArguments();
    for (var i = 0;i < sourceArguments.length;i++) {
      var fromArg = sourceArguments[i];
      var toArg = inputArray[i];
      if (fromArg === null || toArg === null) {
        pointer.ctatdebug("Internal error: argument lists do not align between received SAI and source SAI");
        return;
      }
      toArg.setValue(fromArg.getValue());
    }
  };
  this.fromString = function fromString(aStream) {
    var messageRoot = messageParser.parse(aStream);
    pointer.fromXML(messageRoot);
  };
  this.fromXML = function fromXML(aNode) {
    pointer.ctatdebug("fromXML ()");
    inputArray = [];
    var entries = messageParser.getElementChildren(aNode);
    inputFlattened = "";
    var textValue = null;
    for (var t = 0;t < entries.length;t++) {
      var entry = entries[t];
      if (messageParser.getElementName(entry) == "selection" || messageParser.getElementName(entry) == "Selection") {
        var vals = messageParser.getElementChildren(entry);
        var nameMatched = false;
        for (var i = 0;i < vals.length;i++) {
          var val = vals[i];
          if (messageParser.getElementName(val) == "value") {
            textValue = messageParser.getNodeTextValue(val);
            if (i < 1) {
              pointer.setSelectionArray(textValue);
            } else {
              pointer.appendToSelectionArray(textValue);
            }
            nameMatched = true;
            pointer.setSelection(textValue);
          }
        }
        if (nameMatched === false) {
          textValue = messageParser.getNodeTextValue(entry);
          pointer.setSelectionArray(textValue);
          pointer.setSelection(textValue);
        }
      }
      if (messageParser.getElementName(entry) == "action" || messageParser.getElementName(entry) == "Action") {
        var acts = messageParser.getElementChildren(entry);
        var actionMatched = false;
        for (var j = 0;j < acts.length;j++) {
          var act = acts[j];
          if (messageParser.getElementName(act) == "value") {
            textValue = messageParser.getNodeTextValue(act);
            if (j < 1) {
              pointer.setActionArray(textValue);
            } else {
              pointer.appendToActionArray(textValue);
            }
            actionMatched = true;
            pointer.setAction(textValue);
          }
        }
        if (actionMatched === false) {
          textValue = messageParser.getNodeTextValue(entry);
          pointer.setActionArray(textValue);
          pointer.setAction(textValue);
        }
      }
      if (messageParser.getElementName(entry) == "inputArray" || messageParser.getElementName(entry) == "value" || messageParser.getElementName(entry) == "Input") {
        var args = messageParser.getElementChildren(entry);
        var newValue = null;
        inputArray = [];
        var formatter = new CTATHTMLManager;
        var newArgument = new CTATArgument;
        var ind = 0;
        inputArray.push(newArgument);
        for (var k = 0;k < args.length;k++) {
          var argument = args[k];
          if (messageParser.getElementName(argument) == "value") {
            var argNodes = messageParser.getElementChildren(argument);
            if (argNodes !== null) {
              pointer.ctatdebug("Parsing SAI input ...");
              pointer.ctatdebug("Childnodes: " + argNodes.length);
              if (argNodes.length === 1) {
                newValue = formatter.htmlDecode(messageParser.getNodeTextValue(argument));
                pointer.ctatdebug("Setting new value to: " + newValue);
                newArgument.setValue(newValue);
              } else {
                if (ind > 0) {
                  inputFlattened += ",";
                }
                newValue = formatter.htmlDecode(messageParser.getNodeTextValue(argument));
                pointer.ctatdebug("Setting new value to: " + newValue);
                newArgument.setValue(newValue);
                newArgument.setName(argument.attributes.getNamedItem("name").value);
                newArgument.setType(argument.attributes.getNamedItem("type").value);
                newArgument.setFormat(argument.attributes.getNamedItem("format").value);
                inputFlattened += newValue;
                ind++;
              }
              if (k < 1) {
                pointer.setInputArray(newValue);
              } else {
                pointer.appendToInputArray(newValue);
              }
            } else {
              var newVal = formatter.htmlDecode(messageParser.getNodeTextValue(argument));
              pointer.ctatdebug("Setting new value to: " + newVal);
              newArgument.setValue(newVal);
              if (k < 1) {
                pointer.setInputArray(newVal);
              } else {
                pointer.appendToInputArray(newVal);
              }
            }
          }
        }
      }
      if (messageParser.getElementName(entry) == "prompt" || messageParser.getElementName(entry) == "Prompt") {
        pointer.ctatdebug("Parsing prompt ...");
        pointer.setPrompt(messageParser.getNodeTextValue(entry));
      }
    }
    pointer.checkDefaultArgument();
  };
  this.appendFromElement = function appendFromElement(expectedName, elt, arrayToAppend, index, isInput) {
    pointer.ctatdebug("appendFromElement ()");
    var name = String(messageParser.getElementName(elt)).toLowerCase();
    if (name != expectedName && name != "value") {
      return;
    }
    var chElts = messageParser.getElementChildren(elt);
    if (!Array.isArray(chElts) || chElts.length < 1) {
      if (isInput == false) {
        arrayToAppend.push(messageParser.getNodeTextValue(elt));
      } else {
        pointer.appendToInputArray(messageParser.getNodeTextValue(elt));
      }
      return;
    }
    for (var i = 0;i < chElts.length;++i) {
      appendFromElement(expectedName, chElts[i], arrayToAppend, i, isInput);
    }
  };
  this.setArrayFromElements = function(elts) {
    pointer.ctatdebug("setArrayFromElements ()");
    if (!elts || !Array.isArray(elts) || elts.length < 1) {
      pointer.ctatdebug("can't get name: don't know whether selection, action or input");
      return;
    }
    var i = 0;
    var eltName = String(messageParser.getElementName(elts[0])).toLowerCase();
    switch(eltName) {
      case "selection":
        pointer.ctatdebug("Processing selection field ...");
        selectionArray = [];
        for (i = 0;i < elts.length;++i) {
          pointer.appendFromElement(eltName, elts[i], selectionArray, i, false);
        }
        break;
      case "action":
        pointer.ctatdebug("Processing action field ...");
        actionArray = [];
        for (i = 0;i < elts.length;++i) {
          pointer.appendFromElement(eltName, elts[i], actionArray, i, false);
        }
        break;
      case "input":
        pointer.ctatdebug("Processing input field ...");
        inputArray = [];
        for (i = 0;i < elts.length;++i) {
          pointer.appendFromElement(eltName, elts[i], inputArray, i, true);
        }
        break;
      default:
        console.log('CTATSAI.setArrayFromElements(): unexpected element name "' + eltName + '"');
        return;
    }
    pointer.ctatdebug("CTATSAI.setArrayFromElements() eltName " + eltName + ", length " + i + ", selectionArray " + pointer.getSelectionArray() + ", actionArray " + pointer.getActionArray() + ", inputArray " + pointer.getInputArray());
  };
  this.fromXMLInternal = function fromXMLInternal(aNode) {
    pointer.ctatdebug("fromXMLInternal ()");
    var parser = new CTATXML;
    inputArray = [];
    var entries = messageParser.getElementChildren(aNode);
    inputFlattened = "";
    var textValue = null;
    for (var t = 0;t < entries.length;t++) {
      var entry = entries[t];
      if (messageParser.getElementName(entry) == "selection" || messageParser.getElementName(entry) == "Selection") {
        var vals = messageParser.getElementChildren(entry);
        var nameMatched = false;
        for (var i = 0;i < vals.length;i++) {
          var val = vals[i];
          if (messageParser.getElementName(val) == "value") {
            textValue = messageParser.getNodeTextValue(val);
            if (i < 1) {
              pointer.setSelectionArray(textValue);
            } else {
              pointer.appendToSelectionArray(textValue);
            }
            nameMatched = true;
            pointer.setSelection(textValue);
          }
        }
        if (nameMatched === false) {
          textValue = messageParser.getNodeTextValue(entry);
          pointer.setSelectionArray(textValue);
          pointer.setSelection(textValue);
        }
      }
      if (messageParser.getElementName(entry) == "action" || messageParser.getElementName(entry) == "Action") {
        var acts = entry.childNodes;
        var actionMatched = false;
        for (var j = 0;j < acts.length;j++) {
          var act = acts[j];
          if (messageParser.getElementName(act) == "value") {
            textValue = messageParser.getNodeTextValue(act);
            if (j < 1) {
              pointer.setActionArray(textValue);
            } else {
              pointer.appendToActionArray(textValue);
            }
            actionMatched = true;
            pointer.setAction(textValue);
          }
        }
        if (actionMatched === false) {
          textValue = messageParser.getNodeTextValue(entry);
          pointer.setActionArray(textValue);
          pointer.setAction(textValue);
        }
      }
      if (messageParser.getElementName(entry) == "inputArray" || messageParser.getElementName(entry) == "Input") {
        var args = entry.childNodes;
        inputArray = [];
        var formatter = new CTATHTMLManager;
        var newArgument = new CTATArgument;
        var ind = 0;
        var newValue = null;
        inputArray.push(newArgument);
        for (var k = 0;k < args.length;k++) {
          var argument = args[k];
          if (messageParser.getElementName(argument) == "value") {
            var margs = messageParser.getElementChildren(argument);
            if (margs !== null) {
              pointer.ctatdebug("Parsing SAI input ...");
              pointer.ctatdebug("Childnodes: " + margs.length);
              if (margs.length === 1) {
                newValue = formatter.htmlDecode(messageParser.getNodeTextValue(argument));
                pointer.ctatdebug("Setting new value to: " + newValue);
                newArgument.setValue(newValue);
              } else {
                if (ind > 0) {
                  inputFlattened += ",";
                }
                newValue = formatter.htmlDecode(messageParser.getNodeTextValue(argument));
                pointer.ctatdebug("Setting new value to: " + newValue);
                newArgument.setValue(newValue);
                newArgument.setName(messageParser.getElementAttr("name"));
                newArgument.setType(messageParser.getElementAttr("type"));
                newArgument.setFormat(messageParser.getElementAttr("format"));
                inputFlattened += newValue;
                ind++;
              }
              if (k < 1) {
                pointer.setInputArray(newValue);
              } else {
                pointer.appendToInputArray(newValue);
              }
            } else {
              var newVal = formatter.htmlDecode(messageParser.getNodeTextValue(argument));
              pointer.ctatdebug("Setting new value to: " + newVal);
              newArgument.setValue(newVal);
              if (k < 1) {
                pointer.setInputArray(newVal);
              } else {
                pointer.appendToInputArray(newVal);
              }
            }
          }
        }
      }
      if (messageParser.getElementName(entry) == "prompt" || messageParser.getElementName(entry) == "Prompt") {
        pointer.ctatdebug("Parsing prompt ...");
        pointer.setPrompt(messageParser.getNodeTextValue(entry));
      }
    }
    pointer.checkDefaultArgument();
  };
  this.toXMLString = function toXMLString(logMessageFormat) {
    pointer.ctatdebug("toXMLString ()");
    if (logMessageFormat) {
      return pointer.toLSxmlString();
    } else {
      return pointer.toTSxmlString();
    }
  };
  this.toLSxmlString = function toLSxmlString() {
    pointer.ctatdebug("toLSxmlString ()");
    var formatter = "";
    for (var i = 0;i < selectionArray.length;i++) {
      var tempSelection = selectionArray[i];
      if (typeof tempSelection === "object") {
        if (tempSelection.getType() != "String") {
          formatter += '<selection type="' + tempSelection.getType() + '">';
        } else {
          formatter += "<selection>";
        }
        formatter += tempSelection.getValue() + "</selection>";
      } else {
        formatter += "<selection>" + tempSelection + "</selection>";
      }
    }
    formatter += "<action>" + pointer.getAction();
    for (var j = 1;j < actionArray.length;j++) {
      formatter += "</action><action>" + actionArray[j];
    }
    formatter += "</action>";
    for (var k = 0;k < inputArray.length;k++) {
      var arg = inputArray[k];
      if (typeof arg === "object") {
        if (arg.getType() != "String") {
          formatter += '<input type="' + arg.getType() + '"><![CDATA[' + arg.getValue() + "]]\x3e</input>";
        } else {
          formatter += "<input><![CDATA[" + arg.getValue() + "]]\x3e</input>";
        }
      } else {
        formatter += "<input><![CDATA[" + arg + "]]\x3e</input>";
      }
    }
    return formatter;
  };
  this.toTSxmlString = function toTSxmlString() {
    pointer.ctatdebug("toTSxmlString ()");
    var formatter = "";
    formatter += "<Selection><value>" + pointer.getSelection();
    for (var i = 1;i < selectionArray.length;i++) {
      var tempSelection = selectionArray[i];
      if (typeof tempSelection === "object") {
        formatter += "</value><value>" + tempSelection.getValue();
      } else {
        formatter += "</value><value>" + tempSelection;
      }
    }
    formatter += "</value></Selection><Action><value>" + pointer.getAction();
    for (var j = 1;j < actionArray.length;j++) {
      formatter += "</value><value>" + actionArray[j];
    }
    formatter += "</value></Action><Input>";
    if (inputArray.length > 1) {
      for (var k = 0;k < inputArray.length;k++) {
        var arg = inputArray[k];
        formatter += '<value fmt="text" name="' + arg.getName() + '" type="' + arg.getType() + '"><![CDATA[' + arg.getValue() + "]]\x3e</value>";
      }
    } else {
      formatter += "<value><![CDATA[" + pointer.getInput() + "]]\x3e</value>";
    }
    formatter += "</Input>";
    return formatter;
  };
  this.toSerializedString = function toSerializedString() {
    var formatter = "";
    formatter += "<selection>" + pointer.getSelection() + "</selection><action>" + pointer.getAction() + "</action><inputArray>";
    for (var i = 0;i < inputArray.length;i++) {
      var arg = inputArray[i];
      formatter += '<value fmt="text" name="' + arg.getName() + '" type="' + arg.getType() + '">' + arg.getValue() + "</value>";
    }
    formatter += "</inputArray>";
    return formatter;
  };
  this.clone = function() {
    pointer.ctatdebug("clone ()");
    var result = new CTATSAI(pointer.getSelection(), pointer.getAction(), pointer.getInput(), pointer.getPrompt());
    for (var i = 0;i < pointer.getArguments().length;++i) {
      result.setArgument(i, pointer.getArgument(i).clone());
    }
    result.setSelectionArray(pointer.getSelectionArray().slice());
    result.setActionArray(pointer.getActionArray().slice());
    result.setInputArray(pointer.getInputArray().slice());
    pointer.ctatdebug("CTATSAI.clone() this " + pointer + ", clone " + result + ", clone inputArray " + result.getInputArray());
    return result;
  };
  this.isDone = function() {
    var s = pointer.getSelection();
    var a = pointer.getAction();
    if (s == null || a == null) {
      return false;
    }
    return "done" == s.toString().toLowerCase() && "buttonpressed" == a.toString().toLowerCase();
  };
  var arraysInitialized = false;
  if (Array.isArray(aSelection) && Array.isArray(anAction) && (Array.isArray(anInput) || anInput == null)) {
    pointer.setSelectionArray(aSelection);
    pointer.setActionArray(anAction);
    pointer.setInputArray(anInput);
    arraysInitialized = true;
    if (aSelection.length > 0 && anAction.length > 0) {
      pointer.setSAI(aSelection[0], anAction[0], anInput == null ? null : anInput[0], "String", aPrompt);
      return;
    }
  }
  if (aSelection !== null && aSelection !== "") {
    pointer.setSelection(aSelection);
  }
  if (aSelection !== null) {
    pointer.setSAI(aSelection, anAction, anInput, "String", aPrompt);
    if (!arraysInitialized) {
      pointer.setSelectionArray(Array.isArray(aSelection) ? aSelection : [aSelection]);
      pointer.setActionArray(Array.isArray(anAction) ? anAction : [anAction]);
      pointer.setInputArray(Array.isArray(anInput) ? anInput : [anInput]);
      arraysInitialized = true;
    }
  }
};
CTATSAI.prototype = Object.create(CTATBase.prototype);
CTATSAI.prototype.constructor = CTATSAI;
CTATSAI.delayedActionRegExp = new RegExp("^([^:]+):([0-9]+)$");
if (typeof module !== "undefined") {
  module.exports = CTATSAI;
}
;goog.provide("CTATSkill");
goog.require("CTATBase");
goog.require("CTATGlobals");
CTATSkill = function() {
  CTATBase.call(this, "CTATSkill", "skill");
  var skillName = "";
  var displayName = "";
  var category = "";
  var modelName = "";
  var level = 0;
  var description = "";
  var touched = false;
  var pGuess = "";
  var pSlip = "";
  var pKnown = "";
  var pLearn = "";
  var history = "";
  var label = null;
  this.setSkillName = function setSkillName(n) {
    skillName = n;
  };
  this.setDisplayName = function setDisplayName(n) {
    displayName = n;
  };
  this.setModelName = function setModelName(model) {
    modelName = model;
  };
  this.setCategory = function setCategory(cat) {
    category = cat;
  };
  this.setLevel = function setLevel(lvl) {
    if (isNaN(lvl) === true) {
      ctatdebug("Error: attempting to set a level to NaN");
      return;
    }
    level = lvl;
    this.setPKnown(String(level));
  };
  this.setDescription = function setDescription(desc) {
    description = desc;
  };
  this.getSkillName = function getSkillName() {
    return skillName;
  };
  this.getDisplayName = function getDisplayName() {
    return displayName;
  };
  this.hasDisplayName = function hasDisplayName() {
    return displayName !== "" && displayName !== null;
  };
  this.getModelName = function getModelName() {
    return modelName;
  };
  this.hasCategory = function hasCategory() {
    return category !== "";
  };
  this.hasModelName = function hasModelName() {
    return modelName !== "";
  };
  this.getCategory = function getCategory() {
    return category;
  };
  this.getLevel = function getLevel() {
    return level;
  };
  this.getDescription = function getDescription() {
    return description;
  };
  this.setTouched = function setTouched(touch) {
    touched = touch;
  };
  this.getTouched = function getTouched() {
    return touched;
  };
  this.toXMLString = function toXMLString() {
    return "";
  };
  this.toSetPreferencesXMLString = function toSetPreferencesXMLString() {
    var string = '<skill label="' + displayName + '" pSlip="' + pSlip + '" description="' + description;
    string += '" pKnown="' + pKnown + '" category="' + category + '" pLearn="' + pLearn + '" name="' + skillName + '" pGuess="' + pGuess + '" history="' + history + '" />';
    return string;
  };
  this.setPGuess = function setPGuess(guess) {
    pGuess = guess;
  };
  this.getPGuess = function getPGuess() {
    return pGuess;
  };
  this.setPSlip = function setPSlip(slip) {
    pSlip = slip;
  };
  this.getPSlip = function getPSlip() {
    return pSlip;
  };
  this.setPLearn = function setPLearn(learn) {
    pLearn = learn;
  };
  this.getPLearn = function getPLearn() {
    return pLearn;
  };
  this.setPKnown = function setPKnown(known) {
    pKnown = known;
  };
  this.getPKnown = function getPKnown() {
    return pKnown;
  };
  this.setSkillHistory = function setSkillHistory(aHistory) {
    history = aHistory;
  };
  this.getSkillHistory = function getSkillHistory() {
    return history;
  };
};
CTATSkill.prototype = Object.create(CTATBase.prototype);
CTATSkill.prototype.constructor = CTATSkill;
goog.provide("CTATSkillSet");
goog.require("CTATBase");
goog.require("CTATGlobals");
goog.require("CTATSkill");
goog.require("CTATXML");
CTATSkillSet = function() {
  CTATBase.call(this, "CTATSkillSet", "skills");
  this.internalSkillSet = [];
  var pointer = this;
  this.fromXMLString = function fromXMLString(aSkills, alreadyDecoded) {
    this.ctatdebug("fromXMLString ()");
    this.ctatdebug("Skills string: " + aSkills);
    if (aSkills === null) {
      this.ctatdebug("Warning: skill object is null");
      return;
    }
    if (aSkills === "") {
      this.ctatdebug("Info: empty skill string provided, bump");
      return;
    }
    if (!aSkills) {
      this.ctatdebug("Warning: skill object is undefined or otherwise empty.");
      return;
    }
    this.ctatdebug("CTATSkillSet.fromXMLString() Raw:     " + aSkills);
    var decoded = alreadyDecoded ? aSkills : decodeURIComponent(aSkills.replace(/\+/g, " "));
    this.ctatdebug("CTATSkillSet.fromXMLString() Decoded: " + decoded);
    var valuePattern = new RegExp("/<value>.+</value>");
    if (valuePattern.exec(decoded) !== null) {
      this.parseByValue(decoded);
    } else {
      var parser = new CTATXML;
      var root = parser.parseXML(decoded);
      this.parseByAttributes(root, decoded);
    }
    this.ctatdebug("fromXMLString () done");
  };
  this.fromXMLData = function fromXMLData(xml, raw) {
    this.ctatdebug("fromXMLData ()");
    var valuePattern = new RegExp("/<value>.+</value>");
    if (valuePattern.exec(raw) !== null) {
      this.parseByValue(raw);
    } else {
      this.parseByAttributes(xml);
    }
    this.ctatdebug("fromXMLData () done");
  };
  this.parseByValue = function parseByValue(aSkills) {
    this.ctatdebug("parseByValue()");
    if (!aSkills) {
      pointer.ctatdebug("Error: aSkills is null");
      return;
    }
    var slist = aSkills.childNodes;
    var parser = new CTATXML;
    for (var k = 0;k < slist.length;k++) {
      var testSkill = slist[k];
      var skillString = parser.getNodeTextValue(testSkill);
      var aSkill = skillString.split("`");
      var pair = aSkill[0].split(" ");
      if (aSkill.length == 4) {
        this.addSkill(pair[0], aSkill[1], aSkill[2], aSkill[3], aSkill[3], pair[1]);
      } else {
        this.addSkill(pair[0], aSkill[1], aSkill[2], aSkill[3], aSkill[4], pair[1]);
      }
    }
  };
  this.parseDOM = function parseDOM(anElement) {
    this.ctatdebug("parseDOM()");
    var parser = new CTATXML;
    var aList = parser.getElementChildren(anElement);
    for (var k = 0;k < aList.length;k++) {
      var testSkill = aList[k];
      var skillString = parser.getNodeTextValue(testSkill);
      var aSkill = skillString.split("`");
      var pair = aSkill[0].split(" ");
      if (aSkill.length == 4) {
        this.addSkill(pair[0], aSkill[1], aSkill[2], aSkill[3], aSkill[3], pair[1]);
      } else {
        this.addSkill(pair[0], aSkill[1], aSkill[2], aSkill[3], aSkill[4], pair[1]);
      }
    }
  };
  this.parseByAttributes = function parseByAttributes(aSkills) {
    this.ctatdebug("parseByAttributes()");
    if (!aSkills) {
      pointer.ctatdebug("Error: aSkills is null");
      return;
    }
    var x = aSkills.childNodes;
    if (!x) {
      this.ctatdebug("Error: list of skill xml elements is null");
      return;
    }
    for (var i = 0;i < x.length;i++) {
      var elem = x[i];
      if (elem.nodeName == "Skill" || elem.nodeName == "skill") {
        this.ctatdebug("Parsing node (" + i + "): " + elem.nodeName + " -> " + elem.nodeValue);
        var nm = elem.attributes.getNamedItem("name");
        nm = nm ? nm.value : "";
        if (!nm) {
          continue;
        }
        var pK = elem.attributes.getNamedItem("pKnown");
        pK = pK ? pK.value : "";
        var desc = elem.attributes.getNamedItem("description");
        desc = desc ? desc.value : "";
        var lbl = elem.attributes.getNamedItem("label");
        lbl = lbl ? lbl.value : "";
        var cat = elem.attributes.getNamedItem("category");
        cat = cat ? cat.value : "";
        var pG = elem.attributes.getNamedItem("pGuess");
        pG = pG ? pG.value : "";
        var pL = elem.attributes.getNamedItem("pLearn");
        pL = pL ? pL.value : "";
        var pS = elem.attributes.getNamedItem("pSlip");
        pS = pS ? pS.value : "";
        var hist = elem.attributes.getNamedItem("history");
        hist = hist ? hist.value : "";
        this.addSkill(nm, pK, .95, desc, lbl, cat, pG, pL, pS, hist);
      }
    }
  };
  this.getSkillSet = function getSkillSet() {
    return this.internalSkillSet;
  };
  this.getSize = function getSize() {
    return this.internalSkillSet.length;
  };
  this.addSkill = function addSkill(aName, aLevel, aMastery, aDescription, aDisplayName, aCategory, pGuess, pLearn, pSlip, aHistory) {
    this.ctatdebug("addSkill() name = " + aName + " level = " + aLevel + " mastery = " + aMastery + " aDescription = " + aDescription + " adisplayName = " + aDisplayName + " aCategory = " + aCategory + " pguess= " + pGuess + " plearn = " + pLearn + " pslip = " + pSlip + " history = " + aHistory);
    var newSkill = this.setSkillLevel(aName, aLevel, aMastery);
    this.ctatdebug("Configuring " + newSkill.getDisplayName());
    if (aDescription) {
      newSkill.setDescription(aDescription);
    }
    if (aDisplayName) {
      newSkill.setDisplayName(aDisplayName);
    }
    if (aCategory) {
      newSkill.setCategory(aCategory);
    }
    if (Boolean(pGuess) || pGuess === 0) {
      newSkill.setPGuess(pGuess);
    }
    if (Boolean(pLearn) || pLearn === 0) {
      newSkill.setPLearn(pLearn);
    }
    if (Boolean(pSlip) || pSlip === 0) {
      newSkill.setPSlip(pSlip);
    }
    if (aHistory !== "") {
      newSkill.setSkillHistory(aHistory);
    }
    return newSkill;
  };
  this.addSkillAsObject = function(skillObj) {
    this.addSkill(skillObj.name, skillObj.level, skillObj.mastery, skillObj.description, skillObj.label, skillObj.category, skillObj.pGuess, skillObj.pLearn, skillObj.pSlip, "");
  };
  this.setSkillLevel = function setSkillLevel(aName, aLevel, aMastery) {
    this.ctatdebug("setSkillLevel (" + aName + "," + aLevel + "," + aMastery + ")");
    var skill = this.getSkill(aName);
    if (skill === null) {
      this.ctatdebug("Skill not found, creating new one ...");
      skill = new CTATSkill;
      skill.setSkillName(aName);
      skill.setLevel(aLevel);
      this.internalSkillSet.push(skill);
    } else {
      this.ctatdebug("Skill found, adjusting ...");
      skill.setLevel(1);
      skill.setLevel(aLevel);
    }
    skill.setTouched(true);
    return skill;
  };
  this.getSkill = function getSkill(aName) {
    this.ctatdebug("getSkill (" + aName + ") -> " + this.internalSkillSet.length);
    if (!aName) {
      return null;
    }
    for (var i = 0;i < this.internalSkillSet.length;i++) {
      var skill = this.internalSkillSet[i];
      if (skill.getSkillName() == aName) {
        this.ctatdebug("Returning: " + i);
        return skill;
      }
    }
    return null;
  };
  this.getSkillLevel = function getSkillLevel(aName) {
    if (!aName) {
      return -1;
    }
    for (var skill in this.internalSkillSet) {
      if (skill.getSkillName() == aName) {
        return skill.getLevel();
      }
    }
    return -1;
  };
  this.getTouched = function getTouched() {
    this.ctatdebug("getTouched ()");
    var touchedList = [];
    for (var i = 0;i < this.internalSkillSet.length;i++) {
      var skill = this.internalSkillSet[i];
      if (skill.getTouched() === true) {
        this.ctatdebug("Adding touched skill: " + skill.getSkillName());
        touchedList.push(skill);
      }
    }
    return touchedList;
  };
  this.untouchSkills = function untouchSkills() {
    this.ctatdebug("untouchSkills ()");
    for (var i = 0;i < this.internalSkillSet.length;i++) {
      var skill = this.internalSkillSet[i];
      skill.setTouched(false);
    }
  };
  this.toSetPreferencesXMLString = function toSetPreferencesXMLString() {
    this.ctatdebug("toSetPreferencesXMLString ()");
    var message = "<skills>";
    for (var i = 0;i < this.internalSkillSet.length;i++) {
      var skill = this.internalSkillSet[i];
      message += skill.toSetPreferencesXMLString();
    }
    message += "</skills>";
    return message;
  };
  this.toLogString = function toLogString() {
    this.ctatdebug("toLogString (" + this.internalSkillSet.length + ")");
    var skillString = "";
    for (var i = 0;i < this.internalSkillSet.length;i++) {
      var skill = this.internalSkillSet[i];
      skillString += '<skill probability="' + skill.getLevel() + '"><name>' + skill.getSkillName() + "</name>";
      if (skill.hasCategory()) {
        skillString += "<category>" + skill.getCategory() + "</category>";
      }
      if (skill.hasModelName()) {
        skillString += "<model_name>" + skill.getModelName() + "</model_name>";
      }
      skillString += "</skill>";
    }
    return skillString;
  };
};
CTATSkillSet.prototype = Object.create(CTATBase.prototype);
CTATSkillSet.prototype.constructor = CTATSkillSet;
CTATSkillSet.skills = null;
if (typeof module !== "undefined") {
  module.exports = CTATSkillSet;
}
;goog.provide("CTATJSON");
goog.require("CTATBase");
function CTATJSONObject(aName, aVal) {
  this.name = aName || "";
  this.value = aVal || null;
}
var transformArray = [];
CTATJSON = function() {
  CTATBase.call(this, "CTATJSON", "json");
  var JSONObject = null;
  var recursion = 5;
  var recursionCounter = 0;
  this.isJSONObject = function isJSONObject(anObject) {
    if (anObject.ctat) {
      return true;
    }
    return false;
  };
  this.parse = function parse(aMessage) {
    return this.parseJSON(aMessage);
  };
  this.parseJSON = function parseJSON(aMessage) {
    this.ctatdebug("parseJSON ()");
    JSONObject = null;
    if (typeof aMessage == "string") {
      this.ctatdebug("Parsing JSON as a string ... ");
      try {
        JSONObject = JSON.parse(aMessage);
      } catch (err) {
        this.ctatdebug("Error parsing JSON message: " + err.message);
        JSONObject = null;
        return null;
      }
      this.ctatdebug("Successfully parsed JSON string");
    }
    this.ctatdebug("JSON string has already been parsed, assigning as an object ...");
    for (var rootElement in JSONObject) {
      this.ctatdebug("Creating internal JSON object with name: " + rootElement);
      var rootObject = new CTATJSONObject;
      rootObject.name = rootElement;
      rootObject.value = JSONObject[rootElement];
      return rootObject;
    }
    return null;
  };
  this.getElementName = function getElementName(anElement) {
    if (typeof anElement != "object") {
      this.ctatdebug("Internal error, the provided element is not of type CTATJSONObject, instead we found: " + typeof anElement);
      return null;
    }
    return anElement.name;
  };
  this.getElementValue = function getElementValue(anElement) {
    if (anElement == null) {
      this.ctatdebug("Error: anElement is null");
      return null;
    }
    if (typeof anElement != "object") {
      this.ctatdebug("Internal error, the provided element is not of type CTATJSONObject, instead we found: " + typeof anElement);
      return null;
    }
    return anElement.value;
  };
  this.getElementChildren = function getElementChildren(anElement) {
    if (anElement == null) {
      this.ctatdebug("Error: anElement is null");
      return null;
    }
    if (typeof anElement != "object") {
      this.ctatdebug("Internal error, the provided element is not of type CTATJSONObject, instead we found: " + typeof anElement);
      return null;
    }
    var transf = null;
    var list = anElement.value;
    var listTransformer = [];
    for (var test in list) {
      var target = list[test];
      if (typeof target == "string") {
        transf = new CTATJSONObject;
        transf.name = test;
        transf.value = target;
        listTransformer.push(transf);
      } else {
        if (target[0] == null || target[0] == undefined) {
          transf = new CTATJSONObject;
          transf.name = test;
          transf.value = target;
          listTransformer.push(transf);
        } else {
          for (var sub in target) {
            transf = new CTATJSONObject;
            transf.name = test;
            transf.value = target[sub];
            listTransformer.push(transf);
          }
        }
      }
    }
    return listTransformer;
  };
  this.getNodeTextValue = function getNodeTextValue(aNode) {
    if (typeof aNode.value != "string") {
      var sub = null;
      for (sub in aNode.value) {
        if (sub == "content") {
          return aNode.value[sub].toString();
        }
      }
      for (sub in aNode.value) {
        if (sub == "value") {
          return aNode.value[sub].toString();
        }
      }
    }
    return aNode.value;
  };
  this.getElementAttr = function getElementAttr(anElement, attr) {
    var attrList = anElement.value;
    for (var test in attrList) {
      if (test == attr) {
        return attrList[test];
      }
    }
    return null;
  };
  this.isArray = function isArray(what) {
    return Object.prototype.toString.call(what) === "[object Array]";
  };
  this.walkDOM = function walkDOM(obj) {
    this.ctatdebug("walkDOM () >>>>>>>>>>>>>>>>>>");
    recursionCounter = 0;
    this.walk(obj);
    this.ctatdebug("walkDOM () <<<<<<<<<<<<<<<<<<");
  };
  this.walk = function walk(obj) {
    recursionCounter++;
    if (recursionCounter > recursion) {
      return;
    }
    var i = 0;
    for (var key in obj) {
      var val = obj[key];
      this.ctatdebug("(" + i + ") typeof (key): " + typeof key + " -> typeof(value): " + typeof val + "(" + val.length + ")");
      if (typeof val != "string") {
        this.ctatdebug("walk (" + key + ")");
        this.walk(val);
      } else {
        this.ctatdebug("walk (" + key + ") : " + val);
      }
      i++;
    }
  };
  this.stringify = function(anObject) {
    return this.toJSONString(anObject);
  };
  this.toJSONString = function toJSONString(anObject) {
    return JSON.stringify(anObject, null, 2);
  };
  this.syntaxHighlight = function syntaxHighlight(json) {
    if (typeof json != "string") {
      json = JSON.stringify(json, undefined, 2);
    }
    json = json.replace(/&/g, "&amp;").replace(/</g, "&lt;").replace(/>/g, "&gt;");
    return json.replace(/("(\\u[a-zA-Z0-9]{4}|\\[^u]|[^\\"])*"(\s*:)?|\b(true|false|null)\b|-?\d+(?:\.\d*)?(?:[eE][+\-]?\d+)?)/g, function(match) {
      var cls = "number";
      if (/^"/.test(match)) {
        if (/:$/.test(match)) {
          cls = "key";
        } else {
          cls = "string";
        }
      } else {
        if (/true|false/.test(match)) {
          cls = "boolean";
        } else {
          if (/null/.test(match)) {
            cls = "null";
          }
        }
      }
      return '<span class="' + cls + '">' + match + "</span>";
    });
  };
};
CTATJSON.prototype = Object.create(CTATBase.prototype);
CTATJSON.prototype.constructor = CTATJSON;
if (typeof module !== "undefined") {
  module.exports = CTATJSON;
}
;goog.provide("CTATMessage");
goog.require("CTATBase");
goog.require("CTATGlobalFunctions");
goog.require("CTATGuid");
goog.require("CTATSAI");
goog.require("CTATSkillSet");
goog.require("CTATXML");
goog.require("CTATJSON");
CTATMessage = function(aMessage) {
  CTATBase.call(this, "CTATMessage", "message");
  CTATMessage.makeTransactionId = function() {
    return CTATGuid.guid();
  };
  var messageObj = aMessage;
  var messageProperties = null;
  var messageParser = null;
  if (aMessage == undefined) {
    messageObj = null;
  }
  if (CTATConfig.parserType == "xml") {
    messageParser = new CTATXML;
  } else {
    messageParser = new CTATJSON;
  }
  if (messageObj) {
    this.ctatdebug("messageParser " + messageParser + ", messageObj " + messageObj);
    if (messageObj.children) {
      this.ctatdebug(messageObj.children);
    }
  }
  var gradeResult = "ungraded";
  var isLogMessage = false;
  var hassai = false;
  var rawMessage = "";
  var messageSkills = new CTATSkillSet;
  var messageType = "";
  var transactionID = "";
  var toolSelection = "";
  var successMsg = "";
  var buggyMsg = "";
  var highlightmessage = "";
  var shouldLog = true;
  var url;
  var sai = null;
  var studentSAI = null;
  var customFields = null;
  var rules = null;
  var isTransactionIdLocked = false;
  this.setURL = function setURL(aURL) {
    url = aURL;
  };
  this.getURL = function getURL() {
    return url;
  };
  this.assignSAI = function assignSAI(anSAI) {
    hassai = true;
    sai = anSAI;
  };
  this.setTransactionID = function setTransactionID(anID) {
    transactionID = anID;
  };
  this.getTransactionID = function getTransactionID() {
    return transactionID;
  };
  this.setGradeResult = function setGradeResult(aResult) {
    gradeResult = aResult;
  };
  this.getGradeResult = function getGradeResult() {
    return gradeResult;
  };
  this.getXMLObject = function getXMLObject() {
    return messageObj;
  };
  this.getSkillsObject = function getSkillsObject() {
    return messageSkills;
  };
  this.getCustomFields = function getCustomFields() {
    return customFields;
  };
  this.getRules = function getRules() {
    return rules;
  };
  this.getSuccessMessage = function getSuccessMessage() {
    return successMsg;
  };
  this.getBuggyMsg = function getBuggyMsg() {
    return buggyMsg;
  };
  this.getHighlightMsg = function getHighlightMsg() {
    return highlightmessage;
  };
  this.parse = function parse() {
    this.ctatdebug("parse ()");
    if (messageObj === null) {
      return;
    }
    this.ctatdebug("messageParser: " + messageParser);
    this.ctatdebug("Root name: " + messageParser.getElementName(messageObj));
    if (messageParser.getElementName(messageObj) == "tool_message") {
      this.ctatdebug("Detected tool message");
      messageType = "tool_message";
    } else {
      if (messageParser.getElementName(messageObj) != "message") {
        this.ctatdebug("Detected log message");
        isLogMessage = true;
        messageType = messageParser.getElementName(messageObj);
      } else {
        this.ctatdebug("Detected regular message");
        isLogMessage = false;
        this.parseMessageType();
      }
    }
    this.parseTransactionID();
    this.parseSAI();
    var tList = messageParser.getElementChildren(messageObj);
    for (var t = 0;t < tList.length;t++) {
      var entry = tList[t];
      if (messageParser.getElementName(entry) == "properties") {
        ctatdebug("Found a 'properties' element ... ");
        messageProperties = messageParser.getElementChildren(entry);
      }
    }
    this.ctatdebug("Message " + messageType + ", with transaction id: " + transactionID);
  };
  this.parseSAI = function parseSAI() {
    this.ctatdebug("parseSAI ()");
    var selection = "";
    var action = "";
    var input = "";
    var prompt = "";
    var selectionElts = [], actionElts = [], inputElts = [];
    if (messageType == "tool_message") {
      this.ctatdebug("Parsing s, a and i");
      var tList = messageParser.getElementChildren(messageObj);
      for (var t = 0;t < tList.length;t++) {
        var entry = tList[t];
        if (messageParser.getElementName(entry) == "tool_message") {
          var aList = messageParser.getElementChildren(entry);
          for (var w = 0;w < aList.length;w++) {
            var test = aList[w];
            if (messageParser.getElementName(test) == "event_descriptor") {
              sai = new CTATSAI;
              sai.fromXMLInternal(test);
            }
          }
        }
      }
      hassai = true;
      return;
    }
    if (!isLogMessage) {
      this.ctatdebug("!isLogMessage ...");
      var lList = messageParser.getElementChildren(messageObj);
      for (var l = 0;l < lList.length;l++) {
        var lentry = lList[l];
        if (messageParser.getElementName(lentry) == "properties") {
          var laList = messageParser.getElementChildren(lentry);
          for (var lw = 0;lw < laList.length;lw++) {
            var ltest = laList[lw];
            var eltName = messageParser.getElementName(ltest);
            this.ctatdebug("Nodename: " + eltName);
            switch(eltName) {
              case "URL":
                url = messageParser.getNodeTextValue(ltest);
                break;
              case "Skills":
                messageSkills.parseByValue(ltest);
                break;
              case "SuccessMsg":
                successMsg = selection = messageParser.getNodeTextValue(ltest);
                break;
              case "BuggyMsg":
                buggyMsg = messageParser.getNodeTextValue(ltest);
                break;
              case "Selection":
                selection = messageParser.getNodeTextValue(ltest);
                selectionElts.push(ltest);
                break;
              case "Action":
                action = messageParser.getNodeTextValue(ltest);
                actionElts.push(ltest);
                break;
              case "Input":
                input = messageParser.getNodeTextValue(ltest);
                inputElts.push(ltest);
                break;
              case "prompt":
                prompt = messageParser.getNodeTextValue(ltest);
                break;
              case "HighlightMsgText":
                highlightmessage = messageParser.getNodeTextValue(ltest);
                break;
              case "custom_fields":
                customFields = parseCustomFields(ltest);
                break;
              case "Rules":
                rules = parseRules(ltest);
                break;
            }
          }
        }
      }
      this.ctatdebug("SAI: " + selection + "," + action + "," + input);
    } else {
      this.ctatdebug("isLogMessage ...");
      var dList = messageParser.getElementChildren(messageObj);
      for (var d = 0;d < dList.length;d++) {
        var dentry = dList[d];
        if (messageParser.getElementName(dentry) == "event_descriptor") {
          var daList = messageParser.getElementChildren(dentry);
          for (var dw = 0;dw < daList.length;dw++) {
            var dtest = daList[dw];
            if (messageParser.getElementName(dtest) == "selection") {
              selection = messageParser.getNodeTextValue(dtest);
              selectionElts.push(dtest);
            }
            if (messageParser.getElementName(dtest) == "action") {
              action = messageParser.getNodeTextValue(dtest);
              actionElts.push(dtest);
            }
            if (messageParser.getElementName(dtest) == "input") {
              input = messageParser.getNodeTextValue(dtest);
              inputElts.push(dtest);
            }
            if (messageParser.getElementName(dtest) == "prompt") {
              prompt = messageParser.getNodeTextValue(dtest);
            }
          }
        }
      }
      this.ctatdebug("SAI: " + selection + "," + action + "," + input);
    }
    if (selection !== "" && selection !== null) {
      sai = new CTATSAI(selection, action, input, prompt);
      sai.setArrayFromElements(selectionElts);
      sai.setArrayFromElements(actionElts);
      sai.setArrayFromElements(inputElts);
      hassai = true;
    } else {
      this.ctatdebug("No SAI found");
      hassai = false;
    }
    this.ctatdebug("parseSAI () done, hassai: " + hassai + ", (" + selection + "," + action + "," + input + "," + prompt + ")");
  };
  this.parseTransactionID = function parseTransactionID() {
    this.ctatdebug("parseTransactionID()");
    if (messageType == "tool_message") {
      return;
    }
    if (!isLogMessage) {
      var tList = messageParser.getElementChildren(messageObj);
      for (var t = 0;t < tList.length;t++) {
        var entry = tList[t];
        if (messageParser.getElementName(entry) == "properties") {
          var aList = messageParser.getElementChildren(entry);
          for (var w = 0;w < aList.length;w++) {
            var test = aList[w];
            var nameCheck = messageParser.getElementName(test);
            if (nameCheck == "transaction_id") {
              transactionID = messageParser.getNodeTextValue(test);
            }
          }
        }
      }
    } else {
    }
    this.ctatdebug("parseTransactionID() done, id: " + transactionID);
  };
  function parseRules(rulesElt) {
    var result = [];
    var valueElts = messageParser.getElementChildren(rulesElt);
    this.ctatdebug("CTATMessage.parseCustomFields(" + messageParser.stringify(rulesElt) + "): valueElts.length " + valueElts.length);
    for (var i = 0;i < valueElts.length;++i) {
      var valueElt = valueElts[i];
      if (messageParser.getElementName(valueElt) != "value") {
        console.log("CTATMessage.parseRules(): unexpected element name " + messageParser.getElementName(valueElt) + " at custom_fields[" + i + "]");
        continue;
      }
      var valueText = messageParser.getNodeTextValue(valueElt);
      if (valueText) {
        result.push(valueText);
      }
    }
    return result;
  }
  function parseCustomFields(cfParentElt) {
    var result = {};
    var cfElts = messageParser.getElementChildren(cfParentElt);
    this.ctatdebug("CTATMessage.parseCustomFields(" + messageParser.stringify(cfParentElt) + "): cfElts.length " + cfElts.length);
    for (var i = 0;i < cfElts.length;++i) {
      var cfElt = cfElts[i];
      if (messageParser.getElementName(cfElt) != "custom_field") {
        continue;
      }
      var name = null, value = null;
      var cfEltChildren = messageParser.getElementChildren(cfElt);
      for (var j = 0, nf = 0;j < cfEltChildren.length && nf < 2;++j) {
        var cfEltChild = cfEltChildren[j];
        switch(messageParser.getElementName(cfEltChild)) {
          case "name":
            name = messageParser.getNodeTextValue(cfEltChild);
            nf++;
            break;
          case "value":
            value = messageParser.getNodeTextValue(cfEltChild);
            nf++;
            break;
          default:
            break;
        }
      }
      if (!name) {
        continue;
      }
      result[name] = value ? value : "";
      this.ctatdebug("CTATMessage.parseCustomFields(): result[" + name + "]=" + result[name] + ";");
    }
    return result;
  }
  this.parseMessageType = function parseMessageType() {
    this.ctatdebug("parseMessageType()");
    var tList = messageParser.getElementChildren(messageObj);
    for (var t = 0;t < tList.length;t++) {
      var entry = tList[t];
      if (messageParser.getElementName(entry) == "properties") {
        var aList = messageParser.getElementChildren(entry);
        for (var w = 0;w < aList.length;w++) {
          var test = aList[w];
          if (messageParser.getElementName(test) == "MessageType") {
            messageType = messageParser.getNodeTextValue(test);
          }
        }
      }
    }
    this.ctatdebug("parseMessageType() -> " + messageType);
  };
  this.getMessageType = function() {
    return messageType;
  };
  this.getTransactionID = function getTransactionID() {
    return transactionID;
  };
  this.getSAI = function getSAI() {
    return hassai ? sai : new CTATSAI;
  };
  this.getSelection = function getSelection() {
    return hassai ? sai.getSelection() : "";
  };
  this.getAction = function getAction() {
    return hassai ? sai.getAction() : "";
  };
  this.getInput = function getInput() {
    return hassai ? sai.getInput() : "";
  };
  this.getSelectionArray = function getSelectionArray() {
    return hassai ? sai.getSelectionArray() : [];
  };
  this.getActionArray = function getActionArray() {
    return hassai ? sai.getActionArray() : [];
  };
  this.getInputArray = function getInputArray() {
    return hassai ? sai.getInputArray() : [];
  };
  this.getXML = function getXML() {
    return messageObj;
  };
  this.getXMLString = function getXMLString(pretty) {
    if (messageObj.xml) {
      return messageObj.xml;
    } else {
      if (XMLSerializer) {
        var xml_serializer = new XMLSerializer;
        return xml_serializer.serializeToString(messageObj);
      } else {
        alert("ERROR: Extremely old browser");
        return "";
      }
    }
  };
  this.getIndicator = function getIndicator() {
    if (messageType != "AssociatedRules") {
      return "";
    }
    return this.getProperty("Indicator");
  };
  this.getIndicatorSub = function getIndicatorSub() {
    if (messageType != "AssociatedRules") {
      return "";
    }
    return this.getProperty("IndicatorSub");
  };
  this.setProperty = function setProperty(property, value) {
    this.ctatdebug("setProperty (" + property + "," + value + ")");
    if (messageProperties !== null) {
      for (var w = 0;w < messageProperties.length;w++) {
        var test = messageProperties[w];
        if (messageParser.getElementName(test) == property) {
        }
      }
    } else {
      this.ctatdebug("Internal error: no messageProperties object available");
    }
  };
  this.getProperty = function getProperty(property) {
    if (isLogMessage) {
      return "";
    } else {
      if (messageProperties !== null) {
        for (var w = 0;w < messageProperties.length;w++) {
          var test = messageProperties[w];
          if (messageParser.getElementName(test) == property) {
            return messageParser.getNodeTextValue(test);
          }
        }
      } else {
        this.ctatdebug("Internal error: no messageProperties object available");
      }
    }
    return "";
  };
  this.hasProperty = function hasProperty(property) {
    var prop = this.getProperty(property);
    return !isLogMessage && prop !== "";
  };
  this.hasSAI = function hasSAI() {
    return hassai;
  };
  this.isEndOfTransaction = function isEndOfTransaction() {
    var trans = this.getProperty("end_of_transaction");
    if (trans == "true") {
      return true;
    }
    return false;
  };
  this.isLogMessageType = function isLogMessageType() {
    return isLogMessage;
  };
  this.hasStudentSAI = function hasStudentSAI() {
    return studentSAI !== null;
  };
  this.getStudentSelection = function getStudentSelection() {
    return studentSAI.getSelection();
  };
  this.getStudentAction = function getStudentAction() {
    return studentSAI.getAction();
  };
  this.getStudentInput = function getStudentInput() {
    return studentSAI.getInput();
  };
  this.getStudentSAI = function getStudentSAI() {
    return studentSAI;
  };
  this.getToolSelection = function getToolSelection() {
    return toolSelection;
  };
  transactionID = CTATMessage.makeTransactionId();
  this.parse();
  this.init = function(givMessageType) {
    this.setMessageType(givMessageType);
  };
  this.setSelection = function(selection) {
    if (sai) {
      sai.setSelection(selection);
    }
    this.setProperty("SELECTION", selection);
  };
  this.setAction = function(action) {
    if (sai) {
      sai.setAction(action);
    }
    this.setProperty("ACTION", action);
  };
  this.setInput = function(input) {
    if (sai) {
      sai.setInput(input);
    }
    this.setProperty("INPUT", input);
  };
  this.lockTransactionId = function(id) {
    if (id === null || typeof id === "undefined" || id.length < 1) {
      throw new CTATExampleTracerException("lockTranactionId() argument " + id + " must be a valid id");
    }
    this.setProperty(CTATMessage.TRANSACTION_ID_TAG, id);
    isTransactionIdLocked = true;
  };
  this.setMessageType = function(givMessageType) {
    this.setProperty(CTATMessage.MESSAGE_TYPE, givMessageType);
    messageType = givMessageType;
  };
  this.setTransactionId = function(id) {
    if (isTransactionIdLocked) {
      return;
    }
    if (id === null || typeof id === "undefined" || id.length < 1) {
      id = CTATMessage.makeTransactionId();
    }
    this.setProperty(CTATMessage.TRANSACTION_ID_TAG, id);
  };
  this.suppressLogging = function() {
    shouldLog = false;
  };
  this.isLoggingSuppressed = function() {
    return !shouldLog;
  };
  CTATMessage.create = function(givMessageType, verb) {
    var result = new CTATMessage;
    result.init(givMessageType);
    return result;
  };
};
Object.defineProperty(CTATMessage, "MESSAGE_TYPE", {enumerable:false, configurable:false, writable:false, value:"MessageType"});
Object.defineProperty(CTATMessage, "TRANSACTION_ID_TAG", {enumerable:false, configurable:false, writable:false, value:"transaction_id"});
CTATMessage.prototype = Object.create(CTATBase.prototype);
CTATMessage.prototype.constructor = CTATMessage;
if (typeof module !== "undefined") {
  module.exports = CTATMessage;
}
;goog.provide("CTATSkills");
goog.require("CTATBase");
goog.require("CTATXML");
goog.require("CTATExampleTracerSkill");
CTATSkills = function(skillList) {
  CTATBase.call(this, "CTATSkills", skillList ? String(skillList.length) : "");
  var skillMap = {};
  var transactionNumber = 0;
  skillList.forEach(function(skill) {
    skillMap[skill.getSkillName().toLowerCase()] = skill;
  });
  var updatedStepIDs = new Set;
  var externallyDefined = false;
  var version = null;
  var that = this;
  this.toXML = function(escape, whitespace) {
    if (!whitespace) {
      whitespace = "";
    }
    var sb = escape ? "&lt;Skills&gt;" : "<Skills>";
    var sbLength0 = sb.length;
    for (var sk in skillMap) {
      if (skillMap.hasOwnProperty(sk) && skillMap[sk]) {
        sb += whitespace + skillMap[sk].toXML(escape);
      }
    }
    sb += whitespace && sb.length > sbLength0 ? "\n" : "";
    sb += escape ? "&lt;/Skills&gt;" : "</Skills>";
    return sb;
  };
  this.getAllSkills = function() {
    var result = [];
    for (var sk in skillMap) {
      if (skillMap.hasOwnProperty(sk) && skillMap[sk]) {
        result.push(skillMap[sk]);
      }
    }
    return result;
  };
  this.addSkill = function(skill, replace) {
    if (!that.getSkill(skill.getSkillName()) || replace) {
      skillMap[skill.getSkillName().toLowerCase()] = skill;
    }
  };
  this.updateSkill = function(transactionResult, skillName, stepID) {
    var result = null;
    var skill = that.getSkill(skillName);
    if (skill !== null && typeof skill !== "undefined") {
      skill.setTransactionNumber(transactionNumber);
      var key = stepID + " " + skillName;
      if (!updatedStepIDs.has(key)) {
        updatedStepIDs.add(key);
        skill.updatePKnown(transactionResult);
        skill.updateHistory(transactionResult);
        skill.changeOpportunityCount(1);
      }
      if (CTATExampleTracerSkill.CORRECT.toString().toUpperCase() === transactionResult.toString().toUpperCase()) {
        updatedStepIDs["delete"](key);
      }
      result = skill;
    }
    return result;
  };
  this.startTransaction = function() {
    ++transactionNumber;
  };
  this.getSkill = function(skillName) {
    var toGet = skillName === null || typeof skillName === "undefined" ? null : skillName.toLowerCase();
    var sk = skillMap[toGet];
    that.ctatdebug("CTATSkills.getSkill(" + skillName + ") returns " + sk);
    return sk;
  };
  this.getSkillBarVector = function(includeLabels, includeAll) {
    var result = [];
    for (var skill in skillMap) {
      if (skillMap.hasOwnProperty(skill) === true) {
        if (includeAll === true || skillMap[skill].getTransactionNumber() === transactionNumber) {
          result.push(skillMap[skill].getSkillBarString(includeLabels));
        }
      }
    }
    return result;
  };
  this.setExternallyDefined = function(givenExternallyDefined) {
    externallyDefined = givenExternallyDefined;
  };
  this.setVersion = function(givenVersion) {
    version = givenVersion;
    for (var sk in skillMap) {
      if (skillMap.hasOwnProperty(sk) === true) {
        skillMap[sk].setVersion(givenVersion);
      }
    }
  };
  this.toJSON = function(key) {
    that.ctatdebug("CTATSkills.toJSON(" + key + ") to return " + (key == "pSummarySkills" ? that.getAllSkills() : that[key]));
    return key ? key == "pSummarySkills" ? that.getAllSkills() : that[key] : that;
  };
};
CTATSkills.fromJSON = function(jsonObj) {
  return Array.isArray(jsonObj) ? new CTATSkills(jsonObj.map(function(s) {
    return CTATExampleTracerSkill.fromJSON(s);
  })) : null;
};
CTATSkills.parseSkills = function(skillsElt, parser) {
  var skillList = [];
  if (!parser) {
    parser = new CTATXML;
  }
  try {
    var skills = parser.getElementChildren(skillsElt);
    for (var index = 0;index < skills.length;index++) {
      var eltName = parser.getElementName(skills[index]);
      if (eltName && eltName.toLowerCase() == "skill") {
        var name = parser.getElementAttr(skills[index], "name");
        if (!name || name.trim() == "") {
          continue;
        }
        var label = parser.getElementAttr(skills[index], "label");
        var pSlip = parser.getElementAttr(skills[index], "pSlip");
        var description = parser.getElementAttr(skills[index], "description");
        var pKnown = parser.getElementAttr(skills[index], "pKnown");
        var category = parser.getElementAttr(skills[index], "category");
        var pLearn = parser.getElementAttr(skills[index], "pLearn");
        var pGuess = parser.getElementAttr(skills[index], "pGuess");
        var history = parser.getElementAttr(skills[index], "history");
        var skill = new CTATExampleTracerSkill(category, name, pGuess, pKnown, pSlip, pLearn, history);
        skill.setLabel(label);
        skill.setDescription(description);
        skillList.push(skill);
      }
    }
  } catch (e) {
    console.log("Error in CTATSkills.parseSkills", e, "\n skillsElt", skillsElt);
  }
  return skillList;
};
CTATSkills.prototype = Object.create(CTATBase.prototype);
CTATSkills.prototype.constructor = CTATSkills;
if (typeof module !== "undefined") {
  module.exports = CTATSkills;
}
;goog.provide("CTATSequencer");
goog.require("CTATBase");
goog.require("CTATPackage");
goog.require("CTATCommLibrary");
goog.require("CTATXML");
goog.require("CTATScrim");
goog.require("CTATMessage");
goog.require("CTATSkills");
goog.require("CTATLMS");
goog.require("CTATConfiguration");
goog.require("CTATLanguageManager");
CTATSequencer = function(givenConfig, ctatlmsListener) {
  CTATBase.call(this, "CTATSequencer", "sequencer");
  if (typeof location != "undefined" && location.search.replace(/.*[?&]show_debug_traces=([^&]*)&?.*/, "$1") == "basic") {
    useDebuggingBasic = true;
  }
  if (CTATLMS.is.OLI()) {
    useDebuggingBasic = true;
  }
  var pointer = this;
  var packageManager = new CTATPackage;
  var parser = new CTATXML;
  var retriever = null;
  var algorithm = "sequential";
  var sequenceReadyHandler = null;
  var CTATLMSListener = ctatlmsListener || function(evt) {
    console.log("CTATSequencer default CTATLMSListener", evt);
  };
  var currentSkills = new CTATSkills([]);
  this.currentIndex = -1;
  this.iframeId = "ctat_inner_frame";
  this.setAlgorithm = function setAlgorithm(anAlgorithm) {
    algorithm = anAlgorithm;
  };
  this.getAlgorithm = function getAlgorithm() {
    return algorithm;
  };
  this.handlePackageRetrieval = function handlePackageRetrieval(aData) {
    pointer.ctatdebug("handlePackageRetrieval ()");
    packageManager.init(aData);
    if (sequenceReadyHandler != null) {
      sequenceReadyHandler(packageManager, pointer.currentIndex + 1);
    }
  };
  this.processXML = function processXML(aRoot) {
    pointer.ctatdebug("parseXML ()");
    packageManager.init(aRoot);
    if (sequenceReadyHandler != null) {
      sequenceReadyHandler(packageManager, pointer.currentIndex + 1);
    }
  };
  this.init = function init(aPackageURL, aHandler, aURLPrefix, aIframeId, aStudentInterface, pIndex) {
    pointer.ctatdebug("CTATSequencer.init (" + aPackageURL + ", " + aHandler + ", " + aURLPrefix + ", " + aIframeId + ", " + aStudentInterface + ", " + pIndex + ")");
    if (!Number.isNaN(pIndex = Number(pIndex)) && pIndex >= 0) {
      pointer.currentIndex = pIndex - 1;
    }
    pointer.iframeId = aIframeId || pointer.iframeId;
    packageManager.setPackageURL(aPackageURL);
    packageManager.setURLPrefix(aURLPrefix);
    packageManager.setDefaultStudentInterface(aStudentInterface);
    sequenceReadyHandler = aHandler || pointer.runNextProblem.bind(pointer);
    retriever = new CTATCommLibrary(null, false);
    retriever.retrieveXMLFile(aPackageURL, parser, this);
    addEventListener("message", function(evt) {
      var iframe = document.getElementById(pointer.iframeId);
      pointer.ctatdebug("CTATSequencer.init() iframe " + iframe + ", evt.data " + evt.data);
      if (evt.data && /tutorready/i.test(evt.data.command)) {
        try {
          iframe.contentWindow.CTATCommShell.commShell.assignDoneProcessor(pointer.advanceToNextProblem.bind(pointer));
        } catch (e) {
          throw new Error("CTATSequencer.init() error adding listener to iframe '" + pointer.iframeId + ": " + e);
        }
      }
    });
  };
  this.getSequenceType = function() {
    return "fixed";
  };
  this.getCurrentIndex = function() {
    return pointer.currentIndex;
  };
  this.advanceToNextProblem = function(psResp) {
    pointer.ctatdebug("advanceToNextProblem()\n psResp " + psResp);
    pointer.processProblemSummaryResponse(psResp);
    pointer.runNextProblem();
  };
  this.processProblemSummaryResponse = function(psResp) {
    try {
      var msg = new CTATMessage(parser.parse(psResp));
      var ps = msg.getProperty("ProblemSummary");
      pointer.ctatdebug("processProblemSummaryResponse typeof(ps)" + typeof ps + ", ps " + ps);
      var psRoot = parser.parse(ps);
      var psChildren = parser.getElementChildren(psRoot);
      for (var i = 0;i < psChildren.length;++i) {
        if (!/^skills$/i.test(parser.getElementName(psChildren[i]))) {
          continue;
        }
        var skillList = CTATSkills.parseSkills(psChildren[i], parser);
        pointer.ctatdebug("processProblemSummaryResponse skillList.length " + (skillList ? skillList.length : null));
        skillList.forEach(function(skill) {
          currentSkills.addSkill(skill, true);
        });
        return;
      }
    } catch (e) {
      console.log("Error in processProblemSummaryResponse", e, "\n psResp", psResp);
    }
  };
  this.getProblemSetSize = function getProblemSetSize() {
    pointer.ctatdebug("getProblemSetSize ()");
    var pSets = packageManager.getProblemSets();
    if (pSets.length == 0) {
      pointer.ctatdebug("Error: no problem sets available, trying list of problems directly ...");
      var pList = packageManager.getProblems();
      return pList.getProblemSize();
    } else {
      var pSet = pSets[0];
      return pSet.getProblemSize();
    }
    return 0;
  };
  this.getFirstProblem = function getFirstProblem() {
    pointer.ctatdebug("getFirstProblem(): currentIndex " + pointer.currentIndex);
    pointer.currentIndex = -1;
    return getNextProblem();
  };
  this.getProblemList = function getProblemList() {
    pointer.ctatdebug("getProblemList ()");
    var pSets = packageManager.getProblemSets();
    if (pSets.length == 0) {
      pointer.ctatdebug("Error: no problem sets available, trying list of problems directly ...");
      var pList = packageManager.getProblems();
      return pList;
    } else {
      var pSet = pSets[0];
      return pSet.getProblems();
    }
    return null;
  };
  this.runNextProblem = function() {
    var p = pointer.getNextProblem();
    pointer.ctatdebug("CTATSequencer.runNextProblem() " + p);
    return pointer.runProblem(p) || CTATScrim.scrim.scrimUp(CTATLanguageManager.theSingleton.filterString("DONE_WITH_PROBLEM_SET")) || null;
  };
  this.runProblem = function(p) {
    if (!p) {
      return null;
    }
    var iframe = document.getElementById(pointer.iframeId);
    pointer.ctatdebug("CTATSequencer.runProblem(" + p + ") iframe " + iframe);
    if (!iframe) {
      throw new Error("CTATSequencer.runProblem(" + p + "): iframe '" + pointer.iframeId + "' not found");
    }
    var config = {};
    Object.assign(config, CTATConfiguration.getRawFlashVars());
    if (!config.dataset_level_name1) {
      config.dataset_level_name1 = p.getProblemFile();
      config.dataset_level_type1 = "Activity";
    }
    config.problem_name = p.getProblemFile();
    config.question_file = packageManager.getRelativePath(p.getStudentInterface(), p.getProblemFile());
    config.student_interface = p.getStudentInterface();
    config.skills = encodeURIComponent(pointer.getRevisedSkills(p.getSkills()).toXML());
    iframe.setAttribute("data-params", JSON.stringify(config));
    iframe.src = packageManager.getURLPrefix() + packageManager.getRelativePath(p.getStudentInterface()) + (config.mode ? "?MODE=" + config.mode : "");
    return p;
  };
  this.getRevisedSkills = function(problemSkills, replace) {
    problemSkills.forEach(function(sk) {
      currentSkills.addSkill(sk, replace);
    });
    return currentSkills;
  };
  this.getNextProblem = function() {
    pointer.ctatdebug("getNextProblem(): currentIndex " + pointer.currentIndex);
    var pSets = packageManager.getProblemSets();
    if (pSets.length == 0) {
      pointer.ctatdebug("Error: no problem sets available, trying list of problems directly ...");
      var pList = packageManager.getProblems();
      return pList[++pointer.currentIndex];
    } else {
      var pSet = pSets[0];
      return pSet.getProblems()[++pointer.currentIndex];
    }
    return null;
  };
  this.addProblem = function(problemFile, studentInterface, name, label, description) {
    packageManager.addProblem(problemFile, studentInterface, name, label, description);
  };
  CTATConfiguration.generateDefaultConfigurationObject(givenConfig, typeof CTATTarget == "undefined" ? undefined : CTATTarget);
  addEventListener("ctatlms", function(evt) {
    console.log("CTATSequencer ctatlms listener evt", evt);
    CTATLMSListener(evt);
  });
};
CTATSequencer.prototype = Object.create(CTATBase.prototype);
CTATSequencer.prototype.constructor = CTATSequencer;
Object.defineProperty(CTATSequencer, "PackageListURI", {enumerable:false, configurable:false, writable:false, value:new RegExp("^([^?]*/)?package[.]xml$", "i")});
goog.provide("CTATActionEvaluationData");
goog.require("CTATBase");
CTATActionEvaluationData = function(anEval) {
  CTATBase.call(this, "CTATActionEvaluationData", "actionevaluation");
  var classification = "";
  var currentHintNumber = 0;
  var totalHintsAvailable = 0;
  var hintID = "";
  var evaluation = anEval;
  this.setClassification = function setClassification(classification) {
    this.classification = classification;
  };
  this.isHint = function isHint() {
    return evaluation == "HINT";
  };
  this.hasClassification = function hasClassification() {
    return classification != null;
  };
  this.setCurrentHintNumber = function setCurrentHintNumber(hintNumber) {
    currentHintNumber = hintNumber;
  };
  this.setTotalHintsAvailable = function setTotalHintsAvailable(numHints) {
    totalHintsAvailable = numHints;
  };
  this.setHintID = function setHintID(theID) {
    hintID = theID;
  };
  this.getClassification = function getClassification() {
    return classification;
  };
  this.setEvaluation = function setEvaluation(theEvluation) {
    evaluation = theEvluation;
  };
  this.getEvaluation = function getEvaluation() {
    return evaluation;
  };
  this.getAttributeString = function getAttributeString() {
    var retString = "";
    if (classification !== "") {
      retString += 'classification="' + classification + '" ';
    }
    if (!this.isHint()) {
      return retString;
    }
    retString += 'current_hint_number="' + currentHintNumber + '" ';
    retString += 'total_hints_available="' + totalHintsAvailable + '" ';
    if (hintID !== "") {
      retString += 'hint_id="' + hintID + '" ';
    }
    return retString;
  };
};
CTATActionEvaluationData.prototype = Object.create(CTATBase.prototype);
CTATActionEvaluationData.prototype.constructor = CTATActionEvaluationData;
goog.provide("CTATVariable");
CTATVariable = function() {
  this.name = "";
  this.value = "";
};
goog.provide("CTATCurriculumService");
goog.require("CTATBase");
goog.require("CTATGlobals");
goog.require("CTATScrim");
goog.require("CTATVariable");
CTATCurriculumService = function(aCommLibrary) {
  CTATBase.call(this, "CTATCurriculumService", "curriculum_service");
  var commLibrary = aCommLibrary;
  var variables = [];
  var pointer = this;
  this.reset = function reset() {
    variables = [];
  };
  this.addVariable = function addVariable(aName, aValue) {
    var variable = new CTATVariable;
    variable.name = aName;
    variable.value = aValue;
    variables.push(variable);
  };
  this.sendSummary = function sendSummary(aMessage) {
    pointer.ctatdebug("sendSummary ()");
    var generator = new CTATXML;
    var problemXML = aMessage.getXMLObject();
    var problemRaw = problemXML.getElementsByTagName("ProblemSummary");
    var problemStr = $("<div>").html(problemRaw[0].innerHTML).text();
    var problemSummary = generator.xmlToString(problemXML);
    var vars = flashVars.getRawFlashVars();
    var url = vars["curriculum_service_url"];
    var subProcessor = new CTATXML;
    var root = subProcessor.parse(problemStr);
    var complete = subProcessor.getElementAttr(root, "CompletionStatus");
    if (url) {
      if (complete && complete.toLowerCase().startsWith("complete")) {
        CTATScrim.scrim.nextProblemScrimUp();
        commLibrary.assignMessageListener(pointer);
        commLibrary.assignHandler(pointer);
      }
      variables = [];
      this.addVariable("user_guid", vars["user_guid"]);
      this.addVariable("session_id", vars["session_id"]);
      this.addVariable("authenticity_token", vars["authenticity_token"]);
      this.addVariable("school_name", vars["school_name"]);
      this.addVariable("summary", problemStr);
      var targetFrame = vars["target_frame"];
      var reuseSWF = vars["reuse_swf"];
      var runProblemUrl = vars["run_problem_url"];
      this.addVariable("targetFrame", targetFrame);
      this.addVariable("reuseSWF", reuseSWF);
      pointer.ctatdebug("CTATCurriculumService.sendSummary about to send targetFrame = " + targetFrame + ", reuseSwf " + reuseSWF + ", runProblemUrl " + runProblemUrl);
      commLibrary.send_post_variables(url, variables);
    } else {
      if (complete == "complete") {
        var str = CTATGlobals.languageManager.getString("CONGRATULATIONS_YOU_ARE_DONE");
        CTATScrim.scrim.OKScrimUp(str, function() {
          var cList = CTATShellTools.getAllComponents();
          var hWindow = cList.find(function(c) {
            return c.getClassName() === "CTATHintWindow";
          });
          if (hWindow) {
            hWindow.showFeedback(str);
          }
          cList.forEach(function(c) {
            return c.lock();
          });
          CTATScrim.scrim.scrimDown();
        });
      }
    }
  };
  this.processOutgoing = function(msg) {
    pointer.ctatdebug('CTATCurriculumService.processOutgoing("' + msg + '")');
  };
  this.processIncoming = function(msg) {
    var vars = flashVars.getRawFlashVars();
    var runProblemUrl = vars["run_problem_url"];
    pointer.ctatdebug("CTATCurriculumService.processIncoming(" + (msg ? msg.substring(0, 12) + "..." : "") + ") parent.location.replace " + parent.location.replace + ', runProblemUrl "' + runProblemUrl + '"');
    if (!runProblemUrl || !parent || !parent.location) {
      return;
    }
    var loggingLib = CTATCommShell.commShell.getLoggingLibrary();
    loggingLib && loggingLib.then(function() {
      parent.location.replace(runProblemUrl);
    }, function() {
      console.log("CTATCurriculumService: cannot chain to logging lib " + loggingLib);
    });
  };
  this.processMessage = function processMessage(msg) {
    this.ctatdebug("CTATCurriculumService.processMessage(" + (msg ? msg.substring(0, 30) + "..." : "") + ")");
  };
  this.updateFlashVars = function updateFlashVars(variables) {
    pointer.ctatdebug("UpdateFlashVars ()");
  };
  this.checkProtocol = function checkProtocol(flashVarURL) {
    if (flashVarURL == "localhost" || flashVarURL == "127.0.0.1") {
      return true;
    }
    var pattern = new RegExp("^http[s]?:\\/\\/([^\\/]+)\\/");
    var result = pattern.exec(flashVarURL);
    if (result === null || flashVarURL.length >= 4096) {
      return false;
    }
    return true;
  };
};
CTATCurriculumService.prototype = Object.create(CTATBase.prototype);
CTATCurriculumService.prototype.constructor = CTATCurriculumService;
goog.provide("CTATLogMessageBuilder");
goog.require("CTATBase");
goog.require("CTATGlobals");
CTATLogMessageBuilder = function() {
  CTATBase.call(this, "CTATLogMessageBuilder", "logmessagebuilder");
  var pointer = this;
  var xmlHeader = "";
  var customFieldNames = [];
  var customFieldValues = [];
  var stepID = "";
  this.getStepID = function() {
    return stepID;
  };
  this.setContextName = function setContextName(context_name) {
    CTATLogMessageBuilder.contextGUID = context_name;
  };
  this.getContextName = function getContextName() {
    return CTATLogMessageBuilder.contextGUID;
  };
  this.makeSessionElement = function makeSessionElement() {
    var vars = flashVars.getRawFlashVars();
    if (vars["log_session_id"] != undefined && vars["log_session_id"] != null) {
      return "<session_id>" + vars["log_session_id"] + "</session_id>";
    }
    return "<session_id>" + vars["session_id"] + "</session_id>";
  };
  this.createContextMessage = function createContextMessage(aWrapForOLI) {
    pointer.ctatdebug("createContextMessage()");
    var now = new Date;
    var vars = flashVars.getRawFlashVars();
    var messageString = xmlHeader + '<context_message context_message_id="' + this.getContextName() + '" name="START_PROBLEM">';
    if (!aWrapForOLI) {
      messageString += this.makeMetaElement(now);
    }
    var classS = "";
    if (vars["class_name"] != undefined) {
      if (vars["class_name"] != "") {
        classS = "<class>";
        classS += "<name>" + vars["class_name"] + "</name>";
        if (vars["school_name"] != undefined) {
          classS += "<school>" + vars["school_name"] + "</school>";
        }
        if (vars["period_name"] != undefined) {
          classS += "<period>" + vars["period_name"] + "</period>";
        }
        if (vars["class_description"] != undefined) {
          classS += "<description>" + vars["class_description"] + "</description>";
        }
        if (vars["instructor_name"] != undefined) {
          classS += "<instructor>" + vars["instructor_name"] + "</instructor>";
        }
        classS += "</class>";
      } else {
        classS = "<class />";
      }
    } else {
      classS = "<class />";
    }
    messageString += classS;
    var datasetLevelTypes = flashVars.getDatasetTypes();
    var datasetLevelNames = flashVars.getDatasetNames();
    pointer.ctatdebug("Check: " + datasetLevelTypes.length + ", " + datasetLevelNames.length);
    if (datasetLevelTypes != null && datasetLevelNames != null) {
      pointer.ctatdebug("We have valid data set names and types, adding to message ...");
      var dataset = "<dataset>";
      dataset += "<name>" + vars["dataset_name"] + "</name>";
      for (var k = 0;k < datasetLevelTypes.length;k++) {
        pointer.ctatdebug("Adding ...");
        dataset += '<level type="' + datasetLevelTypes[k] + '">';
        dataset += "<name>" + datasetLevelNames[k] + "</name>";
      }
      dataset += "<problem ";
      pointer.ctatdebug('Checking vars ["problem_tutorflag"]: ' + vars["problem_tutorflag"]);
      pointer.ctatdebug('Checking vars ["problem_otherproblemflag"]: ' + vars["problem_otherproblemflag"]);
      if (vars["problem_tutorflag"] != undefined || vars["problem_otherproblemflag"] != undefined) {
        if (vars["problem_tutorflag"] != undefined) {
          dataset += ' tutorFlag="' + vars["problem_tutorflag"] + '"';
        } else {
          if (vars["problem_otherproblemflag"] != undefined) {
            dataset += 'tutorFlag="' + vars["problem_otherproblemflag"] + '"';
          }
        }
      }
      dataset += ">";
      dataset += "<name>" + vars["problem_name"] + "</name>";
      if (vars["problem_context"] != undefined) {
        dataset += "<context>" + vars["problem_context"] + "</context>";
      } else {
        dataset += "<context />";
      }
      dataset += "</problem>";
      for (var l = 0;l < datasetLevelTypes.length;l++) {
        dataset += "</level>";
      }
      dataset += "</dataset>";
      messageString += dataset;
    }
    var condition = "";
    var conditionNames = flashVars.getConditionNames();
    var conditionTypes = flashVars.getConditionTypes();
    var conditionDescriptions = flashVars.getConditionDescriptions();
    if (conditionNames.length > 0) {
      for (var i = 0;i < conditionNames.length;i++) {
        condition += "<condition><name>" + conditionNames[i] + "</name>";
        condition += conditionTypes[i] == "" ? "" : "<type>" + conditionTypes[i] + "</type>";
        condition += conditionDescriptions[i] == "" ? "" : "<desc>" + conditionDescriptions[i] + "</desc>";
        condition += "</condition>";
      }
    }
    messageString += condition;
    var cFields = flashVars.getCustomFields();
    for (var aField in cFields) {
      if (cFields.hasOwnProperty(aField)) {
        var v = String(cFields[aField]);
        v = v.indexOf("<![CDATA[") < 0 ? "<![CDATA[" + v + "]]\x3e" : v;
        messageString += "<custom_field>";
        messageString += "<name>" + aField + "</name>";
        messageString += "<value>" + v + "</value>";
        messageString += "</custom_field>";
      }
    }
    messageString += "</context_message>";
    pointer.ctatdebug("messageString = " + messageString);
    return messageString;
  };
  this.createSemanticEventToolMessage = function createSemanticEventToolMessage(sai, semanticTransactionID, semanticName, semanticSubType, wrapForOLI, aTrigger) {
    pointer.ctatdebug("createSemanticEventToolMessage(" + aTrigger + ")");
    var now = new Date;
    var vars = flashVars.getRawFlashVars();
    var messageString = xmlHeader + '<tool_message context_message_id="' + this.getContextName() + '">';
    if (!wrapForOLI) {
      messageString += this.makeMetaElement(now);
    }
    var semantic = '<semantic_event transaction_id="' + semanticTransactionID + '" name="' + semanticName + '"';
    if (semanticSubType != "") {
      semantic += ' subtype="' + semanticSubType + '"';
    }
    if (aTrigger != undefined && aTrigger != "") {
      semantic += ' trigger="' + aTrigger + '"';
    }
    semantic += "/>";
    messageString += semantic;
    var eventDescriptor = "<event_descriptor>";
    var loggedSAI = sai.toXMLString(true);
    eventDescriptor += loggedSAI;
    eventDescriptor += "</event_descriptor>";
    messageString += eventDescriptor;
    messageString += this.createCustomFields(customFieldNames, customFieldValues);
    messageString += "</tool_message>";
    pointer.ctatdebug("messageString = " + messageString);
    return messageString;
  };
  this.createUIEventToolMessage = function createUIEventToolMessage(sai, uiEventName, uiEventField, wrapForOLI) {
    pointer.ctatdebug("createUIEventToolMessage()");
    var now = new Date;
    var vars = flashVars.getRawFlashVars();
    var messageString = xmlHeader + '<tool_message context_message_id="' + this.getContextName() + '">';
    if (!wrapForOLI) {
      messageString += this.makeMetaElement(now);
    }
    var uiEvent = '<ui_event name="' + uiEventName + '">' + uiEventField + "</ui_event>";
    messageString += uiEvent;
    var eventDescriptor = "<event_descriptor>";
    eventDescriptor += sai.toSerializedString();
    eventDescriptor += "</event_descriptor>";
    messageString += eventDescriptor;
    messageString += this.createCustomFields(customFieldNames, customFieldValues);
    messageString += "</tool_message>";
    pointer.ctatdebug("messageString = " + messageString);
    return messageString;
  };
  this.createTutorMessage = function createTutorMessage(sai, semanticTransactionID, semanticName, evalObj, advice, semanticSubType, aSkillObject, wrapForOLI) {
    pointer.ctatdebug("createTutorMessage()");
    var now = new Date;
    var vars = flashVars.getRawFlashVars();
    var messageString = xmlHeader + '<tutor_message context_message_id="' + this.getContextName() + '">';
    if (!wrapForOLI) {
      messageString += this.makeMetaElement(now);
    }
    var semantic = '<semantic_event transaction_id="' + semanticTransactionID + '" name="' + semanticName + '"';
    if (semanticSubType !== "") {
      semantic += ' subtype="' + semanticSubType + '"';
    }
    semantic += "/>";
    messageString += semantic;
    var eventDescriptor = "<event_descriptor>";
    eventDescriptor += sai.toXMLString(true);
    eventDescriptor += "</event_descriptor>";
    messageString += eventDescriptor;
    var actionEvaluation = "<action_evaluation ";
    if (evalObj.hasClassification()) {
      if (evalObj.getAttributeString() != null) {
        actionEvaluation += evalObj.getAttributeString();
      }
    }
    actionEvaluation += ">" + evalObj.getEvaluation() + "</action_evaluation>";
    messageString += actionEvaluation;
    if (advice != "") {
      messageString += "<tutor_advice>" + advice + "</tutor_advice>";
    }
    if (aSkillObject != null) {
      pointer.ctatdebug("Adding skills to log message ...");
      messageString += aSkillObject.toLogString();
    }
    messageString += this.createCustomFields(customFieldNames, customFieldValues);
    messageString += "</tutor_message>";
    pointer.ctatdebug("messageString = " + messageString);
    return messageString;
  };
  this.createGenericMessage = function createGenericMessage(logMessage, wrapForOLI) {
    pointer.ctatdebug("createGenericMessage()");
    var vars = flashVars.getRawFlashVars();
    var messageString = xmlHeader + '<message context_message_id="' + this.getContextName() + '">';
    messageString += logMessage;
    messageString += "</message>";
    pointer.ctatdebug("messageString = " + messageString);
    return messageString;
  };
  this.makeMetaElement = function makeMetaElement(timeStamp) {
    pointer.ctatdebug("makeMetaElement ()");
    var vars = flashVars.getRawFlashVars();
    var meta = "<meta>";
    meta += "<user_id>" + vars["user_guid"] + "</user_id>";
    meta += "<session_id>" + vars["session_id"] + "</session_id>";
    meta += "<time>" + this.formatTimeStamp(timeStamp) + "</time>";
    meta += "<time_zone>" + flashVars.getTimeZone() + "</time_zone></meta>";
    return meta;
  };
  this.createLogSessionStart = function createLogSessionStart() {
    pointer.ctatdebug("createLogSessionStart ()");
    var now = new Date;
    pointer.ctatdebug("Date: " + now);
    var message = '<log_session_start timezone="' + flashVars.getTimeZone() + '" ';
    var vars = flashVars.getRawFlashVars();
    message += 'date_time="' + CTATLogMessageBuilder.formatTimeStampOLI(now) + '" ';
    message += 'auth_token="' + vars["auth_token"] + '" ';
    message += 'session_id="' + vars["session_id"] + '" ';
    message += 'user_guid="' + vars["user_guid"] + '" ';
    message += 'class_id="" treatment_id="" assignment_id="" info_type="tutor_message.dtd"/>';
    return message;
  };
  this.formatTimeStamp = function formatTimeStamp(stamp) {
    pointer.ctatdebug("formatTimeStamp (" + stamp + ")");
    var s = "";
    var year = stamp.getUTCFullYear();
    s += year + "-";
    var month = stamp.getUTCMonth();
    month++;
    s += (month < 10 ? "0" + month : month) + "-";
    var date = stamp.getUTCDate();
    s += (date < 10 ? "0" + date : date) + " ";
    var hours = stamp.getUTCHours();
    s += (hours < 10 ? "0" + hours : hours) + ":";
    var mins = stamp.getUTCMinutes();
    s += (mins < 10 ? "0" + mins : mins) + ":";
    var secs = stamp.getUTCSeconds();
    s += secs < 10 ? "0" + secs : secs;
    var msec = stamp.getUTCMilliseconds();
    s += ".";
    s += msec;
    return s;
  };
  this.resetCustomFields = function resetCustomFields() {
    pointer.ctatdebug("resetCustomFields ()");
    customFieldNames = new Array;
    customFieldValues = new Array;
  };
  this.createCustomFields = function createCustomFields(aCustomFieldNames, aCustomFieldValues) {
    pointer.ctatdebug("createCustomFields ()");
    if (aCustomFieldNames == null || aCustomFieldValues == null) {
      pointer.ctatdebug("No custom fields provided");
      return "";
    }
    pointer.ctatdebug("Processing " + aCustomFieldNames.length + " custom fields ...");
    var message = "";
    for (var dex = 0;dex < aCustomFieldNames.length;dex++) {
      pointer.ctatdebug("Adding custom field: [" + aCustomFieldNames[dex] + "],[" + aCustomFieldValues[dex] + "]");
      var v = String(aCustomFieldValues[dex]);
      if (/step[-_.]?id/i.test(aCustomFieldNames[dex])) {
        stepID = v;
      }
      v = v.indexOf("<![CDATA[") < 0 ? "<![CDATA[" + v + "]]\x3e" : v;
      message += "<custom_field>";
      message += "<name>" + aCustomFieldNames[dex] + "</name>";
      message += "<value>" + v + "</value>";
      message += "</custom_field>";
    }
    return message;
  };
  this.addCustomFields = function addCustomFields(aCustomFieldNames, aCustomFieldValues) {
    pointer.ctatdebug("addCustomFields () " + (aCustomFieldNames ? aCustomFieldNames.length : "null"));
    if (aCustomFieldNames == undefined) {
      return;
    }
    for (var i = 0;i < aCustomFieldNames.length;i++) {
      customFieldNames.push(aCustomFieldNames[i]);
      customFieldValues.push(aCustomFieldValues[i]);
    }
  };
  this.addCustomField = function addCustomfield(aName, aValue) {
    pointer.ctatdebug("addCustomfield (" + aName + "," + aValue + ")");
    customFieldNames.push(aName);
    customFieldValues.push(aValue);
  };
  this.getCustomFieldNames = function getCustomFieldNames() {
    return customFieldNames;
  };
  this.getCustomFieldValues = function getCustomFieldValues() {
    return customFieldValues;
  };
};
CTATLogMessageBuilder.prototype = Object.create(CTATBase.prototype);
CTATLogMessageBuilder.prototype.constructor = CTATLogMessageBuilder;
CTATLogMessageBuilder.contextGUID = "";
CTATLogMessageBuilder.formatTimeStampOLI = function(stamp) {
  ctatdebug("formatTimeStampOLI (" + stamp + ")");
  var s = "";
  var year = stamp.getUTCFullYear();
  s += year + "/";
  var month = stamp.getUTCMonth();
  month++;
  s += (month < 10 ? "0" + month : month) + "/";
  var date = stamp.getUTCDate();
  s += (date < 10 ? "0" + date : date) + " ";
  var hours = stamp.getUTCHours();
  s += (hours < 10 ? "0" + hours : hours) + ":";
  var mins = stamp.getUTCMinutes();
  s += (mins < 10 ? "0" + mins : mins) + ":";
  var secs = stamp.getUTCSeconds();
  s += secs < 10 ? "0" + secs : secs;
  var msec = stamp.getUTCMilliseconds();
  s += ".";
  s += msec;
  return s;
};
CTATLogMessageBuilder.wrapForOLI = function(messageString) {
  ctatdebug("wrapForOLI ()");
  var now = new Date;
  var xmlProlog = '<?xml version="1.0" encoding="UTF-8"?>';
  var vars = flashVars.getRawFlashVars();
  messageString = encodeURIComponent(messageString);
  var wrapper = xmlProlog + "<log_action ";
  wrapper += 'auth_token="' + encodeURIComponent(vars["auth_token"]) + '" ';
  if (vars["log_session_id"] != undefined && vars["session_id"] != null) {
    wrapper += 'session_id="' + vars["log_session_id"] + '" ';
  } else {
    wrapper += 'session_id="' + vars["session_id"] + '" ';
  }
  wrapper += 'action_id="' + "EVALUATE_QUESTION" + '" ';
  wrapper += 'user_guid="' + vars["user_guid"] + '" ';
  wrapper += 'date_time="' + CTATLogMessageBuilder.formatTimeStampOLI(now) + '" ';
  wrapper += 'timezone="' + flashVars.getTimeZone() + '" ';
  wrapper += 'source_id="' + vars["source_id"] + '" ';
  if (vars["activity_context_guid"]) {
    wrapper += 'external_object_id="' + vars["activity_context_guid"] + '" info_type="tutor_message.dtd">';
  } else {
    wrapper += 'external_object_id="" info_type="tutor_message.dtd">';
  }
  messageString = wrapper + messageString + "</log_action>";
  return messageString;
};
goog.provide("CTATCustomLogElementObject");
CTATCustomLogElementObject = function() {
  var customElementNames = [];
  var customElementTypes = [];
  this.reset = function reset() {
    customElementNames = [];
    customElementTypes = [];
  };
  this.addCustomLogElement = function addCustomLogElement(aKey, aValue) {
    customElementsNames.push(aKey);
    customElementsTypes.push(aKey);
  };
  this.getCustomElementNames = function getCustomElementNames() {
    return customElementsNames;
  };
  this.getCustomElementTypes = function getCustomElementTypes() {
    return customElementsTypes;
  };
};
goog.provide("CTATLoggingLibrary");
goog.require("CTATBase");
goog.require("CTATGlobals");
goog.require("CTATGuid");
goog.require("CTATConfiguration");
goog.require("CTATCommLibrary");
goog.require("CTATLogMessageBuilder");
goog.require("CTATCustomLogElementObject");
goog.require("CTATLanguageManager");
goog.require("CTATLMS");
var loggingDisabled = false;
CTATLoggingLibrary = function(aUseInternal, extCommLogMessageBuilder) {
  CTATBase.call(this, "CTATLoggingLibrary", "logginglibrary");
  var pointer = this;
  var version = "3.Beta";
  var DTDVersion = "4";
  var nameSpace = "xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' xsi:noNamespaceSchemaLocation='http://learnlab.web.cmu.edu/dtd/tutor_message_v4.xsd'";
  var xmlProlog = '<?xml version="1.0" encoding="UTF-8"?>';
  var useSessionLog = true;
  var useInternal = typeof aUseInternal == "undefined" ? true : aUseInternal;
  var externalConfigured = false;
  var useForcedSessionID = "";
  var useVars = [];
  var logclassname = "undefined";
  var school = "undefined";
  var period = "undefined";
  var description = "undefined";
  var instructor = "undefined";
  var problem_name = "undefined";
  var problem_context = "undefined";
  var userid = "undefined";
  var datasetName = "UnassignedDataset";
  var datasetLevelName = "UnassignedLevelName";
  var datasetLevelType = "UnassignedLevelType";
  var logListener = null;
  var lastSAI = null;
  var lmsLogEvent = null;
  userid = CTATGuid.guid();
  var loggingCommLibrary = new CTATCommLibrary;
  loggingCommLibrary.setName("commLoggingLibrary");
  loggingCommLibrary.setUseCommSettings(false);
  loggingCommLibrary.setConnectionRefusedMessage("ERROR_CONN_LS");
  loggingCommLibrary.assignHandler(this);
  loggingCommLibrary.setFixedURL(CTATConfiguration.get("log_service_url"));
  this.extCommLogMessageBuilder = extCommLogMessageBuilder;
  this.getLastSAI = function getLastSAI() {
    return lastSAI;
  };
  this.assignLogListener = function assignLogListener(aListener) {
    logListener = aListener;
  };
  this.generateSession = function generateSession() {
    useVars["session_id"] = "ctat_session_" + CTATGuid.guid();
    return useVars["session_id"];
  };
  this.setLogClassName = function setLogClassName(aValue) {
    logclassname = aValue;
  };
  this.setDatasetName = function setDatasetName(aValue) {
    datasetName = aValue;
  };
  this.setDatasetLevelName = function setdDtasetLevelName(aValue) {
    datasetLevelName = aValue;
  };
  this.setDatasetLevelType = function setDatasetLevelType(aValue) {
    datasetLevelType = aValue;
  };
  this.setSchool = function setSchool(aValue) {
    school = aValue;
  };
  this.setPeriod = function setPeriod(aValue) {
    period = aValue;
  };
  this.setDescription = function setDescription(aValue) {
    description = aValue;
  };
  this.setInstructor = function setInstructor(aValue) {
    instructor = aValue;
  };
  this.setProblemName = function setProblemName(aValue) {
    problem_name = aValue;
  };
  this.setProblemContext = function setProblemContext(aValue) {
    problem_context = aValue;
  };
  this.setUserID = function setUserID(aValue) {
    userid = aValue;
  };
  this.getLoggingCommLibrary = function getLoggingCommLibrary() {
    return loggingCommLibrary;
  };
  this.setUseSessionLog = function setUseSessionLog(aValue) {
    useSessionLog = aValue;
  };
  this.setLoggingURL = function setLoggingURL(aURL) {
    pointer.getLoggingCommLibrary().setFixedURL(aURL);
  };
  this.getSessionIdentifierBundle = function getSessionIdentifierBundle() {
    var aBundle = [];
    aBundle["class_name"] = logclassname;
    aBundle["school_name"] = school;
    aBundle["period_name"] = period;
    aBundle["class_description"] = description;
    aBundle["instructor_name"] = instructor;
    aBundle["dataset_name"] = datasetName;
    aBundle["problem_name"] = problem_name;
    aBundle["problem_context"] = problem_context;
    aBundle["auth_token"] = "";
    aBundle["user_guid"] = userid;
    aBundle["session_id"] = useVars["session_id"];
    aBundle["source_id"] = "tutor";
    aBundle["dataset_level_name1"] = datasetLevelName;
    aBundle["dataset_level_type1"] = datasetLevelType;
    return aBundle;
  };
  this.setupExternalLibraryUsage = function setupExternalLibraryUsage() {
    pointer.ctatdebug("setupExternalLibraryUsage ()");
    useVars["class_name"] = logclassname;
    useVars["school_name"] = school;
    useVars["period_name"] = period;
    useVars["class_description"] = description;
    useVars["instructor_name"] = instructor;
    useVars["dataset_name"] = datasetName;
    useVars["problem_name"] = problem_name;
    useVars["problem_context"] = problem_context;
    useVars["auth_token"] = "";
    useVars["user_guid"] = userid;
    useVars["session_id"] = "ctat_session_" + CTATGuid.guid();
    useVars["source_id"] = "tutor";
    useVars["dataset_level_name1"] = datasetLevelName;
    useVars["dataset_level_type1"] = datasetLevelType;
    flashVars = CTATConfiguration.generateDefaultConfigurationObject();
    flashVars.assignRawFlashVars(useVars);
  };
  this.initCheck = function initCheck() {
    pointer.ctatdebug("initCheck ()");
    if (useInternal == false) {
      if (externalConfigured == false) {
        pointer.setupExternalLibraryUsage();
        externalConfigured = true;
      }
    }
  };
  this.sendMessage = function sendMessage(message, info) {
    pointer.ctatdebug("sendMessage ()");
    pointer.ctatdebug("Raw log message to send (info " + info + "): " + message);
    this.sendMessageInternal(message, info);
    if (logListener != null) {
      logListener(message);
    }
  };
  this.sendMessageInternal = function sendMessageInternal(message, info) {
    pointer.ctatdebug("sendMessageInternal ()");
    if (loggingDisabled === true) {
      pointer.ctatdebug("Warning: loggingDisabled==true");
      return;
    }
    if (useInternal == true) {
      var logging = CTATConfiguration.get("Logging");
      if (logging != "ClientToService" && logging != "ClientToLogServer") {
        pointer.ctatdebug("Logging is turned off, as per: " + logging);
        return;
      }
      var tsc = CTATConfiguration.get("tutoring_service_communication");
      if (logging == "ClientToService" && (tsc == "http" || tsc == "https")) {
        var logURL = CTATConfiguration.get("remoteSocketURL") + ":" + CTATConfiguration.get("remoteSocketPort");
        pointer.setLoggingURL(logURL);
        pointer.ctatdebug("Reconfigured the logging url to be: " + logURL);
      }
      pointer.ctatdebug("Pre encoded log message: " + message);
      var encoded_message = message;
      if (message.indexOf("<log_session_start") < 0) {
        encoded_message = xmlProlog + '<tutor_related_message_sequence version_number="' + DTDVersion + '">' + message + "</tutor_related_message_sequence>";
        encoded_message = CTATLogMessageBuilder.wrapForOLI(encoded_message);
      }
      pointer.ctatdebug("Encoded log message: " + encoded_message);
      lmsLogEvent = CTATLMS.logEvent(encoded_message, message, info);
      if (CTATConfiguration.get("log_service_url")) {
        loggingCommLibrary.sendXMLNoBundle(encoded_message);
      }
    } else {
      pointer.ctatdebug("Use internal: " + useInternal);
    }
  };
  this.startProblem = function startProblem() {
    pointer.ctatdebug("startProblem ()");
    pointer.initCheck();
    pointer.logSessionStart();
    var commLogMessageBuilder = pointer.extCommLogMessageBuilder || new CTATLogMessageBuilder;
    pointer.sendMessage(commLogMessageBuilder.createContextMessage(true), {datashopType:"context"});
  };
  this.logSessionStart = function logSessionStart() {
    pointer.ctatdebug("logSessionStart ()");
    pointer.initCheck();
    var vars = CTATConfiguration.getRawFlashVars();
    if (vars["SessionLog"] != undefined) {
      if (vars["SessionLog"] == "false" || typeof vars["SessionLog"] == "boolean" && vars["SessionLog"] === false) {
        pointer.ctatdebug("Turning SessionLog off ...");
        useSessionLog = false;
      } else {
        pointer.ctatdebug("Turning SessionLog on ...");
        useSessionLog = true;
      }
    }
    if (useSessionLog === true) {
      var commLogMessageBuilder = pointer.extCommLogMessageBuilder || new CTATLogMessageBuilder;
      this.sendMessage(commLogMessageBuilder.createLogSessionStart(), {datashopType:"sessionStart"});
    }
  };
  this.logSemanticEvent = function logSemanticEvent(transactionID, sai, semanticEventName, semanticEventSubtype, aCustomFieldNames, aCustomFieldValues, aTrigger) {
    pointer.ctatdebug("logSemanticEvent (" + aTrigger + ")");
    pointer.initCheck();
    lastSAI = sai;
    var timeStamp = new Date;
    var commLogMessageBuilder = pointer.extCommLogMessageBuilder || new CTATLogMessageBuilder;
    commLogMessageBuilder.resetCustomFields();
    commLogMessageBuilder.addCustomFields(aCustomFieldNames, aCustomFieldValues);
    commLogMessageBuilder.addCustomField("tool_event_time", commLogMessageBuilder.formatTimeStamp(timeStamp) + " UTC");
    var message = commLogMessageBuilder.createSemanticEventToolMessage(sai, transactionID, semanticEventName, semanticEventSubtype, true, aTrigger);
    this.sendMessage(message, {datashopType:"tool", semanticName:semanticEventName, sai:sai});
  };
  this.logTutorResponse = function logTutorResponse(transactionID, sai, semanticName, semanticSubtype, anEval, feedBack, aSkillObject, aCustomFieldNames, aCustomFieldValues) {
    pointer.ctatdebug("logTutorResponse ()");
    pointer.initCheck();
    lastSAI = sai;
    var timeStamp = new Date;
    var commLogMessageBuilder = pointer.extCommLogMessageBuilder || new CTATLogMessageBuilder;
    commLogMessageBuilder.resetCustomFields();
    commLogMessageBuilder.addCustomFields(aCustomFieldNames, aCustomFieldValues);
    commLogMessageBuilder.addCustomField("tutor_event_time", commLogMessageBuilder.formatTimeStamp(timeStamp) + " UTC");
    pointer.ctatdebug("Formatting feedback ...");
    var formattedFeedback = "";
    if (feedBack != undefined && feedBack != null) {
      var preFeedback = CTATGlobals.languageManager.filterString(feedBack);
      formattedFeedback = "<![CDATA[" + preFeedback + "]]\x3e";
    } else {
      pointer.ctatdebug("No feedback provided, using empty string");
      formattedFeedback = "";
    }
    pointer.ctatdebug("Creating tutor message ...");
    var logmsg = commLogMessageBuilder.createTutorMessage(sai, transactionID, semanticName, anEval, formattedFeedback, semanticSubtype, aSkillObject, true);
    this.sendMessage(logmsg, {datashopType:"tutor", semanticName:semanticName, stepID:commLogMessageBuilder.getStepID(), sai:sai, evaluation:anEval && anEval.getEvaluation ? anEval.getEvaluation() : "", tutorAdvice:formattedFeedback});
    return logmsg;
  };
  this.processMessage = function processMessage(aMessage) {
    pointer.ctatdebug("processMessage ()");
    pointer.ctatdebug("Response from log server: " + aMessage);
  };
  this.start = function start() {
    pointer.ctatdebug("start ()");
    var sessionTag = pointer.generateSession();
    pointer.startProblem();
    return sessionTag;
  };
  this.logInterfaceAttempt = function logInterfaceAttempt(aSelection, anAction, anInput, aCustomElementObject) {
    pointer.ctatdebug("logInterfaceAttempt ()");
    var transactionID = CTATGuid.guid();
    var sai = new CTATSAI(aSelection, anAction, anInput);
    sai.setInput(anInput);
    lastSAI = sai;
    this.logSemanticEvent(transactionID, sai, "ATTEMPT", "");
    return transactionID;
  };
  this.logInterfaceAttemptSAI = function logInterfaceAttemptSAI(anSAI, aCustomElementObject) {
    pointer.ctatdebug("logInterfaceAttemptSAI ()");
    lastSAI = anSAI;
    var transactionID = CTATGuid.guid();
    this.logSemanticEvent(transactionID, anSAI, "ATTEMPT", "");
    return transactionID;
  };
  this.logResponse = function logResponse(transactionID, aSelection, anAction, anInput, semanticName, anEvaluation, anAdvice, aCustomElementObject) {
    pointer.ctatdebug("logResponse ()");
    var sai = new CTATSAI(aSelection, anAction, anInput);
    sai.setInput(anInput);
    var evalObj = new CTATActionEvaluationData("");
    evalObj.setEvaluation(anEvaluation);
    if (aCustomElementObject == undefined) {
      this.logTutorResponse(transactionID, sai, semanticName, "", evalObj, anAdvice);
    } else {
      this.logTutorResponse(transactionID, sai, semanticName, "", evalObj, anAdvice, null, aCustomElementObject.getCustomElementNames(), aCustomElementObject.getCustomElementTypes());
    }
  };
  this.logResponseSAI = function logResponseSAI(transactionID, anSAI, semanticName, anEvaluation, anAdvice, aCustomElementObject) {
    pointer.ctatdebug("logResponse ()");
    var evalObj = new CTATActionEvaluationData("");
    evalObj.setEvaluation(anEvaluation);
    if (aCustomElementObject == undefined) {
      this.logTutorResponse(transactionID, anSAI, semanticName, "", evalObj, anAdvice);
    } else {
      this.logTutorResponse(transactionID, anSAI, semanticName, "", evalObj, anAdvice, null, aCustomElementObject.getCustomElementNames(), aCustomElementObject.getCustomElementTypes());
    }
  };
  this.endSession = function endSession() {
    this.generateSession();
  };
  this.then = function(done, fail) {
    var loggers = [];
    if (loggingCommLibrary && typeof loggingCommLibrary.then == "function") {
      loggers.push(loggingCommLibrary);
    }
    if (lmsLogEvent && typeof lmsLogEvent.then == "function") {
      loggers.push(lmsLogEvent);
    }
    return Promise.allSettled(loggers).then(done, fail);
  };
};
CTATLoggingLibrary.prototype = Object.create(CTATBase.prototype);
CTATLoggingLibrary.prototype.constructor = CTATLoggingLibrary;
goog.provide("CTATComponentDescription");
goog.require("CTATBase");
CTATComponentDescription = function() {
  CTATBase.call(this, "CTATComponentDescription", "");
  this.type = "Unknown";
  this.name = "Unknown";
  this.groupName = "Unknown";
  this.x = 0;
  this.y = 0;
  this.width = 0;
  this.height = 0;
  this.zIndex = -1;
  this.tabIndex = -1;
  this.styles = {};
  this.params = {};
  var pointer = this;
  this.componentPointer = null;
  this.setComponentPointer = function setComponentPointer(aPointer) {
    this.componentPointer = aPointer;
  };
  this.getComponentPointer = function getComponentPointer() {
    return this.componentPointer;
  };
  this.setGenericDefaults = function() {
    this.name = "Generic name";
    this.styles = {"BackgroundColor":null, "BorderColor":null, "FontName":null, "FontSize":null, "FontColor":null, "FontBold":null, "FontItalic":false, "FontUnderlined":false, "TextAlign":null, "ShowHintHighlight":false, "blockOnCorrect":false, "disabledBackgroundColor":"#999999", "disabledTextColor":"#999999", "tutorComponent":null};
    return this;
  };
};
CTATComponentDescription.prototype = Object.create(CTATBase.prototype);
CTATComponentDescription.prototype.constructor = CTATComponentDescription;
goog.provide("CTATShellTools");
goog.require("CTATBase");
goog.require("CTATGlobalFunctions");
goog.require("CTATGlobals");
CTATShellTools = {ctat_base:new CTATBase("CTATShellTools", "shelltools"), component_descriptions:{}, registerComponentDescription:function(aDesc) {
  CTATShellTools.ctat_base.ctatdebug("registerComponentDescription (" + aDesc.name + "," + aDesc.type + ")");
  CTATShellTools.component_descriptions[aDesc.name] = aDesc;
}, listComponents:function() {
  CTATShellTools.ctat_base.ctatdebug("listComponents ()");
  var components = CTATShellTools.component_descriptions;
  for (var key in components) {
    var ref = components[key];
    CTATShellTools.ctat_base.ctatdebug("Obtaining component for " + ref.name + " with type: " + ref.type);
    var component = ref.getComponentPointer();
    if (component !== null) {
      CTATShellTools.ctat_base.ctatdebug("Component: " + component.getName() + " of instance: " + component.getClassName());
    } else {
      CTATShellTools.ctat_base.ctatdebug("Error: component pointer is null");
    }
  }
}, feedback_components:[], registerFeedbackComponent:function(aComponent, next_callback, previous_callback, showHints_callback, showFeedback_callback) {
  CTATShellTools.feedback_components.push({component:aComponent, next:next_callback, prev:previous_callback, showHints:showHints_callback, showFeedback:showFeedback_callback});
}, showNextHint:function() {
  CTATShellTools.feedback_components.forEach(function(fbc) {
    if (fbc.next) {
      fbc.next.bind(fbc.component)();
    }
  });
}, showPrevHint:function() {
  CTATShellTools.feedback_components.forEach(function(fbc) {
    if (fbc.prev) {
      fbc.prev.bind(fbc.component)();
    }
  });
}, showFeedback:function(feedback) {
  if (CTATShellTools.feedback_components.length == 0) {
    CTATScrim.scrim.OKScrimUp(feedback, null);
    return;
  }
  CTATShellTools.feedback_components.forEach(function(fbc) {
    if (fbc.showFeedback) {
      fbc.showFeedback.bind(fbc.component)(feedback);
    }
  });
}, showHints:function(hints) {
  CTATShellTools.feedback_components.forEach(function(fbc) {
    if (fbc.showHints) {
      fbc.showHints.bind(fbc.component)(hints);
    }
  });
}, getCurrentMs:function() {
  var now = new Date;
  return now.valueOf();
}, getAllComponents:function() {
  var result = [];
  $(".CTATComponent").each(function() {
    result.push($(this).data("CTATComponent"));
  });
  return result;
}, getNameFromGroup:function(nameLabelPair) {
  CTATShellTools.ctat_base.ctatdebug("getNameFromGroup (" + nameLabelPair + ")");
  var pair = nameLabelPair.split(" ");
  if (pair.length == 1) {
    return nameLabelPair;
  }
  return pair[0].substring(0, pair[0].length - 1);
}, findComponent:function(aName) {
  var pointer = CTATShellTools.ctat_base;
  var components = CTATShellTools.component_descriptions;
  var groupArray = [];
  var jqn = null;
  CTATShellTools.ctat_base.ctatdebug("findComponent(" + aName + ")");
  if (!aName) {
    return [];
  }
  var queriesToTry = ['div[data-ctat-component]:has(input[name="' + aName + '"])', aName.toLowerCase() == "done" ? ".CTATDoneButton" : "", aName.toLowerCase() == "hint" || aName.toLowerCase() == "help" ? ".CTATHintButton" : ""];
  jqn = $('[id="' + aName + '"]');
  for (var i$9 = 0;jqn.length === 0 && i$9 < queriesToTry.length;i$9++) {
    jqn = $(queriesToTry[i$9]);
  }
  if (jqn.length > 0) {
    jqn.each(function() {
      if ($(this).data("CTATComponent")) {
        groupArray.push($(this).data("CTATComponent"));
      }
    });
    if (groupArray.length > 0) {
      return groupArray;
    }
  }
  CTATShellTools.ctat_base.ctatdebug("JQuery couldn't find the component, let's try our internal list ...");
  for (var i in components) {
    var aDesc = components[i];
    if (!aDesc || !aDesc.name || !aDesc.getComponentPointer()) {
      CTATShellTools.ctat_base.ctatdebug("Internal error parsing component at index " + i + (aDesc ? !aDesc.name ? "(no name attribute)" : "(no component pointer)" : ""));
      return null;
    }
    CTATShellTools.ctat_base.ctatdebug("Comparing " + aDesc.name + " to: " + aName);
    if (aDesc.name == aName) {
      CTATShellTools.ctat_base.ctatdebug("Found a component description for [" + aDesc.name + "], returning pointer (" + aDesc.getComponentPointer() + ") ...");
      groupArray.push(aDesc.getComponentPointer());
      return groupArray;
    }
    if (aDesc.groupName == aName) {
      CTATShellTools.ctat_base.ctatdebug("Found the component group (" + aDesc.groupName + "), adding component instance for " + aDesc.name + " ...");
      groupArray.push(aDesc.getComponentPointer());
    }
  }
  if (groupArray.length === 0) {
    CTATShellTools.ctat_base.ctatdebug("Info (groupArray.length==0), no appropriate component found, perhaps this is a group component");
    if (aName.indexOf(".") != -1) {
      var gsplitter = aName.split(".");
      return this.findComponent(gsplitter[0]);
    }
  }
  return groupArray;
}, findComponentInstance:function(aName, aCompName) {
  var result = CTATShellTools.findComponent(aName, aCompName);
  if (result.length == 1) {
    return result[0];
  }
  return result;
}, findComponentByClass:function findComponentByClass(aClass) {
  var pointer = CTATShellTools.ctat_base;
  var components = CTATShellTools.component_descriptions;
  for (var i in components) {
    var aDesc = components[i];
    if (aDesc === null) {
      return null;
    }
    if (aDesc.getComponentPointer() !== null) {
      if (aDesc.getComponentPointer().getClassName() == aClass) {
        return aDesc.getComponentPointer();
      }
    }
  }
  var jqnode = $("." + aClass);
  if (jqnode.length > 0) {
    return jqnode.first().data("CTATComponent");
  }
  return null;
}};
goog.provide("CTATTutoringServiceMessageBuilder");
goog.require("CTATBase");
goog.require("CTATGlobalFunctions");
goog.require("CTATGlobals");
goog.require("CTATJSON");
goog.require("CTATMessage");
goog.require("CTATSkillSet");
goog.require("CTATXML");
CTATTutoringServiceMessageBuilder = function() {
  CTATBase.call(this, "CTATTutoringServiceMessageBuilder", "__undefined__");
  var xmlHeader = "";
  this.createStartProblemMessage = function createStartProblemMessage(problemName) {
    this.ctatdebug("createStartProblemMessage ()");
    return xmlHeader + "<message><verb>NotePropertySet</verb><properties><MessageType>StartProblem</MessageType><ProblemName>" + problemName + "</ProblemName></properties></message>";
  };
  this.createInterfaceIdentificationMessage = function createInterfaceIdentificationMessage(anID) {
    this.ctatdebug("createInterfaceIdentificationMessage (" + anID + ")");
    return xmlHeader + "<message><verb>NotePropertySet</verb><properties><MessageType>InterfaceIdentification</MessageType><Guid>" + anID + "</Guid></properties></message>";
  };
  this.createInterfaceDescriptionMessage = function createInterfaceDescriptionMessage(aComponent) {
    this.ctatdebug("createInterfaceDescriptionMessage ()");
    message = "<message><verb>NotePropertySet</verb><properties><MessageType>InterfaceDescription</MessageType>";
    message += "<WidgetType>" + aComponent.getClassName() + "</WidgetType>";
    message += "<CommName>" + aComponent.getName() + "</CommName>";
    message += "<UpdateEachCycle>false</UpdateEachCycle>";
    message += "<serialized>";
    message += "<" + aComponent.getClassName() + ' name="' + aComponent.getName() + '" x="0" y="0" width="50" height="30" scaleX="1" scaleY="1" originalWidth="50" originalHeight="30" zIndex="-1" tabIndex="-1">';
    message += "<Parameters><selection>";
    if (aComponent.getClassName() == "CTATRadioButton" || aComponent.getClassName() == "CTATCheckBox") {
      message += "<CTATComponentParameter>";
      message += "<name>group</name>";
      message += '<value fmt="text" name="Group Name" type="String" includein="sparse">' + aComponent.getComponentGroup() + "</value>";
      message += "</CTATComponentParameter>";
    }
    message += "</selection></Parameters>";
    message += "</" + aComponent.getClassName() + ">";
    message += "</serialized>";
    message += "</properties></message>";
    return message;
  };
  this.createSetPreferencesMessage = function createSetPreferencesMessage(versionNum, interfaceDescs) {
    this.ctatdebug("createSetPreferencesMessage ()");
    var vars = CTATConfiguration.getRawFlashVars();
    var message = "<message><verb>NotePropertySet</verb><properties><MessageType>SetPreferences</MessageType>";
    message += "<log_service_url>" + vars["log_service_url"] + "</log_service_url>";
    var logRemote = false;
    var logDisk = false;
    var logMethod = vars["Logging"];
    this.ctatdebug("Parsing and processing logMethod: " + logMethod);
    switch(logMethod) {
      case "ServiceToLogServer":
        logRemote = true;
        break;
      case "ServiceToDisk":
        logDisk = true;
        break;
      case "ServiceToDiskAndLogServer":
        logRemote = true;
        logDisk = true;
        break;
      case "ClientToLogServer":
        logRemote = false;
        logDisk = false;
        break;
      case "ClientToService":
        logRemote = true;
        logDisk = true;
        break;
      default:
        break;
    }
    message += "<log_to_remote_server>" + logRemote + "</log_to_remote_server><log_to_disk>" + logDisk + "</log_to_disk>";
    message += "<log_to_disk_directory>" + vars["log_to_disk_directory"] + "</log_to_disk_directory>";
    message += "<logging>" + vars["Logging"] + "</logging>";
    message += "<user_guid>" + vars["user_guid"] + "</user_guid>";
    message += "<problem_name>" + vars["problem_name"] + "</problem_name>";
    message += "<question_file><![CDATA[" + vars["question_file"] + "]]\x3e</question_file>";
    message += "<class_name>" + vars["class_name"] + "</class_name>";
    message += "<school_name>" + vars["school_name"] + "</school_name>";
    message += "<instructor_name>" + vars["instructor_name"] + "</instructor_name>";
    message += "<session_id>" + vars["session_id"] + "</session_id>";
    message += "<source_id>" + vars["source_id"] + "</source_id>";
    message += "<sui><![CDATA[" + vars["sui"] + "]]\x3e</sui>";
    message += "<problem_state_status>" + vars["problem_state_status"] + "</problem_state_status>";
    message += "<curriculum_service_url>" + vars["curriculum_service_url"] + "</curriculum_service_url>";
    message += "<restore_problem_url>" + vars["restore_problem_url"] + "</restore_problem_url>";
    message += "<tutoring_service_communication>" + vars["tutoring_service_communication"] + "</tutoring_service_communication>";
    message += "<mode>" + vars["mode"] + "</mode>";
    message += "<collaborators>" + vars["collaborators"] + "</collaborators>";
    if (CTATSkillSet.skills !== null) {
      message += CTATSkillSet.skills.toSetPreferencesXMLString();
    }
    message += "<CommShellVersion>" + versionNum + "</CommShellVersion>";
    if (interfaceDescs) {
      message += interfaceDescs;
    }
    message += "</properties></message>";
    return xmlHeader + message;
  };
  this.createTracerActionMessage = function createTracerActionMessage(transactionID, sai) {
    this.ctatdebug("createTracerActionMessage ()");
    var message = "<message><verb>NotePropertySet</verb><properties><MessageType>TracerAction</MessageType>";
    message += "<transaction_id>" + transactionID + "</transaction_id>";
    message += sai.toXMLString(false);
    message += "</properties></message>";
    return xmlHeader + message;
  };
  this.createInterfaceActionMessage = function createInterfaceActionMessage(transactionID, sai) {
    this.ctatdebug("createInterfaceActionMessage ()");
    var message = "<message><verb>NotePropertySet</verb><properties><MessageType>InterfaceAction</MessageType>";
    message += "<transaction_id>" + transactionID + "</transaction_id>";
    message += sai.toXMLString(false);
    message += "</properties></message>";
    return xmlHeader + message;
  };
  this.createUntutoredActionMessage = function createUntutoredActionMessage(transactionID, sai) {
    this.ctatdebug("createUntutoredActionMessage (" + transactionID + ")");
    var message = "<message><verb>NotePropertySet</verb><properties><MessageType>UntutoredAction</MessageType>";
    message += "<transaction_id>" + transactionID + "</transaction_id>";
    message += sai.toXMLString(false);
    message += "</properties></message>";
    return xmlHeader + message;
  };
  this.createProblemSummaryRequestMessage = function createProblemSummaryRequestMessage() {
    var message = "<message><verb>NotePropertySet</verb><properties><MessageType>ProblemSummaryRequest</MessageType></properties></message>";
    return xmlHeader + message;
  };
  this.createProblemRestoreEndMessage = function createProblemRestoreEndMessage() {
    var message = "<message><verb>NotePropertySet</verb><properties><MessageType>ProblemRestoreEnd</MessageType></properties></message>";
    return xmlHeader + message;
  };
  this.createInterfaceConfigurationEnd = function() {
    var message = "<message><verb>NotePropertySet</verb><properties><MessageType>InterfaceConfigurationEnd</MessageType></properties></message>";
    return xmlHeader + message;
  };
  this.createInCorrectActionMessage = function createInCorrectActionMessage(transactionID, sai) {
    this.ctatdebug("createInCorrectActionMessage ()");
    var message = "<message><verb>SendNoteProperty</verb><properties><MessageType>InCorrectAction</MessageType>";
    message += "<transaction_id>" + transactionID + "</transaction_id>";
    message += sai.toXMLString(false);
    message += "</properties></message>";
    return xmlHeader + message;
  };
  this.createURLResponse = function createURLResponse(aURL, aData) {
    CTATGlobal.debug(classType, "createURLResponse ()");
    return xmlHeader + "<message><verb>NotePropertySet</verb><properties><MessageType>GetURLResponse</MessageType><URL><![CDATA[ " + aURL + " ]]\x3e</URL><content><![CDATA[ " + btoa(aData) + " ]]\x3e</content></properties></message>";
  };
  this.createCorrectActionMessage = function createCorrectActionMessage(transactionID, sai) {
    this.ctatdebug("createCorrectActionMessage ()");
    var message = "<message><verb>SendNoteProperty</verb><properties><MessageType>CorrectAction</MessageType>";
    message += "<transaction_id>" + transactionID + "</transaction_id>";
    message += sai.toXMLString(false);
    message += "</properties></message>";
    return xmlHeader + message;
  };
};
CTATTutoringServiceMessageBuilder.prototype = Object.create(CTATBase.prototype);
CTATTutoringServiceMessageBuilder.prototype.constructor = CTATTutoringServiceMessageBuilder;
goog.provide("CTATMessageHandler");
goog.require("CTATBase");
goog.require("CTATComponentDescription");
goog.require("CTATConfig");
goog.require("CTATGlobals");
goog.require("CTATHTMLManager");
goog.require("CTATJSON");
goog.require("CTATLMS");
goog.require("CTATMessage");
goog.require("CTATSAI");
goog.require("CTATShellTools");
goog.require("CTATSkillSet");
goog.require("CTATXML");
goog.require("CTATTutoringServiceMessageBuilder");
CTATMessageHandler = function(commShell) {
  CTATBase.call(this, "CTATMessageHandler", "messagehandler");
  var messageHandler = null;
  var pointer = this;
  var startStateMessages = [];
  var messageParser = null;
  var nInterfaceReboots = 0;
  if (CTATConfig.parserType_is_XML()) {
    messageParser = new CTATXML;
  } else {
    messageParser = new CTATJSON;
  }
  this.assignHandler = function assignHandler(aHandler) {
    pointer.ctatdebug("assignHandler ()");
    messageHandler = aHandler;
  };
  this.reset = function reset() {
    pointer.ctatdebug("reset ()");
    startStateMessages = [];
  };
  this.getInStartState = function getInStartState() {
    return CTATMessageHandler.inStartState;
  };
  var disableComms = false;
  this.receiveFromTutor = function receiveFromTutor(aMessage) {
    this.processMessage(aMessage);
  };
  this.processMessage = function processMessage(aMessage) {
    pointer.ctatdebug("Incoming message: " + aMessage);
    if (disableComms === true) {
      return;
    }
    if (CTATConfig.parserType_is_JSON()) {
      if (aMessage.indexOf("<?xml") != -1) {
        alert("Error: CTAT is configured to parse JSON but it received an XML message, disabling comm capabilities ...");
        disableComms = true;
        return;
      }
    }
    if (CTATConfig.parserType_is_XML()) {
      if (aMessage.indexOf("{") === 0) {
        alert("Error: CTAT is configured to parse XML but it received a JSON message, disabling comm capabilities ...");
        disableComms = true;
        return;
      }
    }
    var docRoot = null;
    pointer.ctatdebug("Attempting parse ...");
    docRoot = messageParser.parse(aMessage);
    if (docRoot === null) {
      pointer.ctatdebug("Error parsing message: " + aMessage);
      return;
    }
    this.parseElement(docRoot, aMessage);
  };
  this.parseElement = function parseElement(anElement, aMessage) {
    var aName = messageParser.getElementName(anElement);
    pointer.ctatdebug("parseElement (" + aName + ")");
    if (aName == "CTATResponseMessages" || aName == "StartStateMessages" || aName == "MessageBundle") {
      this.processMessageBundle(anElement);
    }
    if (aName == "message") {
      this.processSingleMessage(anElement, aMessage);
    }
  };
  this.processMessageBundle = function processMessageBundle(anElement, aMessage) {
    var aName = messageParser.getElementName(anElement);
    pointer.ctatdebug("processMessageBundle (" + aName + ")");
    var list = messageParser.getElementChildren(anElement);
    if (list === null) {
      pointer.ctatdebug("Error parsing bundle");
      return;
    }
    ctatdebug("Processing " + list.length + " objects in bundle");
    for (var i = 0;i < list.length;i++) {
      this.parseElement(list[i]);
    }
  };
  this.processSingleMessage = function processSingleMessage(anElement, aMessage) {
    pointer.ctatdebug("processSingleMessage (" + messageParser.getElementName(anElement) + ")");
    commShell.sendToTools(aMessage);
    var aMessage = new CTATMessage(anElement);
    var actor = aMessage.getProperty("subtype");
    actor = !actor || /tutor/i.test(actor) ? "tutor" : actor;
    if (messageHandler["updateLastActionTimestamp"]) {
      messageHandler.updateLastActionTimestamp();
    }
    var x = messageParser.getElementChildren(anElement);
    pointer.ctatdebug("Generated CTATMessage, now doing regular processing ...");
    for (var i = 0;i < x.length;i++) {
      var tempElement = x[i];
      if (messageParser.getElementName(tempElement) == "properties") {
        pointer.ctatdebug("Parsing properties ...");
        var messageProperties = messageParser.getElementChildren(tempElement);
        for (var t = 0;t < messageProperties.length;t++) {
          var propNode = messageProperties[t];
          if (messageParser.getElementName(propNode) == "MessageType") {
            var nodeValue = messageParser.getNodeTextValue(propNode);
            pointer.ctatdebug("MessageType: " + nodeValue);
            switch(nodeValue) {
              case "StateGraph":
                ctatdebug("Setting inStartState to true");
                CTATMessageHandler.inStartState = true;
                commShell.setGotProblemRestoreEnd(false);
                this.processStateGraph(tempElement);
                commShell.propagateShellEvent("StateGraph", aMessage);
                break;
              case "StartProblem":
                pointer.ctatdebug("Setting inStartState to true");
                CTATMessageHandler.inStartState = true;
                commShell.setGotProblemRestoreEnd(false);
                this.processStartProblem(messageProperties);
                commShell.propagateShellEvent("StartProblem", aMessage);
                break;
              case "InterfaceIdentification":
                this.processInterfaceIdentification(messageProperties);
                commShell.propagateShellEvent("InterfaceIdentification", aMessage);
                break;
              case "InterfaceDescription":
                this.processInterfaceDescription(messageProperties);
                commShell.propagateShellEvent("InterfaceDescription", aMessage);
                break;
              case "GetAllInterfaceDescriptions":
                commShell.sendInterfaceDescriptionMessages();
                commShell.propagateShellEvent("GetAllInterfaceDescriptions", aMessage);
                break;
              case "SendWidgetLock":
                pointer.ctatdebug("Found: SendWidgetLock");
                if (this.getInStartState() === true) {
                  startStateMessages.push(aMessage);
                }
                commShell.propagateShellEvent("SendWidgetLock", aMessage);
                break;
              case "CorrectAction":
                pointer.ctatdebug("Found: CorrectAction");
                if (this.getInStartState() === true) {
                  startStateMessages.push(aMessage);
                } else {
                  messageHandler.processCorrectAction(aMessage);
                }
                commShell.propagateShellEvent("CorrectAction", aMessage);
                break;
              case "InCorrectAction":
                pointer.ctatdebug("Found: InCorrectAction");
                if (CTATMessageHandler.inStartState === true) {
                  startStateMessages.push(aMessage);
                } else {
                  pointer.ctatdebug("Handing incorrect message to messagehandler ...");
                  messageHandler.processInCorrectAction(aMessage);
                }
                commShell.propagateShellEvent("InCorrectAction", aMessage);
                break;
              case "HighlightMsg":
                pointer.ctatdebug("Found: HighlightMsg");
                messageHandler.processHighlightMsg(aMessage);
                commShell.propagateShellEvent("HighlightMsg", aMessage);
                break;
              case "UnHighlightMsg":
                pointer.ctatdebug("Found: UnHighlightMsg");
                messageHandler.processUnHighlightMsg(aMessage);
                commShell.propagateShellEvent("UnHighlightMsg", aMessage);
                break;
              case "AssociatedRules":
                pointer.ctatdebug("Found: AssociatedRules (" + messageProperties.length + ")");
                var advice = "";
                var indicator = "";
                var stepID = "";
                var logAsResult = "";
                var toolSelection = "";
                for (var k = 0;k < messageProperties.length;k++) {
                  var testNode = messageProperties[k];
                  var testNodeName = messageParser.getElementName(testNode);
                  switch(testNodeName) {
                    case "TutorAdvice":
                      advice = messageParser.getNodeTextValue(testNode);
                      break;
                    case "Actor":
                      actor = messageParser.getNodeTextValue(testNode);
                      break;
                    case "Indicator":
                      indicator = messageParser.getNodeTextValue(testNode);
                      break;
                    case "StepID":
                      stepID = messageParser.getNodeTextValue(testNode);
                      break;
                    case "LogAsResult":
                      logAsResult = messageParser.getNodeTextValue(testNode);
                      break;
                    case "tool_selection":
                    ;
                    case "StudentSelection":
                      toolSelection = messageParser.getNodeTextValue(testNode);
                      break;
                    case "Skills":
                      pointer.ctatdebug("Processing skills ...");
                      if (CTATSkillSet.skills === null) {
                        pointer.ctatdebug("Interesting, there isn't a skillSet object yet. Creating ...");
                        CTATSkillSet.skills = new CTATSkillSet;
                      }
                      CTATSkillSet.skills.parseByValue(testNode);
                      break;
                  }
                }
                var logmsg = messageHandler.processAssociatedRules(aMessage, indicator, advice, toolSelection);
                commShell.propagateShellEvent("AssociatedRules", aMessage, actor);
                break;
              case "BuggyMessage":
                pointer.ctatdebug("Found: BuggyMessage");
                messageHandler.processBuggyMessage(aMessage);
                commShell.propagateShellEvent("BuggyMessage", aMessage);
                break;
              case "SuccessMessage":
                pointer.ctatdebug("Found: SuccessMessage");
                messageHandler.processSuccessMessage(aMessage);
                commShell.propagateShellEvent("SuccessMessage", aMessage);
                break;
              case "InterfaceAction":
                pointer.ctatdebug("Found: InterfaceAction");
                var testSAI = aMessage.getSAI();
                if (testSAI.getAction().indexOf(":") != -1) {
                  pointer.ctatdebug("Processing and storing timed interface action : " + testSAI.getAction());
                  var targetTime = parseInt(testSAI.getAction().substring(testSAI.getAction().indexOf(":") + 1));
                  pointer.ctatdebug("Target time: " + targetTime);
                  testSAI.setAction(testSAI.getAction().substring(0, testSAI.getAction().indexOf(":")));
                  pointer.ctatdebug("Timing ...");
                  setTimeout(messageHandler.processInterfaceAction, targetTime, aMessage);
                  setTimeout(commShell.propagateShellEvent, targetTime, "InterfaceAction", aMessage, actor);
                } else {
                  pointer.ctatdebug("Processing regular (non-timed) interface action");
                  if (CTATMessageHandler.inStartState === true) {
                    pointer.ctatdebug("inStartState==true => storing for later playback ...");
                    startStateMessages.push(aMessage);
                  } else {
                    messageHandler.processInterfaceAction(aMessage);
                    commShell.propagateShellEvent("InterfaceAction", aMessage, actor);
                  }
                }
                break;
              case "UntutoredAction":
                pointer.ctatdebug("Found: UntutoredAction");
                var testSAI = aMessage.getSAI();
                if (testSAI.getAction().indexOf(":") != -1) {
                  pointer.ctatdebug("Processing and storing timed interface action : " + testSAI.getAction());
                  var targetTime = parseInt(testSAI.getAction().substring(testSAI.getAction().indexOf(":") + 1));
                  pointer.ctatdebug("Target time: " + targetTime);
                  testSAI.setAction(testSAI.getAction().substring(0, testSAI.getAction().indexOf(":")));
                  pointer.ctatdebug("Timing ...");
                  setTimeout(messageHandler.processUntutoredAction, targetTime, aMessage);
                  setTimeout(commShell.propagateShellEvent, targetTime, "UntutoredAction", aMessage, actor);
                } else {
                  pointer.ctatdebug("Processing regular (non-timed) interface action");
                  if (CTATMessageHandler.inStartState === true) {
                    pointer.ctatdebug("inStartState==true => storing for later playback ...");
                    startStateMessages.push(aMessage);
                  } else {
                    messageHandler.processUntutoredAction(aMessage);
                    commShell.propagateShellEvent("UntutoredAction", aMessage, actor);
                  }
                }
                break;
              case "InterfaceIdentification":
                pointer.ctatdebug("Found: InterfaceIdentification");
                commShell.propagateShellEvent("InterfaceIdentification", aMessage);
                break;
              case "AuthorModeChange":
                pointer.ctatdebug("Found: AuthorModeChange");
                messageHandler.globalReset();
                commShell.propagateShellEvent("AuthorModeChange", aMessage);
                break;
              case "ResetAction":
                pointer.ctatdebug("Found: ResetAction");
                messageHandler.globalReset();
                commShell.propagateShellEvent("ResetAction", aMessage);
                break;
              case "ShowHintsMessage":
                pointer.ctatdebug("Found: ShowHintsMessage");
                var hintComplete = false;
                var hintArray = [];
                for (var p = 0;p < messageProperties.length;p++) {
                  var pNode = messageProperties[p];
                  if (messageParser.getElementName(pNode) == "HintsMessage") {
                    var aList = messageParser.getElementChildren(pNode);
                    for (var w = 0;w < aList.length;w++) {
                      var hintNode = aList[w];
                      if (messageParser.getElementName(hintNode) == "value") {
                        hintArray.push(messageParser.getNodeTextValue(hintNode));
                        hintComplete = true;
                      }
                    }
                  }
                }
                if (hintComplete === true) {
                  messageHandler.processHintResponse(aMessage, hintArray);
                } else {
                  pointer.ctatdebug("Error: incomplete hint message received");
                }
                commShell.propagateShellEvent("ShowHintsMessage", aMessage);
                break;
              case "ConfirmDone":
                pointer.ctatdebug("Found: ConfirmDone");
                messageHandler.processConfirmDone(aMessage);
                commShell.propagateShellEvent("ConfirmDone", aMessage);
                break;
              case "VersionInfo":
                pointer.ctatdebug("Found: VersionInfo");
                messageHandler.processVersionInfo(messageProperties);
                commShell.propagateShellEvent("VersionInfo", aMessage);
                break;
              case "TutoringServiceAlert":
                pointer.ctatdebug("Found: TutoringServiceAlert");
                messageHandler.processTutoringServiceAlert(messageProperties);
                commShell.propagateShellEvent("TutoringServiceAlert", aMessage);
                break;
              case "TutoringServiceError":
                var action = aMessage.getProperty("Action");
                pointer.ctatdebug("Found: TutoringServiceError - actor " + actor + ", action " + action);
                var aParsed;
                if (action && (aParsed = CTATSAI.delayedActionRegExp.exec(action)) && aParsed.length > 2 && aParsed[2] > 1) {
                  var targetTime = parseInt(aParsed[2]);
                  aMessage.setProperty("Action", aParsed[1]);
                  pointer.ctatdebug("Delaying TutoringServiceError by " + targetTime + " ...");
                  setTimeout(messageHandler.processTutoringServiceError, targetTime, aMessage);
                  setTimeout(commShell.propagateShellEvent, targetTime, "TutoringServiceError", aMessage, actor);
                } else {
                  messageHandler.processTutoringServiceError(aMessage);
                  commShell.propagateShellEvent("TutoringServiceError", aMessage, actor);
                }
                break;
              case "ProblemSummaryResponse":
                pointer.ctatdebug("Found: ProblemSummaryResponse");
                messageHandler.processProblemSummaryResponse(aMessage);
                commShell.propagateShellEvent("ProblemSummaryResponse", aMessage);
                break;
              case "StartStateEnd":
                pointer.ctatdebug("Found: StartStateEnd");
                CTATShellTools.listComponents();
                if (messageHandler !== null) {
                  messageHandler.processStartState();
                } else {
                  this.ctatdebug("Error: no message handler object available to process start state");
                }
                try {
                  pointer.processStartStateActions();
                } catch (err) {
                  pointer.ctatdebug("Caught in the act: " + err.message);
                }
                CTATMessageHandler.inStartState = false;
                commShell.propagateShellEvent("StartStateEnd", aMessage);
                break;
              case "ProblemRestoreEnd":
                pointer.ctatdebug("Found: ProblemRestoreEnd");
                messageHandler.processProblemRestoreEnd(aMessage);
                commShell.propagateShellEvent("ProblemRestoreEnd", aMessage);
                break;
              case "GetURL":
                pointer.ctatdebug("Found: GetURL");
                messageHandler.processGetURL(aMessage);
                commShell.propagateShellEvent("GetURL", aMessage);
                break;
              case "SetPreferences":
                messageHandler.forwardToTutor(aMessage);
                return;
                break;
              case "InterfaceReboot":
                nInterfaceReboots++;
                ctatdebug("Found: InterfaceReboot #" + nInterfaceReboots + " -- href " + (location ? location.href : "(no location)"));
                if (nInterfaceReboots > 1) {
                  if (!CTAT.ToolTutor.reboot("InterfaceReboot from CTATMessageHandler")) {
                    var url = "ws://" + CTATConfiguration.get("remoteSocketURL") + ":" + CTATConfiguration.get("remoteSocketPort");
                    ctatdebug("closing connection w/ url: " + url);
                    commShell.closeWSConnection(url, function() {
                      var myId = window.frameElement.getAttribute("id");
                      if (typeof CustomEvent == "function") {
                        var refreshEvent = new CustomEvent("refreshIframe", {"detail":myId});
                        window.parent.document.dispatchEvent(refreshEvent);
                      }
                    }, "interfaceReboot");
                  }
                }
                break;
              case "NoOp":
                var transactionID = aMessage && aMessage.getTransactionID();
                var sai = aMessage && aMessage.getSAI();
                ctatdebug("NoOp transactionID " + transactionID + ", SAI " + sai);
                return;
            }
            var collaborator = /student[0-9]+/i.exec(actor);
            if (collaborator && collaborator[0] == actor) {
              messageHandler.forwardToTutor(aMessage);
            }
          }
        }
      }
    }
  };
  this.processStateGraph = function processStateGraph(aPropertyList) {
    pointer.ctatdebug("processStateGraph ()");
    if (aPropertyList === undefined || aPropertyList === null) {
      pointer.ctatdebug("Error: state graph property list is undefined");
      return;
    }
    pointer.ctatdebug("Processing node: " + aPropertyList.nodeName);
    if (messageParser.getElementChildren(aPropertyList) === null) {
      pointer.ctatdebug("Error: state graph property list is undefined");
      return;
    }
    var messageProperties = messageParser.getElementChildren(aPropertyList);
    for (var t = 0;t < messageProperties.length;t++) {
      var propNode = messageProperties[t];
      pointer.ctatdebug("State graph attribute: " + messageParser.getElementName(propNode));
      if (messageParser.getElementName(propNode) == "caseInsensitive") {
        if (messageParser.getNodeTextValue(propNode) == "false") {
          caseInsensitive = false;
        } else {
          caseInsensitive = true;
        }
      }
      if (messageParser.getElementName(propNode) == "unordered") {
        if (messageParser.getNodeTextValue(propNode) == "false") {
          unordered = false;
        } else {
          unordered = true;
        }
      }
      if (messageParser.getElementName(propNode) == "lockWidget") {
        if (messageParser.getNodeTextValue(propNode) == "false") {
          lockWidget = false;
        } else {
          lockWidget = true;
        }
      }
      if (messageParser.getElementName(propNode) == "suppressStudentFeedback") {
        if (messageParser.getNodeTextValue(propNode) == "false") {
          CTATGlobals.suppressStudentFeedback = false;
        } else {
          CTATGlobals.suppressStudentFeedback = true;
        }
      }
      if (messageParser.getElementName(propNode) == "highlightRightSelection") {
        if (messageParser.getNodeTextValue(propNode) == "false") {
          highlightRightSelection = false;
        } else {
          highlightRightSelection = true;
        }
      }
      if (messageParser.getElementName(propNode) == "confirmDone") {
        pointer.ctatdebug("Confirm done: " + messageParser.getNodeTextValue(propNode));
        if (messageParser.getNodeTextValue(propNode) == "true") {
          CTATGlobals.confirmDone = true;
        } else {
          CTATGlobals.confirmDone = false;
        }
      }
      if (messageParser.getElementName(propNode) == "Skills") {
        if (CTATSkillSet.skills === null) {
          CTATSkillSet.skills = new CTATSkillSet;
        }
        CTATSkillSet.skills.parseByValue(propNode);
        messageHandler.updateSkillWindow();
      }
    }
  };
  this.processStartProblem = function processStartProblem(aPropertyList) {
    pointer.ctatdebug("processStartProblem ()");
    messageHandler.processStartProblem();
  };
  this.processInterfaceIdentification = function processInterfaceIdentification(aPropertyList) {
  };
  this.processInterfaceDescription = function processInterfaceDescription(aPropertyList) {
    pointer.ctatdebug("processInterfaceDescription (" + aPropertyList.length + ")");
    var aType = "Unknown";
    var aName = "Unknown";
    var targetSerializationElement = null;
    for (var i = 0;i < aPropertyList.length;i++) {
      var tempElement = aPropertyList[i];
      pointer.ctatdebug("Inspecting element: " + messageParser.getElementName(tempElement));
      if (messageParser.getElementName(tempElement) == "WidgetType") {
        pointer.ctatdebug("Widget type: " + messageParser.getNodeTextValue(tempElement));
        aType = messageParser.getNodeTextValue(tempElement);
      }
      if (messageParser.getElementName(tempElement) == "CommName") {
        pointer.ctatdebug("Instance name: " + messageParser.getNodeTextValue(tempElement));
        aName = messageParser.getNodeTextValue(tempElement);
      }
      if (messageParser.getElementName(tempElement) == "serialized") {
        pointer.ctatdebug("Prepareing to de-serialize component ...");
        var compTest = messageParser.getElementChildren(tempElement);
        for (var j = 0;j < compTest.length;j++) {
          var serElement = compTest[j];
          if (messageParser.getElementName(serElement).indexOf("CTAT") != -1) {
            targetSerializationElement = serElement;
          }
        }
      }
      if (messageParser.getElementName(tempElement) == "interface") {
        pointer.ctatdebug("Storing interface for post start-state reconstruction ...");
        CTATGlobals.interfaceElement = tempElement;
      }
      if (messageParser.getElementName(tempElement) == "script") {
        pointer.ctatdebug("Storing and loading main javascript code as defined by the BRD ...");
        scriptElement = messageParser.getNodeTextValue(tempElement);
      }
    }
    if (targetSerializationElement !== null) {
      this.deserializeComponent(aType, aName, targetSerializationElement);
    } else {
      pointer.ctatdebug("Error: unable to find CTAT serialization point of attachement");
    }
    pointer.ctatdebug("processInterfaceDescription () done");
  };
  this.deserializeComponent = function deserializeComponent(aType, aName, aComponentElement) {
    pointer.ctatdebug("deserializeComponent (" + aType + "," + aName + ")");
    if (CTATGlobals.ignoreInterfaceDescriptions === true) {
      pointer.ctatdebug("ignoreInterfaceDescriptions==true");
      return;
    }
    if (messageParser.getElementAttr(aComponentElement, "x") === null) {
      pointer.ctatdebug("Warning: this component does not have x,y information. Probably an older component");
      return;
    }
    var x = messageParser.getElementAttr(aComponentElement, "x");
    var y = messageParser.getElementAttr(aComponentElement, "y");
    var width = messageParser.getElementAttr(aComponentElement, "width");
    var height = messageParser.getElementAttr(aComponentElement, "height");
    var tabIndex = messageParser.getElementAttr(aComponentElement, "tabIndex");
    var zIndex = messageParser.getElementAttr(aComponentElement, "zIndex");
    if (tabIndex === null) {
      tabIndex = -1;
    }
    if (zIndex === null) {
      zIndex = 0;
    }
    var compEntry = new CTATComponentDescription;
    compEntry.type = aType;
    compEntry.name = aName;
    compEntry.x = Math.floor(x);
    compEntry.y = Math.floor(y);
    compEntry.tabIndex = tabIndex;
    compEntry.zIndex = zIndex;
    compEntry.width = Math.floor(width);
    compEntry.height = Math.floor(height);
    CTATShellTools.registerComponentDescription(compEntry);
    var serializedProps = messageParser.getElementChildren(aComponentElement);
    for (var i = 0;i < serializedProps.length;i++) {
      var tempElement = serializedProps[i];
      if (messageParser.getElementName(tempElement) == "SAIs") {
      }
      if (messageParser.getElementName(tempElement) == "Parameters") {
        this.ctatdebug("Processing component parameters ...");
        var tempProps = messageParser.getElementChildren(tempElement);
        var tempProp = tempProps[0];
        var paramProps = messageParser.getElementChildren(tempProp);
        for (var t = 0;t < paramProps.length;t++) {
          var paramProperty = paramProps[t];
          if (messageParser.getElementName(paramProperty) == "CTATComponentParameter") {
            this.ctatdebug("Processing parameter property (CTATComponentParameter) ...");
            var aParam = {name:undefined, value:undefined};
            var paramValues = messageParser.getElementChildren(paramProperty);
            for (var j = 0;j < paramValues.length;j++) {
              var paramElement = paramValues[j];
              if (messageParser.getElementName(paramElement) == "name") {
                this.ctatdebug("Found parameter name: " + messageParser.getNodeTextValue(paramElement));
                aParam.name = messageParser.getNodeTextValue(paramElement);
              }
              if (messageParser.getElementName(paramElement) == "value") {
                this.ctatdebug("Found parameter value: " + messageParser.getNodeTextValue(paramElement));
                aParam.value = messageParser.getNodeTextValue(paramElement).trim();
              }
            }
            this.ctatdebug("Parameter name: " + aParam.name + ", value: " + aParam.value);
            if (aParam.name !== undefined) {
              compEntry.params[aParam.name] = aParam.value;
              if (aParam.name == "group") {
                compEntry.groupName = aParam.value;
              }
            }
          }
        }
      }
      if (messageParser.getElementName(tempElement) == "Styles") {
        this.ctatdebug("Processing component styles ...");
        var tmpProps = messageParser.getElementChildren(tempElement);
        var tmpProp = tmpProps[0];
        var stylesProps = messageParser.getElementChildren(tmpProp);
        for (var s = 0;s < stylesProps.length;s++) {
          var styleProperty = stylesProps[s];
          if (messageParser.getElementName(styleProperty) == "CTATStyleProperty") {
            this.ctatdebug("Processing style property (CTATStyleProperty) ...");
            var aStyle = {name:"", value:""};
            var styleValues = messageParser.getElementChildren(styleProperty);
            for (var k = 0;k < styleValues.length;k++) {
              var styleElement = styleValues[k];
              if (messageParser.getElementName(styleElement) == "name") {
                aStyle.name = messageParser.getNodeTextValue(styleElement);
              }
              if (messageParser.getElementName(styleElement) == "value") {
                aStyle.value = messageParser.getNodeTextValue(styleElement).trim();
              }
            }
            this.ctatdebug("Style (name: " + aStyle.name + ", value: " + aStyle.value + ")");
            if (aStyle.name !== "") {
              compEntry.styles[aStyle.name] = aStyle.value;
            }
          }
        }
      }
    }
    pointer.ctatdebug("deserializeComponent (" + aType + "," + aName + ") done");
  };
  function xml_to_string(xml_node) {
    if (xml_node.xml) {
      return xml_node.xml;
    } else {
      if (XMLSerializer) {
        var xml_serializer = new XMLSerializer;
        return xml_serializer.serializeToString(xml_node);
      } else {
        alert("ERROR: Extremely old browser");
        return "";
      }
    }
  }
  function checkForSendWidgetLock() {
    var result = false, i = 0, swlMsg = [], wlFlag = "";
    for (i = startStateMessages.length - 1;i >= 0;--i) {
      if (startStateMessages[i].getMessageType() == "SendWidgetLock") {
        swlMsg = startStateMessages.splice(i, 1);
        wlFlag = swlMsg[0].getProperty("WidgetLockFlag");
        switch(String(wlFlag).toLowerCase()) {
          case "no":
          ;
          case "off":
          ;
          case "false":
            result = false;
            break;
          default:
            result = true;
            break;
        }
      }
    }
    pointer.ctatdebug("checkForSendWidgetLock() found " + swlMsg.length + " msg, wlFlag " + wlFlag + ", result" + result);
    return result;
  }
  this.processStartStateActions = function processStartStateActions() {
    pointer.ctatdebug("processStartStateActions (" + startStateMessages.length + ")");
    if (startStateMessages.length === 0) {
      pointer.ctatdebug("No start state messages, bump");
      return;
    }
    if (CTATMessageHandler.startStateHandlers.length > 0) {
      for (var i = 0;i < CTATMessageHandler.startStateHandlers.length;i++) {
        var aHandler = CTATMessageHandler.startStateHandlers[i];
        aHandler.processStartStateActions(startStateMessages);
      }
      return;
    }
    var lockWidgetsSetInStartState = checkForSendWidgetLock();
    for (var j = 0;j < startStateMessages.length;j++) {
      var aMessage = startStateMessages[j];
      pointer.ctatdebug("Processing startstate message[" + j + "] type: " + aMessage.getMessageType());
      switch(aMessage.getMessageType()) {
        case "InterfaceAction":
          messageHandler.processInterfaceAction(aMessage, lockWidgetsSetInStartState);
          commShell.propagateShellEvent("InterfaceAction", aMessage, aMessage && aMessage.getProperty ? aMessage.getProperty("Actor") : "");
          break;
        case "UntutoredAction":
          messageHandler.processUntutoredAction(aMessage, lockWidgetsSetInStartState);
          commShell.propagateShellEvent("UntutoredAction", aMessage, aMessage && aMessage.getProperty ? aMessage.getProperty("Actor") : "");
          break;
        case "CorrectAction":
          messageHandler.processCorrectAction(aMessage);
          break;
        case "InCorrectAction":
          messageHandler.processInCorrectAction(aMessage);
          break;
      }
    }
    if (CTATMessageHandler.scriptElement !== "") {
      try {
        eval(CTATMessageHandler.scriptElement);
      } catch (err) {
        alert("Error executing script from BRD: " + err.message);
      }
    }
  };
  this.sleep = function sleep(milliseconds) {
    pointer.ctatdebug("sleep (" + milliseconds + ")");
  };
};
CTATMessageHandler.prototype = Object.create(CTATBase.prototype);
CTATMessageHandler.prototype.constructor = CTATMessageHandler;
CTATMessageHandler.startStateHandlers = [];
CTATMessageHandler.inStartState = false;
CTATMessageHandler.scriptElement = "";
goog.provide("CTAT");
CTAT = function() {
};
if (typeof window != "undefined" && window != null) {
  window.CTAT = CTAT;
}
if (typeof module !== "undefined") {
  module.exports = CTAT;
}
;goog.provide("CTAT.SAI");
goog.require("CTATXML");
goog.require("CTATMessage");
goog.require("CTAT");
goog.require("CTAT.ToolTutor");
function createSteps() {
  CTAT.SAI = {help:"Enter steps.list() to see the list of steps;\n      steps.next() to do the next step;\n      steps.rest() to do the remaining steps;\n      steps.all() to do all\n      steps.send(n) to send the nth step\n", nStored:0, msgs:[], storeForReplay:function(msg) {
    if (msg && typeof msg == "string") {
      try {
        if (sessionStorage && typeof sessionStorage.setItem == "function") {
          sessionStorage.setItem("CTAT.SAI." + CTAT.SAI.nStored, msg);
          sessionStorage.setItem("CTAT.SAI.length", String(++CTAT.SAI.nStored));
        }
      } catch (e) {
        console.log("CTAT.SAI.storeForReplay() error ", e, "\n  msg", msg);
      }
      return CTAT.SAI.nStored;
    }
  }, format:function(s) {
    var udb = useDebuggingBasic;
    useDebuggingBasic = false;
    var ud = useDebugging;
    useDebugging = false;
    var xml = (new CTATXML).parseXML(s);
    var msg = new CTATMessage(xml);
    useDebuggingBasic = udb;
    useDebugging = ud;
    return sprintf("s: %-16s, a: %-16s, i: %s", msg.getSelection(), msg.getAction(), msg.getInput());
  }, list:function() {
    var list = "";
    for (var m = 0;m < CTAT.SAI.msgs.length;++m) {
      var msg = CTAT.SAI.format(CTAT.SAI.msgs[m]);
      list = sprintf("%s\n[%2d] %s", list, m, msg);
    }
    return "Number of steps: " + CTAT.SAI.msgs.length + list + "\n";
  }, send:function(i) {
    if (i >= CTAT.SAI.msgs.length) {
      return "Already past last step " + i;
    }
    CTATCommShell.commShell.getCommLibrary().sendXML(CTAT.SAI.msgs[i]);
    CTAT.SAI.storeForReplay(CTAT.SAI.msgs[i]);
  }, last:-1, next:function() {
    return CTAT.SAI.send(++CTAT.SAI.last);
  }, rest:function() {
    while (CTAT.SAI.last < CTAT.SAI.msgs.length - 2) {
      CTAT.SAI.next();
    }
    return CTAT.SAI.next();
  }, all:function() {
    CTAT.SAI.last = -1;
    return CTAT.SAI.rest();
  }};
  try {
    var n = sessionStorage.getItem("CTAT.SAI.length");
    n = n ? Number(n) : 0;
    var j = 0;
    for (;j < n;++j) {
      var key = "CTAT.SAI." + j;
      CTAT.SAI.msgs.push(sessionStorage.getItem(key));
      sessionStorage.removeItem(key);
    }
    sessionStorage.setItem("CTAT.SAI.length", String(n - j));
  } catch (e) {
    console.log("CTAT.SAI load error ", e);
  }
  return CTAT.SAI;
}
window.steps = createSteps();
console.log("***To replay steps:", "\n" + steps.help);
goog.provide("CTATSessionExpiry");
goog.require("CTATBase");
goog.require("CTATConfiguration");
goog.require("CTATConnection");
CTATSessionExpiry = function(vars, session_timeout, expire_logout_url, refresh_session_url) {
  CTATBase.call(this, "CTATSessionExpiry", session_timeout);
  var pointer = this;
  var sessionTimeoutMS = session_timeout * 1E3;
  var refreshIntervalMS = (session_timeout - 60) * 1E3;
  var inactivityIntervalMS = 60 * 1E3;
  var expireLogoutURL = expire_logout_url;
  var refreshSessionURL = refresh_session_url;
  var lastActionTimestamp = Date.now();
  var refreshConnection = null;
  var refreshTimer = 0;
  var inactivityTimer = 0;
  function processRefreshReply() {
    var httpObject = refreshConnection && refreshConnection["getHTTPObject"] ? refreshConnection.getHTTPObject() : null;
    pointer.ctatdebug("CTATSessionExpiry.processRefreshReply() refreshConnection " + refreshConnection + ", getHTTPObject " + httpObject);
    if (refreshConnection && httpObject) {
      pointer.ctatdebug("CTATSessionExpiry.processRefreshReply() readyState " + httpObject.readyState + ", status " + httpObject.status + ", responseText " + (httpObject.readyState == 4 ? httpObject.responseText : null));
    }
  }
  function processInactivityReply() {
    var httpObject = refreshConnection && refreshConnection["getHTTPObject"] ? refreshConnection.getHTTPObject() : null;
    pointer.ctatdebug("CTATSessionExpiry.processInactivityReply() refreshConnection " + refreshConnection + ", getHTTPObject " + httpObject);
    if (refreshConnection && httpObject) {
      pointer.ctatdebug("CTATSessionExpiry.processInactivityReply() readyState " + httpObject.readyState + ", status " + httpObject.status + ", responseText " + (httpObject.readyState == 4 ? httpObject.responseText : null));
    }
  }
  function startRefreshTimer() {
    try {
      if (refreshIntervalMS < 50) {
        throw "No-op: time interval " + refreshIntervalMS + " too short: less than 50 ms";
      }
      refreshTimer = setInterval(function() {
        refreshConnection.send.apply(refreshConnection, []);
      }, refreshIntervalMS);
      return "ok";
    } catch (e) {
      return e.toString();
    }
  }
  function startInactivityTimer() {
    try {
      if (inactivityIntervalMS < 50) {
        throw "No-op: time interval " + inactivityIntervalMS + " too short: less than 50 ms";
      }
      inactivityTimer = setInterval(function() {
        pointer.checkInactivity.apply(pointer, []);
      }, inactivityIntervalMS);
      return "ok";
    } catch (e) {
      return e.toString();
    }
  }
  this.checkInactivity = function() {
    var now = Date.now();
    var lastAct = lastActionTimestamp;
    pointer.ctatdebug("CTATSessionExpiry.checkInactivity() elapsed " + (now - lastAct) + ", limit " + sessionTimeoutMS + ",\n                 now " + Date(now) + ",\n lastActionTimestamp " + pointer.getLastActionTimestamp());
    if (now < lastAct + sessionTimeoutMS) {
      return;
    }
    try {
      pointer.cancelTimers();
      var connection = new CTATConnection(CTATConfiguration.getRawFlashVars());
      connection.setMethod("GET");
      connection.setURL(expireLogoutURL);
      connection.assignReceiveFunction(processInactivityReply);
      connection.send();
      return "ok";
    } catch (e) {
      return e.toString();
    }
  };
  this.updateLastActionTimestamp = function() {
    lastActionTimestamp = Date.now();
  };
  this.getLastActionTimestamp = function() {
    return new Date(lastActionTimestamp);
  };
  this.toString = function() {
    return "CTATSessionExpiry sessionTimeoutMS " + sessionTimeoutMS + ", refreshIntervalMS " + refreshIntervalMS + ", refreshTimer " + refreshTimer + ", inactivityTimer " + inactivityTimer + ",\n  expireLogoutURL " + expireLogoutURL + ",\n  refreshSessionURL " + refreshSessionURL;
  };
  this.getRefreshConnection = function() {
    return refreshConnection;
  };
  this.getSessionTimeoutMS = function() {
    return sessionTimeoutMS;
  };
  this.getRefreshIntervalMS = function() {
    return refreshIntervalMS;
  };
  this.getInactivityIntervalMS = function() {
    return inactivityIntervalMS;
  };
  this.setSessionTimeoutMS = function(newSessionTimeoutMS) {
    sessionTimeoutMS = newSessionTimeoutMS;
  };
  this.setRefreshIntervalMS = function(newRefreshIntervalMS) {
    refreshIntervalMS = newRefreshIntervalMS;
    pointer.cancelRefreshTimer();
    startRefreshTimer();
  };
  this.setInactivityIntervalMS = function(newInactivityIntervalMS) {
    inactivityIntervalMS = newInactivityIntervalMS;
    pointer.cancelInactivityTimer();
    startInactivityTimer();
  };
  this.cancelRefreshTimer = function() {
    if (refreshTimer !== 0) {
      clearInterval(refreshTimer);
    }
    refreshTimer = 0;
  };
  this.cancelInactivityTimer = function() {
    if (inactivityTimer !== 0) {
      clearInterval(inactivityTimer);
    }
    inactivityTimer = 0;
  };
  this.cancelTimers = function() {
    pointer.cancelRefreshTimer();
    pointer.cancelInactivityTimer();
  };
  this.getRefreshTimer = function() {
    return refreshTimer;
  };
  this.getInactivityTimer = function() {
    return inactivityTimer;
  };
  refreshConnection = new CTATConnection(vars);
  refreshConnection.setMethod("GET");
  refreshConnection.setURL(refreshSessionURL);
  refreshConnection.assignReceiveFunction(processRefreshReply);
  startRefreshTimer();
  startInactivityTimer();
};
CTATSessionExpiry.prototype = Object.create(CTATBase.prototype);
CTATSessionExpiry.prototype.constructor = CTATSessionExpiry;
CTATSessionExpiry.factory = function(vars) {
  var session_timeout = Number(vars["session_timeout"]) || 0;
  var expire_logout_url = vars["expire_logout_url"];
  var refresh_session_url = vars["refresh_session_url"];
  ctatdebug("CTATSessionExpiry.init() session_timeout " + session_timeout + ", expire_logout_url " + expire_logout_url + ", refresh_session_url " + refresh_session_url);
  if (session_timeout <= 60 || !expire_logout_url || !refresh_session_url) {
    return null;
  }
  return new CTATSessionExpiry(vars, session_timeout, expire_logout_url, refresh_session_url);
};
if (typeof module !== "undefined") {
  module.exports = CTATSessionExpiry;
}
;goog.provide("sprintf");
!function() {
  var re = {not_string:/[^s]/, not_bool:/[^t]/, not_type:/[^T]/, not_primitive:/[^v]/, number:/[diefg]/, numeric_arg:/[bcdiefguxX]/, json:/[j]/, not_json:/[^j]/, text:/^[^\x25]+/, modulo:/^\x25{2}/, placeholder:/^\x25(?:([1-9]\d*)\$|\(([^)]+)\))?(\+)?(0|'[^$])?(-)?(\d+)?(?:\.(\d+))?([b-gijostTuvxX])/, key:/^([a-z_][a-z_\d]*)/i, key_access:/^\.([a-z_][a-z_\d]*)/i, index_access:/^\[(\d+)\]/, sign:/^[+-]/};
  function sprintf(key) {
    return sprintf_format(sprintf_parse(key), arguments);
  }
  function vsprintf(fmt, argv) {
    return sprintf.apply(null, [fmt].concat(argv || []));
  }
  function sprintf_format(parse_tree, argv) {
    var cursor = 1, tree_length = parse_tree.length, arg, output = "", i, k, ph, pad, pad_character, pad_length, is_positive, sign;
    for (i = 0;i < tree_length;i++) {
      if (typeof parse_tree[i] === "string") {
        output += parse_tree[i];
      } else {
        if (typeof parse_tree[i] === "object") {
          ph = parse_tree[i];
          if (ph.keys) {
            arg = argv[cursor];
            for (k = 0;k < ph.keys.length;k++) {
              if (arg == undefined) {
                throw new Error(sprintf('[sprintf] Cannot access property "%s" of undefined value "%s"', ph.keys[k], ph.keys[k - 1]));
              }
              arg = arg[ph.keys[k]];
            }
          } else {
            if (ph.param_no) {
              arg = argv[ph.param_no];
            } else {
              arg = argv[cursor++];
            }
          }
          if (re.not_type.test(ph.type) && re.not_primitive.test(ph.type) && arg instanceof Function) {
            arg = arg();
          }
          if (re.numeric_arg.test(ph.type) && (typeof arg !== "number" && isNaN(arg))) {
            throw new TypeError(sprintf("[sprintf] expecting number but found %T", arg));
          }
          if (re.number.test(ph.type)) {
            is_positive = arg >= 0;
          }
          switch(ph.type) {
            case "b":
              arg = parseInt(arg, 10).toString(2);
              break;
            case "c":
              arg = String.fromCharCode(parseInt(arg, 10));
              break;
            case "d":
            ;
            case "i":
              arg = parseInt(arg, 10);
              break;
            case "j":
              arg = JSON.stringify(arg, null, ph.width ? parseInt(ph.width) : 0);
              break;
            case "e":
              arg = ph.precision ? parseFloat(arg).toExponential(ph.precision) : parseFloat(arg).toExponential();
              break;
            case "f":
              arg = ph.precision ? parseFloat(arg).toFixed(ph.precision) : parseFloat(arg);
              break;
            case "g":
              arg = ph.precision ? String(Number(arg.toPrecision(ph.precision))) : parseFloat(arg);
              break;
            case "o":
              arg = (parseInt(arg, 10) >>> 0).toString(8);
              break;
            case "s":
              arg = String(arg);
              arg = ph.precision ? arg.substring(0, ph.precision) : arg;
              break;
            case "t":
              arg = String(!!arg);
              arg = ph.precision ? arg.substring(0, ph.precision) : arg;
              break;
            case "T":
              arg = Object.prototype.toString.call(arg).slice(8, -1).toLowerCase();
              arg = ph.precision ? arg.substring(0, ph.precision) : arg;
              break;
            case "u":
              arg = parseInt(arg, 10) >>> 0;
              break;
            case "v":
              arg = arg.valueOf();
              arg = ph.precision ? arg.substring(0, ph.precision) : arg;
              break;
            case "x":
              arg = (parseInt(arg, 10) >>> 0).toString(16);
              break;
            case "X":
              arg = (parseInt(arg, 10) >>> 0).toString(16).toUpperCase();
              break;
          }
          if (re.json.test(ph.type)) {
            output += arg;
          } else {
            if (re.number.test(ph.type) && (!is_positive || ph.sign)) {
              sign = is_positive ? "+" : "-";
              arg = arg.toString().replace(re.sign, "");
            } else {
              sign = "";
            }
            pad_character = ph.pad_char ? ph.pad_char === "0" ? "0" : ph.pad_char.charAt(1) : " ";
            pad_length = ph.width - (sign + arg).length;
            pad = ph.width ? pad_length > 0 ? pad_character.repeat(pad_length) : "" : "";
            output += ph.align ? sign + arg + pad : pad_character === "0" ? sign + pad + arg : pad + sign + arg;
          }
        }
      }
    }
    return output;
  }
  var sprintf_cache = Object.create(null);
  function sprintf_parse(fmt) {
    if (sprintf_cache[fmt]) {
      return sprintf_cache[fmt];
    }
    var _fmt = fmt, match, parse_tree = [], arg_names = 0;
    while (_fmt) {
      if ((match = re.text.exec(_fmt)) !== null) {
        parse_tree.push(match[0]);
      } else {
        if ((match = re.modulo.exec(_fmt)) !== null) {
          parse_tree.push("%");
        } else {
          if ((match = re.placeholder.exec(_fmt)) !== null) {
            if (match[2]) {
              arg_names |= 1;
              var field_list = [], replacement_field = match[2], field_match = [];
              if ((field_match = re.key.exec(replacement_field)) !== null) {
                field_list.push(field_match[1]);
                while ((replacement_field = replacement_field.substring(field_match[0].length)) !== "") {
                  if ((field_match = re.key_access.exec(replacement_field)) !== null) {
                    field_list.push(field_match[1]);
                  } else {
                    if ((field_match = re.index_access.exec(replacement_field)) !== null) {
                      field_list.push(field_match[1]);
                    } else {
                      throw new SyntaxError("[sprintf] failed to parse named argument key");
                    }
                  }
                }
              } else {
                throw new SyntaxError("[sprintf] failed to parse named argument key");
              }
              match[2] = field_list;
            } else {
              arg_names |= 2;
            }
            if (arg_names === 3) {
              throw new Error("[sprintf] mixing positional and named placeholders is not (yet) supported");
            }
            parse_tree.push({placeholder:match[0], param_no:match[1], keys:match[2], sign:match[3], pad_char:match[4], align:match[5], width:match[6], precision:match[7], type:match[8]});
          } else {
            throw new SyntaxError("[sprintf] unexpected placeholder");
          }
        }
      }
      _fmt = _fmt.substring(match[0].length);
    }
    return sprintf_cache[fmt] = parse_tree;
  }
  if (typeof exports !== "undefined") {
    exports["sprintf"] = sprintf;
    exports["vsprintf"] = vsprintf;
  }
  if (typeof window !== "undefined") {
    window["sprintf"] = sprintf;
    window["vsprintf"] = vsprintf;
    if (typeof define === "function" && define["amd"]) {
      define(function() {
        return {"sprintf":sprintf, "vsprintf":vsprintf};
      });
    }
  }
}();
goog.provide("CTATTransactionListener");
goog.require("sprintf");
goog.require("CTAT.ToolTutor");
goog.require("CTATBase");
goog.require("CTATConfiguration");
goog.require("CTATGuid");
goog.require("CTATJSON");
goog.require("CTATLogMessageBuilder");
goog.require("CTATMessage");
goog.require("CTATSAI");
goog.require("CTATSkillSet");
goog.require("CTATXML");
CTATTransactionListener = function(transactionURL) {
  CTATBase.call(this, "CTATTransactionListener", "");
  var pointer = this;
  var process_transactions_url = transactionURL;
  var mailerProxy = null;
  var initializing = true;
  var problemInfo = null;
  var incompleteTransactions = {};
  var nIncompleteTransactions = 0;
  var messageParser = CTATConfig.parserType_is_XML() ? new CTATXML : new CTATJSON;
  function removeIncompleteTransaction(txId) {
    var result = incompleteTransactions[txId];
    if (result) {
      delete incompleteTransactions[txId];
      --nIncompleteTransactions;
      pointer.ctatdebug("CTATTransactionListener.removeIncompleteTransaction(" + txId + ") count now " + nIncompleteTransactions);
      return result;
    }
    return null;
  }
  function storeIncompleteTransaction(txId, tx) {
    var oldTx = incompleteTransactions[txId];
    if (oldTx) {
      console.log("Warning: CTATTransactionListener.storeIncompleteTransaction() found tx with ID " + txId, oldTx);
      --nIncompleteTransactions;
    }
    incompleteTransactions[txId] = tx;
    ++nIncompleteTransactions;
    pointer.ctatdebug("CTATTransactionListener.storeIncompleteTransaction(" + txId + ") count now " + nIncompleteTransactions);
    return null;
  }
  function hasTutorResponse(eventType, msg) {
    switch(eventType) {
      case "UntutoredAction":
        return false;
      case "InterfaceAction":
        return getProperty(msg, "subtype").toLowerCase() != "tutor-performed";
      default:
        return true;
    }
  }
  function makeMailer() {
    if (typeof TransactionMailerUsers != "undefined" && typeof TransactionMailerUsers.create == "function") {
      try {
        var result = TransactionMailerUsers.create("Assets", process_transactions_url, CTATConfiguration.get("process_detectors_url"), CTATConfiguration.get("authenticity_token"), CTATConfiguration.get("detectors"), CTATConfiguration.get("provider_key"));
        return mailerProxy = result;
      } catch (error) {
        console.trace("Error creating transaction mailer: " + error);
        return mailerProxy = null;
      }
    }
  }
  this.getMailer = function() {
    return mailerProxy;
  };
  this.onmessage = function(e) {
    pointer.ctatdebug("CTATTransactionListener.onmessage(" + e.toString() + ")");
    var sai = e.data && e.data.length >= 3 ? new CTATSAI(e.data[0], e.data[1], e.data[2]) : null;
    if (sai) {
      CTATCommShell.shell.processComponentAction(sai, false, true, null, "ATTEMPT", "Detector");
    }
  };
  if (!mailerProxy) {
    mailerProxy = makeMailer();
  }
  this.isReady = function() {
    return pointer.mailerProxy != null;
  };
  this.toString = function() {
    return "transactions sent to [" + pointer.process_transactions_url + ":]";
  };
  this.processCommShellEvent = function(eventType, aMessage, actor) {
    console.trace("CTATTransactionListener.processCommShellEvent(" + eventType + ", " + aMessage + ", " + actor + ")");
    try {
      var tx = null;
      switch(eventType) {
        case "InterfaceAction":
        ;
        case "AssociatedRules":
        ;
        case "UntutoredAction":
        ;
        case "NextPressed":
        ;
        case "PreviousPressed":
          var msg = aMessage;
          if (aMessage && aMessage.constructor != CTATMessage) {
            msg = aMessage.constructor != Element ? messageParser.parse(msg) : msg;
            msg = new CTATMessage(msg);
          }
          tx = makeOrCompleteTransaction(eventType, msg, actor);
          break;
        case "StartProblem":
          pointer.problemInfo = createContextMessage();
          break;
        case "ProblemRestoreEnd":
          pointer.initializing = false;
          break;
        default:
        ;
      }
      if (tx && !pointer.initializing) {
        mailerProxy.sendTransaction(tx);
      }
    } catch (error) {
      console.log("Error in CTATTransactionListener.processCommShellEvent(" + eventType + "): " + error, error.stack);
    }
  };
  function makeOrCompleteTransaction(eventType, msg, actor) {
    pointer.ctatdebug("CTATTransactionListener.makeOrCompleteTransaction(" + eventType + ") pointer " + pointer + ", problemInfo " + problemInfo + ", pointer.problemInfo " + (pointer ? pointer.problemInfo : null));
    var result = null;
    var txId = null;
    var isComplete = false;
    if (!(txId = getTransactionId(msg))) {
      return null;
    }
    if ((isComplete = !hasTutorResponse(eventType, msg)) || !((result = removeIncompleteTransaction(txId)) && (isComplete = true))) {
      result = {meta:pointer.problemInfo.meta, context:pointer.problemInfo.context};
    }
    switch(eventType) {
      case "AssociatedRules":
      ;
      case "NextPressed":
      ;
      case "PreviousPressed":
        addTutorInfo(eventType, msg, actor, result);
        break;
      default:
        result.meta.date_time = formatTimeStamp(new Date);
        addToolInfo(eventType, msg, actor, result);
        break;
    }
    return isComplete ? result : storeIncompleteTransaction(txId, result);
  }
  function getTransactionId(msg) {
    return msg && typeof msg.getTransactionID == "function" ? msg.getTransactionID() : null;
  }
  function formatTimeStamp(stamp) {
    pointer.ctatdebug("formatTimeStamp (" + stamp + ")");
    var s = sprintf("%04d-%02d-%02d %02d:%02d:%02d.%03d UTC", stamp.getUTCFullYear(), stamp.getUTCMonth() + 1, stamp.getUTCDate(), stamp.getUTCHours(), stamp.getUTCMinutes(), stamp.getUTCSeconds(), stamp.getUTCMilliseconds());
    return s;
  }
  function makeMetaElement(timeStamp) {
    pointer.ctatdebug("TX.makeMetaElement ()");
    var meta = {};
    meta.date_time = formatTimeStamp(timeStamp);
    meta.session_id = CTATConfiguration.get("session_id");
    meta.user_guid = CTATConfiguration.get("user_guid");
    return meta;
  }
  function addContextMessageID(ctxt) {
    var id = CTATLogMessageBuilder.contextGUID;
    if (!id) {
      throw new Error("Context message ID not yet defined");
    }
    ctxt.context_message_id = id;
    return ctxt;
  }
  function addMultilevelProperties(ctxt, prefix) {
    var levelType = null, levelName = null;
    for (var i = 1;true;++i) {
      var t = prefix + "_type" + i, n = prefix + "_name" + i;
      levelType = CTATConfiguration.get(t);
      levelName = CTATConfiguration.get(n);
      if (!levelType || !levelName) {
        break;
      }
      ctxt[t] = levelType;
      ctxt[n] = levelName;
    }
    if (i == 1) {
      levelType = CTATConfiguration.get(prefix + "_type");
      levelName = CTATConfiguration.get(prefix + "_name");
      ctxt[t] = levelType ? levelType : "";
      ctxt[n] = levelName ? levelName : "";
    }
    return ctxt;
  }
  function addDatasetProperties(ctxt) {
    var dataset = CTATConfiguration.get("dataset_name");
    ctxt.dataset_name = dataset ? dataset : "";
    addMultilevelProperties(ctxt, "dataset_level");
    prop = CTATConfiguration.get("problem_name");
    ctxt.problem_name = prop ? prop : "";
    prop = CTATConfiguration.get("problem_context");
    ctxt.problem_context = prop ? prop : "";
    prop = CTATConfiguration.get("problem_tutorflag");
    ctxt.problem_tutorFlag = prop ? prop : "";
    addMultilevelProperties(ctxt, "study_condition");
    return ctxt;
  }
  function addCustomFields(ctxt) {
    var n = 0, cfs = CTATConfiguration.getCustomFields();
    if (cfs) {
      ctxt.custom_fields = {};
      for (var name in cfs) {
        if (cfs.hasOwnProperty(name)) {
          ctxt.custom_fields[name] = cfs[name];
          ++n;
        }
      }
    }
    pointer.ctatdebug("CTATTransactionListener.createCustomFields() nAdded " + n + ", cfs " + cfs);
    return ctxt;
  }
  function addClassProperties(ctxt) {
    var prop = null;
    prop = CTATConfiguration.get("class_name");
    ctxt.class_name = prop ? prop : "";
    prop = CTATConfiguration.get("school_name");
    ctxt.class_school = prop ? prop : "";
    prop = CTATConfiguration.get("period_name");
    ctxt.class_period_name = prop ? prop : "";
    prop = CTATConfiguration.get("class_description");
    ctxt.class_description = prop ? prop : "";
    prop = CTATConfiguration.get("instructor_name");
    ctxt.class_instructor_name = prop ? prop : "";
    return ctxt;
  }
  function createContextMessage() {
    pointer.ctatdebug("CTATTransactionListener.createContextMessage()");
    var result = {};
    var now = new Date;
    result.meta = makeMetaElement(now);
    result.context = {};
    addContextMessageID(result.context);
    addClassProperties(result.context);
    addDatasetProperties(result.context);
    addCustomFields(result.context);
    return result;
  }
  function addToolInfo(eventType, msg, actor, tx) {
    if (!(tx.transaction_id = getTransactionId(msg))) {
      throw new Error("Message has no transaction_id: eventType " + eventType + ", msg\n  " + msg);
    }
    tx.semantic_event = eventType == "UntutoredAction" ? "UNTUTORED-ACTION" : isHint(eventType, msg) ? "HINT-REQUEST-HINTS" : "ATTEMPT-RESULT";
    tx.actor = actor ? actor : "student";
    if (tx.tool_data) {
      console.log("Warning: CTATTransactionListener.addToolInfo(" + eventType + ") tx has tool_data with time " + tx.tool_data.tool_event_time);
    }
    tx.tool_data = {};
    tx.tool_data.tool_event_time = formatTimeStamp(new Date);
    tx.tool_data.selection = getProperty(msg, "Selection");
    tx.tool_data.action = getProperty(msg, "Action");
    tx.tool_data.input = getProperty(msg, "Input");
  }
  function addTutorInfo(eventType, msg, actor, tx) {
    if (tx.tutor_data) {
      console.log("Warning: CTATTransactionListener.addTutorInfo(" + eventType + ") tx has tutor_data with time " + tx.tutor_data.tutor_event_time);
    }
    tx.tutor_data = {};
    tx.tutor_data.tutor_event_time = formatTimeStamp(new Date);
    tx.tutor_data.selection = getProperty(msg, "Selection");
    tx.tutor_data.action = getProperty(msg, "Action");
    tx.tutor_data.input = getProperty(msg, "Input");
    tx.tutor_data.action_evaluation = msg.getIndicator();
    if (tx.tutor_data.action_evaluation.toLowerCase().indexOf("hint") >= 0) {
      tx.tutor_data.current_hint_number = getProperty(msg, "CurrentHintNumber");
      tx.tutor_data.total_hints_available = getProperty(msg, "TotalHintsAvailable");
    }
    tx.tutor_data.tutor_advice = getProperty(msg, "TutorAdvice");
    tx.tutor_data.skills = createSkills(msg);
    tx.tutor_data.step_id = getProperty(msg, "StepID");
    tx.tutor_data.rule_names = getPropertyAsArray(msg, "Rules");
    tx.tutor_data.custom_fields = createCustomFields(msg);
  }
  function createCustomFields(msg) {
    var result = msg.getCustomFields();
    pointer.ctatdebug("CTATTransactionListener.createCustomFields() result " + result);
    return result;
  }
  function createSkills(msg) {
    var result = [];
    var tracerSS = CTAT.ToolTutor.tutor && CTAT.ToolTutor.tutor.getProblemSummary() ? CTAT.ToolTutor.tutor.getProblemSummary().getSkills() : null;
    var skObj = msg.getSkillsObject();
    var skList = skObj.getSkillSet();
    for (var i = 0;i < skList.length;++i) {
      var sk = skList[i];
      var ssSk = CTATSkillSet.skills ? CTATSkillSet.skills.getSkill(sk.getSkillName()) : null;
      if (ssSk) {
        var skElt = {};
        skElt.name = ssSk.getSkillName();
        skElt.category = ssSk.getCategory();
        var fullName = skElt.category == null || skElt.category.trim() == "" ? skElt.name : skElt.name + " " + skElt.category;
        var tracerSk = tracerSS ? tracerSS.getSkill(fullName) : null;
        var p;
        if (tracerSk) {
          skElt.pKnown = isNaN(p = tracerSk.getPKnown()) ? "" : p;
          skElt.pGuess = isNaN(p = tracerSk.getPGuess()) ? "" : p;
          skElt.pSlip = isNaN(p = tracerSk.getPSlip()) ? "" : p;
          skElt.pLearn = isNaN(p = tracerSk.getPLearn()) ? "" : p;
          skElt.history = isNaN(p = tracerSk.getHistory()) ? "" : p;
          skElt.opportunityCount = isNaN(p = tracerSk.getOpportunityCount()) ? "" : p;
        } else {
          skElt.pKnown = isNaN(p = ssSk.getPKnown()) ? "" : p;
          skElt.pGuess = isNaN(p = ssSk.getPGuess()) ? "" : p;
          skElt.pSlip = isNaN(p = ssSk.getPSlip()) ? "" : p;
          skElt.pLearn = isNaN(p = ssSk.getPLearn()) ? "" : p;
        }
        pointer.ctatdebug("CTATTransactionListener.createSkills() ssSk " + ssSk + ", tracerSk " + tracerSk + ", skElt " + skElt);
        result.push(skElt);
      }
    }
    return result;
  }
  function isHint(eventType, msg) {
    if (eventType && typeof eventType.toLowerCase == "function" && eventType.toLowerCase().indexOf("hint") >= 0) {
      return true;
    }
    if (!msg) {
      return false;
    }
    if (msg.getMessageType().toLowerCase().indexOf("hint") >= 0) {
      return true;
    }
    var selection = msg.getSelection().toLowerCase();
    var action = msg.getAction().toLowerCase();
    return action.indexOf("buttonpress") >= 0 && (selection.indexOf("hint") >= 0 || selection.indexOf("help") >= 0);
  }
  function getPropertyAsArray(msg, propName) {
    var withValues = msg.getProperty(propName);
    var result = withValues ? withValues.split(CTATTransactionListener.valueDelimiter) : [];
    pointer.ctatdebug("CTATTransactionListener.getPropertyAsArray(" + propName + ") withValues " + withValues + ", result " + result);
    return result;
  }
  function getProperty(msg, propName) {
    var valueElts = getPropertyAsArray(msg, propName);
    var result = "";
    for (var i = 0;i < valueElts.length;++i) {
      result = result + valueElts[i];
    }
    pointer.ctatdebug("CTATTransactionListener.getProperty(" + propName + ") valueElts " + valueElts + ", result " + result);
    return result;
  }
  ctatdebug("**<end of CTATTransactionListener constructor, process_transactions_url " + process_transactions_url + ", mailerProxy " + mailerProxy);
};
Object.defineProperty(CTATTransactionListener, "scriptParam", {enumerable:false, configurable:false, writable:false, value:"process_transactions_url"});
Object.defineProperty(CTATTransactionListener, "valueDelimiter", {enumerable:false, configurable:false, writable:false, value:/<\/?value>/});
CTATTransactionListener.prototype = Object.create(CTATBase.prototype);
CTATTransactionListener.prototype.constructor = CTATTransactionListener;
if (typeof module !== "undefined") {
  module.exports = CTATTransactionListener;
}
CTATTransactionListener.create = function(scriptURL) {
  var result = null;
  if (!scriptURL && (typeof TransactionMailerUsers == "undefined" || typeof TransactionMailerUsers.create != "function")) {
    return null;
  }
  try {
    result = new CTATTransactionListener(scriptURL);
    if (!result.getMailer()) {
      throw new Error("Transaction listener postMessage() not defined.");
    }
  } catch (error) {
    console.trace("Error creating or connecting to transaction listener", error);
    result = null;
  }
  return result;
};
goog.provide("CTATNameTranslator");
goog.require("CTATBase");
goog.require("CTATGlobalFunctions");
CTATNameTranslator = function() {
  CTATBase.call(this, "CTATNameTranslator", "translator");
  var toUpperCase = false;
  var passthrough = false;
  var pointer = this;
  this.setPassthrough = function setPassthrough(aValue) {
    passthrough = CTATGlobalFunctions.toBoolean(aValue);
  };
  this.getPassthrough = function getPassthrough() {
    return passthrough;
  };
  this.manufactorJSON = function manufactorJSON(aRange, aValue) {
    pointer.ctatdebug("manufactorJSON (" + aRange + "," + aValue + ")");
    var range = aRange.split(":");
    if (range.length == 1) {
      pointer.ctatdebug("No range in aRange, returning basic JSON ...");
      return "";
    }
    var a1RowStart = this.getA1Row(range[0]);
    var a1ColStart = this.getA1Col(range[0]);
    var a1RowEnd = this.getA1Row(range[1]);
    var a1ColEnd = this.getA1Col(range[1]);
    pointer.ctatdebug("Manufacturing json from: [" + a1RowStart + "," + a1ColStart + "] to: [" + a1RowEnd + "," + a1ColEnd + "]");
    var jsonString = "[";
    var xRange = parseInt(a1RowEnd) - parseInt(a1RowStart);
    var yRange = parseInt(a1ColEnd) - parseInt(a1ColStart);
    xRange++;
    yRange++;
    pointer.ctatdebug("X range: " + xRange + ", Y range: " + yRange);
    for (var i = 0;i < xRange;i++) {
      if (i > 0) {
        jsonString += ",";
      }
      jsonString += "[";
      for (var j = 0;j < yRange;j++) {
        if (j > 0) {
          jsonString += ",";
        }
        jsonString += '"';
        jsonString += aValue;
        jsonString += '"';
      }
      jsonString += "]";
    }
    jsonString += "]";
    return jsonString;
  };
  this.translateFromCTAT = function translateFromCTAT(aName, noNamespace) {
    if (passthrough === true) {
      return aName;
    }
    var inName = aName.toLowerCase();
    pointer.ctatdebug("translateFromCTAT (" + inName + ")");
    var rowOriginal = 0;
    var colOriginal = 0;
    var outName = "";
    if (inName.indexOf(".r") != -1) {
      var pieces = inName.split(".");
      var RC = pieces[1].split("r");
      if (RC.length <= 0) {
        RC = pieces[1].split("c");
      }
      if (RC.length <= 0) {
        pointer.ctatdebug("Info: incoming name does not need translation");
      } else {
        colOriginal = RC[1];
        rowOriginal = RC[0].substr(1);
        pointer.ctatdebug("Original row (1st format): " + rowOriginal + " original col: " + colOriginal);
        if (noNamespace === true) {
          outName = colName(colOriginal, toUpperCase) + rowOriginal;
        } else {
          outName = pieces[0] + "." + colName(colOriginal, toUpperCase) + rowOriginal;
        }
        pointer.ctatdebug("Translated: " + outName);
        return outName;
      }
    } else {
      if (inName.indexOf("r") === 0) {
        var columnIndex = inName.indexOf("c");
        var rowRaw = parseInt(inName.substr(1, columnIndex - 1));
        var colRaw = parseInt(inName.substr(columnIndex + 1));
        rowOriginal = rowRaw + 1;
        colOriginal = colRaw;
        pointer.ctatdebug("Original row (2nd format) (columnindex: " + columnIndex + "): " + rowRaw + " -> " + rowOriginal + ", original col: " + colRaw + " -> " + colOriginal);
        outName = colName(colOriginal, toUpperCase) + rowOriginal;
        pointer.ctatdebug("Translated: " + outName);
        return outName;
      } else {
        pointer.ctatdebug("Info: incoming name does not need translation");
      }
    }
    return inName;
  };
  this.translateToCTAT = function translateToCTAT(inName) {
    if (passthrough === true) {
      return inName;
    }
    var colRaw = this.letterToColumn(inName.substr(0, 1)) - 1;
    var rowRaw = parseInt(inName.substr(1)) - 1;
    return "R" + rowRaw + "C" + colRaw;
  };
  this.columnToLetter = function columnToLetter(column) {
    var temp, letter = "";
    while (column > 0) {
      temp = (column - 1) % 26;
      letter = String.fromCharCode(temp + 65) + letter;
      column = (column - temp - 1) / 26;
    }
    return letter;
  };
  this.letterToColumn = function letterToColumn(letter) {
    var column = 0, length = letter.length;
    for (var i = 0;i < length;i++) {
      column += (letter.charCodeAt(i) - 64) * Math.pow(26, length - i - 1);
    }
    return column;
  };
  this.getA1Row = function getA1Row(inName) {
    var rowRaw = parseInt(inName.substr(1)) - 1;
    return rowRaw;
  };
  this.getA1Col = function getA1Col(inName) {
    var colRaw = this.letterToColumn(inName.substr(0, 1)) - 1;
    return colRaw;
  };
};
CTATNameTranslator.prototype = Object.create(CTATBase.prototype);
CTATNameTranslator.prototype.constructor = CTATNameTranslator;
goog.provide("CTATCommShell");
goog.require("CTATActionEvaluationData");
goog.require("CTATBase");
goog.require("CTATCommLibrary");
goog.require("CTATCurriculumService");
goog.require("CTATGlobalFunctions");
goog.require("CTATGlobals");
goog.require("CTATGuid");
goog.require("CTATHTMLManager");
goog.require("CTATLMS");
goog.require("CTATLoggingLibrary");
goog.require("CTATLogMessageBuilder");
goog.require("CTATMessage");
goog.require("CTATMessageHandler");
goog.require("CTATSAI");
goog.require("CTAT.SAI");
goog.require("CTATScrim");
goog.require("CTATSessionExpiry");
goog.require("CTATShellTools");
goog.require("CTATSkillSet");
goog.require("CTATTutoringServiceMessageBuilder");
goog.require("CTATTransactionListener");
goog.require("CTATXML");
goog.require("CTATNameTranslator");
CTATCommShell = function() {
  CTATBase.call(this, "CTATCommShell", "theShell");
  var commLibrary = null;
  var sessionExpiry = null;
  var commLMSService = null;
  var commMessageBuilder = null;
  var tutorPointer = null;
  var pointer = this;
  var doneProcessor = null;
  var messageParser = null;
  var externalComponents = {};
  var gradingProcessor = null;
  var feedbackProcessor = null;
  var summaryRequestCallback = null;
  var anonymousGradingProcessor = null;
  var eventListeners = {};
  var eventListenersGlobal = [];
  var gotProblemRestoreEnd = false;
  if (CTATConfig.parserType == "xml") {
    messageParser = new CTATXML;
  } else {
    messageParser = new CTATJSON;
  }
  this.init = function init(aTutor) {
    this.ctatdebug("init () tutoring_service_communication " + CTATConfiguration.get("tutoring_service_communication") + " is.Authoring " + CTATLMS.is.Authoring());
    if (CTATLMS.is.Authoring()) {
      CTATConfiguration.set("tutoring_service_communication", "websocket");
      CTATConfiguration.set("question_file", "");
    }
    var vars = CTATConfiguration.getRawFlashVars();
    var prefix = "http://";
    if (vars["tutoring_service_communication"] == "https") {
      prefix = "https://";
    }
    var rsURL = vars["remoteSocketURL"];
    if (rsURL) {
      rsURL = String(rsURL).toLowerCase();
      if (rsURL.indexOf("http") == 0 || rsURL.indexOf("ws") == 0) {
        prefix = "";
      }
    }
    tutorPointer = aTutor;
    CTATLogMessageBuilder.contextGUID = CTATGuid.guid();
    processSkills();
    if (commMessageHandler == null) {
      commMessageHandler = new CTATMessageHandler(this);
      CTAT.ToolTutor.registerInterface(commMessageHandler);
    }
    commMessageHandler.assignHandler(this);
    commMessageBuilder = new CTATTutoringServiceMessageBuilder;
    if (vars["deliverymode"]) {
      if (vars["deliverymode"] == "review") {
        vars["Logging"] = "None";
      }
    }
    sessionExpiry = CTATSessionExpiry.factory(vars);
    commLibrary = new CTATCommLibrary;
    commLibrary.setConnectionRefusedMessage("ERROR_CONN_TS");
    commLibrary.setSocketType(vars["tutoring_service_communication"] + (vars["collaborators"] || CTATLMS.is.ToolsListener() ? " websocket" : ""));
    commLibrary.assignHandler(this);
    commLMSService = new CTATCurriculumService(commLibrary);
    if (commLoggingLibrary == null) {
      commLoggingLibrary = new CTATLoggingLibrary(true);
    }
    commLoggingLibrary.getLoggingCommLibrary().setFixedURL(flashVars.getRawFlashVars()["log_service_url"]);
    flashVars.setTimeZone(null);
    var htmlManager = new CTATHTMLManager;
    this.ctatdebug("CTATCommShell.init() FlashVar info: " + vars["info"]);
    if (vars["info"] != null) {
      try {
        if (parent.javaScriptInfo) {
          parent.javaScriptInfo(decodeURIComponent(vars["info"]));
        }
      } catch (err) {
      }
    } else {
      this.ctatdebug("There is no info flash var");
    }
    console.log("Connecting to: " + prefix + vars["remoteSocketURL"] + ":" + vars["remoteSocketPort"]);
    var prefMessage = commMessageBuilder.createSetPreferencesMessage(version, this.getAllInterfaceDescriptions());
    if (pointer.hasTutorShopCable()) {
      CTAT.ToolTutor.sendToTutor(prefMessage);
    } else {
      commLibrary.sendXMLURL(prefMessage, prefix + vars["remoteSocketURL"] + ":" + vars["remoteSocketPort"], CTATConfiguration.get("collaborators"));
    }
    initializeScrimForCollaboration();
    pointer.addGlobalEventListener(CTATTransactionListener.create(vars[CTATTransactionListener.scriptParam]));
  };
  this.getCommLibrary = function() {
    return commLibrary;
  };
  this.forwardToTutor = function(msg) {
    if (commLibrary && commLibrary.hasJavaScriptConnection()) {
      CTAT.ToolTutor.sendToTutor(msg.getXMLString());
    }
  };
  this.getLoggingLibrary = function getLoggingLibrary() {
    return commLoggingLibrary;
  };
  this.propagateShellEvent = function propagateShellEvent(anEvent, aMessage, actor, logmsg) {
    ctatdebug("propagateShellEvent (" + anEvent + ", " + typeof aMessage + ", logmsg len " + (typeof logmsg == "string" ? logmsg.length : logmsg) + ")");
    for (var i = 0;i < eventListenersGlobal.length;i++) {
      eventListenersGlobal[i].processCommShellEvent(anEvent, aMessage, actor, logmsg);
    }
  };
  this.reset = function reset() {
    pointer.ctatdebug("reset ()");
    CTATGlobals.interfaceElement = null;
    commMessageHandler.reset();
  };
  this.getSessionExpiry = function getSessionExpiry() {
    return sessionExpiry;
  };
  this.getMessageHandler = function getMessageHandler() {
    return this.commMessageHandler;
  };
  this.addStartStateHandler = function addStartStateHandler(aHandler) {
    pointer.ctatdebug("addStartStateHandler ()");
    if (CTATMessageHandler.startStateHandlers == null) {
      CTATMessageHandler.startStateHandlers = [];
    }
    CTATMessageHandler.startStateHandlers.push(aHandler);
  };
  function initializeScrimForCollaboration() {
    var collabs = CTATConfiguration.get("collaborators");
    if (collabs && collabs.length > 1) {
      CTATScrim.scrim.scrimDown();
      CTATScrim.scrim.scrimUp(CTATGlobals.languageManager.getString("AWAITING_OTHER_COLLABORATORS"));
    }
  }
  function processSkills() {
    pointer.ctatdebug("processSkills ()");
    CTATSkillSet.skills = new CTATSkillSet;
    var vars = flashVars.getRawFlashVars();
    if (vars["skills"] != null) {
      CTATSkillSet.skills.fromXMLString(vars["skills"], true);
    }
    pointer.updateSkillWindow(null);
  }
  this.gradeComponent = function gradeComponent(aComponent) {
    this.ctatdebug("gradeComponent (" + aComponent.getName() + "," + aComponent.getClassName() + ")");
    var doneButton = CTATShellTools.findComponentByClass("CTATDoneButton");
    if (doneButton != null && doneButton != aComponent) {
      doneButton.moveHintHighlight(false, null);
    } else {
      pointer.ctatdebug("Info: no done button available to reset");
    }
    pointer.clearFeedbackComponents();
    if (nameTranslator != null) {
      nameTranslator.translateFromCTAT(aComponent.getName());
    } else {
      this.ctatdebug("Info: no name translator provided, using as-is");
    }
    if (aComponent == null) {
      this.ctatdebug("Internal error, provided component is null");
      return;
    } else {
      this.ctatdebug("Info: we have a valid component, grading ...");
    }
    if (aComponent.getTutorComponent() == "Do not tutor") {
      pointer.processComponentAction(aComponent.getSAI(), false);
      return;
    }
    this.ctatdebug("Checking for back grading: " + aComponent.getName());
    if (aComponent.getClassName() == "CTATTextArea" || aComponent.getClassName() == "CTATTextInput" || aComponent.getClassName() == "CTATTextField") {
      this.ctatdebug("Backgrading ...");
      this.ctatdebug("Grading " + aComponent.getClassName() + " with value: " + aComponent.getValue());
      if (CTATGlobalFunctions.isBlank(aComponent.getValue()) === true) {
        this.ctatdebug("Empty component, nothing to grade");
        return;
      }
      aComponent.updateSAI();
      var textSAI = aComponent.getSAI();
      pointer.processComponentAction(textSAI);
      return;
    }
    if (aComponent.getClassName() == "CTATTableGoogle") {
      var tgMessage = new CTATSAI(aComponent.getCurrentSelection(), "UpdateTextArea", aComponent.getCurrentValue());
      pointer.processComponentAction(tgMessage);
      return;
    }
    var dtsMessage = aComponent.getSAI();
    pointer.processComponentAction(dtsMessage);
  };
  this.processMessage = function processMessage(aMessage) {
    this.ctatdebug("processMessage ()");
    commMessageHandler.processMessage(aMessage);
    this.ctatdebug("processMessage () done");
  };
  this.processStartProblem = function processStartProblem() {
    this.ctatdebug("processStartProblem ()");
    if (CTATConfig.external == "google") {
      this.showFeedback("The tutor is starting, please wait ...");
    }
    if (CTATLMS.initLMSConnection) {
      CTATLMS.initLMSConnection();
    }
  };
  this.processStartState = function processStartState() {
    this.ctatdebug("processStartState ()");
    CTATMessageHandler.inStartState = true;
    if (tutorPointer != null) {
      this.ctatdebug("Calling tutor.createInterface () ...");
      tutorPointer.createInterface();
    } else {
      this.ctatdebug("Error: no tutor object available, calling createInterface globally ...");
      if (window.hasOwnProperty("createInterface")) {
        window.createInterface();
      }
    }
    this.ctatdebug("Logging start of problem ...");
    if (commLoggingLibrary != null) {
      commLoggingLibrary.startProblem();
    } else {
      this.ctatdebug("Info: no logging library available!");
    }
    pointer.propagateShellEvent("StartProblem", null);
    this.ctatdebug("End of start state, inspecting suppressStudentFeedback ...");
    if (CTATGlobals.suppressStudentFeedback === true) {
      this.ctatdebug("Hiding hint button ...");
      var hintButton = CTATShellTools.findComponentByClass("CTATHintButton");
      if (hintButton != null) {
        hintButton.SetVisible(false);
      }
    }
    if (CTATConfig.external == "google") {
      pointer.ctatdebug("Calling google app script hint request driver ...");
      addCall(new RPCObject("resetOnEditQueue", "dummy", "dummy"));
      return;
    }
    this.ctatdebug("processStartState () done");
  };
  this.sendStartProblemMessage = function sendStartProblemMessage() {
    pointer.ctatdebug("sendStartProblemMessage()");
  };
  this.sendProblemSummaryRequest = function sendProblemSummaryRequest(callBack) {
    pointer.ctatdebug("sendProblemSummaryRequest()");
    summaryRequestCallback = callBack;
    var builder = new CTATTutoringServiceMessageBuilder;
    var tsMessage = builder.createProblemSummaryRequestMessage();
    commLibrary.sendXML(tsMessage, false);
  };
  this.getAllInterfaceDescriptions = function getAllInterfaceDescriptions() {
    pointer.ctatdebug("getAllInterfaceDescriptions ()");
    var descMessages = "<messages>";
    var builder = new CTATTutoringServiceMessageBuilder;
    var cList = CTATShellTools.getAllComponents();
    for (var i = 0;i < cList.length;i++) {
      var aComponent = cList[i];
      pointer.ctatdebug("Getting component interface description message for: " + aComponent.getName());
      descMessages += builder.createInterfaceDescriptionMessage(aComponent);
      if (aComponent.getConfigurationActions) {
        var cas = aComponent.getConfigurationActions();
        cas.forEach(function(sai) {
          descMessages += builder.createInterfaceActionMessage(CTATGuid.guid(), sai);
        });
      }
    }
    descMessages += "</messages>";
    return descMessages;
  };
  this.sendInterfaceDescriptionMessages = function sendInterfaceDescriptionMessages() {
    pointer.ctatdebug("sendInterfaceDescriptionMessages ()");
    var descMessages = '<?xml version="1.0" encoding="UTF-8"?><message><verb>NotePropertySet</verb><properties><MessageType>MessageBundle</MessageType>';
    descMessages += pointer.getAllInterfaceDescriptions();
    descMessages += "</properties></message>";
    pointer.ctatdebug("Final bundle: " + descMessages);
    commLibrary.sendXMLNoBundle(descMessages);
  };
  this.processSerialization = function processSerialization() {
    pointer.ctatdebug("processSerialization()");
    pointer.setText(this.label);
  };
  this.processComponentAction = function processComponentAction(sai, tutorComponent, behaviorRecord, component, logType, aTrigger) {
    pointer.ctatdebug("processComponentAction(" + sai.getName() + " -> " + sai.getSelection() + "," + sai.getAction() + "," + sai.getInput() + ")");
    this.showFeedback("");
    var transactionID = CTATGuid.guid();
    if (commLoggingLibrary != null) {
      if (gotProblemRestoreEnd) {
        pointer.ctatdebug("We're not in the start state, logging the action ...");
        if (sai.getSelection() == "scrim") {
          ctatdebug("Not logging any scrim actions (for now)");
        } else {
          if (logType != undefined) {
            commLoggingLibrary.logSemanticEvent(transactionID, sai, logType, "", "", "", aTrigger);
          } else {
            if (sai.getSelection() == "hint" || sai.getSelection() == "null.nextButton" || sai.getSelection() == "null.previousButton") {
              commLoggingLibrary.logSemanticEvent(transactionID, sai, "HINT_REQUEST", "", "", "", aTrigger);
            } else {
              commLoggingLibrary.logSemanticEvent(transactionID, sai, "ATTEMPT", "", "", "", aTrigger);
            }
          }
        }
      }
    } else {
      this.ctatdebug("Info: no logging library available!");
    }
    var builder = new CTATTutoringServiceMessageBuilder;
    var tsMessage = "";
    if (tutorComponent !== false && tutorComponent !== CTAT.Component.Base.Tutorable.Options.TutorComponent.DO_NOT_TUTOR) {
      tsMessage = builder.createInterfaceActionMessage(transactionID, sai);
      pointer.propagateShellEvent("InterfaceAction", tsMessage);
    } else {
      tsMessage = builder.createUntutoredActionMessage(transactionID, sai);
      pointer.propagateShellEvent("UntutoredAction", tsMessage);
    }
    commLibrary.sendXML(tsMessage);
    CTAT.SAI && typeof CTAT.SAI.storeForReplay == "function" && CTAT.SAI.storeForReplay(tsMessage);
  };
  this.onEditSuccess = function onEditSuccess(selectedRange) {
    pointer.ctatdebug("onEditSuccess (" + selectedRange + ")");
    if (nameTranslator == null) {
      pointer.ctatdebug("Error: CTAT name translator not available");
      return;
    }
    if (selectedRange.indexOf(":") != -1) {
      pointer.ctatdebug("Bump");
      pointer.showFeedback("You're asking for a hint for multiple cells, please select only a single cell.");
      return;
    } else {
      var mapped = nameTranslator.translateToCTAT(selectedRange);
      pointer.ctatdebug("Info A1 notiation mapped to (if needed): " + mapped);
      var hintSAI = new CTATSAI("hint", "ButtonPressed", mapped);
      pointer.processComponentAction(hintSAI);
      pointer.propagateShellEvent("REQUESTHINT", null);
    }
    pointer.ctatdebug("onEditSuccess () done");
  };
  this.onFailure = function onFailure(error) {
    pointer.ctatdebug("onFailure (" + error.message + ")");
  };
  this.onNOPEditSuccess = function onNOPEditSuccess(selectedRange) {
    pointer.ctatdebug("onNOPEditSuccess (" + selectedRange + ")");
  };
  this.onNOPFailure = function onNOPFailure(error) {
    pointer.ctatdebug("onNOPFailure (" + error.message + ")");
  };
  this.requestHint = function requestHint() {
    pointer.ctatdebug("requestHint(external -> " + CTATConfig.external + ")");
    var hintSAI = null;
    if (CTATConfig.external == "none") {
      pointer.ctatdebug("Calling built-in hint request driver ...");
      if (CTATGlobals.Tab.previousFocus) {
        hintSAI = new CTATSAI("hint", "ButtonPressed", "hint request");
        if (CTATGlobals.Tab.previousFocus.getSAI) {
          hintSAI.addSelection(CTATGlobals.Tab.previousFocus.getSAI().getSelection());
          hintSAI.addAction("PreviousFocus");
        } else {
          pointer.ctatdebug("Current focus is not a CTAT component, can't ask for a hint yet");
        }
      } else {
        pointer.ctatdebug("CTATGlobals.Tab.previousFocus===null");
        hintSAI = new CTATSAI("hint", "ButtonPressed", "hint request");
      }
      this.processComponentAction(hintSAI);
      this.propagateShellEvent("RequestHint", null);
      return;
    }
    pointer.clearFeedbackComponents();
    if (CTATConfig.external == "google") {
      pointer.ctatdebug("Calling google app script hint request driver ...");
      try {
        google.script.run.withSuccessHandler(pointer.onEditSuccess).withFailureHandler(pointer.onFailure).getSheetSelectedRange();
      } catch (err) {
        pointer.ctatdebug("google.script.run: " + err.message);
      }
      return;
    }
    pointer.ctatdebug("'external' has configuration that doesn't match anything: " + CTATConfig.external);
  };
  this.processDone = function processDone(inputValue) {
    pointer.ctatdebug("processDone()");
    if (CTATGlobals.confirmDone === true) {
      CTATScrim.scrim.confirmScrimUp(CTATGlobals.languageManager.getString("SURE_YOU_ARE_DONE"), this.processDoneContinue, this.processDoneCancel);
    } else {
      var doneSAI = new CTATSAI("done", "ButtonPressed", inputValue && typeof inputValue == "string" ? inputValue : "-1");
      pointer.processComponentAction(doneSAI);
    }
  };
  this.processDoneContinue = function processDoneContinue(inputValue) {
    pointer.ctatdebug("processDoneContinue()");
    CTATScrim.scrim.scrimDown();
    var doneSAI = new CTATSAI("done", "ButtonPressed", inputValue && typeof inputValue == "string" ? inputValue : "-1");
    pointer.processComponentAction(doneSAI);
    pointer.propagateShellEvent("DonePressed", null);
  };
  this.processDoneCancel = function processDoneCancel(aResult) {
    pointer.ctatdebug("processDoneCancel()");
    CTATScrim.scrim.scrimDown();
    var transactionID = CTATGuid.guid();
    var doneSAI = new CTATSAI("ConfirmDone", "ButtonPressed", "no");
    commLoggingLibrary.logSemanticEvent(transactionID, doneSAI, "ATTEMPT", "");
  };
  this.processGetURL = function processGetURL(aMessage) {
    pointer.ctatdebug("processGetURL()");
    var cleaner = aMessage.getURL();
    if (cleaner.indexOf("http://") != -1) {
      commLibrary.retrieveFile(aMessage.getURL().substring(7), pointer.processClientBRDLoad);
    } else {
      commLibrary.retrieveFile(aMessage.getURL(), pointer.processClientBRDLoad);
    }
  };
  this.processClientBRDLoad = function processClientBRDLoad(aFile) {
    pointer.ctatdebug("processClientBRDLoad()");
    var url = commLibrary.getURL();
    commLibrary.sendXML("<message><verb>NotePropertySet</verb><properties><MessageType>GetURLResponse</MessageType><URL><![CDATA[ " + url + " ]]\x3e</URL><content><![CDATA[ " + window.btoa(aFile) + " ]]\x3e</content></properties></message>");
  };
  this.processCorrectAction = function processCorrectAction(aMessage) {
    pointer.ctatdebug("processCorrectAction()");
    aMessage.setGradeResult("correct");
    pointer.clearFeedbackComponents();
    if (anonymousGradingProcessor != null) {
      ctatdebug("Calling custom grading processor ...");
      anonymousGradingProcessor("CORRECT", aMessage);
    }
    var sel = aMessage.getSelection();
    if (externalComponents[sel]) {
      if (gradingProcessor != null) {
        gradingProcessor("CORRECT", aMessage);
        this.propagateShellEvent("CORRECT", aMessage);
        return;
      }
    }
    var compList = CTATShellTools.findComponent(sel);
    if (compList != null) {
      ctatdebug("Processing " + compList.length + " components ...");
      for (var t = 0;t < compList.length;t++) {
        ctatdebug("Check " + compList[t].getName());
        if (compList[t]) {
          if (compList[t].setCorrect) {
            compList[t].setCorrect(aMessage);
          }
        } else {
          pointer.ctatdebug("Internal error, component pointer is null");
        }
      }
    } else {
      pointer.ctatdebug("Error: component is null for selection " + sel);
    }
  };
  this.processInCorrectAction = function processInCorrectAction(aMessage) {
    pointer.ctatdebug("processInCorrectAction()");
    aMessage.setGradeResult("incorrect");
    if (anonymousGradingProcessor != null) {
      ctatdebug("Calling custom grading processor ...");
      anonymousGradingProcessor("INCORRECT", aMessage);
    }
    var sel = aMessage.getSelection();
    if (externalComponents[sel]) {
      if (gradingProcessor != null) {
        gradingProcessor("INCORRECT", aMessage);
        return;
      }
    }
    var comp = CTATShellTools.findComponent(sel);
    if (comp !== null) {
      for (var t = 0;t < comp.length;t++) {
        ctatdebug("Calling setIncorrect on component (" + comp[t].getClassName() + ")...");
        if (comp[t].setIncorrect) {
          comp[t].setIncorrect(aMessage);
        }
      }
    } else {
      pointer.ctatdebug("Error: component is null for selection " + sel);
    }
  };
  this.processHighlightMsg = function processHighlightMsg(aMessage) {
    pointer.ctatdebug("processHighlightMsg()");
    var sel = aMessage.getSelection();
    var comp = CTATShellTools.findComponent(sel);
    if (comp != null) {
      for (var t = 0;t < comp.length;t++) {
        if (typeof comp[t].setHintHighlight == "function") {
          comp[t].setHintHighlight(true, aMessage);
        }
      }
    } else {
      pointer.ctatdebug("Error: component is null for selection " + sel);
    }
    this.showFeedback(aMessage.getHighlightMsg());
  };
  this.processUnHighlightMsg = function processUnHighlightMsg(aMessage) {
    pointer.ctatdebug("processUnHighlightMsg()");
    var sel = aMessage.getSelection();
    var comp = CTATShellTools.findComponent(sel);
    if (comp != null) {
      for (var t = 0;t < comp.length;t++) {
        if (typeof comp[t].setHintHighlight == "function") {
          comp[t].setHintHighlight(false, null, aMessage);
        }
      }
    } else {
      pointer.ctatdebug("Error: component is null for selection " + sel);
    }
  };
  this.processAssociatedRules = function processAssociatedRules(aMessage, indicator, advice, studentSelection) {
    var logmsg = "";
    pointer.ctatdebug("processAssociatedRules()");
    if (commMessageHandler.getInStartState() == false) {
      logHintSAI = aMessage.getSAI();
      var semanticEvent = "";
      var evalObj = new CTATActionEvaluationData("");
      pointer.ctatdebug("Found tutor advice: " + advice);
      if (indicator == "Hint" || indicator == "HintWindow") {
        ctatdebug("Preparing log message to indicate a hint response", "commShell");
        evalObj.setCurrentHintNumber(hintIndex + 1);
        evalObj.setTotalHintsAvailable(hints.length);
        evalObj.setEvaluation("HINT");
        semanticEvent = "HINT_MSG";
        if (hints[hintIndex]) {
          advice = hints[hintIndex];
        }
      } else {
        if (aMessage.getIndicator() == "Correct") {
          evalObj.setEvaluation("CORRECT");
        } else {
          evalObj.setEvaluation("INCORRECT");
        }
        semanticEvent = "RESULT";
      }
      ctatdebug("Adding custom field names ...");
      var customFieldNames = new Array;
      var customFieldValues = new Array;
      customFieldNames.push("step_id");
      customFieldValues.push(aMessage.getProperty("StepID"));
      var tutorInput = aMessage.getInput();
      ctatdebug("CTATCommShell.processAssociatedRules() tutorInput: " + tutorInput);
      if (tutorInput) {
        customFieldNames.push("tutor_input");
        customFieldValues.push(tutorInput.toString());
      }
      var ruleNames = aMessage.getRules();
      if (ruleNames) {
        customFieldNames.push("rule_names");
        customFieldValues.push(ruleNames.toString());
      }
      var customFields = aMessage.getCustomFields();
      for (var cfName in customFields) {
        customFieldNames.push(cfName);
        customFieldValues.push(customFields[cfName]);
      }
      var skillObject = aMessage.getSkillsObject();
      pointer.updateSkillWindow(skillObject);
      ctatdebug("Sending log message ...");
      if (commLoggingLibrary != null) {
        if (gotProblemRestoreEnd) {
          logmsg = commLoggingLibrary.logTutorResponse(aMessage.getTransactionID(), logHintSAI, semanticEvent, "", evalObj, advice, skillObject, customFieldNames, customFieldValues);
        } else {
          aMessage.suppressLogging();
        }
      } else {
        this.ctatdebug("Info: no logging library available!");
      }
      if (logHintSAI.getSelection() == "done" && logHintSAI.getAction() == "ButtonPressed") {
        if (aMessage.getIndicator() == "Correct") {
          var problemSummary = commMessageBuilder.createProblemSummaryRequestMessage();
          commLibrary.sendXML(problemSummary, false);
        }
      }
    } else {
      pointer.updateSkillWindow(null);
    }
    var comp = studentSelection && CTATShellTools.findComponent(studentSelection);
    if (comp && comp["length"]) {
      for (var t = 0;t < comp.length;t++) {
        ctatdebug("Calling processAssociatedRules on component (" + comp[t].getClassName() + ")...");
        if (comp[t].processAssociatedRules) {
          comp[t].processAssociatedRules(aMessage, indicator, advice, logmsg);
        }
      }
    }
    pointer.ctatdebug("processAssociatedRules() done");
    return logmsg;
  };
  this.processBuggyMessage = function processBuggyMessage(aMessage) {
    pointer.ctatdebug("processBuggyMessage()");
    this.showFeedback(aMessage.getBuggyMsg());
  };
  this.processSuccessMessage = function processSuccessMessage(aMessage) {
    pointer.ctatdebug("processSuccessMessage()");
    this.showFeedback(aMessage.getSuccessMessage());
  };
  this.processUntutoredAction = function(aMessage, lockWidgetsSetInStartState) {
    pointer.processInterfaceAction(aMessage, lockWidgetsSetInStartState);
  };
  this.processInterfaceAction = function processInterfaceAction(aMessage, lockWidgetsSetInStartState) {
    pointer.ctatdebug('CTATCommShell.processInterfaceAction ("' + aMessage.getMessageType() + '")');
    var trigger = aMessage.getProperty("trigger");
    var subtype = aMessage.getProperty("subtype") || (trigger && trigger.toLowerCase() == "data" ? "tutor-performed" : "");
    if (commLoggingLibrary != null) {
      if (gotProblemRestoreEnd) {
        commLoggingLibrary.logSemanticEvent(aMessage.getTransactionID(), aMessage.getSAI(), "ATTEMPT", subtype);
      } else {
      }
    } else {
      this.ctatdebug("Info: no logging library available!");
    }
    if (aMessage.getSelection() == "root" || aMessage.getSelection() == "_root") {
      pointer.ctatdebug("Info: selection is 'root', we'll call the function straight up ...");
      var pseudoComponent = [window, CTATCommShell.commShell];
      var anAction = aMessage.getAction();
      var anInput = aMessage.getInput();
      for (var i = 0;i < pseudoComponent.length && typeof pseudoComponent[i][anAction] != "function";++i) {
      }
      if (i >= pseudoComponent.length) {
        pointer.ctatdebug("Internal error: unable to find function: " + anAction);
        return;
      }
      pointer.ctatdebug("Calling as: " + anAction + "(" + anInput + ")");
      try {
        pseudoComponent[i][anAction](anInput);
      } catch (err) {
        pointer.ctatdebug("Internal error: unable to execute function: " + err.message);
      }
      return;
    }
    var targetComponent = CTATShellTools.findComponent(aMessage.getSelection());
    if (targetComponent === null) {
      pointer.ctatdebug("Internal error: unable to find pointer to component object");
      return;
    }
    if (targetComponent.length == 0) {
      pointer.ctatdebug("Error: no component found to call interface action on");
      return;
    }
    var nrComponents = targetComponent.length;
    pointer.ctatdebug("Call the action on the component(s) -> (" + nrComponents + ")...");
    for (var t = 0;t < nrComponents;t++) {
      pointer.ctatdebug("About to call " + aMessage.getAction() + " (" + aMessage.getInput() + ") on: " + aMessage.getSelection());
      var target = targetComponent[t];
      if (typeof target.executeSAI == "function") {
        target.executeSAI(aMessage);
      }
      pointer.ctatdebug("Method executed, continuing with post-processing ...");
      if (commMessageHandler.getInStartState() == true) {
        var action = aMessage.getAction() || "";
        if (/^(updatetext|updatecombobox|updatecheckbox)/i.test(action) && !target.getDivWrap().className.includes("CTATTextField")) {
          target.setEnabled(!Boolean(lockWidgetsSetInStartState));
        }
      }
    }
    pointer.ctatdebug("processInterfaceAction() Done");
  };
  this.removeComponent = function(id) {
    CTATTutor.removeComponent(id);
  };
  this.processInterfaceIdentification = function processInterfaceIdentification(aMessage) {
    pointer.ctatdebug("processInterfaceIdentification()");
  };
  this.processAuthorModeChange = function processAuthorModeChange(aMessage) {
    pointer.ctatdebug("processAuthorModeChange()");
  };
  this.processShowHintsMessage = function processShowHintsMessage(aMessage) {
    pointer.ctatdebug("processShowHintsMessage()");
  };
  this.processConfirmDone = function processConfirmDone(aMessage) {
    pointer.ctatdebug("processConfirmDone()");
  };
  this.processVersionInfo = function processVersionInfo(messageProperties) {
    pointer.ctatdebug("processVersionInfo()");
  };
  this.updateLastActionTimestamp = function() {
    if (sessionExpiry) {
      sessionExpiry.updateLastActionTimestamp();
    }
  };
  this.processTutoringServiceAlert = function processTutoringServiceAlert(messageProperties) {
    pointer.ctatdebug("processTutoringServiceAlert()");
    var aTitle = "";
    var aMessage = "";
    for (var t = 0;t < messageProperties.length;t++) {
      var propNode = messageProperties[t];
      if (messageParser.getElementName(propNode) == "ErrorType") {
        aTitle = messageParser.getNodeTextValue(propNode);
      }
      if (messageParser.getElementName(propNode) == "Details") {
        aMessage = messageParser.getNodeTextValue(propNode);
      }
    }
    CTATScrim.scrim.scrimUp(aMessage);
  };
  this.processTutoringServiceError = function processTutoringServiceError(aMessage) {
    pointer.ctatdebug("processTutoringServiceError()");
    var aTitle = aMessage.getProperty("ErrorType");
    var details = aMessage.getProperty("Details");
    CTATScrim.scrim.scrimDown();
    CTATScrim.scrim.errorScrimUp(aTitle + " - " + details);
  };
  this.processProblemSummaryResponse = function processProblemSummaryResponse(aMessage, iscb) {
    pointer.ctatdebug("processProblemSummaryResponse() iscb " + iscb);
    if (commLoggingLibrary && !iscb) {
      commLoggingLibrary.then(pointer.processProblemSummaryResponse(aMessage, true));
      return;
    }
    if (CTATLMS.processProblemSummary) {
      CTATLMS.processProblemSummary(aMessage.getXMLObject());
    }
    if (CTATLMS.closeLMSConnection) {
      CTATLMS.closeLMSConnection();
    }
    if (summaryRequestCallback != null) {
      var problemXML = aMessage.getXMLObject();
      var problemRaw = problemXML.getElementsByTagName("ProblemSummary");
      var scorm_lesson_status_raw = problemXML.getElementsByTagName("cmi.core.lesson_status");
      var scorm_score_raw = problemXML.getElementsByTagName("cmi.core.score.raw");
      var scorm_exit_raw = problemXML.getElementsByTagName("cmi.core.exit");
      var scorm_session_time_raw = problemXML.getElementsByTagName("cmi.core.session_time");
      var problemStr = $("<div>").html(problemRaw[0].innerHTML).text();
      var scorm_lesson_status = "<cmi.core.lesson_status>" + $("<div>").html(scorm_lesson_status_raw[0].innerHTML).text() + "</cmi.core.lesson_status>";
      var scorm_score = "<cmi.core.score.raw>" + $("<div>").html(scorm_score_raw[0].innerHTML).text() + "</cmi.core.score.raw>";
      var scorm_exit = "<cmi.core.exit>" + $("<div>").html(scorm_exit_raw[0].innerHTML).text() + "</cmi.core.exit>";
      var scorm_session_time = "<cmi.core.session_time>" + $("<div>").html(scorm_session_time_raw[0].innerHTML).text() + "</cmi.core.session_time>";
      summaryRequestCallback(problemStr, "<scorm>" + scorm_lesson_status + scorm_score + scorm_exit + scorm_session_time + "</scorm>");
      summaryRequestCallback = null;
      return;
    }
    var generator = new CTATXML;
    if (doneProcessor != null) {
      doneProcessor(generator.xmlToString(aMessage.getXMLObject()), commLMSService.sendSummary.bind(commLMSService, aMessage));
    } else {
      commLMSService.sendSummary(aMessage);
    }
  };
  this.setGotProblemRestoreEnd = function(gotit) {
    gotProblemRestoreEnd = gotit;
  };
  this.getGotProblemRestoreEnd = function() {
    return gotProblemRestoreEnd;
  };
  this.processProblemRestoreEnd = function processProblemRestoreEnd(aMessage) {
    pointer.ctatdebug("processProblemRestoreEnd() scrimIsUp " + scrimIsUp);
    gotProblemRestoreEnd = true;
    if (pointer.getCommLibrary()) {
      pointer.getCommLibrary().sendTutorReady();
    }
    if (!pointer.hasTutorShopCable()) {
      CTATScrim.scrim.scrimDown();
    }
  };
  this.hasTutorShopCable = function() {
    var customFields = CTATConfiguration.getCustomFields();
    return CTATLMS.is.TutorShop() && customFields && customFields["Team ID"];
  };
  this.clearFeedbackComponents = function clearFeedbackComponents() {
    pointer.ctatdebug("clearFeedbackComponents ()");
    CTATShellTools.showHints(null);
  };
  this.processHintResponse = function processHintResponse(aMessage, aHintArray) {
    pointer.ctatdebug("processHintResponse()");
    unhighlightall();
    CTATShellTools.showHints(aHintArray);
    var highlightSAI = aMessage.getSAI();
    if (highlightSAI != null) {
      var highlightSelection = highlightSAI.getSelection();
      if (highlightSelection != null) {
        pointer.ctatdebug("Highlighting selection for hint: " + highlightSelection);
        var aComponent = CTATShellTools.findComponent(highlightSelection);
        if (aComponent != null) {
          for (var t = 0;t < aComponent.length;t++) {
            if (CTATCommShell.detailedFeedback == true) {
              if (typeof aComponent[t].setHintHighlight == "function") {
                aComponent[t].setHintHighlight(true, aMessage);
              }
            }
          }
        } else {
          pointer.ctatdebug("Unable to find component name in list: " + aComponent);
        }
      } else {
        pointer.ctatdebug("Error: no highlight selection present in SAI");
      }
    } else {
      pointer.ctatdebug("Warning: no SAI found in highlight message");
    }
    CTATCommShell.detailedFeedback = true;
    pointer.ctatdebug("processHintResponse() done");
  };
  this.showHighlightSelection = function showHighlightSelection(highlightSelection, aMessage) {
    pointer.ctatdebug("showHighlightSelection (" + highlightSelection + ")");
    var aComponent = CTATShellTools.findComponent(highlightSelection);
    if (aComponent != null) {
      for (var t = 0;t < aComponent.length;t++) {
        if (CTATCommShell.detailedFeedback == true) {
          if (t === 0) {
            if (aComponent[t].moveHintHightlight) {
              aComponent[t].moveHintHighlight(true, aMessage);
            }
          } else {
            if (aComponent[t].setHintHighlight) {
              aComponent[t].setHintHighlight(true, aMessage);
            }
          }
        }
      }
    } else {
      pointer.ctatdebug("Unable to find component name in list: " + aComponent);
    }
  };
  this.globalReset = function globalReset() {
    pointer.ctatdebug("globalReset ()");
    CTATMessageHandler.scriptElement = "";
  };
  this.nextProblem = function nextProblem(aMessage) {
    pointer.ctatdebug("nextProblem ()");
    if (CTATGlobalFunctions.isBlank(aMessage)) {
      pointer.ctatdebug("Message is blank, requesting next problem ...");
      var vars = flashVars.getRawFlashVars();
      var url = vars["run_problem_url"];
      commLibrary.send(url);
    } else {
      pointer.ctatdebug("Message contains html data, writing ...");
      try {
        document.close();
      } catch (err) {
        alert("Error closing document: " + err.message);
      }
      try {
        document.write(aMessage);
      } catch (err$10) {
        alert("Error writing document: " + err$10.message);
      }
    }
  };
  this.updateSkillWindow = function updateSkillWindow(aNewSkillObject) {
    pointer.ctatdebug("updateSkillWindow()");
    CTATSkillSet.skills.untouchSkills();
    var skillWindow = CTATShellTools.findComponentByClass("CTATSkillWindow");
    if (skillWindow !== null) {
      if (aNewSkillObject != null) {
        skillWindow.updateSkillSet(aNewSkillObject);
      } else {
        skillWindow.drawComponent();
      }
    } else {
      pointer.ctatdebug("Info: no skill window available");
    }
  };
  this.processComponentFocus = function processComponentFocus(aComponent) {
    pointer.ctatdebug("processComponentFocus(" + aComponent.getName() + "," + aComponent.getClassName() + ")");
    if (aComponent.getClassName() == "CTATTextInput" || aComponent.getClassName() == "CTATTextField" || aComponent.getClassName() == "CTATTextArea") {
      CTATGlobals.selectedTextInput = aComponent;
      if (mobileAPI !== null) {
        if (mobileAPI.getEnabled() === true) {
          mobileAPI.processTextFocus(aComponent.getX(), aComponent.getY(), aComponent.getWidth(), aComponent.getHeight());
        }
      }
    } else {
      CTATGlobals.selectedTextInput = null;
    }
    pointer.ctatdebug("processComponentFocus() done");
  };
  this.showFeedback = function showFeedback(aMessage) {
    if (aMessage == null || aMessage == undefined || !/\S/.test(aMessage) || aMessage == " ") {
      pointer.ctatdebug("showFeedback(): False alarm: empty message. This can happen when the commshell is trying to clear the hint window and there is no hint window.");
      return;
    } else {
      pointer.ctatdebug("showFeedback(" + aMessage + ") -> l: " + aMessage.length);
    }
    CTATShellTools.showFeedback(aMessage);
    if (feedbackProcessor != null) {
      feedbackProcessor(aMessage);
    }
  };
  this.assignFeedbackHandler = function assignFeedbackHandler(aHandler) {
    pointer.ctatdebug("assignFeedbackHandler()");
    feedbackProcessor = aHandler;
  };
  this.gradeSAI = function gradeSAI(aSelection, anAction, anInput) {
    pointer.ctatdebug("gradeSAI()");
    externalComponents[aSelection] = anInput;
    var anSAI = new CTATSAI(aSelection, anAction, anInput);
    pointer.processComponentAction(anSAI, true, true);
  };
  this.assignGradingHandler = function assignGradingHandler(aHandler) {
    pointer.ctatdebug("assignGradingHandler()");
    gradingProcessor = aHandler;
  };
  this.assignAnonymousGradingProcessor = function assignAnonymousGradingProcessor(aFunction) {
    anonymousGradingProcessor = aFunction;
  };
  this.assignDoneProcessor = function assignDoneProcessor(aProcessor) {
    doneProcessor = aProcessor;
  };
  this.addEventListener = function addEventListener(anEvent, aCallback) {
    eventListeners[anEvent] = Callback;
  };
  this.addGlobalEventListener = function addGlobalEventListener(aListenerComponent) {
    pointer.ctatdebug("addGlobalEventListener( " + aListenerComponent + ")");
    if (aListenerComponent) {
      eventListenersGlobal.push(aListenerComponent);
    }
  };
  this.sendToTools = function(aMessage) {
    if (commLibrary) {
      commLibrary.sendToToolsOrCollaborators(commLibrary.getURL(), aMessage, false);
    }
  };
  this.closeWSConnection = function(aUrl, opt_cbk, reason) {
    var connection = commLibrary.findWSConnection(aUrl);
    if (connection) {
      connection.close(reason, opt_cbk);
    } else {
      console.warn("connection not found");
    }
  };
};
CTATCommShell.prototype = Object.create(CTATBase.prototype);
CTATCommShell.prototype.constructor = CTATCommShell;
CTATCommShell.commShell = null;
CTATCommShell.detailedFeedback = true;
function enableDetailedFeedback(aValue) {
  CTATCommShell.detailedFeedback = aValue;
}
;goog.provide("CTATComponentReference");
CTATComponentReference = function(aRef, aDiv) {
  var compReference = aRef;
  var div = aDiv;
  this.setElement = function setElement(aComponent) {
    compReference = aComponent;
  };
  this.getElement = function getElement() {
    return compReference;
  };
  this.setDiv = function setDiv(aDiv) {
    div = aDiv;
  };
  this.getDiv = function getDiv() {
    return div;
  };
};
CTATComponentReference.components = {};
CTATComponentReference.list = function() {
  for (var comp in CTATComponentReference.components) {
    var ref = CTATComponentReference.components[comp];
    ctatdebug("Component: " + ref.getElement().getName() + ", with div: " + ref.getDiv().id);
  }
};
CTATComponentReference.getComponentFromID = function(anId) {
  var components = CTATComponentReference.components;
  if (components.hasOwnProperty(anId)) {
    var ref = components[anId];
    if (!ref.getElement()) {
      return null;
    }
    return ref.getElement();
  }
  return null;
};
CTATComponentReference.add = function(aComponent, aDiv) {
  var ref = new CTATComponentReference(aComponent, aDiv);
  CTATComponentReference.components[ref.getDiv().getAttribute("id")] = ref;
  return ref;
};
goog.provide("CTATCompBase");
goog.require("CTATBase");
goog.require("CTATCommShell");
goog.require("CTATComponentReference");
goog.require("CTATConfig");
goog.require("CTATGlobalFunctions");
goog.require("CTATGlobals");
goog.require("CTATSandboxDriver");
CTATCompBase = function(aClassName, aName, aX, aY, aWidth, aHeight) {
  CTATBase.call(this, aClassName, aName);
  var x = aX || 0;
  var y = aY || 0;
  var width = aWidth || -2;
  var height = aHeight || -2;
  var defaultWidth = 50;
  var defaultHeight = 25;
  var abstractComponent = false;
  var isFeedbackComponent = false;
  var text = "";
  var initialized = false;
  var enabled = true;
  var divWrapper = null;
  var componentGroup = "";
  var tabIndex = null;
  this.isTabIndexable = true;
  var zIndex = 0;
  var component = null;
  var pointer = this;
  var subCanvas = null;
  var canvasVisible = "hidden";
  var topDivZIndex = CTATGlobalFunctions.gensym.z_index();
  var topDivID = CTATGlobalFunctions.gensym.div_id();
  var canvasZIndex = CTATGlobalFunctions.gensym.z_index();
  var canvasID = CTATGlobalFunctions.gensym.div_id();
  this.setIsAbstractComponent = function(aValue) {
    abstractComponent = aValue;
  };
  this.isAbstractComponent = function() {
    return abstractComponent;
  };
  this.setIsFeedbackComponent = function(aValue) {
    isFeedbackComponent = aValue;
  };
  this.isFeedbackComponent = function() {
    return isFeedbackComponent;
  };
  this.setTabIndex = function(aValue) {
    if (this.isTabIndexable === true) {
      tabIndex = aValue;
      if (tabIndex < 0) {
        tabIndex = CTATGlobals.Tab.Tracker;
        CTATGlobals.Tab.Tracker++;
      } else {
        CTATGlobals.Tab.Tracker = tabIndex;
      }
    } else {
      tabIndex = -1;
    }
  };
  this.getTabIndex = function() {
    return tabIndex || this.getComponent().getAttribute("tabindex");
  };
  this.setZIndex = function setZIndex(aValue) {
    pointer.ctatdebug("Setting z index to: " + aValue);
    zIndex = aValue;
    if (divWrapper !== null) {
      divWrapper.style.zIndex = aValue;
    }
  };
  this.getZIndex = function getZIndex() {
    return zIndex;
  };
  this.setDefaultWidth = function setDefaultWidth(aValue) {
    defaultWidth = aValue;
  };
  this.getDefaultWidth = function getDefaultWidth() {
    return defaultWidth;
  };
  this.setDefaultHeight = function setDefaultHeight(aValue) {
    defaultHeight = aValue;
  };
  this.getDefaultHeight = function getDefaultHeight() {
    return defaultHeight;
  };
  this.processCommShellEvent = function processCommShellEvent(anEvent, aMessage) {
    pointer.ctatdebug("processCommShellEvent (" + anEvent + ")");
  };
  this.makeDivWrapper = function(topDiv) {
    divWrapper = document.createElement("div");
    divWrapper.id = this.getName();
    divWrapper.setAttribute("onkeypress", "return noenter(event)");
    divWrapper.setAttribute("data-ctat-component", this.getClassName());
    divWrapper.style.position = "absolute";
    divWrapper.style.left = x + "px";
    divWrapper.style.top = y + "px";
    divWrapper.style.zIndex = topDivZIndex;
    divWrapper.style.width = pointer.getWidth() + "px";
    divWrapper.style.height = pointer.getHeight() + "px";
    $(divWrapper).data("CTATComponent", this);
    topDiv.appendChild(divWrapper);
  };
  this.setDivWrapper = function(aDiv) {
    if (divWrapper = aDiv) {
      divWrapper.setAttribute("data-ctat-component", this.getClassName());
    }
  };
  var super_setClassName = this.setClassName;
  this.setClassName = function(sClassName) {
    super_setClassName(sClassName);
    if (divWrapper) {
      divWrapper.setAttribute("data-ctat-component", this.getClassName());
    }
  };
  this.wrapComponent = function wrapComponent(topDiv) {
    pointer.ctatdebug("wrapComponent ()");
    pointer.makeDivWrapper(topDiv);
    pointer.ctatdebug("wrapComponent () done");
  };
  this.createCanvas = function() {
    pointer.ctatdebug("createCanvas ()");
    subCanvas = document.createElement("canvas");
    subCanvas.setAttribute("id", canvasID);
    subCanvas.setAttribute("onkeypress", "return noenter(event)");
    subCanvas.setAttribute("width", width + canvasCalibrate + "px");
    subCanvas.setAttribute("height", height + canvasCalibrate + "px");
    subCanvas.setAttribute("style", "border: 1px " + this.borderColor + " solid; " + (canvasVisible == "hidden" ? "visibility: hidden; " : "") + "z-index:" + canvasZIndex + ";");
    if (divWrapper.firstChild) {
      divWrapper.insertBefore(subCanvas, divWrapper.firstChild);
    } else {
      divWrapper.appendChild(subCanvas);
    }
    return subCanvas;
  };
  this.redraw = function redraw() {
    var temp = divWrapper.style.display;
    divWrapper.style.display = "none";
    var redrawFix = divWrapper.offsetHeight;
    divWrapper.style.display = temp;
  };
  this.setCanvasVisibility = function setCanvasVisibility(anAttrib) {
    canvasVisible = anAttrib;
  };
  this.getSubCanvasCtx = function getSubCanvasCtx() {
    if (subCanvas) {
      return subCanvas.getContext("2d");
    }
    return undefined;
  };
  this.getSubCanvas = function getSubCanvas() {
    return subCanvas;
  };
  this.getX = function getX() {
    return x;
  };
  this.getY = function getY() {
    return y;
  };
  this.getWidth = function getWidth() {
    if (width <= 0) {
      var cstyle;
      if (component) {
        cstyle = window.getComputedStyle(component);
      } else {
        if (divWrapper) {
          cstyle = window.getComputedStyle(divWrapper);
        }
      }
      if (cstyle) {
        return parseFloat(cstyle.width);
      }
    }
    return width;
  };
  this.getHeight = function getHeight() {
    if (height <= 0 && divWrapper) {
      var cstyle = window.getComputedStyle(divWrapper);
      return parseFloat(cstyle.getPropertyValue("height"));
    }
    return height;
  };
  this.getText = function getText() {
    return text;
  };
  this.getEnabled = function getEnabled() {
    return enabled;
  };
  this.assignEnabled = function assignEnabled(aValue) {
    enabled = aValue;
    divWrapper.setAttribute("data-ctat-enabled", enabled);
  };
  this.setEnabled = function(aValue) {
    pointer.ctatdebug("setEnabled (" + aValue + ")");
    pointer.assignEnabled(aValue);
    if (!component) {
      pointer.ctatdebug("Error: component pointer is null");
      return;
    }
    component.disabled = !enabled;
  };
  this.lock = function() {
    this.setEnabled(false);
  };
  this.unlock = function() {
    this.setEnabled(true);
  };
  this.getDivWrap = function getDivWrap() {
    return divWrapper;
  };
  this.getComponent = function getComponent() {
    return component;
  };
  this.component = null;
  Object.defineProperty(this, "component", {get:function() {
    return component;
  }});
  this.getCanvasZIndex = function getCanvasZIndex() {
    return canvasZIndex;
  };
  this.getComponentGroup = function getComponentGroup() {
    return componentGroup;
  };
  this.setComponent = function setComponent(aComponent) {
    component = aComponent;
    this.setEnabled(this.getEnabled());
  };
  this.getTopDivZIndex = function() {
    return topDivZIndex;
  };
  this.getTopDivID = function() {
    return topDivID;
  };
  this.setComponentGroup = function setComponentGroup(aGroup) {
    componentGroup = aGroup;
    if (component) {
      component.name = aGroup;
    }
  };
  this.assignText = function assignText(aText) {
    text = aText;
  };
  this.init = function init() {
    pointer.ctatdebug("THIS IS THE BASE INIT METHOD");
  };
  this.initialize = function() {
    pointer.ctatdebug("initialize ()");
    pointer.configFromDescription();
    pointer.init();
    pointer.processSerialization();
    pointer.render();
    pointer.processTabOrder();
    pointer.ctatdebug("initialize () done");
  };
  this.getInitialized = function getInitialized() {
    return initialized;
  };
  this.setInitialized = function setInitialized(aInitialized) {
    pointer.ctatdebug("setInitialized (" + aInitialized + ")");
    initialized = aInitialized;
    if (initialized === true && !divWrapper) {
      pointer.ctatdebug("Wrapping a component and appending it to the top container div if one was never set ...");
      var aClip = findPointOfAttachment(this.getName());
      if (aClip) {
        pointer.ctatdebug("Attaching component to existing MovieClip ...");
        pointer.wrapComponent(aClip.getDivWrapper());
      } else {
        pointer.ctatdebug("Attaching component to main div ...");
        var $ctatcontainer = $("#" + ctatcontainer);
        if ($ctatcontainer.length > 0) {
          pointer.wrapComponent(getSafeElementById(ctatcontainer));
        }
      }
    } else {
      pointer.ctatdebug("Not wrapping, initialized=" + initialized + ", divWrapper = " + divWrapper);
    }
    pointer.getDivWrap().classList.add("CTATComponent");
    pointer.ctatdebug("setInitialized () done");
  };
  this.addSafeEventListener = function addSafeEventListener(aType, aFunction, aTarget) {
    pointer.ctatdebug("addSafeEventListener (" + aType + ")");
    pointer.ctatdebug("Adding event listener to: " + aTarget);
    if (aTarget) {
      aTarget.addEventListener(aType, aFunction);
      return;
    }
    if (component) {
      pointer.ctatdebug("Adding eventlistener to component instead of target");
      component.addEventListener(aType, aFunction);
    } else {
      pointer.ctatdebug("Error: pointer to component is null, can't add event listener");
    }
    pointer.ctatdebug("addSafeEventListener () done");
  };
  function getKey(e) {
    var key;
    if (CTATConfig.platform == "google") {
      return 0;
    }
    if (window.event) {
      key = window.event.keyCode;
    } else {
      key = e.which;
    }
    return key;
  }
  this.drawComponent = function drawComponent() {
  };
  this.addComponentReference = function addComponentReference(aComponent, aDiv) {
    pointer.ctatdebug("addComponentReference (" + aComponent.getName() + " -> " + aDiv.getAttribute("id") + ")");
    CTATComponentReference.add(aComponent, aDiv);
    pointer.ctatdebug("addComponentReference ()");
  };
  this.getComponentFromID = function getComponentFromID(anID) {
    return CTATComponentReference.getComponentFromID(anID);
  };
  this.processSerialization = function processSerialization() {
    pointer.ctatdebug("processSerialization()");
    pointer.ctatdebug("implement in child class");
  };
  this.move = function(newX, newY) {
    x = Number(newX);
    y = Number(newY);
    if (newY === undefined || newY === null || isNaN(y)) {
      if (newX.indexOf(",") >= 0) {
        var split = newX.split(",");
        x = Number(split[0]);
        y = Number(split[1]);
      } else {
        y = 0;
      }
    }
    x = isNaN(x) ? 0 : x;
    y = isNaN(y) ? 0 : y;
    if (divWrapper) {
      divWrapper.style.left = x + "px";
      divWrapper.style.top = y + "px";
    }
  };
  this.setSize = function setSize(w, h) {
    var width = Number(w);
    var height = Number(h);
    if (h === undefined || h === null || isNaN(height)) {
      if (w.indexOf(",") >= 0) {
        var split = w.split(",");
        width = Number(split[0]);
        height = Number(split[1]);
      }
    }
    pointer.ctatdebug("setSize (" + width + "," + height + ")");
    if (!isNaN(width)) {
      pointer.setWidth(width);
    }
    if (!isNaN(height)) {
      pointer.setHeight(height);
    }
  };
  this.setVisible = function setVisible(aValue) {
    var vis = CTATGlobalFunctions.toBoolean(aValue);
    if (vis === true) {
      canvasVisible = "block";
    } else {
      canvasVisible = "hidden";
    }
    if (subCanvas) {
      subCanvas.setAttribute("style", "border: 0px; position: absolute; " + (vis ? "" : "visibility:hidden; ") + "; left:" + x + "px; top:" + y + "px; z-index:" + canvasZIndex + ";");
    }
    if (vis === true) {
      divWrapper.style.visibility = "unset";
    } else {
      divWrapper.style.visibility = "hidden";
    }
  };
  this.SetVisible = this.setVisible;
  this.FadeIn = function(fadeTime) {
    pointer.SetVisible(true);
  };
  this.FadeOut = function(fadeTime) {
    pointer.SetVisible(false);
  };
  this.reset = function reset() {
  };
  this.setX = function setX(newX) {
    this.x = newX;
    divWrapper.style.left = this.x + "px";
    if (initialized === true) {
      this.render();
    }
  };
  this.setY = function setY(newY) {
    this.y = newY;
    divWrapper.style.top = this.y + "px";
    if (initialized === true) {
      this.render();
    }
  };
  this.setWidth = function setWidth(newWidth) {
    pointer.ctatdebug("setWidth (" + newWidth + ")");
    width = newWidth;
    if (divWrapper) {
      divWrapper.style.width = width + "px";
    } else {
      pointer.ctatdebug("Internal error: no div wrapper available to set width");
    }
  };
  this.setHeight = function setHeight(newHeight) {
    pointer.ctatdebug("setHeight (" + newHeight + ")");
    height = newHeight;
    if (divWrapper) {
      divWrapper.style.height = height + "px";
    } else {
      pointer.ctatdebug("Internal error: no div wrapper available to set height");
    }
  };
  this.setText = function setText(aText) {
    text = aText;
    return this;
  };
  this.getValue = function getValue() {
    if (component) {
      return component.value;
    }
    return "";
  };
  this.backgrade = false;
  this.unHighlightAll = function unHighlightAll() {
    $(".CTAT--hint").each(function() {
      var $entity = $(this);
      var comp = null;
      while ($entity.length > 0 && comp === null) {
        if ($entity.data("CTATComponent")) {
          comp = $entity.data("CTATComponent");
        } else {
          $entity = $entity.parent();
        }
      }
      if (comp && comp.setHintHighlight) {
        comp.setHintHighlight(false, null);
      }
    });
  };
  this.processOnFocus = function processOnFocus() {
    pointer.ctatdebug("processOnFocus (" + pointer.getName() + ")");
    CTATGlobals.Tab.previousFocus = CTATGlobals.Tab.Focus;
    if (CTATGlobals.Tab.Focus != pointer) {
      pointer.ctatdebug("CTATGlobals.Tab.Focus!=pointer, updating CTATGlobals.Tab.Focus ...");
      CTATGlobals.Tab.Focus = pointer;
    } else {
      pointer.ctatdebug("CTATGlobals.Tab.Focus==pointer");
    }
    pointer.ctatdebug("processOnFocus () done");
  };
  this.processFocus = function processFocus(e) {
    pointer.ctatdebug("processFocus ()");
    var comp = pointer;
    pointer.ctatdebug("***processFocus(", e, "): comp.getName ", pointer && typeof pointer.getName == "function" ? pointer.getName() : pointer, "\n  CTATGlobals.Tab.Focus ", CTATGlobals.Tab.Focus && typeof CTATGlobals.Tab.Focus.getName == "function" ? CTATGlobals.Tab.Focus.getName() : CTATGlobals.Tab.Focus, "\n  CTATGlobals.Tab.Focus.isCorrect ", CTATGlobals.Tab.Focus && typeof CTATGlobals.Tab.Focus.isCorrect == "function" ? CTATGlobals.Tab.Focus.isCorrect() : "no isCorrect", "\n  CTATGlobals.Tab.Focus == comp ", 
    CTATGlobals.Tab.Focus == pointer, "\n  CTATGlobals.Tab.Focus.backgrade ", CTATGlobals.Tab.Focus && typeof CTATGlobals.Tab.Focus.backgrade != "undefined" ? CTATGlobals.Tab.Focus.backgrade : "no backgrade", "\n  comp.getClassName ", pointer && typeof pointer.getClassName == "function" ? pointer.getClassName() : pointer, "\n  CTATGlobals.Tab.previousFocus ", CTATGlobals.Tab.previousFocus);
    if (!comp) {
      pointer.ctatdebug("Error: component reference is null");
      return;
    }
    if (mobileAPI) {
      if (mobileAPI.getEnabled() === true) {
        pointer.hideKeyboard();
      }
    }
    if (CTATCommShell.commShell) {
      CTATCommShell.commShell.processComponentFocus(comp);
    }
    if (CTATGlobals.Tab.Focus) {
      pointer.ctatdebug("old focus: " + CTATGlobals.Tab.Focus.getName() + ", new focus:" + comp.getName() + ", correct: " + CTATGlobals.Tab.Focus.isCorrect());
      if (CTATGlobals.Tab.Focus.isCorrect() == true) {
        pointer.ctatdebug("Previous focus is a correct component, don't backgrade!");
        return;
      }
      if (CTATGlobals.Tab.Focus == comp) {
        pointer.ctatdebug("We're already there!");
        return;
      }
      if (CTATGlobals.Tab.Focus.backgrade) {
        CTATGlobals.Tab.Focus.processAction();
      }
    } else {
      pointer.ctatdebug("No previously focused component yet, can't grade");
    }
    if (comp.getClassName() == "hint" || comp.getClassName() == "CTATHintButton") {
      pointer.ctatdebug("Info: focus moved to hint, bump");
      return;
    } else {
      CTATGlobals.Tab.previousFocus = CTATGlobals.Tab.Focus;
      CTATGlobals.Tab.Focus = comp;
    }
    pointer.ctatdebug("processFocus () done");
  };
  this.processTabOrder = function processTabOrder() {
    pointer.ctatdebug("processTabOrder (" + tabIndex + ")");
    if (abstractComponent === true) {
      pointer.ctatdebug("Component is an abstract component, bump");
      return;
    }
    if (component) {
      pointer.ctatdebug("We have a component, actually assigning to html component ...");
      if (tabIndex !== null) {
        component.tabIndex = tabIndex;
      }
      component.onfocus = pointer.processOnFocus;
    } else {
      pointer.ctatdebug("Error: we don't have an html component yet, can't assign tab index");
    }
  };
  this.hideKeyboard = function hideKeyboard() {
    document.activeElement.blur();
    $("input").blur();
  };
};
CTATCompBase.prototype = Object.create(CTATBase.prototype);
CTATCompBase.prototype.constructor = CTATCompBase;
goog.provide("CTATCSS");
CTATCSS = function() {
  var currPair = 0;
  var attributeValuePairs = [];
  var currSelector = 0;
  var selectorAttributes = [];
  var currStr = 0;
  var cssStringArray = [];
  this.resetSelectors = function resetSelectors() {
    currSelector = 0;
    selectorAttributes = [];
    selectorAttributes[currSelector] = [];
  };
  this.resetCSSStringArray = function resetCSSStringArray() {
    cssStringArray = [];
    currStr = 0;
  };
  this.clearCSS = function clearCSS() {
    this.resetSelectors();
    this.resetCSSStringArray();
    attributeValuePairs = [];
    currPair = 0;
  };
  this.addStringCSS = function addStringCSS(str) {
    cssStringArray[currStr] = str;
    currStr++;
  };
  this.addCSSAttribute = function addCSSAttribute(attribute, value) {
    attributeValuePairs[currPair] = attribute;
    attributeValuePairs[currPair + 1] = value;
    currPair += 2;
  };
  this.removeStringCSS = function removeStringCSS(str) {
    var index = cssStringArray.indexOf(str);
    if (index >= 0) {
      cssStringArray.splice(index, 1);
    }
  };
  this.removeCSSAttribute = function removeCSSAttribute(attribute) {
    var index = attributeValuePairs.indexOf(attribute);
    if (index >= 0) {
      attributeValuePairs.splice(index, 2);
    }
  };
  this.modifyCSSAttribute = function modifyCSSAttribute(attribute, value) {
    var attribIndex = attributeValuePairs.indexOf(attribute);
    if (attribIndex == -1) {
      this.addCSSAttribute(attribute, value);
      return;
    }
    attributeValuePairs[attribIndex + 1] = value;
  };
  this.addSelector = function addSelector(selector) {
    selectorAttributes[currSelector] = [];
    selectorAttributes[currSelector][0] = selector;
    currSelector++;
  };
  function getSelectorIndex(sel) {
    if (currSelector === 0) {
      return 0;
    }
    for (var i = 0;i < selectorAttributes.length;i++) {
      if (selectorAttributes[i][0] === null) {
        return -1;
      }
      if (selectorAttributes[i][0] == sel) {
        return i;
      }
    }
    return -1;
  }
  this.addSelectorAttribute = function addSelectorAttribute(selector, attribute, value) {
    var j = 1;
    var selectorIndex = getSelectorIndex(selector);
    while (selectorAttributes[selectorIndex][j] !== undefined) {
      j++;
    }
    selectorAttributes[selectorIndex][j] = attribute;
    selectorAttributes[selectorIndex][j + 1] = value;
  };
  this.toCSSString = function toCSSString() {
    var cssString = "";
    var doesNeedPixels = false;
    for (var i = 0;i < selectorAttributes.length;i++) {
      cssString += selectorAttributes[i][0] + " { ";
      for (var j = 1;j < selectorAttributes[i].length;j++) {
        cssString += selectorAttributes[i][j];
        if (j % 2 === 0) {
          cssString += "; ";
        } else {
          cssString += ": ";
        }
      }
      cssString += " }; ";
    }
    for (var k = 0;k < attributeValuePairs.length;k++) {
      cssString += attributeValuePairs[k];
      if (k % 2 === 0) {
        cssString += ": ";
      } else {
        cssString += "; ";
      }
    }
    for (var c = 0;c < cssStringArray.length;c++) {
      cssString += cssStringArray[c] + " ";
    }
    return cssString;
  };
};
goog.provide("CTAT.Component.Base.Style");
goog.require("CTATCompBase");
goog.require("CTATCSS");
CTAT.Component.Base.Style = function(aClassName, aName, aX, aY, aWidth, aHeight) {
  CTATCompBase.call(this, aClassName, aName, aX, aY, aWidth, aHeight);
  var componentStyle = new CTATCSS;
  this.addCSSAttribute = function addCSSAttribute(attrib, val) {
    componentStyle.addCSSAttribute(attrib, val);
    this.render();
  };
  this.removeCSSAttribute = function(attrib) {
    componentStyle.removeCSSAttribute(attrib);
    this.render();
  };
  this.addStringCSS = function addStringCSS(str) {
    componentStyle.addStringCSS(str);
    this.render();
  };
  this.removeStringCSS = function(str) {
    componentStyle.removeStringCSS(str);
    this.render();
  };
  this.modifyCSSAttribute = function modifyCSSAttribute(attrib, val) {
    componentStyle.modifyCSSAttribute(attrib, val);
    this.render();
  };
  this.getCSS = function getCSS() {
    return componentStyle.toCSSString();
  };
  this.render = function() {
    if (this.isAbstractComponent() === true) {
      this.ctatdebug("Component is an abstract component, bump");
      return;
    }
    if (this.getInitialized()) {
      var component = this.getComponent();
      if (component) {
        this.ctatdebug(componentStyle.toCSSString());
      } else {
        this.ctatdebug("Internal error, html component not available for rendering");
      }
    }
  };
  this.setStyleAll = function setStyleAll(aStyle, aValue) {
    if (this.getSubCanvas()) {
      this.getSubCanvas().setAttribute(aStyle, aValue);
    }
    this.modifyCSSAttribute(aStyle, aValue);
  };
};
CTAT.Component.Base.Style.prototype = Object.create(CTATCompBase.prototype);
CTAT.Component.Base.Style.prototype.constructor = CTAT.Component.Base.Style;
goog.provide("CTAT.Component.Base.Graphical");
goog.require("CTAT.Component.Base.Style");
goog.require("CTATComponentDescription");
goog.require("CTATGlobals");
goog.require("CTATGlobalFunctions");
CTAT.Component.Base.Graphical = function(aClassName, aName, aDescription, aX, aY, aWidth, aHeight) {
  CTAT.Component.Base.Style.call(this, aClassName, aName, aX, aY, aWidth, aHeight);
  var grDescription = aDescription || (new CTATComponentDescription).setGenericDefaults();
  this.getGrDescription = function getGrDescription() {
    return grDescription;
  };
  this.setGrDescription = function setGrDescription(aGrDescription) {
    grDescription = aGrDescription;
    this.processDescription(grDescription);
  };
  var border = {}, font = {};
  this.getDisplay = function() {
    return $(this.getDivWrap()).css("display");
  };
  this.getdisplay = this.getDisplay.bind(this);
  this.GetDisplay = this.getDisplay.bind(this);
  this.setDisplay = function(s) {
    var nd = String(s);
    switch(nd.toLowerCase()) {
      case "false":
        nd = "none";
        break;
      case "true":
      ;
      case "null":
      ;
      case "undefined":
        nd = "";
        break;
    }
    $(this.getDivWrap()).css("display", nd);
    return this;
  };
  this.setdisplay = this.setDisplay.bind(this);
  this.SetDisplay = this.setDisplay.bind(this);
  this.getAlign = function() {
    if (this.component) {
      return $(this.component).css("text-align");
    }
    return $(this.getDivWrap()).css("text-align");
  };
  this.setAlign = function(alignment) {
    if (this.component) {
      this.component.style.textAlign = alignment;
    }
    return this;
  };
  this.getBackgroundColor = function() {
    return $(this.getComponent()).css("background-color");
  };
  this.setBackgroundColor = function(color) {
    color = color ? CTATGlobalFunctions.formatColor(color) : null;
    if (this.component) {
      this.component.style.backgroundColor = color;
    }
    return this;
  };
  this.setDisabledBGColor = function(color) {
    return this;
  };
  this.setDisabledTextColor = function(color) {
    return this;
  };
  this.getBorderColor = function() {
    return $(this.getComponent()).css("border-color");
  };
  this.setBorderColor = function(color) {
    if (color) {
      color = CTATGlobalFunctions.formatColor(color);
      if (this.getComponent()) {
        $(this.getComponent()).css("border-color", color);
      } else {
        this.getDivWrap().style.borderColor = color;
      }
    }
    return this;
  };
  this.getBorderRoundness = function() {
    return $(this.getComponent()).css("border-radius");
  };
  this.setBorderRoundness = function(radius) {
    radius = parseInt(radius, 10);
    if (!isNaN(radius)) {
      border.roundness = radius;
    } else {
      border.roundness = 0;
      radius = 0;
    }
    radius = radius + "px";
    if (this.component && this.getBorderRoundness() !== radius) {
      $(this.component).css("border-radius", radius);
      this.component.style.borderRadius = border.roundness;
    }
    return this;
  };
  this.getBorderStyle = function() {
    return $(this.getComponent()).css("borderStyle");
  };
  this.setBorderStyle = function(aStyle) {
    if (this.component) {
      this.component.style.borderStyle = aStyle;
    }
    return this;
  };
  this.getBorderWidth = function() {
    if (this.getComponent()) {
      return $(this.getComponent()).css("borderWidth");
    }
    return border.width;
  };
  this.setBorderWidth = function(width) {
    border.width = width;
    var regex = /(\d*(px)? ?){1,3}(\d*(px)? ?)?/;
    var isValid = regex.test(width);
    if (!isValid) {
      width = "0px";
      console.log("invalid width string");
    }
    if (this.component && this.getBorderWidth() !== width) {
      $(this.component).css("borderWidth", width);
    }
    return this;
  };
  this.setPadding = function(newWidth) {
    var padding = parseInt(newWidth);
    if (isNaN(padding)) {
      padding = 0;
    }
    if (this.component) {
      this.component.style.padding = padding + "px";
    }
    return this;
  };
  this.getFontColor = function() {
    if (this.component) {
      return $(this.component).css("color");
    }
  };
  this.setFontColor = function(color) {
    console.log("setFontColor( )");
    font.color = CTATGlobalFunctions.formatColor(color);
    if (this.component) {
      console.log("got comp");
      if (this.getFontColor() !== font.color) {
        $(this.component).css("color", font.color);
      }
    }
    return font.color;
  };
  this.setFontFamily = function(family) {
    if (this.component) {
      this.component.style.fontFamily = family;
    }
    return this;
  };
  this.getFontFamily = function() {
    if (this.component) {
      return this.component.style.fontFamily;
    }
    console.warn("component not found");
    return null;
  };
  this.setFontSize = function(size) {
    var s = parseInt(size);
    if (!isNaN(s)) {
      font.size = s;
      if (this.component) {
        this.component.style.fontSize = s + "pt";
      }
    } else {
      this.component.style.fontSize = null;
    }
    return this;
  };
  this.setShowBorder = function(p_show) {
    p_show = CTATGlobalFunctions.toBoolean(p_show);
    if (this.component) {
      if (p_show) {
        this.setBorderStyle("solid");
      } else {
        this.setBorderStyle("none");
      }
    }
    return this;
  };
  this.setUnderlined = function(p_under) {
    p_underlined = CTATGlobalFunctions.toBoolean(p_under);
    if (this.component) {
      if (p_underlined) {
        this.component.style.textDecoration = "underline";
      } else {
        this.component.style.textDecoration = null;
      }
    }
    return this;
  };
  this.setBolded = function(p_bold) {
    p_bold = CTATGlobalFunctions.stringToBoolean(p_bold);
    if (this.component) {
      if (p_bold) {
        this.component.style.fontWeight = "bold";
      } else {
        this.component.style.fontWeight = null;
      }
    }
    return this;
  };
  this.setItalicized = function(p_italicized) {
    p_italicized = CTATGlobalFunctions.toBoolean(p_italicized);
    if (this.component) {
      if (font.italicized) {
        this.component.style.fontStyle = "italic";
      } else {
        this.component.style.fontStyle = null;
      }
    }
    return this;
  };
  var pointer = this;
  var makeHandlerCollection = function(map_object) {
    var handlers = map_object || {};
    return {setHandler:function(name, handler) {
      handlers[name] = handler;
    }, set:function(name) {
      if (handlers.hasOwnProperty(name)) {
        if (handlers[name]) {
          var args = Array.prototype.slice.call(arguments, 1);
          return handlers[name].apply(pointer, args);
        } else {
          pointer.ctatdebug("Error: NULL handler for " + name);
        }
      } else {
        pointer.ctatdebug("Error: No handler set for " + name);
      }
    }};
  };
  this.style_handlers = makeHandlerCollection({"BackgroundColor":this.setBackgroundColor, "BorderColor":this.setBorderColor, "borderRoundness":this.setBorderRoundness, "DrawBorder":this.setShowBorder, "FontFace":this.setFontFamily, "FontSize":this.setFontSize, "FontBold":this.setBolded, "FontItalic":this.setItalicized, "FontUnderlined":this.setUnderlined, "labelText":this.setText, "padding":this.setPadding, "showBorder":this.setShowBorder, "TextAlign":this.setAlign, "TextColor":this.setFontColor});
  this.setStyle = function(styleName, styleValue) {
    this.style_handlers.set(styleName, styleValue);
  };
  this.setStyleHandler = function(styleName, styleHandler) {
    this.style_handlers.setHandler(styleName, styleHandler);
  };
  this.parameter_handlers = makeHandlerCollection({"group":this.setComponentGroup});
  this.setParameter = function(paramName, paramValue) {
    this.parameter_handlers.set(paramName, paramValue);
  };
  this.setParameterHandler = function(paramName, paramHandler) {
    this.parameter_handlers.setHandler(paramName, paramHandler);
  };
  this.data_ctat_handlers = {};
  this.processAttributes = function() {
    if (this.getDivWrap()) {
      var $div = $(this.getDivWrap());
      this.disableTextAlterations($div);
      var tabindex = parseInt($div.attr("tabindex"), 10) || parseInt($div.attr("data-ctat-tabindex"), 10);
      if (!isNaN(tabindex)) {
        this.setTabIndex(tabindex);
        $div.attr("tabindex", null);
      }
      var name = $div.attr("name");
      if (name !== undefined) {
        this.setComponentGroup(name);
      }
      for (var datum in this.data_ctat_handlers) {
        var param_value = $div.data("ctat-" + datum);
        if (param_value !== undefined) {
          this.data_ctat_handlers[datum].apply(this, [param_value]);
        }
      }
    }
  };
  this.data_ctat_handlers["enabled"] = function(val) {
    this.setEnabled(CTATGlobalFunctions.toBoolean(val));
  };
  this.disableTextAlterations = function($div) {
    var attrs = ["autocomplete", "off", "autocapitalize", "off", "autocorrect", "off", "spellcheck", "false"];
    for (var i = 0;i < attrs.length;i += 2) {
      var a = attrs[i], v = $div.attr(a);
      if (!v && String(v).toLowerCase() !== "false") {
        $div.attr(a, v = attrs[i + 1]);
      }
      attrs[i + 1] = v;
    }
    this.ctatdebug("'#" + $div.attr("id") + "'.processAttributes(" + attrs + ")");
    return attrs;
  };
  this.processParameters = function(myDescription) {
    if (myDescription) {
      if (myDescription instanceof CTATComponentDescription) {
        pointer.setName(myDescription.name);
        var parameters = myDescription.params;
        for (var paramName in parameters) {
          var paramValue = parameters[paramName];
          this.setParameter(paramName, paramValue);
        }
      } else {
        this.ctatdebug("Error: Invalid description sent to CTAT.Components.Hierarchy.Graphical.processDescription: " + myDescription);
      }
    }
  };
  this.processStyles = function(myDescription) {
    if (myDescription) {
      if (myDescription instanceof CTATComponentDescription) {
        var styles = myDescription.styles;
        for (var styleName in styles) {
          var styleValue = styles[styleName];
          this.setStyle(styleName, styleValue);
        }
      } else {
        this.ctatdebug("Error: Invalid description sent to CTAT.Components.Hierarchy.Graphical.processDescription: " + myDescription);
      }
    }
  };
  this.processDescription = function(myDescription) {
    this.processParameters(myDescription);
    this.processStyles(myDescription);
  };
  this.configFromDescription = function() {
    this.processParameters(grDescription);
  };
  this.processSerialization = function() {
    this.processStyles(grDescription);
  };
  this.addClass = function(className) {
    if (this.getDivWrap() && this.getDivWrap() != null) {
      this.getDivWrap().classList.add(className);
    }
  };
  this.removeClass = function(className) {
    if (this.getDivWrap() && this.getDivWrap().classList != null) {
      this.getDivWrap().classList.remove(className);
    }
  };
};
CTAT.Component.Base.Graphical.prototype = Object.create(CTAT.Component.Base.Style.prototype);
CTAT.Component.Base.Graphical.prototype.constructor = CTAT.Component.Base.Graphical;
goog.provide("CTAT.Component.Base.SAIHandler");
goog.require("CTAT.Component.Base.Graphical");
goog.require("CTATGlobals");
goog.require("CTATMessage");
goog.require("CTATSAI");
CTAT.Component.Base.SAIHandler = function(aClassName, aName, aDescription, aX, aY, aWidth, aHeight) {
  CTAT.Component.Base.Graphical.call(this, aClassName, aName, aDescription, aX, aY, aWidth, aHeight);
  var _sai = new CTATSAI(this.getName(), CTAT.Component.Base.SAIHandler.DefaultAction, CTAT.Component.Base.SAIHandler.DefaultInput, CTAT.Component.Base.SAIHandler.DefaultPrompt);
  var super_setName = this.setName;
  this.setName = function(newName) {
    super_setName(newName);
    _sai.setSelection(this.getName());
  };
  this.getSAI = function() {
    return _sai;
  };
  this.setSAI = function(aSelection, anAction, anInput) {
    if (aSelection instanceof CTATSAI) {
      _sai = aSelection;
    } else {
      aSelection = aSelection === null || aSelection === undefined ? this.getName() : aSelection;
      _sai = new CTATSAI(aSelection, anAction, anInput, CTAT.Component.Base.SAIHandler.DefaultPrompt);
    }
    return this;
  };
  this.setInput = function(anInput) {
    if (_sai instanceof CTATSAI) {
      _sai.setInput(anInput);
    } else {
      _sai = new CTATSAI(this.getName(), CTAT.Component.Base.SAIHandler.DefaultAction, anInput, CTAT.Component.Base.SAIHandler.DefaultPrompt);
    }
    return this;
  };
  this.setAction = function(anAction) {
    if (_sai instanceof CTATSAI) {
      _sai.setAction(anAction);
    } else {
      _sai = new CTATSAI(this.getName(), anAction, CTAT.Component.Base.SAIHandler.DefaultInput, CTAT.Component.Base.SAIHandler.DefaultPrompt);
    }
    return this;
  };
  this.setActionInput = function(anAction, anInput) {
    this.setAction(anAction);
    this.setInput(anInput);
    return this;
  };
  this.setSelection = function(aSelection) {
    if (_sai instanceof CTATSAI) {
      _sai.setSelection(aSelection);
    } else {
      _sai = new CTATSAI(aSelection, CTAT.Component.Base.SAIHandler.DefaultAction, CTAT.Component.Base.SAIHandler.DefaultInput, CTAT.Component.Base.SAIHandler.DefaultPrompt);
    }
  };
  this.updateSAI = function() {
    return;
  };
  this.executeSAI = function(aSAI) {
    this.ctatdebug("executeSAI ()");
    var sai = null;
    if (aSAI instanceof CTATMessage) {
      sai = aSAI.getSAI();
    } else {
      sai = aSAI;
    }
    if (sai instanceof CTATSAI) {
      var action = sai.getAction();
      this.ctatdebug("Processing " + action + "(" + sai.getInput() + ") on: " + sai.getSelection());
      if (typeof this[action] == "function") {
        var args = sai.getArgumentsTyped();
        this.ctatdebug("JSON args: " + JSON.stringify(args));
        try {
          this.ctatdebug("Executing " + action + "(" + args + "," + typeof aSAI + ")...");
          args.push(aSAI);
          this[action].apply(this, args);
        } catch (err) {
          this.ctatdebug("ERROR: failed to execute action: " + err.message);
          return false;
        }
        if (this.component) {
          var SAI_event = new CustomEvent("CTAT_EXECUTE_SAI", {detail:{sai:aSAI, component:this}, bubbles:true, cancelable:true});
          this.component.dispatchEvent(SAI_event);
        }
        return true;
      } else {
        this.ctatdebug("ERROR: Unsupported action: " + action + " from " + sai.toLSxmlString());
        return false;
      }
    } else {
      this.ctatdebug("ERROR: Non-SAI sent to executeSAI(" + typeof aSAI + ")");
      return false;
    }
  };
};
CTAT.Component.Base.SAIHandler.DefaultAction = "ButtonPressed";
CTAT.Component.Base.SAIHandler.DefaultInput = "-1";
CTAT.Component.Base.SAIHandler.DefaultPrompt = "";
CTAT.Component.Base.SAIHandler.prototype = Object.create(CTAT.Component.Base.Graphical.prototype);
CTAT.Component.Base.SAIHandler.prototype.constructor = CTAT.Component.Base.SAIHandler;
goog.provide("CTAT.Component.Base.Tutorable");
goog.require("CTAT.Component.Base.SAIHandler");
goog.require("CTATCommShell");
goog.require("CTATGlobalFunctions");
CTAT.Component.Base.Tutorable = function(aClassName, aName, aDescription, aX, aY, aWidth, aHeight) {
  CTAT.Component.Base.SAIHandler.call(this, aClassName, aName, aDescription, aX, aY, aWidth, aHeight);
  var defaultTutorMe = true;
  var defaultRecordMe = true;
  var showFeedback = true;
  var _tutorComponent = CTAT.Component.Base.Tutorable.Options.TutorComponent.TUTOR;
  var disableOnCorrect = true;
  var pointer = this;
  var _highlighted = false;
  this.setTutorComponent = function setTutorComponent(theValue) {
    _tutorComponent = theValue;
    var opt = CTAT.Component.Base.Tutorable.Options.TutorComponent;
    switch(_tutorComponent) {
      case opt.TUTOR:
        defaultTutorMe = defaultRecordMe = true;
        showFeedback = true;
        break;
      case opt.TUTOR_NO_FEEDBACK:
        defaultTutorMe = defaultRecordMe = true;
        showFeedback = false;
        break;
      case opt.DO_NOT_TUTOR:
        defaultTutorMe = false;
        defaultRecordMe = true;
        break;
    }
  };
  this.setParameterHandler("tutorComponent", this.setTutorComponent);
  this.data_ctat_handlers["tutor"] = function(val) {
    defaultTutorMe = CTATGlobalFunctions.toBoolean(val);
  };
  this.data_ctat_handlers["show-feedback"] = function(val) {
    showFeedback = CTATGlobalFunctions.toBoolean(val);
  };
  this.getTutorComponent = function getTutorComponent() {
    var opt = CTAT.Component.Base.Tutorable.Options.TutorComponent;
    if (defaultTutorMe && defaultRecordMe && showFeedback) {
      return opt.TUTOR;
    } else {
      if (defaultTutorMe && defaultRecordMe && !showFeedback) {
        return opt.TUTOR_NO_FEEDBACK;
      } else {
        if (!defaultTutorMe && defaultRecordMe) {
          return opt.DO_NOT_TUTOR;
        } else {
          return _tutorComponent;
        }
      }
    }
  };
  this.getDisableOnCorrect = function() {
    var doc = $(this.getDivWrap()).attr("data-ctat-disable-on-correct");
    if (doc) {
      return CTATGlobalFunctions.toBoolean(doc);
    }
    return true;
  };
  this.setDisableOnCorrect = function(p_disable) {
    $(this.getDivWrap()).attr("data-ctat-disable-on-correct", p_disable);
  };
  this.setParameterHandler("DisableOnCorrect", this.setDisableOnCorrect);
  var showHintHighlight = true;
  this.getShowHintHighlight = function() {
    return showHintHighlight;
  };
  this.setShowHintHighlight = function(p_show) {
    showHintHighlight = CTATGlobalFunctions.toBoolean(p_show);
  };
  this.setParameterHandler("ShowHintHighlight", this.setShowHintHighlight);
  this.data_ctat_handlers["show-hint-highlight"] = function(val) {
    showHintHighlight = CTATGlobalFunctions.toBoolean(val);
  };
  var componentStatus = CTAT.Component.Base.Tutorable.Options.Status.NOTGRADED;
  this.getComponentStatus = function() {
    return componentStatus;
  };
  this.setComponentStatus = function(status) {
    componentStatus = status;
  };
  this.isCorrect = function() {
    return componentStatus === CTAT.Component.Base.Tutorable.Options.Status.CORRECT;
  };
  this.isIncorrect = function() {
    return componentStatus === CTAT.Component.Base.Tutorable.Options.Status.INCORRECT;
  };
  this.isNotGraded = function() {
    return componentStatus === CTAT.Component.Base.Tutorable.Options.Status.NOTGRADED;
  };
  this.setCorrect = function(aSAI) {
    this.setNotGraded();
    if (this.getClassName() != "CTATTableGoogle") {
      this.executeSAI(aSAI);
    }
    componentStatus = CTAT.Component.Base.Tutorable.Options.Status.CORRECT;
    if (this.getDisableOnCorrect() === true) {
      this.setEnabled(false);
    }
    if (CTATGlobals.suppressStudentFeedback === false && showFeedback) {
      this.showCorrect(aSAI);
    }
    this.ctatdebug("setCorrect() post showCorrect");
    if (this.component) {
      var correct_event = new CustomEvent(CTAT.Component.Base.Tutorable.EventType.correct, {detail:{sai:aSAI, component:this}, bubbles:true, cancelable:true});
      this.getDivWrap().dispatchEvent(correct_event);
    }
  };
  this.setIncorrect = function(aSAI) {
    this.ctatdebug("setIncorrect()");
    this.setNotGraded();
    if (this.getClassName() != "CTATTableGoogle") {
      this.executeSAI(aSAI);
    }
    componentStatus = CTAT.Component.Base.Tutorable.Options.Status.INCORRECT;
    if (CTATGlobals.suppressStudentFeedback === false && showFeedback) {
      this.showInCorrect(aSAI);
    }
    if (this.component) {
      var incorrect_event = new CustomEvent(CTAT.Component.Base.Tutorable.EventType.incorrect, {detail:{sai:aSAI, component:this}, bubbles:true, cancelable:true});
      this.getDivWrap().dispatchEvent(incorrect_event);
    }
  };
  this.setNotGraded = function() {
    this.ctatdebug("setNotGraded ()");
    this.setHintHighlight(false);
    if (!this.isNotGraded()) {
      componentStatus = CTAT.Component.Base.Tutorable.Options.Status.NOTGRADED;
      this.removeCorrect();
      this.removeInCorrect();
      if (this.component) {
        var notGraded_event = new CustomEvent(CTAT.Component.Base.Tutorable.EventType.ungrade, {detail:{component:this}, bubbles:true, cancelable:true});
        this.getDivWrap().dispatchEvent(notGraded_event);
      }
    }
  };
  this.showHintHighlight = function(p_show, aSAI) {
    this.component.classList.remove("CTAT--correct");
    this.component.classList.remove("CTAT--incorrect");
    if (p_show) {
      this.component.classList.add("CTAT--hint");
    } else {
      this.component.classList.remove("CTAT--hint");
    }
  };
  this.setHintHighlight = function setHintHighlight(newValue, aSAI) {
    this.ctatdebug("setHintHighlight (" + newValue + ")");
    if (showHintHighlight) {
      var highlight = CTATGlobalFunctions.toBoolean(newValue);
      if (this.component) {
        var hint_event = new CustomEvent(CTAT.Component.Base.Tutorable.EventType.highlight, {detail:{isHighlighted:highlight, component:this}, bubbles:true, cancelable:true});
        this.getDivWrap().dispatchEvent(hint_event);
      }
      if (highlight !== _highlighted) {
        _highlighted = highlight;
        this.showHintHighlight(highlight, aSAI);
      }
    }
  };
  this.moveHintHighlight = function moveHintHighlight(newValue, aSAI) {
    this.ctatdebug("moveHintHighlight (" + newValue + ")");
    CTATGlobals.Tab.previousFocus = CTATGlobals.Tab.Focus;
    CTATGlobals.Tab.Focus = pointer;
    if (pointer.component.focus) {
      CTATGlobals.Tab.Focus.getComponent().focus();
    } else {
      CTATGlobals.Tab.Focus.getDivWrap().focus();
    }
    if (showHintHighlight) {
      var highlight = CTATGlobalFunctions.toBoolean(newValue);
      if (this.component) {
        var hint_event = new CustomEvent(CTAT.Component.Base.Tutorable.EventType.highlight, {detail:{isHighlighted:highlight, component:this}, bubbles:true, cancelable:true});
        this.getDivWrap().dispatchEvent(hint_event);
      }
      if (highlight !== _highlighted) {
        _highlighted = highlight;
        this.showHintHighlight(highlight, aSAI);
      }
    }
  };
  this.highlight = function highlight(dummy) {
    ctatdebug("highlight ()");
    this.component.classList.add("CTAT--highlight");
  };
  this.unhighlight = function unhighlight(dummy) {
    ctatdebug("unhighlight ()");
    this.component.classList.remove("CTAT--highlight");
  };
  this.showCorrect = function(aMessage) {
    this.ctatdebug("showCorrect(" + aMessage + ")");
    this.getComponent().classList.remove("CTAT--incorrect");
    this.getComponent().classList.remove("CTAT--hint");
    this.getComponent().classList.add("CTAT--correct");
  };
  this.removeCorrect = function() {
    if (this.getComponent()) {
      this.getComponent().classList.remove("CTAT--correct");
    }
  };
  this.showInCorrect = function showInCorrect(aMessage) {
    this.ctatdebug("showInCorrect(" + aMessage + ")");
    this.getComponent().classList.remove("CTAT--correct");
    this.getComponent().classList.remove("CTAT--hint");
    this.getComponent().classList.add("CTAT--incorrect");
  };
  this.removeInCorrect = function() {
    if (this.getComponent()) {
      this.getComponent().classList.remove("CTAT--incorrect");
    }
  };
  this.resetTutoring = function() {
    this.showHintHighlight(false);
    this.removeCorrect();
    this.removeInCorrect();
    componentStatus = CTAT.Component.Base.Tutorable.Options.Status.NOTGRADED;
  };
  this.grade = function() {
    this.updateSAI();
    this.processAction(true);
  };
  this.processAction = function(force_grade, force_record) {
    this.ctatdebug("processAction(" + force_grade + "," + force_record + ")");
    pointer.unHighlightAll();
    var doneButton = CTATShellTools.findComponentByClass("CTATDoneButton");
    if (doneButton && doneButton instanceof CTAT.Component.Base.Tutorable && doneButton != this) {
      doneButton.setNotGraded();
    }
    this.ctatdebug("processAction() finished checking doneButton");
    ctatdebug("Clearing hint window ...");
    if (CTATCommShell.commShell) {
      CTATCommShell.commShell.clearFeedbackComponents();
    }
    force_grade = force_grade === undefined || force_grade === null ? false : force_grade;
    force_record = force_record === undefined || force_record === null ? false : force_record;
    if (this.getComponentGroup() !== "") {
      var group = CTATShellTools.findComponent(this.getComponentGroup());
      group.forEach(function(g) {
        if (g.setNotGraded) {
          g.setNotGraded();
        }
      });
    } else {
      this.setNotGraded();
    }
    this.ctatdebug("processAction() finished setNotGraded");
    if (CTATCommShell.commShell) {
      if (force_grade) {
        CTATCommShell.commShell.processComponentAction(this.getSAI(), true, true);
      } else {
        if (force_record) {
          CTATCommShell.commShell.processComponentAction(this.getSAI(), false, true);
        } else {
          CTATCommShell.commShell.processComponentAction(this.getSAI(), defaultTutorMe, defaultRecordMe);
        }
      }
    }
    this.ctatdebug("processAction() finished call to commShell.processComponentAction");
    if (this.component) {
      var SAI_event = new CustomEvent(CTAT.Component.Base.Tutorable.EventType.action, {detail:{sai:this.getSAI(), component:this, graded:force_grade || defaultTutorMe}, bubbles:true, cancelable:true});
      this.component.dispatchEvent(SAI_event);
    }
  };
  this.addEventScreen = function(addDblClickListener) {
    var eventScreen = document.createElement("div");
    eventScreen.style.position = "absolute";
    eventScreen.style.top = "0";
    eventScreen.style.left = "0";
    eventScreen.style.bottom = "0";
    eventScreen.style.right = "0";
    var dblClickListener = function() {
      var timeout = setTimeout(function() {
        var wasEnabled = pointer.getDivWrap().getAttribute("data-ctat-enabled");
        pointer.setEnabled(true);
        var inputElement = pointer.getComponent();
        if (!inputElement.hasEditListeners) {
          inputElement.addEventListener("blur", function() {
            pointer.setEnabled(false);
            pointer.getDivWrap().setAttribute("data-ctat-enabled", wasEnabled);
            pointer.getDivWrap().setAttribute("value", inputElement.value);
          });
          if (pointer.getClassName() === "CTATTextArea") {
            inputElement.addEventListener("keydown", function(event) {
              var key = event.keyCode || event.charCode;
              if (key == 13) {
                event.preventDefault();
                this.value += "\n";
              }
            });
          }
          inputElement.hasEditListeners = true;
        }
        inputElement.focus();
      }, 410);
    };
    if (addDblClickListener) {
      eventScreen.addEventListener("dblclick", dblClickListener);
    }
    this.getDivWrap().appendChild(eventScreen);
  };
};
CTAT.Component.Base.Tutorable.Options = {TutorComponent:{TUTOR:"Tutor", TUTOR_NO_FEEDBACK:"Tutor but no visual feedback", DO_NOT_TUTOR:"Do not tutor"}, Status:{CORRECT:"CORRECT", INCORRECT:"INCORRECT", NOTGRADED:"NOTGRADED"}};
CTAT.Component.Base.Tutorable.EventType = {correct:"CTAT_CORRECT", incorrect:"CTAT_INCORRECT", highlight:"CTAT_HIGHLIGHT", ungrade:"CTAT_NOTGRADED", action:"CTAT_ACTION"};
CTAT.Component.Base.Tutorable.prototype = Object.create(CTAT.Component.Base.SAIHandler.prototype);
CTAT.Component.Base.Tutorable.prototype.constructor = CTAT.Component.Base.Tutorable;
goog.provide("CTAT.Component.Base.Clickable");
goog.require("CTAT.Component.Base.Tutorable");
CTAT.Component.Base.Clickable = function(aClassName, aName, aDescription, aX, aY, aWidth, aHeight) {
  CTAT.Component.Base.Tutorable.call(this, aClassName, aName, aDescription, aX, aY, aWidth, aHeight);
  var pointer = this;
  this.processClick = function(e) {
    pointer.ctatdebug("processClick (" + e.currentTarget.getAttribute("id") + " -> " + e.eventPhase + ")");
    if (pointer.getEnabled() === true) {
      pointer.processAction();
    } else {
      pointer.ctatdebug("Component is disabled, not grading");
    }
  };
  this.setClickable = function(clickable) {
    pointer.setEnabled(clickable);
  };
};
CTAT.Component.Base.Clickable.prototype = Object.create(CTAT.Component.Base.Tutorable.prototype);
CTAT.Component.Base.Clickable.prototype.constructor = CTAT.Component.Base.Clickable;
goog.provide("CTATButtonBasedComponent");
goog.require("CTATGlobals");
goog.require("CTAT.Component.Base.Clickable");
CTATButtonBasedComponent = function(aClassName, aName, aDescription, aX, aY, aWidth, aHeight) {
  CTAT.Component.Base.Clickable.call(this, aClassName, aName, aDescription, aX, aY, aWidth, aHeight);
  var pointer = this;
  var buttonText = "";
  var textColor = "black";
  var scaleComponentToImage = false;
  this.setActionInput("ButtonPressed", "-1");
  this.setImage = function setImage(anImage) {
    pointer.ctatdebug("assignImage (" + anImage + ")");
    pointer.getDivWrap().setAttribute("data-ctat-img", anImage);
    if (anImage) {
      anImage = "url('" + anImage + "')";
    }
    $(pointer.getComponent()).css("background-image", anImage);
    $(pointer.getComponent()).css("background-size", "cover");
  };
  this.assignImage = function assignImage(anImage) {
    pointer.ctatdebug("assignImage ()");
    pointer.assignImages(anImage, anImage, anImage, anImage);
  };
  this.assignImageURL = function assignImageURL(anImage) {
    pointer.ctatdebug("assignImageURL ()");
    pointer.assignImages(anImage, anImage, anImage, anImage);
  };
  this.assignImages = function assignImages(aHover, aClicked, aDefault, aDisabled) {
    pointer.ctatdebug("assignImages ()");
    pointer.getDivWrap().setAttribute("data-ctat-image-hover", aHover);
    pointer.getDivWrap().setAttribute("data-ctat-image-clicked", aClicked);
    pointer.getDivWrap().setAttribute("data-ctat-image-default", aDefault);
    pointer.getDivWrap().setAttribute("data-ctat-image-disabled", aDisabled);
    this.setImage(aDefault);
  };
  this.processBaseMousedown = function processBaseMousedown() {
    pointer.ctatdebug("processMousedown ()");
    pointer.component.classList.add("CTAT-button--clicked");
    var imageClicked = pointer.getDivWrap().getAttribute("data-ctat-image-clicked");
    if (pointer.getEnabled() && imageClicked && imageClicked !== undefined && imageClicked !== "" && imageClicked !== null) {
      pointer.getComponent().style.backgroundImage = "url('" + imageClicked + "')";
    }
  };
  this.processBaseMouseup = function processBaseMouseup() {
    pointer.ctatdebug("processMouseup ()");
    pointer.component.classList.remove("CTAT-button--clicked");
    var imageDefault = pointer.getDivWrap().getAttribute("data-ctat-image-default");
    if (pointer.getEnabled() && imageDefault && imageDefault !== undefined && imageDefault !== "" && imageDefault !== null) {
      pointer.getComponent().style.backgroundImage = "url('" + imageDefault + "')";
    }
  };
  this.processBaseMouseover = function processBaseMouseover() {
    pointer.ctatdebug("processBaseMouseover ()");
    pointer.component.classList.add("CTAT-button--hover");
    var imageHover = pointer.getDivWrap().getAttribute("data-ctat-image-hover");
    if (pointer.getEnabled() && imageHover && imageHover !== undefined && imageHover !== "") {
      pointer.getComponent().style.backgroundImage = "url('" + imageHover + "')";
    }
  };
  this.processBaseMouseout = function processBaseMouseout() {
    pointer.ctatdebug("processBaseMouseout ()");
    pointer.component.classList.remove("CTAT-button--hover");
    pointer.component.classList.remove("CTAT-button--clicked");
    var imageDefault = pointer.getDivWrap().getAttribute("data-ctat-image-default");
    if (pointer.getEnabled() && imageDefault && imageDefault !== undefined && imageDefault !== "") {
      pointer.getComponent().style.backgroundImage = "url('" + imageDefault + "')";
    }
  };
  this.setText = function setText(aText) {
    pointer.ctatdebug("setText (" + aText + ")");
    buttonText = aText;
    if (pointer.getComponent() !== null) {
      pointer.getComponent().innerHTML = buttonText;
    }
  };
  this.setFontColor = function(aColor) {
    textColor = aColor;
    $(pointer.getComponent()).css("color", aColor);
  };
  this.getFontColor = function() {
    return textColor;
  };
  this.setStyleHandler("labelText", this.setText);
  this.getText = function getText() {
    return buttonText;
  };
  this.processClick = function processClick(e) {
    pointer.ctatdebug("processClick (" + e.currentTarget.getAttribute("id") + " -> " + e.eventPhase + ")");
    if (pointer.getEnabled() === true) {
      if (CTATGlobals.Tab.Focus !== null) {
        if (CTATGlobals.Tab.Focus.getClassName() == "CTATTextArea" || CTATGlobals.Tab.Focus.getClassName() == "CTATTextInput" || CTATGlobals.Tab.Focus.getClassName() == "CTATTextField") {
          CTATGlobals.Tab.Focus.processAction();
        } else {
          pointer.ctatdebug("Info: CTATGlobals.Tab.Focus==null");
        }
      }
      var value = $(pointer.getDivWrap()).attr("value");
      pointer.setInput(value ? value : "-1");
      pointer.processAction();
    } else {
      pointer.ctatdebug("Component is disabled, not grading");
    }
  };
  this.ButtonPressed = function() {
    return;
  };
};
CTATButtonBasedComponent.prototype = Object.create(CTAT.Component.Base.Clickable.prototype);
CTATButtonBasedComponent.prototype.constructor = CTATButtonBasedComponent;
goog.provide("CTAT.ComponentRegistry");
CTAT.ComponentRegistry = {};
CTAT.ComponentRegistry.addComponentType = function() {
};
Object.defineProperty(CTAT.ComponentRegistry, "addComponentType", {enumerable:false, value:function(aName, aConstructor) {
  if (typeof aName == "string") {
    if (this.hasOwnProperty(aName)) {
      alert(aName + " is already a registered component");
    } else {
      this[aName] = aConstructor;
    }
  }
}});
goog.provide("CTATAudioButton");
goog.require("CTATButtonBasedComponent");
goog.require("CTATCommShell");
goog.require("CTATGlobalFunctions");
goog.require("CTATSAI");
goog.require("CTAT.ComponentRegistry");
CTATAudioButton = function(aDescription, aX, aY, aWidth, aHeight) {
  CTATButtonBasedComponent.call(this, "CTATAudioButton", "audiobutton", aDescription, aX, aY, aWidth, aHeight);
  var pointer = this;
  pointer.setActionInput("play", "-1");
  var audioElement = null;
  var lastCommand = "";
  var previewMode = CTATConfiguration.get("previewMode");
  this.setSource = function(aUrl) {
    this.getDivWrap().setAttribute("data-ctat-src", aUrl);
    return this;
  };
  this.getSource = function() {
    return this.getDivWrap().getAttribute("data-ctat-src");
  };
  this.setParameterHandler("SoundFile", this.setSource);
  this.init = function init() {
    var button = document.createElement("button");
    button.value = "-1";
    button.name = pointer.getName();
    button.setAttribute("id", CTATGlobalFunctions.gensym.div_id());
    button.setAttribute("onkeypress", "return noenter(event)");
    button.classList.add("CTAT-button");
    if (this.getDivWrap().getAttribute("data-ctat-label")) {
      button.textContent = this.getDivWrap().getAttribute("data-ctat-label");
    } else {
      if (pointer.getText()) {
        button.textContent = pointer.getText();
      } else {
        if (pointer.getDivWrap() && pointer.getDivWrap().innerHTML && !previewMode) {
          var insides = pointer.getDivWrap().innerHTML;
          pointer.getDivWrap().innerHTML = "";
          button.innerHTML = insides;
        }
      }
    }
    pointer.setInitialized(true);
    pointer.setComponent(button);
    pointer.addComponentReference(pointer, button);
    pointer.getDivWrap().appendChild(button);
    pointer.ctatdebug("Final location: " + pointer.getX() + "," + pointer.getY() + " with text: " + pointer.getText());
    if (!previewMode) {
      button.addEventListener("click", pointer.processClick);
      button.addEventListener("focus", pointer.processFocus);
    }
    audioElement = document.createElement("audio");
    audioElement.addEventListener("canplay", function() {
      pointer.ctatdebug("Audio loaded and ready for play");
      if (lastCommand !== "") {
        pointer.logAudioEvent(lastCommand);
        lastCommand = "";
      }
    }, true);
    audioElement.onended = function() {
      pointer.ctatdebug("Audio ended");
      pointer.logAudioEvent("end");
    };
    this.getDivWrap().appendChild(audioElement);
  };
  this.getConfigurationActions = function() {
    var actions = [];
    var sai;
    if (this.component.innerHTML.trim().length > 0) {
      sai = new CTATSAI;
      sai.setSelection(this.getName());
      sai.setInput(this.component.innerHTML.toString());
      sai.setAction("setText");
      actions.push(sai);
    }
    if (this.getSource().trim().length > 0) {
      sai = new CTATSAI;
      sai.setSelection(this.getName());
      sai.setInput(this.getSource());
      sai.setAction("setSource");
      actions.push(sai);
    }
    return actions;
  };
  this.reset = function reset() {
    pointer.configFromDescription();
    pointer.processSerialization();
    pointer.setEnabled(true);
    lastCommand = "reset";
  };
  this.logAudioEvent = function logAudioEvent(eventName) {
    pointer.ctatdebug("logAudioEvent (" + eventName + ")");
    if (audioElement.duration !== undefined) {
      if (CTATCommShell.commShell !== null) {
        var audioSAI = new CTATSAI(pointer.getName(), eventName, pointer.toHHMMSS(audioElement.currentTime) + ".000", "");
        audioSAI.addSelection(encodeURIComponent(audioElement.currentSrc), "media_file");
        audioSAI.addSelection(pointer.toHHMMSS(audioElement.duration) + ".000", "clip_length");
        var tempInput = audioSAI.getInputObject();
        if (tempInput !== null) {
          tempInput.setType("time");
        }
        CTATCommShell.commShell.processComponentAction(audioSAI, false, true, pointer, "AUDIO_ACTION", "USER");
      } else {
        pointer.ctatdebug("Error: commShell is null, can't send untutored tool message");
      }
    } else {
      pointer.ctatdebug("Error: audio file not loaded yet, can't obtain duration");
    }
  };
  this.processClick = function processClick(e) {
    pointer.ctatdebug("processClick (" + e.currentTarget.getAttribute("id") + " -> " + e.eventPhase + ")");
    if (pointer.getEnabled() === true) {
      var soundFile = this.getSource();
      pointer.ctatdebug("Playing audio file: " + soundFile);
      audioElement.setAttribute("src", soundFile);
      audioElement.play();
      lastCommand = "play";
      pointer.processAction();
    } else {
      pointer.ctatdebug("Component is disabled, not grading");
    }
  }.bind(this);
  this.play = function() {
    pointer.ctatdebug("play");
    var soundFile = this.getSource();
    audioElement.setAttribute("src", soundFile);
    audioElement.load();
    audioElement.play();
    lastCommand = "play";
  };
  this.playClip = function(aURL) {
    pointer.ctatdebug("playClip");
    audioElement.setAttribute("src", aURL);
    audioElement.load();
    audioElement.play();
    lastCommand = "play";
  };
  this.pause = function() {
    pointer.ctatdebug("pause");
    audioElement.pause();
    lastCommand = "pause";
  };
};
CTATAudioButton.prototype = Object.create(CTATButtonBasedComponent.prototype);
CTATAudioButton.prototype.constructor = CTATAudioButton;
CTAT.ComponentRegistry.addComponentType("CTATAudioButton", CTATAudioButton);
goog.provide("CTATButton");
goog.require("CTATButtonBasedComponent");
goog.require("CTATGlobalFunctions");
goog.require("CTATSAI");
goog.require("CTAT.ComponentRegistry");
CTATButton = function(aDescription, aX, aY, aWidth, aHeight) {
  CTATButtonBasedComponent.call(this, "CTATButton", "aButton", aDescription, aX, aY, aWidth, aHeight);
  var pointer = this;
  var button = null;
  var previewMode = CTATConfiguration.get("previewMode");
  this.init = function init() {
    pointer.ctatdebug("init (" + pointer.getName() + ")");
    pointer.setActionInput("ButtonPressed", "-1");
    button = document.createElement("button");
    button.type = "button";
    button.name = pointer.getName();
    button.value = $(this.getDivWrap()).attr("value") || "-1";
    this.setInput(button.value);
    button.id = CTATGlobalFunctions.gensym.div_id();
    button.setAttribute("onkeypress", "return noenter(event)");
    button.classList.add("CTAT-button");
    pointer.setInitialized(true);
    if (pointer.getDivWrap().getAttribute("data-ctat-label")) {
      button.innerHTML = pointer.getDivWrap().getAttribute("data-ctat-label");
    } else {
      if (pointer.getText()) {
        button.innerHTML = pointer.getText();
      } else {
        if (pointer.getDivWrap() && pointer.getDivWrap().innerHTML && !previewMode) {
          var insides = pointer.getDivWrap().innerHTML;
          pointer.getDivWrap().innerHTML = "";
          button.innerHTML = insides;
        }
      }
    }
    pointer.setComponent(button);
    pointer.addComponentReference(pointer, button);
    pointer.getDivWrap().appendChild(button);
    button.addEventListener("click", pointer.processClick);
    button.addEventListener("focus", pointer.processFocus);
    button.addEventListener("mousedown", this.processBaseMousedown);
    button.addEventListener("mouseup", this.processBaseMouseup);
    button.addEventListener("mouseover", pointer.processBaseMouseover);
    button.addEventListener("mouseout", pointer.processBaseMouseout);
  }.bind(this);
  this.render = function() {
    return;
  };
  this.getConfigurationActions = function() {
    var actions = [];
    var sai;
    if (button.innerHTML.trim().length > 0) {
      sai = new CTATSAI;
      sai.setSelection(this.getName());
      sai.setInput(button.innerHTML.toString());
      sai.setAction("setText");
      actions.push(sai);
    }
    return actions;
  };
  this.reset = function reset() {
    pointer.configFromDescription();
    pointer.processSerialization();
    pointer.setEnabled(true);
  };
};
CTATButton.prototype = Object.create(CTATButtonBasedComponent.prototype);
CTATButton.prototype.constructor = CTATButton;
CTAT.ComponentRegistry.addComponentType("CTATButton", CTATButton);
goog.provide("CTATTextBasedComponent");
goog.require("CTATConfig");
goog.require("CTATGlobalFunctions");
goog.require("CTAT.Component.Base.Tutorable");
CTATTextBasedComponent = function(aClassName, aName, aDescription, aX, aY, aWidth, aHeight) {
  CTAT.Component.Base.Tutorable.call(this, aClassName, aName, aDescription, aX, aY, aWidth, aHeight);
  var pointer = this;
  var text = "";
  var textColor = "#000000";
  var textSize = 16;
  var tabOnEnter = true;
  var maxCharacters = 255;
  var editable = true;
  this.setAction("UpdateTextField");
  this.backgrade = true;
  this.setFontColor = function(aColor) {
    textColor = aColor;
    $(pointer.getComponent()).css("color", aColor);
  };
  this.getFontColor = function() {
    return textColor;
  };
  this.setFontSize = function(aSize) {
    if (!aSize.includes("px")) {
      aSize += "px";
    }
    textSize = aSize;
    $(pointer.getComponent()).css("font-size", aSize);
  };
  this.getFontSize = function() {
    return textSize;
  };
  this.assignText = function assignText(aText) {
    text = aText;
    this.setInput(aText);
  };
  this.UpdateTextField = function(aText) {
    this.setText(aText);
  };
  this.UpdateTextArea = this.UpdateTextField;
  this.setTabOnEnter = function setTabOnEnter(aValue) {
    tabOnEnter = CTATGlobalFunctions.toBoolean(aValue);
  };
  this.setStyleHandler("TabOnEnter", this.setTabOnEnter);
  this.data_ctat_handlers["tab-on-enter"] = this.setTabOnEnter;
  this.assignEditable = function assignEditable(aEditable) {
    editable = aEditable;
  };
  this.setMaxCharacters = function setMaxCharacters(aMax) {
    maxCharacters = aMax;
  };
  this.setStyleHandler("MaxCharacters", this.setMaxCharacters);
  this.getText = function getText() {
    return text;
  };
  this.getEditable = function getEditable() {
    return editable;
  };
  this.getTabOnEnter = function getTabOnEnter() {
    return tabOnEnter;
  };
  this.getMaxCharacters = function getMaxCharacters() {
    return maxCharacters;
  };
  function getKey(e) {
    var key;
    if (CTATConfig.platform == "google") {
      return 0;
    }
    if (window.event) {
      key = window.event.keyCode;
    } else {
      key = e.which;
    }
    return key;
  }
  this.setEditable = function setEditable(aValue) {
    pointer.assignEditable(CTATGlobalFunctions.toBoolean(aValue));
    if (pointer.getComponent() === null) {
      return;
    }
    if (pointer.getEditable() === true) {
      pointer.getComponent().contentEditable = "true";
    } else {
      pointer.getComponent().contentEditable = "false";
    }
  };
  this.setStyleHandler("Enabled", this.setEditable);
  this.setEnabled = function setEnabled(aValue) {
    pointer.assignEnabled(aValue);
    if (pointer.getComponent() === null) {
      return;
    }
    pointer.getComponent().disabled = !aValue;
    this.setEditable(aValue);
  };
  var super_processAction = this.processAction.bind(this);
  this.processAction = function(force_grade, force_record) {
    pointer.ctatdebug("processAction ()");
    this.updateSAI();
    if (!CTATGlobalFunctions.isBlank(this.getValue())) {
      super_processAction(force_grade, force_record);
    }
  };
  this.processKeypress = function processKeypress(e) {
    pointer.ctatdebug("processKeypress ()");
    var id = e.target.getAttribute("id");
    pointer.ctatdebug(id);
    var comp = pointer.getComponentFromID(id);
    if (comp === null) {
      pointer.ctatdebug("Error: component reference is null");
      return;
    }
    pointer.ctatdebug(comp.getName() + " keydown (" + getKey(e) + " -> " + e.eventPhase + ") " + "ID: " + id);
    switch(e.which) {
      case 37:
        pointer.ctatdebug("left arrow key pressed!");
        break;
      case 39:
        pointer.ctatdebug("right arrow key pressed!");
        break;
      case 13:
        if (tabOnEnter) {
          pointer.component.blur();
          CTATGlobals.Tab.Focus = null;
          pointer.processAction();
          return false;
        } else {
          return true;
        }
        break;
      case 0:
        pointer.component.blur();
        CTATGlobals.Tab.Focus = null;
        pointer.processAction();
        break;
      default:
        pointer.ctatdebug('Key pressed! "' + e.which + '"');
    }
  };
  this.updateSAI = function() {
    pointer.ctatdebug("updateSAI ()");
    this.setInput(this.getValue());
    var testSAI = this.getSAI();
    pointer.ctatdebug("SAI: " + testSAI.toTSxmlString());
  };
};
CTATTextBasedComponent.prototype = Object.create(CTAT.Component.Base.Tutorable.prototype);
CTATTextBasedComponent.prototype.constructor = CTATTextBasedComponent;
goog.provide("CTATTextArea");
goog.require("CTATGlobalFunctions");
goog.require("CTATTextBasedComponent");
goog.require("CTAT.ComponentRegistry");
CTATTextArea = function(aDescription, aX, aY, aWidth, aHeight) {
  CTATTextBasedComponent.call(this, "CTATTextArea", "__undefined__", aDescription, aX, aY, aWidth, aHeight);
  this.setDefaultWidth(100);
  this.setDefaultHeight(44);
  var pointer = this;
  var textinput = null;
  var cellContainer = null;
  var previewMode = CTATConfiguration.get("previewMode");
  this.setAction("UpdateTextArea");
  this.init = function init(isTableCell) {
    textinput = document.createElement("textarea");
    if (aDescription) {
      textinput.name = aDescription.name;
    }
    textinput.setAttribute("id", CTATGlobalFunctions.gensym.div_id());
    var divWrap = this.getDivWrap();
    if (divWrap && $(divWrap).attr("maxlength")) {
      textinput.maxlength = $(divWrap).attr("maxlength");
    }
    if (divWrap && $(divWrap).attr("rows")) {
      textinput.rows = $(divWrap).attr("rows");
    }
    if (divWrap && $(divWrap).attr("cols")) {
      textinput.cols = $(divWrap).attr("cols");
    }
    pointer.setComponent(textinput);
    if (divWrap && $(divWrap).attr("value")) {
      this.setText($(divWrap).attr("value"));
    } else {
      textinput.value = this.getText();
    }
    pointer.setInitialized(true);
    pointer.addComponentReference(pointer, textinput);
    divWrap.appendChild(textinput);
    $(textinput).keypress(pointer.processKeypress);
    textinput.addEventListener("focus", pointer.processFocus);
    $(textinput).on("input", function(e) {
      pointer.setNotGraded();
    });
    if (previewMode) {
      this.addEventScreen(false);
    }
  };
  this.processBlur = function(e) {
    pointer.processAction();
  };
  this.setCellContainer = function setCellContainer(aContainer) {
    cellContainer = aContainer;
  };
  this.getCellContainer = function getCellContainer() {
    return cellContainer;
  };
  this.setText = function setText(aText) {
    pointer.ctatdebug("setText (" + aText + ")");
    pointer.assignText(aText);
    textinput.value = aText;
  };
  this.getValue = function() {
    return textinput.value;
  };
  this.reset = function reset() {
    pointer.configFromDescription();
    pointer.processSerialization();
    textinput.value = "";
  };
};
CTATTextArea.prototype = Object.create(CTATTextBasedComponent.prototype);
CTATTextArea.prototype.constructor = CTATTextArea;
CTAT.ComponentRegistry.addComponentType("CTATTextArea", CTATTextArea);
goog.provide("CTATChatPanel");
goog.require("CTAT.Component.Base.Graphical");
goog.require("CTATGlobalFunctions");
goog.require("CTATGlobals");
goog.require("CTATShellTools");
goog.require("CTATTextArea");
goog.require("CTAT.ComponentRegistry");
CTATChatPanel = function(aDescription, aX, aY, aWidth, aHeight) {
  CTAT.Component.Base.Tutorable.call(this, "CTATChatPanel", "__undefined__", aDescription, aX, aY, aWidth, aHeight);
  var pointer = this;
  var chatArea = null;
  var inputDiv = null;
  var messageBox = null;
  var sendButton = null;
  var previewMode = CTATConfiguration.get("previewMode");
  this.init = function init() {
    pointer.ctatdebug("init (" + pointer.getName() + ")");
    var opt = CTAT.Component.Base.Tutorable.Options.TutorComponent;
    pointer.setTutorComponent(opt.DO_NOT_TUTOR);
    pointer.setInitialized(true);
    var divWrap = pointer.getDivWrap();
    pointer.setComponent(divWrap);
    pointer.addComponentReference(pointer, divWrap);
    pointer.ctatdebug("chat name = " + this.getName());
    divWrap.style.display = "flex";
    divWrap.style.flexDirection = "column";
    divWrap.style.position = "relative";
    divWrap.style.margin = "10px";
    divWrap.style.width = "300px";
    divWrap.style.height = "200px";
    chatArea = document.createElement("div");
    chatArea.id = "chatArea";
    chatArea.classList.add("CTATChatPanel--chat-area");
    chatArea.style.height = "70%";
    chatArea.style.width = "100%";
    chatArea.style.border = "2px solid #9096a0";
    chatArea.style.borderRadius = "10px";
    chatArea.style.overflowY = "auto";
    chatArea.style.padding = "7px";
    chatArea.style.backgroundColor = "white";
    inputDiv = document.createElement("div");
    inputDiv.id = "inputDiv";
    inputDiv.classList.add("CTATChatPanel--input-div");
    inputDiv.style.display = "flex";
    inputDiv.style.flexDirection = "row";
    inputDiv.style.height = "30%";
    inputDiv.style.width = "100%";
    messageBox = document.createElement("textarea");
    messageBox.id = divWrap.id + "_input";
    messageBox.classList.add("CTATChatPanel--message-box");
    messageBox.placeholder = "Type a message";
    messageBox.style.width = "100%";
    messageBox.style.border = "2px solid #9096a0";
    messageBox.style.borderRadius = "10px";
    messageBox.style.marginTop = "5px";
    messageBox.style.marginRight = "5px";
    messageBox.style.fontFamily = "Verdana";
    inputDiv.appendChild(messageBox);
    sendButton = document.createElement("button");
    sendButton.innerText = "Send";
    sendButton.classList.add("CTATChatPanel--send-button");
    sendButton.style.width = "20%";
    sendButton.style.border = "2px solid #9096a0";
    sendButton.style.borderRadius = "10px";
    sendButton.style.marginTop = "5px";
    sendButton.addEventListener("click", this.sendText);
    pointer.setComponent(chatArea);
    pointer.setComponent(inputDiv);
    pointer.setComponent(messageBox);
    pointer.addComponentReference(pointer, chatArea);
    pointer.addComponentReference(pointer, inputDiv);
    pointer.addComponentReference(pointer, messageBox);
    divWrap.appendChild(chatArea);
    divWrap.appendChild(inputDiv);
    pointer.render();
    if (previewMode) {
      this.addEventScreen(false);
    }
  };
  this.updateSAISend = function(input) {
    pointer.ctatdebug("updateSAISend ()");
    var divWrap = pointer.getDivWrap();
    this.setSelection(divWrap.id);
    this.setAction("sendMessage");
    var user = CTATConfiguration.get("user_guid");
    input = user + ": " + input;
    this.setInput(input);
    var testSAI = this.getSAI();
    pointer.ctatdebug("SAI: " + testSAI.toTSxmlString());
  };
  var super_processAction = this.processAction.bind(this);
  this.processSend = function(input, force_grade, force_record) {
    pointer.ctatdebug("processSend ()");
    pointer.updateSAISend(input);
    var isComp = input.split("_").pop() === "computer";
    if (!CTATGlobalFunctions.isBlank(messageBox.value) || isComp) {
      super_processAction(force_grade, force_record);
    }
  };
  this.addOwnMessage = function(value) {
    var message = document.createElement("div");
    message.innerText = value;
    message.style.borderRadius = "5px";
    message.style.position = "relative";
    message.style.backgroundColor = "#ffcb87";
    message.style.marginBottom = "5px";
    message.style.marginTop = "2px";
    message.style.maxWidth = "90%";
    message.style.wordWrap = "break-word";
    message.style.padding = "5px 8px";
    message.style.display = "inline-block";
    message.style.cssFloat = "right";
    message.style.clear = "both";
    message.style.fontFamily = "Verdana";
    var br = document.createElement("br");
    chatArea.appendChild(message);
    chatArea.appendChild(br);
    chatArea.scrollTop = chatArea.scrollHeight;
  };
  this.addOtherMessage = function(value) {
    var idx = value.indexOf(":");
    var username = value.substr(0, idx) + " ";
    var rest = value.substr(idx + 2);
    var message = document.createElement("div");
    message.innerHTML = username.bold() + rest;
    message.style.borderRadius = "5px";
    message.style.position = "relative";
    message.style.backgroundColor = "#c7edfc";
    message.style.marginBottom = "5px";
    message.style.marginTop = "2px";
    message.style.maxWidth = "90%";
    message.style.wordWrap = "break-word";
    message.style.padding = "5px 8px";
    message.style.display = "inline-block";
    message.style.fontFamily = "Verdana";
    var br = document.createElement("br");
    chatArea.appendChild(message);
    chatArea.appendChild(br);
    chatArea.scrollTop = chatArea.scrollHeight;
  };
  this.sendCompMessage = function(value) {
    var message = document.createElement("div");
    var username = "computer: ";
    message.innerHTML = username.bold() + value;
    message.style.borderRadius = "5px";
    message.style.position = "relative";
    message.style.backgroundColor = "#d5dde8";
    message.style.marginBottom = "5px";
    message.style.marginTop = "2px";
    message.style.maxWidth = "90%";
    message.style.wordWrap = "break-word";
    message.style.padding = "5px 8px";
    message.style.display = "inline-block";
    message.style.fontFamily = "Verdana";
    var br = document.createElement("br");
    chatArea.appendChild(message);
    chatArea.appendChild(br);
    chatArea.scrollTop = chatArea.scrollHeight;
  };
  this.sendCompMessageBroadcast = function(value) {
    if (value !== "") {
      pointer.processSend(value + "_computer");
      var opt = CTAT.Component.Base.Tutorable.Options.TutorComponent;
      if (pointer.getTutorComponent() === opt.DO_NOT_TUTOR) {
        pointer.sendCompMessage(value);
      }
    }
  };
  this.sendText = function(label) {
    var input = messageBox.value;
    if (input !== "") {
      input = label + ": " + input;
      pointer.processSend(input);
      var opt = CTAT.Component.Base.Tutorable.Options.TutorComponent;
      if (pointer.getTutorComponent() === opt.DO_NOT_TUTOR) {
        pointer.addOwnMessage(input);
      }
    }
    messageBox.value = "";
    sendButton.classList.remove("CTAT--incorrect");
  };
  this.sendMessage = function(data) {
    var isComp = data.split("_").pop() === "computer";
    if (isComp) {
      var colon = data.indexOf(":");
      var underscore = data.lastIndexOf("_");
      var res = data.slice(colon + 2, underscore);
      pointer.sendCompMessage(res);
    } else {
      pointer.addOtherMessage(data);
    }
    sendButton.classList.remove("CTAT--incorrect");
  };
};
CTATChatPanel.prototype = Object.create(CTAT.Component.Base.Tutorable.prototype);
CTATChatPanel.prototype.constructor = CTATChatPanel;
CTAT.ComponentRegistry.addComponentType("CTATChatPanel", CTATChatPanel);
goog.provide("CTATCheckBox");
goog.require("CTATGlobalFunctions");
goog.require("CTAT.Component.Base.Clickable");
goog.require("CTAT.ComponentRegistry");
goog.require("CTATSAI");
CTATCheckBox = function(aDescription, aX, aY, aWidth, aHeight) {
  CTAT.Component.Base.Clickable.call(this, "CTATCheckBox", "__undefined__", aDescription, aX, aY, aWidth, aHeight);
  var checkbox = null;
  var label = null;
  var previewMode = CTATConfiguration.get("previewMode");
  this.setStyleHandler("inspBackgroundColor", null);
  this.setStyleHandler("BackgroundColor", null);
  this.setStyleHandler("DrawBorder", null);
  this.setStyleHandler("showBorder", null);
  this.setStyleHandler("BorderColor", null);
  this.setStyleHandler("TextAlign", null);
  var pointer = this;
  this.setSelection(this.getComponentGroup());
  this.setAction("UpdateCheckBox");
  this.getCheckBox = function getCheckBox() {
    return checkbox;
  };
  this.setStyleHandler("labelPlacement", null);
  var handle_selection = function(e) {
    this.updateSAI();
    this.processClick(e);
  };
  this.init = function init() {
    pointer.setInitialized(true);
    checkbox = document.createElement("input");
    checkbox.type = "checkbox";
    checkbox.setAttribute("id", this.getName() + "_check");
    checkbox.classList.add("CTATCheckBox--button");
    if (this.getText()) {
      checkbox.value = pointer.getText();
    } else {
      if (this.getDivWrap() && this.getDivWrap().textContent) {
        checkbox.value = this.getDivWrap().textContent;
      } else {
        checkbox.value = checkbox.id;
      }
    }
    if (this.getComponentGroup()) {
      checkbox.name = pointer.getComponentGroup();
    } else {
      if (this.getDivWrap() && $(this.getDivWrap()).attr("name")) {
        checkbox.name = $(this.getDivWrap()).attr("name");
      } else {
        checkbox.name = "checkBoxGroup";
      }
    }
    if (pointer.getEnabled() === true) {
      checkbox.disabled = false;
    } else {
      checkbox.disabled = true;
    }
    pointer.ctatdebug("Final location: " + pointer.getX() + "," + pointer.getY() + " with text: " + pointer.getText());
    pointer.addComponentReference(pointer, checkbox);
    if (!previewMode) {
      var content = this.getDivWrap().innerHTML;
      this.getDivWrap().innerHTML = "";
    }
    $(pointer.getDivWrap()).append(checkbox);
    label = document.createElement("label");
    label.htmlFor = checkbox.id;
    label.classList.add("CTATCheckBox--label");
    if (this.getText()) {
      label.textContent = this.getText();
    } else {
      if (content && !previewMode) {
        label.innerHTML = content;
      } else {
        if (this.getDivWrap().getAttribute("data-ctat-label")) {
          this.setText(this.getDivWrap().getAttribute("data-ctat-label"));
        }
      }
    }
    $(this.getDivWrap()).append(label);
    pointer.setComponent(checkbox);
    checkbox.addEventListener("click", handle_selection.bind(this));
    checkbox.addEventListener("focus", pointer.processFocus);
    checkbox.onfocus = this.processOnFocus;
    this.setSelection(this.getComponentGroup());
  };
  this.resize = function() {
    var height = $(this.getDivWrap()).height();
    $(label).css("font-size", height - 5 + "px");
    $(this.getComponent()).css("height", height - 10 + "px");
    $(this.getComponent()).css("width", height - 10 + "px");
  };
  this.getConfigurationActions = function() {
    var actions = [];
    var sai;
    if (label.innerHTML.trim().length > 0) {
      sai = new CTATSAI;
      sai.setSelection(this.getName());
      sai.setInput(label.innerHTML.toString());
      sai.setAction("setText");
      actions.push(sai);
    }
    return actions;
  };
  var super_setText = this.setText;
  this.setText = function(aText) {
    pointer.ctatdebug("setText (" + aText + ")");
    super_setText(aText);
    if (checkbox) {
      checkbox.value = aText;
      label.innerHTML = aText;
    }
  };
  this.setStyleHandler("labelText", this.setText);
  var super_setEnabled = this.setEnabled;
  this.setEnabled = function setEnabled(aValue) {
    super_setEnabled(aValue);
    if (!checkbox) {
      return;
    }
    checkbox.disabled = !this.getEnabled();
  };
  this.getCheckBoxInput = function getCheckBoxInput() {
    return label.innerHTML + ": " + checkbox.checked;
  };
  this.reset = function reset() {
    checkbox.checked = false;
    pointer.setEnabled(true);
  };
  this.UpdateCheckBox = function(aLabel) {
    var search_string = new RegExp("(^|;)" + CTATCheckBox.escape(checkbox.value) + "\\s*:\\s*true");
    checkbox.checked = aLabel.search(search_string) >= 0;
  };
  this.SetSelected = function(isChecked) {
    var sel = CTATGlobalFunctions.toBoolean(isChecked);
    checkbox.checked = sel;
  };
  this.updateSAI = function() {
    var checkboxes = $("." + this.getClassName() + '[data-ctat-component]:has(input[type="checkbox"][name="' + checkbox.name + '"])');
    var cbs_sorted = checkboxes.sort(function(a, b) {
      var an = a.id;
      var bn = b.id;
      if (an > bn) {
        return 1;
      }
      if (an < bn) {
        return -1;
      }
      return 0;
    });
    var cbinputs = $.map(cbs_sorted, function(cb) {
      var comp = $(cb).data("CTATComponent").getCheckBox();
      return comp.value + ": " + comp.checked;
    });
    this.setSelection(checkbox.name);
    this.setAction("UpdateCheckBox");
    this.setInput(cbinputs.join(";"));
  };
  var add_highlighting = function(h) {
    label.classList.add(h);
    checkbox.classList.add(h);
  };
  var remove_highlighting = function(h) {
    label.classList.remove(h);
    checkbox.classList.remove(h);
  };
  this.showCorrect = function(aSAI) {
    remove_highlighting("CTAT--incorrect");
    remove_highlighting("CTAT--hint");
    add_highlighting("CTAT--correct");
  };
  this.removeCorrect = remove_highlighting.bind(this, "CTAT--correct");
  this.showInCorrect = function(aSAI) {
    remove_highlighting("CTAT--correct");
    remove_highlighting("CTAT--hint");
    add_highlighting("CTAT--incorrect");
  };
  this.removeInCorrect = remove_highlighting.bind(this, "CTAT--incorrect");
  this.showHintHighlight = function(pHint) {
    remove_highlighting("CTAT--incorrect");
    remove_highlighting("CTAT--correct");
    if (pHint) {
      add_highlighting("CTAT--hint");
    } else {
      remove_highlighting("CTAT--hint");
    }
  };
};
CTATCheckBox.prototype = Object.create(CTAT.Component.Base.Clickable.prototype);
CTATCheckBox.prototype.constructor = CTATCheckBox;
CTATCheckBox.escape = function(text) {
  return text.replace(/[-[\]{}()*+?.,\\^$|#\s\/]/g, "\\$&");
};
CTAT.ComponentRegistry.addComponentType("CTATCheckBox", CTATCheckBox);
goog.provide("CTATComboBox");
goog.require("CTATGlobalFunctions");
goog.require("CTATSAI");
goog.require("CTAT.Component.Base.Clickable");
goog.require("CTAT.ComponentRegistry");
CTATComboBox = function(aDescription, aX, aY, aWidth, aHeight) {
  CTAT.Component.Base.Clickable.call(this, "CTATComboBox", "__undefined__", aDescription, aX, aY, aWidth, aHeight);
  var pointer = this;
  var combobox = null;
  this.component = null;
  var gradeOnNextClickInfo = "";
  var previewMode = CTATConfiguration.get("previewMode");
  this.setAction("UpdateComboBox");
  var split_character = ",";
  var splitter = function(char) {
    split_character = char;
    if (combobox) {
      combobox.innerHTML = "";
      this.addLabels(list_entries, split_character);
    }
  }.bind(this);
  this.setStyleHandler("SplitCharacter", splitter);
  this.data_ctat_handlers["split-on"] = splitter;
  var list_entries = null;
  this.setLabels = function(labels) {
    list_entries = labels;
    if (combobox) {
      combobox.innerHTML = "";
      this.addLabels(list_entries, split_character);
    }
  }.bind(this);
  this.setStyleHandler("Labels", this.setLabels);
  this.data_ctat_handlers["labels"] = this.setLabels;
  var numVisibleOptions = null;
  var setNumOptions = function(numLines) {
    var size = parseInt(numLines);
    if (isNaN(size)) {
      numVisibleOptions = null;
    } else {
      numVisibleOptions = size;
    }
    if (combobox) {
      combobox.setAttribute("size", numVisibleOptions);
    }
  };
  this.setStyleHandler("DropDownSize", setNumOptions);
  this.data_ctat_handlers["size"] = setNumOptions;
  this.setStyleHandler("DropDownWidth", null);
  this.setNumOptions = setNumOptions;
  this.setGradeOnNextClick = function(info) {
    pointer.ctatdebug("CTATComboBox[" + pointer.getName() + "].setGradeOnNextClick(" + info + ")");
    gradeOnNextClickInfo = info;
  };
  this.getGradeOnNextClick = function() {
    pointer.ctatdebug("CTATComboBox[" + pointer.getName() + "].getGradeOnNextClick() to return " + gradeOnNextClickInfo);
    return gradeOnNextClickInfo;
  };
  this.processAssociatedRules = function(msg, indicator, tutorAdvice) {
    var outOfOrder = msg.getProperty("OutOfOrder");
    pointer.ctatdebug("CB[" + pointer.getName() + "] processAssociatedRules indicator " + indicator + ", outOfOrder " + outOfOrder + ", tutorAdvice '" + tutorAdvice + "'");
    if (!indicator) {
      return;
    }
    if (indicator.toString().toLowerCase() == "incorrect" && (outOfOrder || tutorAdvice && tutorAdvice.toString().toLowerCase().includes(" the step you "))) {
      pointer.setGradeOnNextClick("at " + (new Date).toString() + ": sai " + pointer.getSAI().toString());
    }
  };
  this.init = function init() {
    pointer.setInitialized(true);
    combobox = document.createElement("select");
    combobox.name = pointer.getName();
    combobox.setAttribute("id", CTATGlobalFunctions.gensym.div_id());
    combobox.setAttribute("onkeypress", "return noenter(event)");
    combobox.onchange = this.processComboSelection;
    combobox.addEventListener("click", function(event) {
      pointer.ctatdebug("CB[" + pointer.getName() + "].onclick() " + event + ", gradeOnNextClickInfo " + pointer.getGradeOnNextClick());
      if (pointer.getGradeOnNextClick()) {
        pointer.processComboSelection();
      }
    });
    combobox.classList.add("CTAT-combobox");
    if (numVisibleOptions && !previewMode) {
      combobox.setAttribute("size", numVisibleOptions);
    }
    if (!previewMode) {
      var content = this.getDivWrap().innerHTML;
      this.getDivWrap().innerHTML = "";
      if (content.trim()) {
        combobox.innerHTML = content;
      }
    }
    if (list_entries) {
      this.addLabels(list_entries, split_character);
    }
    if (pointer.getEnabled() === true) {
      combobox.disabled = false;
    } else {
      combobox.disabled = true;
    }
    pointer.addComponentReference(pointer, combobox);
    pointer.setComponent(combobox);
    pointer.getDivWrap().appendChild(combobox);
    this.component = combobox;
    combobox.addEventListener("focus", pointer.processFocus);
  };
  this.getConfigurationActions = function() {
    var actions = [];
    if (list_entries) {
      var sai = new CTATSAI;
      sai.setSelection(this.getName());
      sai.setInput(list_entries);
      sai.setAction("setLabels");
      actions.push(sai);
    }
    return actions;
  };
  this.getHTMLComponent = function getHTMLComponent() {
    return combobox;
  };
  this.addLabels = function(labels, sep) {
    var splitter = sep ? sep : split_character;
    var items = labels.split(splitter);
    for (var i = 0;i < items.length;i++) {
      this.addItem(items[i]);
    }
  };
  this.addBlank = function(numLabels) {
    for (var i = 0;i < numLabels;i++) {
      this.addItem("");
    }
  };
  this.addItem = function addItem(aValue) {
    pointer.ctatdebug("addItem (" + aValue + ")");
    var option = document.createElement("option");
    option.setAttribute("value", aValue);
    option.textContent = aValue;
    combobox.appendChild(option);
  };
  this.setFontSize = function(aSizeStr) {
    if (!isNaN(aSizeStr)) {
      $(this.getComponent()).css("font-size", aSizeStr + "px");
      this.getDivWrap().setAttribute("data-ctat-font-size", aSizeStr);
    }
  };
  this.valid_selection = function() {
    return combobox.selectedIndex >= 0 && !CTATGlobalFunctions.isBlank(combobox.value);
  };
  this.processComboSelection = function processComboSelection() {
    pointer.ctatdebug("processComboSelection ()");
    pointer.setGradeOnNextClick("");
    var selected = combobox.options[combobox.selectedIndex].value;
    pointer.setInput(selected);
    if (!pointer.valid_selection()) {
      this.ctatdebug("Empty component, nothing to grade");
    } else {
      pointer.processAction();
    }
  };
  this.UpdateComboBox = function(item) {
    combobox.value = item;
  };
  this.updateSAI = function() {
    pointer.setInput(combobox.value);
  };
};
CTATComboBox.prototype = Object.create(CTAT.Component.Base.Clickable.prototype);
CTATComboBox.prototype.constructor = CTATComboBox;
CTAT.ComponentRegistry.addComponentType("CTATComboBox", CTATComboBox);
goog.provide("CTATDoneButton");
goog.require("CTATCommShell");
goog.require("CTAT.Component.Base.Clickable");
goog.require("CTAT.ComponentRegistry");
goog.require("CTATLanguageManager");
CTATDoneButton = function(aDescription, aX, aY, aWidth, aHeight) {
  CTAT.Component.Base.Clickable.call(this, "done", "CTATDoneButton", aDescription, aX, aY, aWidth, aHeight);
  this.setName("done");
  this.setClassName("CTATDoneButton");
  this.setText(CTATGlobals.languageManager.getString("DONE"));
  this.setStyleHandler("BackgroundColor", null);
  this.setStyleHandler("TextAlign", null);
  var pointer = this;
  this.init = function() {
    this.setInitialized(true);
    var comp = document.createElement("button");
    comp.classList.add("CTAT-done-button");
    this.setComponent(comp);
    var button_content = document.createElement("div");
    button_content.classList.add("CTAT-done-button--content");
    comp.appendChild(button_content);
    var checkmark = document.createElement("div");
    checkmark.textContent = "\u2714";
    checkmark.classList.add("CTAT-done-button--icon");
    button_content.appendChild(checkmark);
    if (this.getText()) {
      var button_text = document.createElement("div");
      button_text.classList.add("CTAT-done-button--text");
      button_text.textContent = this.getText();
      button_content.appendChild(button_text);
    }
    this.getDivWrap().appendChild(comp);
    comp.addEventListener("mouseenter", function(e) {
      e.target.classList.add("CTAT-done-button--hover");
    });
    comp.addEventListener("mouseleave", function(e) {
      e.target.classList.remove("CTAT-done-button--hover");
      e.target.classList.remove("CTAT-done-button--clicked");
    });
    comp.addEventListener("mousedown", function(e) {
      e.target.classList.add("CTAT-done-button--clicked");
    });
    comp.addEventListener("mouseup", function(e) {
      e.target.classList.remove("CTAT-done-button--clicked");
    });
    comp.addEventListener("click", function(e) {
      e.target.classList.remove("CTAT-done-button--clicked");
    });
    comp.addEventListener("click", this.processClick);
    comp.addEventListener("focus", this.processFocus);
  };
  this.processClick = function(e) {
    if (pointer.getEnabled() && CTATCommShell.commShell) {
      var focusEvent = new FocusEvent(pointer.getName(), {currentTarget:pointer, relatedTarget:CTATGlobals.Tab.Focus && typeof CTATGlobals.Tab.Focus.getComponent == "function" ? CTATGlobals.Tab.Focus.getComponent() : null});
      pointer.processFocus(focusEvent);
      CTATCommShell.commShell.processDone(pointer.getCompletionStatus());
    }
  };
  this.getCompletionStatus = function() {
    return this.getDivWrap() ? this.getDivWrap().getAttribute("data-ctat-completion-status") : "";
  };
  this.setCompletionStatus = function(status) {
    this.getDivWrap() && this.getDivWrap().setAttribute("data-ctat-completion-status", String(status));
    return this;
  };
};
CTATDoneButton.prototype = Object.create(CTAT.Component.Base.Clickable.prototype);
CTATDoneButton.prototype.constructor = CTATDoneButton;
CTAT.ComponentRegistry.addComponentType("CTATDoneButton", CTATDoneButton);
goog.provide("CTATDragNDrop");
goog.require("CTAT.Component.Base.Tutorable");
goog.require("CTAT.ComponentRegistry");
goog.require("CTATGlobalFunctions");
goog.require("CTATSAI");
CTATDragNDrop = function() {
  CTAT.Component.Base.Tutorable.call(this, "CTATDragNDrop", "aDnD");
  this.setParameterHandler("groupname", function(aName) {
    if (this.getDivWrap()) {
      $(this.getDivWrap()).attr("name", aName);
    }
  });
  this.set_child_limit = function(aNum) {
    var val = parseInt(aNum);
    if (!isNaN(val)) {
      $(this.component).attr("data-ctat-max-cardinality", val);
    }
  };
  this.setParameterHandler("MaxObjects", this.set_child_limit);
  this.get_child_limit = function() {
    var lim = parseInt($(this.component).attr("data-ctat-max-cardinality"));
    return isNaN(lim) ? -1 : lim;
  };
  var hash = function(s) {
    return s.split("").reduce(function(a, b) {
      a = (a << 5) - a + b.charCodeAt(0);
      return a & a;
    }, 0);
  };
  var handle_drag_start = function(e) {
    var groupname = $(this).parent().attr("name");
    var parent = $(this).parent().attr("id");
    e.dataTransfer.setData("ctat/group", groupname);
    e.dataTransfer.setData("ctat/source", parent);
    e.dataTransfer.setData("text", this.id);
    var hid = hash(this.id);
    CTATDragNDrop.dragging[hid] = {id:this.id, group:groupname, source:parent};
    e.dataTransfer.setData("ctat/id/" + hid, hid);
  };
  var handle_drag_end = function(e) {
    var dndid;
    for (var i = 0;i < e.dataTransfer.types.length;i++) {
      dndid = /^ctat\/id\/(.+)$/.exec(e.dataTransfer.types[i]);
      if (dndid) {
        var hid = dndid[1];
        if (CTATDragNDrop.dragging.hasOwnProperty(hid)) {
          delete CTATDragNDrop.dragging[hid];
        }
      }
    }
  };
  var dnd = null;
  this.init = function() {
    dnd = this.getDivWrap();
    if (!$(dnd).attr("name")) {
      var gname = CTATDragNDrop.default_groupname;
      if (this.getComponentGroup()) {
        gname = this.getComponentGroup();
      }
      $(dnd).attr("name", gname);
    }
    this.setComponent(dnd);
    CTATComponentReference.add(this, dnd);
    if (!CTATConfiguration.get("previewMode")) {
      $(dnd).children().addClass("CTATDragNDrop--item").attr({unselectable:"on", draggable:true}).each(function() {
        if (!this.id) {
          this.id = CTATGlobalFunctions.gensym.div_id();
        }
        this.addEventListener("dragstart", handle_drag_start, false);
        this.addEventListener("dragend", handle_drag_end, false);
      });
    }
    this.component.addEventListener("dragover", function(e) {
      var allow_drop = false;
      if ($(this).data("CTATComponent").getEnabled()) {
        var limit = parseInt($(this).attr("data-ctat-max-cardinality"));
        if (isNaN(limit) || limit < 0 || $(this).children().length < limit) {
          var types = new Set(e.dataTransfer.types);
          if (types.has("ctat/group")) {
            if (e.dataTransfer.getData("text")) {
              if (e.dataTransfer.getData("ctat/group") === $(this).attr("name") && e.dataTransfer.getData("ctat/source") !== this.id) {
                allow_drop = true;
              }
            } else {
              var dndid;
              for (var i = 0;i < e.dataTransfer.types.length;i++) {
                dndid = /^ctat\/id\/(.+)$/.exec(e.dataTransfer.types[i]);
                if (dndid) {
                  var hid = dndid[1];
                  if (CTATDragNDrop.dragging.hasOwnProperty(hid) && CTATDragNDrop.dragging[hid].group === $(this).attr("name") && CTATDragNDrop.dragging[hid].source !== this.id) {
                    allow_drop = true;
                  }
                }
              }
            }
          }
        }
      }
      if (allow_drop) {
        e.preventDefault();
        e.dataTransfer.effectAllowed = "move";
        e.dataTransfer.dropEffect = "move";
        this.classList.add("CTATDragNDrop--valid-drop");
      }
    }, false);
    this.component.addEventListener("drop", function(e) {
      e.preventDefault();
      this.classList.remove("CTATDragNDrop--valid-drop");
      var comp = $(this).data("CTATComponent");
      if (comp.getEnabled()) {
        var item_id = e.dataTransfer.getData("text");
        var source_id = e.dataTransfer.getData("ctat/source");
        var item = document.getElementById(item_id);
        this.appendChild(item);
        $("#" + item_id).removeClass("CTAT--correct CTAT--incorrect CTAT--hint");
        comp.setActionInput("Add", item_id);
        comp.processAction();
      }
    }, false);
    this.component.addEventListener("dragleave", function(e) {
      this.classList.remove("CTATDragNDrop--valid-drop");
    }, false);
    this.setInitialized(true);
  };
  this.getConfigurationActions = function() {
    var actions = [];
    var items = [];
    $(this.component).children().each(function() {
      items.push($(this).attr("id"));
    });
    if (items.length > 0) {
      var sai = new CTATSAI;
      sai.setSelection(this.getName());
      sai.setAction("SetChildren");
      sai.setInput(items.sort().join(";"));
      actions.push(sai);
    }
    return actions;
  };
  var super_setEnabled = this.setEnabled;
  this.setEnabled = function(bool) {
    super_setEnabled(bool);
    if (dnd) {
      $(dnd).children().attr("draggable", bool);
      if (this.getDisableOnCorrect()) {
        $(dnd).find(".CTAT--correct").attr("draggable", false);
      }
    }
  };
  this.Add = function(aId) {
    var target = $("#" + aId);
    if (target.length > 0) {
      target.appendTo(this.getDivWrap());
    }
    if (!$(target).hasClass("CTATDragNDrop--item")) {
      $(target).addClass("CTATDragNDrop--item").attr({unselectable:"on", draggable:true});
      target.addEventListener("dragstart", handle_drag_start, false);
      target.addEventListener("dragend", handle_drag_end, false);
    }
  };
  this.SetChildren = function(list_of_ids) {
    list_of_ids.split(";").forEach(function(aId) {
      this.Add(aId);
    }, this);
  };
  this.updateSAI = function() {
    var items = [];
    $(this.component).children().each(function() {
      items.push($(this).attr("id"));
    });
    this.setActionInput("SetChildren", items.sort().join(";"));
  };
  var super_showCorrect = this.showCorrect.bind(this);
  this.showCorrect = function(aSAI) {
    var action = aSAI.getAction();
    switch(action) {
      case "Add":
        this.setEnabled(true);
        var id = aSAI.getInput();
        $("#" + id).addClass("CTAT--correct");
        if (this.getDisableOnCorrect()) {
          $("#" + id).attr("draggable", false);
        }
        break;
      case "SetChildren":
      ;
      default:
        super_showCorrect(aSAI);
        break;
    }
  };
  var super_showInCorrect = this.showInCorrect.bind(this);
  this.showInCorrect = function(aSAI) {
    var action = aSAI.getAction();
    switch(action) {
      case "Add":
        var id = aSAI.getInput();
        $("#" + id).addClass("CTAT--incorrect");
        break;
      case "SetChildren":
      ;
      default:
        super_showInCorrect(aSAI);
        break;
    }
  };
};
CTATDragNDrop.dragging = {};
CTATDragNDrop.default_groupname = "DragNDropGroup";
CTATDragNDrop.prototype = Object.create(CTAT.Component.Base.Tutorable.prototype);
CTATDragNDrop.prototype.constructor = CTATDragNDrop;
CTAT.ComponentRegistry.addComponentType("CTATDragNDrop", CTATDragNDrop);
goog.provide("CTATDragSource");
goog.require("CTAT.Component.Base.Tutorable");
goog.require("CTAT.ComponentRegistry");
goog.require("CTATGlobalFunctions");
goog.require("CTATSAI");
var CTATDragSource = function() {
  CTAT.Component.Base.Tutorable.call(this, "CTATDragSource", "aDnD");
  this.setParameterHandler("groupname", function(aName) {
    if (this.getDivWrap()) {
      $(this.getDivWrap()).attr("name", aName);
    }
  });
  this.set_child_limit = function(aNum) {
    var val = parseInt(aNum);
    if (!isNaN(val)) {
      $(this.component).attr("data-ctat-max-cardinality", val);
    }
  };
  this.setParameterHandler("MaxObjects", this.set_child_limit);
  this.get_child_limit = function() {
    var lim = parseInt($(this.component).attr("data-ctat-max-cardinality"));
    return isNaN(lim) ? -1 : lim;
  };
  this.set_child_overflow = function(aNum) {
    var val = parseInt(aNum);
    if (!isNaN(val)) {
      $(this.component).attr("data-ctat-max-overflow", val);
    }
  };
  this.setParameterHandler("MaxOverflow", this.set_child_overflow);
  this.get_child_overflow = function() {
    var lim = parseInt($(this.component).attr("data-ctat-max-overflow"));
    return isNaN(lim) ? -1 : lim;
  };
  this.set_purpose = function(aString) {
    if (aString) {
      $(this.component).attr("data-ctat-purpose", aString);
    } else {
      $(this.component).attr("data-ctat-purpose", "destination");
    }
  };
  this.setParameterHandler("Purpose", this.set_purpose);
  this.get_purpose = function() {
    if ($(this.component).attr("data-ctat-purpose")) {
      return $(this.component).attr("data-ctat-purpose");
    } else {
      return "destination";
    }
  };
  var hash = function(s) {
    return s.split("").reduce(function(a, b) {
      a = (a << 5) - a + b.charCodeAt(0);
      return a & a;
    }, 0);
  };
  var handle_drag_start = function(e) {
    var groupname = $(this).parent().attr("name");
    var parent = $(this).parent().attr("id");
    e.dataTransfer.setData("ctat/group", groupname);
    e.dataTransfer.setData("ctat/source", parent);
    e.dataTransfer.setData("original", this.id);
    if ($("#" + parent).attr("data-ctat-purpose") === "source") {
      var cloneId = this.id + "--" + CTATGlobalFunctions.gensym.div_id().slice(7);
      e.dataTransfer.setData("text", cloneId);
      var hid = hash(cloneId);
      e.dataTransfer.setData("ctat/id/" + hid, hid);
      CTATDragSource.dragging[hid] = {id:cloneId, group:groupname, source:parent};
    } else {
      e.dataTransfer.setData("text", this.id);
      var hid = hash(this.id);
      e.dataTransfer.setData("ctat/id/" + hid, hid);
      CTATDragSource.dragging[hid] = {id:this.id, group:groupname, source:parent};
    }
  };
  var handle_drag_end = function(e) {
    var dndid;
    for (var i = 0;i < e.dataTransfer.types.length;i++) {
      dndid = /^ctat\/id\/(.+)$/.exec(e.dataTransfer.types[i]);
      if (dndid) {
        var hid = dndid[1];
        if (CTATDragSource.dragging.hasOwnProperty(hid)) {
          delete CTATDragSource.dragging[hid];
        }
      }
    }
  };
  var pointer = this;
  pointer.setDisabled = function(x) {
    try {
      if (x.type !== "button") {
        x.disabled = true;
      }
      if (x.children.length > 0) {
        for (var i = 0;i < x.children.length;i++) {
          pointer.setDisabled(x.children[i]);
        }
      }
    } catch (err) {
    }
  };
  pointer.removeDisabled = function(x) {
    x.disabled = false;
    if (x.children.length > 0) {
      for (var i = 0;i < x.children.length;i++) {
        pointer.removeDisabled(x.children[i]);
      }
    }
  };
  pointer.animatedRemove = function(childID) {
    $("#" + childID).animate({opacity:.1, zoom:1.3}, 500, "swing", function() {
      var focus = document.getElementById(childID);
      var parent = focus.parentNode;
      parent.removeChild(focus);
    });
  };
  var dnd = null;
  this.init = function() {
    dnd = this.getDivWrap();
    if (!$(dnd).attr("name")) {
      var gname = CTATDragSource.default_groupname;
      if (this.getComponentGroup()) {
        gname = this.getComponentGroup();
      }
      $(dnd).attr("name", gname);
    }
    this.setComponent(dnd);
    CTATComponentReference.add(this, dnd);
    if (!CTATConfiguration.get("previewMode")) {
      $(dnd).children().addClass("CTATDragSource--item").attr({unselectable:"on", draggable:true}).each(function() {
        if (!this.id) {
          this.id = CTATGlobalFunctions.gensym.div_id();
        }
        this.addEventListener("dragstart", handle_drag_start, false);
        this.addEventListener("dragend", handle_drag_end, false);
      });
    }
    if (dnd.getAttribute("data-ctat-purpose") === "source") {
      window.onload = function() {
        pointer.setDisabled(dnd);
      };
    }
    this.component.addEventListener("dragover", function(e) {
      var allow_drop = false;
      if ($(this).data("CTATComponent").getEnabled()) {
        var limit = parseInt($(this).attr("data-ctat-max-cardinality"));
        if (isNaN(limit) || limit < 0 || $(this).children().length < limit) {
          var types = new Set(e.dataTransfer.types);
          if (types.has("ctat/group")) {
            if (e.dataTransfer.getData("text")) {
              if (e.dataTransfer.getData("ctat/group") === $(this).attr("name") && e.dataTransfer.getData("ctat/source") !== this.id) {
                allow_drop = true;
              }
            } else {
              var dndid;
              for (var i = 0;i < e.dataTransfer.types.length;i++) {
                dndid = /^ctat\/id\/(.+)$/.exec(e.dataTransfer.types[i]);
                if (dndid) {
                  var hid = dndid[1];
                  if (CTATDragSource.dragging.hasOwnProperty(hid) && CTATDragSource.dragging[hid].group === $(this).attr("name") && CTATDragSource.dragging[hid].source !== this.id) {
                    allow_drop = true;
                  }
                }
              }
            }
          }
        }
      }
      if ($(e.target).attr("data-ctat-purpose") === "source") {
        allow_drop = false;
      }
      if (allow_drop) {
        e.preventDefault();
        e.dataTransfer.effectAllowed = "move";
        e.dataTransfer.dropEffect = "move";
        this.classList.add("CTATDragSource--valid-drop");
      }
    }, false);
    this.component.addEventListener("drop", function(e) {
      e.preventDefault();
      this.classList.remove("CTATDragSource--valid-drop");
      var comp = $(this).data("CTATComponent");
      if (comp.getEnabled()) {
        var item_id = e.dataTransfer.getData("text");
        var item;
        if (document.getElementById(item_id)) {
          item = document.getElementById(item_id);
          this.appendChild(item);
        }
        if (!document.getElementById(item_id)) {
          var original = document.getElementById(e.dataTransfer.getData("original"));
          item = original.cloneNode(false);
          this.append(item);
          item.id = item_id;
          item.addEventListener("dragstart", handle_drag_start, false);
          item.addEventListener("dragend", handle_drag_end, false);
          var componentType;
          var CTATClassRegex = /(CTAT[A-z]*)(\s|$)/g;
          var ctatClass = CTATClassRegex.exec(item.className);
          if (ctatClass) {
            for (var i = 0;i < ctatClass.length;i++) {
              if (CTAT.ComponentRegistry[ctatClass[i]]) {
                componentType = ctatClass[i];
              }
            }
          }
          if (componentType) {
            CTATTutor.initializeHTMLComponent(item, componentType);
          }
          item.setAttribute("draggable", true);
          item.setAttribute("unselectable", "on");
          var oldLength = original.childNodes.length;
          var newLength = item.childNodes.length;
          original.classList.remove("CTAT--correct");
          original.classList.remove("CTAT--incorrect");
          original.classList.remove("CTAT--hint");
          if (newLength === oldLength) {
            for (var i = 0;i < newLength;i++) {
              item.childNodes[i].setAttribute("class", original.childNodes[i].className);
              item.childNodes[i].setAttribute("value", original.childNodes[i].value);
              item.childNodes[i].innerHTML = original.childNodes[i].innerHTML;
            }
          }
          if (oldLength !== newLength) {
            while (item.hasChildNodes()) {
              item.removeChild(item.lastChild);
            }
            for (var i = 0;i < oldLength;i++) {
              item.appendChild(original.childNodes[i].cloneNode(true));
            }
          }
        }
        if ($(this).attr("data-ctat-purpose") === "trashcan") {
          this.removeChild(item);
        }
        if ($(this).attr("data-ctat-purpose") === "source") {
          this.removeChild(item);
        }
        if ($(this).attr("data-ctat-purpose") === "destination" || !$(this).attr("data-ctat-purpose")) {
          $("#" + item.id).removeClass("CTAT--correct CTAT--incorrect CTAT--hint");
          pointer.removeDisabled(item);
          comp.setActionInput("Add", item_id);
          comp.processAction();
          if ($(this).attr("data-ctat-max-overflow") !== null && this.childNodes.length > $(this).attr("data-ctat-max-overflow")) {
            pointer.animatedRemove(this.firstChild.id);
          }
        }
      }
    }, false);
    this.component.addEventListener("dragleave", function(e) {
      this.classList.remove("CTATDragSource--valid-drop");
    }, false);
    this.setInitialized(true);
  };
  this.getConfigurationActions = function() {
    var actions = [];
    var items = [];
    $(this.component).children().each(function() {
      items.push($(this).attr("id"));
    });
    if (items.length > 0) {
      var sai = new CTATSAI;
      sai.setSelection(this.getName());
      sai.setAction("SetChildren");
      sai.setInput(items.sort().join(";"));
      actions.push(sai);
    }
    return actions;
  };
  var super_setEnabled = this.setEnabled;
  this.setEnabled = function(bool) {
    super_setEnabled(bool);
    if (dnd) {
      $(dnd).children().attr("draggable", bool);
      if (this.getDisableOnCorrect()) {
        $(dnd).find(".CTAT--correct").attr("draggable", false);
      }
    }
  };
  this.Add = function(aId) {
    var target = $("#" + aId);
    if (target.length > 0) {
      target.appendTo(this.getDivWrap());
    }
    if (!$(target).hasClass("CTATDragSource--item")) {
      $(target).addClass("CTATDragSource--item").attr({unselectable:"on", draggable:true});
      target.addEventListener("dragstart", handle_drag_start, false);
      target.addEventListener("dragend", handle_drag_end, false);
    }
  };
  this.SetChildren = function(list_of_ids) {
    list_of_ids.split(";").forEach(function(aId) {
      this.Add(aId);
    }, this);
  };
  this.updateSAI = function() {
    var items = [];
    $(this.component).children().each(function() {
      items.push($(this).attr("id"));
    });
    this.setActionInput("SetChildren", items.sort().join(";"));
  };
  var super_showCorrect = this.showCorrect.bind(this);
  this.showCorrect = function(aSAI) {
    var action = aSAI.getAction();
    switch(action) {
      case "Add":
        this.setEnabled(true);
        var id = aSAI.getInput();
        $("#" + id).addClass("CTAT--correct");
        if (this.getDisableOnCorrect()) {
          $("#" + id).attr("draggable", false);
        }
        break;
      case "SetChildren":
      ;
      default:
        super_showCorrect(aSAI);
        break;
    }
  };
  var super_showInCorrect = this.showInCorrect.bind(this);
  this.showInCorrect = function(aSAI) {
    var action = aSAI.getAction();
    switch(action) {
      case "Add":
        var id = aSAI.getInput();
        $("#" + id).addClass("CTAT--incorrect");
        break;
      case "SetChildren":
      ;
      default:
        super_showInCorrect(aSAI);
        break;
    }
  };
};
CTATDragSource.dragging = {};
CTATDragSource.default_groupname = "DragNDropGroup";
CTATDragSource.prototype = Object.create(CTAT.Component.Base.Tutorable.prototype);
CTATDragSource.prototype.constructor = CTATDragSource;
CTAT.ComponentRegistry.addComponentType("CTATDragSource", CTATDragSource);
goog.provide("CTATElement");
goog.require("CTATGlobalFunctions");
goog.require("CTAT.Component.Base.SAIHandler");
goog.require("CTAT.ComponentRegistry");
CTATElement = function(aDescription, aX, aY, aWidth, aHeight) {
  CTAT.Component.Base.SAIHandler.call(this, "CTATElement", "__undefined__", aDescription, aX, aY, aWidth, aHeight);
  var previewMode = CTATConfiguration.get("previewMode");
  this.setStyleHandler("inspBackgroundColor", null);
  this.setStyleHandler("BackgroundColor", null);
  this.setStyleHandler("DrawBorder", null);
  this.setStyleHandler("showBorder", null);
  this.setStyleHandler("BorderColor", null);
  this.setStyleHandler("TextAlign", null);
  var pointer = this;
  this.setStyleHandler("labelPlacement", null);
  var handle_selection = function(e) {
    this.updateSAI();
    this.processClick(e);
  };
  this.init = function init() {
    pointer.setInitialized(true);
    console.log("CTATElement.init() typeof getDivWrap()", typeof pointer.getDivWrap(), pointer.getDivWrap());
    pointer.ctatdebug("Final location: " + pointer.getX() + "," + pointer.getY() + " with text: " + pointer.getText());
    pointer.addComponentReference(pointer, pointer.getDivWrap());
  };
  this.resize = function() {
    var height = $(this.getDivWrap()).height();
    $(label).css("font-size", height - 5 + "px");
    $(this.getComponent()).css("height", height - 10 + "px");
    $(this.getComponent()).css("width", height - 10 + "px");
  };
  this.getConfigurationActions = function() {
    return [];
  };
};
CTATElement.prototype = Object.create(CTAT.Component.Base.SAIHandler.prototype);
CTATElement.prototype.constructor = CTATElement;
CTAT.ComponentRegistry.addComponentType("CTATElement", CTATElement);
goog.provide("CTAT.Math");
CTAT.Math = {LeastCommonMultiple:function(a, b) {
  return a * b / CTAT.Math.GreatestCommonDivisor(a, b);
}, GreatestCommonDivisor:function(a, b) {
  if (a < 0 || b < 0) {
    return CTAT.Math.GreatestCommonDivisor(Math.abs(a), Math.abs(b));
  }
  if (a === 1 || b === 1) {
    return 1;
  }
  if (a === 0) {
    return b;
  }
  if (b === 0) {
    return a;
  }
  var gcd = function(x, y) {
    return !y ? x : gcd(y, x % y);
  };
  return gcd(a, b);
}, round10:function(value, exponent) {
  if (typeof exponent === "undefined" || Number(exponent) === 0) {
    return Math.round(value);
  }
  value = Number(value);
  exponent = Number(exponent);
  if (isNaN(value) || !(typeof exponent === "number" && exponent % 1 === 0)) {
    return NaN;
  }
  value = value.toString().split("e");
  value = Math.round(Number(value[0]) + "e" + (value[1] ? Number(value[1]) - exponent : -exponent));
  value = value.toString().split("e");
  return Number(value[0] + "e" + (value[1] ? Number(value[1]) + exponent : exponent));
}, precision:4, round:function(value) {
  return CTAT.Math.round10(value, -CTAT.Math.precision);
}, rad2deg:function(radians) {
  return CTAT.Math.round(radians * 180 / Math.PI);
}, deg2rad:function(degrees) {
  return degrees * Math.PI / 180;
}};
goog.provide("CTAT.Math.Fraction");
goog.require("CTAT.Math");
CTAT.Math.Fraction = function(num, den) {
  this._numerator = 0;
  this._denominator = 1;
  this.set(num, den);
};
CTAT.Math.Fraction.prototype = Object.create(CTAT.Math.Fraction.prototype, {numerator:{get:function() {
  return this._numerator;
}, set:function(value) {
  this._numerator = value;
}}, denominator:{get:function() {
  return this._denominator;
}, set:function(value) {
  this._denominator = value;
}}, toString:{value:function() {
  if (this.denominator === 1) {
    return String(this._numerator);
  }
  return String(this._numerator) + "/" + String(this._denominator);
}}, valueOf:{value:function() {
  return this.numerator / this.denominator;
}}, fromString:{value:function(str) {
  var fraction_regEx = /(\d*\.?\d*)\s*\/\s*(\d*\.?\d*)/;
  var fraction_array = str.match(fraction_regEx);
  if (fraction_array) {
    this._numerator = Number(fraction_array[1]);
    this._denominator = Number(fraction_array[2]);
  } else {
    this.fromValue(str);
  }
}}, fromValue:{value:function(num) {
  this._numerator = Number(num.valueOf());
  this._denominator = 1;
}}, toMathML:{value:function() {
  var mathml = "http://www.w3.org/1998/Math/MathML";
  var math = document.createElementNS(mathml, "math");
  var num = document.createElementNS(mathml, "mn");
  num.textContent = this.numerator;
  if (this.denominator == 1) {
    math.appendChild(num);
  } else {
    var frac = document.createElementNS(mathml, "mfrac");
    var nrow = document.createElementNS(mathml, "mrow");
    nrow.appendChild(num);
    frac.appendChild(nrow);
    var drow = document.createElementNS(mathml, "mrow");
    var den = document.createElementNS(mathml, "mn");
    den.textContent = this.denominator;
    drow.appendChild(den);
    frac.appendChild(drow);
    math.appendChild(frac);
  }
  return math;
}}, is_proper:{get:function() {
  return Math.abs(this._numerator) < Math.abs(this._denominator);
}}, whole_part:{get:function() {
  return Math.floor(this.valueOf());
}}, remainder_part:{get:function() {
  return new CTAT.Math.Fraction(this._numerator % this._denominator, this._denominator);
}}, set_denominator:{value:function(denominator) {
  this._numerator = this.numerator * denominator / this.denominator;
  if (Math.abs(this.numerator - Math.round(this.numerator)) < 1E-9) {
    this.numerator = Math.round(this.numerator);
  }
  this._denominator = denominator;
  return this;
}}, scale:{value:function(factor) {
  this._numerator *= factor;
  if (factor === 0) {
    this._denominator = 1;
  } else {
    this._denominator = Math.abs(this._denominator * factor);
  }
}}, set:{value:function(numerator, denominator) {
  this._numerator = 0;
  this._denominator = 1;
  if (typeof numerator !== "undefined" && denominator) {
    if (typeof numerator === "number") {
      this.numerator = numerator;
    } else {
      if (typeof numerator === "string") {
        this.numerator = Number(numerator);
      } else {
        if (numerator) {
          this.numerator = numerator.valueOf();
        } else {
          this.numerator = 0;
        }
      }
    }
    if (typeof denominator === "number") {
      this.denominator = denominator;
    } else {
      if (typeof denominator === "string") {
        this.denominator = Number(denominator);
      } else {
        this.denominator = denominator.valueOf();
      }
    }
  } else {
    if (numerator) {
      if (numerator instanceof CTAT.Math.Fraction) {
        this.numerator = numerator.numerator;
        this.denominator = numerator.denominator;
      } else {
        if (typeof numerator === "number") {
          this.numerator = numerator;
          this.denominator = 1;
        } else {
          if (typeof numerator === "string") {
            this.fromString(numerator);
          } else {
            if (numerator) {
              this.numerator = numerator.valueOf();
              this.denominator = 1;
            } else {
              this.numerator = 0;
              this.denominator = 1;
            }
          }
        }
      }
    }
  }
  if (isNaN(this._numerator)) {
    this._numerator = 0;
  }
  if (isNaN(this._denominator)) {
    this._denominator = 1;
  }
  return this;
}}, reduce:{value:function() {
  var divisor = CTAT.Math.GreatestCommonDivisor(this.numerator, this.denominator);
  this._numerator /= divisor;
  this._denominator /= divisor;
  return this;
}}, reduced:{value:function() {
  var fraction = new CTAT.Math.Fraction(this);
  fraction.reduce();
  return fraction;
}}, reciprocal:{value:function() {
  return new CTAT.Math.Fraction(this.denominator, this.numerator);
}}, negative:{value:function() {
  return new CTAT.Math.Fraction(-this.numerator, this.denominator);
}}, add:{value:function(addend) {
  var result = new CTAT.Math.Fraction;
  if (addend instanceof CTAT.Math.Fraction) {
    if (this.numerator === 0 || isNaN(this.numerator)) {
      result.set(addend.numerator, addend.denominator);
    } else {
      if (addend.numerator === 0 || isNaN(addend.numerator)) {
        result.set(this.numerator, this.denominator);
      } else {
        if (this.denominator == addend.denominator) {
          result.set(this.numerator + addend.numerator, this.denominator);
        } else {
          result.set(this.numerator * addend.denominator + addend.numerator * this.denominator, this.denominator * addend.denominator);
          result.reduce();
        }
      }
    }
  } else {
    if (typeof addend === "string") {
      var adder = new CTAT.Math.Fraction(addend);
      result = this.add(adder);
    } else {
      result.set(addend.valueOf() * this.denominator + this.numerator, this.denominator);
    }
  }
  return result;
}}, subtract:{value:function(addend) {
  if (addend instanceof CTAT.Math.Fraction) {
    return this.add(addend.negative());
  } else {
    if (typeof addend === "string") {
      var subend = new CTAT.Math.Fraction(addend);
      return this.add(subend.negative());
    } else {
      return this.add(-addend.valueOf());
    }
  }
}}, multiply:{value:function(multican) {
  var result;
  if (multican instanceof CTAT.Math.Fraction) {
    result = new CTAT.Math.Fraction(this.numerator * multican.numerator, this.denominator * multican.denominator);
    result.reduce();
  } else {
    if (typeof multican === "string") {
      var mult = new CTAT.Math.Fraction(multican);
      result = this.multiply(mult);
    } else {
      result = new CTAT.Math.Fraction(multican.valueOf() * this.numerator, this.denominator);
      result.reduce();
    }
  }
  return result;
}}, divide:{value:function(multican) {
  if (multican instanceof CTAT.Math.Fraction) {
    return this.multiply(multican.reciprocal());
  } else {
    if (typeof multican === "string") {
      var divisor = new CTAT.Math.Fraction(multican);
      return this.multiply(divisor.reciprocal());
    } else {
      return this.multiply(new CTAT.Math.Fraction(1, multican.valueOf()));
    }
  }
}}, equals:{value:function(cmp) {
  return CTAT.Math.round(this.valueOf()) === CTAT.Math.round(cmp.valueOf());
}}, deepEquals:{value:function(cmp) {
  return cmp instanceof CTAT.Math.Fraction && this.numerator === cmp.numerator && this.denominator === cmp.denominator;
}}, clone:{value:function() {
  return new CTAT.Math.Fraction(this.numerator, this.denominator);
}}});
CTAT.Math.Fraction.FromString = function(str) {
  var frac = new CTAT.Math.Fraction;
  frac.setFromString(String(str));
  return frac;
};
CTAT.Math.Fraction.FromNumber = function(dec) {
  var frac = new CTAT.Math.Fraction(dec);
  frac.reduce();
  return frac;
};
CTAT.Math.Fraction.Sum = function() {
  var result = new CTAT.Math.Fraction;
  for (var i = 0;i < arguments.length;i++) {
    result = result.add(arguments[i]);
  }
  return result;
};
CTAT.Math.Fraction.Product = function() {
  var result = new CTAT.Math.Fraction(1, 1);
  for (var i = 0;i < arguments.length;i++) {
    result = result.multiply(arguments[i]);
  }
  return result;
};
goog.provide("CTAT.Component.Base.SVG");
goog.require("CTATGlobalFunctions");
goog.require("CTATGlobals");
goog.require("CTAT.Component.Base.Clickable");
CTAT.Component.Base.SVG = function(aClassName, aName, aDescription, aX, aY, aWidth, aHeight) {
  CTAT.Component.Base.Clickable.call(this, aClassName, aName, aDescription, aX, aY, aWidth, aHeight);
  var svg = null;
  this.initSVG = function() {
    this.setInitialized(true);
    var svgNS = CTATGlobals.NameSpace.svg;
    var xmlns = CTATGlobals.NameSpace.xml;
    var xlinkNS = CTATGlobals.NameSpace.xlink;
    var evNS = CTATGlobals.NameSpace.ev;
    var svgFragment = document.createDocumentFragment();
    svg = document.createElementNS(svgNS, "svg");
    svgFragment.appendChild(svg);
    svg.classList.add("CTAT-gen-component");
    svg.classList.add("CTAT-svg");
    svg.classList.add("unselectable");
    svg.setAttributeNS(xmlns, "xmlns", svgNS);
    svg.setAttributeNS(xmlns, "xmlns:xlink", xlinkNS);
    svg.setAttributeNS(xmlns, "xmlns:ev", evNS);
    var defs = document.createElementNS(svgNS, "defs");
    svg.appendChild(defs);
    this.getDivWrap().appendChild(svgFragment);
    this.setComponent(svg);
  };
  this.genName = function(suffix) {
    return this.getName() + "_" + suffix;
  };
  this.getBoundingBox = function() {
    var bbox = new DOMRect(0, 0, this.getWidth(), this.getHeight());
    var comp = this.getComponent();
    var cstyle = window.getComputedStyle(comp);
    var padding = {left:parseInt(cstyle.getPropertyValue("padding-left")), top:parseInt(cstyle.getPropertyValue("padding-right")), bottom:parseInt(cstyle.getPropertyValue("padding-bottom")), right:parseInt(cstyle.getPropertyValue("padding-right"))};
    var border = {left:parseInt(cstyle.getPropertyValue("border-left-width")), top:parseInt(cstyle.getPropertyValue("border-right-width")), bottom:parseInt(cstyle.getPropertyValue("border-bottom-width")), right:parseInt(cstyle.getPropertyValue("border-right-width"))};
    bbox.width -= padding.left + padding.right + border.left + border.right;
    bbox.height -= padding.top + padding.bottom + border.top + border.bottom;
    return bbox;
  };
};
CTAT.Component.Base.SVG.prototype = Object.create(CTAT.Component.Base.Clickable.prototype);
CTAT.Component.Base.SVG.prototype.constructor = CTAT.Component.Base.SVG;
goog.provide("CTAT.Component.Base.UnitDisplay");
goog.require("CTATGlobalFunctions");
goog.require("CTAT.Math");
goog.require("CTAT.Math.Fraction");
goog.require("CTAT.Component.Base.SVG");
goog.require("CTAT.Component.Base.Tutorable");
CTAT.Component.Base.UnitDisplay = function(aClassName, aName, aDescription, aX, aY, aWidth, aHeight) {
  CTAT.Component.Base.SVG.call(this, aClassName, aName, aDescription, aX, aY, aWidth, aHeight);
  var _value = "1/2+1/4+(0*1/8)";
  this.setActionInput("SetPieces", _value);
  var color = "#800080";
  this.color = color;
  var colorAlpha = 1;
  this.colorAlpha = colorAlpha;
  var deselectedColor = "#800080";
  this.deselectedColor = deselectedColor;
  var deselectedColorAlpha = .3;
  this.deselectedColorAlpha = deselectedColorAlpha;
  var piece_border_color = "black";
  this.piece_border_color = piece_border_color;
  var piece_border_thickness = 1;
  this.piece_border_thickness = piece_border_thickness;
  this.getPieceBorderColor = function() {
    return piece_border_color;
  };
  this.setPieceBorderColor = function(aColor) {
    piece_border_color = CTATGlobalFunctions.formatColor(aColor);
    return this;
  };
  var _pieces = [];
  var pieceClass = "UnitPart";
  var pointer = this;
  this.generateClassname = function() {
    return this.getName() + " " + pieceClass;
  };
  this.getPieces = function() {
    return _pieces;
  };
  var is_selected = function(piece) {
    if (piece.hasAttributeNS(null, "data-selected")) {
      return CTATGlobalFunctions.toBoolean(piece.getAttributeNS(null, "data-selected"));
    } else {
      piece.setAttributeNS(null, "data-selected", true);
      return true;
    }
  };
  this.getPiecesBySelected = function(status) {
    var pieces = this.getPieces();
    var selected = [];
    var piece;
    for (var i = 0;i < pieces.length;i++) {
      piece = pieces[i];
      if (is_selected(piece) === status) {
        selected.push(piece);
      }
    }
    return selected;
  };
  this.getSelectedPieces = this.getPiecesBySelected.bind(this, true);
  this.getDeselectedPieces = this.getPiecesBySelected.bind(this, false);
  this.getColor = function() {
    return color;
  };
  this.getColorAlpha = function() {
    return colorAlpha;
  };
  this.getDeselectedColor = function() {
    return deselectedColor;
  };
  this.getDeselectedColorAlpha = function() {
    return deselectedColorAlpha;
  };
  this.setColor = function(aColor) {
    color = CTATGlobalFunctions.formatColor(aColor);
    this.color = color;
    var pieces = this.getSelectedPieces();
    for (var i = 0;i < pieces.length;i++) {
      $(pieces[i]).css("fill", color);
    }
  };
  this.setColorAlpha = function(anAlpha) {
    colorAlpha = Number(anAlpha);
    colorAlpha = isNaN(colorAlpha) ? 1 : colorAlpha;
    this.colorAlpha = colorAlpha;
    var pieces = this.getSelectedPieces();
    for (var i = 0;i < pieces.length;i++) {
      $(pieces[i]).css("fill-opacity", colorAlpha);
    }
  };
  this.setDeselectedColor = function(aColor) {
    deselectedColor = CTATGlobalFunctions.formatColor(aColor);
    this.deselectedColor = deselectedColor;
    var pieces = this.getDeselectedPieces();
    for (var i = 0;i < pieces.length;i++) {
      $(pieces[i]).css("fill", color);
    }
  };
  this.setDeselectedColorAlpha = function(aAlpha) {
    deselectedColorAlpha = Number(aAlpha);
    if (isNaN(deselectedColorAlpha)) {
      deselectedColorAlpha = .3;
    }
    this.deselectedColorAlpha = deselectedColorAlpha;
    var pieces = this.getDeselectedPieces();
    for (var i = 0;i < pieces.length;i++) {
      $(pieces[i]).css("fill-opacity", deselectedColorAlpha);
    }
  };
  this.valueOf = function() {
    return this.evaluate();
  };
  this.getValue = function() {
    return _value;
  };
  this.setValue = function(aVal) {
    _value = String(aVal);
    this.setInput(_value);
    this.clear();
    this.drawPieces();
    return _value;
  };
  this.setParameterHandler("Value", this.setValue);
  this.data_ctat_handlers["value"] = function(val) {
    this.setValue(val);
  };
  this.drawPieces = function() {
  };
  this.evaluate = function() {
    var values = this.parseValue();
    var val = values.reduce(function(sum, frac) {
      return frac.selected ? sum.add(frac) : sum;
    }, new CTAT.Math.Fraction);
    return val;
  };
  this.numActive = function() {
    return this.getSelectedPieces().length;
  };
  this.parseValue = function() {
    var arr0 = _value.split("+");
    var arr1 = [];
    arr0.forEach(function(str) {
      var sel = true;
      if (str.search(/(\(\s*0\s*\*)|(\*\s*0\s*\))/) != -1) {
        sel = false;
        str = str.replace(/(\(\s*0\s*\*)|(\*\s*0\s*\))/, "");
        str = str.replace(/[() ]/g, "");
      }
      var frac = new CTAT.Math.Fraction(str);
      frac.selected = sel;
      if (frac > 0) {
        arr1.push(frac);
      }
      return frac;
    });
    return arr1;
  };
  this.updateValue = function() {
    var pieces = this.getPieces();
    var values = pieces.map(function(piece) {
      return genOutValue(piece.getAttributeNS(null, "data-value"), CTATGlobalFunctions.toBoolean(piece.getAttributeNS(null, "data-selected")));
    });
    _value = values.join("+");
    return _value;
  };
  var set_selected = function(target, p_selected) {
    var sel = CTATGlobalFunctions.toBoolean(p_selected);
    var tsel = CTATGlobalFunctions.toBoolean(target.getAttributeNS(null, "data-selected"));
    if (sel === true) {
      target.setAttributeNS(null, "data-selected", true);
      $(target).css("fill", pointer.color);
      $(target).css("fill-opacity", pointer.colorAlpha);
    } else {
      $(target).css("fill", pointer.deselectedColor);
      $(target).css("fill-opacity", pointer.deselectedColorAlpha);
      target.setAttributeNS(null, "data-selected", false);
    }
  };
  this.clickHandler = function(event) {
    if (pointer.getEnabled() === true) {
      var target = this;
      var selected = CTATGlobalFunctions.toBoolean(target.getAttributeNS(null, "data-selected"));
      set_selected(target, !selected);
      pointer.setActionInput("SetPieces", pointer.updateValue());
      pointer.processAction();
    }
  };
  this.updateSAI = function() {
    pointer.setActionInput("SetPieces", pointer.updateValue());
  };
  this.addPieceElem = function(piece, frac, selected) {
    piece.setAttributeNS(null, "data-selected", selected);
    piece.setAttributeNS(null, "data-value", frac.toString());
    piece.dataValue = frac;
    if (this.getEnabled()) {
      piece.style.cursor = "pointer";
    }
    piece.addEventListener("click", this.clickHandler);
    _pieces.push(piece);
  };
  var super_setEnabled = this.setEnabled;
  this.setEnabled = function(pEnabled) {
    super_setEnabled(pEnabled);
    _pieces.forEach(function(piece) {
      piece.style.cursor = pEnabled ? "pointer" : "default";
    });
  };
  this.clear = function() {
    _pieces = [];
  };
  var genOutValue = function(val, selected) {
    var out = val.toString();
    if (selected === false) {
      out = "(0*" + out + ")";
    }
    return out;
  };
  this.AddPiece = function(str, selected) {
    if (str) {
      var val = new CTAT.Math.Fraction(str);
      if (CTAT.Math.round(val.valueOf()) > 0) {
        var va = _value.split("+");
        va.push(genOutValue(val, selected));
        pointer.setValue(va.join("+"));
      }
    }
  };
  this.AddToValue = function(val, selected) {
    if (val) {
      var frac = new CTAT.Math.Fraction(val);
      if (CTAT.Math.round(frac.valueOf()) > 0) {
        var va = _value.split("+");
        va.push(genOutValue(frac, selected));
        _value = va.join("+");
      }
    }
    return _value;
  };
  var _max_denominator = -1;
  var check_bounds = function(denominator) {
    if (isNaN(denominator)) {
      this.get_denominator();
    }
    denominator = Math.max(denominator, 1);
    if (_max_denominator > 1) {
      denominator = Math.min(denominator, _max_denominator);
    }
    return denominator;
  }.bind(this);
  this.set_max_denominator = function(max_denom) {
    max_denom = parseInt(max_denom);
    if (!isNaN(max_denom)) {
      _max_denominator = max_denom;
    }
  };
  this.set_denominator = function(aDenominator) {
    pointer.setHintHighlight(false);
    var denominator = typeof aDenominator === "string" ? parseInt(aDenominator) : aDenominator;
    if (isNaN(denominator)) {
      return;
    }
    denominator = check_bounds(denominator);
    if (this.get_denominator() == aDenominator) {
      return;
    }
    var currentValue = pointer.evaluate();
    pointer.clear();
    var values = [];
    currentValue.set_denominator(denominator);
    var pieceValue = new CTAT.Math.Fraction(1, denominator);
    var fullPieces = Math.floor(currentValue.numerator);
    var emptyPieces = denominator - fullPieces;
    for (var i = 0;i < fullPieces;i++) {
      values.push(genOutValue(pieceValue, true));
    }
    var remainder = new CTAT.Math.Fraction(currentValue.numerator - fullPieces, denominator);
    if (!remainder.equals(0)) {
      values.push(genOutValue(remainder, true));
      values.push(genOutValue(pieceValue.subtract(remainder), false));
      emptyPieces--;
    }
    for (var j = 0;j < emptyPieces;j++) {
      values.push(genOutValue(pieceValue, false));
    }
    this.setValue(values.join("+"));
    pointer.setActionInput("SetPieces", _value);
    pointer.processAction();
    return _value;
  };
  this.get_denominator = function() {
    return _pieces.reduce(function(min, piece, index, array) {
      return Math.min(min, piece.dataValue.denominator);
    }, Infinity);
  };
  this.change_denominator = function(delta) {
    return this.set_denominator(this.get_denominator() + Number(delta));
  };
  this.set_number_pieces = function(numPieces) {
    pointer.setHintHighlight(false);
    var num = typeof numPieces === "string" ? parseInt(numPieces) : numPieces;
    if (isNaN(num)) {
      return;
    }
    num = check_bounds(num);
    var selected = pointer.numActive();
    pointer.clear();
    var values = [];
    var pieceValue = new CTAT.Math.Fraction(1, num);
    for (var i = 0;i < num;i++) {
      values.push(genOutValue(pieceValue, selected > 0));
      selected--;
    }
    this.setValue(values.join("+"));
    pointer.setActionInput("SetPieces", _value);
    pointer.processAction();
    return _value;
  };
  this.change_number_pieces = function(delta) {
    this.set_number_pieces(_pieces.length + delta);
  };
  this.set_numerator = function(aNum) {
    return this.change_numerator(aNum - this.getSelectedPieces().length);
  };
  this.change_numerator = function change_numerator(delta) {
    if (delta === 0) {
      return;
    } else {
      if (delta > 0) {
        _pieces.every(function(piece) {
          if (is_selected(piece) === false) {
            set_selected(piece, true);
            delta--;
          }
          return delta > 0;
        });
      } else {
        _pieces.reverse();
        _pieces.every(function(piece) {
          if (is_selected(piece) === true) {
            set_selected(piece, false);
            delta++;
          }
          return delta < 0;
        });
        _pieces.reverse();
      }
    }
  };
  this.SetPieces = function(str) {
    pointer.setValue(str);
  };
  var get_ctrl = function(type) {
    var ctrls = $(this.getDivWrap()).attr(type);
    if (ctrls) {
      return ctrls.split(/\s*;\s*/).map(function(i) {
        return i.trim();
      });
    } else {
      return [];
    }
  };
  var get_ctrl_denom = get_ctrl.bind(this, "data-ctat-ctrl-denominator");
  var get_ctrl_part = get_ctrl.bind(this, "data-ctat-ctrl-partition");
  var get_ctrl_numer = get_ctrl.bind(this, "data-ctat-ctrl-numerator");
  var isa = function(getctrl, id) {
    return getctrl().indexOf(id) >= 0;
  };
  var isa_denom = isa.bind(null, get_ctrl_denom);
  var isa_part = isa.bind(null, get_ctrl_part);
  var isa_numer = isa.bind(null, get_ctrl_numer);
  var isController = function(aComponent) {
    var ctrl_name = null;
    if (aComponent instanceof CTAT.Component.Base.Tutorable) {
      if (aComponent != this) {
        ctrl_name = aComponent.getName();
      }
    } else {
      if (aComponent instanceof CTATSAI) {
        if (aComponent.getSelection() != pointer.getName()) {
          ctrl_name = aComponent.getSelection();
        }
      } else {
        if (aComponent instanceof String) {
          if (aComponent != pointer.getName()) {
            ctrl_name = aComponent;
          }
        } else {
          if (aComponent instanceof Element) {
            if (aComponent != pointer.getComponent()) {
              ctrl_name = aComponent.id;
            }
          } else {
            return null;
          }
        }
      }
    }
    if (ctrl_name) {
      if (isa_denom(ctrl_name)) {
        return controller_update.bind(this, this.change_denominator, this.set_denominator);
      } else {
        if (isa_numer(ctrl_name)) {
          return controller_update.bind(this, this.change_numerator, this.set_numerator);
        } else {
          if (isa_part(ctrl_name)) {
            return controller_update.bind(this, this.change_number_pieces, this.set_number_pieces);
          }
        }
      }
    }
    return null;
  }.bind(this);
  var event_type = CTAT.Component.Base.Tutorable.EventType;
  if (!CTATConfiguration.get("previewMode")) {
    document.addEventListener(event_type.action, function(e) {
      var sai = e.detail.sai;
      var ctrl = isController(e.detail.component);
      if (sai && ctrl !== null) {
        ctrl(sai);
      }
    }, false);
  }
  var controller_update = function(change_callback, set_callback, sai) {
    var input = parseInt(sai.getInput());
    if (!isNaN(input)) {
      switch(sai.getAction()) {
        case "ButtonPressed":
          change_callback.call(this, input);
          break;
        case "Update":
        ;
        case "UpdateTextField":
        ;
        case "UpdateTextArea":
          set_callback.call(this, input);
          break;
        default:
          break;
      }
      this.updateSAI();
      this.processAction();
    }
  };
  var update_value = function(sai) {
    switch(sai.getAction()) {
      case "SetPieces":
      ;
      case "UpdateTextField":
      ;
      case "UpdateTextArea":
        pointer.setValue(sai.getInput());
        break;
      default:
        break;
    }
  };
  this.setNumeratorControllers = function(controllers) {
    this.getDivWrap().setAttribute("data-ctat-ctrl-numerator", controllers);
    return this;
  };
  this.setParameterHandler("NumeratorControllers", this.setNumeratorControllers);
  this.setDenominatorControllers = function(controllers) {
    this.getDivWrap().setAttribute("data-ctat-ctrl-denominator", controllers);
    return this;
  };
  this.setParameterHandler("DenominatorControllers", this.setDenominatorControllers);
  this.setPartitionControllers = function(controllers) {
    this.getDivWrap().setAttribute("data-ctat-ctrl-partition", controllers);
    return this;
  };
  this.setParameterHandler("PartitionControllers", this.setPartitionControllers);
  this.getConfigurationActions = function() {
    var val = this.getDivWrap().getAttribute("data-ctat-value");
    if (val) {
      var sai = new CTATSAI;
      sai.setSelection(this.getName());
      sai.setAction("SetPieces");
      sai.setInput(val);
      return [sai];
    } else {
      this.updateSAI();
      return [this.getSAI()];
    }
  };
};
CTAT.Component.Base.UnitDisplay.prototype = Object.create(CTAT.Component.Base.SVG.prototype);
CTAT.Component.Base.UnitDisplay.prototype.constructor = CTAT.Component.Base.UnitDisplay;
goog.provide("CTATFractionBar");
goog.require("CTAT.Math.Fraction");
goog.require("CTAT.Component.Base.UnitDisplay");
goog.require("CTAT.ComponentRegistry");
goog.require("CTATGlobals");
CTATFractionBar = function(aDescription, aX, aY, aWidth, aHeight) {
  CTAT.Component.Base.UnitDisplay.call(this, "CTATFractionBar", "aFractionBar", aDescription, aX, aY, aWidth, aHeight);
  var svgNS = CTATGlobals.NameSpace.svg;
  this.init = function() {
    this.initSVG();
    this.baseGroup = document.createElementNS(svgNS, "g");
    this.getComponent().appendChild(this.baseGroup);
    this.getComponent().classList.add("CTATFractionBar--container");
    this.drawPieces();
    this.addComponentReference(this, this.getDivWrap());
    this.component.addEventListener("focus", this.processFocus);
  };
  this.render = function() {
    this.drawPieces();
  };
  this.drawPieces = function() {
    if (this.baseGroup) {
      this.clear();
      var arr = this.parseValue();
      var sum = 0;
      var fragment = document.createDocumentFragment();
      for (var i = 0;i < arr.length;i++) {
        var frac = arr[i];
        var pix = frac * 100;
        var r = document.createElementNS(svgNS, "rect");
        r.classList.add("CTATFractionBar--piece");
        r.setAttributeNS(null, "height", "100%");
        r.setAttributeNS(null, "width", pix + "%");
        r.setAttributeNS(null, "y", 0);
        r.setAttributeNS(null, "x", sum + "%");
        this.addPieceElem(r, frac, frac.selected);
        fragment.appendChild(r);
        var fl = document.createElementNS(svgNS, "text");
        fl.classList.add("CTATFractionBar--label");
        fl.setAttributeNS(null, "text-anchor", "middle");
        fl.setAttributeNS(null, "dominant-baseline", "middle");
        fragment.appendChild(fl);
        var num = "" + String(frac.numerator);
        var den = "" + String(frac.denominator);
        var num_lbl = document.createElementNS(svgNS, "tspan");
        var den_lbl = document.createElementNS(svgNS, "tspan");
        num_lbl.appendChild(document.createTextNode(num));
        den_lbl.appendChild(document.createTextNode(den));
        fl.appendChild(num_lbl);
        fl.appendChild(den_lbl);
        var lbl_x = sum + pix / 2;
        num_lbl.setAttributeNS(null, "x", lbl_x + "%");
        num_lbl.setAttributeNS(null, "y", "60%");
        num_lbl.setAttributeNS(null, "dy", "-1em");
        den_lbl.setAttributeNS(null, "x", lbl_x + "%");
        den_lbl.setAttributeNS(null, "y", "60%");
        if (num.length > den.length) {
          num_lbl.style.textDecoration = "underline";
        } else {
          den_lbl.style.textDecoration = "overline";
        }
        sum += pix;
      }
      this.baseGroup.innerHTML = "";
      this.baseGroup.appendChild(fragment);
      var base_width = this.baseGroup.getBBox().width - 1;
      Array.prototype.slice.call(this.baseGroup.childNodes).forEach(function(rect) {
        if (rect.nodeName == "rect") {
          var cstyle = window.getComputedStyle(rect);
          var padding = parseFloat(cstyle.getPropertyValue("padding-left"));
          var swidth = parseFloat(cstyle.getPropertyValue("stroke-width"));
          var bbox = rect.getBBox();
          rect.setAttributeNS(null, "y", bbox.y + swidth / 2);
          rect.setAttributeNS(null, "height", bbox.height - swidth);
          var adjx = bbox.x + swidth / 2;
          var adjw = bbox.width - swidth;
          if (bbox.x < 1) {
            adjw -= padding / 2;
          } else {
            adjx += padding / 2;
            if (bbox.x + bbox.width >= base_width) {
              adjw -= padding / 2;
            } else {
              adjw -= padding;
            }
          }
          rect.setAttributeNS(null, "x", adjx);
          rect.setAttributeNS(null, "width", adjw);
        }
      });
    }
  };
  this.setShowFractionLabel = function(aShow) {
    return;
  };
  this.setStyleHandler("showFractionLabel", this.setShowFractionLabel);
};
CTATFractionBar.prototype = Object.create(CTAT.Component.Base.UnitDisplay.prototype);
CTATFractionBar.prototype.constructor = CTATFractionBar;
CTAT.ComponentRegistry.addComponentType("CTATFractionBar", CTATFractionBar);
goog.provide("CTATFS");
CTATFS = {};
CTATFS.writeFile = function(fn, txt) {
  return new Promise(function(resolve, reject) {
    return $.post(location.origin + "/writeFile?path=" + fn, txt).done(function(d) {
      return resolve(d);
    }).fail(function(e) {
      return reject(e);
    });
  });
};
goog.provide("CTATGroupingComponent");
goog.require("CTATGlobalFunctions");
goog.require("CTAT.Component.Base.SAIHandler");
goog.require("CTAT.ComponentRegistry");
CTATGroupingComponent = function(aDescription, aX, aY, aWidth, aHeight) {
  CTAT.Component.Base.SAIHandler.call(this, "CTATGroupingComponent", "__undefined__", aDescription, aX, aY, aWidth, aHeight);
  var pointer = this;
  var parentExecuteSAI = pointer.executeSAI;
  this.isTabIndexable = false;
  this.getComponentList = function() {
    var clist = [];
    var comps = pointer.getDivWrap().getAttribute("data-ctat-componentlist");
    if (comps) {
      clist = comps.split(/\s*[,;]\s*/).map(function(i) {
        return $("#" + i.trim()).data("CTATComponent");
      });
    }
    var $p = $(pointer.getDivWrap());
    $p.children(".CTATComponent").each(function() {
      clist.push($(this).data("CTATComponent"));
    });
    return [].concat($jscomp.arrayFromIterable(new Set(clist)));
  };
  this.init = function init() {
    pointer.setInitialized(true);
  };
  this.executeSAI = function(aSAI) {
    pointer.getComponentList().forEach(function(comp) {
      if (comp && typeof comp.executeSAI == "function") {
        comp.executeSAI(aSAI);
      } else {
        pointer.ctatdebug("CTATGroupingComponent " + pointer.getName() + ".executeSAI: comp doesn't implement executeSAI: " + comp);
      }
    });
    parentExecuteSAI.call(pointer, aSAI);
  };
};
CTATGroupingComponent.prototype = Object.create(CTAT.Component.Base.SAIHandler.prototype);
CTATGroupingComponent.prototype.constructor = CTATGroupingComponent;
CTAT.ComponentRegistry.addComponentType("CTATGroupingComponent", CTATGroupingComponent);
goog.provide("CTATHintButton");
goog.require("CTATCommShell");
goog.require("CTAT.Component.Base.Clickable");
goog.require("CTAT.ComponentRegistry");
goog.require("CTATLanguageManager");
CTATHintButton = function(aDescription, aX, aY, aWidth, aHeight) {
  CTAT.Component.Base.Clickable.call(this, "hint", "CTATHintButton", aDescription, aX, aY, aWidth, aHeight);
  this.setName("hint");
  this.setClassName("CTATHintButton");
  this.isTabIndexable = false;
  this.setText(CTATGlobals.languageManager.getString("HINT"));
  this.setStyleHandler("BackgroundColor", null);
  this.setStyleHandler("TextAlign", null);
  this.setStyleHandler("BorderColor", null);
  this.setStyleHandler("FontFace", null);
  this.setStyleHandler("TextColor", null);
  this.init = function() {
    this.setInitialized(true);
    var comp = document.createElement("button");
    this.setComponent(comp);
    comp.classList.add("unselectable");
    comp.classList.add("CTAT-hint-button");
    var qmark = document.createElement("div");
    qmark.classList.add("CTAT-hint-button--icon");
    qmark.textContent = "?";
    comp.appendChild(qmark);
    if (this.getText()) {
      var button_text = document.createElement("div");
      button_text.textContent = this.getText();
      comp.appendChild(button_text);
    }
    this.getDivWrap().appendChild(comp);
    comp.addEventListener("mouseenter", function(e) {
      e.target.classList.add("CTAT-hint-button--hover");
    });
    comp.addEventListener("mouseleave", function(e) {
      e.target.classList.remove("CTAT-hint-button--hover");
      e.target.classList.remove("CTAT-hint-button--clicked");
    });
    comp.addEventListener("mousedown", function(e) {
      e.target.classList.add("CTAT-hint-button--clicked");
    });
    comp.addEventListener("mouseup", function(e) {
      e.target.classList.remove("CTAT-hint-button--clicked");
    });
    comp.addEventListener("click", function(e) {
      e.target.classList.remove("CTAT-hint-button--clicked");
    });
    comp.addEventListener("click", this.processClick);
  };
  var pointer = this;
  this.processClick = function(e) {
    if (pointer.getEnabled() && CTATCommShell.commShell) {
      CTATCommShell.commShell.requestHint();
    }
  };
};
CTATHintButton.prototype = Object.create(CTAT.Component.Base.Clickable.prototype);
CTATHintButton.prototype.constructor = CTATHintButton;
CTAT.ComponentRegistry.addComponentType("CTATHintButton", CTATHintButton);
goog.provide("CTATHintWindow");
goog.require("CTAT.Component.Base.Graphical");
goog.require("CTATCommShell");
goog.require("CTATConfig");
goog.require("CTATGlobalFunctions");
goog.require("CTATGlobals");
goog.require("CTATGuid");
goog.require("CTATJSON");
goog.require("CTATShellTools");
goog.require("CTAT.ComponentRegistry");
goog.require("CTATLanguageManager");
goog.require("CTATTutorMessageBuilder");
goog.require("CTATXML");
CTATHintWindow = function(aDescription, aX, aY, aWidth, aHeight) {
  var HINT_INDICATOR_CURRENT = "&#9679;";
  var HINT_INDICATOR_OTHER = "&#9675;";
  CTAT.Component.Base.Graphical.call(this, "CTATHintWindow", "__undefined__", aDescription, aX, aY, aWidth, aHeight);
  var pointer = this;
  pointer.isTabIndexable = false;
  var messageParser = CTATConfig.parserType_is_XML() ? new CTATXML : new CTATJSON;
  var assocRulesBuilder = new CTATTutorMessageBuilder;
  var hintContent = null;
  var hintIndicator = null;
  var previous = null;
  var next = null;
  var hintwindow = null;
  var _next_text = CTATGlobals.languageManager.getString("NEXT");
  var _previous_text = CTATGlobals.languageManager.getString("PREVIOUS");
  var _next_content = null;
  this.data_ctat_handlers["next-content"] = function(content) {
    _next_content = content;
    if (next) {
      next.innerHTML = content;
    }
  };
  var _previous_content = null;
  this.data_ctat_handlers["previous-content"] = function(content) {
    _previous_content = content;
    if (previous) {
      previous.innerHTML = content;
    }
  };
  this.getCurrentHint = function getCurrentHint() {
    return hintContent.innerHTML;
  };
  this.init = function init() {
    pointer.ctatdebug("init (" + pointer.getName() + ")");
    pointer.setInitialized(true);
    pointer.setIsAbstractComponent(true);
    hintwindow = this.getDivWrap();
    if (!hintwindow.id) {
      hintwindow.setAttribute("id", CTATGlobalFunctions.gensym.div_id());
    }
    hintwindow.setAttribute("onkeypress", "return noenter(event)");
    pointer.setComponent(hintwindow);
    pointer.addComponentReference(pointer, hintwindow);
    hintContent = document.createElement("div");
    hintwindow.appendChild(hintContent);
    hintContent.classList.add("CTATHintWindow--hint-content");
    var hintButtons = document.createElement("div");
    hintButtons.classList.add("CTATHintWindow--hint-button-area");
    hintwindow.appendChild(hintButtons);
    if (_previous_content) {
      previous = document.createElement("button");
      previous.classList.add("CTATHintWindow--previous");
      previous.innerHTML = _previous_content;
    } else {
      previous = document.createElement("button");
      previous.classList.add("CTATHintWindow--previous");
      var larrow = document.createElement("span");
      larrow.classList.add("CTATHintWindow--button-icon");
      larrow.textContent = "\u25c0";
      previous.appendChild(larrow);
      if (_previous_text) {
        larrow.style.cssFloat = "left";
        previous.appendChild(document.createTextNode(_previous_text));
      }
    }
    previous.addEventListener("click", function(e) {
      CTATShellTools.showPrevHint();
    }, false);
    hintButtons.appendChild(previous);
    hintIndicator = document.createElement("div");
    hintIndicator.classList.add("CTATHintWindow--hint-indicator");
    hintButtons.appendChild(hintIndicator);
    if (_next_content) {
      next = document.createElement("button");
      next.classList.add("CTATHintWindow--next");
      next.innerHTML = _next_content;
    } else {
      next = document.createElement("button");
      next.classList.add("CTATHintWindow--next");
      var rarrow = document.createElement("span");
      rarrow.classList.add("CTATHintWindow--button-icon");
      rarrow.textContent = "\u25b6";
      if (_next_text) {
        rarrow.style.cssFloat = "right";
        next.appendChild(document.createTextNode(_next_text));
      }
      next.appendChild(rarrow);
    }
    next.addEventListener("click", function(e) {
      CTATShellTools.showNextHint();
    }, false);
    hintButtons.appendChild(next);
    var setButtonEnabled = function(pEnabled) {
      this.disabled = !pEnabled;
      if (!pEnabled) {
        this.classList.remove("CTAT-hint-button--hover");
        this.classList.remove("CTAT-hint-button--clicked");
      }
    };
    [previous, next].forEach(function(nav_button) {
      nav_button.setEnabled = setButtonEnabled.bind(nav_button);
      nav_button.classList.add("CTATHintWindow--button");
      nav_button.classList.add("CTAT-hint-button");
      nav_button.addEventListener("mouseenter", function(e) {
        e.target.classList.add("CTAT-hint-button--hover");
      });
      nav_button.addEventListener("mouseleave", function(e) {
        e.target.classList.remove("CTAT-hint-button--hover");
        e.target.classList.remove("CTAT-hint-button--clicked");
      });
      nav_button.addEventListener("mousedown", function(e) {
        e.target.classList.add("CTAT-hint-button--clicked");
      });
      nav_button.addEventListener("mouseup", function(e) {
        e.target.classList.remove("CTAT-hint-button--clicked");
      });
      nav_button.addEventListener("click", function(e) {
        e.target.classList.remove("CTAT-hint-button--clicked");
      });
    });
    CTATShellTools.registerFeedbackComponent(this, this.goNext, this.goPrevious, this.showHint, this.showFeedback);
    pointer.ctatdebug("Disabling previous and next ...");
    previous.setEnabled(false);
    next.setEnabled(false);
  };
  this.setStyleHandler("OuterBorderColor", this.setBorderColor);
  this.showFeedback = function showFeedback(aMessage) {
    pointer.ctatdebug("showFeedback (" + aMessage + ")");
    if (hintContent) {
      hintContent.innerHTML = CTATGlobals.languageManager.filterString(aMessage);
    }
    previous.setEnabled(false);
    next.setEnabled(false);
    hintIndicator.innerHTML = "";
  };
  this.SetText = this.showFeedback;
  this.showHint = function showHint(hintList) {
    pointer.ctatdebug("showHint ()");
    hintIndicator.innerHTML = "";
    hints = hintList || [];
    hintIndex = 0;
    previous.setEnabled(false);
    next.setEnabled(false);
    hints = hints.filter(function(hint) {
      return hint !== "";
    });
    if (!hints || hints.length <= 0) {
      hints = [];
      hintContent.innerHTML = "";
      return;
    }
    this.setEnabled(true);
    hintContent.innerHTML = CTATGlobals.languageManager.filterString(hints[hintIndex]);
    if (hints.length > 1) {
      pointer.ctatdebug("We have more than one hint, enabling next button");
      next.setEnabled(true);
    } else {
      pointer.ctatdebug("We only have one hint, leaving next button disabled");
    }
    for (var i = 0;i < hints.length;i++) {
      var hintBullet = document.createElement("span");
      hintBullet.classList.add("CTATHintWindow--hint-indicator-bullet");
      if (i === 0) {
        hintBullet.innerHTML = HINT_INDICATOR_CURRENT;
      } else {
        hintBullet.innerHTML = HINT_INDICATOR_OTHER;
      }
      hintIndicator.appendChild(hintBullet);
    }
  };
  this.setEnabled = function setEnabled(aValue) {
    pointer.assignEnabled(aValue);
    if (pointer.getComponent() === null) {
      pointer.ctatdebug("Error pointer.getComponent()==null");
      return;
    }
    pointer.getComponent().disabled = !aValue;
  };
  this.goPrevious = function goPrevious() {
    pointer.ctatdebug("goPrevious ()");
    hintIndex--;
    next.setEnabled(true);
    if (hintIndex <= 0) {
      hintIndex = 0;
      previous.setEnabled(false);
    } else {
      previous.setEnabled(true);
    }
    hintContent.innerHTML = CTATGlobals.languageManager.filterString(hints[hintIndex]);
    var bullets = hintIndicator.querySelectorAll(".CTATHintWindow--hint-indicator-bullet");
    bullets[hintIndex + 1].innerHTML = HINT_INDICATOR_OTHER;
    bullets[hintIndex].innerHTML = HINT_INDICATOR_CURRENT;
    var builder = new CTATTutoringServiceMessageBuilder;
    var tsMessage = "";
    var transactionID = CTATGuid.guid();
    hintSAI = new CTATSAI("previousButton", "ButtonPressed", "-1");
    tsMessage = builder.createInterfaceActionMessage(transactionID, hintSAI);
    var hintSAI = new CTATSAI("previousButton", "ButtonPressed", "hint request");
    commLoggingLibrary.logSemanticEvent(transactionID, hintSAI, "HINT_REQUEST", "");
    CTATCommShell.commShell.propagateShellEvent("InterfaceAction", tsMessage);
    var indicator = "HintWindow";
    var advice = pointer.getCurrentHint();
    var associatedRulesXML = assocRulesBuilder.createAssociatedRulesMessageForHint([advice], logHintSAI, "student", null, "", transactionID, hints.length, hintIndex + 1);
    var associatedRulesMessage = new CTATMessage(messageParser.parse(associatedRulesXML));
    CTATCommShell.commShell.processAssociatedRules(associatedRulesMessage, indicator, advice);
    CTATCommShell.commShell.propagateShellEvent("PreviousPressed", associatedRulesMessage);
  };
  this.goNext = function goNext() {
    pointer.ctatdebug("goNext ()");
    hintIndex++;
    previous.setEnabled(true);
    if (hintIndex > hints.length - 1) {
      hintIndex = hints.length - 1;
    }
    if (hintIndex > hints.length - 2) {
      next.setEnabled(false);
    } else {
      next.setEnabled(true);
    }
    hintContent.innerHTML = CTATGlobals.languageManager.filterString(hints[hintIndex]);
    var bullets = hintIndicator.querySelectorAll(".CTATHintWindow--hint-indicator-bullet");
    bullets[hintIndex - 1].innerHTML = HINT_INDICATOR_OTHER;
    bullets[hintIndex].innerHTML = HINT_INDICATOR_CURRENT;
    var builder = new CTATTutoringServiceMessageBuilder;
    var tsMessage = "";
    var transactionID = CTATGuid.guid();
    hintSAI = new CTATSAI("nextButton", "ButtonPressed", "-1");
    tsMessage = builder.createInterfaceActionMessage(transactionID, hintSAI);
    var hintSAI = new CTATSAI("nextButton", "ButtonPressed", "hint request");
    commLoggingLibrary.logSemanticEvent(transactionID, hintSAI, "HINT_REQUEST", "");
    CTATCommShell.commShell.propagateShellEvent("InterfaceAction", tsMessage);
    var indicator = "HintWindow";
    var advice = pointer.getCurrentHint();
    var associatedRulesXML = assocRulesBuilder.createAssociatedRulesMessageForHint([advice], logHintSAI, "student", null, "", transactionID, hints.length, hintIndex + 1);
    var associatedRulesMessage = new CTATMessage(messageParser.parse(associatedRulesXML));
    CTATCommShell.commShell.processAssociatedRules(associatedRulesMessage, indicator, advice);
    CTATCommShell.commShell.propagateShellEvent("NextPressed", associatedRulesMessage);
  };
};
CTATHintWindow.prototype = Object.create(CTAT.Component.Base.Graphical.prototype);
CTATHintWindow.prototype.constructor = CTATHintWindow;
CTAT.ComponentRegistry.addComponentType("CTATHintWindow", CTATHintWindow);
goog.provide("CTATIFrameManager");
CTATIFrameManager = function() {
  var managedFrames = {};
  var pointer = this;
  this.initFrame = function(frame, data, mode) {
    var id = frame ? frame.getAttribute("id") : null;
    if (id) {
      managedFrames[id] = {"domNode":frame, "initialDom":data, "initialMode":mode};
    } else {
      console.error("iFrames managed by CTATIFrameManager must exist and have unique ids");
    }
    frame.setAttribute("data-ctat-target", mode);
    this.writeData(frame, data);
  };
  this.refresh = function(id) {
    var frameObject = managedFrames[id];
    if (frameObject["domNode"]) {
      frameObject["domNode"].setAttribute("src", "about:blank");
      this.writeData(frameObject["domNode"], frameObject["initialDom"]);
    } else {
      console.warn("CTATIFrameManager: iFrame id " + id + " not found");
    }
  };
  this.writeData = function(frame, data) {
    if (frame) {
      var doc = frame.contentDocument || frame.contentWindow.document;
      doc.open();
      doc.write(data);
      doc.close();
    }
  };
  document.addEventListener("refreshIframe", function(event) {
    var id = event.detail;
    console.log("refresh event for iframe " + id);
    pointer.refresh(id);
  });
};
goog.provide("CTATImageButton");
goog.require("CTATGlobalFunctions");
goog.require("CTATGlobals");
goog.require("CTATButtonBasedComponent");
goog.require("CTAT.ComponentRegistry");
CTATImageButton = function(aDescription, aX, aY, aWidth, aHeight) {
  CTATButtonBasedComponent.call(this, "CTATImageButton", "__undefined__", aDescription, aX, aY, aWidth, aHeight);
  var pointer = this;
  this.init = function init() {
    pointer.setInitialized(true);
    pointer.setComponent(pointer.getDivWrap());
    pointer.addComponentReference(pointer, pointer.getDivWrap());
    pointer.setImage(pointer.getDivWrap().getAttribute("data-ctat-image-default"));
    var button = pointer.component;
    button.setAttribute("role", "button");
    button.classList.add("CTAT-button");
    button.addEventListener("click", pointer.processClick);
    button.addEventListener("focus", pointer.processFocus);
    button.addEventListener("mousedown", pointer.processBaseMousedown);
    button.addEventListener("mouseup", pointer.processBaseMouseup);
    button.addEventListener("mouseover", pointer.processBaseMouseover);
    button.addEventListener("mouseout", pointer.processBaseMouseout);
  };
  var super_setEnabled = this.setEnabled;
  this.setEnabled = function(bool) {
    super_setEnabled(bool);
    if (pointer.getEnabled()) {
      pointer.setImage(pointer.getDivWrap().getAttribute("data-ctat-image-default"));
    } else {
      pointer.setImage(pointer.getDivWrap().getAttribute("data-ctat-image-disabled"));
    }
  };
  this.getConfigurationActions = function() {
    var c = this.getDivWrap();
    var hov = c.getAttribute("data-ctat-image-hover");
    var clk = c.getAttribute("data-ctat-image-clicked");
    var def = c.getAttribute("data-ctat-image-default");
    var dis = c.getAttribute("data-ctat-image-disabled");
    if (def) {
      var sai = new CTATSAI;
      sai.setSelection(this.getName());
      if (hov || clk || dis) {
        sai.setAction("assignImages");
        sai.setInputArray([hov, clk, def, dis]);
      } else {
        sai.setAction("assignImage");
        sai.setInput(def);
      }
      return [sai];
    }
    return [];
  };
};
CTATImageButton.prototype = Object.create(CTATButtonBasedComponent.prototype);
CTATImageButton.prototype.constructor = CTATImageButton;
CTAT.ComponentRegistry.addComponentType("CTATImageButton", CTATImageButton);
goog.provide("CTATJumble");
goog.require("CTAT.Component.Base.Tutorable");
goog.require("CTAT.ComponentRegistry");
CTATJumble = function(aDescription, aX, aY, aWidth, aHeight) {
  CTAT.Component.Base.Tutorable.call(this, "CTATJumble", "aJumble", aDescription, aX, aY, aWidth, aHeight);
  var pointer = this;
  this.setActionInput("SetOrder", "");
  var drag_area = null;
  this.init = function() {
    this.setInitialized(true);
    drag_area = this.getDivWrap();
    this.setComponent(drag_area);
    this.addComponentReference(this, drag_area);
    if (!CTATConfiguration.get("previewMode")) {
      $(drag_area).children().addClass("CTATJumble--item").attr({unselectable:"on", draggable:true}).each(function() {
        this.addEventListener("dragstart", handleDragStart, false);
        this.addEventListener("dragenter", handleDragEnter, false);
        this.addEventListener("dragover", handleDragOver, false);
        this.addEventListener("dragleave", handleDragLeave, false);
        this.addEventListener("drop", handleDrop, false);
        this.addEventListener("dragend", handleDragEnd, false);
      });
    }
    this.component.addEventListener("focus", this.processFocus);
  };
  this.getConfigurationActions = function() {
    this.updateSAI();
    return [this.getSAI()];
  };
  var _drag_source = null;
  var handleDragStart = function(e) {
    if (/CTATJumble/.test(e.target.className)) {
      e.target.classList.add("CTATJumble--item--home");
      _drag_source = e.target;
      e.dataTransfer.effectAllowed = "move";
      e.dataTransfer.setData("text/html", e.target.innerHTML);
    }
  };
  var handleDragOver = function(e) {
    if (e.preventDefault) {
      e.preventDefault();
    }
    e.dataTransfer.dropEffect = "move";
    return false;
  };
  var handleDragEnter = function(e) {
    this.classList.add("CTATJumble--item--over");
  };
  var handleDragLeave = function(e) {
    this.classList.remove("CTATJumble--item--over");
  };
  var handleDrop = function(e) {
    if (e.stopPropagation) {
      e.stopPropagation();
    }
    if (_drag_source) {
      $(drag_area).children().removeClass("CTATJumble--item--over");
      if (_drag_source != this) {
        _drag_source.innerHTML = this.innerHTML;
        var id = _drag_source.id;
        _drag_source.id = this.id;
        this.innerHTML = e.dataTransfer.getData("text/html");
        this.id = id;
        pointer.setInput(pointer.getOrder());
        pointer.processAction();
      }
    }
    return false;
  };
  var handleDragEnd = function(e) {
    this.classList.remove("CTATJumble--item--home");
    $(drag_area).children().removeClass("CTATJumble--item--over");
    _drag_source = null;
  };
  var super_setEnabled = this.setEnabled;
  this.setEnabled = function(bool) {
    super_setEnabled(bool);
    if (drag_area) {
      $(drag_area).children().attr("draggable", bool);
    }
  };
  this.init_items = function(items) {
    if (drag_area) {
      var fragment = document.createDocumentFragment();
      var itms = items.split(";");
      var l = itms.length;
      for (var i = 0;i < l;i++) {
        var label = document.createElement("div");
        label.textContent = itms[i];
        label.id = this.getName() + i;
        label.setAttribute("unselectable", "on");
        label.setAttribute("draggable", true);
        label.classList.add("CTATJumble--item");
        label.addEventListener("dragstart", handleDragStart, false);
        label.addEventListener("dragenter", handleDragEnter, false);
        label.addEventListener("dragover", handleDragOver, false);
        label.addEventListener("dragleave", handleDragLeave, false);
        label.addEventListener("drop", handleDrop, false);
        label.addEventListener("dragend", handleDragEnd, false);
        fragment.appendChild(label);
      }
      drag_area.innerHTML = "";
      drag_area.appendChild(fragment);
    }
  };
  this.setParameterHandler("textItems", this.init_items);
  this.SetOrder = function(str) {
    str.split(";").forEach(function(id) {
      $(drag_area).append($("#" + id));
    });
  };
  this.getOrder = function() {
    var lbs = [];
    $(drag_area).children().each(function() {
      if (this.draggable) {
        if (this.id) {
          lbs.push(this.id);
        } else {
          console.log("ERROR: The CTATJumble " + pointer.getName() + " has a child with no id attribute: " + this + "!!!");
        }
      }
    });
    return lbs.join(";");
  };
  this.updateSAI = function() {
    pointer.setInput(pointer.getOrder());
  };
};
CTATJumble.prototype = Object.create(CTAT.Component.Base.Tutorable.prototype);
CTATJumble.prototype.constructor = CTATJumble;
CTAT.ComponentRegistry.addComponentType("CTATJumble", CTATJumble);
goog.provide("CTATMathInput");
goog.require("CTATGlobalFunctions");
goog.require("CTATGlobals");
goog.require("CTATSAI");
goog.require("CTAT.Component.Base.Tutorable");
goog.require("CTAT.ComponentRegistry");
var CTATMathInput = function() {
  CTAT.Component.Base.Tutorable.call(this, "CTATMathInput", "myComponent");
  if (!CTATMathInput.guppyInitialized) {
    Guppy.init({"path":"https://cdn.ctat.cs.cmu.edu/releases/latest/guppy/", "symbols":"https://cdn.ctat.cs.cmu.edu/releases/latest/guppy/symbols.json"});
    CTATMathInput.guppyInitialized = true;
  }
  var pointer = this;
  var mathinput = null;
  var previewMode = CTATConfiguration.get("previewMode");
  var div;
  var mathDiv;
  var newDiv;
  var correct = false;
  var dirty = 0;
  if (!CTATMathInput.__osk && window.GuppyOSK) {
    var detachListener = function(e) {
      var target = e.target;
      while (target.parentNode) {
        if (target.classList.contains("guppy_osk") || target.classList.contains("CTATMathInput") && target.getAttribute("data-ctat-enabled") !== "false") {
          return true;
        }
        target = target.parentNode;
        if (!target.isConnected) {
          return true;
        }
      }
      CTATMathInput.__osk.detach();
    };
    document.documentElement.className += "ontouchstart" in document.documentElement ? " touch" : " no-touch";
    CTATMathInput.__osk = new GuppyOSK({groups:["qwerty"], controls:["&uarr;", "&darr;", "&larr;", "&rarr;", "del", "enter"]});
    document.addEventListener("mousedown", detachListener);
    document.addEventListener("touchstart", detachListener);
  }
  this.init = function() {
    this.ctatdebug("init (" + pointer.getName() + ")");
    if (!pointer.getInitialized()) {
      div = pointer.getDivWrap();
      mathDiv = document.createElement("div");
      mathDiv.id = div.id + "_math";
      div.appendChild(mathDiv);
      mathinput = new Guppy(mathDiv.id, {events:{"done":function() {
        var val = pointer.getValue();
        if (/^\s*$/.test(String(val))) {
          return;
        }
        pointer.setActionInput("UpdateTextField", val);
        pointer.processAction();
        dirty = 0;
      }, "focus":function(e) {
        if (e.focused) {
          if (CTATMathInput.__osk) {
            if (e.target === mathinput && CTATMathInput.__osk.guppy !== mathinput) {
              CTATMathInput.__osk.attach(mathinput);
            }
          }
        }
      }}, settings:{"empty_content":""}});
      newDiv = document.createElement("div");
      newDiv.id = div.id + "_new";
      div.appendChild(newDiv);
      this.ctatdebug("Final location: " + pointer.getX() + "," + pointer.getY() + " with text: " + pointer.getValue());
      div.addEventListener("keydown", function(event) {
        var x = event.key;
        ++dirty;
        pointer.ctatdebug("dirty " + dirty);
      });
      mathDiv.addEventListener("blur", function(event) {
        if (!correct) {
          var val = pointer.getValue();
          if (/^\s*$/.test(String(val))) {
            return;
          }
          if (dirty < 1) {
            return;
          }
          pointer.setActionInput("UpdateTextField", val);
          pointer.processAction();
          dirty = 0;
        }
      });
      pointer.setInitialized(true);
      pointer.setComponent(div);
      pointer.addComponentReference(pointer, div);
      if (previewMode) {
        this.addEventScreen(false);
      }
    }
  };
  this.GuppyStyleInput = function(x) {
    var ret;
    if (x.includes("/")) {
      var n = x.indexOf("/");
      for (var i = n;i > 0;i--) {
        if (x[i] === "+" || x[i] === "-") {
          ret = x.slice(0, i + 1) + "(" + x.slice(i + 1, n) + ")" + "/" + pointer.GuppyStyleInput(x.slice(n + 1, x.length));
          break;
        }
      }
      !ret && (ret = "(" + x.slice(0, n) + ")" + "/" + pointer.GuppyStyleInput(x.slice(n + 1, x.length)));
    } else {
      ret = x;
    }
    return ret;
  };
  this.getValue = function() {
    try {
      var v = mathinput.asciimath();
      return v;
    } catch (err) {
      return "";
    }
  };
  this.updateSAI = function() {
    this.setActionInput("UpdateTextField", pointer.getValue());
  };
  this.setMath = function(aMath) {
    console.log("setMath (" + aMath + ")");
    mathinput.import_text(aMath);
    if (!pointer.getEnabled()) {
      var xml = mathinput.xml();
      Guppy.Doc.render(xml, newDiv.id);
    }
  };
  this.getConfigurationActions = function() {
    var actions = [];
    var $div = $(this.getDivWrap());
    if ($div.attr("value")) {
      var sai = new CTATSAI;
      sai.setSelection(this.getName());
      sai.setAction("UpdateTextField");
      sai.setInput($div.attr("value"));
      actions.push(sai);
    }
    return actions;
  };
  this.UpdateTextField = function(aMath) {
    this.setMath(aMath);
  };
  this.reset = function reset() {
    pointer.configFromDescription();
    pointer.processSerialization();
    mathinput.import_text("");
  };
  var enable = function() {
    if (mathDiv.parentNode !== div) {
      div.appendChild(mathDiv);
    }
    if (newDiv.parentNode === div) {
      div.removeChild(newDiv);
    }
  };
  var disable = function() {
    if (newDiv.parentNode !== div) {
      div.appendChild(newDiv);
    }
    if (mathDiv.parentNode === div) {
      div.removeChild(mathDiv);
    }
    var xml = mathinput.xml();
    Guppy.Doc.render(xml, newDiv.id);
    if (CTATMathInput.__osk && CTATMathInput.__osk.guppy === mathinput) {
      CTATMathInput.__osk.detach();
    }
  };
  var baseSetEnabled = this.setEnabled;
  this.setEnabled = function(enabled) {
    baseSetEnabled.call(this, enabled);
    if (pointer.getInitialized()) {
      if (enabled) {
        enable();
      } else {
        disable();
      }
    }
  };
  var baseSetCorrect = this.setCorrect;
  this.setCorrect = function() {
    correct = true;
    baseSetCorrect.apply(this, arguments);
  };
  var baseShowCorrect = this.showCorrect;
  this.showCorrect = function() {
    baseShowCorrect.apply(this, arguments);
    newDiv.style.color = "darkgreen";
  };
  var baseSetIncorrect = this.setIncorrect;
  this.setIncorrect = function() {
    correct = false;
    baseSetIncorrect.apply(this, arguments);
  };
  var baseShowIncorrect = this.showIncorrect;
  this.showIncorrect = function() {
    baseShowIncorrect.apply(this, arguments);
    mathDiv.style.color = "red";
  };
  var baseShowHintHighlight = this.showHintHighlight;
  this.showHintHighlight = function() {
    baseShowHintHighlight.apply(this, arguments);
    mathDiv.style.color = "initial";
  };
};
CTATMathInput.prototype = Object.create(CTAT.Component.Base.Tutorable.prototype);
CTATMathInput.prototype.constructor = CTATMathInput;
CTAT.ComponentRegistry.addComponentType("CTATMathInput", CTATMathInput);
goog.provide("CTATMobileTutorHandler");
goog.require("CTATBase");
goog.require("CTATGlobals");
goog.require("CTATSandboxDriver");
CTATMobileTutorHandler = function(aName, aMode) {
  CTATBase.call(this, "CTATMobileTutorHandler", "mobiletutorhandler");
  this.ctatdebug("CTATMobileTutorHandler ()");
  var stringInput = "";
  var swfObjName = aName;
  var mode = aMode ? aMode : "disabled";
  var onDevice = false;
  if (/Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent)) {
    onDevice = true;
  }
  this.error = function error(aMessage) {
    this.ctatdebug(aMessage);
    alert(aMessage);
  };
  this.processOrientationChange = function processOrientationChange(orientation) {
    this.ctatdebug("processOrientationChange (" + orientation + ")");
  };
  this.getEnabled = function getEnabled() {
    if (mode == "disabled") {
      return false;
    }
    if (mode == "auto" && onDevice == false) {
      return false;
    }
    return true;
  };
  this.processTextFocus = function processTextFocus(x, y, width, height, componentText) {
    this.ctatdebug("processTextFocus (" + x + "," + y + "," + width + "," + height + "," + componentText + ")");
    if (mode == "disabled") {
      return;
    }
    if (mode == "auto" && onDevice == false) {
      return;
    }
    stringInput = "";
    this.manipulateKeyboard();
  };
  function removeFocus() {
    this.ctatdebug("removeFocus ()");
  }
  this.processEnter = function processEnter() {
    this.ctatdebug("processEnter ()");
    if (mode == "disabled") {
      return;
    }
    if (mode == "auto" && onDevice == false) {
      return;
    }
    var swfObject = getSafeElementById(swfObjName);
    if (swfObject != null) {
      try {
        swfObject.processExternalEnter();
        this.ctatdebug("Successfully called AS3 method");
      } catch (err) {
        this.ctatdebug("Error description: " + err.message);
      }
    } else {
      this.ctatdebug("Error: unable to obtain reference to swf object");
    }
  };
  this.setText = function setText(aString) {
    this.ctatdebug("setText (" + aString + ")");
    if (mode == "disabled") {
      return;
    }
    if (mode == "auto" && onDevice == false) {
      return;
    }
    if (CTATGlobals.selectedTextInput != null) {
      this.ctatdebug("Attempting to call HTML5 method on text object ...");
      var previousString = CTATGlobals.selectedTextInput.getText();
      CTATGlobals.selectedTextInput.setText(previousString + aString);
    } else {
      this.ctatdebug("Attempting to call AS3 method ...");
      var swfObject = getSafeElementById(swfObjName);
      if (swfObject != null) {
        try {
          stringInput = stringInput + aString;
          this.ctatdebug(stringInput);
          swfObject.processExternalKeyboard(stringInput);
          this.ctatdebug("Successfully called AS3 method");
        } catch (err) {
          this.ctatdebug("Error description: " + err.message);
        }
      } else {
        this.ctatdebug("Error: unable to obtain reference to swf object");
      }
    }
  };
  this.manipulateKeyboard = function manipulateKeyboard() {
    this.ctatdebug("manipulateKeyboard()");
    if (mode == "disabled") {
      return;
    }
    if (mode == "auto" && onDevice == false) {
      return;
    }
    this.hideKeyboard();
    var keyboard = getSafeElementById("keyboardUI");
    if (keyboard) {
      keyboard.style.visibility = "visible";
    }
  };
  this.hideKeyboard = function hideKeyboard() {
    document.activeElement.blur();
    var inp = getSafeElementById("input");
    if (inp) {
      inp.blur();
    }
  };
  this.hideCustomKeyboard = function hideCustomKeyboard() {
    getSafeElementById("keyboardUI").style.visibility = "visible";
  };
};
CTATMobileTutorHandler.prototype = Object.create(CTATBase.prototype);
CTATMobileTutorHandler.prototype.constructor = CTATMobileTutorHandler;
function processTextFocus(x, y, width, height, componentText) {
  mobileAPI.processTextFocus(x, y, width, height, componentText);
}
function processFocusOut() {
  closeK();
}
;goog.provide("CTATMovieClip");
goog.require("CTATBase");
goog.require("CTATGlobals");
goog.require("CTATGlobalFunctions");
CTATMovieClip = function(anInstance, aX, aY, aWidth, aHeight) {
  CTATBase.call(this, "CTATMovieClip", anInstance);
  var x = aX;
  var y = aY;
  var width = aWidth;
  var height = aHeight;
  var topDivZIndex = CTATGlobalFunctions.gensym.z_index();
  var topDivID = CTATGlobalFunctions.gensym.div_id();
  var canvasZIndex = CTATGlobalFunctions.gensym.z_index();
  var canvasID = CTATGlobalFunctions.gensym.div_id();
  var componentList = [];
  var pointer = this;
  var divWrapper = null;
  this.wrapComponent = function wrapComponent(aParent) {
    divWrapper = document.createElement("div");
    divWrapper.setAttribute("id", topDivID);
    divWrapper.setAttribute("name", this.getName());
    divWrapper.setAttribute("style", "z-index: " + topDivZIndex);
    divWrapper.setAttribute("width", width + "px");
    divWrapper.setAttribute("height", height + "px");
    divWrapper.setAttribute("style", "border: 0px; position: absolute; left:" + x + "px; top:" + y + "px; z-index:" + canvasZIndex + ";");
    aParent.appendChild(divWrapper);
    return divWrapper;
  };
  this.getDivWrapper = function getDivWrapper() {
    return divWrapper;
  };
  this.addComponent = function addComponent(aComponentName) {
    pointer.ctatdebug("addComponent (" + aComponentName + ")");
    componentList.push(aComponentName);
  };
  this.isRegistered = function isRegistered(aComponentName) {
    for (var i = 0;i < componentList.length;i++) {
      if (componentList[i] == aComponentName) {
        return true;
      }
    }
    return false;
  };
};
CTATMovieClip.prototype = Object.create(CTATBase.prototype);
CTATMovieClip.prototype.constructor = CTATMovieClip;
goog.provide("CTATNLPInput");
goog.require("CTATGlobalFunctions");
goog.require("CTATGlobals");
goog.require("CTATSAI");
goog.require("CTATTextBasedComponent");
goog.require("CTAT.ComponentRegistry");
var CTATNLPInput = function(a, f, g, d, c) {
  CTATTextBasedComponent.call(this, "CTATNLPInput", "__undefined__", a, f, g, d, c);
  var b = this, e = null, h = null, l = CTATConfiguration.get("previewMode");
  this.init = function() {
    this.ctatdebug("init (" + b.getName() + ")");
    e = document.createElement("input");
    e.type = "text";
    a && (e.name = a.name);
    e.setAttribute("maxlength", b.getMaxCharacters());
    e.setAttribute("id", CTATGlobalFunctions.gensym.div_id());
    b.setComponent(e);
    this.ctatdebug("Final location: " + b.getX() + "," + b.getY() + " with text: " + b.getText());
    var c = $(this.getDivWrap());
    c.attr("value") && this.setText(c.attr("value"));
    var d = $(e);
    "autofocus defaultValue maxLength pattern placeholder readOnly size title".split(" ").forEach(function(b) {
      var a = c.attr(b);
      a && d.attr(b, a);
    });
    b.setInitialized(!0);
    b.addComponentReference(b, e);
    b.getDivWrap().appendChild(e);
    b.addSafeEventListener("keypress", b.processKeypress, e);
    b.addSafeEventListener("focus", b.processFocus, e);
    $(e).on("input", function(a) {
      b.setNotGraded();
    });
    l && this.addEventScreen(!1);
  };
  this.getConfigurationActions = function() {
    var b = [], a = $(this.getDivWrap());
    if (a.attr("value")) {
      var c = new CTATSAI;
      c.setSelection(this.getName());
      c.setAction("UpdateTextField");
      c.setInput(a.attr("value"));
      b.push(c);
    }
    return b;
  };
  var u = this.processAction.bind(this);
  this.processAction = function(b, a) {
    if (method === "GET") {
      var getClassification = function(handleData) {
        $.get(url, function(data) {
          console.log("NLP DATA: ", data);
          handleData(data);
        });
      };
      var url = this.nlp_url;
      if (url.includes("${input}")) {
        url = url.replace("${input}", this.getValue());
      } else {
        url = url.concat(this.getValue());
      }
      var id = this.getName();
      getClassification(function(output) {
        var s = new CTATSAI;
        s.setSelection(id);
        s.setAction("NLPclassification");
        s.setInput(output.result);
        CTATCommShell.commShell.processComponentAction(s);
      });
    }
    if (method === "POST") {
      var getClassification$11 = function(handleData) {
        $.post(url, function(data) {
          handleData(data);
        });
      };
      var url = this.nlp_url;
      var body = post_body;
      if (body.includes("${input}")) {
        body = body.replace("${input}", this.getValue());
      } else {
        body = body.concat(this.getValue());
      }
      url = url.concat(body);
      var id = this.getName();
      getClassification$11(function(output) {
        var s = new CTATSAI;
        s.setSelection(id);
        s.setAction("NLPclassification");
        s.setInput(output);
        CTATCommShell.commShell.processComponentAction(s);
      });
    }
  };
  this.setCellContainer = function(b) {
    h = b;
  };
  this.getCellContainer = function() {
    return h;
  };
  this.setText = function(a) {
    b.ctatdebug("setText (" + a + ")");
    b.assignText(a);
    e.value = a;
  };
  this.getValue = function() {
    return e.value;
  };
  this.reset = function() {
    b.configFromDescription();
    b.processSerialization();
    e.value = "";
  };
  this.setStyleHandler("DrawBorder", null);
  this.nlp_url = "";
  this.setURL = function(url) {
    this.nlp_url = url;
  };
  this.data_ctat_handlers["nlp-url"] = function(val) {
    this.setURL(val);
  };
  var post_body = "";
  this.setPostBody = function(body) {
    this.post_body = body;
  };
  this.data_ctat_handlers["post-body"] = function(val) {
    this.setPostBody(val);
  };
  var method = "GET";
  this.setMethod = function(given_method) {
    if (given_method) {
      this.method = given_method;
    }
  };
  this.data_ctat_handlers["nlp-method"] = function(val) {
    this.setMethod(val);
  };
  var preprocessor = "";
  this.setPreprocessor = function(val) {
    if (window && typeof window[val] === "function") {
      this.preprocessor = window[val];
    }
  };
  this.data_ctat_handlers["preprocess"] = function(val) {
    this.setPreprocessor(val);
  };
};
CTATNLPInput.prototype = Object.create(CTATTextBasedComponent.prototype);
CTATNLPInput.prototype.constructor = CTATNLPInput;
CTAT.ComponentRegistry.addComponentType("CTATNLPInput", CTATNLPInput);
goog.provide("CTAT.Geom.Point");
goog.require("CTAT.Math");
try {
  new DOMPoint;
} catch (e) {
  console.log("WARNING: new DOMPoint():", e, typeof e);
  if (e instanceof ReferenceError || e instanceof TypeError) {
    console.log("   Using shim!");
    var DOMPoint = function(x, y, z, w) {
      this.x = 0;
      this.y = 0;
      this.z = 0;
      this.w = 1;
      if (x instanceof DOMPoint) {
        for (var d in x) {
          this[d] = x[d];
        }
      } else {
        this.x = x || 0;
        this.y = y || 0;
        this.z = z || 0;
        this.w = w || 1;
      }
    };
  }
}
CTAT.Geom.Point.useDOMMatrix = true;
try {
  new DOMMatrix;
} catch (e$12) {
  if (e$12 instanceof ReferenceError) {
    CTAT.Geom.Point.useDOMMatrix = false;
  }
}
CTAT.Geom.Point.add = function() {
  if (CTAT.Geom.Point.useDOMMatrix) {
    var matrix = new DOMMatrix;
    var p;
    for (var i = 0;i < arguments.length;i++) {
      p = arguments[i];
      matrix.translateSelf(p.x / p.w, p.y / p.w, p.z / p.w);
    }
    return matrix.transformPoint(new DOMPoint);
  } else {
    return Array.prototype.reduce.call(arguments, function(sum, pnt) {
      for (var d in sum) {
        if (d != "w" && pnt[d] !== 0) {
          sum[d] += pnt[d] / pnt.w;
        }
      }
      return sum;
    }, new DOMPoint);
  }
};
if (!DOMPoint.prototype.add) {
  Object.defineProperty(DOMPoint.prototype, "add", {enumerable:false, value:function(a) {
    if (CTAT.Geom.Point.useDOMMatrix) {
      return (new DOMMatrix).translate(a.x / a.w, a.y / a.w, a.z / a.w).transformPoint(this);
    } else {
      return CTAT.Geom.Point.add(this, a);
    }
  }});
}
CTAT.Geom.Point.angle = function(a, b) {
  return Math.acos(DOMPoint.dot(a, b) / (a.magnitude * b.magnitude));
};
CTAT.Geom.Point.angle_degrees = function(a, b) {
  return CTAT.Math.rad2deg(CTAT.Geom.Point.angle(a, b));
};
CTAT.Geom.Point.angle_between_2d = function(a, b) {
  var a1 = Math.atan2(a.y, a.x);
  var a2 = Math.atan2(b.y, b.x);
  var angle = a2 - a1;
  return CTAT.Math.rad2deg(angle);
};
if (!DOMPoint.prototype.clone) {
  Object.defineProperty(DOMPoint.prototype, "clone", {value:function() {
    return new DOMPoint(this.x, this.y, this.z, this.w);
  }});
}
CTAT.Geom.Point.distance = function(a, b) {
  var d = CTAT.Geom.Point.add(a, CTAT.Geom.Point.scale(b, -1));
  return Math.sqrt(CTAT.Geom.Point.dot(d, d));
};
if (!DOMPoint.prototype.distance) {
  Object.defineProperty(DOMPoint.prototype, "distance", {value:function(a) {
    return CTAT.Geom.Point.distance(this, a);
  }});
}
CTAT.Geom.Point.dot = function(a, b) {
  return (a.x * b.x + a.y * b.y + a.z * b.z) / (a.w * b.w);
};
CTAT.Geom.Point.equals = function(a, b) {
  var eq = true;
  for (var d in a) {
    if (d in b) {
      if (d != "w") {
        eq = eq & a[d] / a.w == b[d] / b.w;
      }
    } else {
      eq = false;
    }
    if (!eq) {
      break;
    }
  }
  return eq;
};
CTAT.Geom.Point.interpolate = function(a, b, f) {
  return CTAT.Geom.Point.add(a.scale(f), b.scale(1 - f));
};
if (!("magnitude" in DOMPoint.prototype)) {
  Object.defineProperty(DOMPoint.prototype, "magnitude", {enumerable:false, get:function() {
    return CTAT.Math.round(Math.sqrt(CTAT.Geom.Point.dot(this, this)));
  }});
}
if (!DOMPoint.prototype.normalize) {
  Object.defineProperty(DOMPoint.prototype, "normalize", {value:function(unit) {
    unit = unit ? unit : 1;
    return this.scale(unit / this.magnitude);
  }});
}
CTAT.Geom.Point.scale = function(p, v) {
  if (CTAT.Geom.Point.useDOMMatrix) {
    return (new DOMMatrix).scale(v).transformPoint(p);
  } else {
    var ret = new DOMPoint(p);
    for (var d in ret) {
      if (d != "w") {
        ret[d] = CTAT.Math.round(p[d] * v);
      }
    }
    return ret;
  }
};
if (!DOMPoint.prototype.scale) {
  Object.defineProperty(DOMPoint.prototype, "scale", {value:function(v) {
    return CTAT.Geom.Point.scale(this, v);
  }});
}
CTAT.Geom.Point.polar = function(len, angle) {
  return new DOMPoint(CTAT.Math.round(len * Math.cos(angle)), CTAT.Math.round(len * Math.sin(angle)));
};
CTAT.Geom.Point.is_on_line = function(a, b, c) {
  return Math.abs(a.distance(c) + b.distance(c) - a.distance(b)) < 1E-4;
};
CTAT.Geom.Point.circle_intersection = function(start, end, center, radius) {
  var unit = end.add(start.scale(-1)).normalize();
  var t = CTAT.Geom.Point.dot(unit, center.add(start.scale(-1)));
  var e = start.add(unit.scale(t));
  var dist = CTAT.Geom.Point.distance(center, e);
  if (dist < radius) {
    var dt = Math.sqrt(radius * radius - dist * dist);
    var intercepts = [start.add(unit.scale(t - dt)), start.add(unit.scale(t + dt))];
    return intercepts;
  } else {
    if (dist == radius) {
      return [e];
    } else {
      return [];
    }
  }
};
CTAT.Geom.Point.to2DString = function(p, paren) {
  var s = [p.x / p.w, p.y / p.w].join(",");
  if (paren) {
    s = "(" + s + ")";
  }
  return s;
};
goog.provide("CTAT.Geom.Rectangle");
goog.require("CTAT.Geom.Point");
try {
  new DOMRect;
} catch (e$13) {
  console.log("WARNING: new DOMRect():", e$13, typeof e$13);
  if (e$13 instanceof ReferenceError || e$13 instanceof TypeError) {
    console.log("    Using shim!");
    var DOMRect = function(x, y, w, h) {
      this.x = x || 0;
      this.y = y || 0;
      this.width = w || 0;
      this.height = h || 0;
      return this;
    };
  }
}
if (!("left" in DOMRect.prototype)) {
  Object.defineProperty(DOMRect.prototype, "left", {get:function() {
    return Math.min(this.x, this.x + this.width);
  }});
}
if (!("right" in DOMRect.prototype)) {
  Object.defineProperty(DOMRect.prototype, "right", {get:function() {
    return Math.max(this.x, this.x + this.width);
  }});
}
if (!("top" in DOMRect.prototype)) {
  Object.defineProperty(DOMRect.prototype, "top", {get:function() {
    return Math.min(this.y, this.y + this.height);
  }});
}
if (!("bottom" in DOMRect.prototype)) {
  Object.defineProperty(DOMRect.prototype, "bottom", {get:function() {
    return Math.max(this.y, this.y + this.height);
  }});
}
CTAT.Geom.Rectangle.contains = function(rect, x, y) {
  var contains = CTAT.Geom.Rectangle.contains;
  if (x instanceof DOMRect) {
    return contains(rect, x.left, x.top) & contains(rect, x.right, x.bottom);
  } else {
    if (x instanceof DOMPoint) {
      var y_check = true;
      if (y instanceof DOMPoint) {
        y_check = contains(rect, y.x / y.w, y.y / y.w);
      } else {
        if (typeof y == "number") {
          return contains(rect, x.x - y, x.y - y) & contains(rect, x.x + y, x.y + y);
        }
      }
      return y_check & contains(rect, x.x, x.y);
    } else {
      return rect.left <= x & rect.right >= x & rect.top <= y & rect.bottom >= y;
    }
  }
};
if (!DOMRect.prototype.contains) {
  Object.defineProperty(DOMRect.prototype, "contains", {value:function(x, y) {
    return CTAT.Geom.Rectangle.contains(this, x, y);
  }});
}
if (!DOMRect.prototype.clone) {
  Object.defineProperty(DOMRect.prototype, "clone", {value:function() {
    return new DOMRect(this.x, this.y, this.width, this.height);
  }});
}
if (!DOMRect.prototype.copyFrom) {
  Object.defineProperty(DOMRect.prototype, "copyFrom", {value:function(rect) {
    this.x = rect.x;
    this.y = rect.y;
    this.width = rect.width;
    this.height = rect.height;
    return this;
  }});
}
CTAT.Geom.Rectangle.equals = function(a, b) {
  return a.left == b.left && a.top == b.top && a.right == b.right && a.bottom == b.bottom;
};
CTAT.Geom.Rectangle.inflate = function(rect, dx, dy) {
  dx = dx ? dx : 0;
  dy = dy ? dy : 0;
  if (dx instanceof DOMPoint) {
    dy = dx.y;
    dx = dx.x;
  }
  var r = rect.clone();
  r.x -= dx;
  r.y -= dy;
  r.width += 2 * dx;
  r.height += 2 * dy;
  return r;
};
CTAT.Geom.Rectangle.isEmpty = function(rect) {
  return rect.width === 0 || rect.height === 0;
};
CTAT.Geom.Rectangle.setEmpty = function(rect) {
  rect.x = 0;
  rect.y = 0;
  rect.width = 0;
  rect.height = 0;
  return rect;
};
CTAT.Geom.Rectangle.setTo = function(rect, x, y, width, height) {
  rect.x = x;
  rect.y = y;
  rect.width = width;
  rect.height = height;
  return rect;
};
CTAT.Geom.Rectangle.offset = function(rect, dx, dy) {
  dx = dx ? dx : 0;
  dy = dy ? dy : 0;
  if (dx instanceof DOMPoint) {
    dy = dx.y;
    dx = dx.x;
  }
  var o = rect.clone();
  o.x += dx;
  o.y += dy;
  return o;
};
CTAT.Geom.Rectangle.union = function(a, b) {
  var u = new DOMRect;
  u.x = Math.min(a.x, b.x);
  u.y = Math.min(a.y, b.y);
  u.width = Math.max(a.right, b.right) - u.x;
  u.height = Math.max(a.bottom, b.bottom) - u.y;
  return u;
};
goog.provide("CTATNumberLine");
goog.require("CTAT.Math");
goog.require("CTAT.Math.Fraction");
goog.require("CTATGlobalFunctions");
goog.require("CTATGlobals");
goog.require("CTATSAI");
goog.require("CTAT.Component.Base.SVG");
goog.require("CTAT.Component.Base.Tutorable");
goog.require("CTAT.ComponentRegistry");
goog.require("CTAT.Geom.Point");
goog.require("CTAT.Geom.Rectangle");
CTATNumberLine = function(aDescription, aX, aY, aWidth, aHeight) {
  CTAT.Component.Base.SVG.call(this, "CTATNumberLine", "aNumberLine", aDescription, aX, aY, aWidth, aHeight);
  var Fraction = CTAT.Math.Fraction;
  var svgNS = CTATGlobals.NameSpace.svg;
  var Ticks = function(pnumberline, pstep, psize, tick_class, label_class) {
    this.numberline = pnumberline;
    this.step = new Fraction(pstep);
    var default_size = psize;
    this.size = psize;
    this.origin = new Fraction(0);
    tick_class = tick_class ? tick_class : null;
    label_class = label_class ? label_class : null;
    this.g = null;
    this.setStep = function(val) {
      this.step = new Fraction(val);
    };
    this.setSize = function(val) {
      var v = Number(val);
      if (isNaN(v)) {
        v = default_size;
      }
      this.size = v;
    };
    this.setOrigin = function(val) {
      this.origin = new Fraction(val);
    };
    this.generate = function() {
      if (!this.numberline) {
        return;
      }
      var curVal = new Fraction;
      var fragment = document.createDocumentFragment();
      var group = document.createElementNS(svgNS, "g");
      group.setAttributeNS(null, "data-step-size", this.step.toString());
      group.setAttributeNS(null, "pointer-events", "none");
      if (tick_class) {
        group.classList.add(tick_class);
      }
      fragment.appendChild(group);
      if (this.step > 0) {
        curVal.set(this.origin).reduce();
        while (curVal <= this.numberline.Maximum) {
          if (curVal >= this.numberline.Minimum) {
            group.appendChild(this.numberline.genTickmark(curVal, null, this.size));
          }
          curVal = curVal.add(this.step);
        }
        curVal.set(this.origin).reduce();
        curVal = curVal.subtract(this.step);
        while (curVal >= this.numberline.Minimum) {
          if (curVal <= this.numberline.Maximum) {
            group.appendChild(this.numberline.genTickmark(curVal, null, this.size));
          }
          curVal = curVal.subtract(this.step);
        }
      }
      if (label_class) {
        $(group).find("text.CTATNumberLine--tickmark-label").each(function() {
          this.classList.add(label_class);
        });
      }
      return fragment;
    };
  };
  var ticksLarge = new Ticks(this, new Fraction(1), 30, "CTATNumberLine--large-tickmark", "CTATNumberLine--large-tickmark-label");
  this.setLargeTickSize = function(size) {
    ticksLarge.setSize(s);
    this.render();
    return this;
  };
  this.setParameterHandler("LargeTickmarkSize", this.setLargeTickSize);
  this.setParameterHandler("LargeTickmarkStep", function(step) {
    ticksLarge.setStep(step);
    this.render();
    return this;
  });
  this.data_ctat_handlers["large-tick-step"] = function(step) {
    ticksLarge.setStep(step);
    this.render();
  };
  var ticksSmall = new Ticks(this, new Fraction(1, 2), 20, "CTATNumberLine--small-tickmark", "CTATNumberLine--small-tickmark-label");
  this.setSmallTickSize = function(size) {
    ticksSmall.setSize(s);
    this.render();
    return this;
  };
  this.setParameterHandler("SmallTickmarkSize", this.setSmallTickSize);
  this.setParameterHandler("SmallTickmarkStep", function(step) {
    ticksSmall.setStep(step);
    this.render();
    return this;
  });
  this.data_ctat_handlers["small-tick-step"] = function(step) {
    ticksSmall.setStep(step);
    this.render();
  };
  var ticksDenominator = new Ticks(this, new Fraction(0), 25, "CTATNumberLine--denominator-tickmark", "CTATNumberLine--denominator-tickmark-label");
  this.setParameterHandler("DenominatorTickmarkSize", function(size) {
    ticksDenominator.setSize(size);
    this.render();
    return this;
  });
  this.setParameterHandler("DenominatorTickmarkStep", function(denom) {
    ticksDenominator.setStep((new Fraction(denom)).reciprocal());
  });
  this.data_ctat_handlers["denominator"] = function(denom) {
    var d = new Fraction(denom);
    ticksDenominator.setStep(d.reciprocal());
  };
  this.setColor = function(aColor) {
    console.log("numberline.setColor");
    var color = CTATGlobalFunctions.formatColor(aColor);
    this.color = color;
    var gNodes = $(this.getDivWrap()).find("g");
    for (var i = 0;i < gNodes.length;i++) {
      $(gNodes[i]).css("stroke", color);
    }
  };
  this.getColor = function() {
    console.log("numberline.getColor");
    return this.color;
  };
  var Axis = function(start_point, end_point, axis_min, axis_max) {
    var _memo = {};
    var _decoration_padding = 10;
    this.svg_group = null;
    var start = start_point;
    Object.defineProperty(this, "start", {get:function() {
      return start;
    }, set:function(value) {
      _memo = {};
      start = value;
    }});
    Object.defineProperty(this, "min_loc", {get:function() {
      if (!_memo.hasOwnProperty("min_loc")) {
        var p = this.start.clone();
        var decoration = _decoration_padding;
        decoration += 10;
        var dv = CTAT.Geom.Point.polar(decoration, this.angle());
        p = p.add(dv);
        p.x = CTAT.Math.round(p.x);
        p.y = CTAT.Math.round(p.y);
        _memo.min_loc = p;
      }
      return _memo.min_loc;
    }});
    var end = end_point;
    Object.defineProperty(this, "end", {get:function() {
      return end;
    }, set:function(value) {
      _memo = {};
      end = value;
    }});
    Object.defineProperty(this, "max_loc", {get:function() {
      if (!_memo.hasOwnProperty("max_loc")) {
        var p = this.end.clone();
        var decoration = _decoration_padding;
        decoration += 10;
        var dv = CTAT.Geom.Point.polar(decoration, this.angle());
        p = p.add(dv.scale(-1));
        p.x = CTAT.Math.round(p.x);
        p.y = CTAT.Math.round(p.y);
        _memo.max_loc = p;
      }
      return _memo.max_loc;
    }});
    var min = axis_min;
    Object.defineProperty(this, "min", {get:function() {
      return min;
    }, set:function(value) {
      _memo = {};
      min = value;
    }});
    var max = axis_max;
    Object.defineProperty(this, "max", {get:function() {
      return max;
    }, set:function(value) {
      _memo = {};
      max = value;
    }});
    Object.defineProperty(this, "length", {get:function() {
      if (!_memo.hasOwnProperty("length")) {
        _memo.length = CTAT.Math.round(this.min_loc.distance(this.max_loc));
      }
      return _memo.length;
    }});
    this.isHorizontal = function() {
      return this.start.y === this.end.y;
    };
    this.isVertical = function() {
      return this.start.x === this.end.x;
    };
    Object.defineProperty(this, "range", {get:function() {
      return this.max.subtract(this.min);
    }});
    Object.defineProperty(this, "step_size", {get:function() {
      if (CTAT.Geom.Point.equals(this.min_loc, this.max_loc)) {
        return this.length;
      }
      return CTAT.Math.round(this.length / this.range);
    }});
    this.s_vec = function() {
      return this.max_loc.add(this.min_loc.scale(-1));
    };
    this.slope = function() {
      var m = this.s_vec();
      return m.y / m.x;
    };
    this.step = function() {
      if (!_memo.hasOwnProperty("step")) {
        _memo.step = this.s_vec().normalize(this.step_size);
      }
      return _memo.step;
    };
    this.scalar = function() {
      if (!_memo.hasOwnProperty("scalar")) {
        _memo.scalar = this.range / this.length;
      }
      return _memo.scalar;
    };
    this.zero = function() {
      if (!_memo.hasOwnProperty("zero")) {
        _memo.zero = this.min_loc.add(this.step().scale(-this.min));
        _memo.zero.x = CTAT.Math.round(_memo.zero.x);
        _memo.zero.y = CTAT.Math.round(_memo.zero.y);
      }
      return _memo.zero;
    };
    this.angle = function() {
      if (!_memo.hasOwnProperty("angle")) {
        var m = this.end.add(this.start.scale(-1));
        _memo.angle = Math.atan2(m.y, m.x);
      }
      return _memo.angle;
    };
    this.angle_deg = function() {
      return CTAT.Math.rad2deg(this.angle());
    };
    this.getPosition = function(value) {
      var p = this.zero().add(this.step().scale(1 * value));
      p.x = CTAT.Math.round(p.x);
      p.y = CTAT.Math.round(p.y);
      return p;
    };
    this.projected_point = function(point) {
      var s = this.s_vec();
      var dps = point.add(this.min_loc.scale(-1));
      var c = 0 + (s.y * dps.x - s.x * dps.y) / (s.y * s.y + s.x * s.x);
      return point.add(new DOMPoint(-c * s.y, c * s.x));
    };
    this.getProjectedPoint = function(point) {
      var pp = this.projected_point(point);
      if (pp.distance(this.max_loc) > this.length) {
        return this.min_loc;
      }
      if (pp.distance(this.min_loc) > this.length) {
        return this.max_loc;
      }
      return pp;
    };
    this.getAxisValue = function(point) {
      return CTAT.Math.round(min + this.scalar() * this.min_loc.distance(this.getProjectedPoint(point)));
    };
  };
  this.X_Axis = new Axis(new DOMPoint(0, 0), new DOMPoint(0, 0), new Fraction(0), new Fraction(3));
  Object.defineProperty(this, "Maximum", {get:function() {
    return this.X_Axis.max;
  }, set:function(value) {
    this.X_Axis.max = new Fraction(value);
  }});
  this.setMaximum = function(newMax) {
    this.Maximum = newMax;
  };
  this.setParameterHandler("Maximum", this.setMaximum);
  this.data_ctat_handlers["maximum"] = this.setMaximum;
  Object.defineProperty(this, "Minimum", {get:function() {
    return this.X_Axis.min;
  }, set:function(value) {
    this.X_Axis.min = new Fraction(value);
  }});
  this.setMinimum = function(m) {
    this.Minimum = m;
  };
  this.setParameterHandler("Minimum", this.setMinimum);
  this.data_ctat_handlers["minimum"] = this.setMinimum;
  var _max_points = 1;
  Object.defineProperty(this, "Max_Points", {get:function() {
    return _max_points;
  }, set:function(m) {
    var im = parseInt(m);
    if (!isNaN(im)) {
      _max_points = im;
    }
  }});
  this.setMaxPoints = function(aMaxPoints) {
    this.Max_Points = aMaxPoints;
  };
  this.setParameterHandler("Max_Points", this.setMaxPoints);
  this.data_ctat_handlers["max-points"] = this.setMaxPoints;
  var _point_size = 7;
  this.setPointSize = function(newPointSize) {
    _point_size = Number(newPointSize);
    if (cursor) {
      cursor.setAttributeNS(null, "r", _point_size);
      $(this._point_group).find("circle").each(function() {
        $(this).attr("r", _point_size);
      });
    }
  };
  this.setStyleHandler("PointSize", this.setPointSize);
  this.data_ctat_handlers["point-size"] = this.setPointSize;
  var _snap = false;
  this.setSnapToTickMark = function(bool) {
    _snap = CTATGlobalFunctions.toBoolean(bool);
  };
  this.setParameterHandler("SnapToTickmark", this.setSnapToTickMark);
  this.data_ctat_handlers["snap"] = this.setSnapToTickMark;
  this.theta = 0;
  Object.defineProperty(this, "Orientation", {get:function() {
    return 180 * this.theta / Math.PI;
  }, set:function(value) {
    var d = Number(value);
    if (isNaN(d)) {
      d = 0;
    }
    this.theta = Math.PI * d / 180;
  }});
  this.setOrientation = function(deg) {
    this.Orientation = deg;
    this.render();
  };
  this.setParameterHandler("Orientation", this.setOrientation);
  this.data_ctat_handlers["rotation"] = this.setOrientation;
  this._tickmarks = [];
  this.genTickmark = function(value, label, size) {
    var fragment = document.createDocumentFragment();
    if (!this._tickmarks.some(function(elem) {
      return elem.data.equals(value);
    })) {
      var pt, pb;
      var tick = document.createElementNS(svgNS, "line");
      var origin = this.X_Axis.getPosition(value);
      var top = (pt = CTAT.Geom.Point.polar(size / 2, this.theta + Math.PI / 2)).add(origin);
      var bot = (pb = CTAT.Geom.Point.polar(-size / 2, this.theta + Math.PI / 2)).add(origin);
      var lloc = bot;
      tick.setAttributeNS(null, "x1", top.x);
      tick.setAttributeNS(null, "y1", top.y);
      tick.setAttributeNS(null, "x2", bot.x);
      tick.setAttributeNS(null, "y2", bot.y);
      tick.setAttributeNS(null, "data-value", value.toString());
      tick.data = value;
      tick.location = origin;
      tick.label = null;
      this._tickmarks.push(tick);
      fragment.appendChild(tick);
      if (label !== "") {
        var tick_label = document.createElementNS(svgNS, "text");
        tick_label.classList.add("CTATNumberLine--tickmark-label");
        tick_label.setAttributeNS(null, "text-anchor", "middle");
        fragment.appendChild(tick_label);
        if (label === null || label === undefined) {
          if (value.denominator == 1) {
            tick_label.appendChild(document.createTextNode(String(value.numerator.toPrecision(_precision))));
            tick_label.setAttributeNS(null, "x", lloc.x);
            tick_label.setAttributeNS(null, "y", lloc.y);
          } else {
            var num = "" + String(value.numerator);
            var den = "" + String(value.denominator);
            tick_label.style.fontSize = "0.6em";
            tick_label.setAttributeNS(null, "text-align", "center");
            var num_lbl = document.createElementNS(svgNS, "tspan");
            var den_lbl = document.createElementNS(svgNS, "tspan");
            num_lbl.appendChild(document.createTextNode(num));
            den_lbl.appendChild(document.createTextNode(den));
            tick_label.appendChild(num_lbl);
            tick_label.appendChild(den_lbl);
            num_lbl.setAttributeNS(null, "text-anchor", "middle");
            num_lbl.setAttributeNS(null, "x", lloc.x);
            num_lbl.setAttributeNS(null, "y", lloc.y);
            num_lbl.setAttributeNS(null, "dy", "-1em");
            den_lbl.setAttributeNS(null, "text-anchor", "middle");
            den_lbl.setAttributeNS(null, "x", lloc.x);
            den_lbl.setAttributeNS(null, "y", lloc.y);
            if (num.length > den.length) {
              num_lbl.style.textDecoration = "underline";
            } else {
              den_lbl.style.textDecoration = "overline";
            }
          }
        } else {
          tick_label.appendChild(document.createTextNode(label.toString()));
          fragment.appendChild(tlabel);
          tick_label.setAttributeNS(null, "x", lloc.x);
          tick_label.setAttributeNS(null, "y", lloc.y);
        }
        tick.label = tick_label;
      }
    }
    return fragment;
  };
  var drawNumberLine = function() {
    if (this.X_Axis === null || this.X_Axis.svg_group === null) {
      return;
    }
    var bbox = this.getBoundingBox();
    var cstyle = window.getComputedStyle(this._axis_line_group);
    var stroke_width = parseInt(cstyle.getPropertyValue("stroke-width"));
    bbox = CTAT.Geom.Rectangle.inflate(bbox, -stroke_width, -stroke_width);
    var center = new DOMPoint(bbox.width / 2, bbox.height / 2);
    var d = Math.min(40, bbox.height, bbox.width) / 4;
    var ref = center.add(CTAT.Geom.Point.polar(d, this.theta));
    var A = Math.sin(this.theta);
    var B = -Math.cos(this.theta);
    var C = A * center.x + B * center.y;
    var det_lr = -bbox.height * B;
    var det_tb = -A * bbox.width;
    var start = new DOMPoint(bbox.left, center.y);
    var end = new DOMPoint(bbox.right, center.y);
    if (Math.abs(CTAT.Math.round(det_lr)) > 0) {
      var test_l = new DOMPoint(bbox.left, (C - A * bbox.left) / B);
      var test_r = new DOMPoint(bbox.right, (C - A * bbox.right) / B);
      if (bbox.contains(test_l) || bbox.contains(test_r)) {
        if (ref.distance(test_l) < ref.distance(test_r)) {
          start = test_r;
          end = test_l;
        } else {
          start = test_l;
          end = test_r;
        }
      }
    }
    if (Math.abs(CTAT.Math.round(det_tb)) > 0) {
      var test_t = new DOMPoint((C - B * bbox.top) / A, bbox.top);
      var test_b = new DOMPoint((C - B * bbox.bottom) / A, bbox.bottom);
      if (bbox.contains(test_t) || bbox.contains(test_b)) {
        if (ref.distance(test_t) < ref.distance(test_b)) {
          start = test_b;
          end = test_t;
        } else {
          start = test_t;
          end = test_b;
        }
      }
    }
    if (this.X_Axis.start.x != start.x || this.X_Axis.start.y != start.y || this.X_Axis.end.x != end.x || this.X_Axis.end.y != end.y) {
      this.X_Axis.start = start;
      this.X_Axis.end = end;
      this.X_Axis.svg_group.innerHTML = "";
      var axis_fragment = document.createDocumentFragment();
      var axis = document.createElementNS(svgNS, "line");
      axis.setAttributeNS(null, "x1", start.x);
      axis.setAttributeNS(null, "y1", start.y);
      axis.setAttributeNS(null, "x2", end.x);
      axis.setAttributeNS(null, "y2", end.y);
      axis_fragment.appendChild(axis);
      var end_l = document.createElementNS(svgNS, "path");
      end_l.setAttributeNS(null, "d", "M 10,6 L 0,0 L 10,-6");
      end_l.setAttributeNS(null, "transform", "translate(" + CTAT.Geom.Point.to2DString(start) + ") rotate(" + this.Orientation + ")");
      axis_fragment.appendChild(end_l);
      var end_r = document.createElementNS(svgNS, "path");
      end_r.setAttributeNS(null, "d", "M -10,6 L 0,0 L -10,-6");
      end_r.setAttributeNS(null, "transform", "translate(" + CTAT.Geom.Point.to2DString(end) + ") rotate(" + this.Orientation + ")");
      axis_fragment.appendChild(end_r);
      this.X_Axis.svg_group.appendChild(axis_fragment);
    }
    this._tickmarks = [];
    var tick_fragment = document.createDocumentFragment();
    tick_fragment.appendChild(ticksLarge.generate());
    tick_fragment.appendChild(ticksSmall.generate());
    tick_fragment.appendChild(ticksDenominator.generate());
    this._tick_mark_group.innerHTML = "";
    this._tick_mark_group.appendChild(tick_fragment);
    var points = this._point_group.children;
    for (var i = 0;i < points.length;i++) {
      var p = points[i];
      var ploc = this.X_Axis.getPosition(p.value);
      var cloc = new DOMPoint(p.cx.baseVal.value, p.cy.baseVal.value);
      if (ploc.distance(cloc) > 1) {
        p.cx.baseVal.value = ploc.x;
        p.cy.baseVal.value = ploc.y;
      }
    }
  }.bind(this);
  var point_group = null;
  var rAFIndex = 0;
  var cursor = null;
  var cursorPosition = new DOMPoint(-30, -30);
  var inframe = false;
  var mousemoveHandler = function(event) {
    cursorPosition.x = event.clientX;
    cursorPosition.y = event.clientY;
  };
  var mouseleaveHandler = function(event) {
    cancelAnimationFrame(rAFIndex);
    cursor.style.visibility = "hidden";
    inframe = false;
  };
  var clickHandler = function(event) {
    if (this.getEnabled() === true && _max_points > 0) {
      this.setHintHighlight(false);
      var pp, value;
      if (_snap) {
        var tick = closest_tick(event.clientX, event.clientY);
        pp = tick.location;
        value = tick.data;
      } else {
        var loc = client2local(event.clientX, event.clientY);
        pp = this.X_Axis.getProjectedPoint(loc);
        value = this.X_Axis.getAxisValue(loc);
      }
      var point = document.createElementNS(svgNS, "circle");
      point.classList.add("CTATNumberLine--point");
      point.setAttributeNS(null, "cx", pp.x);
      point.setAttributeNS(null, "cy", pp.y);
      point.setAttributeNS(null, "r", _point_size);
      point.value = value;
      if (this._point_group.children.length >= this.Max_Points) {
        var children = [].slice.call(this._point_group.children);
        var incorrects = children.filter(function(point, index, array) {
          return point.classList.contains("CTAT--incorrect");
        });
        if (incorrects.length > 0) {
          this._point_group.removeChild(incorrects[0]);
        } else {
          var not_corrects = children.filter(function(point, index, array) {
            return !point.classList.contains("CTAT--correct");
          });
          if (not_corrects.length > 0) {
            this._point_group.removeChild(not_corrects[0]);
          }
        }
      }
      this._point_group.appendChild(point);
      this.setActionInput("AddPoint", value.toString());
      this.processAction();
    }
  }.bind(this);
  this.init = function() {
    this.initSVG();
    this.component.classList.add("CTATNumberLine--container");
    this._axis_line_group = document.createElementNS(svgNS, "g");
    this._axis_line_group.classList.add("CTATNumberLine--axis");
    this._tick_mark_group = document.createElementNS(svgNS, "g");
    this._tick_mark_group.classList.add("CTATNumberLine--tickmark");
    this._point_group = document.createElementNS(svgNS, "g");
    cursor = document.createElementNS(svgNS, "circle");
    cursor.setAttributeNS(null, "r", _point_size);
    cursor.classList.add("CTATNumberLine--cursor");
    cursor.setAttributeNS(null, "transform", "translate(-30,-30)");
    this.component.appendChild(this._axis_line_group);
    this.component.appendChild(this._tick_mark_group);
    this.component.appendChild(this._point_group);
    this.component.appendChild(cursor);
    this.X_Axis.svg_group = this._axis_line_group;
    drawNumberLine();
    this.addComponentReference(this, this.getDivWrap());
    this.component.addEventListener("mousemove", mousemoveHandler);
    this.component.addEventListener("mouseleave", mouseleaveHandler);
    var enabled = this.getEnabled;
    this.component.addEventListener("mouseenter", function() {
      if (enabled() === true && _max_points > 0) {
        inframe = true;
        cursor.style.visibility = null;
        rAFIndex = requestAnimationFrame(moveCursor);
      }
    });
    this.component.addEventListener("click", clickHandler);
    this.component.addEventListener("focus", this.processFocus);
  };
  this.getConfigurationActions = function() {
    var actions = [];
    var sai;
    var $div = $(this.getDivWrap());
    if ($div.attr("data-ctat-minimum")) {
      sai = new CTATSAI;
      sai.setSelection(this.getName());
      sai.setAction("set_minimum");
      sai.setInput($div.attr("data-ctat-minimum"));
      actions.push(sai);
    }
    if ($div.attr("data-ctat-maximum")) {
      sai = new CTATSAI;
      sai.setSelection(this.getName());
      sai.setAction("set_maximum");
      sai.setInput($div.attr("data-ctat-maximum"));
      actions.push(sai);
    }
    if ($div.attr("data-ctat-max-points")) {
      sai = new CTATSAI;
      sai.setSelection(this.getName());
      sai.setAction("set_max_user_entries");
      sai.setInput($div.attr("data-ctat-max-points"));
      actions.push(sai);
    }
    if ($div.attr("data-ctat-large-tick-step")) {
      sai = new CTATSAI;
      sai.setSelection(this.getName());
      sai.setAction("set_large_step");
      sai.setInput($div.attr("data-ctat-large-tick-step"));
      actions.push(sai);
    }
    if ($div.attr("data-ctat-small-tick-step")) {
      sai = new CTATSAI;
      sai.setSelection(this.getName());
      sai.setAction("set_small_step");
      sai.setInput($div.attr("data-ctat-small-tick-step"));
      actions.push(sai);
    }
    if ($div.attr("data-ctat-denominator")) {
      sai = new CTATSAI;
      sai.setSelection(this.getName());
      sai.setAction("set_denominator");
      sai.setInput($div.attr("data-ctat-denominator"));
      actions.push(sai);
    }
    return actions;
  };
  var _in_firefox = navigator.userAgent.toLowerCase().indexOf("firefox") > -1;
  var client2local = function(ex, ey) {
    this.svgPoint = this.svgPoint ? this.svgPoint : this.component.createSVGPoint();
    this.svgPoint.x = ex;
    this.svgPoint.y = ey;
    var matrix = this._axis_line_group.getScreenCTM().inverse();
    this.svgPoint = this.svgPoint.matrixTransform(matrix);
    var p = new DOMPoint(this.svgPoint.x, this.svgPoint.y);
    if (_in_firefox) {
      var $c = $(this.component);
      var x_offset = parseInt($c.css("borderLeftWidth")) + parseInt($c.css("paddingLeft")) + parseInt($c.css("marginLeft"));
      var y_offset = parseInt($c.css("borderTopWidth")) + parseInt($c.css("paddingTop")) + parseInt($c.css("marginTop"));
      p.x -= x_offset;
      p.y -= y_offset;
    }
    return p;
  }.bind(this);
  var project_point = function(ecx, ecy) {
    return this.getProjectedPoint(client2local(ecx, ecy));
  }.bind(this.X_Axis);
  var closest_tick = function(ecx, ecy) {
    var pp = project_point(ecx, ecy);
    var min_tick = null;
    var min_dist = Number.POSITIVE_INFINITY;
    var tick, dist;
    for (var i = 0;i < this._tickmarks.length;i++) {
      tick = this._tickmarks[i];
      dist = pp.distance(tick.location);
      if (dist < min_dist) {
        min_tick = tick;
        min_dist = dist;
      }
    }
    return min_tick;
  }.bind(this);
  var moveCursor = function() {
    if (inframe) {
      if (this.getEnabled() === true) {
        if (_snap) {
          var tick = closest_tick(cursorPosition.x, cursorPosition.y);
          cursor.setAttributeNS(null, "transform", "translate" + CTAT.Geom.Point.to2DString(tick.location, true));
        } else {
          cursor.setAttributeNS(null, "transform", "translate" + CTAT.Geom.Point.to2DString(project_point(cursorPosition.x, cursorPosition.y), true));
        }
        rAFIndex = requestAnimationFrame(moveCursor);
      }
    }
  }.bind(this);
  this.render = function() {
    drawNumberLine();
  };
  this.calcXCoordinate = function(num) {
    var fraction = new Fraction(num);
    var start = 30;
    var end = this.getWidth() - 30;
    var rangePix = Math.abs(end - start);
    var range = max.subtract(min);
    var offset = fraction.subtract(min).divide(range);
    return start + offset / rangePix;
  };
  this.calcNum = function(xCoor) {
    var start = 30;
    var end = this.getWidth() - 30;
    var rangePix = Math.abs(end - start);
    var range = max.subtract(min);
    var offset = range.multiply((xCoor - start) / rangePix);
    return min.add(offset);
  };
  var fix_sai = function(comp, sai) {
    switch(sai.getClassName()) {
      case "CTATMessage":
        sai = sai.getSAI();
        break;
      default:
        break;
    }
    var s = sai.clone();
    s.setAction(comp.getSAI().getAction());
    s.setSelection(comp.getName());
    return s;
  };
  this.showCorrect = function(aSAI) {
    var name = aSAI.getInput();
    var action = aSAI.getAction();
    var call_correct = function(c) {
      c.setCorrect(fix_sai(c, aSAI));
    };
    switch(action) {
      case "AddPoint":
        if (this._point_group.children.length > 0) {
          var children = [].slice.call(this._point_group.children);
          var last_point = children[children.length - 1];
          last_point.classList.remove("CTAT--incorrect");
          last_point.classList.remove("CTAT--hint");
          last_point.classList.add("CTAT--correct");
          if (this.getDisableOnCorrect()) {
            if (children.length >= this.Max_Points && children.every(function(c) {
              return c.classList.contains("CTAT--correct");
            })) {
              this.setEnabled(false);
            } else {
              this.setEnabled(true);
            }
          }
        }
        break;
      case "Points":
        var points = this._point_group.children;
        for (var p = 0;p < points.length;p++) {
          var point = points[p];
          point.classList.remove("CTAT--incorrect");
          point.classList.remove("CTAT--hint");
          point.classList.add("CTAT--correct");
        }
        break;
      case "set_minimum":
        ctrl_component(get_ctrl_min()).forEach(call_correct);
        break;
      case "set_maximum":
        ctrl_component(get_ctrl_max()).forEach(call_correct);
        break;
      case "set_large_step":
        ctrl_component(get_ctrl_large()).forEach(call_correct);
        break;
      case "set_small_step":
        ctrl_component(get_ctrl_small()).forEach(call_correct);
        break;
      case "set_denominator":
        ctrl_component(get_ctrl_denom()).forEach(call_correct);
        break;
      default:
        console.log("Unhandled Action in", this.getName(), action);
    }
  };
  this.showInCorrect = function(aSAI) {
    var name = aSAI.getInput();
    var action = aSAI.getAction();
    var call_incorrect = function(c) {
      c.setIncorrect(fix_sai(c, aSAI));
    };
    switch(action) {
      case "AddPoint":
        if (this._point_group.children.length > 0) {
          var children = [].slice.call(this._point_group.children);
          var last_point = children[children.length - 1];
          last_point.classList.remove("CTAT--correct");
          last_point.classList.remove("CTAT--hint");
          last_point.classList.add("CTAT--incorrect");
        }
        break;
      case "Points":
        var points = this._point_group.children;
        for (var p = 0;p < points.length;p++) {
          var point = points[p];
          point.classList.remove("CTAT--correct");
          point.classList.remove("CTAT--hint");
          point.classList.add("CTAT--incorrect");
        }
        break;
      case "set_minimum":
        ctrl_component(get_ctrl_min()).forEach(call_incorrect);
        break;
      case "set_maximum":
        ctrl_component(get_ctrl_max()).forEach(call_incorrect);
        break;
      case "set_large_step":
        ctrl_component(get_ctrl_large()).forEach(call_incorrect);
        break;
      case "set_small_step":
        ctrl_component(get_ctrl_small()).forEach(call_incorrect);
        break;
      case "set_denominator":
        ctrl_component(get_ctrl_denom()).forEach(call_incorrect);
        break;
      default:
        console.log("Unhandled Action in", this.getName(), action);
    }
  };
  var super_setEnabled = this.setEnabled;
  this.setEnabled = function(bool) {
    super_setEnabled(bool);
    if (cursor && inframe) {
      cursor.style.visibility = this.getEnabled() ? null : "hidden";
    }
  };
  this.set_minimum = function(str) {
    this.Minimum = str;
    this.render();
  };
  this.change_minimum = function(delta) {
    var d = new Fraction(delta);
    if (d.valueOf() !== 0) {
      this.Minimum = this.Minimum.add(d);
      this.render();
    }
  };
  var updateSAI_minimum = function() {
    this.setActionInput("set_minimum", this.Minimum);
  }.bind(this);
  this.set_maximum = function(str) {
    this.Maximum = str;
    this.render();
  };
  this.change_maximum = function(delta) {
    var d = new Fraction(delta);
    if (d.valueOf() !== 0) {
      this.Maximum = this.Maximum.add(d);
      this.render();
    }
  };
  var updateSAI_maximum = function() {
    this.setActionInput("set_maximum", this.Maximum);
  }.bind(this);
  this.set_max_user_entries = function(str) {
    this.setMaxPoints(parseInt(str));
  };
  var set_step = function(ticks, str) {
    ticks.setStep(str);
    this.render();
  };
  this.set_large_step = set_step.bind(this, ticksLarge);
  var updateSAI_large_step = function() {
    this.setActionInput("set_large_step", ticksLarge.step.toString());
  }.bind(this);
  this.set_small_step = set_step.bind(this, ticksSmall);
  var updateSAI_small_step = function() {
    this.setActionInput("set_small_step", ticksSmall.step.toString());
  }.bind(this);
  this.set_denominator = function(str) {
    if (parseInt(str) === 0) {
      ticksDenominator.setStep(0);
    } else {
      ticksDenominator.setStep((new Fraction(str)).reciprocal());
    }
    this.render();
  };
  var updateSAI_denominator = function() {
    var denom = ticksDenominator.step.valueOf() === 0 ? 0 : ticksDenominator.step.reciprocal();
    this.setActionInput("set_denominator", denom.toString());
  }.bind(this);
  var change_step = function(ticks, delta) {
    var d = new Fraction(delta);
    if (d.valueOf() !== 0) {
      var step = ticks.step.add(delta);
      if (step.valueOf() < 0) {
        step.set(0, 1);
      }
      ticks.setStep(step);
      this.render();
    }
  };
  this.change_large_step = change_step.bind(this, ticksLarge);
  this.change_small_step = change_step.bind(this, ticksSmall);
  this.change_denominator = function(delta) {
    var d = new Fraction(delta);
    if (d.valueOf() !== 0) {
      var s = d.add(ticksDenominator.step.denominator);
      ticksDenominator.setStep(s.reciprocal());
      this.render();
    }
  };
  var _precision = undefined;
  this.set_precision = function(str) {
    _precision = parseInt(str);
    this.render();
  };
  this.AddPoint = function(val, sai) {
    var value = new Fraction(val);
    var pp = this.X_Axis.getPosition(value);
    var point = document.createElementNS(svgNS, "circle");
    point.classList.add("CTATNumberLine--point");
    point.setAttributeNS(null, "cx", pp.x);
    point.setAttributeNS(null, "cy", pp.y);
    point.setAttributeNS(null, "r", _point_size);
    point.value = value;
    var children = [].slice.call(this._point_group.children);
    if (!children.some(function(c) {
      return value.equals(c.value);
    })) {
      this._point_group.appendChild(point);
    }
  };
  this.Points = function(str, sai) {
    this._point_group.innerHTML = "";
    var points = str.split(";");
    for (var i in points) {
      this.AddPoint(points[i], sai);
    }
  };
  var controller_update = function(change_callback, set_callback, update_sai, sai) {
    switch(sai.getAction()) {
      case "ButtonPressed":
        change_callback.call(this, sai.getInput());
        break;
      case "Update":
      ;
      case "UpdateTextField":
      ;
      case "UpdateTextArea":
        set_callback.call(this, sai.getInput());
        break;
      default:
        break;
    }
    update_sai.call();
    this.processAction(false, true);
  };
  var get_ctrl = function(type) {
    var ctrls = $(this.getDivWrap()).attr(type);
    if (ctrls) {
      return ctrls.split(/\s*;\s*/).map(function(i) {
        return i.trim();
      });
    } else {
      return [];
    }
  };
  var get_ctrl_max = get_ctrl.bind(this, "data-ctat-ctrl-max");
  var get_ctrl_min = get_ctrl.bind(this, "data-ctat-ctrl-min");
  var get_ctrl_large = get_ctrl.bind(this, "data-ctat-ctrl-large-tick");
  var get_ctrl_small = get_ctrl.bind(this, "data-ctat-ctrl-small-tick");
  var get_ctrl_denom = get_ctrl.bind(this, "data-ctat-ctrl-denominator");
  var ctrl_component = function(names) {
    return names.map(function(id) {
      return $("#" + id).data("CTATComponent");
    });
  };
  var isController = function(aComponent) {
    var ctrl_name = null;
    if (aComponent instanceof CTAT.Component.Base.Tutorable) {
      if (aComponent != this) {
        ctrl_name = aComponent.getName();
      }
    } else {
      if (aComponent instanceof CTATSAI) {
        if (aComponent.getSelection() != pointer.getName()) {
          ctrl_name = aComponent.getSelection();
        }
      } else {
        if (aComponent instanceof String) {
          if (aComponent != pointer.getName()) {
            ctrl_name = aComponent;
          }
        } else {
          if (aComponent instanceof Element) {
            if (aComponent != pointer.getComponent()) {
              ctrl_name = aComponent.id;
            }
          } else {
            return null;
          }
        }
      }
    }
    if (ctrl_name) {
      if (isa_denom(ctrl_name)) {
        return controller_update.bind(this, this.change_denominator, this.set_denominator, updateSAI_denominator);
      } else {
        if (isa_small(ctrl_name)) {
          return controller_update.bind(this, this.change_small_step, this.set_small_step, updateSAI_small_step);
        } else {
          if (isa_large(ctrl_name)) {
            return controller_update.bind(this, this.change_large_step, this.set_large_step, updateSAI_large_step);
          } else {
            if (isa_min(ctrl_name)) {
              return controller_update.bind(this, this.change_minimum, this.set_minimum, updateSAI_minimum);
            } else {
              if (isa_max(ctrl_name)) {
                return controller_update.bind(this, this.change_maximum, this.set_maximum, updateSAI_maximum);
              }
            }
          }
        }
      }
    }
    return null;
  }.bind(this);
  if (!CTATConfiguration.get("previewMode")) {
    document.addEventListener(CTAT.Component.Base.Tutorable.EventType.action, function(e) {
      var sai = e.detail.sai;
      var ctrl = isController(e.detail.component);
      if (sai && ctrl !== null) {
        ctrl(sai);
      }
    }, false);
  }
  this.setMaxControllers = function(controllers) {
    $(this.getDivWrap()).attr("data-ctat-ctrl-max", controllers);
  };
  this.setParameterHandler("MaxValueControllers", this.setMaxControllers);
  this.setMinControllers = function(controllers) {
    $(this.getDivWrap()).attr("data-ctat-ctrl-min", controllers);
  };
  this.setParameterHandler("MinValueControllers", this.setMinControllers);
  this.setLargeTickControllers = function(controllers) {
    $(this.getDivWrap()).attr("data-ctat-ctrl-large-tick", controllers);
  };
  this.setParameterHandler("LargeTickmarkControllers", this.setLargeTickControllers);
  this.setSmallTickControllers = function(controllers) {
    $(this.getDivWrap()).attr("data-ctat-ctrl-small-tick", controllers);
  };
  this.setParameterHandler("SmallTickmarkControllers", this.setSmallTickControllers);
  this.setDenominatorControllers = function(controllers) {
    $(this.getDivWrap()).attr("data-ctat-ctrl-denominator", controllers);
  };
  this.setParameterHandler("DenominatorTickmarkControllers", this.setDenominatorControllers);
  var isa = function(gctrl, id) {
    return gctrl().indexOf(id) >= 0;
  };
  var isa_max = isa.bind(null, get_ctrl_max);
  var isa_min = isa.bind(null, get_ctrl_min);
  var isa_large = isa.bind(null, get_ctrl_large);
  var isa_small = isa.bind(null, get_ctrl_small);
  var isa_denom = isa.bind(null, get_ctrl_denom);
  this.grade = function(submit_button) {
    var sb_name = submit_button.getDivWrap().id;
    if (isa_max(sb_name)) {
      this.setAction("set_maximum");
      this.setInput(this.Maximum.toString());
    } else {
      if (isa_min(sb_name)) {
        this.setAction("set_minimum");
        this.setInput(this.Minimum.toString());
      } else {
        if (isa_large(sb_name)) {
          this.setAction("set_large_step");
          this.setInput(ticksLarge.step.toString());
        } else {
          if (isa_small(sb_name)) {
            this.setAction("set_small_step");
            this.setInput(ticksSmall.step.toString());
          } else {
            if (isa_denom(sb_name)) {
              this.setAction("set_denominator");
              this.setInput(ticksDenominator.step.reciprocal().toString());
            } else {
              this.updateSAI();
            }
          }
        }
      }
    }
    this.processAction(true);
  };
  this.updateSAI = function() {
    var points = this._point_group.children;
    var pvals = [];
    for (var i = 0;i < points.length;i++) {
      pvals.push(points[i].value);
    }
    pvals.sort(function(a, b) {
      return a - b;
    });
    this.setActionInput("Points", pvals.join(";"));
  };
};
CTATNumberLine.prototype = Object.create(CTAT.Component.Base.SVG.prototype);
CTATNumberLine.prototype.constructor = CTATNumberLine;
CTAT.ComponentRegistry.addComponentType("CTATNumberLine", CTATNumberLine);
goog.provide("CTATNumericStepper");
goog.require("CTAT.Component.Base.Tutorable");
goog.require("CTAT.ComponentRegistry");
goog.require("CTATSAI");
CTATNumericStepper = function(aDescription, aX, aY, aWidth, aHeight) {
  CTAT.Component.Base.Tutorable.call(this, "CTATNumericStepper", "__undefined__", aDescription, aX, aY, aWidth, aHeight);
  this.setAction("Update");
  var spinner = document.createElement("input");
  spinner.type = "number";
  this.set_maximum = function(max) {
    max = Number(max);
    if (!isNaN(max)) {
      spinner.max = max;
    }
  };
  this.setParameterHandler("maximum", this.set_maximum);
  this.set_minimum = function(min) {
    min = Number(min);
    if (!isNaN(min)) {
      spinner.min = min;
    }
  };
  this.setParameterHandler("minimum", this.set_minimum);
  this.set_step = function(step) {
    step = Number(step);
    if (!isNaN(step)) {
      spinner.step = step;
    }
  };
  this.setParameterHandler("stepSize", this.set_step);
  this.update_value = function(val) {
    val = Number(val);
    if (!isNaN(val)) {
      spinner.value = val;
      this.setInput(val);
    }
  };
  this.setParameterHandler("value", this.update_value);
  this.updateSAI = function() {
    this.setInput(spinner.value);
  };
  this.Update = this.update_value;
  this.init = function() {
    spinner.id = this.getName() + "_spinner";
    this.setComponent(spinner);
    this.setInitialized(true);
    var $div = $(this.getDivWrap());
    var $spinner = $(spinner);
    ["autofocus", "defaultValue", "placeholder", "value", "max", "min", "readOnly", "step"].forEach(function(attr) {
      var av = $div.attr(attr);
      if (av) {
        $spinner.attr(attr, av);
      }
    });
    if (!CTATConfiguration.get("previewMode")) {
      this.getDivWrap().innerHTML = "";
    }
    this.getDivWrap().appendChild(spinner);
    this.component.addEventListener("focus", this.processFocus);
    var pointer = this;
    spinner.addEventListener("change", function(e) {
      var min = Number(this.min);
      if (isNaN(min)) {
        min = 0;
      }
      var value = Number(this.value);
      if (isNaN(value)) {
        this.value = min;
      } else {
        if (this.min !== "" && value < min) {
          this.value = min;
        } else {
          if (this.max !== "" && !isNaN(Number(this.max)) && value > Number(this.max)) {
            this.value = this.max;
          } else {
            var step = Number(this.step);
            if (isNaN(step) || step <= 0) {
              step = 1;
            }
            var mod = (value - min) % step;
            if (mod !== 0) {
              this.value = value - mod;
            }
          }
        }
      }
      pointer.updateSAI();
      pointer.processAction();
      return false;
    });
    if (CTATConfiguration.get("previewMode")) {
      this.addEventScreen(false);
    }
  };
  this.getConfigurationActions = function() {
    var actions = [];
    var sai;
    var $div = $(this.getDivWrap());
    if ($div.attr("min")) {
      sai = new CTATSAI;
      sai.setSelection(this.getName());
      sai.setAction("set_minimum");
      sai.setInput($div.attr("min"));
      actions.push(sai);
    }
    if ($div.attr("max")) {
      sai = new CTATSAI;
      sai.setSelection(this.getName());
      sai.setAction("set_maximum");
      sai.setInput($div.attr("max"));
      actions.push(sai);
    }
    if ($div.attr("step")) {
      sai = new CTATSAI;
      sai.setSelection(this.getName());
      sai.setAction("set_step");
      sai.setInput($div.attr("step"));
      actions.push(sai);
    }
    if ($div.attr("value")) {
      sai = new CTATSAI;
      sai.setSelection(this.getName());
      sai.setAction("Update");
      sai.setInput($div.attr("value"));
      actions.push(sai);
    }
    return actions;
  };
};
CTATNumericStepper.prototype = Object.create(CTAT.Component.Base.Tutorable.prototype);
CTATNumericStepper.prototype.constructor = CTATNumericStepper;
CTAT.ComponentRegistry.addComponentType("CTATNumericStepper", CTATNumericStepper);
goog.provide("CTATPieChart");
goog.require("CTAT.Geom.Point");
goog.require("CTAT.Math.Fraction");
goog.require("CTAT.Component.Base.UnitDisplay");
goog.require("CTAT.ComponentRegistry");
goog.require("CTATGlobals");
CTATPieChart = function(aDescription, aX, aY, aWidth, aHeight) {
  CTAT.Component.Base.UnitDisplay.call(this, "CTATPieChart", "aPieChart", aDescription, aX, aY, aWidth, aHeight);
  var explode = 3;
  var dropDistance = 3;
  var pointer = this;
  var dropShadow;
  var dropShadowRef;
  var dropShadowUrl;
  var offset = null;
  var svgNS = CTATGlobals.NameSpace.svg;
  this.init = function() {
    this.initSVG();
    this.baseGroup = document.createElementNS(svgNS, "g");
    this.getComponent().appendChild(this.baseGroup);
    this.getComponent().classList.add("CTATPieChart--container");
    dropShadow = document.createElementNS(svgNS, "filter");
    dropShadow.id = this.genName("Shadow");
    dropShadowRef = "#" + dropShadow.id;
    dropShadowUrl = "url(" + dropShadowRef + ")";
    dropShadow.setAttributeNS(null, "width", "200%");
    dropShadow.setAttributeNS(null, "height", "200%");
    offset = document.createElementNS(svgNS, "feOffset");
    offset.setAttributeNS(null, "in", "SourceAlpha");
    offset.setAttributeNS(null, "result", "offOut");
    offset.setAttributeNS(null, "dx", dropDistance);
    offset.setAttributeNS(null, "dy", dropDistance);
    dropShadow.appendChild(offset);
    var blur = document.createElementNS(svgNS, "feGaussianBlur");
    blur.setAttributeNS(null, "in", "offOut");
    blur.setAttributeNS(null, "result", "blurOut");
    blur.setAttributeNS(null, "stdDeviation", 4);
    dropShadow.appendChild(blur);
    var blend = document.createElementNS(svgNS, "feBlend");
    blend.setAttributeNS(null, "in", "SourceGraphic");
    blend.setAttributeNS(null, "in2", "blurOut");
    blend.setAttributeNS(null, "mode", "normal");
    dropShadow.appendChild(blend);
    this.getComponent().getElementsByTagName("defs")[0].appendChild(dropShadow);
    if (dropDistance > 0) {
      this.baseGroup.setAttributeNS(null, "filter", dropShadowUrl);
    }
    this.drawPieces();
    this.addComponentReference(this, this.getDivWrap());
    this.component.addEventListener("focus", this.processFocus);
  };
  this.render = function() {
    this.drawPieces();
  };
  this.drawPieces = function() {
    if (this.baseGroup) {
      this.clear();
      var cstyle = window.getComputedStyle(this.getComponent());
      var stroke_width = parseFloat(cstyle.getPropertyValue("stroke-width"));
      var bbox = this.getBoundingBox();
      var radius = Math.min(bbox.width / 2, bbox.height / 2) - (stroke_width + dropDistance + 4);
      var center = new DOMPoint(bbox.width / 2, bbox.height / 2);
      var arr = this.parseValue();
      var fragment = document.createDocumentFragment();
      arr.reduce(function(sum, frac, i, a) {
        if (frac.valueOf() >= 1) {
          var fc = document.createElementNS(svgNS, "circle");
          fc.classList.add("CTATPieChart--piece");
          fc.cx.baseVal.value = center.x;
          fc.cy.baseVal.value = center.y;
          fc.r.baseVal.value = radius;
          this.addPieceElem(fc, frac, frac.selected);
          fragment.appendChild(fc);
        } else {
          var p = document.createElementNS(svgNS, "path");
          p.classList.add("CTATPieChart--piece");
          fragment.appendChild(p);
          var pstyle = window.getComputedStyle(p);
          var startAngle = 2 * Math.PI * sum.valueOf();
          var start = center.add(CTAT.Geom.Point.polar(radius, startAngle));
          frac.reduce();
          var theta = 2 * Math.PI * frac.valueOf();
          var end = center.add(CTAT.Geom.Point.polar(radius, theta + startAngle));
          var tip = center.clone();
          if (true && explode > 0 && explode < radius) {
            var exp = CTAT.Geom.Point.polar(explode, startAngle + Math.PI * frac.valueOf());
            tip = tip.add(exp);
            start = start.add(exp);
            var sint = CTAT.Geom.Point.circle_intersection(tip, start, center, radius);
            var find_closest = function(check, closest, point) {
              return check["distance"](closest) < check["distance"](point) ? closest : point;
            };
            start = sint.reduce(find_closest.bind(this, start));
            end = end.add(exp);
            var eint = CTAT.Geom.Point.circle_intersection(tip, end, center, radius);
            end = eint.reduce(find_closest.bind(this, end));
          }
          var toS = CTAT.Geom.Point.to2DString;
          var pathStr = "M " + toS(tip);
          var r = new DOMPoint(radius, radius);
          pathStr += " L " + toS(start);
          pathStr += " A " + toS(r) + " 0 " + (frac.valueOf() > .5 ? 1 : 0) + ",1 " + toS(end);
          pathStr += " Z";
          p.setAttributeNS(null, "d", pathStr);
          pointer.addPieceElem(p, frac, frac.selected);
        }
        return sum.add(frac);
      }, new CTAT.Math.Fraction);
      this.baseGroup.innerHTML = "";
      this.baseGroup.appendChild(fragment);
    }
  };
  this.getExplode = function() {
    return explode;
  };
  this.getDropShadowDistance = function() {
    return dropDistance;
  };
  this.setExplode = function(aExplode) {
    var ex = Number(aExplode);
    if (!isNaN(ex)) {
      var repaint = ex !== explode;
      explode = ex;
      if (repaint) {
        this.drawPieces();
      }
    }
    return this;
  };
  this.setStyleHandler("explode", this.setExplode);
  this.data_ctat_handlers["explode"] = function(val) {
    this.setExplode(val);
  };
  this.setDropShadowDistance = function(aDrop) {
    dropDistance = parseInt(aDrop);
    dropDistance = isNaN(dropDistance) ? 0 : dropDistance;
    if (offset) {
      offset.setAttributeNS(null, "dx", dropDistance);
      offset.setAttributeNS(null, "dy", dropDistance);
      if (dropDistance <= 0 && this.baseGroup) {
        this.baseGroup.removeAttributeNS(null, "filter");
      } else {
        if (!this.baseGroup.hasAttributeNS(null, "filter")) {
          this.baseGroup.setAttributeNS(null, "filter", dropShadowUrl);
        }
      }
    }
  };
  this.data_ctat_handlers["shadow-distance"] = function(val) {
    this.setDropShadowDistance(val);
  };
};
CTATPieChart.prototype = Object.create(CTAT.Component.Base.UnitDisplay.prototype);
CTATPieChart.prototype.constructor = CTATPieChart;
CTAT.ComponentRegistry.addComponentType("CTATPieChart", CTATPieChart);
goog.provide("CTATRadioButton");
goog.require("CTATGlobals");
goog.require("CTATGlobalFunctions");
goog.require("CTAT.Component.Base.Clickable");
goog.require("CTAT.ComponentRegistry");
goog.require("CTATSAI");
goog.require("CTATShellTools");
CTATRadioButton = function(aDescription, aX, aY, aWidth, aHeight) {
  CTAT.Component.Base.Clickable.call(this, "CTATRadioButton", "__undefined__", aDescription, aX, aY, aWidth, aHeight);
  var previewMode = CTATConfiguration.get("previewMode");
  var pointer = this;
  var radiobutton = null;
  var label = null;
  var color = "#000000";
  this.setSelection(this.getComponentGroup());
  this.setAction("UpdateRadioButton");
  this.setStyleHandler("BackgroundColor", null);
  this.init = function init() {
    pointer.setInitialized(true);
    radiobutton = document.createElement("input");
    radiobutton.type = "radio";
    radiobutton.id = this.getName() + "_radio";
    radiobutton.value = pointer.getName();
    if (this.getComponentGroup()) {
      radiobutton.name = pointer.getComponentGroup();
    } else {
      if (this.getDivWrap() && $(this.getDivWrap()).attr("name")) {
        radiobutton.name = $(this.getDivWrap()).attr("name");
      } else {
        radiobutton.name = "radioButtonGroup";
      }
    }
    if (pointer.getEnabled() === true) {
      radiobutton.disabled = false;
    } else {
      radiobutton.disabled = true;
    }
    pointer.addComponentReference(pointer, radiobutton);
    var content;
    if (!previewMode) {
      content = this.getDivWrap().innerHTML;
      this.getDivWrap().innerHTML = "";
    }
    pointer.getDivWrap().appendChild(radiobutton);
    label = document.createElement("label");
    label.htmlFor = radiobutton.id;
    if (this.getText()) {
      label.textContent = pointer.getText();
    } else {
      if (content && !previewMode) {
        label.innerHTML = content;
      } else {
        if (this.getDivWrap().getAttribute("data-ctat-label")) {
          label.textContent = this.getDivWrap().getAttribute("data-ctat-label");
        }
      }
    }
    pointer.setComponent(radiobutton);
    this.getDivWrap().appendChild(label);
    radiobutton.addEventListener("click", function(e) {
      pointer.updateSAI();
      pointer.processAction();
    });
    radiobutton.addEventListener("focus", this.processFocus);
    radiobutton.onfocus = this.processOnFocus;
    this.setSelection(this.getComponentGroup());
    this.component.addEventListener("focus", this.processFocus);
  };
  this.getConfigurationActions = function() {
    var actions = [];
    if (label.innerHTML.trim().length > 0) {
      var sai = new CTATSAI;
      sai.setSelection(this.getName());
      sai.setInput(label.innerHTML.toString());
      sai.setAction("setText");
      actions.push(sai);
    }
    return actions;
  };
  this.setFontColor = function(aColor) {
    color = aColor;
    $(label).css("color", aColor);
  };
  this.getFontColor = function() {
    return color;
  };
  this.resize = function() {
    var height = $(this.getDivWrap()).height();
    $(label).css("font-size", height - 5 + "px");
    $(this.getComponent()).css("height", height - 10 + "px");
    $(this.getComponent()).css("width", height - 10 + "px");
  };
  var super_setText = this.setText;
  this.setText = function setText(aText) {
    super_setText(aText);
    if (label !== null) {
      label.innerHTML = this.getText();
    }
  };
  this.setStyleHandler("buttonLabel", this.setText);
  var super_setEnabled = this.setEnabled;
  this.setEnabled = function setEnabled(aValue) {
    super_setEnabled(aValue);
    if (radiobutton === null) {
      return;
    }
    radiobutton.disabled = !this.getEnabled();
  };
  this.setChecked = function setChecked(aValue) {
    if (radiobutton === null) {
      return;
    }
    radiobutton.checked = aValue;
  };
  this.getChecked = function getChecked() {
    return radiobutton.checked;
  };
  this.getRadioInput = function getRadioInput() {
    if (radiobutton.checked) {
      return radiobutton.value + ": " + label.textContent;
    } else {
      return "";
    }
  };
  this.setStyleHandler("labelPlacement", null);
  this.reset = function reset() {
    pointer.ctatdebug(" reset ( " + pointer.getName() + ")");
    radiobutton.checked = false;
    pointer.setEnabled(true);
  };
  this.UpdateRadioButton = function UpdateRadioButton(selection) {
    if (selection.indexOf(radiobutton.value) >= 0) {
      pointer.setChecked(true);
    }
    pointer.ctatdebug("UpdateRadioButton ()");
  };
  this.updateSAI = function() {
    var radios = $("." + this.getClassName() + '[data-ctat-component]:has(input[type="radio"][name="' + radiobutton.name + '"]:checked)');
    var input = "";
    if (radios.length === 1) {
      input = $(radios[0]).data("CTATComponent").getRadioInput();
    }
    pointer.setSelection(radiobutton.name);
    pointer.setInput(input);
  };
  var add_highlighting = function(h) {
    if (label) {
      label.classList.add(h);
    }
    if (radiobutton) {
      radiobutton.classList.add(h);
    }
  };
  var remove_highlighting = function(h) {
    if (label) {
      label.classList.remove(h);
    }
    if (radiobutton) {
      radiobutton.classList.remove(h);
    }
  };
  this.showCorrect = function(aSAI) {
    remove_highlighting("CTAT--hint");
    remove_highlighting("CTAT--incorrect");
    if (aSAI ? aSAI.getInput().indexOf(radiobutton.value) === 0 : true) {
      add_highlighting("CTAT--correct");
    } else {
      remove_highlighting("CTAT-correct");
    }
  };
  this.removeCorrect = function() {
    remove_highlighting("CTAT--correct");
  };
  this.showInCorrect = function(aSAI) {
    remove_highlighting("CTAT--hint");
    remove_highlighting("CTAT--correct");
    if (aSAI ? aSAI.getInput().indexOf(radiobutton.value) === 0 : true) {
      add_highlighting("CTAT--incorrect");
    } else {
      remove_highlighting("CTAT-incorrect");
    }
  };
  this.removeInCorrect = remove_highlighting.bind(this, "CTAT--incorrect");
  this.showHintHighlight = function(pHint) {
    this.removeCorrect();
    this.removeInCorrect();
    if (pHint) {
      add_highlighting("CTAT--hint");
    } else {
      remove_highlighting("CTAT--hint");
    }
  };
};
CTATRadioButton.prototype = Object.create(CTAT.Component.Base.Clickable.prototype);
CTATRadioButton.prototype.constructor = CTATRadioButton;
CTAT.ComponentRegistry.addComponentType("CTATRadioButton", CTATRadioButton);
goog.provide("CTATScrollPaneComponent");
goog.require("CTATCommShell");
goog.require("CTAT.Component.Base.Tutorable");
goog.require("CTAT.ComponentRegistry");
goog.require("CTATScrim");
CTATScrollPaneComponent = function(aDescription, aX, aY, aWidth, aHeight) {
  CTAT.Component.Base.Tutorable.call(this, "CTATScrollPaneComponent", "__undefined__", aDescription, aX, aY, aWidth, aHeight);
  var hints = [];
  var alpha = 0;
  var pointer = this;
  pointer.isTabIndexable = false;
  var scrollpane = null;
  this.getAlpha = function getAlpha() {
    return alpha;
  };
  this.setAlpha = function setAlpha(aAlpha) {
    alpha = aAlpha;
  };
  this.init = function init() {
    pointer.ctatdebug("init (" + pointer.getName() + ")");
    pointer.ctatdebug("Final location: " + pointer.getX() + "," + pointer.getY() + " with text: " + pointer.getText());
    pointer.setInitialized(true);
  };
  this.processCommShellEvent = function processCommShellEvent(anEvent, aMessage) {
    pointer.ctatdebug("processCommShellEvent (" + anEvent + ")");
  };
  this.processSerialization = function processSerialization() {
    pointer.ctatdebug("processSerialization()");
  };
  this.postProcess = function postProcess() {
    pointer.ctatdebug("postProcess ()");
    for (var paramName in this.parameters) {
      var paramValue = this.parameters[paramName];
      pointer.ctatdebug("Checking style name: " + paramName);
      if (paramName == "TargetMovieClip") {
        pointer.ctatdebug("Loading sub element: [" + paramValue.trim() + "] ...");
        var aClip = findMovieClip(paramValue.trim());
        if (aClip !== null) {
          pointer.ctatdebug("Found target movieclip, temporarily removing ...");
          if (aClip.getDivWrapper().parentNode !== null) {
            try {
              aClip.getDivWrapper().parentNode.removeChild(aClip.getDivWrapper());
            } catch (err) {
              CTATScrim.scrim.errorScrimUp(err.message);
              return;
            }
            pointer.getDivWrap().setAttribute("id", "scrollsubdiv");
            pointer.ctatdebug("Adding ...");
            pointer.getDivWrap().appendChild(aClip.getDivWrapper());
            var xDiff = aClip.getDivWrapper().style.left;
            var yDiff = aClip.getDivWrapper().style.top;
            aClip.getDivWrapper().style.left = "0px";
            aClip.getDivWrapper().style.top = "0px";
            pointer.ctatdebug("Moving canvas from: " + xDiff + "," + yDiff + " to: 0,0");
            var childNodes = aClip.getDivWrapper().childNodes;
            for (var i = 0;i < childNodes.length;i++) {
              var aNode = childNodes[i]
            }
          }
        } else {
          pointer.ctatdebug("Unable to find the target movieclip to reparent the content from");
        }
      }
    }
    pointer.ctatdebug("Final location: " + pointer.getX() + "," + pointer.getY() + " with text: " + pointer.getText());
    if (CTATCommShell.commShell === null || CTATCommShell.commShell === undefined) {
      pointer.ctatdebug("Error: can't add event listener to commshell, pointer is invalid");
    } else {
      CTATCommShell.commShell.addGlobalEventListener(this);
    }
  };
  this.configFromDescription();
};
CTATScrollPaneComponent.prototype = Object.create(CTAT.Component.Base.Tutorable.prototype);
CTATScrollPaneComponent.prototype.constructor = CTATScrollPaneComponent;
CTAT.ComponentRegistry.addComponentType("CTATScrollPaneComponent", CTATScrollPaneComponent);
goog.provide("CTATSkillWindow");
goog.require("CTAT.Component.Base.Graphical");
goog.require("CTATGlobalFunctions");
goog.require("CTATGlobals");
goog.require("CTAT.ComponentRegistry");
goog.require("CTATSkillSet");
CTATSkillWindow = function(aDescription, aX, aY, aWidth, aHeight) {
  CTAT.Component.Base.Graphical.call(this, "CTATSkillWindow", "__undefined__", aDescription, aX, aY, aWidth, aHeight);
  var pointer = this;
  pointer.isTabIndexable = false;
  this.getThreshold = function() {
    var threshold = parseFloat($(this.getDivWrap()).attr("data-ctat-threshold"));
    return isNaN(threshold) ? .95 : threshold;
  };
  this.setThreshold = function(threshold) {
    $(this.getDivWrap()).attr("data-ctat-threshold", threshold);
  };
  var skill_window = null;
  this.init = function init() {
    pointer.ctatdebug("init (" + pointer.getName() + ")");
    pointer.setIsAbstractComponent(true);
    pointer.setInitialized(true);
    skill_window = this.getDivWrap();
    this.setComponent(skill_window);
    this.drawComponent();
    this.component.addEventListener("focus", this.processFocus);
  };
  this.assignSkillSet = function assignSkillSet(aSkillSet) {
    CTATSkillSet.skills = aSkillSet;
    this.drawComponent();
  };
  this.updateSkillSet = function updateSkillSet(aSkillSet) {
    if (!CTATSkillSet.skills) {
      pointer.ctatdebug("Error: updateSkillSet () no initial skill set given, can't update");
      return;
    }
    pointer.ctatdebug("updateSkillSet (" + aSkillSet.getSkillSet().length + ")");
    var internalSkillList = aSkillSet.getSkillSet();
    for (var i = 0;i < internalSkillList.length;i++) {
      var skill = internalSkillList[i];
      pointer.ctatdebug("Updating skill " + skill.getSkillName() + " to level: " + skill.getLevel() + " ...");
      CTATSkillSet.skills.setSkillLevel(skill.getSkillName(), skill.getLevel(), 1);
    }
    this.drawComponent();
  };
  this.drawComponent = function drawComponent() {
    pointer.ctatdebug("drawComponent ()");
    if (CTATSkillSet.skills === null) {
      ctatdebug("Info: no skillSet object available, bumping out");
      return;
    }
    var skillList = CTATSkillSet.skills.getSkillSet();
    if (skillList === null) {
      pointer.ctatdebug("Error: list of skills is null in skills object");
      return;
    }
    if (skillList.length <= 0) {
      pointer.ctatdebug("Error: list of skills is 0 length");
      return;
    }
    var fragment = document.createDocumentFragment();
    var spThreshold = this.getThreshold();
    for (var i = 0;i < skillList.length;i++) {
      var skill = skillList[i];
      pointer.ctatdebug("Drawing skill " + i + " " + skill.getDisplayName() + " level: " + skill.getLevel() + " ...");
      var skill_line = document.createElement("div");
      skill_line.classList.add("CTATSkillWindow--skill");
      var sbar = document.createElement("div");
      sbar.classList.add("CTATSkillWindow--bar");
      var mbar = document.createElement("div");
      var slvl = skill.getLevel();
      if (slvl < spThreshold) {
        mbar.classList.add("CTATSkillWindow--bar--nonmastered");
      } else {
        mbar.classList.add("CTATSkillWindow--bar--mastery");
      }
      mbar.style.width = slvl > spThreshold ? "100%" : slvl * 100 + "%";
      sbar.appendChild(mbar);
      skill_line.appendChild(sbar);
      fragment.appendChild(skill_line);
      var sbar_label = document.createElement("div");
      sbar_label.textContent = skill.getDisplayName() || "no-name";
      sbar_label.classList.add("CTATSkillWindow--label");
      skill_line.appendChild(sbar_label);
    }
    skill_window.innerHTML = "";
    skill_window.appendChild(fragment);
  };
};
CTATSkillWindow.prototype = Object.create(CTAT.Component.Base.Graphical.prototype);
CTATSkillWindow.prototype.constructor = CTATSkillWindow;
CTAT.ComponentRegistry.addComponentType("CTATSkillWindow", CTATSkillWindow);
goog.provide("CTATSubmitButton");
goog.require("CTATButton");
goog.require("CTAT.Component.Base.Tutorable");
goog.require("CTAT.ComponentRegistry");
goog.require("CTATGlobalFunctions");
goog.require("CTATGlobals");
goog.require("CTATSAI");
CTATSubmitButton = function(aDescription, aX, aY, aWidth, aHeight) {
  CTATButton.call(this, aDescription, aX, aY, aWidth, aHeight);
  this.setClassName("CTATSubmitButton");
  var previewMode = CTATConfiguration.get("previewMode");
  var pointer = this;
  this.setParameterHandler("target_components", function(slist) {
    this.getDivWrap().setAttribute("data-ctat-target", slist);
    return this;
  });
  var super_init = this.init;
  this.init = function() {
    super_init();
    this.setParameter("tutorComponent", CTAT.Component.Base.Tutorable.Options.DO_NOT_TUTOR);
    this.component.addEventListener("focus", this.processFocus);
  };
  var isTarget = function(aComponent) {
    var targets = pointer.getTargets();
    if (Object.keys(targets).length === 0) {
      return false;
    } else {
      if (aComponent === pointer) {
        return false;
      } else {
        if (aComponent instanceof CTAT.Component.Base.Tutorable) {
          return targets.hasOwnProperty(aComponent.getName()) || targets.hasOwnProperty(aComponent.getComponentGroup());
        } else {
          if (aComponent instanceof CTATSAI) {
            return aComponent.getSelection() != pointer.getName() && targets.hasOwnProperty(aComponent.getSelection());
          } else {
            if (aComponent instanceof String) {
              return aComponent != pointer.getName() && targets.hasOwnProperty(aComponent);
            } else {
              if (aComponent instanceof Element) {
                return aComponent != pointer.getComponent() && (targets.hasOwnProperty(aComponent.id) || targets.hasOwnProperty(aComponent.getAttribute("name")));
              } else {
                return false;
              }
            }
          }
        }
      }
    }
  };
  var event_type = CTAT.Component.Base.Tutorable.EventType;
  document.addEventListener(event_type.correct, function(e) {
    var sai = e.detail.sai;
    if (sai && isTarget(e.detail.component)) {
      if (pointer.isNotGraded()) {
        pointer.setCorrect();
      }
    }
  }, false);
  document.addEventListener(event_type.incorrect, function(e) {
    var sai = e.detail.sai;
    if (sai && isTarget(e.detail.component)) {
      pointer.setIncorrect();
      pointer.setEnabled(true);
    }
  }, false);
  document.addEventListener(event_type.ungrade, function(e) {
    var comp = e.detail.component;
    if (comp && isTarget(comp)) {
      pointer.setNotGraded();
    }
  }, false);
  document.addEventListener(event_type.action, function(e) {
    var comp = e.detail.component;
    if (comp && isTarget(comp) && !e.detail.graded) {
      pointer.setNotGraded();
      pointer.setEnabled(true);
    }
  }, false);
  document.addEventListener(event_type.highlight, function(e) {
    var comp = e.detail.component;
    if (comp && isTarget(comp)) {
      pointer.setHintHighlight(e.detail.isHighlighted);
    }
  }, false);
  this.getTargets = function() {
    var targets = {};
    var div_wrap = this.getDivWrap();
    var target_string = div_wrap.getAttribute("data-ctat-target");
    if (target_string) {
      String(target_string).split(/\s*[;,]\s*/).forEach(function(t) {
        return targets[t.trim()] = 1;
      });
    }
    return targets;
  };
  this.processClick = function(e) {
    if (pointer.getEnabled() === true) {
      var targets = pointer.getTargets();
      for (var targetName in targets) {
        var targetArr = CTATShellTools.findComponent(targetName);
        if (targetArr !== null && targetArr.length > 0) {
          var target = targetArr[0];
          if (target instanceof CTAT.Component.Base.Tutorable) {
            if (target.getEnabled()) {
              target.grade(pointer);
            }
          } else {
            pointer.ctatdebug("Invalid target component: " + target);
          }
        }
      }
    }
  };
};
CTATSubmitButton.prototype = Object.create(CTATButtonBasedComponent.prototype);
CTATSubmitButton.prototype.constructor = CTATSubmitButton;
CTAT.ComponentRegistry.addComponentType("CTATSubmitButton", CTATSubmitButton);
goog.provide("CTATTable");
goog.require("CTAT.Component.Base.Graphical");
goog.require("CTATGlobalFunctions");
goog.require("CTATGlobals");
goog.require("CTATShellTools");
goog.require("CTATTextArea");
goog.require("CTAT.ComponentRegistry");
CTATTable = function(aDescription, aX, aY, aWidth, aHeight) {
  CTAT.Component.Base.Tutorable.call(this, "CTATTable", "__undefined__", aDescription, aX, aY, aWidth, aHeight);
  var pointer = this;
  var cells = [];
  var rows = [];
  var header_row = 0;
  this.get_first_row_is_header = function() {
    return CTATGlobalFunctions.toBoolean($(this.getDivWrap()).attr("data-ctat-has-header"));
  };
  this.set_first_row_is_header = function(aBool) {
    $(this.getDivWrap()).attr("data-ctat-has-header", aBool);
    if (this.get_first_row_is_header()) {
      fix_header();
      header_row = 1;
    } else {
      remove_header();
      header_row = 0;
    }
  };
  this.setParameterHandler("FirstRowIsHeader", this.set_first_row_is_header);
  var get_count = function(attribute) {
    var count = parseInt($(this.getDivWrap()).attr(attribute));
    return isNaN(count) ? 2 : count;
  };
  var get_row_count = get_count.bind(this, "data-ctat-num-rows");
  this.get_row_count = get_row_count;
  this.set_row_count = function(nRows) {
    $(this.getDivWrap()).attr("data-ctat-num-rows", nRows);
  };
  this.setNumRows = function(nRows) {
    var newRows = Number(nRows);
    if (!isNaN(newRows)) {
      while (this.get_row_count() < newRows) {
        this.addRow();
      }
      while (this.get_row_count() > newRows) {
        this.deleteRow();
      }
    }
  };
  var get_col_count = get_count.bind(this, "data-ctat-num-cols");
  this.get_col_count = get_col_count;
  this.set_col_count = function(nCols) {
    $(this.getDivWrap()).attr("data-ctat-num-cols", nCols);
  };
  this.setNumCols = function(nCols) {
    var newCols = Number(nCols);
    if (!isNaN(newCols)) {
      while (this.get_col_count() < newCols) {
        this.addColumn();
      }
      while (this.get_col_count() > newCols) {
        this.deleteColumn();
      }
    }
  };
  this.super_setName = this.setName;
  this.setName = function(aName) {
    this.super_setName(aName);
    if (cells && cells[0]) {
      for (var i = 0;i < cells.length;i++) {
        for (var j = 0;j < cells[0].length;j++) {
          cells[i][j].setAttribute("id", aName + ".R" + i + "C" + j);
        }
      }
    }
  };
  this.init = function init() {
    pointer.ctatdebug("init (" + pointer.getName() + ")");
    pointer.setInitialized(true);
    var divWrap = pointer.getDivWrap();
    pointer.setComponent(divWrap);
    pointer.addComponentReference(pointer, divWrap);
    pointer.render();
    pointer.ctatdebug("table name = " + this.getName());
    this.adjustTableContents();
    if (this.get_first_row_is_header()) {
      fix_header();
      header_row = 1;
    } else {
      header_row = 0;
    }
  };
  this.getConfigurationActions = function() {
    var actions = [];
    var sai;
    var $div = $(this.getDivWrap());
    if ($div.attr("data-ctat-num-rows")) {
      sai = new CTATSAI;
      sai.setSelection(this.getName());
      sai.setAction("setNumRows");
      sai.setInput($div.attr("data-ctat-num-rows"));
      actions.push(sai);
    }
    if ($div.attr("data-ctat-num-cols")) {
      sai = new CTATSAI;
      sai.setSelection(this.getName());
      sai.setAction("setNumCols");
      sai.setInput($div.attr("data-ctat-num-cols"));
      actions.push(sai);
    }
    if ($div.attr("data-ctat-has-header")) {
      sai = new CTATSAI;
      sai.setSelection(this.getName());
      sai.setAction("set_first_row_is_header");
      sai.setInput($div.attr("data-ctat-has-header"));
      actions.push(sai);
    }
    return actions;
  };
  var fix_header = function() {
    pointer.ctatdebug("fix_header()");
    rows[0].classList.add("CTATTable--headers");
    for (var i = 0;i < cells[0].length;i++) {
      cells[0][i].classList.add("CTATTable--header");
    }
  }.bind(this);
  var remove_header = function() {
    pointer.ctatdebug("remove_header()");
    rows[0].classList.remove("CTATTable--headers");
    for (var i = 0;i < cells[0].length;i++) {
      cells[0][i].classList.remove("CTATTable--header");
    }
  }.bind(this);
  this.fixHeader = fix_header;
  this.removeHeader = remove_header;
  var make_cell = function(row, col) {
    var cell = document.createElement("div");
    var compName = this.getName() + ".R" + row + "C" + col;
    cell.id = compName;
    cell.classList.add("CTATTable--cell");
    cell.classList.add("CTATTextArea");
    var ta = new CTATTextArea;
    ta.setName(compName);
    ta.setDivWrapper(cell);
    var idx = this.getTabIndex();
    if (idx) {
      ta.setTabIndex(idx);
    }
    ta.processAttributes();
    ta.init(true);
    ta.processTabOrder();
    ta.setEnabled(this.getEnabled());
    $(cell).data("CTATComponent", ta);
    return cell;
  }.bind(this);
  this.addRow = function() {
    var rowdiv = document.createElement("div");
    rowdiv.classList.add("CTATTable--row");
    var row = get_row_count();
    var rowInt = parseInt(row, 10);
    cells[row] = [];
    for (var col = 0;col < get_col_count();col++) {
      var cell = make_cell(row, col);
      cells[row].push(cell);
      rowdiv.appendChild(cell);
    }
    $(this.getDivWrap()).append(rowdiv);
    rows.push(rowdiv);
    this.set_row_count(row + 1);
  };
  this.deleteRow = function() {
    var divWrap = this.getDivWrap();
    divWrap.removeChild(divWrap.lastChild);
    rows.pop();
    cells.pop();
    this.set_row_count(this.get_row_count() - 1);
  };
  this.addColumn = function() {
    var col = get_col_count();
    var row = 0;
    rows.forEach(function(thisRow) {
      var cell = make_cell(row, col);
      cells[row].push(cell);
      if (row < header_row) {
        cell.classList.add("CTATTable--header");
      }
      thisRow.appendChild(cell);
      row++;
    });
    this.set_col_count(col + 1);
  };
  this.deleteColumn = function() {
    var divWrap = this.getDivWrap();
    var numRows = rows.length;
    for (var i = 0;i < numRows;i++) {
      rows[i].removeChild(rows[i].lastChild);
      cells[i].pop();
    }
    this.set_col_count(this.get_col_count() - 1);
  };
  this.adjustTableContents = function adjustTableContents() {
    pointer.ctatdebug("adjustTableContents()");
    var rowCnt = get_row_count();
    for (var row = 0;row < rowCnt;row++) {
      var rowdiv = document.createElement("div");
      rowdiv.classList.add("CTATTable--row");
      $(this.getDivWrap()).append(rowdiv);
      rows.push(rowdiv);
      for (var col = 0;col < get_col_count();col++) {
        var compName = pointer.getName() + ".R" + row + "C" + col;
        var comp = CTATShellTools.findComponent(compName);
        var compElement;
        if (!comp || comp.length === 0 || comp[0].getName() !== compName) {
          compElement = make_cell(row, col);
          rowdiv.appendChild(compElement);
        } else {
          compElement = comp[0].getDivWrap();
          compElement.classList.add("CTATTable--cell");
          rowdiv.appendChild(compElement);
        }
        if (!cells[row]) {
          cells[row] = [];
        }
        cells[row].push(compElement);
      }
    }
  };
};
CTATTable.prototype = Object.create(CTAT.Component.Base.Graphical.prototype);
CTATTable.prototype.constructor = CTATTable;
CTAT.ComponentRegistry.addComponentType("CTATTable", CTATTable);
goog.provide("CTATTextField");
goog.require("CTATGlobalFunctions");
goog.require("CTATGlobals");
goog.require("CTATTextBasedComponent");
CTATTextField = function(aDescription, aX, aY, aWidth, aHeight) {
  CTATTextBasedComponent.call(this, "CTATTextBasedComponent", "__undefined__", aDescription, aX, aY, aWidth, aHeight);
  var pointer = this;
  var textfield = null;
  var startMarker, endMarker;
  var currRange = null;
  var isDragging = true;
  var activeSelection = null;
  this.setAction("UpdateTextArea");
  this.init = function init() {
    textfield = this.getDivWrap();
    pointer.setComponent(textfield);
    if (this.getText()) {
      textfield.innerHTML = pointer.getText();
    }
    var selectable = textfield.getAttribute("data-ctat-selectable");
    if (selectable && selectable.toLowerCase() == "true") {
      initMarkers();
    }
    pointer.setInitialized(true);
    pointer.addComponentReference(pointer, textfield);
    pointer.setEditable(false);
    var isEnabled = textfield.getAttribute("data-ctat-enabled");
    isEnabled = isEnabled && isEnabled.toLowerCase() == "true";
    pointer.setEnabled(isEnabled);
    pointer.render();
    pointer.addSafeEventListener("focus", pointer.processFocus, textfield);
  };
  var super_setEnabled = this.setEnabled.bind(this);
  this.setEnabled = function(e) {
    super_setEnabled(e);
    pointer.setEditable(false);
  };
  var initMarkers = function() {
    [startMarker, endMarker].forEach(function(m, idx) {
      var marker = document.createElement("span"), handle = document.createElement("div"), isStart = idx == 0;
      marker.className = "ctattextfield-marker";
      marker.id = isStart ? "start-marker" : "end-marker";
      handle.className = "handle";
      marker.appendChild(handle);
      if (isStart) {
        handle.className += " start-handle";
        startMarker = marker;
      } else {
        handle.className += " end-handle";
        endMarker = marker;
      }
      marker.addEventListener("click", function(e) {
        e.stopPropagation();
      });
      marker.addEventListener("mouseup", function(e) {
        e.stopPropagation();
      });
    });
    pointer.addSafeEventListener("mouseup", processMouseup, textfield);
  };
  var handleDrag = function(isStart, e) {
    var marker = isStart ? startMarker : endMarker;
    if (!isDragging) {
      marker.parentNode.removeChild(marker);
      document.getElementById("container").appendChild(marker);
      isDragging = true;
    }
    marker.style.top = e.clientY + window.pageYOffset + "px";
    marker.style.left = e.clientX + window.pageXOffset + "px";
  };
  var handleDragend = function(isStart, e) {
    var dragData = getEventOffset(e);
    var newRange = new Range;
    var marker = isStart ? startMarker : endMarker;
    if (isStart) {
      newRange.setStart(dragData.offsetNode, dragData.offset);
      newRange.setEnd(currRange.endContainer, currRange.endOffset);
    } else {
      newRange.setStart(currRange.startContainer, currRange.startOffset);
      newRange.setEnd(dragData.offsetNode, dragData.offset);
    }
    marker.style.top = "auto";
    marker.style.left = "auto";
    pointer.setSelectionMarkers(newRange);
    isDragging = false;
  };
  var getEventOffset = function(e) {
    var ret = null;
    if (document.caretPositionFromPoint) {
      ret = document.caretPositionFromPoint(e.clientX, e.clientY);
    } else {
      if (document.caretRangeFromPoint) {
        var r = document.caretRangeFromPoint(e.clientX, e.clientY);
        ret = {offset:r.startOffset, offsetNode:r.startContainer};
      }
    }
    return ret;
  };
  var processMouseup = function(e) {
    if (pointer.getEnabled()) {
      var range = null;
      pointer.clearSelectionMarkers();
      if (window.getSelection) {
        var sel = window.getSelection();
        if (sel.getRangeAt) {
          range = sel.getRangeAt(0);
        }
      } else {
        if (document.selection && document.selection.createRange) {
          range = document.selection.createRange();
        }
      }
      if (range && !range.collapsed && textfield.contains(range.startContainer) && range.startContainer == range.endContainer) {
        activeSelection = range.startOffset + "," + range.endOffset;
        pointer.processAction();
        pointer.setSelectionMarkers(range);
      } else {
        activeSelection = "0,0";
        pointer.processAction();
      }
    }
  };
  this.setSelectionMarkers = function(range) {
    var start = range.startOffset, startNode = range.startContainer;
    range.insertNode(startMarker);
    range.collapse(false);
    range.insertNode(endMarker);
  };
  this.clearSelectionMarkers = function() {
    startMarker.parentNode && startMarker.parentNode.removeChild(startMarker);
    endMarker.parentNode && endMarker.parentNode.removeChild(endMarker);
    textfield.normalize();
    activeSelection = null;
  };
  this.getConfigurationActions = function() {
    if (textfield.innerHTML.trim().length > 0) {
      console.log(textfield.innerHTML);
      this.setInput(textfield.innerHTML.toString());
      return [this.getSAI()];
    }
    return [];
  };
  this.setText = function setText(aText) {
    pointer.ctatdebug("setText (" + aText + ")");
    pointer.assignText(aText);
    if (textfield !== null) {
      textfield.innerHTML = aText;
    }
  };
  this.getValue = function() {
    var ret = content = "" + this.getDivWrap().innerHTML;
    if (activeSelection) {
      content = content.replace(/<span.*?class="ctattextfield-marker".*?>.*?<\/span>/g, "");
      ret = activeSelection + ";" + content;
    }
    return ret;
  };
  var super_updateSAI = this.updateSAI.bind(this);
  this.updateSAI = function() {
    if (activeSelection) {
      pointer.setAction("TextSelected");
    } else {
      pointer.setAction("UpdateTextArea");
    }
    super_updateSAI();
  };
  this.setStyleHandler("ShowScrollbars", function(bool) {
    if (CTATGlobalFunctions.toBoolean(bool) === true) {
      pointer.modifyCSSAttribute("overflow", "scroll");
    } else {
      pointer.modifyCSSAttribute("overflow", "hidden");
    }
  });
};
CTATTextField.prototype = Object.create(CTATTextBasedComponent.prototype);
CTATTextField.prototype.constructor = CTATTextField;
CTAT.ComponentRegistry.addComponentType("CTATTextField", CTATTextField);
goog.provide("CTATTextInput");
goog.require("CTATGlobalFunctions");
goog.require("CTATGlobals");
goog.require("CTATSAI");
goog.require("CTATTextBasedComponent");
goog.require("CTAT.ComponentRegistry");
CTATTextInput = function(aDescription, aX, aY, aWidth, aHeight) {
  CTATTextBasedComponent.call(this, "CTATTextInput", "__undefined__", aDescription, aX, aY, aWidth, aHeight);
  var pointer = this;
  var textinput = null;
  var cellContainer = null;
  var previewMode = CTATConfiguration.get("previewMode");
  this.init = function init() {
    this.ctatdebug("init (" + pointer.getName() + ")");
    var $div = $(this.getDivWrap());
    var typeAttr = $div.attr("data-ctat-type");
    textinput = document.createElement("input");
    textinput.type = typeAttr == "number" ? "number" : "text";
    if (aDescription) {
      textinput.name = aDescription.name;
    }
    textinput.setAttribute("maxlength", pointer.getMaxCharacters());
    textinput.setAttribute("id", CTATGlobalFunctions.gensym.div_id());
    pointer.setComponent(textinput);
    this.ctatdebug("Final location: " + pointer.getX() + "," + pointer.getY() + " with text: " + pointer.getText());
    if ($div.attr("value")) {
      this.setText($div.attr("value"));
    }
    var $txt = $(textinput);
    ["autofocus", "defaultValue", "maxLength", "pattern", "placeholder", "readOnly", "size", "title"].forEach(function(attr) {
      var av = $div.attr(attr);
      if (av) {
        $txt.attr(attr, av);
      }
    });
    pointer.setInitialized(true);
    pointer.addComponentReference(pointer, textinput);
    pointer.getDivWrap().appendChild(textinput);
    pointer.addSafeEventListener("keypress", pointer.processKeypress, textinput);
    pointer.addSafeEventListener("focus", pointer.processFocus, textinput);
    $(textinput).on("input", function(e) {
      pointer.setNotGraded();
    });
    if (previewMode) {
      this.addEventScreen(false);
    }
  };
  this.getConfigurationActions = function() {
    var actions = [];
    var $div = $(this.getDivWrap());
    if ($div.attr("value")) {
      var sai = new CTATSAI;
      sai.setSelection(this.getName());
      sai.setAction("UpdateTextField");
      sai.setInput($div.attr("value"));
      actions.push(sai);
    }
    return actions;
  };
  this.setCellContainer = function setCellContainer(aContainer) {
    cellContainer = aContainer;
  };
  this.getCellContainer = function getCellContainer() {
    return cellContainer;
  };
  this.setText = function setText(aText) {
    pointer.ctatdebug("setText (" + aText + ")");
    pointer.assignText(aText);
    textinput.value = aText;
  };
  this.getValue = function() {
    return textinput.value;
  };
  this.reset = function reset() {
    pointer.configFromDescription();
    pointer.processSerialization();
    textinput.value = "";
  };
  this.setStyleHandler("DrawBorder", null);
};
CTATTextInput.prototype = Object.create(CTATTextBasedComponent.prototype);
CTATTextInput.prototype.constructor = CTATTextInput;
CTAT.ComponentRegistry.addComponentType("CTATTextInput", CTATTextInput);
goog.provide("CTATVideo");
goog.require("CTATCommShell");
goog.require("CTATGlobalFunctions");
goog.require("CTAT.Component.Base.Tutorable");
goog.require("CTAT.ComponentRegistry");
CTATVideo = function(aDescription, aX, aY, aWidth, aHeight) {
  CTAT.Component.Base.Tutorable.call(this, "CTATVideo", "__undefined__", aDescription, aX, aY, aWidth, aHeight);
  var alpha = 0;
  var pointer = this;
  var video = null;
  var lastCommand = "";
  this.getAlpha = function getAlpha() {
    return alpha;
  };
  this.setAlpha = function setAlpha(aAlpha) {
    alpha = aAlpha;
  };
  this.ctatdebug(this.getClassName() + " (" + this.getX() + "," + this.getY() + "," + this.getWidth() + "," + this.getHeight() + ")");
  this.setTutorComponent(CTAT.Component.Base.Tutorable.Options.TutorComponent.DO_NOT_TUTOR);
  this.configFromDescription();
  this.init = function init() {
    pointer.ctatdebug("init (" + pointer.getName() + ")");
    pointer.addCSSAttribute("z-index", CTATGlobalFunctions.gensym.z_index());
    video = document.createElement("video");
    if (this.getDivWrap() && $(this.getDivWrap()).attr("src") && !CTATConfiguration.get("previewMode")) {
      video.src = $(this.getDivWrap()).attr("src");
    }
    if (this.getDivWrap() && $(pointer.getDivWrap()).attr("data-ctat-controls")) {
      video.controls = CTATGlobalFunctions.toBoolean($(this.getDivWrap()).attr("data-ctat-controls"));
    } else {
      video.controls = true;
    }
    video.autocontrols = false;
    pointer.ctatdebug("Auto play: " + $(pointer.getDivWrap()).attr("data-ctat-autoplay"));
    if (this.getDivWrap() && $(pointer.getDivWrap()).attr("data-ctat-autoplay")) {
      video.autoplay = CTATGlobalFunctions.toBoolean($(this.getDivWrap()).attr("data-ctat-autoplay"));
    } else {
      video.autoplay = true;
    }
    pointer.setComponent(video);
    video.name = pointer.getName();
    video.setAttribute("id", CTATGlobalFunctions.gensym.div_id());
    video.setAttribute("onkeypress", "return noenter(event)");
    pointer.addComponentReference(pointer, video);
    pointer.ctatdebug("Final location: " + pointer.getX() + "," + pointer.getY() + " with text: " + pointer.getText());
    pointer.setInitialized(true);
    pointer.getDivWrap().appendChild(video);
    pointer.ctatdebug("Resizing component to: " + $(pointer.getDivWrap()).width() + "," + $(pointer.getDivWrap()).height());
    video.addEventListener("focus", this.processFocus);
    video.addEventListener("canplay", function() {
      pointer.ctatdebug("Video loaded and ready for play");
    }, true);
    video.addEventListener("play", function() {
      pointer.ctatdebug("Video loaded and ready for play");
      pointer.logVideoEvent("play");
    }, true);
    video.addEventListener("pause", function() {
      pointer.ctatdebug("Video loaded and ready for play");
      pointer.logVideoEvent("pause");
    }, true);
    pointer.sizeToDiv();
  };
  this.sizeToDiv = function() {
    if (video) {
      video.setAttribute("width", $(pointer.getDivWrap()).width());
      video.setAttribute("height", $(pointer.getDivWrap()).height());
    }
  };
  var super_render = this.render;
  this.render = function() {
    super_render.call(this);
    this.sizeToDiv();
  };
  this.getConfigurationActions = function() {
    var actions = [];
    var sai;
    if ($(pointer.getDivWrap()).attr("data-ctat-controls")) {
      sai = new CTATSAI;
      sai.setSelection(this.getName());
      sai.setAction("showControls");
      sai.setInput($(pointer.getDivWrap()).attr("data-ctat-controls"));
      actions.push(sai);
    }
    if ($(pointer.getDivWrap()).attr("data-ctat-autoplay")) {
      sai = new CTATSAI;
      sai.setSelection(this.getName());
      sai.setAction("setAutoplay");
      sai.setInput($(pointer.getDivWrap()).attr("data-ctat-autoplay"));
      actions.push(sai);
    }
    if ($(this.getDivWrap()).attr("src")) {
      sai = new CTATSAI;
      sai.setSelection(this.getName());
      sai.setAction("setURL");
      sai.setInput($(this.getDivWrap()).attr("src"));
      actions.push(sai);
    }
    return actions;
  };
  this.logVideoEvent = function logVideoEvent(eventName) {
    pointer.ctatdebug("logVideoEvent (" + eventName + ")");
    if (video.duration !== undefined) {
      if (CTATCommShell.commShell !== null) {
        var audioSAI = new CTATSAI(pointer.getName(), eventName, pointer.toHHMMSS(video.currentTime) + ".000", "");
        audioSAI.addSelection(encodeURIComponent(video.currentSrc), "media_file");
        audioSAI.addSelection(pointer.toHHMMSS(video.duration) + ".000", "clip_length");
        var tempInput = audioSAI.getInputObject();
        if (tempInput !== null) {
          tempInput.setType("time");
        }
        CTATCommShell.commShell.processComponentAction(audioSAI, pointer.getTutorComponent(), true, pointer, "VIDEO_ACTION", "USER");
      } else {
        pointer.ctatdebug("Error: commShell is null, can't send untutored tool message");
      }
    } else {
      pointer.ctatdebug("Error: audio file not loaded yet, can't obtain duration");
    }
  };
  this.PlayMedia = function(aURL) {
    video.src = aURL;
    lastCommand = "play";
  };
  this.showControls = function(show) {
    show = CTATGlobalFunctions.toBoolean(show);
    $(pointer.getDivWrap()).attr("data-ctat-controls", show);
    video.controls = show;
  };
  this.setAutoplay = function(play) {
    play = CTATGlobalFunctions.toBoolean(play);
    $(pointer.getDivWrap()).attr("data-ctat-autoplay", play);
    video.autoplay = play;
  };
  this.setURL = function(aURL) {
    $(this.getDivWrap()).attr("src", aURL);
    video.src = aURL;
  };
  this.play = function(playtime) {
    pointer.ctatdebug("play ()");
    var starttime = "0";
    if (playtime) {
      if (typeof playtime === "number") {
        starttime = String(playtime);
      } else {
        if (typeof playtime === "string") {
          starttime = playtime;
        } else {
          starttime = "0";
        }
      }
    }
    video.currentTime = starttime;
    video.play();
    lastCommand = "play";
  };
  this.pause = function(playtime) {
    pointer.ctatdebug("pause ()");
    video.pause();
    var starttime = "0";
    if (playtime) {
      if (typeof playtime === "number") {
        starttime = String(playtime);
      } else {
        if (typeof playtime === "string") {
          starttime = playtime;
        } else {
          starttime = "0";
        }
      }
    }
    video.currentTime = starttime;
    lastCommand = "pause";
  };
  this.stop = function() {
    pointer.ctatdebug("stop ()");
    lastCommand = "stop";
    pointer.pause();
  };
};
CTATVideo.prototype = Object.create(CTAT.Component.Base.Tutorable.prototype);
CTATVideo.prototype.constructor = CTATVideo;
CTAT.ComponentRegistry.addComponentType("CTATVideo", CTATVideo);
goog.provide("CTATAssistments");
goog.require("CTATBase");
var assistmentsTimerVar;
var assistmentsJSONpreface = '{ "version" : "AS.1", "action" : ';
function iframeToParent(message) {
  window.parent.postMessage(message, "https://test1.assistments.org");
}
function iframeLoaded() {
  iframeToParent(assistmentsJSONpreface + '"loaded" }');
  assistmentsTimerVar = window.setInterval("iframeHeartbeat()", 1E4);
}
function iframeHeartbeat() {
  iframeToParent(assistmentsJSONpreface + '"heartbeat"}');
}
function iframeCompleted() {
  var score = document.getElementById("MyScore").value;
  iframeToParent(assistmentsJSONpreface + '"completed", ' + '"answer" : "<b>Student worked hard on this problem.</b>",' + '"score" : ' + score + " }");
  window.clearTimeout(assistmentsTimerVar);
}
;goog.provide("CTATEnabledInPreview");
var ctatEnabledInPreview = {"CTATButton":true, "CTATComboBox":true, "CTATAudioButton":true, "CTATImageButton":true, "CTATSubmitButton":true, "CTATTextArea":true, "CTATTextInput":true, "CTATNumericStepper":true, "CTATTable":true, "CTATHintButton":true, "CTATDoneButton":true};
goog.provide("CTATTutor");
goog.require("CTATAudioButton");
goog.require("CTATButton");
goog.require("CTATChatPanel");
goog.require("CTATCheckBox");
goog.require("CTATComboBox");
goog.require("CTATCommLibrary");
goog.require("CTATCommShell");
goog.require("CTATConfig");
goog.require("CTATConfiguration");
goog.require("CTATDoneButton");
goog.require("CTATDragNDrop");
goog.require("CTATDragSource");
goog.require("CTATElement");
goog.require("CTATFractionBar");
goog.require("CTATFS");
goog.require("CTATGlobalFunctions");
goog.require("CTATGlobals");
goog.require("CTATGroupingComponent");
goog.require("CTATHintButton");
goog.require("CTATHintWindow");
goog.require("CTATHTMLManager");
goog.require("CTATIFrameManager");
goog.require("CTATImageButton");
goog.require("CTATJSON");
goog.require("CTATJumble");
goog.require("CTATMathInput");
goog.require("CTATMobileTutorHandler");
goog.require("CTATMovieClip");
goog.require("CTATNLPInput");
goog.require("CTATNumberLine");
goog.require("CTATNumericStepper");
goog.require("CTATPieChart");
goog.require("CTATRadioButton");
goog.require("CTATSAI");
goog.require("CTATSandboxDriver");
goog.require("CTATScrim");
goog.require("CTATScrollPaneComponent");
goog.require("CTATSkillSet");
goog.require("CTATSkillWindow");
goog.require("CTATSubmitButton");
goog.require("CTATTable");
goog.require("CTATTextArea");
goog.require("CTATTextField");
goog.require("CTATTextInput");
goog.require("CTATVideo");
goog.require("CTATXML");
goog.require("CTATPackage");
goog.require("CTATSequencer");
goog.require("CTATAssistments");
goog.require("CTATEnabledInPreview");
CTATTutor.drawing = false;
CTATTutor.onMobile = false;
CTATTutor.tutorInitialized = false;
CTATTutor.flashVars = null;
Object.defineProperty(CTATTutor, "parser", {get:function() {
  if (!this._parser) {
    if (CTATConfig.parserType_is_XML()) {
      ctatdebug("Creating XML parser ...");
      this._parser = new CTATXML;
    } else {
      if (CTATConfig.parserType_is_JSON()) {
        this._parser = new CTATJSON;
      }
    }
  }
  return this._parser;
}});
CTATTutor.removeComponent = function(aName) {
  var result = [], cList = CTATShellTools.findComponent(aName);
  console.log("CTATTutor.removeComponent(" + aName + ") cList", cList);
  if (!aName || !cList) {
    return result;
  }
  var c = null, cName = null, divWrap = null;
  for (var i = 0;i < cList.length;++i) {
    if (!(c = cList[i])) {
      continue;
    }
    console.log("CTATTutor.removeComponent()[", i, "] ", c.getName && c.getName(), c);
    (c.getComponentList ? c.getComponentList() : []).forEach(function(ch) {
      CTATTutor.removeComponent(ch.getName ? ch.getName() : "");
    });
    if (cName = c.getName && c.getName()) {
      delete CTATShellTools.component_descriptions[cName];
      result.push(cName);
    }
    if (divWrap = c.getDivWrap && c.getDivWrap()) {
      c.setDivWrapper(null);
      $(divWrap).data("CTATComponent", null);
      $(divWrap).remove();
    }
    console.log("CTATTutor.removeComponent()[", i, "] divWrap", divWrap);
  }
  return result;
};
CTATTutor.initializeHTMLComponent = function(divWrap, componentType) {
  var CTATComponentConstructor = CTAT.ComponentRegistry[componentType];
  var ctat_component;
  if (ctat_component = $(divWrap).data("CTATComponent")) {
    return ctat_component;
  }
  ctat_component = new CTATComponentConstructor;
  if ($(divWrap).attr("id")) {
    ctat_component.setName($(divWrap).attr("id"));
  } else {
    divWrap.setAttribute("id", CTATGlobalFunctions.gensym.div_id());
    ctat_component.setName(divWrap.getAttribute("id"));
  }
  ctat_component.setDivWrapper(divWrap);
  ctat_component.processAttributes();
  ctat_component.init();
  ctat_component.processTabOrder();
  ctat_component.setEnabled(ctat_component.getEnabled());
  if (ctat_component.isFeedbackComponent() == false) {
    var compEntry = new CTATComponentDescription;
    compEntry.type = ctat_component.getClassName();
    compEntry.name = ctat_component.getName();
    compEntry.setComponentPointer(ctat_component);
    CTATShellTools.registerComponentDescription(compEntry);
  }
  $(divWrap).data("CTATComponent", ctat_component);
  if (CTATConfiguration.get("previewMode")) {
    var restore = ctat_component.getDivWrap().getAttribute("data-ctat-enabled");
    var isEnabled = ctatEnabledInPreview[ctat_component.getClassName()];
    if (!isEnabled) {
      isEnabled = false;
    }
    ctat_component.setEnabled(isEnabled);
    ctat_component.getDivWrap().setAttribute("data-ctat-enabled", restore);
  }
  return ctat_component;
};
CTATTutor.initializeHTMLComponents = function() {
  for (var CTATComponentType in CTAT.ComponentRegistry) {
    var CTATComponent = CTAT.ComponentRegistry[CTATComponentType];
    $("." + CTATComponentType).each(function() {
      if (!$(this).data("CTATComponent")) {
        CTATTutor.initializeHTMLComponent(this, CTATComponentType);
      }
    });
  }
  CTATShellTools.listComponents();
  ctatdebug("initializeHTMLComponents () done");
};
var CTATComponentMutObserver = new MutationObserver(function(mutations, pointer) {
  mutations.forEach(function(mutation) {
    if (mutation.addedNodes) {
      var CTATClass = null, CTATComponent = null, nodes = mutation.addedNodes, l = nodes.length;
      for (var i = 0;i < l;i++) {
        var addedNode = nodes[i];
        if (addedNode.nodeType === Node.ELEMENT_NODE) {
          addedNode.childNodes && (nodes = Array.prototype.concat.call(nodes, Array.from(addedNode.childNodes)));
          l = nodes.length;
          var CTATClassRegex = /(CTAT[A-z]*)(\s|$)/g;
          while (ctatClass = CTATClassRegex.exec(addedNode.className)) {
            if (CTAT.ComponentRegistry[ctatClass[1]]) {
              CTATComponentMutObserver.disconnect();
              CTATTutor.initializeHTMLComponent(addedNode, ctatClass[1]);
              CTATComponentMutObserver.observe(document.body, {childList:true, subtree:true});
              break;
            }
          }
        }
      }
    }
  });
});
function addMutObserver() {
  console.log("adding ctatcomponent mutation observer");
  CTATComponentMutObserver.observe(document.body, {childList:true, subtree:true});
}
if (document.readyState !== "loading") {
  addMutObserver();
} else {
  document.addEventListener("DOMContentLoaded", addMutObserver);
}
CTATTutor.callComponentFunction = function(componentDiv, func, arg) {
  var componentArr = CTATShellTools.findComponent(componentDiv.id);
  if (componentArr && componentArr.length > 0) {
    var componentObj = componentArr[0];
    var val = null;
    if (func) {
      val = func(componentObj, arg);
    }
    return val;
  }
};
function assignNameTranslator(aTranslator) {
  nameTranslator = aTranslator;
}
CTATTutor.drawTutor = function drawTutor() {
  if (this.drawing === true) {
    return;
  }
  this.drawing = true;
  for (var i in CTATShellTools.component_descriptions) {
    var aDesc = CTATShellTools.component_descriptions[i];
    var component = aDesc.getComponentPointer();
    if (component !== null) {
      component.drawComponent();
    }
  }
  this.drawing = false;
};
CTATTutor.initialize = function initialize() {
  var useragent = navigator.userAgent.toLowerCase();
  if (useragent.search("iphone") > 0) {
    CTATTutor.onMobile = true;
  } else {
    if (useragent.search("ipod") > 0) {
      CTATTutor.onMobile = true;
    } else {
      if (useragent.search("android") > 0) {
        CTATTutor.onMobile = true;
      }
    }
  }
  var isMobile = getSafeElementById("pageor");
  if (isMobile !== null) {
    if (CTATTutor.onMobile === false) {
      isMobile.style.display = "none";
    }
  }
  ctatdebug("initialize ()");
  this.initializeHTMLComponents();
  var raw = flashVars.getRawFlashVars();
  var startConnectedTutor = true;
  if (CTATConfiguration.get("previewMode")) {
    ctatdebug("In preview mode...");
    startConnectedTutor = false;
  }
  if (startConnectedTutor == true) {
    CTATCommShell.commShell = new CTATCommShell;
    CTATCommShell.commShell.init(CTATTutor);
  } else {
    CTATScrim.scrim.scrimDown();
  }
};
CTATTutor.createInterface = function createInterface() {
  ctatdebug("createInterface (" + Object.keys(CTATShellTools.component_descriptions).length + ")");
  if (CTATGlobals.ignoreInterfaceDescriptions == true) {
    ctatdebug("No need to process interface description messages, the interface should already be ready.");
    this.postProcess();
    this.drawTutor();
    return;
  }
  if (CTATGlobals.interfaceElement) {
    ctatdebug("Re-creating interface ...");
    var intProps = CTATTutor.parser.getElementChildren(CTATGlobals.interfaceElement);
    CTATTutor.createStaticInterface(null, intProps, null);
  }
  for (var i in CTATShellTools.component_descriptions) {
    var aDesc = CTATShellTools.component_descriptions[i];
    if (!aDesc) {
      alert("Internal error parsing component at index " + i);
      return;
    }
    if (!aDesc.name) {
      alert("Internal error parsing component at index " + i + " (no name attribute available)");
      return;
    }
    if (aDesc.name.indexOf("null.") == -1) {
      ctatdebug("Component: " + aDesc.name + ", type: " + aDesc.type);
      if (aDesc.type == "CTATCommShell") {
        if (CTATCommShell.commShell) {
          CTATCommShell.commShell.setName(aDesc.name);
        }
        if (aDesc.type == "CTATCommShell") {
          ctatdebug("Tutor dimensions: " + aDesc.width + "x" + aDesc.height);
          var tutorCanvas = getSafeElementById(ctatcontainer);
          if (tutorCanvas !== null) {
            ctatdebug("Setting canvas dimensions from: " + tutorCanvas.width + "px, " + tutorCanvas.height + "px, to: " + aDesc.width + "px, " + aDesc.height + "px");
            tutorCanvas.width = aDesc.width;
            tutorCanvas.height = aDesc.height;
            tutorCanvas.style.width = aDesc.width;
            tutorCanvas.style.height = aDesc.height;
            ctatdebug("Canvas dimensions now: " + tutorCanvas.width + "px, " + tutorCanvas.height + "px");
          } else {
            ctatdebug("Error: tutor canvas is null, can't adjust size");
          }
          var tutorContainer = getSafeElementById(ctatcontainer);
          if (tutorContainer !== null) {
            tutorContainer.style.width = aDesc.width + "px";
            tutorContainer.style.height = aDesc.height + "px";
          } else {
            ctatdebug("Error: tutor container is null, can't adjust size");
          }
        }
      } else {
        if (CTAT.ComponentRegistry.hasOwnProperty(aDesc.type)) {
          ctatdebug("Creating (" + aDesc.type + ") :" + aDesc.name);
          var regComp = new CTAT.ComponentRegistry[aDesc.type](aDesc, aDesc.x, aDesc.y, aDesc.width, aDesc.height);
          regComp.setName(aDesc.name);
          if (aDesc.type == "CTATTextInput" || aDesc.type == "CTATTextArea") {
            regComp.setEnabled(true);
          }
          regComp.setTabIndex(aDesc.tabIndex);
          aDesc.setComponentPointer(regComp);
          regComp.initialize();
          ctatdebug(regComp.getDivWrap());
        } else {
          ctatdebug("ERROR: Unrecognized component type " + aDesc.type + " for " + aDesc.name);
        }
      }
    }
  }
  this.postProcess();
  this.drawTutor();
  ctatdebug("Tutor has been intialized from BRD, recalculating canvas position and size ...");
};
CTATTutor.postProcess = function postProcess() {
  ctatdebug("postProcess ()");
  for (var i in CTATShellTools.component_descriptions) {
    var ref = CTATShellTools.component_descriptions[i];
    var component = ref.getComponentPointer();
    if (component !== null) {
      if (component.getClassName() == "CTATTable") {
      }
      if (component.postProcess) {
        component.postProcess();
      }
    } else {
      ctatdebug("Error: component pointer " + i + " is null");
    }
  }
};
CTATTutor.createStaticInterface = function createStaticInterface(aParent, intProps, aMovieClip) {
  ctatdebug("createStaticInterface ()");
  var parent = getSafeElementById(ctatcontainer);
  if (aParent !== null) {
    parent = aParent;
  }
  for (var t = 0;t < intProps.length;t++) {
    var intNode = intProps[t];
    ctatdebug(this.parser.getElementName(intNode));
    if (this.parser.getElementName(intNode) == "timeline") {
      ctatdebug("Timeline node found, obtaining visual elements ...");
      var interf = this.parser.getElementChildren(intNode);
      this.createStaticInterface(null, interf, null);
      return;
    }
    if (this.parser.getElementName(intNode) == "ctatcomponent") {
      var inst = this.parser.getElementAttr("instance");
      if (aMovieClip) {
        ctatdebug("Registering existence of CTAT component on MovieClip container: " + inst);
        aMovieClip.addComponent(inst);
      }
    }
    var x, y;
    var width, height;
    var instName, descString;
    if (this.parser.getElementName(intNode) == "shape") {
      x = this.parser.getElementAttr(intNode, "x");
      y = this.parser.getElementAttr(intNode, "y");
      width = this.parser.getElementAttr(intNode, "width");
      height = this.parser.getElementAttr(intNode, "height");
      instName = this.parser.getElementAttr(intNode, "instance");
      ctatdebug("Creating shape: " + instName + " at: " + x + "," + y + "," + width + "," + height);
      descString = "data:image/png;base64, " + this.parser.getNodeTextValue(intNode);
      var imgA = new Image;
      imgA.setAttribute("style", "position: absolute; top: " + y + "px; left:" + x + "px; z-index:" + CTATGlobalFunctions.gensym.z_index() + ";");
      imgA.setAttribute("id", instName);
      imgA.setAttribute("src", descString);
      parent.appendChild(imgA);
    }
    if (this.parser.getElementName(intNode) == "statictext") {
      x = this.parser.getElementAttr(intNode, "x");
      y = this.parser.getElementAttr(intNode, "y");
      width = this.parser.getElementAttr(intNode, "width");
      height = this.parser.getElementAttr(intNode, "height");
      instName = this.parser.getElementAttr(intNode, "instance");
      ctatdebug("Creating static text: " + instName + " at: " + x + "," + y + "," + width + "," + height);
      descString = "data:image/png;base64, " + this.parser.getNodeTextValue(intNode);
      var imgB = new Image;
      imgB.setAttribute("style", "position: absolute; top: " + y + "px; left:" + x + "px; z-index:" + CTATGlobalFunctions.gensym.z_index() + ";");
      imgB.setAttribute("id", instName);
      imgB.setAttribute("src", descString);
      parent.appendChild(imgB);
    }
    if (this.parser.getElementName(intNode) == "statictext") {
      instName = this.parser.getElementAttr("instance");
      ctatdebug("Creating movieclip: " + instName);
      var aX = this.parser.getElementAttr(intNode, "x");
      var aY = this.parser.getElementAttr(intNode, "y");
      var aWidth = this.parser.getElementAttr(intNode, "width");
      var aHeight = this.parser.getElementAttr(intNode, "height");
      var aClip = new CTATMovieClip(instName, aX, aY, aWidth, aHeight);
      var newParent = aClip.wrapComponent(parent);
      ctatdebug("Created movieclip: " + instName + " at: " + aClip.x + "," + aClip.y + "," + aClip.width + "," + aClip.height);
      movieclips.push(aClip);
      var subProps = this.parser.getElementChildren(intNode);
      this.createStaticInterface(newParent, subProps, aClip);
    }
  }
};
CTATTutor.runTutor = function() {
  ctatdebug("runTutor ()");
  if (CTATGlobals.tutorRunning === true) {
    ctatdebug("The tutor is already running");
    return;
  }
  if (CTATSkillSet.skills == null) {
    CTATSkillSet.skills = new CTATSkillSet;
  }
  window.onerror = function(errorMsg, url, lineNumber) {
    var formatter = new CTATHTMLManager;
    ctatdebug(formatter.htmlEncode(errorMsg) + " in " + url + ", line " + lineNumber);
    ctatdebug(formatter.htmlEncode(errorMsg) + " in " + url + ", line " + lineNumber);
  };
  centerTutorContainer();
  CTATTutor.initialize();
  CTATGlobals.tutorRunning = true;
  ctatdebug("runTutor () ... all set");
};
var idleTime = 0;
CTATTutor.setIdleTimeout = function() {
  var idleInterval = setInterval(CTATTutor.timerIncrement, 6E4);
  $(document).mousemove(function(e) {
    idleTime = 0;
  });
  $(document).keypress(function(e) {
    idleTime = 0;
  });
};
CTATTutor.timerIncrement = function() {
  if (idleTime < 0) {
    return;
  }
  var tutorTimeout = 19 * 60;
  var session_timeout = CTATConfiguration.get("session_timeout");
  if (session_timeout && !isNaN(session_timeout)) {
    tutorTimeout = parseInt(session_timeout) + 60;
  } else {
    if (!CTATLMS.identifier || parseInt(CTATLMS.identifier) < 0) {
      tutorTimeout = 1E20;
    }
  }
  idleTime = idleTime + 60;
  if (idleTime > tutorTimeout) {
    idleTime = -1;
    CTATScrim.scrim.OKScrimUp("The tutor timed out due to inactivity, click 'Ok' to reload the page.", function() {
      window.location.reload();
    });
  }
};
CTATTutor.initTutor = function(aFlashVars, aDiv, aCanvas, usingFlash) {
  ctatdebug("initTutor() aFlashVars " + typeof aFlashVars + ", usingFlash " + usingFlash);
  if (CTATTutor.tutorInitialized == true) {
    ctatdebug("Tutor already initialized, probably in author mode");
    if (typeof aFlashVars != "undefined" && aFlashVars.previewMode) {
      CTATScrim.scrim.scrimDown();
      ctatdebug("In preview mode...");
    }
    return;
  }
  CTATConfiguration.generateDefaultConfigurationObject(aFlashVars, typeof CTATTarget == "undefined" ? undefined : CTATTarget);
  switch(CTATConfiguration.get("show_debug_traces")) {
    case "true":
    ;
    case "basic":
      useDebuggingBasic = true;
      break;
    case "on":
    ;
    case "full":
      useDebugging = true;
      break;
    case "false":
    ;
    case "off":
      useDebugging = false;
      useDebuggingBasic = false;
      break;
    default:
      useDebuggingBasic = true;
  }
  if (usingFlash == null) {
    usingFlash = CTATConfiguration.usingFlash();
  }
  if (usingFlash) {
    CTATScrim.scrim.scrimDown();
  }
  CTATCommLibrary.setAuthenticityToken(CTATConfiguration.get("authenticity_token"));
  if (aDiv) {
    ctatcontainer = aDiv;
  }
  var el = document.getElementById(ctatcontainer);
  if (el) {
    el.classList.add("CTATTutorContainer");
  }
  var debugtraces = getSafeElementById("debugtraces");
  if (debugtraces !== null) {
    if (debugtraces.checked === true) {
      useDebugging = true;
    } else {
      useDebugging = false;
    }
  }
  ctatdebug("initTutor() CTATConfiguration.get('mode')=" + CTATConfiguration.get("mode") + ", window.sendToTutor=" + window.sendToTutor);
  if (CTATConfiguration.get("swf_name") && !window["sendToTutor"]) {
    window.sendToTutor = function(message) {
      ctatdebug("window.sendToTutor(" + message + ") CTAT.ToolTutor.tutor " + CTAT.ToolTutor.tutor);
      if (CTAT.ToolTutor.tutor) {
        return CTAT.ToolTutor.tutor.receiveFromInterface(message);
      } else {
        return CTAT.ToolTutor.tutorMessages.push(message);
      }
    };
    window.registerInterface = function(msgHandler) {
      CTAT.ToolTutor.registerInterfaceMessageHandler(msgHandler);
    };
  }
  if (String(CTATConfiguration.get("tutoring_service_communication")).toLowerCase() == "javascript") {
    if (typeof CTATExampleTracer == "undefined" || !CTATExampleTracer) {
      var tracerMissingMsg = 'Tutoring service communication parameter is "JavaScript" but class\nCTATExampleTracer is missing. Use a different ctat-*.js script.';
      CTATScrim.scrim.warningScrimUp(tracerMissingMsg);
    } else {
      CTAT.ToolTutor.registerTutor(new CTATExampleTracer);
    }
  }
  ctatdebug("initTutor ()");
  if (CTATConfiguration.get("tutoring_service_communication") == "applet") {
    deployJava.runApplet({id:"TSApplet", width:150, height:10}, {jnlp_href:"/ctat_applet/TSApplet.jnlp"}, "1.6");
  }
  if (!usingFlash) {
    CTATTutor.runTutor();
  }
  CTATTutor.setIdleTimeout();
  CTATTutor.tutorInitialized = true;
  if (document && typeof(document.dispatchEvent == "function")) {
    var dispatch = function(ms) {
      return new Promise(function(resolve) {
        return setTimeout(resolve, ms);
      });
    };
    dispatch(0).then(function() {
      return document.dispatchEvent(new CustomEvent("tutorInitialized", {student_interface:CTATConfiguration.get("student_interface"), question_file:CTATConfiguration.get("question_file")}));
    });
  }
};
if (!window.hasOwnProperty("initTutor")) {
  window["initTutor"] = CTATTutor.initTutor;
}
function receiveFromTutor() {
  ctatdebug("receiveFromTutor ()");
}
function saveAndQuit() {
  ctatdebug("saveAndQuit ()");
}
function prepTutorArea() {
  initTutor();
}
window["prepTutorArea"] = prepTutorArea;
function assignAnonymousGradingProcessor(aFunction) {
  CTATCommShell.commShell.assignAnonymousGradingProcessor(aFunction);
}
function gradeAnonymousComponent(aSelection, anAction, anInput) {
  ctatdebug("gradeAnonymousComponent ()");
  var tsMessage = new CTATSAI(aSelection, anAction, anInput);
  CTATCommShell.commShell.processComponentAction(tsMessage);
}
function testTutor(aVars) {
  ctatdebug("testTutor ()");
  window.onerror = function(errorMsg, url, lineNumber) {
    var formatter = new CTATHTMLManager;
    ctatdebug(formatter.htmlEncode(errorMsg) + " in " + url + ", line " + lineNumber);
  };
  if (CTATSkillSet.skills == null) {
    CTATSkillSet.skills = new CTATSkillSet;
  }
  var connector = new CTATCommLibrary;
  connector.send("http://augustus.pslc.cs.cmu.edu/crossdomain.xml");
}
function centerTutorContainer() {
  ctatdebug("centerTutorContainer ()");
  var tutorContainer = getSafeElementById(ctatcontainer);
  if (tutorContainer == null) {
    ctatdebug("Tutor container not found, bump");
    return;
  }
  var raw = null;
  if (flashVars) {
    raw = flashVars.getRawFlashVars();
  } else {
    ctatdebug("No flashvars yet, bump");
    return;
  }
  var actualWidth = "550";
  var actualHeight = "450";
  actualWidth = tutorContainer.offsetWidth;
  actualHeight = tutorContainer.offsetHeight;
  if (raw) {
    if (raw["width"] && raw["height"]) {
      ctatdebug("We have raw width and height variables in our flashvars: " + raw["width"] + "," + raw["height"]);
      actualWidth = raw["width"];
      actualHeight = raw["height"];
    }
  }
  if (raw["centerTutor"]) {
    if (raw["centerTutor"] == true) {
      var wOffset = Number(actualWidth / 2);
      var hOffset = Number(actualHeight / 2);
      var marginOffset = "-" + wOffset + "px 0 0 -" + hOffset + "px;";
      ctatdebug("Moving tutor over by: " + marginOffset);
      tutorContainer.style.position = "absolute";
      tutorContainer.style.top = "0";
      tutorContainer.style.left = "0";
      tutorContainer.style.right = "0";
      tutorContainer.style.bottom = "0";
      tutorContainer.style.margin = "auto";
    }
  } else {
    ctatdebug("The tutor is not configured to center the container, bump");
  }
}
function checkTutorCanvas() {
  ctatdebug("checkTutorCanvas ()");
  var tutorContainer = getSafeElementById(ctatcontainer);
  var testCanvas = getSafeElementById("main-canvas");
  var raw = flashVars.getRawFlashVars();
  var actualWidth = "550";
  var actualHeight = "450";
  if (tutorContainer) {
    ctatdebug("Recording the actual CSS width and height: " + tutorContainer.offsetWidth + " , " + tutorContainer.offsetHeight);
    actualWidth = tutorContainer.offsetWidth;
    actualHeight = tutorContainer.offsetHeight;
  }
  if (raw) {
    if (raw["width"] && raw["height"]) {
      ctatdebug("We have tutor size flashvars, using those instead: " + raw["width"] + " , " + raw["height"]);
      actualWidth = raw["width"];
      actualHeight = raw["height"];
    }
  }
  if (testCanvas === null) {
    ctatdebug("No canvas available, creating ...");
    testCanvas = document.createElement("canvas");
    testCanvas.id = "main-canvas";
    testCanvas.innerHTML = "Your browser does not support CTAT. Please update or use another browser.";
    ctatdebug("Setting canvas to: 0,0," + actualWidth + " , " + actualHeight);
    var mainContainer = getSafeElementById(ctatcontainer);
    mainContainer.appendChild(testCanvas);
    testCanvas.style.width = actualWidth + "px";
    testCanvas.style.height = actualHeight + "px";
  } else {
    ctatdebug("Setting canvas to: 0 , 0, " + actualWidth + " , " + actualHeight);
    testCanvas.style.top = "0";
    testCanvas.style.left = "0";
    testCanvas.style.width = actualWidth + "px";
    testCanvas.style.height = actualHeight + "px";
  }
  return testCanvas;
}
;goog.provide("CTATNoolsTracerUtil");
goog.require("CTATTutoringServiceMessageBuilder");
goog.require("CTATSAI");
var CTATNoolsTracerUtil = function() {
  var types = {};
  var absUrlRegex = new RegExp("^(?:[a-z]+:/)?/", "i");
  this.setTypes = function(flow, typeNames) {
    console.log("setTypes()");
    typeNames.forEach(function(type) {
      types[type] = flow.getDefined(type);
      if (!types[type]) {
        console.log("couldn't get " + type);
      } else {
        console.log("set type " + type);
      }
    });
  };
  this.getFactType = function(fact) {
    var type = typeof fact;
    if (type === "object") {
      type = null;
      if (fact instanceof Array) {
        type = "Array";
      } else {
        if (fact instanceof RegExp) {
          type = "RegExp";
        } else {
          if (fact instanceof Date) {
            type = "Date";
          } else {
            for (t in types) {
              if (types.hasOwnProperty(t) && types[t] === fact.constructor) {
                type = t;
                break;
              }
            }
          }
        }
      }
    }
    return type;
  };
  this.getTypeConstructor = function(type) {
    return types[type];
  };
  this.relativeToAbsolute = function(rel, base) {
    if (this.isAbsoluteURL(rel)) {
      return rel;
    }
    base = base || window.location.origin + window.location.pathname;
    var stack = base.split("/"), parts = rel.split("/");
    stack.pop();
    for (var i = 0;i < parts.length;i++) {
      if (parts[i] == ".") {
        continue;
      }
      if (parts[i] == "..") {
        stack.pop();
      } else {
        stack.push(parts[i]);
      }
    }
    return stack.join("/");
  };
  this.isAbsoluteURL = function(url) {
    return absUrlRegex.test(url);
  };
  this.buildStartStateMsg = function() {
    var transactionId = 0;
    var tsMsgBuilder = new CTATTutoringServiceMessageBuilder;
    return function(tpaFact) {
      return tsMsgBuilder.createInterfaceActionMessage(transactionId++, new CTATSAI(tpaFact.selection, tpaFact.action, tpaFact.input));
    };
  }();
  this.buildStateGraphMsg = function(configObject) {
    var sgMsg = "<message><verb>SendNoteProperty</verb><properties><MessageType>StateGraph</MessageType>";
    for (var attr in configObject) {
      if (configObject.hasOwnProperty(attr)) {
        sgMsg += "<" + attr + ">" + configObject[attr] + "</" + attr + ">";
      }
    }
    sgMsg += "</properties></message>";
    return sgMsg;
  };
  this.printAgenda = function(session) {
    return JSON.stringify(session.getAgenda());
  };
  this.printConflictTree = function(session, firedOnly) {
    return session.getConflictTree().toString(firedOnly);
  };
  this.printFact = function(session, id, showId) {
    var fact = session.getFact(id);
    var ret = "";
    if (fact) {
      showId && (ret = "id: " + id + ", ");
      ret += "type: " + session.getFactType(fact.object) + ", ";
      var valStr;
      try {
        valStr = "values: " + JSON.stringify(fact.object);
      } catch (e$14) {
        valStr = "< Error converting fact to JSON >";
      }
      ret += valStr;
    } else {
      ret = "no fact found with ID " + id;
    }
    return ret;
  };
  this.getFacts = function(session, optType) {
    var arg2 = optType, facts = [];
    if (Array.isArray(arg2)) {
      for (var $jscomp$iter$0 = $jscomp.makeIterator(arg2), $jscomp$key$type = $jscomp$iter$0.next();!$jscomp$key$type.done;$jscomp$key$type = $jscomp$iter$0.next()) {
        type = $jscomp$key$type.value;
        facts = facts.concat(this.getFacts(session, type));
      }
      return facts;
    } else {
      if (Number.isInteger(optType)) {
        return this.getFact(session, optType);
      } else {
        facts = session.getFacts(optType, true);
      }
    }
    if (!optType) {
      facts = facts.filter(function(fact) {
        var type = session.getFactType(fact.object);
        return !(type === "hint" || type === "tpa" || type === "customfield" || type === "skill");
      });
    }
    return facts.map(function(fact) {
      return fact.object;
    });
  };
  this.getFact = function(session, id) {
    var ret = null, list;
    if (typeof id === "number") {
      ret = session.getFact(id);
      ret && (ret = ret.object);
    } else {
      if (!id || typeof id === "string") {
        list = this.getFacts(session, id);
        list && (ret = list[0]);
      }
    }
    return ret;
  };
  this.printFacts = function(session, optType) {
    var arg2 = optType, factStr = "";
    if (Array.isArray(arg2)) {
      for (var $jscomp$iter$1 = $jscomp.makeIterator(arg2), $jscomp$key$optType = $jscomp$iter$1.next();!$jscomp$key$optType.done;$jscomp$key$optType = $jscomp$iter$1.next()) {
        optType = $jscomp$key$optType.value;
        factStr += Number.isInteger(optType) ? this.printFact(session, optType, true) : this.printFacts(session, optType);
        factStr += "\n";
      }
      return factStr;
    } else {
      if (Number.isInteger(optType)) {
        return this.printFact(session, optType);
      }
    }
    var facts = session.getFacts(optType, true);
    if (!optType) {
      facts = facts.filter(function(fact) {
        var type = session.getFactType(fact.object);
        return !(type === "hint" || type === "tpa" || type === "customfield" || type === "skill");
      });
    }
    factStr = "got " + facts.length + (optType ? " " + optType : "") + " fact(s):\n";
    facts.forEach(function(fact) {
      factStr += "id: " + fact.id + ", " + (optType ? "" : "type: " + session.getFactType(fact.object) + ", ");
      var valStr;
      try {
        valStr = "values: " + JSON.stringify(fact.object) + "\n";
      } catch (e$15) {
        valStr = "< Error converting fact to JSON >\n";
      }
      factStr += valStr;
    });
    return factStr;
  };
  this.printRules = function(session, optSubstr) {
    var ruleList = session.getRuleNames();
    if (optSubstr) {
      ruleList = ruleList.filter(function(rule) {
        return rule.toLowerCase().includes(optSubstr);
      });
    }
    return ruleList.join(", ");
  };
  this.printCtNodeMatch = function(session, nodeId) {
    var match = session.getNodeMatcherResult(nodeId), studentAction, tutorAction, matchStr;
    if (match && match !== "no match") {
      studentAction = match.student, tutorAction = match.tutor;
      matchStr = "rule: " + match.rule + "\n" + "student: " + studentAction.selection + ", " + studentAction.action + ", " + studentAction.input + "\n" + "tutor:   " + tutorAction.selection + ", " + tutorAction.action + ", " + tutorAction.input + "\n" + "result: " + (match.isMatch ? "match" : "no match");
    } else {
      if (match === "no match") {
        matchStr = "No match found at node " + nodeId;
      } else {
        matchStr = "No conflict tree node found for ID " + nodeId;
      }
    }
    return matchStr;
  };
  this.printRuleNodes = function() {
    function processMatch(match) {
      var obj = {};
      match.facts.forEach(function(fact, idx) {
        var alias;
        for (idx = 0;!alias && idx < match.aliases.length;idx++) {
          if (match.factHash[match.aliases[idx]] === fact.object) {
            alias = match.aliases[idx];
          }
        }
        if (alias) {
          obj[alias] = fact;
        } else {
          console.warn("no alias found for " + JSON.stringify(fact));
        }
      });
      return obj;
    }
    function getMemoryBindings(memory, bindings) {
      var match, fBindings = [];
      for (var key in memory) {
        match = memory[key].data.match;
        fBindings.push(processMatch(match));
      }
      return fBindings;
    }
    function getMatchBindings(memory) {
      var matches, match, bindings = [];
      for (var key in memory) {
        matches = memory[key].data.rightMatches;
        for (var fid in matches) {
          match = matches[fid].match;
          bindings.push(processMatch(match));
        }
      }
      return bindings;
    }
    function getFromNodeBindings(memory) {
      var fmEntry, context, bindings = [];
      for (var key in memory) {
        fmEntry = memory[key];
        for (var hashcode in fmEntry) {
          context = fmEntry[hashcode][1];
          if (context.match) {
            bindings.push(processMatch(context.match));
          }
        }
      }
      return bindings;
    }
    function processPattern(pattern, node) {
      var ret = {}, isNot = node.nodeType === "NotNode" || node.nodeType === "FromNotNode";
      switch(node.nodeType) {
        case "BetaNode":
        ;
        case "NotNode":
        ;
        case "ExistsNode":
          ret.factBindings = getMemoryBindings(node.rightMemory);
          break;
        case "JoinNode":
          ret.factBindings = getMatchBindings(node.leftMemory);
          break;
        case "FromNode":
        ;
        case "FromNotNode":
          ret.factBindings = getFromNodeBindings(node.fromMemory);
          break;
        default:
          ret.factBindings = [];
          break;
      }
      ret.isMatch = ret.factBindings.length && !isNot || !ret.factBindings.length && isNot;
      return ret;
    }
    return function(session, ruleName) {
      var ruleMatched = true, data = session.getRuleData(ruleName), msgStr = "";
      if (data) {
        var nodes = data.memoryNodes, patterns = [].concat(data.patterns), aliasCnt = {}, lastD = null, alias, patternRes, bindings, factRegex = /("([^"]*)"):/g;
        try {
          for (var j = 0;j < patterns.length;j++) {
            msgStr += lastD ? "\n\t" : '\npattern: "';
            var pattern = patterns[j];
            if (pattern.disjuncts) {
              msgStr += "or (\n\t";
              lastD = j - 1 + pattern.disjuncts.length;
              patterns.splice.apply(patterns, [].concat([j, 1], $jscomp.arrayFromIterable(pattern.disjuncts)));
              pattern = patterns[j];
            }
            msgStr += pattern.string + (lastD ? "" : '"');
            alias = pattern.alias;
            if (!aliasCnt[alias]) {
              aliasCnt[alias] = 0;
            }
            patternRes = processPattern(pattern, nodes[alias][aliasCnt[alias]++]);
            if (!patternRes.isMatch) {
              msgStr += " NOT";
            }
            msgStr += " MATCHED";
            if ((bindings = patternRes.factBindings).length) {
              msgStr += " - Possible bindings: ";
              bindings.forEach(function(m, i) {
                for (var a in m) {
                  if (a !== "__i__") {
                    var factStr = JSON.stringify(m[a].object), res = null;
                    while (res = factRegex.exec(factStr)) {
                      factStr = factStr.replace(res[1], res[2]);
                    }
                    msgStr += "\n\t" + (lastD ? "\t" : "") + a + ": " + factStr + " (fact ID " + m[a].id + ")";
                  }
                }
                msgStr += "\n";
              });
            }
            if (j === lastD) {
              msgStr += '\n)"';
              lastD = null;
            }
            if (!patternRes.isMatch) {
              ruleMatched = false;
              break;
            }
          }
          return msgStr + "\nRule " + (ruleMatched ? "" : "not ") + "matched";
        } catch (e$16) {
          console.log("got here: " + msgStr);
          throw e$16;
        }
      } else {
        return "Rule " + ruleName + " not found";
      }
    };
  }();
  this.printBreakpoints = function(session) {
    return "breakpoints set for rules: " + session.getBreakpoints().join(", ");
  };
};
goog.provide("CTATNoolsTracerWrapper");
CTATNoolsTracerWrapper = function(tracer) {
  var tracerRef = tracer;
  this.printAgenda = function() {
    tracerRef.printAgenda("override");
  };
  this.printConflictTree = function(firedOnly, inclSAIs) {
    tracerRef.printConflictTree("override", firedOnly, inclSAIs);
  };
  this.printPregenTrees = function(firedOnly, inclSAIs) {
    tracerRef.printPregenTrees("override", firedOnly, inclSAIs);
  };
  this.printTutorSAIs = function(inclRules) {
    tracerRef.printTutorSAIs("override", inclRules);
  };
  this.printFact = function(fId) {
    tracerRef.printFact(fId);
  };
  this.getFact = function(fId) {
    return tracerRef.getFact(fId);
  };
  this.printFacts = function(optType) {
    tracerRef.printFacts(optType);
  };
  this.getFacts = function(optType) {
    return tracerRef.getFacts(optType);
  };
  this.printRules = function(optSubstr) {
    tracerRef.printRules(optSubstr);
  };
  this.printMatch = function(ctNodeId) {
    tracerRef.printCtNodeMatch(ctNodeId);
  };
  this.printRuleNodes = function(ruleName) {
    tracerRef.printRuleNodes(ruleName);
  };
  this.setStepperMode = function(mode) {
    tracerRef.setInStepMode(mode);
  };
  this.takeSteps = function(numSteps, stopOnBacktrack) {
    tracerRef.takeSteps(numSteps, stopOnBacktrack);
  };
  this.setBreakpoint = function(ruleName, everyOrFirst) {
    tracerRef.setBreakpoint(ruleName, everyOrFirst);
  };
  this.printBreakpoints = function() {
    tracerRef.printBreakpoints();
  };
  this.resume = function() {
    tracerRef.resume();
  };
  this.getProblemStateStatus = function() {
    return tracerRef.getProblemStateStatus();
  };
};
goog.provide("CTATAlgebraTreeNode");
(function() {
  var CTATAlgebraTreeNode, slice = [].slice;
  CTATAlgebraTreeNode = function() {
    function CTATAlgebraTreeNode() {
    }
    CTATAlgebraTreeNode.operators = [["UNKNOWN"], ["CONST"], ["VAR"], ["EXP", "ROOT"], ["UPLUS", "UMINUS"], ["ITIMES", "TIMES", "DIVIDE"], ["IDIVIDE", "REM"], ["PLUS", "MINUS"], ["LESS", "LESSEQUAL", "EQUAL", "NOTEQUAL", "GREATEREQUAL", "GREATER"]];
    CTATAlgebraTreeNode.relationalOperators = ["LESS", "LESSEQUAL", "EQUAL", "NOTEQUAL", "GREATEREQUAL", "GREATER"];
    CTATAlgebraTreeNode.operatorPrecedence = function(operator1, operator2) {
      return Math.sign(this.operators.findIndex(function(group) {
        return group.includes(operator1);
      }) - this.operators.findIndex(function(group) {
        return group.includes(operator2);
      }));
    };
    CTATAlgebraTreeNode.operatorStrings = {"EXP":["^", "**"], "ROOT":["|", "\u221a"], "UPLUS":["+"], "UMINUS":["-"], "ITIMES":[""], "TIMES":["*", "\u00d7"], "DIVIDE":["/", "\u00f7"], "IDIVIDE":["//"], "REM":["%"], "PLUS":["+"], "MINUS":["-"], "LESS":["<"], "LESSEQUAL":["<=", "\u2264"], "EQUAL":["=", "=="], "NOTEQUAL":["!=", "/=", "<>", "\u2260"], "GREATEREQUAL":[">=", "\u2265"], "GREATER":[">"]};
    CTATAlgebraTreeNode.toOperatorString = function(operator) {
      var ref;
      return ((ref = this.operatorStrings[operator]) != null ? ref[0] : void 0) || "";
    };
    CTATAlgebraTreeNode.toOperator = function(string, count) {
      var ref;
      return (ref = Object.entries(this.operatorStrings).find(function(_this) {
        return function(pair) {
          return pair[1].includes(string) && (!["UPLUS", "UMINUS"].includes(pair[0]) || count === 1);
        };
      }(this))) != null ? ref[0] : void 0;
    };
    CTATAlgebraTreeNode.diff = function(list1, list2) {
      return list1.filter(function(item) {
        return !list2.includes(item);
      });
    };
    CTATAlgebraTreeNode.prototype.toString = function(string, operator, other) {
      var i, j, ref;
      if (operator == null) {
        operator = "EQUAL";
      }
      if (other == null) {
        other = false;
      }
      for (i = j = 0, ref = this.parens;0 <= ref ? j < ref : j > ref;i = 0 <= ref ? ++j : --j) {
        string = "(" + string + ")";
      }
      if (!this.parented() && this.addParens(null, true)) {
        string = "(" + string + ")";
      }
      if (this.inverted()) {
        string = "1/" + string;
      }
      if (this.negated()) {
        string = "-" + string;
      }
      if (!this.parented() && this.addParens(operator, other)) {
        string = "(" + string + ")";
      }
      return string;
    };
    CTATAlgebraTreeNode.prototype.setParens = function() {
      this.parens++;
      return this;
    };
    CTATAlgebraTreeNode.prototype.addParens = function(operator1, other) {
      var operator2, precedence;
      if (operator1 == null) {
        operator1 = null;
      }
      if (other == null) {
        other = false;
      }
      if (operator1 != null) {
        operator2 = this.negated() ? "UMINUS" : this.inverted() ? "DIVIDE" : this.operator;
      } else {
        operator1 = this.negated() ? "MINUS" : this.inverted() ? "DIVIDE" : null;
        operator2 = this.operator;
      }
      precedence = CTATAlgebraTreeNode.operatorPrecedence(operator1, operator2);
      return operator1 != null && (precedence < 0 || precedence === 0 && other);
    };
    CTATAlgebraTreeNode.prototype.addPaths = function(path) {
      return Object.assign(this, {path:path});
    };
    CTATAlgebraTreeNode.prototype.evaluate = function(value, invert) {
      if (invert == null) {
        invert = true;
      }
      return this.sign * (this.inverted() && invert ? 1 / value : value);
    };
    CTATAlgebraTreeNode.prototype.applyOperator = function(left, right, invert) {
      var operator, result;
      if (invert == null) {
        invert = false;
      }
      operator = invert ? "DIVIDE" : this.operator;
      return result = function() {
        switch(operator) {
          case "LESS":
            return left < right;
          case "GREATER":
            return left > right;
          case "LESSEQUAL":
            return left <= right;
          case "GREATEREQUAL":
            return left >= right;
          case "EQUAL":
            return left === right;
          case "NOTEQUAL":
            return left !== right;
          case "PLUS":
            return left + right;
          case "MINUS":
            return left - right;
          case "TIMES":
          ;
          case "ITIMES":
            return left * right;
          case "DIVIDE":
            return left / right;
          case "EXP":
            return Math.pow(left, right);
          case "ROOT":
            return Math.pow(left, 1 / right);
          case "REM":
            return left % right;
          case "IDIVIDE":
            return Math.floor(left / right);
          case "UPLUS":
            return left;
          case "UMINUS":
            return -left;
        }
      }();
    };
    CTATAlgebraTreeNode.prototype.equals = function(node) {
      return node && this.operator === node.operator && this.sign === node.sign && this.exp === node.exp && this.parens === node.parens;
    };
    CTATAlgebraTreeNode.prototype.subEquals = function(expression, index) {
      return false;
    };
    CTATAlgebraTreeNode.prototype.subNode = function(start, end) {
      return this;
    };
    CTATAlgebraTreeNode.prototype.countOperands = function() {
      return 0;
    };
    CTATAlgebraTreeNode.prototype.getOperator = function(top, index) {
      if (top == null) {
        top = false;
      }
      if (index == null) {
        index = null;
      }
      return top && this.inverted() && "DIVIDE" || top && this.negated() && "UMINUS" || void 0;
    };
    CTATAlgebraTreeNode.prototype.getOperators = function(top) {
      var operator;
      if (top == null) {
        top = false;
      }
      return operator = this.getOperator(top) && [operator] || [];
    };
    CTATAlgebraTreeNode.prototype.getVariables = function() {
      return [];
    };
    CTATAlgebraTreeNode.prototype.getOperands = function() {
      return [];
    };
    CTATAlgebraTreeNode.prototype.getExpression = function(start, end) {
      if (start == null) {
        start = 0;
      }
      if (end == null) {
        end = this.countOperands() - 1;
      }
      return end <= this.countOperands() - 1 && end - start >= 1 && this.subNode(start, end + 1) || null;
    };
    CTATAlgebraTreeNode.prototype.findExpression = function(expression, path, index) {
      var end;
      if (index == null) {
        index = null;
      }
      if (!index && this.equals(expression)) {
        return [Object.assign(this, {path:path})];
      } else {
        if (index != null && this.terms != null && this.subEquals(expression, index)) {
          return [Object.assign(this.subNode(index, end = index + expression.terms.length), {path:path.concat([["terms", index, end]])})];
        } else {
          if (index != null && this.factors != null && this.subEquals(expression, index)) {
            return [Object.assign(this.subNode(index, end = index + expression.factors.length), {path:path.concat([["factors", index, end]])})];
          } else {
            return [];
          }
        }
      }
    };
    CTATAlgebraTreeNode.prototype.createExpression = function() {
      var expressions, operator, ref;
      operator = arguments[0], expressions = 2 <= arguments.length ? slice.call(arguments, 1) : [];
      return ((ref = function() {
        switch(operator = CTATAlgebraTreeNode.toOperator(operator, expressions.length + 1) || operator) {
          case "LESS":
          ;
          case "LESSEQUAL":
          ;
          case "EQUAL":
          ;
          case "NOTEQUAL":
          ;
          case "GREATEREQUAL":
          ;
          case "GREATER":
            return expressions[0] && new CTATRelationNode(operator, this, expressions[0]) || null;
          case "PLUS":
          ;
          case "MINUS":
            return expressions.unshift(this) > 1 && new CTATAdditionNode(operator, expressions) || null;
          case "UPLUS":
          ;
          case "UMINUS":
            return new CTATUnaryNode(operator, this);
          case "TIMES":
          ;
          case "DIVIDE":
            return expressions.unshift(this) > 1 && new CTATMultiplicationNode(operator, expressions) || null;
          case "IDIVIDE":
          ;
          case "REM":
            return expressions[0] && new CTATIntDivisionNode(operator, this, expressions[0]) || null;
          case "EXP":
            return expressions[0] && new CTATPowerNode(operator, this, expressions[0]) || null;
          case "ROOT":
            return new CTATPowerNode(operator, this, new CTATConstantNode(2));
        }
      }.call(this)) != null ? ref.simpleFlatten() : void 0) || null;
    };
    CTATAlgebraTreeNode.prototype.replaceExpression = function(oldSubexpression, newSubexpression, locator) {
      var expression, ref, ref1, ref2, selector;
      if (typeof locator === "number" && (oldSubexpression = this.findExpression(oldSubexpression, [])[locator])) {
        locator = oldSubexpression.path;
        delete oldSubexpression.path;
      }
      if ((locator != null ? locator.length : void 0) === 0) {
        return newSubexpression;
      } else {
        if ((selector = locator != null ? locator.shift() : void 0) != null) {
          expression = this.clone(false);
          if (typeof selector === "string") {
            expression[selector] = (ref = this[selector]) != null ? ref.replaceExpression(oldSubexpression, newSubexpression, locator) : void 0;
            return expression.simpleFlatten();
          } else {
            if (typeof selector === "object" && selector.length === 2) {
              expression[selector[0]] = expression[selector[0]].slice(0);
              expression[selector[0]][selector[1]] = (ref1 = this[selector[0]]) != null ? ref1[selector[1]].replaceExpression(oldSubexpression, newSubexpression, locator) : void 0;
              return expression.simpleFlatten();
            } else {
              if (typeof selector === "object" && selector.length === 3) {
                expression[selector[0]] = expression[selector[0]].slice(0);
                [].splice.apply(expression[selector[0]], [ref2 = selector[1], selector[2] - ref2].concat(newSubexpression)), newSubexpression;
                return expression.simpleFlatten();
              } else {
                return this;
              }
            }
          }
        }
      }
    };
    CTATAlgebraTreeNode.prototype.deleteExpression = function(subexpression, locator) {
      var expression, ref, ref1, ref2, selector;
      if (typeof locator === "number" && (subexpression = this.findExpression(subexpression, [])[locator])) {
        locator = subexpression.path;
        delete subexpression.path;
      }
      if ((locator != null ? locator.length : void 0) === 0) {
        return null;
      } else {
        if ((selector = locator != null ? locator.shift() : void 0) != null) {
          expression = this.clone(false);
          if (typeof selector === "string") {
            expression[selector] = (ref = this[selector]) != null ? ref.deleteExpression(subexpression, locator) : void 0;
            return expression.removeNull();
          } else {
            if (typeof selector === "object" && selector.length === 2) {
              expression[selector[0]] = expression[selector[0]].slice(0);
              expression[selector[0]][selector[1]] = (ref1 = this[selector[0]]) != null ? ref1[selector[1]].deleteExpression(subexpression, locator) : void 0;
              return expression.removeNull();
            } else {
              if (typeof selector === "object" && selector.length === 3) {
                expression[selector[0]] = expression[selector[0]].slice(0);
                [].splice.apply(expression[selector[0]], [ref2 = selector[1], selector[2] - ref2].concat(null)), null;
                return expression.removeNull();
              } else {
                return this;
              }
            }
          }
        }
      }
    };
    CTATAlgebraTreeNode.prototype.applyRulesSelectively = function() {
      var global, index, indices, result, rules, subnode;
      rules = arguments[0], global = arguments[1], index = arguments[2], indices = 4 <= arguments.length ? slice.call(arguments, 3) : [];
      this.rules = rules;
      if (global == null) {
        global = true;
      }
      if (index == null) {
        index = null;
      }
      return this.checkIndices(indices.concat(index)) && (!["PLUS", "TIMES"].includes(this.operator) || this.wholeNode(index, indices) ? this.applyRules(this.rules, global) : (subnode = this.selectOperands(indices.concat(index))) && subnode.equals(result = subnode.applyRules(this.rules, global)) ? this : this.replaceOperands(result, index, indices)) || null;
    };
    CTATAlgebraTreeNode.prototype.applyRules = function(rules, global) {
      var j, len, ref, result, rule;
      this.rules = rules;
      if (global == null) {
        global = true;
      }
      result = this;
      ref = this.rules;
      for (j = 0, len = ref.length;j < len;j++) {
        rule = ref[j];
        result = result[rule].call(result);
        result.rules = this.rules;
      }
      delete result.rules;
      return result;
    };
    CTATAlgebraTreeNode.prototype.removeNull = function() {
      return this;
    };
    CTATAlgebraTreeNode.prototype.checkIndices = function(indices) {
      return indices.every(function(index, position) {
        return index == null || 0 <= index && index <= 1 && indices.indexOf(index) === position;
      });
    };
    CTATAlgebraTreeNode.prototype.wholeNode = function(index, indices) {
      return index == null || indices.length === 0 || indices.concat(index).length >= this.countOperands();
    };
    CTATAlgebraTreeNode.prototype.selectOperands = function(index, indices) {
      return this;
    };
    CTATAlgebraTreeNode.prototype.replaceOperands = function(expression, index, indices) {
      return expression;
    };
    CTATAlgebraTreeNode.prototype.simpleFlatten = function() {
      return this;
    };
    CTATAlgebraTreeNode.prototype.flatten = function() {
      this.parens = 0;
      return this.simpleFlatten();
    };
    CTATAlgebraTreeNode.prototype.computeConstants = function() {
      return this;
    };
    CTATAlgebraTreeNode.prototype.combineSimilar = function() {
      return this;
    };
    CTATAlgebraTreeNode.prototype.expand = function() {
      return this;
    };
    CTATAlgebraTreeNode.prototype.distribute = function() {
      return this;
    };
    CTATAlgebraTreeNode.prototype.removeIdentity = function() {
      return this;
    };
    CTATAlgebraTreeNode.prototype.sort = function() {
      return this;
    };
    CTATAlgebraTreeNode.prototype.spreadIdentity = function() {
      return this;
    };
    CTATAlgebraTreeNode.prototype.stripIdentity = function() {
      return this;
    };
    CTATAlgebraTreeNode.prototype.multiplyOne = function(marked) {
      if (marked == null) {
        marked = false;
      }
      return (new CTATMultiplicationNode("TIMES", [new CTATConstantNode(1, marked), this])).popNegation().pushNegation();
    };
    CTATAlgebraTreeNode.prototype.powerOne = function(marked) {
      if (marked == null) {
        marked = false;
      }
      return (new CTATPowerNode("EXP", this, new CTATConstantNode(1, marked))).popInversion().pushInversion().popNegation();
    };
    CTATAlgebraTreeNode.prototype.findGroup = function(groups, pair) {
      return groups.find(function(group) {
        var ref, ref1;
        return ((ref = group[0]) != null ? ref.equals(pair[0]) : void 0) || group[0] === (ref1 = pair[0]) && ref1 === null;
      });
    };
    CTATAlgebraTreeNode.prototype.compareFactors = function(node, reverse) {
      return this.compareSigns(node, !reverse) || this.compare(node, reverse);
    };
    CTATAlgebraTreeNode.prototype.compare = function(node, reverse) {
      return CTATAlgebraTreeNode.operatorPrecedence(this.operator, node.operator);
    };
    CTATAlgebraTreeNode.prototype.compareSigns = function(node, reverse) {
      return (Math.sign(this.sign - node.sign) || Math.sign(this.exp - node.exp)) * (reverse ? -1 : 1);
    };
    CTATAlgebraTreeNode.prototype.countVariables = function() {
      return 0;
    };
    CTATAlgebraTreeNode.prototype.pushNegation = function() {
      return this;
    };
    CTATAlgebraTreeNode.prototype.popNegation = function() {
      return this;
    };
    CTATAlgebraTreeNode.prototype.pushInversion = function() {
      return this;
    };
    CTATAlgebraTreeNode.prototype.popInversion = function() {
      return this;
    };
    CTATAlgebraTreeNode.prototype.negate = function() {
      this.sign = -this.sign;
      return this;
    };
    CTATAlgebraTreeNode.prototype.invert = function() {
      this.exp = -this.exp;
      return this;
    };
    CTATAlgebraTreeNode.prototype.addition = function() {
      return this.operator === "PLUS";
    };
    CTATAlgebraTreeNode.prototype.subtraction = function() {
      return this.operator === "MINUS";
    };
    CTATAlgebraTreeNode.prototype.multiplication = function() {
      return this.operator === "TIMES";
    };
    CTATAlgebraTreeNode.prototype.division = function() {
      return this.operator === "DIVIDE";
    };
    CTATAlgebraTreeNode.prototype.intDivision = function() {
      return this.operator === "IDIVIDE";
    };
    CTATAlgebraTreeNode.prototype.power = function() {
      return this.operator === "EXP";
    };
    CTATAlgebraTreeNode.prototype.root = function() {
      return this.operator === "ROOT";
    };
    CTATAlgebraTreeNode.prototype.negation = function() {
      return this.operator === "UMINUS";
    };
    CTATAlgebraTreeNode.prototype.unary = function() {
      var ref;
      return (ref = this.operator) === "UPLUS" || ref === "UMINUS";
    };
    CTATAlgebraTreeNode.prototype.constant = function(value) {
      return false;
    };
    CTATAlgebraTreeNode.prototype.unknown = function() {
      return false;
    };
    CTATAlgebraTreeNode.prototype.integer = function() {
      return false;
    };
    CTATAlgebraTreeNode.prototype.negated = function() {
      return this.sign < 0;
    };
    CTATAlgebraTreeNode.prototype.inverted = function() {
      return this.exp < 0;
    };
    CTATAlgebraTreeNode.prototype.parented = function() {
      return this.parens > 0;
    };
    CTATAlgebraTreeNode.prototype.even = function() {
      return false;
    };
    return CTATAlgebraTreeNode;
  }();
  if (typeof module !== "undefined" && module !== null) {
    module.exports = CTATAlgebraTreeNode;
  } else {
    this.CTATAlgebraTreeNode = CTATAlgebraTreeNode;
  }
}).call(this);
goog.provide("CTATRelationNode");
goog.require("CTATAlgebraTreeNode");
(function() {
  var CTATRelationNode, extend = function(child, parent) {
    for (var key in parent) {
      if (hasProp.call(parent, key)) {
        child[key] = parent[key];
      }
    }
    function ctor() {
      this.constructor = child;
    }
    ctor.prototype = parent.prototype;
    child.prototype = new ctor;
    child.__super__ = parent.prototype;
    return child;
  }, hasProp = {}.hasOwnProperty;
  CTATRelationNode = function(superClass) {
    extend(CTATRelationNode, superClass);
    function CTATRelationNode(operator1, left, right, parens, sign, exp) {
      this.operator = operator1;
      this.left = left;
      this.right = right;
      this.parens = parens != null ? parens : 0;
      this.sign = sign != null ? sign : 1;
      this.exp = exp != null ? exp : 1;
    }
    CTATRelationNode.prototype.clone = function(deep) {
      if (deep == null) {
        deep = true;
      }
      return new CTATRelationNode(this.operator, deep ? this.left.clone() : this.left, deep ? this.right.clone() : this.right, this.parens, this.sign, this.exp);
    };
    CTATRelationNode.prototype.toString = function(operator, other) {
      if (operator == null) {
        operator = "EQUAL";
      }
      if (other == null) {
        other = false;
      }
      return CTATRelationNode.__super__.toString.call(this, "" + this.left.toString(this.operator) + CTATAlgebraTreeNode.toOperatorString(this.operator) + this.right.toString(this.operator), operator, other);
    };
    CTATRelationNode.prototype.addPaths = function(path) {
      this.left.addPaths(path.concat(["left"]));
      this.right.addPaths(path.concat(["right"]));
      return CTATRelationNode.__super__.addPaths.apply(this, arguments);
    };
    CTATRelationNode.prototype.evaluate = function(bindings) {
      if (bindings == null) {
        bindings = null;
      }
      return this.applyOperator(this.left.evaluate(bindings), this.right.evaluate(bindings));
    };
    CTATRelationNode.prototype.equals = function(node) {
      return CTATRelationNode.__super__.equals.call(this, node) && this.left.equals(node.left) && this.right.equals(node.right);
    };
    CTATRelationNode.prototype.countOperands = function() {
      return 2;
    };
    CTATRelationNode.prototype.getOperator = function(top, index) {
      if (top == null) {
        top = false;
      }
      if (index == null) {
        index = null;
      }
      return this.operator;
    };
    CTATRelationNode.prototype.getOperators = function(top) {
      if (top == null) {
        top = false;
      }
      return this.left.getOperators().concat(this.getOperator(), this.right.getOperators());
    };
    CTATRelationNode.prototype.getVariables = function() {
      return this.left.getVariables().concat(this.right.getVariables());
    };
    CTATRelationNode.prototype.getOperands = function() {
      return [this.left, this.right];
    };
    CTATRelationNode.prototype.findExpression = function(expression, path) {
      return this.left.findExpression(expression, path.concat(["left"])).concat(CTATRelationNode.__super__.findExpression.call(this, expression, path), this.right.findExpression(expression, path.concat(["right"])));
    };
    CTATRelationNode.prototype.applyRules = function(rules, global) {
      this.rules = rules;
      if (global == null) {
        global = true;
      }
      if (global) {
        this.left = this.left.applyRules(this.rules);
        this.right = this.right.applyRules(this.rules);
      }
      return CTATRelationNode.__super__.applyRules.apply(this, arguments);
    };
    CTATRelationNode.prototype.removeNull = function() {
      var ref, ref1;
      this.left = (ref = this.left) != null ? ref.removeNull() : void 0;
      this.right = (ref1 = this.right) != null ? ref1.removeNull() : void 0;
      if (this.left != null && this.right != null) {
        return this;
      } else {
        return this.left || this.right || null;
      }
    };
    CTATRelationNode.prototype.computeConstants = function() {
      if (this.left.constant() && this.right.constant()) {
        return new CTATConstantNode(this.evaluate());
      } else {
        return this;
      }
    };
    CTATRelationNode.prototype.sort = function() {
      var ref, ref1, ref2;
      switch(this.operator) {
        case "GREATER":
          this.operator = "LESS";
          ref = [this.right, this.left], this.left = ref[0], this.right = ref[1];
          break;
        case "GREATEREQUAL":
          this.operator = "LESSEQUAL";
          ref1 = [this.right, this.left], this.left = ref1[0], this.right = ref1[1];
          break;
        case "EQUAL":
        ;
        case "NOTEQUAL":
          if (this.left.compare(this.right) < 0) {
            ref2 = [this.right, this.left], this.left = ref2[0], this.right = ref2[1];
          }
        ;
      }
      return this;
    };
    CTATRelationNode.prototype.countVariables = function() {
      return this.left.countVariables() + this.right.countVariables();
    };
    return CTATRelationNode;
  }(CTATAlgebraTreeNode);
  if (typeof module !== "undefined" && module !== null) {
    module.exports = CTATRelationNode;
  } else {
    this.CTATRelationNode = CTATRelationNode;
  }
}).call(this);
goog.provide("CTATAdditionNode");
goog.require("CTATAlgebraTreeNode");
(function() {
  var CTATAdditionNode, extend = function(child, parent) {
    for (var key in parent) {
      if (hasProp.call(parent, key)) {
        child[key] = parent[key];
      }
    }
    function ctor() {
      this.constructor = child;
    }
    ctor.prototype = parent.prototype;
    child.prototype = new ctor;
    child.__super__ = parent.prototype;
    return child;
  }, hasProp = {}.hasOwnProperty;
  CTATAdditionNode = function(superClass) {
    extend(CTATAdditionNode, superClass);
    function CTATAdditionNode(operator1, terms1, parens, sign, exp) {
      this.operator = operator1;
      this.terms = terms1;
      this.parens = parens != null ? parens : 0;
      this.sign = sign != null ? sign : 1;
      this.exp = exp != null ? exp : 1;
    }
    CTATAdditionNode.prototype.clone = function(deep) {
      if (deep == null) {
        deep = true;
      }
      return new CTATAdditionNode(this.operator, deep ? this.terms.map(function(term) {
        return term.clone();
      }) : this.terms, this.parens, this.sign, this.exp);
    };
    CTATAdditionNode.prototype.toString = function(operator, other) {
      if (operator == null) {
        operator = "EQUAL";
      }
      if (other == null) {
        other = false;
      }
      return CTATAdditionNode.__super__.toString.call(this, this.terms.reduce(function(_this) {
        return function(result, term) {
          var oper;
          oper = result && !term.negated() ? _this.operator : "";
          return "" + result + CTATAlgebraTreeNode.toOperatorString(oper) + term.toString(_this.operator);
        };
      }(this), ""), operator, other);
    };
    CTATAdditionNode.prototype.addPaths = function(path) {
      this.terms.forEach(function(term, index) {
        return term.addPaths(path.concat([["terms", index]]));
      });
      return CTATAdditionNode.__super__.addPaths.apply(this, arguments);
    };
    CTATAdditionNode.prototype.evaluate = function(bindings) {
      if (bindings == null) {
        bindings = null;
      }
      return CTATAdditionNode.__super__.evaluate.call(this, this.terms.reduce(function(_this) {
        return function(result, term) {
          return _this.applyOperator(result, term.evaluate(bindings));
        };
      }(this), 0));
    };
    CTATAdditionNode.prototype.equals = function(node) {
      return CTATAdditionNode.__super__.equals.call(this, node) && this.terms.length === node.terms.length && this.terms.every(function(term, index) {
        return term.equals(node.terms[index]);
      });
    };
    CTATAdditionNode.prototype.subEquals = function(node, start) {
      return this.operator === node.operator && !node.negated() && this.terms.length >= node.terms.length && node.terms.every(function(_this) {
        return function(term, index) {
          return term.equals(_this.terms[start + index]);
        };
      }(this));
    };
    CTATAdditionNode.prototype.subNode = function(start, end) {
      console.log(start, end);
      if (start != null) {
        return Object.assign(this.clone(false), {terms:this.terms.slice(start, end)});
      } else {
        return this;
      }
    };
    CTATAdditionNode.prototype.countOperands = function() {
      return this.terms.length;
    };
    CTATAdditionNode.prototype.getOperator = function(top, index) {
      if (top == null) {
        top = false;
      }
      if (index == null) {
        index = null;
      }
      return top && CTATAdditionNode.__super__.getOperator.apply(this, arguments) || index != null && this.terms[index].negated() && "MINUS" || this.operator;
    };
    CTATAdditionNode.prototype.getOperators = function(top) {
      if (top == null) {
        top = false;
      }
      return this.terms.slice(1).reduce(function(_this) {
        return function(result, term, index) {
          return result.concat(_this.getOperator(top, index + 1), term.getOperators());
        };
      }(this), this.terms[0].getOperators());
    };
    CTATAdditionNode.prototype.getVariables = function() {
      return this.terms.slice(1).reduce(function(_this) {
        return function(result, term) {
          return result.concat(term.getVariables());
        };
      }(this), this.terms[0].getVariables());
    };
    CTATAdditionNode.prototype.getOperands = function() {
      return this.terms.slice(0);
    };
    CTATAdditionNode.prototype.findExpression = function(expression, path) {
      return this.terms.slice(1).reduce(function(_this) {
        return function(result, term, index) {
          return result.concat(CTATAdditionNode.__super__.findExpression.call(_this, expression, path, index), term.findExpression(expression, path.concat([["terms", index + 1]])));
        };
      }(this), this.terms[0].findExpression(expression, path.concat([["terms", 0]])));
    };
    CTATAdditionNode.prototype.applyRules = function(rules, global) {
      this.rules = rules;
      if (global == null) {
        global = true;
      }
      if (global) {
        this.terms = this.terms.map(function(_this) {
          return function(term) {
            return term.applyRules(_this.rules);
          };
        }(this));
      }
      return CTATAdditionNode.__super__.applyRules.apply(this, arguments);
    };
    CTATAdditionNode.prototype.removeNull = function() {
      this.terms = this.terms.map(function(term) {
        return term != null ? term.removeNull() : void 0;
      }).filter(function(term) {
        return term;
      });
      if (this.terms.length > 1) {
        return this;
      } else {
        return this.terms[0] || null;
      }
    };
    CTATAdditionNode.prototype.checkIndices = function(indices) {
      var length;
      length = this.terms.length;
      return indices.every(function(index, position) {
        return index == null || 0 <= index && index < length && indices.indexOf(index) === position;
      });
    };
    CTATAdditionNode.prototype.selectOperands = function(indices) {
      return Object.assign(this.clone(false), {terms:this.terms.filter(function(_, index) {
        return indices.includes(index);
      })});
    };
    CTATAdditionNode.prototype.replaceOperands = function(expression, index, indices) {
      var ref, result;
      (result = this.clone(false)).terms = this.terms.slice(0);
      [].splice.apply(result.terms, [index, index - index + 1].concat(ref = expression.operator === "PLUS" ? expression.terms : expression)), ref;
      indices.forEach(function(index) {
        var ref1;
        return [].splice.apply(result.terms, [index, index - index + 1].concat(ref1 = [])), ref1;
      });
      return result;
    };
    CTATAdditionNode.prototype.simpleFlatten = function() {
      if (this.terms[0].negation() && !this.terms[0].inverted() && !this.terms[0].parented()) {
        this.terms[0] = this.terms[0].base.negate();
      }
      if (this.subtraction()) {
        this.terms[1].negate();
        this.operator = "PLUS";
      }
      this.terms = this.terms.reduce(function(result, term) {
        if (term.inverted() || term.parented() || !term.addition()) {
          result.push(term);
        } else {
          result.push.apply(result, term.pushNegation().terms);
        }
        return result;
      }, []);
      return this;
    };
    CTATAdditionNode.prototype.flatten = function() {
      return CTATAdditionNode.__super__.flatten.apply(this, arguments).pushNegation();
    };
    CTATAdditionNode.prototype.computeConstants = function() {
      var constant, constantIndex;
      if ((constantIndex = this.terms.findIndex(function(term) {
        return term.constant();
      })) >= 0) {
        constant = this.terms[constantIndex].evaluate();
        this.terms = this.terms.filter(function(term, index) {
          return index <= constantIndex || !term.constant() || (constant += term.evaluate()) && false;
        });
        if (constant === 0 && this.terms.length > 1) {
          this.terms.splice(constantIndex, 1);
        } else {
          this.terms[constantIndex] = new CTATConstantNode(constant);
        }
      }
      if (this.terms.length > 1) {
        return this;
      } else {
        return this.pushInversion().terms[0];
      }
    };
    CTATAdditionNode.prototype.combineSimilar = function() {
      var groups;
      groups = [];
      this.terms.forEach(function(_this) {
        return function(term) {
          var group, ref, splitPair;
          splitPair = term.constant() ? [null, term] : (term = term.multiplyOne(), [term, term.factors.shift()]);
          if (!((ref = splitPair[0]) != null ? ref.unknown() : void 0) && (group = _this.findGroup(groups, splitPair))) {
            return group[1] += splitPair[1].evaluate();
          } else {
            return groups.push([splitPair[0], splitPair[1].evaluate()]);
          }
        };
      }(this));
      this.terms = groups.reduce(function(result, group) {
        if (group[1] !== 0) {
          group[1] = (new CTATConstantNode(group[1])).popNegation();
          if (!group[0]) {
            result.push(group[1]);
          } else {
            group[0].factors.unshift(group[1]);
            result.push(group[0].removeIdentity());
          }
        }
        return result;
      }, []);
      if (this.terms.length > 1) {
        return this;
      } else {
        if (this.terms.length === 1) {
          return this.pushInversion().terms[0];
        } else {
          this.terms[0] = new CTATConstantNode(0);
          return this.pushInversion().terms[0];
        }
      }
    };
    CTATAdditionNode.prototype.removeIdentity = function(marked) {
      var terms;
      if (marked == null) {
        marked = false;
      }
      terms = this.terms.filter(function(term) {
        return !term.constant(0, marked);
      });
      this.terms = terms.length ? terms : this.terms.slice(0, 1);
      if (this.terms.length > 1) {
        return this.pushNegation();
      } else {
        return this.pushInversion().terms[0];
      }
    };
    CTATAdditionNode.prototype.sort = function() {
      this.spreadIdentity();
      this.terms = this.terms.sort(function(node1, node2) {
        return -node1.compare(node2, true);
      });
      return this.stripIdentity();
    };
    CTATAdditionNode.prototype.spreadIdentity = function() {
      this.terms = this.terms.map(function(term) {
        return term.multiplyOne(true);
      });
      return this;
    };
    CTATAdditionNode.prototype.stripIdentity = function() {
      this.terms = this.terms.map(function(term) {
        return term.removeIdentity(true);
      });
      return this;
    };
    CTATAdditionNode.prototype.compare = function(node, reverse) {
      var value;
      return CTATAdditionNode.__super__.compare.apply(this, arguments) || this.countVariables() - node.countVariables() || (value = null, this.terms.some(function(term, index) {
        return value = term.compare(node.terms[index], reverse);
      }) && value) || this.compareSigns(node, reverse);
    };
    CTATAdditionNode.prototype.countVariables = function() {
      return this.terms.reduce(function(result, term) {
        return result + term.countVariables();
      }, 0);
    };
    CTATAdditionNode.prototype.pushNegation = function() {
      if (this.negated()) {
        this.negate();
        this.terms.forEach(function(term) {
          return term.negate();
        });
      }
      return this;
    };
    CTATAdditionNode.prototype.popNegation = function() {
      if (this.terms[0].negated()) {
        this.negate();
        this.terms.forEach(function(term) {
          return term.negate();
        });
      }
      return this;
    };
    CTATAdditionNode.prototype.pushInversion = function() {
      if (this.inverted()) {
        this.invert();
        this.terms[0].invert();
      }
      return this;
    };
    CTATAdditionNode.prototype.unknown = function() {
      return this.terms.some(function(term) {
        return term.unknown();
      });
    };
    CTATAdditionNode.prototype.even = function() {
      return !this.inverted && this.terms.every(function(term) {
        return term.even();
      });
    };
    return CTATAdditionNode;
  }(CTATAlgebraTreeNode);
  if (typeof module !== "undefined" && module !== null) {
    module.exports = CTATAdditionNode;
  } else {
    this.CTATAdditionNode = CTATAdditionNode;
  }
}).call(this);
goog.provide("CTATMultiplicationNode");
goog.require("CTATAlgebraTreeNode");
(function() {
  var CTATMultiplicationNode, extend = function(child, parent) {
    for (var key in parent) {
      if (hasProp.call(parent, key)) {
        child[key] = parent[key];
      }
    }
    function ctor() {
      this.constructor = child;
    }
    ctor.prototype = parent.prototype;
    child.prototype = new ctor;
    child.__super__ = parent.prototype;
    return child;
  }, hasProp = {}.hasOwnProperty, slice = [].slice;
  CTATMultiplicationNode = function(superClass) {
    extend(CTATMultiplicationNode, superClass);
    function CTATMultiplicationNode(operator1, factors1, parens, sign, exp) {
      this.operator = operator1;
      this.factors = factors1;
      this.parens = parens != null ? parens : 0;
      this.sign = sign != null ? sign : 1;
      this.exp = exp != null ? exp : 1;
    }
    CTATMultiplicationNode.prototype.clone = function(deep) {
      if (deep == null) {
        deep = true;
      }
      return new CTATMultiplicationNode(this.operator, deep ? this.factors.map(function(factor) {
        return factor.clone();
      }) : this.factors, this.parens, this.sign, this.exp);
    };
    CTATMultiplicationNode.prototype.toString = function(operator, other) {
      if (operator == null) {
        operator = "EQUAL";
      }
      if (other == null) {
        other = false;
      }
      return CTATMultiplicationNode.__super__.toString.call(this, this.factors.reduce(function(_this) {
        return function(result, factor) {
          var factorString, oper;
          if (factor.inverted()) {
            factor.invert();
            factorString = factor.toString("DIVIDE", result);
            factor.invert();
          } else {
            factorString = factor.toString(_this.operator, result);
          }
          oper = !result ? "" : factor.inverted() ? "DIVIDE" : _this.operator === "DIVIDE" || /^[\d+-]/.test(factorString) && /\d$/.test(result) ? _this.operator : "";
          return "" + result + CTATAlgebraTreeNode.toOperatorString(oper) + factorString;
        };
      }(this), this.operator === "TIMES" && this.factors[0].inverted() ? "1" : ""), operator, other);
    };
    CTATMultiplicationNode.prototype.addPaths = function(path) {
      this.factors.forEach(function(factor, index) {
        return factor.addPaths(path.concat([["factors", index]]));
      });
      return CTATMultiplicationNode.__super__.addPaths.apply(this, arguments);
    };
    CTATMultiplicationNode.prototype.evaluate = function(bindings) {
      var result;
      if (bindings == null) {
        bindings = null;
      }
      result = this.factors.reduce(function(_this) {
        return function(result, factor) {
          if (factor.inverted()) {
            return result;
          } else {
            return _this.applyOperator(result, factor.evaluate(bindings, false));
          }
        };
      }(this), 1);
      return CTATMultiplicationNode.__super__.evaluate.call(this, this.factors.reduce(function(_this) {
        return function(result, factor) {
          if (factor.inverted()) {
            return _this.applyOperator(result, factor.evaluate(bindings, false), true);
          } else {
            return result;
          }
        };
      }(this), result));
    };
    CTATMultiplicationNode.prototype.equals = function(node) {
      return CTATMultiplicationNode.__super__.equals.call(this, node) && this.factors.length === node.factors.length && this.factors.every(function(factor, index) {
        return factor.equals(node.factors[index]);
      });
    };
    CTATMultiplicationNode.prototype.subEquals = function(node, start) {
      return this.operator === node.operator && !node.inverted() && this.factors.length >= node.factors.length && node.factors.every(function(_this) {
        return function(factor, index) {
          return factor.equals(_this.factors[start + index]);
        };
      }(this));
    };
    CTATMultiplicationNode.prototype.subNode = function(start, end) {
      console.log(start, end);
      if (start != null) {
        return Object.assign(this.clone(false), {factors:this.factors.slice(start, end)});
      } else {
        return this;
      }
    };
    CTATMultiplicationNode.prototype.countOperands = function() {
      return this.factors.length;
    };
    CTATMultiplicationNode.prototype.getOperator = function(top, index) {
      if (top == null) {
        top = false;
      }
      if (index == null) {
        index = null;
      }
      return top && CTATMultiplicationNode.__super__.getOperator.apply(this, arguments) || index != null && this.factors[index].inverted() && "DIVIDE" || this.operator;
    };
    CTATMultiplicationNode.prototype.getOperators = function(top) {
      if (top == null) {
        top = false;
      }
      return this.factors.slice(1).reduce(function(_this) {
        return function(result, factor, index) {
          return result.concat(_this.getOperator(top, index + 1), factor.getOperators());
        };
      }(this), this.factors[0].getOperators());
    };
    CTATMultiplicationNode.prototype.getVariables = function() {
      return this.factors.slice(1).reduce(function(_this) {
        return function(result, factor) {
          return result.concat(factor.getVariables());
        };
      }(this), this.factors[0].getVariables());
    };
    CTATMultiplicationNode.prototype.getOperands = function() {
      return this.factors.slice(0);
    };
    CTATMultiplicationNode.prototype.findExpression = function(expression, path) {
      return this.factors.slice(1).reduce(function(_this) {
        return function(result, factor, index) {
          return result.concat(CTATMultiplicationNode.__super__.findExpression.call(_this, expression, path, index), factor.findExpression(expression, path.concat([["factors", index + 1]])));
        };
      }(this), this.factors[0].findExpression(expression, path.concat([["factors", 0]])));
    };
    CTATMultiplicationNode.prototype.applyRules = function(rules1, global) {
      this.rules = rules1;
      if (global == null) {
        global = true;
      }
      if (global) {
        this.factors = this.factors.map(function(_this) {
          return function(factor) {
            return factor.applyRules(_this.rules);
          };
        }(this));
      }
      return CTATMultiplicationNode.__super__.applyRules.apply(this, arguments);
    };
    CTATMultiplicationNode.prototype.removeNull = function() {
      this.factors = this.factors.map(function(factor) {
        return factor != null ? factor.removeNull() : void 0;
      }).filter(function(factor) {
        return factor;
      });
      if (this.factors.length > 1) {
        return this;
      } else {
        return this.factors[0] || null;
      }
    };
    CTATMultiplicationNode.prototype.checkIndices = function(indices) {
      var length;
      length = this.factors.length;
      return indices.every(function(index, position) {
        return index == null || 0 <= index && index < length && indices.indexOf(index) === position;
      });
    };
    CTATMultiplicationNode.prototype.selectOperands = function(indices) {
      return Object.assign(this.clone(false), {factors:this.factors.filter(function(_, index) {
        return indices.includes(index);
      })});
    };
    CTATMultiplicationNode.prototype.replaceOperands = function(expression, index, indices) {
      var ref, result;
      (result = this.clone(false)).terms = this.factors.slice(0);
      [].splice.apply(result.factors, [index, index - index + 1].concat(ref = expression.operator === "TIMES" ? expression.factors : expression)), ref;
      indices.forEach(function(index) {
        var ref1;
        return [].splice.apply(result.factors, [index, index - index + 1].concat(ref1 = [])), ref1;
      });
      return result;
    };
    CTATMultiplicationNode.prototype.simpleFlatten = function() {
      if (this.division()) {
        this.factors[1].invert();
      }
      this.operator = "TIMES";
      this.factors = this.factors.reduce(function(result, factor) {
        if (factor.parented() || !factor.multiplication()) {
          result.push(factor);
        } else {
          result.push.apply(result, factor.pushNegation().pushInversion().factors);
        }
        return result;
      }, []);
      return this;
    };
    CTATMultiplicationNode.prototype.flatten = function() {
      return CTATMultiplicationNode.__super__.flatten.apply(this, arguments).popNegation();
    };
    CTATMultiplicationNode.prototype.computeConstants = function() {
      var constant, constantIndex, value;
      if ((constantIndex = this.factors.findIndex(function(term) {
        return term.constant();
      })) >= 0) {
        constant = new CTATMultiplicationNode("TIMES", [new CTATConstantNode(1)]);
        this.factors = this.factors.filter(function(factor, index) {
          return index < constantIndex || !factor.constant() || constant.factors.push(factor) && false;
        });
        if ((value = constant.evaluate()) !== 1) {
          this.factors = [new CTATConstantNode(value)].concat(slice.call(this.factors));
        }
      }
      if (this.factors.length > 1) {
        return this;
      } else {
        return this.pushNegation().pushInversion().factors[0];
      }
    };
    CTATMultiplicationNode.prototype.combineSimilar = function() {
      var groups;
      groups = [];
      this.factors.forEach(function(_this) {
        return function(factor) {
          var group, ref, ref1, ref2, splitPair;
          splitPair = factor.constant() ? [null, factor] : !factor.power() ? (factor = factor.powerOne(), [factor.base, factor.exponent]) : factor.exponent.constant() ? (factor.pushInversion(), [factor.base, factor.exponent]) : (factor.exponent = factor.exponent.multiplyOne(), [factor, factor.exponent.factors.shift()]);
          if (!((ref = splitPair[0]) != null ? ref.unknown() : void 0) && (group = _this.findGroup(groups, splitPair))) {
            return group[1] += ((ref1 = splitPair[1]) != null ? ref1.evaluate() : void 0) || 1;
          } else {
            return groups.push([splitPair[0], ((ref2 = splitPair[1]) != null ? ref2.evaluate() : void 0) || 1]);
          }
        };
      }(this));
      this.factors = groups.reduce(function(result, group) {
        if (group[1] !== 0) {
          group[1] = (new CTATConstantNode(group[1])).popNegation();
          if (!group[0]) {
            result.push(group[1]);
          } else {
            if (group[1].constant(1)) {
              result.push(group[0]);
            } else {
              if (group[1].constant(-1)) {
                result.push(group[0].invert());
              } else {
                if (!group[0].power()) {
                  result.push((new CTATPowerNode("EXP", group[0], group[1])).popInversion());
                } else {
                  group[0].exponent.factors.unshift(group[1]);
                  result.push(group[0]);
                }
              }
            }
          }
        }
        return result;
      }, []);
      if (this.factors.length > 1) {
        return this;
      } else {
        if (this.factors.length === 1) {
          return this.pushNegation().pushInversion().factors[0];
        } else {
          this.factors[0] = new CTATConstantNode(1);
          return this.pushNegation().pushInversion().factors[0];
        }
      }
    };
    CTATMultiplicationNode.prototype.distribute = function() {
      var directFactors, directTerms, invertedFactors, invertedTerms;
      directFactors = this.factors.filter(function(factor) {
        return !factor.inverted();
      });
      invertedFactors = this.factors.filter(function(factor) {
        return factor.inverted();
      });
      if (this.distributedOrSingle(directFactors) && this.distributedOrSingle(invertedFactors) && !(this.single(directFactors) && invertedFactors.length && this.distributed(invertedFactors))) {
        return this;
      } else {
        if (this.distributed(invertedFactors)) {
          directTerms = this.distributeFactors(this.factors);
          invertedTerms = [];
        } else {
          if (this.distributed(directFactors)) {
            invertedTerms = this.distributeFactors(this.factors);
            directTerms = [];
          } else {
            directTerms = this.distributeFactors(directFactors);
            invertedTerms = this.distributeFactors(invertedFactors);
          }
        }
        if (!invertedTerms.length) {
          this.factors = [this.packTerms(directTerms)];
        } else {
          if (!directTerms.length) {
            this.factors = [this.packTerms(invertedTerms).invert()];
          } else {
            this.factors = [this.packTerms(directTerms), this.packTerms(invertedTerms).invert()];
          }
        }
        if (this.factors.length > 1) {
          return this;
        } else {
          return this.pushNegation().pushInversion().factors[0];
        }
      }
    };
    CTATMultiplicationNode.prototype.distributedOrSingle = function(factors) {
      return this.distributed(factors) || this.single(factors);
    };
    CTATMultiplicationNode.prototype.distributed = function(factors) {
      return factors.every(function(factor) {
        return !factor.addition();
      });
    };
    CTATMultiplicationNode.prototype.single = function(factors) {
      return factors.length === 1 && factors[0].addition();
    };
    CTATMultiplicationNode.prototype.distributeFactors = function(factors) {
      var terms;
      terms = !factors[0].addition() ? [[factors[0]]] : factors[0].terms.map(function(term) {
        if (!term.multiplication()) {
          return [term];
        } else {
          return term.pushNegation().factors;
        }
      });
      factors.slice(1).forEach(function(newFactor) {
        var ref;
        if (!newFactor.addition()) {
          if (terms.length === 1) {
            if (!newFactor.multiplication()) {
              return terms[0].push(newFactor);
            } else {
              return (ref = terms[0]).push.apply(ref, newFactor.pushNegation().factors);
            }
          } else {
            return terms.forEach(function(term, index) {
              var ref1;
              if (!newFactor.multiplication()) {
                return terms[index].push(newFactor.clone());
              } else {
                return (ref1 = terms[index]).push.apply(ref1, newFactor.pushNegation().factors.map(function(factor) {
                  return factor.clone();
                }));
              }
            });
          }
        } else {
          if (terms.length === 1) {
            return terms = newFactor.terms.map(function(newTerm) {
              var term;
              term = terms[0].map(function(factor) {
                return factor.clone();
              });
              if (!newTerm.multiplication()) {
                term.push(newTerm);
              } else {
                term.push.apply(term, newTerm.pushNegation().factors);
              }
              return term;
            });
          } else {
            return terms = terms.reduce(function(result, term) {
              result.push.apply(result, newFactor.terms.map(function(newTerm) {
                var copyTerm;
                copyTerm = term.map(function(factor) {
                  return factor.clone();
                });
                if (!newTerm.multiplication()) {
                  copyTerm.push(newTerm.clone());
                } else {
                  copyTerm.push.apply(copyTerm, newTerm.pushNegation().factors.map(function(factor) {
                    return factor.clone();
                  }));
                }
                return copyTerm;
              }));
              return result;
            }, []);
          }
        }
      });
      return terms;
    };
    CTATMultiplicationNode.prototype.packTerms = function(terms) {
      var rules;
      rules = CTATAlgebraTreeNode.diff(this.rules, ["flatten", "distribute"]);
      return (new CTATAdditionNode("PLUS", terms.map(function(term) {
        return (new CTATMultiplicationNode("TIMES", term)).popNegation().applyRules(rules, false);
      }))).applyRules(rules, false);
    };
    CTATMultiplicationNode.prototype.removeIdentity = function(marked) {
      var factors, zero;
      if (marked == null) {
        marked = false;
      }
      this.popNegation();
      factors = this.factors.filter(function(factor) {
        return !factor.constant(1, marked);
      });
      this.factors = factors.length ? factors : this.factors.slice(0, 1);
      if ((zero = this.factors.find(function(factor) {
        return factor.constant(0, marked);
      })) && this.factors.every(function(factor) {
        return !factor.inverted() && (!factor.power() || factor.exponent.constant());
      })) {
        this.factors = [zero];
      }
      if (this.factors.length > 1) {
        return this;
      } else {
        return this.pushNegation().pushInversion().factors[0];
      }
    };
    CTATMultiplicationNode.prototype.sort = function() {
      this.factors = this.factors.sort(function(node1, node2) {
        return node1.compareFactors(node2);
      });
      return this;
    };
    CTATMultiplicationNode.prototype.spreadIdentity = function() {
      this.factors = this.factors.map(function(factor) {
        return factor.powerOne(true);
      });
      return this;
    };
    CTATMultiplicationNode.prototype.stripIdentity = function() {
      this.factors = this.factors.map(function(factor) {
        return factor.removeIdentity(true);
      });
      return this.popNegation();
    };
    CTATMultiplicationNode.prototype.multiplyOne = function(marked) {
      if (marked == null) {
        marked = false;
      }
      if (!this.factors[0].constant()) {
        this.factors.unshift(new CTATConstantNode(1, marked));
      }
      return this.pushNegation();
    };
    CTATMultiplicationNode.prototype.compare = function(node, reverse) {
      var nodefactors, value;
      return CTATMultiplicationNode.__super__.compare.apply(this, arguments) || this.countVariables() - node.countVariables() || (value = null, (nodefactors = node.factors.slice(0).reverse()) && this.factors.slice(0).reverse().some(function(factor, index) {
        return value = factor.compareFactors(nodefactors[index], reverse);
      }) && value) || this.compareSigns(node, reverse);
    };
    CTATMultiplicationNode.prototype.countVariables = function() {
      return this.factors.reduce(function(result, factor) {
        return result + factor.countVariables();
      }, 0);
    };
    CTATMultiplicationNode.prototype.pushNegation = function() {
      if (this.negated()) {
        this.negate();
        this.factors[0].negate();
      }
      return this;
    };
    CTATMultiplicationNode.prototype.popNegation = function() {
      this.factors.forEach(function(_this) {
        return function(factor) {
          if (factor.negated()) {
            _this.negate();
            return factor.negate();
          }
        };
      }(this));
      return this;
    };
    CTATMultiplicationNode.prototype.pushInversion = function() {
      if (this.inverted()) {
        this.invert();
        this.factors.forEach(function(factor) {
          return factor.invert();
        });
      }
      return this;
    };
    CTATMultiplicationNode.prototype.unknown = function() {
      return this.factors.some(function(factor) {
        return factor.unknown();
      });
    };
    CTATMultiplicationNode.prototype.even = function() {
      return !this.inverted() && this.factors.every(function(factor) {
        return factor.integer();
      }) && this.factors.some(function(factor) {
        return factor.even();
      });
    };
    return CTATMultiplicationNode;
  }(CTATAlgebraTreeNode);
  if (typeof module !== "undefined" && module !== null) {
    module.exports = CTATMultiplicationNode;
  } else {
    this.CTATMultiplicationNode = CTATMultiplicationNode;
  }
}).call(this);
goog.provide("CTATIntDivisionNode");
goog.require("CTATAlgebraTreeNode");
(function() {
  var CTATIntDivisionNode, extend = function(child, parent) {
    for (var key in parent) {
      if (hasProp.call(parent, key)) {
        child[key] = parent[key];
      }
    }
    function ctor() {
      this.constructor = child;
    }
    ctor.prototype = parent.prototype;
    child.prototype = new ctor;
    child.__super__ = parent.prototype;
    return child;
  }, hasProp = {}.hasOwnProperty;
  CTATIntDivisionNode = function(superClass) {
    extend(CTATIntDivisionNode, superClass);
    function CTATIntDivisionNode(operator1, dividend, divisor1, parens, sign, exp) {
      this.operator = operator1;
      this.dividend = dividend;
      this.divisor = divisor1;
      this.parens = parens != null ? parens : 0;
      this.sign = sign != null ? sign : 1;
      this.exp = exp != null ? exp : 1;
    }
    CTATIntDivisionNode.prototype.clone = function(deep) {
      if (deep == null) {
        deep = true;
      }
      return new CTATIntDivisionNode(this.operator, deep ? this.dividend.clone() : this.dividend, deep ? this.divisor.clone() : this.divisor, this.parens, this.sign, this.exp);
    };
    CTATIntDivisionNode.prototype.toString = function(operator, other) {
      if (operator == null) {
        operator = "EQUAL";
      }
      if (other == null) {
        other = false;
      }
      return CTATIntDivisionNode.__super__.toString.call(this, "" + this.dividend.toString(this.operator) + CTATAlgebraTreeNode.toOperatorString(this.operator) + this.divisor.toString(this.operator), operator, other);
    };
    CTATIntDivisionNode.prototype.addPaths = function(path) {
      this.dividend.addPaths(path.concat(["dividend"]));
      this.divisor.addPaths(path.concat(["divisor"]));
      return CTATIntDivisionNode.__super__.addPaths.apply(this, arguments);
    };
    CTATIntDivisionNode.prototype.evaluate = function(bindings) {
      if (bindings == null) {
        bindings = null;
      }
      return CTATIntDivisionNode.__super__.evaluate.call(this, this.applyOperator(this.dividend.evaluate(bindings), this.divisor.evaluate(bindings)));
    };
    CTATIntDivisionNode.prototype.equals = function(node) {
      return CTATIntDivisionNode.__super__.equals.call(this, node) && this.dividend.equals(node.dividend) && this.divisor.equals(node.divisor);
    };
    CTATIntDivisionNode.prototype.countOperands = function() {
      return 2;
    };
    CTATIntDivisionNode.prototype.getOperator = function(top, index) {
      if (top == null) {
        top = false;
      }
      if (index == null) {
        index = null;
      }
      return top && CTATIntDivisionNode.__super__.getOperator.apply(this, arguments) || this.operator;
    };
    CTATIntDivisionNode.prototype.getOperators = function(top) {
      if (top == null) {
        top = false;
      }
      return this.dividend.getOperators().concat(this.getOperator(top), this.divisor.getOperators());
    };
    CTATIntDivisionNode.prototype.getVariables = function() {
      return this.dividend.getVariables().concat(this.divisor.getVariables());
    };
    CTATIntDivisionNode.prototype.getOperands = function() {
      return [this.dividend, this.divisor];
    };
    CTATIntDivisionNode.prototype.findExpression = function(expression, path) {
      return this.dividend.findExpression(expression, path.concat(["dividend"])).concat(CTATIntDivisionNode.__super__.findExpression.call(this, expression, path), this.divisor.findExpression(expression, path.concat(["divisor"])));
    };
    CTATIntDivisionNode.prototype.applyRules = function(rules, global) {
      this.rules = rules;
      if (global == null) {
        global = true;
      }
      if (global) {
        this.dividend = this.dividend.applyRules(this.rules);
        this.divisor = this.divisor.applyRules(this.rules);
      }
      return CTATIntDivisionNode.__super__.applyRules.apply(this, arguments);
    };
    CTATIntDivisionNode.prototype.removeNull = function() {
      var ref, ref1;
      this.dividend = (ref = this.dividend) != null ? ref.removeNull() : void 0;
      this.divisor = (ref1 = this.divisor) != null ? ref1.removeNull() : void 0;
      if (this.dividend != null && this.divisor != null) {
        return this;
      } else {
        return this.dividend || this.divisor || null;
      }
    };
    CTATIntDivisionNode.prototype.computeConstants = function() {
      if (this.dividend.constant() && this.divisor.constant()) {
        return new CTATConstantNode(this.evaluate());
      } else {
        return this;
      }
    };
    CTATIntDivisionNode.prototype.removeIdentity = function(marked) {
      if (marked == null) {
        marked = false;
      }
      if (this.divisor.constant(1, marked)) {
        if (!this.intDivision()) {
          this.dividend = new CTATConstantNode(0, marked);
        }
        return this.pushNegation().pushInversion().dividend;
      } else {
        return this.popNegation();
      }
    };
    CTATIntDivisionNode.prototype.compare = function(node, reverse) {
      return CTATIntDivisionNode.__super__.compare.apply(this, arguments) || this.dividend.compare(node.dividend, reverse) || this.divisor.compare(node.divisor, reverse) || this.operator !== node.operator && (this.intDivision() && -1 || 1) || this.compareSigns(node, reverse);
    };
    CTATIntDivisionNode.prototype.countVariables = function() {
      return this.dividend.countVariables() + divisor.countVariables();
    };
    CTATIntDivisionNode.prototype.pushNegation = function() {
      if (this.intDivision() && this.negated()) {
        this.negate();
        this.dividend.negate();
      }
      return this;
    };
    CTATIntDivisionNode.prototype.pushInversion = function() {
      if (this.intDivision() && this.inverted()) {
        this.invert();
        this.dividend.invert();
      }
      return this;
    };
    CTATIntDivisionNode.prototype.popNegation = function() {
      if (this.divisor.negated()) {
        this.divisor.negate();
        if (this.intDivision()) {
          this.dividend.negate();
        }
      }
      return this;
    };
    CTATIntDivisionNode.prototype.unknown = function() {
      return this.dividend.unknown() || this.divisor.unknown();
    };
    CTATIntDivisionNode.prototype.even = function() {
      return !this.inverted && this.operator === "REM" && this.dividend.even() && this.divisor.even();
    };
    return CTATIntDivisionNode;
  }(CTATAlgebraTreeNode);
  if (typeof module !== "undefined" && module !== null) {
    module.exports = CTATIntDivisionNode;
  } else {
    this.CTATIntDivisionNode = CTATIntDivisionNode;
  }
}).call(this);
goog.provide("CTATUnaryNode");
goog.require("CTATAlgebraTreeNode");
(function() {
  var CTATUnaryNode, extend = function(child, parent) {
    for (var key in parent) {
      if (hasProp.call(parent, key)) {
        child[key] = parent[key];
      }
    }
    function ctor() {
      this.constructor = child;
    }
    ctor.prototype = parent.prototype;
    child.prototype = new ctor;
    child.__super__ = parent.prototype;
    return child;
  }, hasProp = {}.hasOwnProperty;
  CTATUnaryNode = function(superClass) {
    extend(CTATUnaryNode, superClass);
    function CTATUnaryNode(operator1, base, parens, sign, exp) {
      this.operator = operator1;
      this.base = base;
      this.parens = parens != null ? parens : 0;
      this.sign = sign != null ? sign : 1;
      this.exp = exp != null ? exp : 1;
    }
    CTATUnaryNode.prototype.clone = function(deep) {
      if (deep == null) {
        deep = true;
      }
      return new CTATUnaryNode(this.operator, deep ? this.base.clone() : this.base, this.parens, this.sign, this.exp);
    };
    CTATUnaryNode.prototype.toString = function(operator, other) {
      if (operator == null) {
        operator = "EQUAL";
      }
      if (other == null) {
        other = false;
      }
      return CTATUnaryNode.__super__.toString.call(this, "" + CTATAlgebraTreeNode.toOperatorString(this.operator) + this.base.toString(this.operator), operator, other);
    };
    CTATUnaryNode.prototype.addPaths = function(path) {
      this.base.addPaths(path.concat(["base"]));
      return CTATUnaryNode.__super__.addPaths.apply(this, arguments);
    };
    CTATUnaryNode.prototype.evaluate = function(bindings) {
      if (bindings == null) {
        bindings = null;
      }
      return CTATUnaryNode.__super__.evaluate.call(this, this.applyOperator(this.base.evaluate(bindings)));
    };
    CTATUnaryNode.prototype.equals = function(node) {
      return CTATUnaryNode.__super__.equals.call(this, node) && this.base.equals(node.base);
    };
    CTATUnaryNode.prototype.countOperands = function() {
      return 1;
    };
    CTATUnaryNode.prototype.getOperator = function(top, index) {
      if (top == null) {
        top = false;
      }
      if (index == null) {
        index = null;
      }
      return top && CTATUnaryNode.__super__.getOperator.apply(this, arguments) || this.operator;
    };
    CTATUnaryNode.prototype.getOperators = function(top) {
      if (top == null) {
        top = false;
      }
      return [this.getOperator(top)].concat(this.base.getOperators());
    };
    CTATUnaryNode.prototype.getVariables = function() {
      return this.base.getVariables();
    };
    CTATUnaryNode.prototype.getOperands = function() {
      return [this.base];
    };
    CTATUnaryNode.prototype.findExpression = function(expression, path) {
      return this.base.findExpression(expression, path.concat(["base"])).concat(CTATUnaryNode.__super__.findExpression.call(this, expression, path));
    };
    CTATUnaryNode.prototype.applyRules = function(rules, global) {
      this.rules = rules;
      if (global == null) {
        global = true;
      }
      if (global) {
        this.base = this.base.applyRules(this.rules);
      }
      return CTATUnaryNode.__super__.applyRules.apply(this, arguments);
    };
    CTATUnaryNode.prototype.removeNull = function() {
      var ref;
      this.base = (ref = this.base) != null ? ref.removeNull() : void 0;
      if (this.base != null) {
        return this;
      } else {
        return null;
      }
    };
    CTATUnaryNode.prototype.simpleFlatten = function() {
      if (this.parented()) {
        return this;
      } else {
        if (this.negation()) {
          this.negate();
          this.operator = "UPLUS";
        }
        return this.pushNegation().pushInversion().base;
      }
    };
    CTATUnaryNode.prototype.flatten = function() {
      return CTATUnaryNode.__super__.flatten.apply(this, arguments).popNegation();
    };
    CTATUnaryNode.prototype.compare = function(node, reverse) {
      return node.unary() && this.base.compare(node.base, reverse) || CTATUnaryNode.__super__.compare.apply(this, arguments) || this.compareSigns(node, reverse);
    };
    CTATUnaryNode.prototype.countVariables = function() {
      return this.base.countVariables();
    };
    CTATUnaryNode.prototype.pushNegation = function() {
      if (this.negated()) {
        this.negate();
        this.base.negate();
      }
      return this;
    };
    CTATUnaryNode.prototype.pushInversion = function() {
      if (this.inverted()) {
        this.invert();
        this.base.invert();
      }
      return this;
    };
    CTATUnaryNode.prototype.constant = function(value, marked) {
      if (marked == null) {
        marked = false;
      }
      return this.base.constant(value, marked);
    };
    CTATUnaryNode.prototype.unknown = function() {
      return this.base.unknown();
    };
    return CTATUnaryNode;
  }(CTATAlgebraTreeNode);
  if (typeof module !== "undefined" && module !== null) {
    module.exports = CTATUnaryNode;
  } else {
    this.CTATUnaryNode = CTATUnaryNode;
  }
}).call(this);
goog.provide("CTATPowerNode");
goog.require("CTATAlgebraTreeNode");
(function() {
  var CTATPowerNode, extend = function(child, parent) {
    for (var key in parent) {
      if (hasProp.call(parent, key)) {
        child[key] = parent[key];
      }
    }
    function ctor() {
      this.constructor = child;
    }
    ctor.prototype = parent.prototype;
    child.prototype = new ctor;
    child.__super__ = parent.prototype;
    return child;
  }, hasProp = {}.hasOwnProperty;
  CTATPowerNode = function(superClass) {
    extend(CTATPowerNode, superClass);
    function CTATPowerNode(operator1, base1, exponent1, parens, sign, exp) {
      this.operator = operator1;
      this.base = base1;
      this.exponent = exponent1;
      this.parens = parens != null ? parens : 0;
      this.sign = sign != null ? sign : 1;
      this.exp = exp != null ? exp : 1;
    }
    CTATPowerNode.prototype.clone = function(deep) {
      if (deep == null) {
        deep = true;
      }
      return new CTATPowerNode(this.operator, deep ? this.base.clone() : this.base, deep ? this.exponent.clone() : this.exponent, this.parens, this.sign, this.exp);
    };
    CTATPowerNode.prototype.toString = function(operator, other) {
      if (operator == null) {
        operator = "EQUAL";
      }
      if (other == null) {
        other = false;
      }
      return CTATPowerNode.__super__.toString.call(this, "" + this.base.toString(this.operator) + CTATAlgebraTreeNode.toOperatorString(this.operator) + this.exponent.toString(this.operator), operator, other);
    };
    CTATPowerNode.prototype.addPaths = function(path) {
      this.base.addPaths(path.concat(["base"]));
      this.exponent.addPaths(path.concat(["exponent"]));
      return CTATPowerNode.__super__.addPaths.apply(this, arguments);
    };
    CTATPowerNode.prototype.evaluate = function(bindings) {
      if (bindings == null) {
        bindings = null;
      }
      return CTATPowerNode.__super__.evaluate.call(this, this.applyOperator(this.base.evaluate(bindings), this.exponent.evaluate(bindings)));
    };
    CTATPowerNode.prototype.equals = function(node) {
      return CTATPowerNode.__super__.equals.call(this, node) && this.base.equals(node.base) && this.exponent.equals(node.exponent);
    };
    CTATPowerNode.prototype.countOperands = function() {
      return 2;
    };
    CTATPowerNode.prototype.getOperator = function(top, index) {
      if (top == null) {
        top = false;
      }
      if (index == null) {
        index = null;
      }
      return top && CTATPowerNode.__super__.getOperator.apply(this, arguments) || this.operator;
    };
    CTATPowerNode.prototype.getOperators = function(top) {
      if (top == null) {
        top = false;
      }
      return this.base.getOperators().concat(this.getOperator(top), this.exponent.getOperators());
    };
    CTATPowerNode.prototype.getVariables = function() {
      return this.base.getVariables().concat(this.exponent.getVariables());
    };
    CTATPowerNode.prototype.getOperands = function() {
      return [this.base, this.exponent];
    };
    CTATPowerNode.prototype.findExpression = function(expression, path) {
      return this.base.findExpression(expression, path.concat(["base"])).concat(CTATPowerNode.__super__.findExpression.call(this, expression, path), this.exponent.findExpression(expression, path.concat(["exponent"])));
    };
    CTATPowerNode.prototype.applyRules = function(rules1, global) {
      this.rules = rules1;
      if (global == null) {
        global = true;
      }
      if (global) {
        this.base = this.base.applyRules(this.rules);
        this.exponent = this.exponent.applyRules(this.rules);
      }
      return CTATPowerNode.__super__.applyRules.apply(this, arguments);
    };
    CTATPowerNode.prototype.removeNull = function() {
      var ref, ref1;
      this.base = (ref = this.base) != null ? ref.removeNull() : void 0;
      this.exponent = (ref1 = this.exponent) != null ? ref1.removeNull() : void 0;
      if (this.base != null && this.exponent != null) {
        return this;
      } else {
        return this.base || this.exponent || null;
      }
    };
    CTATPowerNode.prototype.flatten = function() {
      var factors, rules;
      CTATPowerNode.__super__.flatten.apply(this, arguments);
      if (this.root()) {
        this.exponent.invert();
        this.operator = "EXP";
      }
      this.popNegation().popInversion();
      if (this.base.power()) {
        rules = CTATAlgebraTreeNode.diff(this.rules, ["flatten"]);
        factors = !this.base.exponent.multiplication() ? [this.base.exponent] : this.base.exponent.pushNegation().pushInversion().factors;
        if (!this.exponent.multiplication()) {
          factors.push(this.exponent);
        } else {
          factors.push.apply(factors, this.exponent.pushNegation().pushInversion().factors);
        }
        this.base.exponent = (new CTATMultiplicationNode("TIMES", factors)).applyRules(rules, false);
        return this.pushBaseNegation().pushBaseInversion().base;
      } else {
        return this;
      }
    };
    CTATPowerNode.prototype.computeConstants = function() {
      if (this.base.constant() && (this.exponent.constant() || this.exponent.multiplication() && this.exponent.factors[0].constant())) {
        if (this.exponent.constant()) {
          this.base = new CTATConstantNode(this.evaluate());
          this.exponent = null;
          this.exp = 1;
        } else {
          this.base = new CTATConstantNode((new CTATPowerNode("EXP", this.base, this.exponent.factors.shift())).evaluate());
          if (this.exponent.factors.length === 1) {
            this.exponent = this.exponent.pushNegation().pushInversion().factors[0];
          }
        }
        if (this.exponent) {
          return this;
        } else {
          return this.pushBaseNegation().pushBaseInversion().base;
        }
      } else {
        return this;
      }
    };
    CTATPowerNode.prototype.powerOne = function(marked) {
      if (marked == null) {
        marked = false;
      }
      this.exponent = this.exponent.multiplyOne(marked);
      return this.pushInversion();
    };
    CTATPowerNode.prototype.expand = function() {
      var exponent, factors, i, j, ref;
      if (this.base.addition() && (this.exponent.integer() && this.exponent.value > 1 || this.exponent.multiplication() && this.exponent.factors[0].integer() && this.exponent.factors[0].value > 1)) {
        if (this.exponent.integer()) {
          exponent = this.exponent;
          this.exponent = null;
        } else {
          exponent = this.exponent.factors.shift();
          if (this.exponent.factors.length === 1) {
            this.exponent = this.exponent.pushNegation().pushInversion().factors[0];
          }
        }
        factors = [this.base];
        for (i = j = 1, ref = exponent.evaluate();1 <= ref ? j < ref : j > ref;i = 1 <= ref ? ++j : --j) {
          factors.push(this.base.clone());
        }
        this.base = (new CTATMultiplicationNode("TIMES", factors)).applyRules(["distribute"], false);
        if (this.exponent) {
          return this;
        } else {
          return this.pushBaseNegation().pushBaseInversion().base;
        }
      } else {
        return this;
      }
    };
    CTATPowerNode.prototype.distribute = function() {
      var factors, pairs;
      if (this.base.multiplication() || this.exponent.addition()) {
        factors = this.base.multiplication() ? this.base.pushNegation().pushInversion().factors : [this.base];
        pairs = !this.exponent.addition() ? factors.map(function(_this) {
          return function(factor) {
            return [factor, _this.exponent.clone()];
          };
        }(this)) : factors.reduce(function(_this) {
          return function(result, factor) {
            result.push.apply(result, _this.exponent.terms.map(function(term) {
              return [factor.clone(), term.clone()];
            }));
            return result;
          };
        }(this), []);
        this.base = this.packFactors(pairs);
        return this.pushBaseNegation().pushBaseInversion().base;
      } else {
        return this;
      }
    };
    CTATPowerNode.prototype.packFactors = function(pairs) {
      var rules;
      rules = CTATAlgebraTreeNode.diff(this.rules, ["flatten"]);
      return new CTATMultiplicationNode("TIMES", pairs.map(function(arg) {
        var base, exponent;
        base = arg[0], exponent = arg[1];
        return (new CTATPowerNode("EXP", base, exponent)).applyRules(rules, false);
      }));
    };
    CTATPowerNode.prototype.removeIdentity = function(marked) {
      if (marked == null) {
        marked = false;
      }
      this.popInversion();
      if (this.exponent.constant(0, marked)) {
        this.base = new CTATConstantNode(1, marked);
        return this.pushBaseNegation().base;
      } else {
        if (this.base.constant(0, marked)) {
          return this.pushBaseInversion().base;
        } else {
          if (this.exponent.constant(1, marked)) {
            return this.pushBaseNegation().pushBaseInversion().base;
          } else {
            this.exponent = this.exponent.removeIdentity(marked);
            return this;
          }
        }
      }
    };
    CTATPowerNode.prototype.compare = function(node, reverse) {
      return CTATPowerNode.__super__.compare.apply(this, arguments) || (this.countVariables() - node.countVariables()) * (reverse ? -1 : 1) || this.exponent.compare(node.exponent, reverse) || this.base.compare(node.base, reverse) || this.compareSigns(node, reverse);
    };
    CTATPowerNode.prototype.countVariables = function() {
      return this.base.countVariables() * (this.exponent.constant() ? Math.abs(this.exponent.evaluate()) : Infinity);
    };
    CTATPowerNode.prototype.pushBaseNegation = function() {
      if (this.negated()) {
        this.negate();
        this.base.negate();
      }
      return this;
    };
    CTATPowerNode.prototype.pushInversion = function() {
      if (this.inverted()) {
        this.invert();
        this.exponent.negate();
      }
      return this;
    };
    CTATPowerNode.prototype.pushBaseInversion = function() {
      if (this.inverted()) {
        this.invert();
        this.base.invert();
      }
      return this;
    };
    CTATPowerNode.prototype.popNegation = function() {
      if (this.base.negated() && this.exponent.constant()) {
        this.base.negate();
        if (!this.exponent.even()) {
          this.negate();
        }
      }
      return this;
    };
    CTATPowerNode.prototype.popInversion = function() {
      if (this.exponent.negated()) {
        this.invert();
        this.exponent.negate();
      }
      if (this.base.inverted()) {
        this.invert();
        this.base.invert();
      }
      return this;
    };
    CTATPowerNode.prototype.unknown = function() {
      return this.base.unknown() || this.exponent.unknown();
    };
    CTATPowerNode.prototype.even = function() {
      return !this.inverted() && this.base.even() && this.exponent.integer();
    };
    return CTATPowerNode;
  }(CTATAlgebraTreeNode);
  if (typeof module !== "undefined" && module !== null) {
    module.exports = CTATPowerNode;
  } else {
    this.CTATPowerNode = CTATPowerNode;
  }
}).call(this);
goog.provide("CTATVariableNode");
goog.require("CTATAlgebraTreeNode");
(function() {
  var CTATVariableNode, extend = function(child, parent) {
    for (var key in parent) {
      if (hasProp.call(parent, key)) {
        child[key] = parent[key];
      }
    }
    function ctor() {
      this.constructor = child;
    }
    ctor.prototype = parent.prototype;
    child.prototype = new ctor;
    child.__super__ = parent.prototype;
    return child;
  }, hasProp = {}.hasOwnProperty;
  CTATVariableNode = function(superClass) {
    extend(CTATVariableNode, superClass);
    function CTATVariableNode(variableTable, variable, parens, sign, exp) {
      this.variableTable = variableTable;
      this.variable = variable;
      this.parens = parens != null ? parens : 0;
      this.sign = sign != null ? sign : 1;
      this.exp = exp != null ? exp : 1;
      this.operator = "VAR";
    }
    CTATVariableNode.prototype.clone = function() {
      return new CTATVariableNode(this.variableTable, this.variable, this.parens, this.sign, this.exp);
    };
    CTATVariableNode.prototype.toString = function(operator, other) {
      if (operator == null) {
        operator = "EQUAL";
      }
      if (other == null) {
        other = false;
      }
      return CTATVariableNode.__super__.toString.call(this, this.variable, operator, other);
    };
    CTATVariableNode.prototype.evaluate = function(bindings) {
      if (bindings == null) {
        bindings = null;
      }
      return CTATVariableNode.__super__.evaluate.call(this, bindings != null ? (typeof bindings.get === "function" ? bindings.get(this.variable) : void 0) || bindings[this.variable] : this.variableTable != null ? this.variableTable.get(this.variable) : function() {
        try {
          return eval(this.variable);
        } catch (_error) {
          return void 0;
        }
      }.call(this));
    };
    CTATVariableNode.prototype.equals = function(node) {
      return CTATVariableNode.__super__.equals.call(this, node) && this.variable === node.variable;
    };
    CTATVariableNode.prototype.getOperator = function(top, index) {
      if (top == null) {
        top = false;
      }
      if (index == null) {
        index = null;
      }
      return top && CTATVariableNode.__super__.getOperator.apply(this, arguments);
    };
    CTATVariableNode.prototype.getVariables = function() {
      return [this.variable];
    };
    CTATVariableNode.prototype.compare = function(node, reverse) {
      reverse = reverse != null ? -1 : 1;
      return CTATVariableNode.__super__.compare.apply(this, arguments) || this.variable > node.variable && reverse || this.variable < node.variable && -reverse || this.compareSigns(node, reverse);
    };
    CTATVariableNode.prototype.countVariables = function() {
      return 1;
    };
    return CTATVariableNode;
  }(CTATAlgebraTreeNode);
  if (typeof module !== "undefined" && module !== null) {
    module.exports = CTATVariableNode;
  } else {
    this.CTATVariableNode = CTATVariableNode;
  }
}).call(this);
goog.provide("CTATConstantNode");
goog.require("CTATAlgebraTreeNode");
(function() {
  var CTATConstantNode, extend = function(child, parent) {
    for (var key in parent) {
      if (hasProp.call(parent, key)) {
        child[key] = parent[key];
      }
    }
    function ctor() {
      this.constructor = child;
    }
    ctor.prototype = parent.prototype;
    child.prototype = new ctor;
    child.__super__ = parent.prototype;
    return child;
  }, hasProp = {}.hasOwnProperty;
  CTATConstantNode = function(superClass) {
    extend(CTATConstantNode, superClass);
    function CTATConstantNode(value1, marked1, parens, sign, exp) {
      this.value = value1;
      this.marked = marked1 != null ? marked1 : false;
      this.parens = parens != null ? parens : 0;
      this.sign = sign != null ? sign : 1;
      this.exp = exp != null ? exp : 1;
      this.operator = "CONST";
    }
    CTATConstantNode.prototype.clone = function() {
      return new CTATConstantNode(this.value, this.marked, this.parens, this.sign, this.exp);
    };
    CTATConstantNode.prototype.toString = function(operator, other) {
      if (operator == null) {
        operator = "EQUAL";
      }
      if (other == null) {
        other = false;
      }
      return CTATConstantNode.__super__.toString.call(this, this.value.toString(), operator, other);
    };
    CTATConstantNode.prototype.evaluate = function(bindings, invert) {
      if (bindings == null) {
        bindings = null;
      }
      if (invert == null) {
        invert = true;
      }
      return CTATConstantNode.__super__.evaluate.call(this, this.value, invert);
    };
    CTATConstantNode.prototype.equals = function(node) {
      return CTATConstantNode.__super__.equals.call(this, node) && this.value === node.value;
    };
    CTATConstantNode.prototype.getOperator = function(top, index) {
      if (top == null) {
        top = false;
      }
      if (index == null) {
        index = null;
      }
      return top && CTATConstantNode.__super__.getOperator.apply(this, arguments);
    };
    CTATConstantNode.prototype.multiplyOne = function() {
      return this;
    };
    CTATConstantNode.prototype.powerOne = function() {
      return this;
    };
    CTATConstantNode.prototype.compare = function(node, reverse) {
      reverse = reverse != null ? 1 : -1;
      return CTATConstantNode.__super__.compare.apply(this, arguments) || Math.sign(Math.abs(this.evaluate()) - Math.abs(node.evaluate())) * reverse || this.compareSigns(node, reverse);
    };
    CTATConstantNode.prototype.popNegation = function() {
      if (this.value < 0) {
        this.negate();
        this.value = -this.value;
      }
      return this;
    };
    CTATConstantNode.prototype.constant = function(value, marked) {
      if (marked == null) {
        marked = false;
      }
      return value == null || this.evaluate() === value && this.marked === marked;
    };
    CTATConstantNode.prototype.integer = function() {
      return Math.floor(this.evaluate()) === this.value;
    };
    CTATConstantNode.prototype.even = function() {
      return this.evaluate() % 2 === 0;
    };
    CTATConstantNode.prototype.set = function(value) {
      this.exp = 1;
      this.value = Math.abs(value);
      return this.sign = Math.sign(value);
    };
    return CTATConstantNode;
  }(CTATAlgebraTreeNode);
  if (typeof module !== "undefined" && module !== null) {
    module.exports = CTATConstantNode;
  } else {
    this.CTATConstantNode = CTATConstantNode;
  }
}).call(this);
goog.provide("CTATUnknownNode");
goog.require("CTATAlgebraTreeNode");
(function() {
  var CTATUnknownNode, extend = function(child, parent) {
    for (var key in parent) {
      if (hasProp.call(parent, key)) {
        child[key] = parent[key];
      }
    }
    function ctor() {
      this.constructor = child;
    }
    ctor.prototype = parent.prototype;
    child.prototype = new ctor;
    child.__super__ = parent.prototype;
    return child;
  }, hasProp = {}.hasOwnProperty;
  CTATUnknownNode = function(superClass) {
    extend(CTATUnknownNode, superClass);
    function CTATUnknownNode(parens, sign, exp) {
      this.parens = parens != null ? parens : 0;
      this.sign = sign != null ? sign : 1;
      this.exp = exp != null ? exp : 1;
      this.operator = "UNKNOWN";
    }
    CTATUnknownNode.prototype.clone = function() {
      return new CTATUnknownNode(this.parens, this.sign, this.exp);
    };
    CTATUnknownNode.prototype.toString = function(operator, other) {
      if (operator == null) {
        operator = "EQUAL";
      }
      if (other == null) {
        other = false;
      }
      return CTATUnknownNode.__super__.toString.call(this, "?", operator, other);
    };
    CTATUnknownNode.prototype.evaluate = function(bindings) {
      if (bindings == null) {
        bindings = null;
      }
      return NaN;
    };
    CTATUnknownNode.prototype.getOperator = function(top, index) {
      if (top == null) {
        top = false;
      }
      if (index == null) {
        index = null;
      }
      return top && CTATUnknownNode.__super__.getOperator.apply(this, arguments);
    };
    CTATUnknownNode.prototype.compare = function(node, reverse) {
      reverse = reverse != null ? 1 : -1;
      return CTATUnknownNode.__super__.compare.apply(this, arguments) || this.compareSigns(node, reverse);
    };
    CTATUnknownNode.prototype.unknown = function() {
      return true;
    };
    return CTATUnknownNode;
  }(CTATAlgebraTreeNode);
  if (typeof module !== "undefined" && module !== null) {
    module.exports = CTATUnknownNode;
  } else {
    this.CTATUnknownNode = CTATUnknownNode;
  }
}).call(this);
goog.provide("CTATAlgebraGrammar");
goog.require("CTATAlgebraTreeNode");
goog.require("CTATRelationNode");
goog.require("CTATAdditionNode");
goog.require("CTATMultiplicationNode");
goog.require("CTATIntDivisionNode");
goog.require("CTATUnaryNode");
goog.require("CTATPowerNode");
goog.require("CTATVariableNode");
goog.require("CTATConstantNode");
goog.require("CTATUnknownNode");
var CTATAlgebraGrammar = function() {
  var o = function(k, v, o, l) {
    for (o = o || {}, l = k.length;l--;o[k[l]] = v) {
    }
    return o;
  }, $V0 = [1, 6], $V1 = [1, 7], $V2 = [1, 10], $V3 = [1, 11], $V4 = [1, 12], $V5 = [1, 13], $V6 = [1, 14], $V7 = [1, 22], $V8 = [1, 23], $V9 = [5, 7, 8, 9, 10, 11, 12, 13, 15, 26], $Va = [1, 24], $Vb = [1, 25], $Vc = [1, 27], $Vd = [1, 28], $Ve = [5, 7, 8, 9, 10, 11, 12, 13, 15, 16, 18, 20, 21, 24, 25, 26, 27, 28, 29], $Vf = [5, 7, 8, 9, 10, 11, 12, 13, 15, 16, 18, 20, 21, 23, 24, 25, 26, 27, 28, 29];
  var parser = {trace:function trace() {
  }, yy:{}, symbols_:{"error":2, "expression":3, "relational":4, "EOF":5, "arithmetic":6, "LESS":7, "GREATER":8, "LESSEQUAL":9, "GREATEREQUAL":10, "EQUAL":11, "NOTEQUAL":12, "PLUS":13, "term":14, "MINUS":15, "TIMES":16, "signedfactor":17, "DIVIDE":18, "factor":19, "IDIVIDE":20, "REM":21, "atom":22, "EXP":23, "SQRT":24, "LPAREN":25, "RPAREN":26, "VARIABLE":27, "NUMBER":28, "UNKNOWN":29, "$accept":0, "$end":1}, terminals_:{2:"error", 5:"EOF", 7:"LESS", 8:"GREATER", 9:"LESSEQUAL", 10:"GREATEREQUAL", 
  11:"EQUAL", 12:"NOTEQUAL", 13:"PLUS", 15:"MINUS", 16:"TIMES", 18:"DIVIDE", 20:"IDIVIDE", 21:"REM", 23:"EXP", 24:"SQRT", 25:"LPAREN", 26:"RPAREN", 27:"VARIABLE", 28:"NUMBER", 29:"UNKNOWN"}, productions_:[0, [3, 2], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 1], [6, 3], [6, 3], [6, 1], [14, 3], [14, 3], [14, 2], [14, 3], [14, 3], [14, 1], [17, 2], [17, 2], [17, 1], [19, 3], [19, 2], [19, 1], [22, 3], [22, 1], [22, 1], [22, 1]], performAction:function anonymous(yytext, yyleng, yylineno, yy, 
  yystate, $$, _$) {
    var $0 = $$.length - 1;
    switch(yystate) {
      case 1:
        return $$[$0 - 1];
        break;
      case 2:
        this.$ = new yy.CTATRelationNode("LESS", $$[$0 - 2], $$[$0]);
        break;
      case 3:
        this.$ = new yy.CTATRelationNode("GREATER", $$[$0 - 2], $$[$0]);
        break;
      case 4:
        this.$ = new yy.CTATRelationNode("LESSEQUAL", $$[$0 - 2], $$[$0]);
        break;
      case 5:
        this.$ = new yy.CTATRelationNode("GREATEREQUAL", $$[$0 - 2], $$[$0]);
        break;
      case 6:
        this.$ = new yy.CTATRelationNode("EQUAL", $$[$0 - 2], $$[$0]);
        break;
      case 7:
        this.$ = new yy.CTATRelationNode("NOTEQUAL", $$[$0 - 2], $$[$0]);
        break;
      case 8:
      ;
      case 11:
      ;
      case 17:
      ;
      case 20:
      ;
      case 23:
        this.$ = $$[$0];
        break;
      case 9:
        this.$ = new yy.CTATAdditionNode("PLUS", [$$[$0 - 2], $$[$0]]);
        break;
      case 10:
        this.$ = new yy.CTATAdditionNode("MINUS", [$$[$0 - 2], $$[$0]]);
        break;
      case 12:
        this.$ = new yy.CTATMultiplicationNode("TIMES", [$$[$0 - 2], $$[$0]]);
        break;
      case 13:
        this.$ = new yy.CTATMultiplicationNode("DIVIDE", [$$[$0 - 2], $$[$0]]);
        break;
      case 14:
        this.$ = new yy.CTATMultiplicationNode("ITIMES", [$$[$0 - 1], $$[$0]]);
        break;
      case 15:
        this.$ = new yy.CTATIntDivisionNode("IDIVIDE", $$[$0 - 2], $$[$0]);
        break;
      case 16:
        this.$ = new yy.CTATIntDivisionNode("REM", $$[$0 - 2], $$[$0]);
        break;
      case 18:
        this.$ = new yy.CTATUnaryNode("UPLUS", $$[$0]);
        break;
      case 19:
        this.$ = new yy.CTATUnaryNode("UMINUS", $$[$0]);
        break;
      case 21:
        this.$ = new yy.CTATPowerNode("EXP", $$[$0 - 2], $$[$0]);
        break;
      case 22:
        this.$ = new yy.CTATPowerNode("ROOT", $$[$0], new yy.CTATConstantNode(2));
        break;
      case 24:
        this.$ = $$[$0 - 1].setParens();
        break;
      case 25:
        this.$ = new yy.CTATVariableNode(yy.variableTable, $$[$0]);
        break;
      case 26:
        this.$ = new yy.CTATConstantNode(Number($$[$0]));
        break;
      case 27:
        this.$ = new yy.CTATUnknownNode;
        break;
    }
  }, table:[{3:1, 4:2, 6:3, 13:$V0, 14:4, 15:$V1, 17:5, 19:8, 22:9, 24:$V2, 25:$V3, 27:$V4, 28:$V5, 29:$V6}, {1:[3]}, {5:[1, 15]}, {5:[2, 8], 7:[1, 16], 8:[1, 17], 9:[1, 18], 10:[1, 19], 11:[1, 20], 12:[1, 21], 13:$V7, 15:$V8}, o($V9, [2, 11], {22:9, 19:26, 16:$Va, 18:$Vb, 20:$Vc, 21:$Vd, 24:$V2, 25:$V3, 27:$V4, 28:$V5, 29:$V6}), o($Ve, [2, 17]), {13:$V0, 15:$V1, 17:29, 19:8, 22:9, 24:$V2, 25:$V3, 27:$V4, 28:$V5, 29:$V6}, {13:$V0, 15:$V1, 17:30, 19:8, 22:9, 24:$V2, 25:$V3, 27:$V4, 28:$V5, 29:$V6}, 
  o($Ve, [2, 20]), o($Ve, [2, 23], {23:[1, 31]}), {13:$V0, 15:$V1, 17:32, 19:8, 22:9, 24:$V2, 25:$V3, 27:$V4, 28:$V5, 29:$V6}, {6:33, 13:$V0, 14:4, 15:$V1, 17:5, 19:8, 22:9, 24:$V2, 25:$V3, 27:$V4, 28:$V5, 29:$V6}, o($Vf, [2, 25]), o($Vf, [2, 26]), o($Vf, [2, 27]), {1:[2, 1]}, {6:34, 13:$V0, 14:4, 15:$V1, 17:5, 19:8, 22:9, 24:$V2, 25:$V3, 27:$V4, 28:$V5, 29:$V6}, {6:35, 13:$V0, 14:4, 15:$V1, 17:5, 19:8, 22:9, 24:$V2, 25:$V3, 27:$V4, 28:$V5, 29:$V6}, {6:36, 13:$V0, 14:4, 15:$V1, 17:5, 19:8, 22:9, 
  24:$V2, 25:$V3, 27:$V4, 28:$V5, 29:$V6}, {6:37, 13:$V0, 14:4, 15:$V1, 17:5, 19:8, 22:9, 24:$V2, 25:$V3, 27:$V4, 28:$V5, 29:$V6}, {6:38, 13:$V0, 14:4, 15:$V1, 17:5, 19:8, 22:9, 24:$V2, 25:$V3, 27:$V4, 28:$V5, 29:$V6}, {6:39, 13:$V0, 14:4, 15:$V1, 17:5, 19:8, 22:9, 24:$V2, 25:$V3, 27:$V4, 28:$V5, 29:$V6}, {13:$V0, 14:40, 15:$V1, 17:5, 19:8, 22:9, 24:$V2, 25:$V3, 27:$V4, 28:$V5, 29:$V6}, {13:$V0, 14:41, 15:$V1, 17:5, 19:8, 22:9, 24:$V2, 25:$V3, 27:$V4, 28:$V5, 29:$V6}, {13:$V0, 15:$V1, 17:42, 19:8, 
  22:9, 24:$V2, 25:$V3, 27:$V4, 28:$V5, 29:$V6}, {13:$V0, 15:$V1, 17:43, 19:8, 22:9, 24:$V2, 25:$V3, 27:$V4, 28:$V5, 29:$V6}, o($Ve, [2, 14]), {13:$V0, 15:$V1, 17:44, 19:8, 22:9, 24:$V2, 25:$V3, 27:$V4, 28:$V5, 29:$V6}, {13:$V0, 15:$V1, 17:45, 19:8, 22:9, 24:$V2, 25:$V3, 27:$V4, 28:$V5, 29:$V6}, o($Ve, [2, 18]), o($Ve, [2, 19]), {13:$V0, 15:$V1, 17:46, 19:8, 22:9, 24:$V2, 25:$V3, 27:$V4, 28:$V5, 29:$V6}, o($Ve, [2, 22]), {13:$V7, 15:$V8, 26:[1, 47]}, {5:[2, 2], 13:$V7, 15:$V8}, {5:[2, 3], 13:$V7, 
  15:$V8}, {5:[2, 4], 13:$V7, 15:$V8}, {5:[2, 5], 13:$V7, 15:$V8}, {5:[2, 6], 13:$V7, 15:$V8}, {5:[2, 7], 13:$V7, 15:$V8}, o($V9, [2, 9], {22:9, 19:26, 16:$Va, 18:$Vb, 20:$Vc, 21:$Vd, 24:$V2, 25:$V3, 27:$V4, 28:$V5, 29:$V6}), o($V9, [2, 10], {22:9, 19:26, 16:$Va, 18:$Vb, 20:$Vc, 21:$Vd, 24:$V2, 25:$V3, 27:$V4, 28:$V5, 29:$V6}), o($Ve, [2, 12]), o($Ve, [2, 13]), o($Ve, [2, 15]), o($Ve, [2, 16]), o($Ve, [2, 21]), o($Vf, [2, 24])], defaultActions:{15:[2, 1]}, parseError:function parseError(str, hash) {
    if (hash.recoverable) {
      this.trace(str);
    } else {
      var error = new Error(str);
      error.hash = hash;
      throw error;
    }
  }, parse:function parse(input) {
    var self = this, stack = [0], tstack = [], vstack = [null], lstack = [], table = this.table, yytext = "", yylineno = 0, yyleng = 0, recovering = 0, TERROR = 2, EOF = 1;
    var args = lstack.slice.call(arguments, 1);
    var lexer = Object.create(this.lexer);
    var sharedState = {yy:{}};
    for (var k in this.yy) {
      if (Object.prototype.hasOwnProperty.call(this.yy, k)) {
        sharedState.yy[k] = this.yy[k];
      }
    }
    lexer.setInput(input, sharedState.yy);
    sharedState.yy.lexer = lexer;
    sharedState.yy.parser = this;
    if (typeof lexer.yylloc == "undefined") {
      lexer.yylloc = {};
    }
    var yyloc = lexer.yylloc;
    lstack.push(yyloc);
    var ranges = lexer.options && lexer.options.ranges;
    if (typeof sharedState.yy.parseError === "function") {
      this.parseError = sharedState.yy.parseError;
    } else {
      this.parseError = Object.getPrototypeOf(this).parseError;
    }
    function popStack(n) {
      stack.length = stack.length - 2 * n;
      vstack.length = vstack.length - n;
      lstack.length = lstack.length - n;
    }
    _token_stack: var lex = function() {
      var token;
      token = lexer.lex() || EOF;
      if (typeof token !== "number") {
        token = self.symbols_[token] || token;
      }
      return token;
    };
    var symbol, preErrorSymbol, state, action, a, r, yyval = {}, p, len, newState, expected;
    while (true) {
      state = stack[stack.length - 1];
      if (this.defaultActions[state]) {
        action = this.defaultActions[state];
      } else {
        if (symbol === null || typeof symbol == "undefined") {
          symbol = lex();
        }
        action = table[state] && table[state][symbol];
      }
      if (typeof action === "undefined" || !action.length || !action[0]) {
        var errStr = "";
        expected = [];
        for (p in table[state]) {
          if (this.terminals_[p] && p > TERROR) {
            expected.push("'" + this.terminals_[p] + "'");
          }
        }
        if (lexer.showPosition) {
          errStr = "Parse error on line " + (yylineno + 1) + ":\n" + lexer.showPosition() + "\nExpecting " + expected.join(", ") + ", got '" + (this.terminals_[symbol] || symbol) + "'";
        } else {
          errStr = "Parse error on line " + (yylineno + 1) + ": Unexpected " + (symbol == EOF ? "end of input" : "'" + (this.terminals_[symbol] || symbol) + "'");
        }
        this.parseError(errStr, {text:lexer.match, token:this.terminals_[symbol] || symbol, line:lexer.yylineno, loc:yyloc, expected:expected});
      }
      if (action[0] instanceof Array && action.length > 1) {
        throw new Error("Parse Error: multiple actions possible at state: " + state + ", token: " + symbol);
      }
      switch(action[0]) {
        case 1:
          stack.push(symbol);
          vstack.push(lexer.yytext);
          lstack.push(lexer.yylloc);
          stack.push(action[1]);
          symbol = null;
          if (!preErrorSymbol) {
            yyleng = lexer.yyleng;
            yytext = lexer.yytext;
            yylineno = lexer.yylineno;
            yyloc = lexer.yylloc;
            if (recovering > 0) {
              recovering--;
            }
          } else {
            symbol = preErrorSymbol;
            preErrorSymbol = null;
          }
          break;
        case 2:
          len = this.productions_[action[1]][1];
          yyval.$ = vstack[vstack.length - len];
          yyval._$ = {first_line:lstack[lstack.length - (len || 1)].first_line, last_line:lstack[lstack.length - 1].last_line, first_column:lstack[lstack.length - (len || 1)].first_column, last_column:lstack[lstack.length - 1].last_column};
          if (ranges) {
            yyval._$.range = [lstack[lstack.length - (len || 1)].range[0], lstack[lstack.length - 1].range[1]];
          }
          r = this.performAction.apply(yyval, [yytext, yyleng, yylineno, sharedState.yy, action[1], vstack, lstack].concat(args));
          if (typeof r !== "undefined") {
            return r;
          }
          if (len) {
            stack = stack.slice(0, -1 * len * 2);
            vstack = vstack.slice(0, -1 * len);
            lstack = lstack.slice(0, -1 * len);
          }
          stack.push(this.productions_[action[1]][0]);
          vstack.push(yyval.$);
          lstack.push(yyval._$);
          newState = table[stack[stack.length - 2]][stack[stack.length - 1]];
          stack.push(newState);
          break;
        case 3:
          return true;
      }
    }
    return true;
  }};
  var lexer = function() {
    var lexer = {EOF:1, parseError:function parseError(str, hash) {
      if (this.yy.parser) {
        this.yy.parser.parseError(str, hash);
      } else {
        throw new Error(str);
      }
    }, setInput:function(input, yy) {
      this.yy = yy || this.yy || {};
      this._input = input;
      this._more = this._backtrack = this.done = false;
      this.yylineno = this.yyleng = 0;
      this.yytext = this.matched = this.match = "";
      this.conditionStack = ["INITIAL"];
      this.yylloc = {first_line:1, first_column:0, last_line:1, last_column:0};
      if (this.options.ranges) {
        this.yylloc.range = [0, 0];
      }
      this.offset = 0;
      return this;
    }, input:function() {
      var ch = this._input[0];
      this.yytext += ch;
      this.yyleng++;
      this.offset++;
      this.match += ch;
      this.matched += ch;
      var lines = ch.match(/(?:\r\n?|\n).*/g);
      if (lines) {
        this.yylineno++;
        this.yylloc.last_line++;
      } else {
        this.yylloc.last_column++;
      }
      if (this.options.ranges) {
        this.yylloc.range[1]++;
      }
      this._input = this._input.slice(1);
      return ch;
    }, unput:function(ch) {
      var len = ch.length;
      var lines = ch.split(/(?:\r\n?|\n)/g);
      this._input = ch + this._input;
      this.yytext = this.yytext.substr(0, this.yytext.length - len);
      this.offset -= len;
      var oldLines = this.match.split(/(?:\r\n?|\n)/g);
      this.match = this.match.substr(0, this.match.length - 1);
      this.matched = this.matched.substr(0, this.matched.length - 1);
      if (lines.length - 1) {
        this.yylineno -= lines.length - 1;
      }
      var r = this.yylloc.range;
      this.yylloc = {first_line:this.yylloc.first_line, last_line:this.yylineno + 1, first_column:this.yylloc.first_column, last_column:lines ? (lines.length === oldLines.length ? this.yylloc.first_column : 0) + oldLines[oldLines.length - lines.length].length - lines[0].length : this.yylloc.first_column - len};
      if (this.options.ranges) {
        this.yylloc.range = [r[0], r[0] + this.yyleng - len];
      }
      this.yyleng = this.yytext.length;
      return this;
    }, more:function() {
      this._more = true;
      return this;
    }, reject:function() {
      if (this.options.backtrack_lexer) {
        this._backtrack = true;
      } else {
        return this.parseError("Lexical error on line " + (this.yylineno + 1) + ". You can only invoke reject() in the lexer when the lexer is of the backtracking persuasion (options.backtrack_lexer = true).\n" + this.showPosition(), {text:"", token:null, line:this.yylineno});
      }
      return this;
    }, less:function(n) {
      this.unput(this.match.slice(n));
    }, pastInput:function() {
      var past = this.matched.substr(0, this.matched.length - this.match.length);
      return (past.length > 20 ? "..." : "") + past.substr(-20).replace(/\n/g, "");
    }, upcomingInput:function() {
      var next = this.match;
      if (next.length < 20) {
        next += this._input.substr(0, 20 - next.length);
      }
      return (next.substr(0, 20) + (next.length > 20 ? "..." : "")).replace(/\n/g, "");
    }, showPosition:function() {
      var pre = this.pastInput();
      var c = (new Array(pre.length + 1)).join("-");
      return pre + this.upcomingInput() + "\n" + c + "^";
    }, test_match:function(match, indexed_rule) {
      var token, lines, backup;
      if (this.options.backtrack_lexer) {
        backup = {yylineno:this.yylineno, yylloc:{first_line:this.yylloc.first_line, last_line:this.last_line, first_column:this.yylloc.first_column, last_column:this.yylloc.last_column}, yytext:this.yytext, match:this.match, matches:this.matches, matched:this.matched, yyleng:this.yyleng, offset:this.offset, _more:this._more, _input:this._input, yy:this.yy, conditionStack:this.conditionStack.slice(0), done:this.done};
        if (this.options.ranges) {
          backup.yylloc.range = this.yylloc.range.slice(0);
        }
      }
      lines = match[0].match(/(?:\r\n?|\n).*/g);
      if (lines) {
        this.yylineno += lines.length;
      }
      this.yylloc = {first_line:this.yylloc.last_line, last_line:this.yylineno + 1, first_column:this.yylloc.last_column, last_column:lines ? lines[lines.length - 1].length - lines[lines.length - 1].match(/\r?\n?/)[0].length : this.yylloc.last_column + match[0].length};
      this.yytext += match[0];
      this.match += match[0];
      this.matches = match;
      this.yyleng = this.yytext.length;
      if (this.options.ranges) {
        this.yylloc.range = [this.offset, this.offset += this.yyleng];
      }
      this._more = false;
      this._backtrack = false;
      this._input = this._input.slice(match[0].length);
      this.matched += match[0];
      token = this.performAction.call(this, this.yy, this, indexed_rule, this.conditionStack[this.conditionStack.length - 1]);
      if (this.done && this._input) {
        this.done = false;
      }
      if (token) {
        return token;
      } else {
        if (this._backtrack) {
          for (var k in backup) {
            this[k] = backup[k];
          }
          return false;
        }
      }
      return false;
    }, next:function() {
      if (this.done) {
        return this.EOF;
      }
      if (!this._input) {
        this.done = true;
      }
      var token, match, tempMatch, index;
      if (!this._more) {
        this.yytext = "";
        this.match = "";
      }
      var rules = this._currentRules();
      for (var i = 0;i < rules.length;i++) {
        tempMatch = this._input.match(this.rules[rules[i]]);
        if (tempMatch && (!match || tempMatch[0].length > match[0].length)) {
          match = tempMatch;
          index = i;
          if (this.options.backtrack_lexer) {
            token = this.test_match(tempMatch, rules[i]);
            if (token !== false) {
              return token;
            } else {
              if (this._backtrack) {
                match = false;
                continue;
              } else {
                return false;
              }
            }
          } else {
            if (!this.options.flex) {
              break;
            }
          }
        }
      }
      if (match) {
        token = this.test_match(match, rules[index]);
        if (token !== false) {
          return token;
        }
        return false;
      }
      if (this._input === "") {
        return this.EOF;
      } else {
        return this.parseError("Lexical error on line " + (this.yylineno + 1) + ". Unrecognized text.\n" + this.showPosition(), {text:"", token:null, line:this.yylineno});
      }
    }, lex:function lex() {
      var r = this.next();
      if (r) {
        return r;
      } else {
        return this.lex();
      }
    }, begin:function begin(condition) {
      this.conditionStack.push(condition);
    }, popState:function popState() {
      var n = this.conditionStack.length - 1;
      if (n > 0) {
        return this.conditionStack.pop();
      } else {
        return this.conditionStack[0];
      }
    }, _currentRules:function _currentRules() {
      if (this.conditionStack.length && this.conditionStack[this.conditionStack.length - 1]) {
        return this.conditions[this.conditionStack[this.conditionStack.length - 1]].rules;
      } else {
        return this.conditions["INITIAL"].rules;
      }
    }, topState:function topState(n) {
      n = this.conditionStack.length - 1 - Math.abs(n || 0);
      if (n >= 0) {
        return this.conditionStack[n];
      } else {
        return "INITIAL";
      }
    }, pushState:function pushState(condition) {
      this.begin(condition);
    }, stateStackSize:function stateStackSize() {
      return this.conditionStack.length;
    }, options:{}, performAction:function anonymous(yy, yy_, $avoiding_name_collisions, YY_START) {
      var YYSTATE = YY_START;
      switch($avoiding_name_collisions) {
        case 0:
          break;
        case 1:
          return 25;
          break;
        case 2:
          return 26;
          break;
        case 3:
          return 23;
          break;
        case 4:
          return 23;
          break;
        case 5:
          return 24;
          break;
        case 6:
          return 24;
          break;
        case 7:
          return 16;
          break;
        case 8:
          return 16;
          break;
        case 9:
          return 16;
          break;
        case 10:
          return 20;
          break;
        case 11:
          return 18;
          break;
        case 12:
          return 18;
          break;
        case 13:
          return 21;
          break;
        case 14:
          return 15;
          break;
        case 15:
          return 13;
          break;
        case 16:
          return 9;
          break;
        case 17:
          return 9;
          break;
        case 18:
          return 10;
          break;
        case 19:
          return 10;
          break;
        case 20:
          return 7;
          break;
        case 21:
          return 8;
          break;
        case 22:
          return 12;
          break;
        case 23:
          return 12;
          break;
        case 24:
          return 12;
          break;
        case 25:
          return 12;
          break;
        case 26:
          return 11;
          break;
        case 27:
          return 11;
          break;
        case 28:
          return 28;
          break;
        case 29:
          return 28;
          break;
        case 30:
          return 27;
          break;
        case 31:
          return 29;
          break;
        case 32:
          return 5;
          break;
      }
    }, rules:[/^(?:\s+)/, /^(?:\()/, /^(?:\))/, /^(?:\*\*)/, /^(?:\^)/, /^(?:\|)/, /^(?:\u221a)/, /^(?:\*)/, /^(?:\u00d7)/, /^(?:\u22c5)/, /^(?:\/\/)/, /^(?:\/)/, /^(?:\u00f7)/, /^(?:%)/, /^(?:-)/, /^(?:\+)/, /^(?:<=)/, /^(?:\u2264)/, /^(?:>=)/, /^(?:\u2265)/, /^(?:<)/, /^(?:>)/, /^(?:!=)/, /^(?:\/=)/, /^(?:<>)/, /^(?:\u2260)/, /^(?:==)/, /^(?:=)/, /^(?:(([0-9])+\.?([0-9])*|\.([0-9])+)([Ee][+-]?([0-9])+)?)/, /^(?:(0[Bb]([0-1])+|0[Oo]([0-7])+|0[Xx]([0-9A-Fa-f])+))/, /^(?:([A-Za-z]))/, /^(?:\?)/, /^(?:$)/], 
    conditions:{"INITIAL":{"rules":[0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32], "inclusive":true}}};
    return lexer;
  }();
  parser.lexer = lexer;
  function Parser() {
    this.yy = {};
  }
  Parser.prototype = parser;
  parser.Parser = Parser;
  return new Parser;
}();
goog.provide("CTATAlgebraParser");
goog.require("CTATAlgebraGrammar");
goog.require("CTATRelationNode");
goog.require("CTATAdditionNode");
goog.require("CTATMultiplicationNode");
goog.require("CTATIntDivisionNode");
goog.require("CTATUnaryNode");
goog.require("CTATPowerNode");
goog.require("CTATVariableNode");
goog.require("CTATConstantNode");
goog.require("CTATUnknownNode");
goog.require("CTATAlgebraTreeNode");
(function() {
  var CTATAlgebraParser, slice = [].slice;
  CTATAlgebraParser = function() {
    function CTATAlgebraParser(variableTable) {
      this.parser = new CTATAlgebraGrammar.Parser;
      this.parser.yy = {CTATRelationNode:CTATRelationNode, CTATAdditionNode:CTATAdditionNode, CTATMultiplicationNode:CTATMultiplicationNode, CTATIntDivisionNode:CTATIntDivisionNode, CTATUnaryNode:CTATUnaryNode, CTATPowerNode:CTATPowerNode, CTATVariableNode:CTATVariableNode, CTATConstantNode:CTATConstantNode, CTATUnknownNode:CTATUnknownNode, CTATAlgebraTreeNode:CTATAlgebraTreeNode};
      this.parser.yy.variableTable = variableTable;
    }
    CTATAlgebraParser.partial = ["flatten", "removeIdentity"];
    CTATAlgebraParser.full = ["flatten", "computeConstants", "combineSimilar", "expand", "distribute", "removeIdentity"];
    CTATAlgebraParser.prototype.toTree = function(expression, order, clone, removeParentheses) {
      var result;
      if (order == null) {
        order = false;
      }
      if (clone == null) {
        clone = false;
      }
      if (removeParentheses == null) {
        removeParentheses = false;
      }
      result = expression instanceof CTATAlgebraTreeNode ? clone ? expression.clone() : expression : this.parser.parse(String(expression));
      return result.applyRules([removeParentheses ? "flatten" : "simpleFlatten"].concat(order ? "sort" : []));
    };
    CTATAlgebraParser.prototype.toExpression = function(expression, tree, paths) {
      if (paths == null) {
        paths = true;
      }
      if (expression instanceof CTATAlgebraTreeNode) {
        if (paths && tree instanceof CTATAlgebraTreeNode) {
          return tree.addPaths(tree.path || []);
        } else {
          return tree;
        }
      } else {
        if (tree != null) {
          return tree.toString();
        } else {
          return tree;
        }
      }
    };
    CTATAlgebraParser.prototype.equalExpressions = function(expression1, expression2) {
      if (expression1 instanceof CTATAlgebraTreeNode || expression2 instanceof CTATAlgebraTreeNode) {
        return expression1.toString() === expression2.toString();
      } else {
        return expression1 === expression2;
      }
    };
    CTATAlgebraParser.prototype.algParse = function(expression, order, removeParentheses) {
      if (order == null) {
        order = false;
      }
      if (removeParentheses == null) {
        removeParentheses = false;
      }
      try {
        return this.toTree(expression, order, true, removeParentheses).addPaths([]);
      } catch (_error) {
        return null;
      }
    };
    CTATAlgebraParser.prototype.algGetError = function(expression) {
      var error;
      try {
        expression instanceof CTATAlgebraTreeNode || this.parser.parse(String(expression));
        return null;
      } catch (_error) {
        error = _error;
        return error;
      }
    };
    CTATAlgebraParser.prototype.algStringify = function(expression) {
      return (expression != null ? expression.toString() : void 0) || null;
    };
    CTATAlgebraParser.prototype.algEvaluate = function(expression, bindings) {
      if (bindings == null) {
        bindings = null;
      }
      try {
        return this.toTree(expression).evaluate(bindings);
      } catch (_error) {
        return null;
      }
    };
    CTATAlgebraParser.prototype.algSort = function(expression) {
      try {
        return this.toExpression(expression, this.toTree(expression, true, true));
      } catch (_error) {
        return null;
      }
    };
    CTATAlgebraParser.prototype.algGetOperator = function(expression) {
      try {
        return this.toTree(expression).getOperator(true, 1);
      } catch (_error) {
        return null;
      }
    };
    CTATAlgebraParser.prototype.algGetOperators = function(expression) {
      try {
        return this.toTree(expression).getOperators(true);
      } catch (_error) {
        return null;
      }
    };
    CTATAlgebraParser.prototype.algGetVariables = function(expression) {
      try {
        return this.toTree(expression).getVariables();
      } catch (_error) {
        return null;
      }
    };
    CTATAlgebraParser.prototype.algGetOperands = function(expression) {
      var ref;
      try {
        return (ref = this.toTree(expression)) != null ? ref.getOperands().map(function(_this) {
          return function(subexpression) {
            return _this.toExpression(expression, subexpression, false);
          };
        }(this)) : void 0;
      } catch (_error) {
        return null;
      }
    };
    CTATAlgebraParser.prototype.algGetExpression = function(expression, start, end) {
      try {
        return this.toExpression(expression, this.toTree(expression).getExpression(start, end), false);
      } catch (_error) {
        return null;
      }
    };
    CTATAlgebraParser.prototype.algFindExpression = function(expression, subexpression) {
      try {
        return this.toTree(expression).findExpression(this.toTree(subexpression), []).map(function(_this) {
          return function(subexpression) {
            return _this.toExpression(expression, subexpression, false);
          };
        }(this));
      } catch (_error) {
        return null;
      }
    };
    CTATAlgebraParser.prototype.algCreateExpression = function() {
      var expression, expressions, operator, ref;
      operator = arguments[0], expression = arguments[1], expressions = 3 <= arguments.length ? slice.call(arguments, 2) : [];
      try {
        return this.toExpression(expression, (ref = this.toTree(expression, false, true)).createExpression.apply(ref, [operator].concat(slice.call(expressions.map(function(_this) {
          return function(expression) {
            return _this.toTree(expression, false, true);
          };
        }(this))))));
      } catch (_error) {
        return null;
      }
    };
    CTATAlgebraParser.prototype.algReplaceExpression = function(expression, oldSubexpression, newSubexpression, locator) {
      var ref, ref1;
      if (locator == null) {
        locator = null;
      }
      locator = (locator != null ? locator : (ref = oldSubexpression.path) != null ? ref.slice(0) : void 0) || 0;
      try {
        return this.toExpression(expression, (ref1 = this.toTree(expression)) != null ? ref1.replaceExpression(this.toTree(oldSubexpression), this.toTree(newSubexpression), locator) : void 0);
      } catch (_error) {
        return null;
      }
    };
    CTATAlgebraParser.prototype.algDeleteExpression = function(expression, subexpression, locator) {
      var ref, ref1;
      if (locator == null) {
        locator = null;
      }
      locator = (locator != null ? locator : (ref = subexpression.path) != null ? ref.slice(0) : void 0) || 0;
      try {
        return this.toExpression(expression, (ref1 = this.toTree(expression)) != null ? ref1.deleteExpression(this.toTree(subexpression), locator) : void 0);
      } catch (_error) {
        return null;
      }
    };
    CTATAlgebraParser.prototype.algApplyRulesSelectively = function() {
      var expression, global, index, indices, ref, rules;
      expression = arguments[0], rules = arguments[1], global = arguments[2], index = arguments[3], indices = 5 <= arguments.length ? slice.call(arguments, 4) : [];
      if (global == null) {
        global = true;
      }
      if (index == null) {
        index = null;
      }
      try {
        return this.toExpression(expression, (ref = this.toTree(expression, false, true)).applyRulesSelectively.apply(ref, [rules, global, index].concat(slice.call(indices))));
      } catch (_error) {
        return null;
      }
    };
    CTATAlgebraParser.prototype.algApplyRules = function(expression, rules, global) {
      if (global == null) {
        global = true;
      }
      try {
        return this.toExpression(expression, this.toTree(expression, false, true).applyRules(rules, global));
      } catch (_error) {
        return null;
      }
    };
    CTATAlgebraParser.prototype.algPartiallySimplify = function(expression, order) {
      if (order == null) {
        order = false;
      }
      return this.algApplyRules(expression, CTATAlgebraParser.partial.concat(order ? "sort" : []), true);
    };
    CTATAlgebraParser.prototype.algSimplify = function(expression, order) {
      if (order == null) {
        order = false;
      }
      return this.algApplyRules(expression, CTATAlgebraParser.full.concat(order ? "sort" : []), true);
    };
    CTATAlgebraParser.prototype.algValid = function(expression, ordered) {
      var expression1, expression2;
      if (ordered == null) {
        ordered = false;
      }
      if ((expression1 = this.algParse(expression, true)) != null && (expression2 = this.algParse(expression, !ordered)) != null) {
        return this.equalExpressions(expression1, expression2);
      } else {
        return null;
      }
    };
    CTATAlgebraParser.prototype.algValued = function(expression, bindings) {
      var value;
      if (bindings == null) {
        bindings = null;
      }
      if ((value = this.algEvaluate(expression, bindings)) != null) {
        return !isNaN(value);
      } else {
        return null;
      }
    };
    CTATAlgebraParser.prototype.algPartiallySimplified = function(expression, ordered) {
      var expression1, expression2;
      if (ordered == null) {
        ordered = false;
      }
      if ((expression1 = this.algPartiallySimplify(expression, true)) != null && (expression2 = this.algParse(expression, !ordered)) != null) {
        return this.equalExpressions(expression1, expression2);
      } else {
        return null;
      }
    };
    CTATAlgebraParser.prototype.algSimplified = function(expression, ordered) {
      var expression1, expression2;
      if (ordered == null) {
        ordered = false;
      }
      if ((expression1 = this.algSimplify(expression, true)) != null && (expression2 = this.algParse(expression, !ordered)) != null) {
        return this.equalExpressions(expression1, expression2);
      } else {
        return null;
      }
    };
    CTATAlgebraParser.prototype.algIdentical = function(expression1, expression2, sameOrder, ignoreParentheses) {
      if (sameOrder == null) {
        sameOrder = false;
      }
      if (ignoreParentheses == null) {
        ignoreParentheses = false;
      }
      if ((expression1 = this.algParse(expression1, !sameOrder, ignoreParentheses)) != null && (expression2 = this.algParse(expression2, !sameOrder, ignoreParentheses)) != null) {
        return this.equalExpressions(expression1, expression2);
      } else {
        return null;
      }
    };
    CTATAlgebraParser.prototype.algEqual = function(expression1, expression2, bindings) {
      var value1, value2;
      if (bindings == null) {
        bindings = null;
      }
      if ((value1 = this.algEvaluate(expression1, bindings)) != null && (value2 = this.algEvaluate(expression2, bindings)) != null) {
        return value1 === value2;
      } else {
        return null;
      }
    };
    CTATAlgebraParser.prototype.algPartiallyEquivalent = function(expression1, expression2, sameOrder) {
      if (sameOrder == null) {
        sameOrder = false;
      }
      if ((expression1 = this.algPartiallySimplify(expression1, !sameOrder)) != null && (expression2 = this.algPartiallySimplify(expression2, !sameOrder)) != null) {
        return this.equalExpressions(expression1, expression2);
      } else {
        return null;
      }
    };
    CTATAlgebraParser.prototype.algEquivalent = function(expression1, expression2, sameOrder) {
      if (sameOrder == null) {
        sameOrder = false;
      }
      if ((expression1 = this.algSimplify(expression1, !sameOrder)) != null && (expression2 = this.algSimplify(expression2, !sameOrder)) != null) {
        return this.equalExpressions(expression1, expression2);
      } else {
        return null;
      }
    };
    CTATAlgebraParser.prototype.isAlgValid = CTATAlgebraParser.prototype.algValid;
    CTATAlgebraParser.prototype.algEval = CTATAlgebraParser.prototype.algEvaluate;
    CTATAlgebraParser.prototype.algStrictEquivTermsSameOrder = function(expression1, expression2) {
      return this.algPartiallyEquivalent(expression1, expression2, true);
    };
    CTATAlgebraParser.prototype.algEquivTermsSameOrder = CTATAlgebraParser.prototype.algStrictEquivTermsSameOrder;
    CTATAlgebraParser.prototype.algStrictEquivTerms = CTATAlgebraParser.prototype.algPartiallyEquivalent;
    CTATAlgebraParser.prototype.algEquivTerms = CTATAlgebraParser.prototype.algStrictEquivTerms;
    CTATAlgebraParser.prototype.algEquiv = CTATAlgebraParser.prototype.algEquivalent;
    CTATAlgebraParser.prototype.isSimplified = function(expression) {
      return this.algSimplified(expression, true);
    };
    CTATAlgebraParser.prototype.calc = CTATAlgebraParser.prototype.algEvaluate;
    CTATAlgebraParser.prototype.calca = function(expression) {
      return (+this.algEvaluate(expression)).toFixed(2);
    };
    CTATAlgebraParser.prototype.simplify = function(expression) {
      return this.algSimplify(expression, true);
    };
    CTATAlgebraParser.prototype.algebraicEqual = CTATAlgebraParser.prototype.algEqual;
    CTATAlgebraParser.prototype.patternMatches = function(expression1, expression2) {
      return this.algIdentical(expression1, expression2, true);
    };
    CTATAlgebraParser.prototype.polyTermsEqual = function(expression1, expression2) {
      return this.algPartiallyEquivalent(expression1, expression2);
    };
    CTATAlgebraParser.prototype.algebraicMatches = function(expression1, expression2) {
      return this.algEquivalent(expression1, expression2, true);
    };
    CTATAlgebraParser.prototype.expressionMatches = CTATAlgebraParser.prototype.algebraicMatches;
    return CTATAlgebraParser;
  }();
  if (typeof module !== "undefined" && module !== null) {
    module.exports = CTATAlgebraParser;
  } else {
    this.CTATAlgebraParser = CTATAlgebraParser;
  }
}).call(this);
goog.provide("CTATLogicTreeNode");
(function() {
  var CTATLogicTreeNode, slice = [].slice;
  CTATLogicTreeNode = function() {
    CTATLogicTreeNode.operators = [["CONST"], ["VAR"], ["NOT"], ["AND", "NAND"], ["OR", "NOR"], ["IF"], ["IFF", "XOR"]];
    CTATLogicTreeNode.operatorStrings = {"NOT":"\u00ac", "AND":"\u2227", "OR":"\u2228", "NAND":"\u22bc", "NOR":"\u22bd", "XOR":"\u2295", "IF":"\u2192", "IFF":"\u2194", "true":"\u22a4", "false":"\u22a5"};
    CTATLogicTreeNode.toOperatorString = function(operator) {
      return this.operatorStrings[operator] || "";
    };
    CTATLogicTreeNode.diff = function(list1, list2) {
      return list1.filter(function(item) {
        return !list2.includes(item);
      });
    };
    CTATLogicTreeNode.uniq = function(list) {
      return slice.call(new Set(list));
    };
    CTATLogicTreeNode.removeIndex = function(list, index) {
      var ref;
      list = list.slice(0);
      [].splice.apply(list, [index, index - index + 1].concat(ref = [])), ref;
      return list;
    };
    CTATLogicTreeNode.difference = function(list1, list2) {
      return list1.filter(function(tree) {
        return !list2.some(function(tree2) {
          return tree2 === tree;
        });
      });
    };
    CTATLogicTreeNode.intersection = function(lists) {
      return lists[0].filter(function(tree) {
        return lists.every(function(list) {
          return list.some(function(tree2) {
            return tree2.equals(tree);
          });
        });
      });
    };
    CTATLogicTreeNode.commonLength = function(lists) {
      var length;
      length = null;
      return lists.every(function(list) {
        return (length != null ? length : length = list.length) === list.length;
      }) && length;
    };
    CTATLogicTreeNode.sameNegation = function(terms) {
      return terms.length === 2 && terms[0].negationNode() === terms[1].negationNode();
    };
    CTATLogicTreeNode.oppositeNegation = function(terms) {
      return terms.length === 2 && terms[0].negationNode() !== terms[1].negationNode();
    };
    CTATLogicTreeNode.replaceTerms = function(list, pairs, inverse) {
      var i, len, pair, results, term;
      results = [];
      for (i = 0, len = list.length;i < len;i++) {
        term = list[i];
        if (!(pair = pairs.find(function(pair) {
          return pair[0] === term;
        })) || inverse && (term = term.junctionNode(this.removeIndex(term.terms, pair[1])))) {
          results.push(term);
        }
      }
      return results;
    };
    function CTATLogicTreeNode() {
      var ref, ref1;
      if (this.string != null) {
        CTATLogicTreeNode.operatorStrings[(ref = this.value) != null ? ref : this.operator] = this.string;
      } else {
        this.string = CTATLogicTreeNode.operatorStrings[(ref1 = this.value) != null ? ref1 : this.operator];
      }
    }
    CTATLogicTreeNode.prototype.addOperand = function(operator, operand, string) {
      if (string == null) {
        string = null;
      }
      return new CTATLogicFlattenNode(operator, [this, operand], string);
    };
    CTATLogicTreeNode.prototype.setParens = function() {
      this.parens = true;
      return this;
    };
    CTATLogicTreeNode.prototype.checkParens = function() {
      var ref;
      return (ref = this.operator) === "NOT" || ref === "VAR" || ref === "CONST" || this.parens;
    };
    CTATLogicTreeNode.prototype.toString = function(string, parenthesized, node, other) {
      if (parenthesized == null) {
        parenthesized = false;
      }
      if (node == null) {
        node = null;
      }
      if (other == null) {
        other = false;
      }
      if (this.addParens(parenthesized, node, other)) {
        string = "(" + string + ")";
      }
      if (this.negated) {
        string = "" + CTATLogicTreeNode.operatorStrings["NOT"] + string;
      }
      return string;
    };
    CTATLogicTreeNode.prototype.addParens = function(parenthesized, node, other) {
      return (this.left != null || this.terms != null) && node != null && (parenthesized || this.precedence() > node.precedence() || other && this.precedence() === node.precedence());
    };
    CTATLogicTreeNode.prototype.operatorString = function() {
      return "" + (this.binaryOp() ? " " : "") + this.string + (this.binaryOp() ? " " : "");
    };
    CTATLogicTreeNode.prototype.evaluate = function(value) {
      if (this.negated) {
        return applyOperator("NOT", value);
      } else {
        return value;
      }
    };
    CTATLogicTreeNode.prototype.applyOperator = function(operator, operand1, operand2) {
      switch(operator) {
        case "NOT":
          if (operand1 != null) {
            return !operand1;
          } else {
            return void 0;
          }
        ;
        case "AND":
          if (operand1 != null) {
            return operand1 && operand2;
          } else {
            return operand2 && operand1;
          }
        ;
        case "OR":
          if (operand1 != null) {
            return operand1 || operand2;
          } else {
            return operand2 || operand1;
          }
        ;
      }
    };
    CTATLogicTreeNode.prototype.equals = function(node, inverse) {
      return node && this.operator === node.operator && inverse !== (this.negated === node.negated);
    };
    CTATLogicTreeNode.prototype.inverse = function(node) {
      if (this.negationOp()) {
        return this.right.equals(node);
      } else {
        if (node.negationOp()) {
          return this.equals(node.right);
        } else {
          return false;
        }
      }
    };
    CTATLogicTreeNode.prototype.subEquals = function(expression, index) {
      return false;
    };
    CTATLogicTreeNode.prototype.subNode = function(start, end) {
      return this;
    };
    CTATLogicTreeNode.prototype.countOperands = function() {
      return 0;
    };
    CTATLogicTreeNode.prototype.getOperator = function(string) {
      if (string == null) {
        string = false;
      }
      return !string && this.operator || this.string;
    };
    CTATLogicTreeNode.prototype.getOperators = function(string) {
      if (string == null) {
        string = false;
      }
      return [];
    };
    CTATLogicTreeNode.prototype.getVariables = function() {
      return [];
    };
    CTATLogicTreeNode.prototype.getOperands = function() {
      return [];
    };
    CTATLogicTreeNode.prototype.getExpression = function(start, end) {
      if (start == null) {
        start = 0;
      }
      if (end == null) {
        end = this.countOperands() - 1;
      }
      return end <= this.countOperands() - 1 && end - start >= 1 && this.subNode(start, end + 1) || null;
    };
    CTATLogicTreeNode.prototype.findOperator = function(operator, path, index, subexpressions) {
      var end, ref, start;
      if (index == null) {
        index = null;
      }
      if (subexpressions == null) {
        subexpressions = "none";
      }
      if (!index && this.operator === operator && (this.terms == null || this.terms.length === 2 || subexpressions === "none")) {
        return [Object.assign(this, {path:path})];
      } else {
        if (index != null && this.operator === operator && subexpressions !== "none") {
          ref = subexpressions === "left" ? [0, index + 2] : [index, this.terms.length], start = ref[0], end = ref[1];
          return [Object.assign(this.subNode(start, end), {path:path.concat([[start, end]])})];
        } else {
          return [];
        }
      }
    };
    CTATLogicTreeNode.prototype.findExpression = function(expression, path, index) {
      var end;
      if (index == null) {
        index = null;
      }
      if (!index && this.equals(expression)) {
        return [Object.assign(this, {path:path})];
      } else {
        if (index != null && this.subEquals(expression, index)) {
          return [Object.assign(this.subNode(index, end = index + expression.terms.length), {path:path.concat([[index, end]])})];
        } else {
          return [];
        }
      }
    };
    CTATLogicTreeNode.prototype.findRule = function(rule, path, reverse, index) {
      if (reverse == null) {
        reverse = false;
      }
      if (index == null) {
        index = null;
      }
      if (!index && this.testRule(rule, reverse)) {
        return [Object.assign(this, {path:path})];
      } else {
        if (index != null && this.testRule(rule, reverse, index)) {
          return [Object.assign(this.subNode(index, index + 2), {path:path.concat([[index, index + 2]])})];
        } else {
          return [];
        }
      }
    };
    CTATLogicTreeNode.prototype.createExpression = function() {
      var expressions, operator;
      operator = arguments[0], expressions = 2 <= arguments.length ? slice.call(arguments, 1) : [];
      switch(operator) {
        case "NAND":
        ;
        case "NOR":
        ;
        case "XOR":
        ;
        case "IF":
        ;
        case "IFF":
          return expressions[0] && new CTATLogicRelationNode(operator, this, expressions[0]) || null;
        case "AND":
        ;
        case "OR":
          return expressions.unshift(this) > 1 && new CTATLogicFlattenNode(operator, expressions) || null;
        case "NOT":
          return new CTATLogicRelationNode(operator, null, this);
      }
    };
    CTATLogicTreeNode.prototype.replaceExpression = function(oldSubexpression, newSubexpression, locator) {
      var expression, ref, ref1, ref2, selector;
      if (typeof locator === "number" && (oldSubexpression = this.findExpression(oldSubexpression, [])[locator])) {
        locator = oldSubexpression.path;
        delete oldSubexpression.path;
      }
      if ((locator != null ? locator.length : void 0) === 0) {
        return newSubexpression;
      } else {
        if ((selector = locator != null ? locator.shift() : void 0) != null) {
          expression = this.clone(false);
          if (typeof selector === "string") {
            expression[selector] = (ref = this[selector]) != null ? ref.replaceExpression(oldSubexpression, newSubexpression, locator) : void 0;
            return expression;
          } else {
            if (typeof selector === "number") {
              expression.terms = expression.terms.slice(0);
              expression.terms[selector] = (ref1 = this.terms[selector]) != null ? ref1.replaceExpression(oldSubexpression, newSubexpression, locator) : void 0;
              return expression;
            } else {
              if (typeof selector === "object") {
                expression.terms = expression.terms.slice(0);
                [].splice.apply(expression.terms, [ref2 = selector[0], selector[1] - ref2].concat(newSubexpression)), newSubexpression;
                return expression;
              } else {
                return this;
              }
            }
          }
        }
      }
    };
    CTATLogicTreeNode.prototype.deleteExpression = function(subexpression, locator) {
      var expression, ref, ref1, ref2, selector;
      if (typeof locator === "number" && (subexpression = this.findExpression(subexpression, [])[locator])) {
        locator = subexpression.path;
        delete subexpression.path;
      }
      if ((locator != null ? locator.length : void 0) === 0) {
        return null;
      } else {
        if ((selector = locator != null ? locator.shift() : void 0) != null) {
          expression = this.clone(false);
          if (typeof selector === "string") {
            expression[selector] = (ref = this[selector]) != null ? ref.deleteExpression(subexpression, locator) : void 0;
            return expression.removeNull();
          } else {
            if (typeof selector === "number") {
              expression.terms = expression.terms.slice(0);
              expression.terms[selector] = (ref1 = this.terms[selector]) != null ? ref1.deleteExpression(subexpression, locator) : void 0;
              return expression.removeNull();
            } else {
              if (typeof selector === "object") {
                expression.terms = expression.terms.slice(0);
                [].splice.apply(expression.terms, [ref2 = selector[0], selector[1] - ref2].concat(null)), null;
                return expression.removeNull();
              } else {
                return this;
              }
            }
          }
        }
      }
    };
    CTATLogicTreeNode.prototype.removeNull = function() {
      return this;
    };
    CTATLogicTreeNode.prototype.applyTests = function(tests) {
      return tests.every(function(_this) {
        return function(test) {
          var result;
          result = _this[test]();
          return result;
        };
      }(this));
    };
    CTATLogicTreeNode.prototype.applyRules = function(rules, reverse, global) {
      var result;
      if (reverse == null) {
        reverse = false;
      }
      if (global == null) {
        global = false;
      }
      result = (typeof rules === "string" ? [rules] : rules).reduce(function(result, rule) {
        result.rules = rules;
        result = result[rule](reverse);
        return result;
      }, this);
      delete result.rules;
      return result;
    };
    CTATLogicTreeNode.prototype.testRule = function(rule, reverse, index) {
      if (reverse == null) {
        reverse = false;
      }
      if (index == null) {
        index = null;
      }
      return this.subNode(index)[rule](reverse, true);
    };
    CTATLogicTreeNode.prototype.findCounterExample = function(expression) {
      return this.checkExpressions(expression, CTATLogicTreeNode.uniq(this.getVariables().concat(expression.getVariables())), {});
    };
    CTATLogicTreeNode.prototype.checkExpressions = function(expression, variables, bindings) {
      var obj, obj1;
      if (variables.length) {
        return this.checkExpressions(expression, variables.slice(1), Object.assign(bindings, (obj = {}, obj["" + variables[0]] = true, obj))) || this.checkExpressions(expression, variables.slice(1), Object.assign(bindings, (obj1 = {}, obj1["" + variables[0]] = false, obj1)));
      } else {
        if (this.evaluate(bindings) !== expression.evaluate(bindings)) {
          return bindings;
        }
      }
    };
    CTATLogicTreeNode.prototype.truth = function(reverse, test) {
      if (reverse == null) {
        reverse = false;
      }
      if (test == null) {
        test = false;
      }
      return !test && this;
    };
    CTATLogicTreeNode.prototype.domination = function(reverse, test) {
      if (reverse == null) {
        reverse = false;
      }
      if (test == null) {
        test = false;
      }
      return !test && this;
    };
    CTATLogicTreeNode.prototype.negation = function(reverse, test) {
      if (reverse == null) {
        reverse = false;
      }
      if (test == null) {
        test = false;
      }
      return !test && this;
    };
    CTATLogicTreeNode.prototype.identity = function(reverse, test) {
      if (reverse == null) {
        reverse = false;
      }
      if (test == null) {
        test = false;
      }
      if (reverse) {
        return test || new CTATLogicFlattenNode("OR", this, new CTATLogicConstantNode(true));
      } else {
        return !test && this;
      }
    };
    CTATLogicTreeNode.prototype.idempotence = function(reverse, test) {
      if (reverse == null) {
        reverse = false;
      }
      if (test == null) {
        test = false;
      }
      if (reverse) {
        return test || new CTATLogicFlattenNode("OR", [this, this]);
      } else {
        return !test && this;
      }
    };
    CTATLogicTreeNode.prototype.absorption = function(reverse, test) {
      if (reverse == null) {
        reverse = false;
      }
      if (test == null) {
        test = false;
      }
      return !test && this;
    };
    CTATLogicTreeNode.prototype.inverseAbsorption = function(reverse, test) {
      if (reverse == null) {
        reverse = false;
      }
      if (test == null) {
        test = false;
      }
      return !test && this;
    };
    CTATLogicTreeNode.prototype.commutativity = function(reverse, test) {
      if (reverse == null) {
        reverse = false;
      }
      if (test == null) {
        test = false;
      }
      return !test && this;
    };
    CTATLogicTreeNode.prototype.associativity = function(reverse, test) {
      if (reverse == null) {
        reverse = false;
      }
      if (test == null) {
        test = false;
      }
      return !test && this;
    };
    CTATLogicTreeNode.prototype.distributivity = function(reverse, test) {
      if (reverse == null) {
        reverse = false;
      }
      if (test == null) {
        test = false;
      }
      return !test && this;
    };
    CTATLogicTreeNode.prototype.deMorgan = function(reverse, test) {
      if (reverse == null) {
        reverse = false;
      }
      if (test == null) {
        test = false;
      }
      return !test && this;
    };
    CTATLogicTreeNode.prototype.doubleNegation = function(reverse, test) {
      if (reverse == null) {
        reverse = false;
      }
      if (test == null) {
        test = false;
      }
      if (reverse && !this.negationOp()) {
        return test || this.negateNode().negateNode();
      } else {
        return !test && this;
      }
    };
    CTATLogicTreeNode.prototype.implication = function(reverse, test) {
      if (reverse == null) {
        reverse = false;
      }
      if (test == null) {
        test = false;
      }
      return !test && this;
    };
    CTATLogicTreeNode.prototype.biimplication = function(reverse, test) {
      if (reverse == null) {
        reverse = false;
      }
      if (test == null) {
        test = false;
      }
      return !test && this;
    };
    CTATLogicTreeNode.prototype.biimplicationToImplication = function(reverse, test) {
      if (reverse == null) {
        reverse = false;
      }
      if (test == null) {
        test = false;
      }
      return !test && this;
    };
    CTATLogicTreeNode.prototype.exclusiveDisjunction = function(reverse, test) {
      if (reverse == null) {
        reverse = false;
      }
      if (test == null) {
        test = false;
      }
      return !test && this;
    };
    CTATLogicTreeNode.prototype.exclusiveDisjunctionToImplication = function(reverse, test) {
      if (reverse == null) {
        reverse = false;
      }
      if (test == null) {
        test = false;
      }
      return !test && this;
    };
    CTATLogicTreeNode.prototype.findPairs = function(operator, list, func) {
      var i, index2, len, results, term;
      results = [];
      for (i = 0, len = list.length;i < len;i++) {
        term = list[i];
        if (term.operator === operator && (index2 = term.terms.findIndex(function(_this) {
          return function(term2) {
            return term2[func](_this);
          };
        }(this))) !== -1) {
          results.push([term, index2]);
        }
      }
      return results;
    };
    CTATLogicTreeNode.prototype.normalFormOperators = function() {
      var ref;
      return (ref = this.operator) === "NOT" || ref === "AND" || ref === "OR" || ref === "VAR" || ref === "CONST";
    };
    CTATLogicTreeNode.prototype.atomicNegation = function() {
      return true;
    };
    CTATLogicTreeNode.prototype.atomicConjunction = function() {
      return true;
    };
    CTATLogicTreeNode.prototype.atomicDisjunction = function() {
      return true;
    };
    CTATLogicTreeNode.prototype.replaceNodes = function() {
      return this;
    };
    CTATLogicTreeNode.prototype.flatten = function() {
      return this;
    };
    CTATLogicTreeNode.prototype.pushNegation = function() {
      return this;
    };
    CTATLogicTreeNode.prototype.distributeDisjunction = function() {
      return this;
    };
    CTATLogicTreeNode.prototype.distributeConjunction = function() {
      return this;
    };
    CTATLogicTreeNode.prototype.sort = function() {
      return this;
    };
    CTATLogicTreeNode.prototype.absorb = function() {
      return this;
    };
    CTATLogicTreeNode.prototype.compare = function(node) {
      return Math.sign(this.countLevels() - node.countLevels() || this.precedence(true) - node.precedence(true) || this.countVariables() - node.countVariables());
    };
    CTATLogicTreeNode.prototype.compareNegations = function(node) {
      return this.negationNode() - node.negationNode();
    };
    CTATLogicTreeNode.prototype.precedence = function(sort) {
      if (sort == null) {
        sort = false;
      }
      return CTATLogicTreeNode.operators.findIndex(function(_this) {
        return function(group) {
          return group.includes(_this.operator);
        };
      }(this));
    };
    CTATLogicTreeNode.prototype.countVariables = function() {
      return 0;
    };
    CTATLogicTreeNode.prototype.countLevels = function() {
      return 0;
    };
    CTATLogicTreeNode.prototype.invertOperator = function() {
      this.operator = this.inverseOperator();
      this.string = CTATLogicTreeNode.operatorStrings[this.operator];
      return this;
    };
    CTATLogicTreeNode.prototype.inverseOperator = function() {
      if (this.conjunctionOp()) {
        return "OR";
      } else {
        if (this.disjunctionOp()) {
          return "AND";
        } else {
          return this.operator;
        }
      }
    };
    CTATLogicTreeNode.prototype.negateNode = function() {
      return new CTATLogicRelationNode("NOT", null, this);
    };
    CTATLogicTreeNode.prototype.unnegateNode = function() {
      if (this.negationOp()) {
        return this.right;
      } else {
        return this;
      }
    };
    CTATLogicTreeNode.prototype.unnegateOperator = function() {
      if (this.negativeConjunctionOp()) {
        return "AND";
      } else {
        if (this.negativeDisjunctionOp()) {
          return "OR";
        } else {
          return this.operator;
        }
      }
    };
    CTATLogicTreeNode.prototype.negationNode = function() {
      return this.negationOp() && !this.right.negationNode() || this.negated;
    };
    CTATLogicTreeNode.prototype.negate = function() {
      if (this.negated) {
        this.setSteps(this.steps + 1);
      }
      this.negated = !this.negated;
      return this;
    };
    CTATLogicTreeNode.prototype.setSteps = function(count) {
      if (!isNaN(count)) {
        this.steps = count;
      }
      return this;
    };
    CTATLogicTreeNode.prototype.atomic = function() {
      var ref, ref1;
      return (ref = this.operator) === "VAR" || ref === "CONST" || this.operator === "NOT" && ((ref1 = this.right.operator) === "VAR" || ref1 === "CONST");
    };
    CTATLogicTreeNode.prototype.negationOp = function() {
      return this.operator === "NOT";
    };
    CTATLogicTreeNode.prototype.conjunctionOp = function() {
      return this.operator === "AND";
    };
    CTATLogicTreeNode.prototype.disjunctionOp = function() {
      return this.operator === "OR";
    };
    CTATLogicTreeNode.prototype.negativeConjunctionOp = function() {
      return this.operator === "NAND";
    };
    CTATLogicTreeNode.prototype.negativeDisjunctionOp = function() {
      return this.operator === "NOR";
    };
    CTATLogicTreeNode.prototype.junctionOp = function() {
      var ref;
      return (ref = this.operator) === "AND" || ref === "OR";
    };
    CTATLogicTreeNode.prototype.negativeJunctionOp = function() {
      var ref;
      return (ref = this.operator) === "NAND" || ref === "NOR";
    };
    CTATLogicTreeNode.prototype.exclusiveDisjunctionOp = function() {
      return this.operator === "XOR";
    };
    CTATLogicTreeNode.prototype.implicationOp = function() {
      return this.operator === "IF";
    };
    CTATLogicTreeNode.prototype.biimplicationOp = function() {
      return this.operator === "IFF";
    };
    CTATLogicTreeNode.prototype.binaryOp = function() {
      var ref;
      return (ref = this.operator) === "AND" || ref === "OR" || ref === "NAND" || ref === "NOR" || ref === "IF" || ref === "IFF" || ref === "XOR";
    };
    CTATLogicTreeNode.prototype.constant = function(value) {
      if (value == null) {
        value = null;
      }
      return false;
    };
    return CTATLogicTreeNode;
  }();
  if (typeof module !== "undefined" && module !== null) {
    module.exports = CTATLogicTreeNode;
  } else {
    this.CTATLogicTreeNode = CTATLogicTreeNode;
  }
}).call(this);
goog.provide("CTATLogicRelationNode");
goog.require("CTATLogicTreeNode");
(function() {
  var CTATLogicRelationNode, extend = function(child, parent) {
    for (var key in parent) {
      if (hasProp.call(parent, key)) {
        child[key] = parent[key];
      }
    }
    function ctor() {
      this.constructor = child;
    }
    ctor.prototype = parent.prototype;
    child.prototype = new ctor;
    child.__super__ = parent.prototype;
    return child;
  }, hasProp = {}.hasOwnProperty;
  CTATLogicRelationNode = function(superClass) {
    extend(CTATLogicRelationNode, superClass);
    function CTATLogicRelationNode(operator1, left1, right1, string1, negated) {
      this.operator = operator1;
      this.left = left1;
      this.right = right1;
      this.string = string1 != null ? string1 : null;
      this.negated = negated != null ? negated : false;
      CTATLogicRelationNode.__super__.constructor.apply(this, arguments);
    }
    CTATLogicRelationNode.prototype.clone = function(deep) {
      var ref;
      if (deep == null) {
        deep = true;
      }
      return new CTATLogicRelationNode(this.operator, deep ? ((ref = this.left) != null ? ref.clone() : void 0) || null : this.left, deep ? this.right.clone() : this.right, this.string, this.negated);
    };
    CTATLogicRelationNode.prototype.toString = function(parenthesized, node, other) {
      var ref, ref1, ref2;
      if (parenthesized == null) {
        parenthesized = false;
      }
      if (node == null) {
        node = null;
      }
      if (other == null) {
        other = false;
      }
      return CTATLogicRelationNode.__super__.toString.call(this, "" + (((ref = this.left) != null ? ref.toString(parenthesized, this, (ref1 = this.operator) === "IF" || ref1 === "IFF" || ref1 === "XOR") : void 0) || "") + ("" + this.operatorString()) + this.right.toString(parenthesized, this, (ref2 = this.operator) === "AND" || ref2 === "NAND" || ref2 === "OR" || ref2 === "NOR"), parenthesized, node, other);
    };
    CTATLogicRelationNode.prototype.evaluate = function(bindings) {
      var left, ref, right;
      if (bindings == null) {
        bindings = null;
      }
      left = (ref = this.left) != null ? ref.evaluate(bindings) : void 0;
      right = this.right.evaluate(bindings);
      return CTATLogicRelationNode.__super__.evaluate.call(this, function() {
        switch(this.operator) {
          case "NOT":
            return this.applyOperator("NOT", right);
          case "NAND":
            return this.applyOperator("NOT", this.applyOperator("AND", left, right));
          case "NOR":
            return this.applyOperator("NOT", this.applyOperator("OR", left, right));
          case "IF":
            return this.applyOperator("OR", this.applyOperator("NOT", left), right);
          case "IFF":
            return this.applyOperator("OR", this.applyOperator("AND", left, right), this.applyOperator("AND", this.applyOperator("NOT", left), this.applyOperator("NOT", right)));
          case "XOR":
            return this.applyOperator("OR", this.applyOperator("AND", left, this.applyOperator("NOT", right)), this.applyOperator("AND", this.applyOperator("NOT", left), right));
        }
      }.call(this));
    };
    CTATLogicRelationNode.prototype.equals = function(node, inverse) {
      return CTATLogicRelationNode.__super__.equals.call(this, node, inverse) && (this.left == null || this.left.equals(node.left, false)) && this.right.equals(node.right, false);
    };
    CTATLogicRelationNode.prototype.countOperands = function() {
      return 2;
    };
    CTATLogicRelationNode.prototype.getOperators = function(string) {
      var ref, ref1;
      if (string == null) {
        string = false;
      }
      return ((ref = (ref1 = this.left) != null ? ref1.getOperators(string) : void 0) != null ? ref : []).concat(this.getOperator(string), this.right.getOperators(string));
    };
    CTATLogicRelationNode.prototype.getVariables = function() {
      var ref, ref1;
      return ((ref = (ref1 = this.left) != null ? ref1.getVariables() : void 0) != null ? ref : []).concat(this.right.getVariables());
    };
    CTATLogicRelationNode.prototype.getOperands = function() {
      if (this.left != null) {
        return [this.left, this.right];
      } else {
        return [this.right];
      }
    };
    CTATLogicRelationNode.prototype.findOperator = function(operator, path, subexpressions) {
      var ref, ref1;
      if (subexpressions == null) {
        subexpressions = "none";
      }
      return ((ref = (ref1 = this.left) != null ? ref1.findOperator(operator, path.concat(["left"]), subexpressions) : void 0) != null ? ref : []).concat(CTATLogicRelationNode.__super__.findOperator.call(this, operator, path, null, subexpressions), this.right.findOperator(operator, path.concat(["right"]), subexpressions));
    };
    CTATLogicRelationNode.prototype.findExpression = function(expression, path) {
      var ref, ref1;
      return ((ref = (ref1 = this.left) != null ? ref1.findExpression(expression, path.concat(["left"])) : void 0) != null ? ref : []).concat(CTATLogicRelationNode.__super__.findExpression.call(this, expression, path), this.right.findExpression(expression, path.concat(["right"])));
    };
    CTATLogicRelationNode.prototype.findRule = function(rule, path, reverse) {
      var ref, ref1;
      if (reverse == null) {
        reverse = false;
      }
      return ((ref = (ref1 = this.left) != null ? ref1.findRule(rule, path.concat(["left"]), reverse) : void 0) != null ? ref : []).concat(CTATLogicRelationNode.__super__.findRule.call(this, rule, path, reverse), this.right.findRule(rule, path.concat(["right"]), reverse));
    };
    CTATLogicRelationNode.prototype.removeNull = function() {
      var ref, ref1;
      this.left = (ref = this.left) != null ? ref.removeNull() : void 0;
      this.right = (ref1 = this.right) != null ? ref1.removeNull() : void 0;
      if (this.left != null && this.right != null) {
        return this;
      } else {
        return this.left || this.right || null;
      }
    };
    CTATLogicRelationNode.prototype.applyRules = function(rules1, reverse, global) {
      var ref, ref1, ref2;
      this.rules = rules1;
      if (reverse == null) {
        reverse = false;
      }
      if (global == null) {
        global = false;
      }
      if (global) {
        this.left = ((ref = this.left) != null ? (ref1 = ref.setSteps(this.steps)) != null ? ref1.applyRules(this.rules, reverse, true) : void 0 : void 0) || null;
        this.right = this.right.setSteps(((ref2 = this.left) != null ? ref2.steps : void 0) || this.steps).applyRules(this.rules, reverse, true);
        this.setSteps(this.right.steps);
      }
      return CTATLogicRelationNode.__super__.applyRules.apply(this, arguments);
    };
    CTATLogicRelationNode.prototype.truth = function(reverse, test) {
      if (reverse == null) {
        reverse = false;
      }
      if (test == null) {
        test = false;
      }
      if (!reverse && this.negationOp() && this.right.constant()) {
        return test || this.right.clone().negate();
      } else {
        return !test && this;
      }
    };
    CTATLogicRelationNode.prototype.deMorgan = function(reverse, test) {
      if (reverse == null) {
        reverse = false;
      }
      if (test == null) {
        test = false;
      }
      if (!reverse && this.negationOp() && this.right.junctionOp()) {
        return test || this.right.reverseNode();
      } else {
        return !test && this;
      }
    };
    CTATLogicRelationNode.prototype.doubleNegation = function(reverse, test) {
      if (reverse == null) {
        reverse = false;
      }
      if (test == null) {
        test = false;
      }
      if (!reverse && this.negationOp() && this.right.negationOp()) {
        return test || this.unnegateNode().unnegateNode();
      } else {
        return CTATLogicRelationNode.__super__.doubleNegation.apply(this, arguments);
      }
    };
    CTATLogicRelationNode.prototype.negativeConjunction = function(reverse, test) {
      if (reverse == null) {
        reverse = false;
      }
      if (test == null) {
        test = false;
      }
      if (!reverse && this.negativeConjunctionOp()) {
        return test || (new CTATLogicFlattenNode("AND", [this.left, this.right])).negateNode();
      } else {
        if (reverse && this.negationOp() && this.right.conjunctionOp() && this.right.terms.length === 2) {
          return test || new CTATLogicRelationNode("NAND", this.right.terms[0], this.right.terms[1]);
        } else {
          return !test && this;
        }
      }
    };
    CTATLogicRelationNode.prototype.negativeDisjunction = function(reverse, test) {
      if (reverse == null) {
        reverse = false;
      }
      if (test == null) {
        test = false;
      }
      if (!reverse && this.negativeDisjunctionOp()) {
        return test || (new CTATLogicFlattenNode("OR", [this.left, this.right])).negateNode();
      } else {
        if (reverse && this.negationOp() && this.right.disjunctionOp() && this.right.terms.length === 2) {
          return test || new CTATLogicRelationNode("NOR", this.right.terms[0], this.right.terms[1]);
        } else {
          return !test && this;
        }
      }
    };
    CTATLogicRelationNode.prototype.implication = function(reverse, test) {
      if (reverse == null) {
        reverse = false;
      }
      if (test == null) {
        test = false;
      }
      if (!reverse && this.implicationOp()) {
        return test || new CTATLogicFlattenNode("OR", [this.left.negateNode(), this.right]);
      } else {
        return !test && this;
      }
    };
    CTATLogicRelationNode.prototype.biimplication = function(reverse, test) {
      if (reverse == null) {
        reverse = false;
      }
      if (test == null) {
        test = false;
      }
      if (!reverse && this.biimplicationOp()) {
        return test || new CTATLogicFlattenNode("OR", [new CTATLogicFlattenNode("AND", [this.left, this.right]), new CTATLogicFlattenNode("AND", [this.left.negateNode(), this.right.negateNode()])]);
      } else {
        return !test && this;
      }
    };
    CTATLogicRelationNode.prototype.biimplicationToImplication = function(reverse, test) {
      if (reverse == null) {
        reverse = false;
      }
      if (test == null) {
        test = false;
      }
      if (!reverse && this.biimplicationOp()) {
        return test || new CTATLogicFlattenNode("AND", [new CTATLogicRelationNode("IF", this.left, this.right), new CTATLogicRelationNode("IF", this.right, this.left)]);
      } else {
        return !test && this;
      }
    };
    CTATLogicRelationNode.prototype.exclusiveDisjunction = function(reverse, test) {
      if (reverse == null) {
        reverse = false;
      }
      if (test == null) {
        test = false;
      }
      if (!reverse && this.exclusiveDisjunctionOp()) {
        return test || new CTATLogicFlattenNode("OR", [new CTATLogicFlattenNode("AND", [this.left, this.right.negateNode()]), new CTATLogicFlattenNode("AND", [this.left.negateNode(), this.right])]);
      } else {
        return !test && this;
      }
    };
    CTATLogicRelationNode.prototype.exclusiveDisjunctionToImplication = function(reverse, test) {
      if (reverse == null) {
        reverse = false;
      }
      if (test == null) {
        test = false;
      }
      if (!reverse && this.exclusiveDisjunctionOp()) {
        return test || new CTATLogicFlattenNode("AND", [new CTATLogicRelationNode("IF", this.left, this.right.negateNode()), new CTATLogicRelationNode("IF", this.right.negateNode(), this.left)]);
      } else {
        return !test && this;
      }
    };
    CTATLogicRelationNode.prototype.normalFormOperators = function() {
      return CTATLogicRelationNode.__super__.normalFormOperators.apply(this, arguments) && (this.left == null || this.left.normalFormOperators()) && this.right.normalFormOperators();
    };
    CTATLogicRelationNode.prototype.atomicNegation = function() {
      return this.atomic() || !this.negationOp() && !this.negated && this.left.atomicNegation() && this.right.atomicNegation();
    };
    CTATLogicRelationNode.prototype.atomicConjunction = function() {
      return this.atomic() || (this.left == null || this.left.atomicConjunction()) && this.right.atomicConjunction();
    };
    CTATLogicRelationNode.prototype.atomicDisjunction = function() {
      return this.atomic() || (this.left == null || this.left.atomicDisjunction()) && this.right.atomicDisjunction();
    };
    CTATLogicRelationNode.prototype.replaceNodes = function() {
      var left, node, right, rules;
      rules = CTATLogicTreeNode.diff(this.rules, ["replaceNodes"]);
      switch(this.operator) {
        case "NOT":
          return this.right.setSteps(this.steps).negate();
        case "NAND":
        ;
        case "NOR":
          return (new CTATLogicFlattenNode(this.unnegateOperator(), [this.left, this.right])).setSteps(this.steps + 1).negate().applyRules(rules);
        case "IF":
          return (new CTATLogicFlattenNode("OR", [left = this.left.setSteps(this.steps).negate().applyRules(rules), this.right])).setSteps(left.steps + 1);
        case "IFF":
          node = new CTATLogicFlattenNode("OR", [new CTATLogicFlattenNode("AND", [this.left, this.right]), new CTATLogicFlattenNode("AND", [left = this.left.clone().setSteps(this.steps).negate().applyRules(rules), right = this.right.clone().setSteps(left.steps).negate().applyRules(rules)])]);
          node.setSteps(right.steps).terms = node.terms.map(function(_this) {
            return function(term) {
              term = term.setSteps(node.steps).applyRules(rules);
              node.setSteps(term.steps);
              return term;
            };
          }(this));
          return node.setSteps(node.steps + 1);
        case "XOR":
          node = new CTATLogicFlattenNode("OR", [new CTATLogicFlattenNode("AND", [this.left, right = this.right.clone().setSteps(this.steps).negate().applyRules(rules)]), new CTATLogicFlattenNode("AND", [left = this.left.clone().setSteps(right.steps).negate().applyRules(rules), this.right])]);
          node.setSteps(left.steps).terms = node.terms.map(function(_this) {
            return function(term) {
              term = term.setSteps(node.steps).applyRules(rules);
              node.setSteps(term.steps);
              return term;
            };
          }(this));
          return node.setSteps(node.steps + 1);
      }
    };
    CTATLogicRelationNode.prototype.sort = function() {
      var ref, ref1;
      if (((ref = this.operator) === "NAND" || ref === "NOR" || ref === "IFF" || ref === "XOR") && this.left.compare(this.right) > 0) {
        ref1 = [this.right, this.left], this.left = ref1[0], this.right = ref1[1];
      }
      return this;
    };
    CTATLogicRelationNode.prototype.compare = function(node) {
      return CTATLogicRelationNode.__super__.compare.apply(this, arguments) || (this.operator === "NOT" && node.operator === "NOT" ? this.right.compare(node.right) : this.operator === "NOT" ? this.right.compare(node) : node.operator === "NOT" ? this.compare(node.right) : this.left.compare(node.left) || this.right.compare(node.right)) || this.compareNegations(node);
    };
    CTATLogicRelationNode.prototype.precedence = function(sort) {
      if (sort == null) {
        sort = false;
      }
      if (sort && this.operator === "NOT") {
        return this.right.precedence();
      } else {
        return CTATLogicRelationNode.__super__.precedence.apply(this, arguments);
      }
    };
    CTATLogicRelationNode.prototype.countVariables = function() {
      var ref;
      return (((ref = this.left) != null ? ref.countVariables() : void 0) || 0) + this.right.countVariables();
    };
    CTATLogicRelationNode.prototype.countLevels = function() {
      var ref;
      if (this.operator === "NOT") {
        return this.right.countLevels();
      } else {
        return 1 + Math.max(((ref = this.left) != null ? ref.countLevels() : void 0) || 0, this.right.countLevels());
      }
    };
    return CTATLogicRelationNode;
  }(CTATLogicTreeNode);
  if (typeof module !== "undefined" && module !== null) {
    module.exports = CTATLogicRelationNode;
  } else {
    this.CTATLogicRelationNode = CTATLogicRelationNode;
  }
}).call(this);
goog.provide("CTATLogicVariableNode");
goog.require("CTATLogicTreeNode");
(function() {
  var CTATLogicVariableNode, extend = function(child, parent) {
    for (var key in parent) {
      if (hasProp.call(parent, key)) {
        child[key] = parent[key];
      }
    }
    function ctor() {
      this.constructor = child;
    }
    ctor.prototype = parent.prototype;
    child.prototype = new ctor;
    child.__super__ = parent.prototype;
    return child;
  }, hasProp = {}.hasOwnProperty;
  CTATLogicVariableNode = function(superClass) {
    extend(CTATLogicVariableNode, superClass);
    function CTATLogicVariableNode(variableTable, variable, negated) {
      this.variableTable = variableTable;
      this.variable = variable;
      this.negated = negated != null ? negated : false;
      this.operator = "VAR";
    }
    CTATLogicVariableNode.prototype.clone = function() {
      return new CTATLogicVariableNode(this.variableTable, this.variable, this.negated);
    };
    CTATLogicVariableNode.prototype.toString = function(parenthesized, node, other) {
      if (parenthesized == null) {
        parenthesized = false;
      }
      if (node == null) {
        node = null;
      }
      if (other == null) {
        other = false;
      }
      return CTATLogicVariableNode.__super__.toString.call(this, this.variable, parenthesized, node, other);
    };
    CTATLogicVariableNode.prototype.evaluate = function(bindings) {
      if (bindings == null) {
        bindings = null;
      }
      return CTATLogicVariableNode.__super__.evaluate.call(this, function() {
        if (bindings != null) {
          return (typeof bindings.get === "function" ? bindings.get(this.variable) : void 0) || bindings[this.variable];
        } else {
          if (this.variableTable != null) {
            return this.variableTable.get(this.variable);
          } else {
            try {
              return eval(this.variable);
            } catch (_error) {
            }
          }
        }
      }.call(this));
    };
    CTATLogicVariableNode.prototype.equals = function(node, inverse) {
      return CTATLogicVariableNode.__super__.equals.call(this, node, inverse) && this.variable === node.variable;
    };
    CTATLogicVariableNode.prototype.getVariables = function() {
      return [this.variable];
    };
    CTATLogicVariableNode.prototype.compare = function(node) {
      return CTATLogicVariableNode.__super__.compare.apply(this, arguments) || this.variable > node.variable && 1 || this.variable < node.variable && -1 || this.compareNegations(node);
    };
    CTATLogicVariableNode.prototype.countVariables = function() {
      return 1;
    };
    return CTATLogicVariableNode;
  }(CTATLogicTreeNode);
  if (typeof module !== "undefined" && module !== null) {
    module.exports = CTATLogicVariableNode;
  } else {
    this.CTATLogicVariableNode = CTATLogicVariableNode;
  }
}).call(this);
goog.provide("CTATLogicConstantNode");
goog.require("CTATLogicTreeNode");
(function() {
  var CTATLogicConstantNode, extend = function(child, parent) {
    for (var key in parent) {
      if (hasProp.call(parent, key)) {
        child[key] = parent[key];
      }
    }
    function ctor() {
      this.constructor = child;
    }
    ctor.prototype = parent.prototype;
    child.prototype = new ctor;
    child.__super__ = parent.prototype;
    return child;
  }, hasProp = {}.hasOwnProperty;
  CTATLogicConstantNode = function(superClass) {
    extend(CTATLogicConstantNode, superClass);
    function CTATLogicConstantNode(value1, string, negated) {
      this.value = value1;
      this.string = string != null ? string : null;
      this.negated = negated != null ? negated : false;
      (this.operator = "CONST") && CTATLogicConstantNode.__super__.constructor.apply(this, arguments);
    }
    CTATLogicConstantNode.prototype.clone = function() {
      return new CTATLogicConstantNode(this.value, this.string, this.negated);
    };
    CTATLogicConstantNode.prototype.toString = function(parenthesized, node, other) {
      if (parenthesized == null) {
        parenthesized = false;
      }
      if (node == null) {
        node = null;
      }
      if (other == null) {
        other = false;
      }
      return CTATLogicConstantNode.__super__.toString.call(this, this.string, parenthesized, node, other);
    };
    CTATLogicConstantNode.prototype.evaluate = function(bindings) {
      if (bindings == null) {
        bindings = null;
      }
      return CTATLogicConstantNode.__super__.evaluate.call(this, this.value);
    };
    CTATLogicConstantNode.prototype.equals = function(node, inverse) {
      return CTATLogicConstantNode.__super__.equals.call(this, node, inverse) && inverse !== (this.value === node.value);
    };
    CTATLogicConstantNode.prototype.truth = function(reverse, test) {
      if (reverse == null) {
        reverse = false;
      }
      if (test == null) {
        test = false;
      }
      if (reverse) {
        return test || this.negateNode();
      } else {
        return !test && this;
      }
    };
    CTATLogicConstantNode.prototype.compare = function(node) {
      return CTATLogicConstantNode.__super__.compare.apply(this, arguments) || this.value - node.value;
    };
    CTATLogicConstantNode.prototype.negate = function() {
      this.setSteps(this.steps + 1);
      this.value = !this.value;
      this.string = CTATLogicTreeNode.toOperatorString(this.value);
      return this;
    };
    CTATLogicConstantNode.prototype.constant = function(value) {
      if (value == null) {
        value = null;
      }
      return value == null || this.value === value;
    };
    return CTATLogicConstantNode;
  }(CTATLogicTreeNode);
  if (typeof module !== "undefined" && module !== null) {
    module.exports = CTATLogicConstantNode;
  } else {
    this.CTATLogicConstantNode = CTATLogicConstantNode;
  }
}).call(this);
goog.provide("CTATLogicGrammar");
goog.require("CTATLogicTreeNode");
goog.require("CTATLogicRelationNode");
goog.require("CTATLogicVariableNode");
goog.require("CTATLogicConstantNode");
var CTATLogicGrammar = function() {
  var o = function(k, v, o, l) {
    for (o = o || {}, l = k.length;l--;o[k[l]] = v) {
    }
    return o;
  }, $V0 = [1, 3], $V1 = [1, 5], $V2 = [1, 6], $V3 = [1, 7], $V4 = [1, 8], $V5 = [1, 10], $V6 = [1, 11], $V7 = [1, 12], $V8 = [1, 13], $V9 = [1, 14], $Va = [1, 15], $Vb = [1, 16], $Vc = [5, 6, 7, 8, 9, 10, 11, 12, 16], $Vd = [5, 7, 9, 10, 11, 12, 16];
  var parser = {trace:function trace() {
  }, yy:{}, symbols_:{"error":2, "expression":3, "logical":4, "EOF":5, "AND":6, "OR":7, "NAND":8, "NOR":9, "XOR":10, "IF":11, "IFF":12, "NOT":13, "atom":14, "LPAREN":15, "RPAREN":16, "VARIABLE":17, "TRUE":18, "FALSE":19, "$accept":0, "$end":1}, terminals_:{2:"error", 5:"EOF", 6:"AND", 7:"OR", 8:"NAND", 9:"NOR", 10:"XOR", 11:"IF", 12:"IFF", 13:"NOT", 15:"LPAREN", 16:"RPAREN", 17:"VARIABLE", 18:"TRUE", 19:"FALSE"}, productions_:[0, [3, 2], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 
  2], [4, 1], [14, 3], [14, 1], [14, 1], [14, 1]], performAction:function anonymous(yytext, yyleng, yylineno, yy, yystate, $$, _$) {
    var $0 = $$.length - 1;
    switch(yystate) {
      case 1:
        return $$[$0 - 1];
        break;
      case 2:
        yy.parser.checkStrict($$[$0 - 2], _$[$0 - 2], yy.lexer.matched);
        yy.parser.checkStrict($$[$0], _$[$0], yy.lexer.matched);
        this.$ = $$[$0 - 2].addOperand("AND", $$[$0], $$[$0 - 1]);
        break;
      case 3:
        yy.parser.checkStrict($$[$0 - 2], _$[$0 - 2], yy.lexer.matched);
        yy.parser.checkStrict($$[$0], _$[$0], yy.lexer.matched);
        this.$ = $$[$0 - 2].addOperand("OR", $$[$0], $$[$0 - 1]);
        break;
      case 4:
        yy.parser.checkStrict($$[$0 - 2], _$[$0 - 2], yy.lexer.matched);
        yy.parser.checkStrict($$[$0], _$[$0], yy.lexer.matched);
        this.$ = new yy.CTATLogicRelationNode("NAND", $$[$0 - 2], $$[$0], $$[$0 - 1]);
        break;
      case 5:
        yy.parser.checkStrict($$[$0 - 2], _$[$0 - 2], yy.lexer.matched);
        yy.parser.checkStrict($$[$0], _$[$0], yy.lexer.matched);
        this.$ = new yy.CTATLogicRelationNode("NOR", $$[$0 - 2], $$[$0], $$[$0 - 1]);
        break;
      case 6:
        yy.parser.checkStrict($$[$0 - 2], _$[$0 - 2], yy.lexer.matched);
        yy.parser.checkStrict($$[$0], _$[$0], yy.lexer.matched);
        this.$ = new yy.CTATLogicRelationNode("XOR", $$[$0 - 2], $$[$0], $$[$0 - 1]);
        break;
      case 7:
        yy.parser.checkStrict($$[$0 - 2], _$[$0 - 2], yy.lexer.matched);
        yy.parser.checkStrict($$[$0], _$[$0], yy.lexer.matched);
        this.$ = new yy.CTATLogicRelationNode("IF", $$[$0 - 2], $$[$0], $$[$0 - 1]);
        break;
      case 8:
        yy.parser.checkStrict($$[$0 - 2], _$[$0 - 2], yy.lexer.matched);
        yy.parser.checkStrict($$[$0], _$[$0], yy.lexer.matched);
        this.$ = new yy.CTATLogicRelationNode("IFF", $$[$0 - 2], $$[$0], $$[$0 - 1]);
        break;
      case 9:
        yy.parser.checkStrict($$[$0], _$[$0], yy.lexer.matched);
        this.$ = new yy.CTATLogicRelationNode("NOT", null, $$[$0], $$[$0 - 1]);
        break;
      case 10:
        this.$ = $$[$0];
        break;
      case 11:
        this.$ = $$[$0 - 1].setParens();
        break;
      case 12:
        this.$ = new yy.CTATLogicVariableNode(yy.variableTable, $$[$0]);
        break;
      case 13:
        this.$ = new yy.CTATLogicConstantNode(true, $$[$0]);
        break;
      case 14:
        this.$ = new yy.CTATLogicConstantNode(false, $$[$0]);
        break;
    }
  }, table:[{3:1, 4:2, 13:$V0, 14:4, 15:$V1, 17:$V2, 18:$V3, 19:$V4}, {1:[3]}, {5:[1, 9], 6:$V5, 7:$V6, 8:$V7, 9:$V8, 10:$V9, 11:$Va, 12:$Vb}, {4:17, 13:$V0, 14:4, 15:$V1, 17:$V2, 18:$V3, 19:$V4}, o($Vc, [2, 10]), {4:18, 13:$V0, 14:4, 15:$V1, 17:$V2, 18:$V3, 19:$V4}, o($Vc, [2, 12]), o($Vc, [2, 13]), o($Vc, [2, 14]), {1:[2, 1]}, {4:19, 13:$V0, 14:4, 15:$V1, 17:$V2, 18:$V3, 19:$V4}, {4:20, 13:$V0, 14:4, 15:$V1, 17:$V2, 18:$V3, 19:$V4}, {4:21, 13:$V0, 14:4, 15:$V1, 17:$V2, 18:$V3, 19:$V4}, {4:22, 13:$V0, 
  14:4, 15:$V1, 17:$V2, 18:$V3, 19:$V4}, {4:23, 13:$V0, 14:4, 15:$V1, 17:$V2, 18:$V3, 19:$V4}, {4:24, 13:$V0, 14:4, 15:$V1, 17:$V2, 18:$V3, 19:$V4}, {4:25, 13:$V0, 14:4, 15:$V1, 17:$V2, 18:$V3, 19:$V4}, o($Vc, [2, 9]), {6:$V5, 7:$V6, 8:$V7, 9:$V8, 10:$V9, 11:$Va, 12:$Vb, 16:[1, 26]}, o($Vc, [2, 2]), o($Vd, [2, 3], {6:$V5, 8:$V7}), o($Vd, [2, 4], {6:$V5}), o([5, 10, 11, 12, 16], [2, 5], {6:$V5, 7:$V6, 8:$V7}), o([5, 11, 12, 16], [2, 6], {6:$V5, 7:$V6, 8:$V7, 9:$V8, 10:$V9}), o([5, 12, 16], [2, 7], 
  {6:$V5, 7:$V6, 8:$V7, 9:$V8, 10:$V9, 11:$Va}), o([5, 16], [2, 8], {6:$V5, 7:$V6, 8:$V7, 9:$V8, 10:$V9, 11:$Va, 12:$Vb}), o($Vc, [2, 11])], defaultActions:{9:[2, 1]}, parseError:function parseError(str, hash) {
    if (hash.recoverable) {
      this.trace(str);
    } else {
      var error = new Error(str);
      error.hash = hash;
      throw error;
    }
  }, parse:function parse(input) {
    var self = this, stack = [0], tstack = [], vstack = [null], lstack = [], table = this.table, yytext = "", yylineno = 0, yyleng = 0, recovering = 0, TERROR = 2, EOF = 1;
    var args = lstack.slice.call(arguments, 1);
    var lexer = Object.create(this.lexer);
    var sharedState = {yy:{}};
    for (var k in this.yy) {
      if (Object.prototype.hasOwnProperty.call(this.yy, k)) {
        sharedState.yy[k] = this.yy[k];
      }
    }
    lexer.setInput(input, sharedState.yy);
    sharedState.yy.lexer = lexer;
    sharedState.yy.parser = this;
    if (typeof lexer.yylloc == "undefined") {
      lexer.yylloc = {};
    }
    var yyloc = lexer.yylloc;
    lstack.push(yyloc);
    var ranges = lexer.options && lexer.options.ranges;
    if (typeof sharedState.yy.parseError === "function") {
      this.parseError = sharedState.yy.parseError;
    } else {
      this.parseError = Object.getPrototypeOf(this).parseError;
    }
    function popStack(n) {
      stack.length = stack.length - 2 * n;
      vstack.length = vstack.length - n;
      lstack.length = lstack.length - n;
    }
    _token_stack: var lex = function() {
      var token;
      token = lexer.lex() || EOF;
      if (typeof token !== "number") {
        token = self.symbols_[token] || token;
      }
      return token;
    };
    var symbol, preErrorSymbol, state, action, a, r, yyval = {}, p, len, newState, expected;
    while (true) {
      state = stack[stack.length - 1];
      if (this.defaultActions[state]) {
        action = this.defaultActions[state];
      } else {
        if (symbol === null || typeof symbol == "undefined") {
          symbol = lex();
        }
        action = table[state] && table[state][symbol];
      }
      if (typeof action === "undefined" || !action.length || !action[0]) {
        var errStr = "";
        expected = [];
        for (p in table[state]) {
          if (this.terminals_[p] && p > TERROR) {
            expected.push("'" + this.terminals_[p] + "'");
          }
        }
        if (lexer.showPosition) {
          errStr = "Parse error on line " + (yylineno + 1) + ":\n" + lexer.showPosition() + "\nExpecting " + expected.join(", ") + ", got '" + (this.terminals_[symbol] || symbol) + "'";
        } else {
          errStr = "Parse error on line " + (yylineno + 1) + ": Unexpected " + (symbol == EOF ? "end of input" : "'" + (this.terminals_[symbol] || symbol) + "'");
        }
        this.parseError(errStr, {text:lexer.match, token:this.terminals_[symbol] || symbol, line:lexer.yylineno, loc:yyloc, expected:expected});
      }
      if (action[0] instanceof Array && action.length > 1) {
        throw new Error("Parse Error: multiple actions possible at state: " + state + ", token: " + symbol);
      }
      switch(action[0]) {
        case 1:
          stack.push(symbol);
          vstack.push(lexer.yytext);
          lstack.push(lexer.yylloc);
          stack.push(action[1]);
          symbol = null;
          if (!preErrorSymbol) {
            yyleng = lexer.yyleng;
            yytext = lexer.yytext;
            yylineno = lexer.yylineno;
            yyloc = lexer.yylloc;
            if (recovering > 0) {
              recovering--;
            }
          } else {
            symbol = preErrorSymbol;
            preErrorSymbol = null;
          }
          break;
        case 2:
          len = this.productions_[action[1]][1];
          yyval.$ = vstack[vstack.length - len];
          yyval._$ = {first_line:lstack[lstack.length - (len || 1)].first_line, last_line:lstack[lstack.length - 1].last_line, first_column:lstack[lstack.length - (len || 1)].first_column, last_column:lstack[lstack.length - 1].last_column};
          if (ranges) {
            yyval._$.range = [lstack[lstack.length - (len || 1)].range[0], lstack[lstack.length - 1].range[1]];
          }
          r = this.performAction.apply(yyval, [yytext, yyleng, yylineno, sharedState.yy, action[1], vstack, lstack].concat(args));
          if (typeof r !== "undefined") {
            return r;
          }
          if (len) {
            stack = stack.slice(0, -1 * len * 2);
            vstack = vstack.slice(0, -1 * len);
            lstack = lstack.slice(0, -1 * len);
          }
          stack.push(this.productions_[action[1]][0]);
          vstack.push(yyval.$);
          lstack.push(yyval._$);
          newState = table[stack[stack.length - 2]][stack[stack.length - 1]];
          stack.push(newState);
          break;
        case 3:
          return true;
      }
    }
    return true;
  }};
  parser.checkStrict = function checkStrict(node, location, matched) {
    var position = matched + "\n" + "-".repeat(location.first_column) + "^";
    var expected = ["'LPAREN'", "'VARIABLE'", "'TRUE'", "'FALSE'"];
    var error = "Parse error on line " + location.first_line + ":\n" + position + "\nExpecting " + expected.join(", ") + " got '" + matched[location.first_column] + "'";
    if (this.yy.strictMode && !node.checkParens()) {
      this.parseError(error, {text:matched, token:node.operator, line:location.first_line, loc:location, expected:expected});
    }
  };
  var lexer = function() {
    var lexer = {EOF:1, parseError:function parseError(str, hash) {
      if (this.yy.parser) {
        this.yy.parser.parseError(str, hash);
      } else {
        throw new Error(str);
      }
    }, setInput:function(input, yy) {
      this.yy = yy || this.yy || {};
      this._input = input;
      this._more = this._backtrack = this.done = false;
      this.yylineno = this.yyleng = 0;
      this.yytext = this.matched = this.match = "";
      this.conditionStack = ["INITIAL"];
      this.yylloc = {first_line:1, first_column:0, last_line:1, last_column:0};
      if (this.options.ranges) {
        this.yylloc.range = [0, 0];
      }
      this.offset = 0;
      return this;
    }, input:function() {
      var ch = this._input[0];
      this.yytext += ch;
      this.yyleng++;
      this.offset++;
      this.match += ch;
      this.matched += ch;
      var lines = ch.match(/(?:\r\n?|\n).*/g);
      if (lines) {
        this.yylineno++;
        this.yylloc.last_line++;
      } else {
        this.yylloc.last_column++;
      }
      if (this.options.ranges) {
        this.yylloc.range[1]++;
      }
      this._input = this._input.slice(1);
      return ch;
    }, unput:function(ch) {
      var len = ch.length;
      var lines = ch.split(/(?:\r\n?|\n)/g);
      this._input = ch + this._input;
      this.yytext = this.yytext.substr(0, this.yytext.length - len);
      this.offset -= len;
      var oldLines = this.match.split(/(?:\r\n?|\n)/g);
      this.match = this.match.substr(0, this.match.length - 1);
      this.matched = this.matched.substr(0, this.matched.length - 1);
      if (lines.length - 1) {
        this.yylineno -= lines.length - 1;
      }
      var r = this.yylloc.range;
      this.yylloc = {first_line:this.yylloc.first_line, last_line:this.yylineno + 1, first_column:this.yylloc.first_column, last_column:lines ? (lines.length === oldLines.length ? this.yylloc.first_column : 0) + oldLines[oldLines.length - lines.length].length - lines[0].length : this.yylloc.first_column - len};
      if (this.options.ranges) {
        this.yylloc.range = [r[0], r[0] + this.yyleng - len];
      }
      this.yyleng = this.yytext.length;
      return this;
    }, more:function() {
      this._more = true;
      return this;
    }, reject:function() {
      if (this.options.backtrack_lexer) {
        this._backtrack = true;
      } else {
        return this.parseError("Lexical error on line " + (this.yylineno + 1) + ". You can only invoke reject() in the lexer when the lexer is of the backtracking persuasion (options.backtrack_lexer = true).\n" + this.showPosition(), {text:"", token:null, line:this.yylineno});
      }
      return this;
    }, less:function(n) {
      this.unput(this.match.slice(n));
    }, pastInput:function() {
      var past = this.matched.substr(0, this.matched.length - this.match.length);
      return (past.length > 20 ? "..." : "") + past.substr(-20).replace(/\n/g, "");
    }, upcomingInput:function() {
      var next = this.match;
      if (next.length < 20) {
        next += this._input.substr(0, 20 - next.length);
      }
      return (next.substr(0, 20) + (next.length > 20 ? "..." : "")).replace(/\n/g, "");
    }, showPosition:function() {
      var pre = this.pastInput();
      var c = (new Array(pre.length + 1)).join("-");
      return pre + this.upcomingInput() + "\n" + c + "^";
    }, test_match:function(match, indexed_rule) {
      var token, lines, backup;
      if (this.options.backtrack_lexer) {
        backup = {yylineno:this.yylineno, yylloc:{first_line:this.yylloc.first_line, last_line:this.last_line, first_column:this.yylloc.first_column, last_column:this.yylloc.last_column}, yytext:this.yytext, match:this.match, matches:this.matches, matched:this.matched, yyleng:this.yyleng, offset:this.offset, _more:this._more, _input:this._input, yy:this.yy, conditionStack:this.conditionStack.slice(0), done:this.done};
        if (this.options.ranges) {
          backup.yylloc.range = this.yylloc.range.slice(0);
        }
      }
      lines = match[0].match(/(?:\r\n?|\n).*/g);
      if (lines) {
        this.yylineno += lines.length;
      }
      this.yylloc = {first_line:this.yylloc.last_line, last_line:this.yylineno + 1, first_column:this.yylloc.last_column, last_column:lines ? lines[lines.length - 1].length - lines[lines.length - 1].match(/\r?\n?/)[0].length : this.yylloc.last_column + match[0].length};
      this.yytext += match[0];
      this.match += match[0];
      this.matches = match;
      this.yyleng = this.yytext.length;
      if (this.options.ranges) {
        this.yylloc.range = [this.offset, this.offset += this.yyleng];
      }
      this._more = false;
      this._backtrack = false;
      this._input = this._input.slice(match[0].length);
      this.matched += match[0];
      token = this.performAction.call(this, this.yy, this, indexed_rule, this.conditionStack[this.conditionStack.length - 1]);
      if (this.done && this._input) {
        this.done = false;
      }
      if (token) {
        return token;
      } else {
        if (this._backtrack) {
          for (var k in backup) {
            this[k] = backup[k];
          }
          return false;
        }
      }
      return false;
    }, next:function() {
      if (this.done) {
        return this.EOF;
      }
      if (!this._input) {
        this.done = true;
      }
      var token, match, tempMatch, index;
      if (!this._more) {
        this.yytext = "";
        this.match = "";
      }
      var rules = this._currentRules();
      for (var i = 0;i < rules.length;i++) {
        tempMatch = this._input.match(this.rules[rules[i]]);
        if (tempMatch && (!match || tempMatch[0].length > match[0].length)) {
          match = tempMatch;
          index = i;
          if (this.options.backtrack_lexer) {
            token = this.test_match(tempMatch, rules[i]);
            if (token !== false) {
              return token;
            } else {
              if (this._backtrack) {
                match = false;
                continue;
              } else {
                return false;
              }
            }
          } else {
            if (!this.options.flex) {
              break;
            }
          }
        }
      }
      if (match) {
        token = this.test_match(match, rules[index]);
        if (token !== false) {
          return token;
        }
        return false;
      }
      if (this._input === "") {
        return this.EOF;
      } else {
        return this.parseError("Lexical error on line " + (this.yylineno + 1) + ". Unrecognized text.\n" + this.showPosition(), {text:"", token:null, line:this.yylineno});
      }
    }, lex:function lex() {
      var r = this.next();
      if (r) {
        return r;
      } else {
        return this.lex();
      }
    }, begin:function begin(condition) {
      this.conditionStack.push(condition);
    }, popState:function popState() {
      var n = this.conditionStack.length - 1;
      if (n > 0) {
        return this.conditionStack.pop();
      } else {
        return this.conditionStack[0];
      }
    }, _currentRules:function _currentRules() {
      if (this.conditionStack.length && this.conditionStack[this.conditionStack.length - 1]) {
        return this.conditions[this.conditionStack[this.conditionStack.length - 1]].rules;
      } else {
        return this.conditions["INITIAL"].rules;
      }
    }, topState:function topState(n) {
      n = this.conditionStack.length - 1 - Math.abs(n || 0);
      if (n >= 0) {
        return this.conditionStack[n];
      } else {
        return "INITIAL";
      }
    }, pushState:function pushState(condition) {
      this.begin(condition);
    }, stateStackSize:function stateStackSize() {
      return this.conditionStack.length;
    }, options:{}, performAction:function anonymous(yy, yy_, $avoiding_name_collisions, YY_START) {
      var YYSTATE = YY_START;
      switch($avoiding_name_collisions) {
        case 0:
          break;
        case 1:
          return 15;
          break;
        case 2:
          return 16;
          break;
        case 3:
          return 12;
          break;
        case 4:
          return 12;
          break;
        case 5:
          return 12;
          break;
        case 6:
          return 12;
          break;
        case 7:
          return 12;
          break;
        case 8:
          return 12;
          break;
        case 9:
          return 12;
          break;
        case 10:
          return 10;
          break;
        case 11:
          return 10;
          break;
        case 12:
          return 10;
          break;
        case 13:
          return 10;
          break;
        case 14:
          return 10;
          break;
        case 15:
          return 10;
          break;
        case 16:
          return 11;
          break;
        case 17:
          return 11;
          break;
        case 18:
          return 11;
          break;
        case 19:
          return 11;
          break;
        case 20:
          return 11;
          break;
        case 21:
          return 8;
          break;
        case 22:
          return 8;
          break;
        case 23:
          return 8;
          break;
        case 24:
          return 8;
          break;
        case 25:
          return 8;
          break;
        case 26:
          return 8;
          break;
        case 27:
          return 8;
          break;
        case 28:
          return 8;
          break;
        case 29:
          return 8;
          break;
        case 30:
          return 8;
          break;
        case 31:
          return 8;
          break;
        case 32:
          return 6;
          break;
        case 33:
          return 6;
          break;
        case 34:
          return 6;
          break;
        case 35:
          return 6;
          break;
        case 36:
          return 6;
          break;
        case 37:
          return 6;
          break;
        case 38:
          return 9;
          break;
        case 39:
          return 9;
          break;
        case 40:
          return 9;
          break;
        case 41:
          return 9;
          break;
        case 42:
          return 9;
          break;
        case 43:
          return 9;
          break;
        case 44:
          return 9;
          break;
        case 45:
          return 9;
          break;
        case 46:
          return 9;
          break;
        case 47:
          return 9;
          break;
        case 48:
          return 9;
          break;
        case 49:
          return 7;
          break;
        case 50:
          return 7;
          break;
        case 51:
          return 7;
          break;
        case 52:
          return 7;
          break;
        case 53:
          return 7;
          break;
        case 54:
          return 13;
          break;
        case 55:
          return 13;
          break;
        case 56:
          return 13;
          break;
        case 57:
          return 13;
          break;
        case 58:
          return 18;
          break;
        case 59:
          return 18;
          break;
        case 60:
          return 18;
          break;
        case 61:
          return 18;
          break;
        case 62:
          return 19;
          break;
        case 63:
          return 19;
          break;
        case 64:
          return 19;
          break;
        case 65:
          return 19;
          break;
        case 66:
          return 17;
          break;
        case 67:
          return 5;
          break;
      }
    }, rules:[/^(?:\s+)/, /^(?:\()/, /^(?:\))/, /^(?:=)/, /^(?:<=>)/, /^(?:<->)/, /^(?:\u21d4)/, /^(?:\u2194)/, /^(?:\u2261)/, /^(?:\u2299)/, /^(?:\u2260)/, /^(?:\u2262)/, /^(?:\u22bb)/, /^(?:\u2295)/, /^(?:\^)/, /^(?:<~>)/, /^(?:=>)/, /^(?:->)/, /^(?:\u21d2)/, /^(?:\u2192)/, /^(?:\u2283)/, /^(?:\u2191)/, /^(?:\u22bc)/, /^(?:~\/\\)/, /^(?:~&&)/, /^(?:~&)/, /^(?:!\/\\)/, /^(?:!&&)/, /^(?:!&)/, /^(?:-\/\\)/, /^(?:-&&)/, /^(?:-&)/, /^(?:&&)/, /^(?:&)/, /^(?:\u2227)/, /^(?:\/\\)/, /^(?:\*)/, /^(?:\.)/, 
    /^(?:\u2193)/, /^(?:\u22bd)/, /^(?:~\\\/)/, /^(?:~\|\|)/, /^(?:~\|)/, /^(?:!\\\/)/, /^(?:!\|\|)/, /^(?:!\|)/, /^(?:-\\\/)/, /^(?:-\|\|)/, /^(?:-\|)/, /^(?:\|\|)/, /^(?:\|)/, /^(?:\u2228)/, /^(?:\\\/)/, /^(?:\+)/, /^(?:~)/, /^(?:\u00ac)/, /^(?:!)/, /^(?:-)/, /^(?:([Tt][Rr][Uu][Ee]))/, /^(?:T\b)/, /^(?:\u22a4)/, /^(?:1\b)/, /^(?:([Ff][Aa][Ll][Ss][Ee]))/, /^(?:F\b)/, /^(?:\u22a5)/, /^(?:0\b)/, /^(?:([A-Za-z][0-9]*))/, /^(?:$)/], conditions:{"INITIAL":{"rules":[0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 
    12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67], "inclusive":true}}};
    return lexer;
  }();
  parser.lexer = lexer;
  function Parser() {
    this.yy = {};
  }
  Parser.prototype = parser;
  parser.Parser = Parser;
  return new Parser;
}();
goog.provide("CTATLogicFlattenNode");
goog.require("CTATLogicTreeNode");
(function() {
  var CTATLogicFlattenNode, extend = function(child, parent) {
    for (var key in parent) {
      if (hasProp.call(parent, key)) {
        child[key] = parent[key];
      }
    }
    function ctor() {
      this.constructor = child;
    }
    ctor.prototype = parent.prototype;
    child.prototype = new ctor;
    child.__super__ = parent.prototype;
    return child;
  }, hasProp = {}.hasOwnProperty;
  CTATLogicFlattenNode = function(superClass) {
    extend(CTATLogicFlattenNode, superClass);
    function CTATLogicFlattenNode(operator1, terms1, string1, negated1) {
      this.operator = operator1;
      this.terms = terms1;
      this.string = string1 != null ? string1 : null;
      this.negated = negated1 != null ? negated1 : false;
      CTATLogicFlattenNode.__super__.constructor.apply(this, arguments);
    }
    CTATLogicFlattenNode.prototype.addOperand = function(operator, operand, string) {
      if (string == null) {
        string = null;
      }
      if (operator === this.operator && !this.parens) {
        this.terms.push(operand);
        return this;
      } else {
        return CTATLogicFlattenNode.__super__.addOperand.apply(this, arguments);
      }
    };
    CTATLogicFlattenNode.prototype.clone = function(deep) {
      if (deep == null) {
        deep = true;
      }
      return new CTATLogicFlattenNode(this.operator, deep ? this.terms.map(function(term) {
        return term.clone();
      }) : this.terms, this.string, this.negated);
    };
    CTATLogicFlattenNode.prototype.toString = function(parenthesized, node, other) {
      if (parenthesized == null) {
        parenthesized = false;
      }
      if (node == null) {
        node = null;
      }
      if (other == null) {
        other = false;
      }
      return CTATLogicFlattenNode.__super__.toString.call(this, this.terms.reduce(function(_this) {
        return function(result, term) {
          return "" + result + (result ? "" + _this.operatorString() : "") + term.toString(parenthesized, _this, true);
        };
      }(this), ""), parenthesized, node, other);
    };
    CTATLogicFlattenNode.prototype.evaluate = function(bindings) {
      if (bindings == null) {
        bindings = null;
      }
      return CTATLogicFlattenNode.__super__.evaluate.call(this, this.terms.reduce(function(_this) {
        return function(result, term) {
          return _this.applyOperator(_this.operator, result, term.evaluate(bindings));
        };
      }(this), this.conjunctionOp()));
    };
    CTATLogicFlattenNode.prototype.equals = function(node, inverse) {
      return CTATLogicFlattenNode.__super__.equals.call(this, node, inverse) && this.terms.length === node.terms.length && this.terms.every(function(term, index) {
        return term.equals(node.terms[index], false);
      });
    };
    CTATLogicFlattenNode.prototype.subEquals = function(node, start) {
      return this.operator === node.operator && !node.negated && this.terms.length >= node.terms.length && node.terms.every(function(_this) {
        return function(term, index) {
          return term.equals(_this.terms[start + index], false);
        };
      }(this));
    };
    CTATLogicFlattenNode.prototype.subNode = function(start, end) {
      if (start != null) {
        return Object.assign(this.clone(false), {terms:this.terms.slice(start, end)});
      } else {
        return this;
      }
    };
    CTATLogicFlattenNode.prototype.countOperands = function() {
      return this.terms.length;
    };
    CTATLogicFlattenNode.prototype.getOperators = function(string) {
      if (string == null) {
        string = false;
      }
      return this.terms.slice(1).reduce(function(_this) {
        return function(result, term, index) {
          return result.concat(_this.getOperator(string), term.getOperators(string));
        };
      }(this), this.terms[0].getOperators(string));
    };
    CTATLogicFlattenNode.prototype.getVariables = function() {
      return this.terms.slice(1).reduce(function(_this) {
        return function(result, term, index) {
          return result.concat(term.getVariables());
        };
      }(this), this.terms[0].getVariables());
    };
    CTATLogicFlattenNode.prototype.getOperands = function() {
      return this.terms.slice(0);
    };
    CTATLogicFlattenNode.prototype.findOperator = function(operator, path, subexpressions) {
      if (subexpressions == null) {
        subexpressions = "none";
      }
      return this.terms.slice(1).reduce(function(_this) {
        return function(result, term, index) {
          return result.concat(CTATLogicFlattenNode.__super__.findOperator.call(_this, operator, path, index, subexpressions), term.findOperator(operator, path.concat([index + 1]), subexpressions));
        };
      }(this), this.terms[0].findOperator(operator, path.concat([0]), subexpressions));
    };
    CTATLogicFlattenNode.prototype.findExpression = function(expression, path) {
      return this.terms.slice(1).reduce(function(_this) {
        return function(result, term, index) {
          return result.concat(CTATLogicFlattenNode.__super__.findExpression.call(_this, expression, path, index), term.findExpression(expression, path.concat([index + 1])));
        };
      }(this), this.terms[0].findExpression(expression, path.concat([0])));
    };
    CTATLogicFlattenNode.prototype.findRule = function(rule, path, reverse) {
      if (reverse == null) {
        reverse = false;
      }
      return this.terms.slice(1).reduce(function(_this) {
        return function(result, term, index) {
          return result.concat(CTATLogicFlattenNode.__super__.findRule.call(_this, rule, path, reverse, index), term.findRule(rule, path.concat([index + 1]), reverse));
        };
      }(this), this.terms[0].findRule(rule, path.concat([0]), reverse));
    };
    CTATLogicFlattenNode.prototype.removeNull = function() {
      this.terms = this.terms.map(function(term) {
        return term != null ? term.removeNull() : void 0;
      }).filter(function(term) {
        return term;
      });
      if (this.terms.length > 1) {
        return this;
      } else {
        return this.terms[0] || null;
      }
    };
    CTATLogicFlattenNode.prototype.applyRules = function(rules1, reverse, global) {
      this.rules = rules1;
      if (reverse == null) {
        reverse = false;
      }
      if (global == null) {
        global = false;
      }
      if (global) {
        this.terms = this.terms.map(function(_this) {
          return function(term) {
            term = term.setSteps(_this.steps).applyRules(_this.rules, reverse, true);
            _this.setSteps(term.steps);
            return term;
          };
        }(this));
      }
      return CTATLogicFlattenNode.__super__.applyRules.apply(this, arguments);
    };
    CTATLogicFlattenNode.prototype.domination = function(reverse, test) {
      var constant;
      if (reverse == null) {
        reverse = false;
      }
      if (test == null) {
        test = false;
      }
      if (!reverse && this.junctionOp() && (constant = this.terms.find(function(_this) {
        return function(term) {
          return term.constant(_this.disjunctionOp());
        };
      }(this)))) {
        return test || constant;
      } else {
        return !test && this;
      }
    };
    CTATLogicFlattenNode.prototype.negation = function(reverse, test) {
      if (reverse == null) {
        reverse = false;
      }
      if (test == null) {
        test = false;
      }
      if (!reverse && this.junctionOp() && this.terms.some(function(_this) {
        return function(term, index) {
          return _this.terms.slice(index + 1).some(function(term2) {
            return term2.inverse(term);
          });
        };
      }(this))) {
        return test || new CTATLogicConstantNode(this.disjunctionOp());
      } else {
        return !test && this;
      }
    };
    CTATLogicFlattenNode.prototype.identity = function(reverse, test) {
      var constants;
      if (reverse == null) {
        reverse = false;
      }
      if (test == null) {
        test = false;
      }
      if (!reverse && this.junctionOp() && (constants = this.terms.filter(function(_this) {
        return function(term) {
          return term.constant(_this.conjunctionOp());
        };
      }(this))).length) {
        return test || this.junctionNode(CTATLogicTreeNode.difference(this.terms, constants));
      } else {
        if (reverse && this.junctionOp()) {
          return test || this.junctionNode(this.terms.push(new CTATLogicConstantNode(this.conjunctionOp())));
        } else {
          return CTATLogicFlattenNode.__super__.identity.apply(this, arguments);
        }
      }
    };
    CTATLogicFlattenNode.prototype.idempotence = function(reverse, test) {
      var duplicates;
      if (reverse == null) {
        reverse = false;
      }
      if (test == null) {
        test = false;
      }
      if (!reverse && this.junctionOp() && (duplicates = this.terms.filter(function(_this) {
        return function(term, index) {
          return _this.terms.slice(index + 1).some(function(term2) {
            return term2.equals(term);
          });
        };
      }(this))).length) {
        return test || this.junctionNode(CTATLogicTreeNode.difference(this.terms, duplicates));
      } else {
        if (reverse && this.junctionOp()) {
          return test || this.junctionNode(this.terms.concat(this.terms));
        } else {
          return CTATLogicFlattenNode.__super__.idempotence.apply(this, arguments);
        }
      }
    };
    CTATLogicFlattenNode.prototype.absorption = function(reverse, test) {
      var absorbed;
      if (reverse == null) {
        reverse = false;
      }
      if (test == null) {
        test = false;
      }
      if (!reverse && this.junctionOp() && (absorbed = this.terms.reduce(function(_this) {
        return function(result, term) {
          return result.concat(term.findPairs(_this.inverseOperator(), _this.terms, "equals"));
        };
      }(this), [])).length) {
        return test || this.junctionNode(CTATLogicTreeNode.replaceTerms(this.terms, absorbed, false));
      } else {
        return !test && this;
      }
    };
    CTATLogicFlattenNode.prototype.inverseAbsorption = function(reverse, test) {
      var absorbed;
      if (reverse == null) {
        reverse = false;
      }
      if (test == null) {
        test = false;
      }
      if (!reverse && this.junctionOp() && (absorbed = this.terms.reduce(function(_this) {
        return function(result, term) {
          return result.concat(term.findPairs(_this.inverseOperator(), _this.terms, "inverse"));
        };
      }(this), [])).length) {
        return test || this.junctionNode(CTATLogicTreeNode.replaceTerms(this.terms, absorbed, true));
      } else {
        return !test && this;
      }
    };
    CTATLogicFlattenNode.prototype.junctionNode = function(terms) {
      if (terms.length === 1) {
        return terms[0];
      } else {
        return Object.assign(this.clone(), {terms:terms});
      }
    };
    CTATLogicFlattenNode.prototype.commutativity = function(reverse, test) {
      if (reverse == null) {
        reverse = false;
      }
      if (test == null) {
        test = false;
      }
      if (this.junctionOp()) {
        return test || new CTATLogicFlattenNode(this.operator, this.terms.slice(0).reverse());
      } else {
        return !test && this;
      }
    };
    CTATLogicFlattenNode.prototype.associativity = function(reverse, test) {
      if (reverse == null) {
        reverse = false;
      }
      if (test == null) {
        test = false;
      }
      if (this.junctionOp() && this.terms.some(function(_this) {
        return function(term) {
          return term.operator === _this.operator;
        };
      }(this))) {
        return test || this.clone().flatten();
      } else {
        return !test && this;
      }
    };
    CTATLogicFlattenNode.prototype.distributivity = function(reverse, test) {
      var difference, index, intersection, length, subterms, term, terms;
      if (reverse == null) {
        reverse = false;
      }
      if (test == null) {
        test = false;
      }
      if (!reverse && this.junctionOp() && (index = this.terms.findIndex(function(_this) {
        return function(term) {
          return term.junctionOp() && term.operator !== _this.operator;
        };
      }(this))) !== -1) {
        term = this.terms[index];
        terms = CTATLogicTreeNode.removeIndex(this.terms, index);
        return test || new CTATLogicFlattenNode(term.operator, term.terms.map(function(_this) {
          return function(term) {
            return new CTATLogicFlattenNode(_this.operator, terms.concat([term]));
          };
        }(this)));
      } else {
        if (reverse && this.junctionOp() && this.terms.every(function(_this) {
          return function(term) {
            return term.junctionOp() && term.operator !== _this.operator;
          };
        }(this)) && (subterms = this.terms.map(function(term) {
          return term.terms;
        })) && (length = CTATLogicTreeNode.commonLength(subterms)) && (intersection = CTATLogicTreeNode.intersection(subterms)) && intersection.length === length - 1) {
          return test || (difference = subterms.map(function(_this) {
            return function(terms) {
              return CTATLogicTreeNode.difference(terms, intersection)[0];
            };
          }(this)), new CTATLogicFlattenNode(this.terms[0].operator, intersection.concat([new CTATLogicFlattenNode(this.operator, difference)])));
        } else {
          return !test && this;
        }
      }
    };
    CTATLogicFlattenNode.prototype.deMorgan = function(reverse, test) {
      if (reverse == null) {
        reverse = false;
      }
      if (test == null) {
        test = false;
      }
      if (reverse && this.junctionOp() && this.terms.every(function(term) {
        return term.negationOp();
      })) {
        return this.reverseNode(true).negateNode();
      } else {
        return !test && this;
      }
    };
    CTATLogicFlattenNode.prototype.reverseNode = function(reverse) {
      if (reverse == null) {
        reverse = false;
      }
      return new CTATLogicFlattenNode(this.inverseOperator(), this.terms.map(function(term) {
        if (reverse) {
          return term.unnegateNode();
        } else {
          return term.negateNode();
        }
      }));
    };
    CTATLogicFlattenNode.prototype.implication = function(reverse, test) {
      var negated, nonNegated;
      if (reverse == null) {
        reverse = false;
      }
      if (test == null) {
        test = false;
      }
      if (reverse && this.disjunctionOp() && this.terms.some(function(term) {
        return term.negationOp();
      }) && this.terms.some(function(term) {
        return !term.negationOp();
      })) {
        return test || (negated = this.terms.filter(function(term) {
          return term.negationOp();
        }).map(function(term) {
          return term.unnegateNode();
        }), nonNegated = this.terms.filter(function(term) {
          return !term.negationOp();
        }), new CTATLogicRelationNode("IF", negated.length > 1 ? new CTATLogicFlattenNode("AND", negated) : negated[0], nonNegated.length > 1 ? new CTATLogicFlattenNode("OR", nonNegated) : nonNegated[0]));
      } else {
        return !test && this;
      }
    };
    CTATLogicFlattenNode.prototype.biimplication = function(reverse, test) {
      if (reverse == null) {
        reverse = false;
      }
      if (test == null) {
        test = false;
      }
      if (reverse && this.disjunctionOp() && this.terms.length === 2 && this.terms.every(function(term) {
        return term.conjunctionOp();
      }) && this.terms[0].terms.every(function(_this) {
        return function(term) {
          return _this.terms[1].terms.some(function(term2) {
            return term2.inverse(term);
          });
        };
      }(this)) && CTATLogicTreeNode.sameNegation(this.terms[0].terms) && CTATLogicTreeNode.sameNegation(this.terms[1].terms)) {
        return test || new CTATLogicRelationNode("IFF", this.terms[0].terms[0].unnegateNode(), this.terms[0].terms[1].unnegateNode());
      } else {
        return !test && this;
      }
    };
    CTATLogicFlattenNode.prototype.biimplicationToImplication = function(reverse, test) {
      if (reverse == null) {
        reverse = false;
      }
      if (test == null) {
        test = false;
      }
      if (reverse && this.conjunctionOp() && this.terms.length === 2 && this.terms.every(function(term) {
        return term.implicationOp();
      }) && this.terms[0].left.equals(this.terms[1].right) && this.terms[0].right.equals(this.terms[1].left)) {
        return test || new CTATLogicRelationNode("IFF", this.terms[0].left, this.terms[0].right);
      } else {
        return !test && this;
      }
    };
    CTATLogicFlattenNode.prototype.exclusiveDisjunction = function(reverse, test) {
      if (reverse == null) {
        reverse = false;
      }
      if (test == null) {
        test = false;
      }
      if (reverse && this.disjunctionOp() && this.terms.length === 2 && this.terms.every(function(term) {
        return term.conjunctionOp();
      }) && this.terms[0].terms.every(function(_this) {
        return function(term) {
          return _this.terms[1].terms.some(function(term2) {
            return term2.inverse(term);
          });
        };
      }(this)) && CTATLogicTreeNode.oppositeNegation(this.terms[0].terms) && CTATLogicTreeNode.oppositeNegation(this.terms[1].terms)) {
        return test || new CTATLogicRelationNode("XOR", this.terms[0].terms[0].unnegateNode(), this.terms[0].terms[1].unnegateNode());
      } else {
        return !test && this;
      }
    };
    CTATLogicFlattenNode.prototype.exclusiveDisjunctionToImplication = function(reverse, test) {
      if (reverse == null) {
        reverse = false;
      }
      if (test == null) {
        test = false;
      }
      if (reverse && this.conjunctionOp() && this.terms.length === 2 && this.terms.every(function(term) {
        return term.implicationOp();
      }) && this.terms[0].left.equals(this.terms[1].right) && this.terms[0].right.equals(this.terms[1].left)) {
        return test || new CTATLogicRelationNode("XOR", this.terms[0].left.unnegateNode(), this.terms[0].right.unnegateNode());
      } else {
        return !test && this;
      }
    };
    CTATLogicFlattenNode.prototype.normalFormOperators = function() {
      return CTATLogicFlattenNode.__super__.normalFormOperators.apply(this, arguments) && this.terms.every(function(term) {
        return term.normalFormOperators();
      });
    };
    CTATLogicFlattenNode.prototype.atomicNegation = function() {
      return !this.negated && this.terms.every(function(term) {
        return term.atomicNegation();
      });
    };
    CTATLogicFlattenNode.prototype.atomicConjunction = function() {
      return this.conjunctionOp() && this.terms.every(function(term) {
        return term.atomic();
      }) || !this.conjunctionOp() && this.terms.every(function(term) {
        return term.atomicConjunction();
      });
    };
    CTATLogicFlattenNode.prototype.atomicDisjunction = function() {
      return this.disjunctionOp() && this.terms.every(function(term) {
        return term.atomic();
      }) || !this.disjunctionOp() && this.terms.every(function(term) {
        return term.atomicDisjunction();
      });
    };
    CTATLogicFlattenNode.prototype.pushNegation = function() {
      if (this.negated) {
        this.negate();
        this.invertOperator();
        this.terms.forEach(function(_this) {
          return function(term) {
            term.setSteps(_this.steps).negate().pushNegation();
            return _this.setSteps(term.steps);
          };
        }(this));
        this.setSteps(this.steps + 1);
      }
      return this;
    };
    CTATLogicFlattenNode.prototype.flatten = function() {
      this.terms = this.terms.reduce(function(_this) {
        return function(result, term) {
          if (term.operator !== _this.operator) {
            result.push(term);
          } else {
            result.push.apply(result, term.terms);
          }
          return result;
        };
      }(this), []);
      return this;
    };
    CTATLogicFlattenNode.prototype.distributeDisjunction = function() {
      var rules, term;
      if (this.disjunctionOp() && this.conjunctiveTerms()) {
        rules = CTATLogicTreeNode.diff(this.rules, ["replaceNodes", "pushNegation"]);
        (term = this.terms.pop()).setSteps(this.steps).terms = term.terms.map(function(_this) {
          return function(subterm) {
            var item;
            item = _this.clone();
            item.terms.push(subterm);
            item = item.setSteps(term.steps).applyRules(rules);
            term.setSteps(item.steps);
            return item;
          };
        }(this));
        return term.setSteps(term.steps + 1).applyRules(["flatten", "sort", "distributeDisjunction"]);
      } else {
        return this;
      }
    };
    CTATLogicFlattenNode.prototype.conjunctiveTerms = function() {
      return this.terms.some(function(term) {
        return term.conjunctionOp();
      });
    };
    CTATLogicFlattenNode.prototype.distributeConjunction = function() {
      var rules, term;
      if (this.conjunctionOp() && this.disjunctiveTerms()) {
        rules = CTATLogicTreeNode.diff(this.rules, ["replaceNodes", "pushNegation"]);
        (term = this.terms.pop()).setSteps(this.steps).terms = term.terms.map(function(_this) {
          return function(subterm) {
            var item;
            item = _this.clone();
            item.terms.push(subterm);
            item = item.setSteps(term.steps).applyRules(rules);
            term.setSteps(item.steps);
            return item;
          };
        }(this));
        return term.setSteps(term.steps + 1).applyRules(["flatten", "sort", "distributeConjunction"]);
      } else {
        return this;
      }
    };
    CTATLogicFlattenNode.prototype.disjunctiveTerms = function() {
      return this.terms.some(function(term) {
        return term.disjunctionOp();
      });
    };
    CTATLogicFlattenNode.prototype.absorb = function() {
      this.terms = this.terms.reduce(function(_this) {
        return function(result, term) {
          var inverse, ref, ref1, ref2;
          if (!(result instanceof Array)) {
          } else {
            if (_this.disjunctionOp() && term.constant(true) || _this.conjunctionOp() && term.constant(false)) {
              result = term.setSteps(_this.steps + 1);
            } else {
              if (term.constant() && result.length === 0) {
                result.push(term);
              } else {
                if ((ref = result[result.length - 1]) != null ? ref.equals(term, false) : void 0) {
                  _this.setSteps(_this.steps + 1);
                } else {
                  if ((ref1 = result[result.length - 1]) != null ? ref1.equals(term, true) : void 0) {
                    result = (new CTATLogicConstantNode(_this.disjunctionOp(), CTATLogicTreeNode.operatorStrings[_this.disjunctionOp()])).setSteps(_this.steps + 1);
                  } else {
                    if (term.junctionOp() && result.find(function(item) {
                      return term.subterm(item, false);
                    })) {
                      _this.setSteps(_this.steps + 1);
                    } else {
                      if (term.junctionOp() && (inverse = result.find(function(item) {
                        return term.subterm(item, true);
                      }))) {
                        _this.setSteps(_this.steps + 1);
                        result.push(term.removeInverse(inverse));
                      } else {
                        if ((ref2 = result[0]) != null ? ref2.constant() : void 0) {
                          result.pop();
                          _this.setSteps(_this.steps + 1);
                        }
                        result.push(term);
                      }
                    }
                  }
                }
              }
            }
          }
          return result;
        };
      }(this), []);
      if (!(this.terms instanceof Array)) {
        return this.terms;
      } else {
        return this.prune();
      }
    };
    CTATLogicFlattenNode.prototype.subterm = function(item, inverse) {
      return this.terms.some(function(subterm) {
        return item.equals(subterm, inverse);
      });
    };
    CTATLogicFlattenNode.prototype.removeInverse = function(item) {
      this.terms = this.terms.filter(function(subterm) {
        return !item.equals(subterm, true);
      });
      return this.prune();
    };
    CTATLogicFlattenNode.prototype.prune = function() {
      if (this.terms.length === 1) {
        return this.terms[0].setSteps(this.steps);
      } else {
        return this;
      }
    };
    CTATLogicFlattenNode.prototype.sort = function() {
      this.terms = this.terms.sort(function(node1, node2) {
        return node1.compare(node2);
      });
      return this;
    };
    CTATLogicFlattenNode.prototype.compare = function(node) {
      var value;
      return (value = CTATLogicFlattenNode.__super__.compare.apply(this, arguments)) || this.terms.some(function(term, index) {
        return value = term.compare(node.terms[index]);
      }) && value || this.compareNegations(node);
    };
    CTATLogicFlattenNode.prototype.countVariables = function() {
      return this.terms.reduce(function(result, term) {
        return result + term.countVariables();
      }, 0);
    };
    CTATLogicFlattenNode.prototype.countLevels = function() {
      return 1 + this.terms.reduce(function(result, term) {
        return Math.max(result, term.countLevels());
      }, 0);
    };
    return CTATLogicFlattenNode;
  }(CTATLogicTreeNode);
  if (typeof module !== "undefined" && module !== null) {
    module.exports = CTATLogicFlattenNode;
  } else {
    this.CTATLogicFlattenNode = CTATLogicFlattenNode;
  }
}).call(this);
goog.provide("CTATLogicParser");
goog.require("CTATLogicGrammar");
goog.require("CTATLogicRelationNode");
goog.require("CTATLogicFlattenNode");
goog.require("CTATLogicVariableNode");
goog.require("CTATLogicConstantNode");
goog.require("CTATLogicTreeNode");
(function() {
  var CTATLogicParser, slice = [].slice;
  CTATLogicParser = function() {
    function CTATLogicParser(variableTable) {
      this.parser = new CTATLogicGrammar.Parser;
      this.parser.yy = {CTATLogicRelationNode:CTATLogicRelationNode, CTATLogicFlattenNode:CTATLogicFlattenNode, CTATLogicVariableNode:CTATLogicVariableNode, CTATLogicConstantNode:CTATLogicConstantNode, CTATLogicTreeNode:CTATLogicTreeNode};
      this.parser.yy.variableTable = variableTable;
    }
    CTATLogicParser.SORTRule = ["sort"];
    CTATLogicParser.NNFRules = ["replaceNodes", "pushNegation", "flatten", "sort", "absorb", "sort"];
    CTATLogicParser.CNFRules = ["replaceNodes", "pushNegation", "flatten", "sort", "distributeDisjunction", "absorb", "sort"];
    CTATLogicParser.DNFRules = ["replaceNodes", "pushNegation", "flatten", "sort", "distributeConjunction", "absorb", "sort"];
    CTATLogicParser.NNFTests = ["normalFormOperators", "atomicNegation"];
    CTATLogicParser.CNFTests = ["normalFormOperators", "atomicNegation", "atomicDisjunction"];
    CTATLogicParser.DNFTests = ["normalFormOperators", "atomicNegation", "atomicConjunction"];
    CTATLogicParser.prototype.getTree = function(expression, clone, steps) {
      var result;
      if (clone == null) {
        clone = false;
      }
      if (steps == null) {
        steps = false;
      }
      result = expression instanceof CTATLogicTreeNode ? clone ? expression.clone() : expression : this.parser.parse(expression);
      if (steps) {
        if (result != null) {
          result.setSteps(0);
        }
      }
      return result;
    };
    CTATLogicParser.prototype.getExpression = function(expression, tree, parenthesized) {
      if (parenthesized == null) {
        parenthesized = false;
      }
      if (expression instanceof CTATLogicTreeNode) {
        return tree;
      } else {
        if (typeof tree === "string") {
          return tree;
        } else {
          if (tree != null) {
            return tree.toString(parenthesized);
          } else {
            return tree;
          }
        }
      }
    };
    CTATLogicParser.prototype.equalExpressions = function(expression1, expression2) {
      if (expression1 instanceof CTATLogicTreeNode && expression2 instanceof CTATLogicTreeNode) {
        return expression1.toString() === expression2.toString();
      } else {
        return expression1 === expression2;
      }
    };
    CTATLogicParser.prototype.logicSetMode = function(object) {
      Object.assign(this.parser.yy, object);
      return object;
    };
    CTATLogicParser.prototype.logicParse = function(expression) {
      try {
        return this.getTree(expression);
      } catch (_error) {
        return null;
      }
    };
    CTATLogicParser.prototype.logicGetError = function(expression) {
      var error;
      try {
        expression instanceof CTATLogicTreeNode || this.parser.parse(String(expression));
        return null;
      } catch (_error) {
        error = _error;
        return error;
      }
    };
    CTATLogicParser.prototype.logicStringify = function(expression) {
      return this.getExpression("", expression, this.parser.yy.strictMode);
    };
    CTATLogicParser.prototype.logicEvaluate = function(expression, bindings) {
      if (bindings == null) {
        bindings = null;
      }
      try {
        return this.getTree(expression).evaluate(bindings);
      } catch (_error) {
        return null;
      }
    };
    CTATLogicParser.prototype.logicSort = function(expression) {
      return this.getExpression(expression, function() {
        try {
          return this.getTree(expression, true).applyRules(CTATLogicParser.SORTRule, false, true);
        } catch (_error) {
          return null;
        }
      }.call(this));
    };
    CTATLogicParser.prototype.logicGetOperator = function(expression, string) {
      if (string == null) {
        string = false;
      }
      try {
        return this.getTree(expression).getOperator(string);
      } catch (_error) {
        return null;
      }
    };
    CTATLogicParser.prototype.logicGetOperators = function(expression, string) {
      if (string == null) {
        string = false;
      }
      try {
        return this.getTree(expression).getOperators(string);
      } catch (_error) {
        return null;
      }
    };
    CTATLogicParser.prototype.logicGetVariables = function(expression) {
      try {
        return this.getTree(expression).getVariables();
      } catch (_error) {
        return null;
      }
    };
    CTATLogicParser.prototype.logicGetOperands = function(expression) {
      try {
        return this.getTree(expression).getOperands().map(function(_this) {
          return function(subexpression) {
            return _this.getExpression(expression, subexpression);
          };
        }(this));
      } catch (_error) {
        return null;
      }
    };
    CTATLogicParser.prototype.logicGetExpression = function(expression, start, end) {
      return this.getExpression(expression, function() {
        try {
          return this.getTree(expression).getExpression(start, end);
        } catch (_error) {
          return null;
        }
      }.call(this));
    };
    CTATLogicParser.prototype.logicFindOperator = function(expression, operator, subexpressions) {
      if (subexpressions == null) {
        subexpressions = "none";
      }
      try {
        return this.getTree(expression).findOperator(operator, [], subexpressions).map(function(_this) {
          return function(subexpression) {
            return _this.getExpression(expression, subexpression);
          };
        }(this));
      } catch (_error) {
        return null;
      }
    };
    CTATLogicParser.prototype.logicFindExpression = function(expression, subexpression) {
      try {
        return this.getTree(expression).findExpression(this.getTree(subexpression), []).map(function(_this) {
          return function(subexpression) {
            return _this.getExpression(expression, subexpression);
          };
        }(this));
      } catch (_error) {
        return null;
      }
    };
    CTATLogicParser.prototype.logicFindRule = function(expression, rule, reverse) {
      if (reverse == null) {
        reverse = false;
      }
      try {
        return this.getTree(expression).findRule(rule, [], reverse).map(function(_this) {
          return function(subexpression) {
            return _this.getExpression(expression, subexpression);
          };
        }(this));
      } catch (_error) {
        return null;
      }
    };
    CTATLogicParser.prototype.logicApplyRules = function(expression, rules, reverse, global) {
      if (reverse == null) {
        reverse = false;
      }
      if (global == null) {
        global = false;
      }
      return this.getExpression(expression, function() {
        try {
          return this.getTree(expression, global).applyRules(rules, reverse, global);
        } catch (_error) {
          return null;
        }
      }.call(this));
    };
    CTATLogicParser.prototype.logicCreateExpression = function() {
      var expression, expressions, operator;
      operator = arguments[0], expression = arguments[1], expressions = 3 <= arguments.length ? slice.call(arguments, 2) : [];
      return this.getExpression(expression, function() {
        var ref;
        try {
          return (ref = this.getTree(expression)).createExpression.apply(ref, [operator].concat(slice.call(expressions.map(function(_this) {
            return function(expression) {
              return _this.getTree(expression);
            };
          }(this)))));
        } catch (_error) {
          return null;
        }
      }.call(this));
    };
    CTATLogicParser.prototype.logicReplaceExpression = function(expression, oldSubexpression, newSubexpression, locator) {
      var ref;
      if (locator == null) {
        locator = null;
      }
      locator = (locator != null ? locator : (ref = oldSubexpression.path) != null ? ref.slice(0) : void 0) || 0;
      return this.getExpression(expression, function() {
        try {
          return this.getTree(expression).replaceExpression(this.getTree(oldSubexpression), this.getTree(newSubexpression), locator);
        } catch (_error) {
          return null;
        }
      }.call(this));
    };
    CTATLogicParser.prototype.logicDeleteExpression = function(expression, subexpression, locator) {
      var ref;
      if (locator == null) {
        locator = null;
      }
      locator = (locator != null ? locator : (ref = subexpression.path) != null ? ref.slice(0) : void 0) || 0;
      return this.getExpression(expression, function() {
        try {
          return this.getTree(expression).deleteExpression(this.getTree(subexpression), locator);
        } catch (_error) {
          return null;
        }
      }.call(this));
    };
    CTATLogicParser.prototype.logicSimplifyNNF = function(expression, steps) {
      if (steps == null) {
        steps = false;
      }
      return this.getExpression(expression, function() {
        try {
          return this.getTree(expression, true, steps).applyRules(CTATLogicParser.NNFRules, false, true);
        } catch (_error) {
          return null;
        }
      }.call(this));
    };
    CTATLogicParser.prototype.logicSimplifyCNF = function(expression, steps) {
      if (steps == null) {
        steps = false;
      }
      return this.getExpression(expression, function() {
        try {
          return this.getTree(expression, true, steps).applyRules(CTATLogicParser.CNFRules, false, true);
        } catch (_error) {
          return null;
        }
      }.call(this));
    };
    CTATLogicParser.prototype.logicSimplifyDNF = function(expression, steps) {
      if (steps == null) {
        steps = false;
      }
      return this.getExpression(expression, function() {
        try {
          return this.getTree(expression, true, steps).applyRules(CTATLogicParser.DNFRules, false, true);
        } catch (_error) {
          return null;
        }
      }.call(this));
    };
    CTATLogicParser.prototype.logicValid = function(expression) {
      return this.logicParse(expression) != null;
    };
    CTATLogicParser.prototype.logicValued = function(expression, bindings) {
      if (bindings == null) {
        bindings = null;
      }
      return this.logicEvaluate(expression, bindings) != null;
    };
    CTATLogicParser.prototype.logicSorted = function(expression) {
      var expression1, expression2;
      if ((expression1 = this.logicSort(expression)) != null && (expression2 = this.getExpression(expression, this.getTree(expression))) != null) {
        return this.equalExpressions(expression1, expression2);
      } else {
        return null;
      }
    };
    CTATLogicParser.prototype.logicCheckNNF = function(expression) {
      try {
        return this.getTree(expression).applyTests(CTATLogicParser.NNFTests);
      } catch (_error) {
        return null;
      }
    };
    CTATLogicParser.prototype.logicCheckCNF = function(expression) {
      try {
        return this.getTree(expression).applyTests(CTATLogicParser.CNFTests);
      } catch (_error) {
        return null;
      }
    };
    CTATLogicParser.prototype.logicCheckDNF = function(expression) {
      try {
        return this.getTree(expression).applyTests(CTATLogicParser.DNFTests);
      } catch (_error) {
        return null;
      }
    };
    CTATLogicParser.prototype.logicSimplifiedNNF = function(expression) {
      var expression1, expression2;
      if ((expression1 = this.logicSimplifyNNF(expression)) != null && (expression2 = this.logicSort(expression)) != null) {
        return this.equalExpressions(expression1, expression2);
      } else {
        return null;
      }
    };
    CTATLogicParser.prototype.logicSimplifiedCNF = function(expression) {
      var expression1, expression2;
      if ((expression1 = this.logicSimplifyCNF(expression)) != null && (expression2 = this.logicSort(expression)) != null) {
        return this.equalExpressions(expression1, expression2);
      } else {
        return null;
      }
    };
    CTATLogicParser.prototype.logicSimplifiedDNF = function(expression) {
      var expression1, expression2;
      if ((expression1 = this.logicSimplifyDNF(expression)) != null && (expression2 = this.logicSort(expression)) != null) {
        return this.equalExpressions(expression1, expression2);
      } else {
        return null;
      }
    };
    CTATLogicParser.prototype.logicIdentical = function(expression1, expression2) {
      if ((expression1 = this.logicSort(expression1)) != null && (expression2 = this.logicSort(expression2)) != null) {
        return this.equalExpressions(expression1, expression2);
      } else {
        return null;
      }
    };
    CTATLogicParser.prototype.logicEqual = function(expression1, expression2, bindings) {
      var value1, value2;
      if (bindings == null) {
        bindings = null;
      }
      value1 = this.logicEvaluate(expression1, bindings);
      value2 = this.logicEvaluate(expression2, bindings);
      if (value1 != null && value2 != null) {
        return value1 === value2;
      } else {
        if (value1 === null || value2 === null) {
          return null;
        } else {
          return void 0;
        }
      }
    };
    CTATLogicParser.prototype.logicEquivalent = function(expression1, expression2) {
      if ((expression1 = this.logicSimplifyDNF(expression1)) != null && (expression2 = this.logicSimplifyDNF(expression2)) != null) {
        return this.equalExpressions(expression1, expression2);
      } else {
        return null;
      }
    };
    CTATLogicParser.prototype.logicSemanticEquivalent = function(expression1, expression2) {
      try {
        return !this.getTree(expression1).findCounterExample(this.getTree(expression2));
      } catch (_error) {
        return null;
      }
    };
    CTATLogicParser.prototype.logicFindCounterExample = function(expression1, expression2) {
      try {
        return this.getTree(expression1).findCounterExample(this.getTree(expression2));
      } catch (_error) {
        return null;
      }
    };
    return CTATLogicParser;
  }();
  if (typeof module !== "undefined" && module !== null) {
    module.exports = CTATLogicParser;
  } else {
    this.CTATLogicParser = CTATLogicParser;
  }
}).call(this);
goog.provide("CTATChemTreeNode");
(function() {
  var CTATChemTreeNode;
  CTATChemTreeNode = function() {
    function CTATChemTreeNode() {
    }
    CTATChemTreeNode.operators = [["CONST"], ["VAR"], ["EXP", "ROOT"], ["UPLUS", "UMINUS"], ["ITIMES", "TIMES", "DIVIDE"], ["IDIVIDE", "REM"], ["PLUS", "MINUS"], ["LESS", "LESSEQUAL", "EQUAL", "NOTEQUAL", "GREATEREQUAL", "GREATER"]];
    CTATChemTreeNode.relationalOperators = ["LESS", "LESSEQUAL", "EQUAL", "NOTEQUAL", "GREATEREQUAL", "GREATER"];
    CTATChemTreeNode.operatorPrecedence = function(operator1, operator2) {
      return Math.sign(this.operators.findIndex(function(group) {
        return group.includes(operator1);
      }) - this.operators.findIndex(function(group) {
        return group.includes(operator2);
      }));
    };
    CTATChemTreeNode.operatorStrings = {"EXP":"^", "ROOT":"|", "UPLUS":"+", "UMINUS":"-", "ITIMES":"", "TIMES":"*", "DIVIDE":"/", "IDIVIDE":"//", "REM":"%", "PLUS":"+", "MINUS":"-", "LESS":"<", "LESSEQUAL":"<=", "EQUAL":"=", "NOTEQUAL":"!=", "GREATEREQUAL":">=", "GREATER":">"};
    CTATChemTreeNode.toOperatorString = function(operator) {
      return this.operatorStrings[operator] || "";
    };
    CTATChemTreeNode.diff = function(list1, list2) {
      return list1.filter(function(item) {
        return !list2.includes(item);
      });
    };
    CTATChemTreeNode.round = function(val, numPlaces) {
      var scaleFactor;
      if (typeof val !== "number") {
        val = parseFloat(val);
      }
      numPlaces = typeof numPlaces === "number" && numPlaces % 1 === 0 ? numPlaces : CTATChemParser.CHEM_DECIMAL_PRECISION;
      if (numPlaces > -1) {
        scaleFactor = Math.pow(10, numPlaces);
        val = Math.round(val * scaleFactor) / scaleFactor;
      }
      return val;
    };
    CTATChemTreeNode.prototype.toString = function(string, symDelim, wrapSymbols) {
      var i, j, ref;
      if (symDelim == null) {
        symDelim = "";
      }
      if (wrapSymbols == null) {
        wrapSymbols = false;
      }
      if (wrapSymbols) {
        string = symDelim + string + symDelim;
      }
      if (this.checkParens()) {
        string = "(" + string + ")";
      }
      if (this.inverted()) {
        string = "1/" + string;
      }
      if (this.negated()) {
        string = "-" + string;
      }
      for (i = j = 0, ref = this.parens;0 <= ref ? j < ref : j > ref;i = 0 <= ref ? ++j : --j) {
        string = "(" + string + ")";
      }
      if (this.units) {
        string += this.units.toString(wrapSymbols);
      }
      return string;
    };
    CTATChemTreeNode.prototype.setParens = function(operator1, right) {
      if (right == null) {
        right = false;
      }
      if (this.checkParens(operator1, right)) {
        this.parens = 1;
      }
      return this;
    };
    CTATChemTreeNode.prototype.checkParens = function(operator1, right) {
      var operator2, precedence;
      if (right == null) {
        right = false;
      }
      if (operator1 != null) {
        operator2 = this.negated() ? "UMINUS" : this.inverted() ? "DIVIDE" : this.operator;
      } else {
        operator1 = this.negated() ? "MINUS" : this.inverted() ? "DIVIDE" : null;
        operator2 = this.operator;
      }
      precedence = CTATChemTreeNode.operatorPrecedence(operator1, operator2);
      return operator1 != null && (precedence < 0 || precedence === 0 && right);
    };
    CTATChemTreeNode.prototype.evaluate = function(value) {
      return this.sign * Math.pow(value, this.exp);
    };
    CTATChemTreeNode.prototype.applyOperator = function(left, right) {
      var res;
      switch(this.operator) {
        case "LESS":
          res = left < right;
          break;
        case "GREATER":
          res = left > right;
          break;
        case "LESSEQUAL":
          res = left <= right;
          break;
        case "GREATEREQUAL":
          res = left >= right;
          break;
        case "EQUAL":
          res = left === right;
          break;
        case "NOTEQUAL":
          res = left !== right;
          break;
        case "PLUS":
          res = CTATChemTreeNode.round(left + right);
          break;
        case "MINUS":
          res = CTATChemTreeNode.round(left - right);
          break;
        case "TIMES":
        ;
        case "ITIMES":
          res = CTATChemTreeNode.round(left * right);
          break;
        case "DIVIDE":
          res = CTATChemTreeNode.round(left / right);
          break;
        case "EXP":
          res = CTATChemTreeNode.round(Math.pow(left, right));
          break;
        case "ROOT":
          res = CTATChemTreeNode.round(Math.pow(left, 1) / right);
          break;
        case "REM":
          res = left % right;
          break;
        case "IDIVIDE":
          res = Math.floor(left / right);
          break;
        case "UPLUS":
          res = left;
          break;
        case "UMINUS":
          res = -left;
          break;
        case "LOG":
          res = Math.log10(left);
          break;
        case "LN":
          res = Math.log(left);
      }
      return res;
    };
    CTATChemTreeNode.prototype.equals = function(node) {
      return node && this.operator === node.operator && this.sign === node.sign && this.exp === node.exp && this.parens === node.parens;
    };
    CTATChemTreeNode.prototype.simplify = function(methods) {
      this.methods = methods;
      return this.simplifyNode(this.methods);
    };
    CTATChemTreeNode.prototype.simplifyNode = function(methods) {
      var j, len, method, ref, result;
      this.methods = methods;
      result = this;
      ref = this.methods;
      for (j = 0, len = ref.length;j < len;j++) {
        method = ref[j];
        result = result[method].call(result);
        result.methods = this.methods;
      }
      delete result.methods;
      return result;
    };
    CTATChemTreeNode.prototype.simpleFlatten = function() {
      return this;
    };
    CTATChemTreeNode.prototype.flatten = function() {
      return this;
    };
    CTATChemTreeNode.prototype.computeConstants = function() {
      return this;
    };
    CTATChemTreeNode.prototype.combineSimilar = function() {
      return this;
    };
    CTATChemTreeNode.prototype.expand = function() {
      return this;
    };
    CTATChemTreeNode.prototype.distribute = function() {
      return this;
    };
    CTATChemTreeNode.prototype.removeIdentity = function() {
      return this;
    };
    CTATChemTreeNode.prototype.sort = function() {
      return this;
    };
    CTATChemTreeNode.prototype.spreadIdentity = function() {
      return this;
    };
    CTATChemTreeNode.prototype.stripIdentity = function() {
      return this;
    };
    CTATChemTreeNode.prototype.multiplyOne = function(marked) {
      if (marked == null) {
        marked = false;
      }
      return (new CTATChemMultiplicationNode("TIMES", [new CTATChemConstantNode(1, marked), this])).popNegation().pushNegation();
    };
    CTATChemTreeNode.prototype.powerOne = function(marked) {
      if (marked == null) {
        marked = false;
      }
      return (new CTATChemPowerNode("EXP", this, new CTATChemConstantNode(1, marked))).popInversion().pushInversion().popNegation();
    };
    CTATChemTreeNode.prototype.compare = function(node, reverse) {
      return CTATChemTreeNode.operatorPrecedence(this.operator, node.operator);
    };
    CTATChemTreeNode.prototype.compareSigns = function(node, reverse) {
      return (Math.sign(this.sign - node.sign) || Math.sign(this.exp - node.exp)) * reverse;
    };
    CTATChemTreeNode.prototype.countVariables = function() {
      return 0;
    };
    CTATChemTreeNode.prototype.pushNegation = function() {
      return this;
    };
    CTATChemTreeNode.prototype.popNegation = function() {
      return this;
    };
    CTATChemTreeNode.prototype.pushInversion = function() {
      return this;
    };
    CTATChemTreeNode.prototype.popInversion = function() {
      return this;
    };
    CTATChemTreeNode.prototype.negate = function() {
      this.sign = -this.sign;
      return this;
    };
    CTATChemTreeNode.prototype.invert = function() {
      this.exp = -this.exp;
      return this;
    };
    CTATChemTreeNode.prototype.addition = function() {
      return this.operator === "PLUS";
    };
    CTATChemTreeNode.prototype.subtraction = function() {
      return this.operator === "MINUS";
    };
    CTATChemTreeNode.prototype.multiplication = function() {
      return this.operator === "TIMES";
    };
    CTATChemTreeNode.prototype.division = function() {
      return this.operator === "DIVIDE";
    };
    CTATChemTreeNode.prototype.intDivision = function() {
      return this.operator === "IDIVIDE";
    };
    CTATChemTreeNode.prototype.power = function() {
      return this.operator === "EXP";
    };
    CTATChemTreeNode.prototype.root = function() {
      return this.operator === "ROOT";
    };
    CTATChemTreeNode.prototype.negation = function() {
      return this.operator === "UMINUS";
    };
    CTATChemTreeNode.prototype.unary = function() {
      var ref;
      return (ref = this.operator) === "UPLUS" || ref === "UMINUS";
    };
    CTATChemTreeNode.prototype.log = function() {
      var ref;
      return (ref = this.operator) === "LOG" || ref === "LN";
    };
    CTATChemTreeNode.prototype.constant = function(value) {
      return false;
    };
    CTATChemTreeNode.prototype.integer = function() {
      return false;
    };
    CTATChemTreeNode.prototype.negated = function() {
      return this.sign < 0;
    };
    CTATChemTreeNode.prototype.inverted = function() {
      return this.exp < 0;
    };
    CTATChemTreeNode.prototype.parented = function() {
      return this.parens > 0;
    };
    CTATChemTreeNode.prototype.even = function() {
      return false;
    };
    CTATChemTreeNode.prototype.setUnit = function(unitExpNode) {
      this.units = unitExpNode;
      return this;
    };
    CTATChemTreeNode.prototype.getVariables = function() {
      return [];
    };
    CTATChemTreeNode.prototype.setVariable = function() {
      return this;
    };
    return CTATChemTreeNode;
  }();
  if (typeof module !== "undefined" && module !== null) {
    module.exports = CTATChemTreeNode;
  } else {
    this.CTATChemTreeNode = CTATChemTreeNode;
  }
}).call(this);
goog.provide("CTATChemRelationNode");
goog.require("CTATChemTreeNode");
(function() {
  var CTATChemRelationNode, extend = function(child, parent) {
    for (var key in parent) {
      if (hasProp.call(parent, key)) {
        child[key] 