/*
 * Decompiled with CFR 0.152.
 */
package pact.CommWidgets;

import edu.cmu.pact.Utilities.trace;
import java.net.URL;
import javax.swing.ImageIcon;

public enum StudentInterfaceConnectionStatus {
    Disconnected("Disconnected"),
    NewlyConnected("Now Connected"),
    Connected("Connected");

    private static final ImageIcon[] icons;
    private final String text;

    private StudentInterfaceConnectionStatus(String text) {
        this.text = text;
    }

    public boolean isConnected() {
        return this != Disconnected;
    }

    public String getConnectionStatus() {
        return this == Disconnected ? "Not Connected" : "Connected";
    }

    public ImageIcon getIcon(boolean isHTMLInterface) {
        String baseName;
        String converted = baseName = this == Disconnected ? "interface_disconnected" : "interface_connected";
        if (isHTMLInterface) {
            converted = baseName + "_html";
        }
        String imageName = "pact/" + converted + ".png";
        trace.out("mg", "imageName: " + imageName);
        URL imageURL = null;
        try {
            imageURL = ((Object)((Object)this)).getClass().getClassLoader().getResource(imageName);
            StudentInterfaceConnectionStatus.icons[this.ordinal()] = new ImageIcon(imageURL);
        }
        catch (Exception e) {
            trace.err((Object)((Object)this) + " error getting image \"" + imageName + "\" from address " + imageURL + ":\n  " + e + (e.getCause() == null ? "" : "; cause: " + e.getCause()));
        }
        return icons[this.ordinal()];
    }

    public String toString() {
        return this.text;
    }

    public static void main(String[] args) {
        System.out.println("values()\n");
        for (StudentInterfaceConnectionStatus studentInterfaceConnectionStatus : StudentInterfaceConnectionStatus.values()) {
            System.out.printf("[%d] %-17s %s\n", new Object[]{studentInterfaceConnectionStatus.ordinal(), studentInterfaceConnectionStatus, studentInterfaceConnectionStatus.toString()});
        }
        System.out.println();
        for (String string : args) {
            try {
                StudentInterfaceConnectionStatus s = StudentInterfaceConnectionStatus.valueOf(string);
                System.out.printf("from %-20s: [%d] %-17s %s\n", new Object[]{string, s.ordinal(), s, s.toString()});
            }
            catch (Exception e) {
                System.out.printf("exception on valueOf(\"%s\"): %s;\n  cause: \n", string, e.toString(), e.getCause() == null ? "null" : e.getCause().toString());
            }
        }
    }

    static {
        icons = new ImageIcon[StudentInterfaceConnectionStatus.values().length];
    }
}

