/*
 * Decompiled with CFR 0.152.
 */
package pact.CommWidgets;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.View.HintWindow.Hints;
import edu.cmu.pact.Utilities.SocketReader;
import edu.cmu.pact.Utilities.Utils;
import edu.cmu.pact.Utilities.VersionComparator;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.MessageObject;
import edu.cmu.pact.ctat.model.CtatListModel;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import pact.CommWidgets.UniversalToolProxy;

public abstract class RemoteToolProxy
extends UniversalToolProxy {
    public static final int NO_FMT = -1;
    public static final int COMM_FMT = 0;
    public static final int XMLCONVERTER_FMT = 1;
    public static final int OLI_XML_FMT = 2;
    private static List<String> FlashActionNames = Arrays.asList("UpdateTextArea", "showDone", "ChangeHorizontalUnit", "UpdateComboBox", "OkayPressed", "ChangeVerticalLabel", "UpdateTextField", "ComponentReset", "ChangeVerticalUnit", "goToStep", "SpecifiedAngleSet", "setFinalPie", "ButtonPressed", "playClip", "hideAllBars", "showStep", "Solver_startProblem", "solverMethod", "WasJustHitByA", "UpdateText", "ChangeHorizontalInterval", "UpdateRadioButton", "FractionBarBlockDrop", "UpdateCheckBox", "grapherPointAdded", "SetVisible", "replaceAnswer", "Partition", "addPointTPA", "PieChartSubmit", "processFormula", "ChangeVerticalInterval", "FractionBarSubmit", "SetText", "FractionBarBlockDrag", "No_Action", "highlightAnswer", "grapherCurveAdded", "SetPieces", "assignImageURL", "littleTickmarks", "PieSliceDrop", "StopPointAddIntent", "pieReset", "IndicatePointAddIntent", "ShowAllBars", "setNumberLine", "GotoAndStop", "ChangeHorizontalLabel", "PieSliceDrag", "showAdviceQ");
    private static List<String> FlashFixedSelectionNames = Arrays.asList("_root");
    private int format = 0;
    private Map<String, StringBuffer> bundles = new HashMap<String, StringBuffer>();
    private boolean storeAllInterfaceDescriptions = false;
    protected Set<Thread> waitingThreads = new LinkedHashSet<Thread>();
    private static final Set<String> msgTypesToSendWhileRestoring;
    protected PrintWriter teeOut = null;
    protected Socket teeSock = null;
    protected int teeFormat = -1;
    protected int eom = -1;
    protected int destPort = 1501;

    protected abstract Object getSocket();

    protected String createMessageString(MessageObject o, boolean pssOverride) {
        if (!this.allowWhileRestoringProblemState(o, pssOverride)) {
            return null;
        }
        if (this.suppressFeedback(o).tutorSuppresses()) {
            return null;
        }
        if (trace.getDebugCode("mo")) {
            trace.out("mo", "STP.handleMessage tid=" + o.getTransactionId() + "\n" + o);
        }
        return o.toString();
    }

    protected abstract void sendXMLString(String var1);

    private void updateSAITable(MessageObject msg) {
        BR_Controller ctlr = this.getController();
        if (ctlr == null || Utils.isRuntime()) {
            return;
        }
        if (!"InterfaceAction".equalsIgnoreCase(msg.getMessageType())) {
            return;
        }
        Object s = msg.getProperty("Selection");
        Object a = msg.getProperty("Action");
        Object i = msg.getProperty("Input");
        ctlr.updateSAITable((List)(s instanceof List ? s : null), (List)(a instanceof List ? a : null), (List)(s instanceof List ? i : null), Hints.isHintSelection(s) ? "Hint Request" : "Tutored");
    }

    public static String insertXMLPrologue(String str) {
        if (str == null || str.startsWith("<?")) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str);
        sb.insert(0, "<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        return sb.toString();
    }

    public static void sendInterfaceForceDisconnectMsg(BR_Controller controller) {
        if (controller == null) {
            return;
        }
        MessageObject mo = RemoteToolProxy.createInterfaceForceDisconnectMsg(controller.getSemanticEventId());
        controller.handleMessageUTP(mo);
    }

    public static MessageObject createInterfaceForceDisconnectMsg(String transactionId) {
        if (trace.getDebugCode("tsltstp")) {
            trace.printStack("tsltstp", "about to send InterfaceForceDisconnect; transactionId " + transactionId);
        }
        MessageObject mo = MessageObject.create("InterfaceForceDisconnect");
        mo.setVerb("Disconnect");
        mo.setTransactionId(transactionId);
        return mo;
    }

    protected boolean allowWhileRestoringProblemState(MessageObject mo, boolean pssOverride) {
        String msgType = mo.getMessageType();
        BR_Controller controller = null;
        if (msgType != null && msgTypesToSendWhileRestoring.contains(msgType.toLowerCase())) {
            return true;
        }
        controller = this.getController();
        if (controller == null) {
            return true;
        }
        return !controller.isRestoringProblemState(mo.getTransactionId(), pssOverride);
    }

    @Override
    public String getStudentInterfacePlatform() {
        return "HTML & Flash";
    }

    @Override
    public void bundleMessage(MessageObject o, String bundleName, String endMsgType) {
        this.bundleMessage(o, bundleName, endMsgType.equalsIgnoreCase(o.getMessageType()));
    }

    public void bundleMessage(MessageObject o, String bundleName, boolean flush) {
        boolean suppress = this.suppressMsgFromInterface(o);
        if (trace.getDebugCode("msg")) {
            trace.out("msg", String.format("RTP.bundleMessage(%-20.35s..., %s, %b) suppress %b", o, bundleName, flush, suppress));
        }
        if (suppress) {
            return;
        }
        String toSend = this.createMessageString(o, false);
        if (trace.getDebugCode("msg")) {
            trace.out("msg", "RTP.bundleMessage toSend\n" + toSend);
        }
        if (toSend == null) {
            return;
        }
        StringBuffer bundle = this.bundles.get(bundleName);
        if (bundle != null) {
            bundle.append(toSend);
            if (flush) {
                this.flushBundle(bundle, bundleName);
            }
        } else if (flush) {
            this.sendXMLString(toSend);
        } else {
            bundle = new StringBuffer();
            bundle.append("<").append(bundleName).append(">");
            bundle.append(toSend);
            this.bundles.put(bundleName, bundle);
        }
    }

    protected int flushBundle(StringBuffer bundle, String bundleName) {
        if (bundle == null && (bundle = this.bundles.get(bundleName)) == null) {
            return 0;
        }
        bundle.append("</").append(bundleName).append(">");
        this.sendXMLString(bundle.toString());
        this.bundles.remove(bundleName);
        return bundle.length();
    }

    @Override
    public void handleMessageByPlatform(MessageObject o, boolean pssOverride) {
        if (this.checkMessage(o)) {
            return;
        }
        String toSend = this.createMessageString(o, pssOverride);
        if (toSend == null) {
            return;
        }
        this.sendXMLString(toSend);
    }

    public void setFormat(int format) {
        this.format = format == 2 || format == 1 ? format : 0;
    }

    public int getFormat() {
        return this.format;
    }

    @Override
    public boolean getAllInterfaceDescriptions() {
        if (!this.getStudentInterfaceConnectionStatus().isConnected()) {
            return false;
        }
        if (this.getController().clientSupports("StartStateMessages").booleanValue()) {
            this.getController().redirectNextBundle("GetAllInterfaceDescriptions");
        }
        if (this.getController().clientSupports("GetAllInterfaceDescriptions").booleanValue()) {
            this.handleMessage(MessageObject.create("GetAllInterfaceDescriptions"));
        } else {
            this.handleMessage(MessageObject.create("GetAllInterfaceDescriptions"));
            this.handleMessage(MessageObject.create("StartProblem"));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareForDisconnect() {
        Set<Thread> set = this.waitingThreads;
        synchronized (set) {
            for (Thread t : this.waitingThreads) {
                t.interrupt();
            }
            this.waitingThreads.clear();
        }
    }

    public static List<String> getFlashActionNames() {
        return FlashActionNames;
    }

    @Override
    public List<String> listActionNames() {
        return RemoteToolProxy.getFlashActionNames();
    }

    @Override
    protected List<String> listFixedSelectionNames() {
        return RemoteToolProxy.getFlashFixedSelectionNames();
    }

    public static List<String> getFlashFixedSelectionNames() {
        return FlashFixedSelectionNames;
    }

    @Override
    public void listSelectionNames(CtatListModel listModel) {
        if (this.getStartStateModel().nInterfaceDescriptionsFromInterface() > 0) {
            listModel.addAll(this.getStartStateModel().getComponentNames());
        } else {
            this.addStartStateListener(listModel);
            this.getController().redirectNextBundle("GetAllInterfaceDescriptions");
            this.handleMessage(MessageObject.create("GetAllInterfaceDescriptions"));
            if (trace.getDebugCode("editstudentinput")) {
                trace.printStack("editstudentinput", "RTP.listSelectionNames(" + trace.nh(listModel) + ") n listeners " + this.startStateListeners.size());
            }
        }
    }

    @Override
    public Boolean clientSupports(String msgType, String commShellVersion) {
        boolean result = "StartStateMessages".equalsIgnoreCase(msgType) ? commShellVersion != null : ("GetAllInterfaceDescriptions".equalsIgnoreCase(msgType) ? VersionComparator.vc.compare("3.3", commShellVersion) <= 0 : ("InterfaceReboot".equalsIgnoreCase(msgType) ? VersionComparator.vc.compare("3.3", commShellVersion) <= 0 : true));
        if (trace.getDebugCode("msg")) {
            trace.out("msg", "RTP.clientSupports(" + msgType + ", " + commShellVersion + ") returns " + result);
        }
        return result ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public boolean getStoreAllInterfaceDescriptions() {
        return this.storeAllInterfaceDescriptions;
    }

    @Override
    public void setStoreAllInterfaceDescriptions(boolean storeAllInterfaceDescriptions) {
        if (trace.getDebugCode("intdesc")) {
            trace.printStack("intdesc", "PM.setStoreAllInterfaceDescriptions(" + storeAllInterfaceDescriptions + ")");
        }
        this.storeAllInterfaceDescriptions = storeAllInterfaceDescriptions;
    }

    public void setTeeSocket(Socket teeSock, int teeFormat) {
        if (trace.getDebugCode("sp")) {
            trace.out("sp", "SocketToolProxy: old tee socket " + this.teeSock + ", new socket " + teeSock);
        }
        if (this.teeOut != null) {
            this.teeOut.flush();
            this.teeOut.close();
        }
        this.teeOut = null;
        if (this.teeSock != teeSock) {
            try {
                if (this.teeSock != null) {
                    this.teeSock.close();
                }
                this.teeSock = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.teeSock = teeSock;
        this.teeFormat = teeFormat;
        if (teeSock == null) {
            return;
        }
        try {
            this.getTeeSocket();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setTeeSocket(Socket teeSock2) {
        this.setTeeSocket(teeSock2, this.teeFormat);
    }

    public Socket getTeeSocket() {
        try {
            if (this.teeOut == null && this.teeSock != null) {
                this.teeOut = new PrintWriter(new OutputStreamWriter(this.teeSock.getOutputStream(), "UTF-8"));
            }
        }
        catch (Exception e) {
            trace.err("error opening output stream for teeSock: " + e);
            e.printStackTrace();
        }
        return this.teeSock;
    }

    public void sendToTee(String str) {
        if (str == null) {
            return;
        }
        try {
            this.getTeeSocket();
            if (this.teeOut != null) {
                str = RemoteToolProxy.insertXMLPrologue(str);
                if (trace.getDebugCode("sp")) {
                    trace.out("sp", "SocketToolProxy: sendToTee:\n" + str);
                }
                SocketReader.sendString(str, this.teeOut, this.eom);
            }
        }
        catch (Exception e) {
            trace.err("SocketToolProxy failed to connect outgoing socket to Tutor Interface: " + e.toString());
        }
    }

    public int getEom() {
        return this.eom;
    }

    public void setEom(int eom) {
        this.eom = eom;
    }

    public int getDestPort() {
        return this.destPort;
    }

    public void setDestPort(int newnum) {
        this.destPort = newnum;
    }

    public static int deriveMsgFormat(String msg) {
        if (msg.charAt(0) == '[') {
            return 0;
        }
        if (MessageObject.getPropertyFromXML(msg, "MessageType") != null) {
            return 1;
        }
        return 2;
    }

    static {
        Collections.sort(FlashActionNames, String.CASE_INSENSITIVE_ORDER);
        Collections.sort(FlashFixedSelectionNames, String.CASE_INSENSITIVE_ORDER);
        msgTypesToSendWhileRestoring = new HashSet<String>();
        msgTypesToSendWhileRestoring.add("VersionInfo".toLowerCase());
        msgTypesToSendWhileRestoring.add("ProblemRestoreEnd".toLowerCase());
    }
}

