/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss;

import aima.search.framework.GoalTest;
import cl.tutors.solver.SolverTutor;
import cl.utilities.TestableTutor.InvalidParamException;
import cl.utilities.TestableTutor.SAI;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ExampleTracerEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemEdge;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemNode;
import edu.cmu.pact.miss.HashMap;
import edu.cmu.pact.miss.QuizState;
import edu.cmu.pact.miss.SimStInteractiveLearning;
import java.util.Vector;

public class QuizGoalTest
implements GoalTest {
    private static HashMap hm = new HashMap();
    private SolverTutor clSolverTutor = null;
    private String originalEquation = "3x+6 = 15";
    private String prevStep = "3x = 9";
    private String finalStep = "x = 3";

    public boolean isGoalState(Object state) {
        boolean isGoalState = false;
        QuizState quizState = (QuizState)state;
        if (hm.containsKey(quizState.getOriginalEqn())) {
            isGoalState = this.checkGoalReached(quizState);
        } else {
            this.findSolution(quizState);
            isGoalState = this.checkGoalReached(quizState);
        }
        return isGoalState;
    }

    private void findSolution(QuizState quizState) {
        boolean goalReached = false;
        SAI finalStep = null;
        ExampleTracerEvent objETEvent = new ExampleTracerEvent(new Object());
        SolverTutor solverTutor = this.getClSolverTutor();
        try {
            solverTutor.setParameter("Solver", "TypeInMode", "false");
            solverTutor.setParameter("Solver", "AutoSimplify", "true");
            solverTutor.setCltPmWholeSide(true);
        }
        catch (InvalidParamException e) {
            e.printStackTrace();
        }
        if (solverTutor != null) {
            solverTutor.startProblem(quizState.getOriginalEqn());
            finalStep = solverTutor.solveIt(objETEvent, true);
        } else {
            try {
                throw new Exception("SolverTutor not initialized. Aborting");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        hm.put(quizState.getOriginalEqn().trim(), this.setSolutionInCorrectForm(finalStep.getSelection().trim()));
    }

    private boolean checkGoalReached(QuizState quizState) {
        boolean goalReached = false;
        if (quizState.isDoneStep() && hm.get(quizState.getOriginalEqn()).toString().equalsIgnoreCase(this.setSolutionInCorrectForm(quizState.getPreviousStep()))) {
            goalReached = true;
            quizState.getSsInteractiveLearning();
            ProblemNode startNode = SimStInteractiveLearning.brController.getProblemModel().getStartNode();
            ProblemNode endNode = quizState.getProbNode();
            Vector<ProblemEdge> solution = new Vector<ProblemEdge>();
            quizState.getSsInteractiveLearning();
            SimStInteractiveLearning.brController.findPreferredPath(startNode, endNode, solution);
            quizState.getSimStPLE().setSolutionEdges(solution);
        }
        return goalReached;
    }

    private String setSolutionInCorrectForm(String answer) {
        String formattedSoln = null;
        String[] solutionParts = answer.split("=");
        if (solutionParts.length < 2) {
            return answer;
        }
        String firstPart = solutionParts[0].trim();
        String secondPart = solutionParts[1].trim();
        formattedSoln = firstPart.length() == 1 && Character.isLetter(firstPart.charAt(0)) ? firstPart + " = " + secondPart : secondPart + " = " + firstPart;
        return formattedSoln;
    }

    public QuizGoalTest() {
        this.setClSolverTutor(new SolverTutor());
    }

    public static void main(String[] args) {
    }

    public SolverTutor getClSolverTutor() {
        return this.clSolverTutor;
    }

    public void setClSolverTutor(SolverTutor clSolverTutor) {
        this.clSolverTutor = clSolverTutor;
    }
}

