/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss.PeerLearning;

import edu.cmu.pact.BehaviorRecorder.View.JUndo;
import edu.cmu.pact.miss.PeerLearning.AplusPlatform;
import edu.cmu.pact.miss.PeerLearning.SimStLogger;
import edu.cmu.pact.miss.PeerLearning.SimStPLE;
import edu.cmu.pact.miss.PeerLearning.SimStPeerTutoringPlatform;
import edu.cmu.pact.miss.PeerLearning.StudentAvatarDisplay;
import edu.cmu.pact.miss.SimSt;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Calendar;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class StudentAvatarDesigner
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private SimStPeerTutoringPlatform gui = null;
    static JFrame frame = null;
    private JLayeredPane layeredPane;
    protected JLabel backgroundLabel;
    protected JLabel hairLabel;
    protected JLabel shirtLabel;
    protected JLabel faceLabel;
    private JButton nextBackground;
    private JButton nextHair;
    private JButton nextShirt;
    private JButton prevBackground;
    private JButton prevHair;
    private JButton prevShirt;
    protected JButton random;
    protected JButton save;
    int backgroundIndex = 0;
    int hairIndex = 0;
    int shirtIndex = 0;
    int faceIndex = 0;
    protected JTextField name;
    protected String accountName = "default";
    SimStLogger logger;
    protected String[] silhouettes = new String[]{"img/head1.png", "img/head2.png", "img/head3.png", "img/head4.png"};
    protected String[] hairdos = new String[]{"img/hair1.png", "img/hair2.png", "img/hair3.png", "img/hair4.png", "img/hair5.png", "img/hair6.png", "img/hair7.png", "img/hair8.png", "img/hair9.png", "img/hair10.png", "img/hair11.png", "img/hair12.png"};
    protected String[] shirts = new String[]{"img/shirt1.png", "img/shirt2.png", "img/shirt3.png", "img/shirt4.png", "img/shirt5.png", "img/shirt6.png", "img/shirt7.png", "img/shirt8.png"};
    protected String[] faces = new String[]{"img/face1.png", "img/face2.png", "img/face3.png", "img/face4.png", "img/face5.png"};
    protected long startTime;
    JPanel optionPanel;
    JPanel buttonPanel;

    public StudentAvatarDesigner(SimStPeerTutoringPlatform gui, String userid) {
        this.gui = gui;
        this.accountName = userid;
        this.setup();
        this.logger = new SimStLogger(gui.getBrController());
    }

    public StudentAvatarDesigner() {
        this.setup();
    }

    protected void createOptionPanel() {
        this.optionPanel = new JPanel();
        this.optionPanel.setLayout(new BoxLayout(this.optionPanel, 3));
        JPanel skinPanel = new JPanel();
        skinPanel.setLayout(new BoxLayout(skinPanel, 0));
        this.optionPanel.add(skinPanel);
        JPanel hairPanel = new JPanel();
        hairPanel.setLayout(new BoxLayout(hairPanel, 0));
        this.optionPanel.add(hairPanel);
        JPanel shirtPanel = new JPanel();
        shirtPanel.setLayout(new BoxLayout(shirtPanel, 0));
        this.optionPanel.add(shirtPanel);
        JLabel skinChangeLabel = new JLabel("   Skin Color   ");
        JLabel hairChangeLabel = new JLabel("   Hair   ");
        JLabel shirtChangeLabel = new JLabel("   Shirt   ");
        this.prevBackground = new JButton("<");
        skinPanel.add(this.prevBackground);
        this.prevBackground.addActionListener(this);
        skinPanel.add(skinChangeLabel);
        this.prevHair = new JButton("<");
        hairPanel.add(this.prevHair);
        this.prevHair.addActionListener(this);
        hairPanel.add(hairChangeLabel);
        this.prevShirt = new JButton("<");
        shirtPanel.add(this.prevShirt);
        this.prevShirt.addActionListener(this);
        shirtPanel.add(shirtChangeLabel);
        this.nextBackground = new JButton(">");
        skinPanel.add(this.nextBackground);
        this.nextBackground.addActionListener(this);
        this.nextHair = new JButton(">");
        hairPanel.add(this.nextHair);
        this.nextHair.addActionListener(this);
        this.nextShirt = new JButton(">");
        shirtPanel.add(this.nextShirt);
        this.nextShirt.addActionListener(this);
    }

    protected void createButtonPanel() {
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 3));
        JPanel namePanel = new JPanel();
        namePanel.setLayout(new BoxLayout(namePanel, 0));
        JLabel nameLabel = new JLabel(" Student Name: ");
        this.buttonPanel.add(namePanel);
        namePanel.add(nameLabel);
        this.name = new JTextField();
        JUndo.JTextUndoPacket jTextUndoPacket = JUndo.makeTextUndoable(this.name);
        namePanel.add(this.name);
        this.random = new JButton("Randomize");
        this.buttonPanel.add(this.random);
        this.random.addActionListener(this);
        this.save = new JButton("Save");
        this.buttonPanel.add(this.save);
        this.save.addActionListener(this);
    }

    public void createLayeredImage() {
        ImageIcon icon = this.createImageIcon(this.silhouettes[this.backgroundIndex]);
        ImageIcon icon2 = this.createImageIcon(this.hairdos[this.hairIndex]);
        ImageIcon icon5 = this.createImageIcon(this.shirts[this.shirtIndex]);
        ImageIcon icon6 = this.createImageIcon(this.faces[this.faceIndex]);
        this.layeredPane = new JLayeredPane();
        this.layeredPane.setPreferredSize(new Dimension(StudentAvatarDisplay.PREFERRED_WIDTH, StudentAvatarDisplay.PREFERRED_HEIGHT));
        this.backgroundLabel = new JLabel(icon);
        if (icon != null) {
            this.backgroundLabel.setBounds(0, 0, icon.getIconWidth(), icon.getIconHeight());
        }
        this.layeredPane.add(this.backgroundLabel, new Integer(2), 0);
        this.hairLabel = new JLabel(icon2);
        if (icon2 != null) {
            this.hairLabel.setBounds(0, 0, icon.getIconWidth(), icon.getIconHeight());
        }
        this.layeredPane.add(this.hairLabel, new Integer(3), 0);
        this.shirtLabel = new JLabel(icon5);
        if (icon != null) {
            this.shirtLabel.setBounds(0, 0, icon.getIconWidth(), icon.getIconHeight());
        }
        this.layeredPane.add(this.shirtLabel, new Integer(1), 0);
        this.faceLabel = new JLabel(icon6);
        if (icon != null) {
            this.faceLabel.setBounds(0, 0, icon.getIconWidth(), icon.getIconHeight());
        }
        this.layeredPane.add(this.faceLabel, new Integer(3), 0);
    }

    public JPanel getOptionPanel() {
        return this.optionPanel;
    }

    public JPanel getButtonPanel() {
        return this.buttonPanel;
    }

    public JLayeredPane getLayeredImage() {
        return this.layeredPane;
    }

    public void setup() {
        this.startTime = Calendar.getInstance().getTimeInMillis();
        this.setLayout(new BoxLayout(this, 3));
        this.createOptionPanel();
        this.add(this.getOptionPanel());
        this.randomize();
        this.createLayeredImage();
        this.add(Box.createRigidArea(new Dimension(0, 10)));
        this.add(this.getLayeredImage());
        this.createButtonPanel();
        this.add(this.getButtonPanel());
        frame.setPreferredSize(new Dimension(300, 400));
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLocation(screenSize.width / 2, screenSize.height / 4);
    }

    protected ImageIcon createImageIcon(String path) {
        String file = "/edu/cmu/pact/miss/PeerLearning/" + path;
        URL url = this.getClass().getResource(file);
        return new ImageIcon(url);
    }

    protected static void createAndShowGUI(SimStPeerTutoringPlatform gui, String userid) {
        if (frame == null) {
            frame = new JFrame("Customize Your Student");
            frame.setDefaultCloseOperation(1);
        }
        StudentAvatarDesigner newContentPane = new StudentAvatarDesigner(gui, userid);
        newContentPane.setOpaque(true);
        frame.setContentPane(newContentPane);
        frame.setAlwaysOnTop(true);
        frame.pack();
        frame.setVisible(true);
    }

    protected static void createAndShowGUI() {
        if (frame == null) {
            frame = new JFrame("Customize Your Student");
            frame.setDefaultCloseOperation(1);
        }
        StudentAvatarDesigner newContentPane = new StudentAvatarDesigner();
        newContentPane.setOpaque(true);
        frame.setContentPane(newContentPane);
        frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                StudentAvatarDesigner.createAndShowGUI();
            }
        });
    }

    protected void randomize() {
        this.backgroundIndex = (int)(Math.random() * (double)this.silhouettes.length);
        this.hairIndex = (int)(Math.random() * (double)this.hairdos.length);
        this.shirtIndex = (int)(Math.random() * (double)this.shirts.length);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getSource() == this.save) {
            int acceptableNameLength = 16;
            String saveString = "%";
            saveString = saveString + this.silhouettes[this.backgroundIndex] + "%";
            saveString = saveString + this.hairdos[this.hairIndex] + "%";
            SimStPLE.STUDENT_IMAGE = saveString = saveString + this.shirts[this.shirtIndex];
            if (this.gui != null && this.gui.getSimStAvatarLayerIcon() != null) {
                this.gui.setImage(saveString);
            }
            if (this.name.getText().length() > 0) {
                String ssName = this.name.getText();
                if (ssName.length() > acceptableNameLength) {
                    ssName = ssName.substring(0, acceptableNameLength);
                }
                SimSt.setSimStName(ssName);
                if (this.gui != null && this.gui.getSimStNameLabel() != null) {
                    this.gui.setName(ssName);
                }
                if (this.gui != null && this.gui instanceof AplusPlatform) {
                    ((AplusPlatform)this.gui).updateSkillometerLabelText(ssName);
                    String msg = ((AplusPlatform)this.gui).getSpeechText().getText();
                    msg = msg.replaceAll("[Jj][Oo][Ee][:]", "");
                    msg = msg.replace('\n', ' ');
                    ((AplusPlatform)this.gui).clearSpeech();
                    ((AplusPlatform)this.gui).appendSpeech(msg, SimSt.SimStName);
                }
            }
            frame.setVisible(false);
            SimStPLE.saveAccountFile(this.accountName + ".account");
            int duration = (int)(Calendar.getInstance().getTimeInMillis() - this.startTime);
            this.logger.simStShortLog("SIM_STUDENT_PLE", "Avatar Image Saved", this.name.getText(), saveString, duration);
            return;
        }
        if (arg0.getSource() == this.nextBackground) {
            ++this.backgroundIndex;
        }
        if (this.backgroundIndex >= this.silhouettes.length) {
            this.backgroundIndex = 0;
        }
        if (arg0.getSource() == this.nextHair) {
            ++this.hairIndex;
        }
        if (this.hairIndex >= this.hairdos.length) {
            this.hairIndex = 0;
        }
        if (arg0.getSource() == this.nextShirt) {
            ++this.shirtIndex;
        }
        if (this.shirtIndex >= this.shirts.length) {
            this.shirtIndex = 0;
        }
        if (arg0.getSource() == this.prevBackground) {
            --this.backgroundIndex;
        }
        if (this.backgroundIndex < 0) {
            this.backgroundIndex = this.silhouettes.length - 1;
        }
        if (arg0.getSource() == this.prevHair) {
            --this.hairIndex;
        }
        if (this.hairIndex < 0) {
            this.hairIndex = this.hairdos.length - 1;
        }
        if (arg0.getSource() == this.prevShirt) {
            --this.shirtIndex;
        }
        if (this.shirtIndex < 0) {
            this.shirtIndex = this.shirts.length - 1;
        }
        if (arg0.getSource() == this.random) {
            this.randomize();
        }
        ImageIcon icon = this.createImageIcon(this.silhouettes[this.backgroundIndex]);
        ImageIcon icon2 = this.createImageIcon(this.hairdos[this.hairIndex]);
        ImageIcon icon5 = this.createImageIcon(this.shirts[this.shirtIndex]);
        ImageIcon icon6 = this.createImageIcon(this.faces[this.faceIndex]);
        this.backgroundLabel.setIcon(icon);
        this.hairLabel.setIcon(icon2);
        this.shirtLabel.setIcon(icon5);
        this.faceLabel.setIcon(icon6);
    }
}

