/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss.PeerLearning.GameShow;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.miss.PeerLearning.GameShow.Connection;
import edu.cmu.pact.miss.PeerLearning.GameShow.Contestant;
import edu.cmu.pact.miss.PeerLearning.GameShow.GameShowPlatform;
import edu.cmu.pact.miss.PeerLearning.GameShow.GameShowUtilities;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;

public class DummyContestantV2
extends Contestant {
    boolean messageSent = false;

    public DummyContestantV2(BR_Controller brController, GameShowPlatform gameShowPlatform) {
        super(brController, gameShowPlatform);
    }

    @Override
    public void init(String prodRules) {
        try {
            this.echoSocket = new Socket("mocha.pslc.cs.cmu.edu", 4444);
            this.out = new PrintWriter(this.echoSocket.getOutputStream(), true);
            this.in = new BufferedReader(new InputStreamReader(this.echoSocket.getInputStream()));
        }
        catch (UnknownHostException e) {
            System.err.println("Don't know about host.");
            System.exit(1);
        }
        catch (IOException e) {
            System.err.println("Couldn't get I/O for the connection.");
            System.exit(1);
        }
        Connection connection = new Connection(this.echoSocket, this.out, this.in);
        this.listener = new DummyListenerThread(connection);
        new Thread(this.listener).start();
        this.out.println("JoinProgram," + this.nameImg + "," + this.getSimSt().getUserID() + "," + this.getBrController().getLogger().getClassName() + ",static");
    }

    @Override
    public void addPrivateChatMessage(String incomingMsg) {
        String chat = incomingMsg.substring(incomingMsg.indexOf(44) + 1);
        this.gameShowPlatform.addPrivateChatText(chat);
        if (!chat.startsWith(this.name) && !this.messageSent) {
            this.messageSent = true;
            this.out.println("ChatPrivateMessage,I am not a real person.");
        }
    }

    @Override
    public void requestProblem(String incomingMsg) {
        String problem = GameShowUtilities.generate();
        this.out.println("SubmitProblems," + problem);
    }

    class DummyListenerThread
    extends Contestant.ListenerThread {
        DummyListenerThread(Connection connect) {
            super(connect);
        }

        @Override
        protected void contestAgreed(String incomingMsg) {
        }

        @Override
        protected void contestRequested(String incomingMsg) {
            String[] args = incomingMsg.split(",");
            this.connection.writer.println("AgreeContest," + args[1] + ",true");
        }

        @Override
        protected void endContest(String incomingMsg) {
            DummyContestantV2.this.messageSent = false;
            DummyContestantV2.this.gameShowPlatform.viewMatchup();
            this.connection.writer.println("JoinProgram," + DummyContestantV2.this.nameImg + "," + DummyContestantV2.this.getBrController().getLogger().getClassName() + "," + DummyContestantV2.this.getSimSt().getUserID() + ",static");
        }

        protected void forfeitContest(String incomingMsg) {
            DummyContestantV2.this.messageSent = false;
            DummyContestantV2.this.gameShowPlatform.viewMatchup();
            this.connection.writer.println("JoinProgram," + DummyContestantV2.this.nameImg + "," + DummyContestantV2.this.getSimSt().getUserID() + "," + DummyContestantV2.this.getBrController().getLogger().getClassName() + ",static");
        }
    }
}

