/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.ctat.view;

import edu.cmu.pact.BehaviorRecorder.Controller.CTAT_Launcher;
import edu.cmu.pact.Log.AuthorLogListener;
import edu.cmu.pact.Preferences.PreferencesModel;
import edu.cmu.pact.Utilities.CTAT_Controller;
import edu.cmu.pact.Utilities.trace;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import pact.CommWidgets.TutorWrapper;

public abstract class AbstractCtatWindow
extends JFrame
implements ComponentListener,
WindowFocusListener {
    private static final long serialVersionUID = 8372065524741088804L;
    public static JFrame mainFrame = null;
    public JMenuItem showBR;
    public JMenuItem showWMEEditorWindow;
    public JMenuItem showJessConsoleWindow;
    public JMenuItem showConflictTreeWindow;
    public JMenuItem showStudentInterface;
    private boolean isDockable;
    public static final String DEFAULT_JESS_EDITOR = "Jess File Editor";
    public static final String AUTHORINGTOOLS_LISTENING_PORT = "Authoring Tools Listening Port";
    public static final String FOCUS_LOST = "FOCUS_LOST";
    public static final String FOCUS_GAINED = "FOCUS_GAINED";
    public static final String CLOSE = "CLOSE";
    public static final String ICONIFY = "ICONIFY";
    public static final String DEICONIFY = "DEICONIFY";
    protected CTAT_Controller controller;
    protected CTAT_Launcher server;

    @Override
    public void addWindowListener(WindowListener wl) {
        super.addWindowListener(wl);
    }

    public AbstractCtatWindow(CTAT_Launcher server) {
        Image image;
        mainFrame = this;
        this.addComponentListener(this);
        this.isDockable = true;
        this.server = server;
        this.addWindowFocusListener(this);
        if (this.server.getLoggingSupport() != null) {
            this.addWindowListener(new AuthorLogListener(this.server.getLoggingSupport()));
        }
        if ((image = new ImageIcon("ctaticon.png").getImage()) != null && image.getHeight(null) != -1) {
            this.setIconImage(image);
        }
    }

    public void applyPreferences() {
        trace.out("wh", "!! apply preferences for " + this.getName());
        PreferencesModel model = this.server.getPreferencesModel();
        String x_loc = this.getName() + " Location X";
        String y_loc = this.getName() + " Location Y";
        String width = this.getName() + " Width";
        String height = this.getName() + " Height";
        Integer X = model.getIntegerValue(x_loc);
        Integer Y = model.getIntegerValue(y_loc);
        int screenWidth = Toolkit.getDefaultToolkit().getScreenSize().width;
        int screenHeight = Toolkit.getDefaultToolkit().getScreenSize().width;
        screenWidth -= 500;
        screenHeight -= 500;
        if ((X == null || Y == null) && this instanceof TutorWrapper) {
            this.setLocation(100, 100);
        } else if (X == null || Y == null) {
            int x = 125;
            int y = 125;
            if (x > screenWidth) {
                x = screenWidth;
            }
            if (y > screenHeight) {
                y = screenHeight;
            }
            this.setLocation(new Point(x, y));
        } else {
            Point p = new Point(X, Y);
            this.setLocation(p);
        }
        Integer Width = model.getIntegerValue(width);
        Integer Height = model.getIntegerValue(height);
        trace.out("wh", "height = " + Height + " width = " + Width);
        if (Height != null && Width != null) {
            this.setSize(new Dimension(Width, Height));
        }
        trace.out("wh", "size = " + this.getSize() + " location = " + this.getLocation());
    }

    @Override
    public void windowGainedFocus(WindowEvent e) {
        if (this.getServer().getLoggingSupport() != null) {
            this.getServer().getLoggingSupport().authorActionLog("CTAT_WINDOW", FOCUS_GAINED, this.getName(), "", (Object)"");
        }
    }

    @Override
    public void windowLostFocus(WindowEvent e) {
        if (this.getServer().getLoggingSupport() != null) {
            this.getServer().getLoggingSupport().authorActionLog("CTAT_WINDOW", FOCUS_LOST, this.getName(), "", (Object)"");
        }
    }

    public JFrame getActiveWindow() {
        AbstractCtatWindow result = this.getServer().getDockedFrame();
        if (result == null) {
            return this;
        }
        return result;
    }

    public void setDockable(boolean dockable) {
        this.isDockable = dockable;
    }

    public boolean isDockable() {
        return this.isDockable;
    }

    public void storeLocation() {
        String loc_x = this.getName() + " Location X";
        String loc_y = this.getName() + " Location Y";
        Point p = this.getLocation();
        trace.out("wh", "store location for " + this.getName() + " p = " + p);
        this.getServer().getPreferencesModel().setIntegerValue(loc_x, new Integer(p.x));
        this.getServer().getPreferencesModel().setIntegerValue(loc_y, new Integer(p.y));
    }

    public void storeSize() {
        String width = this.getName() + " Width";
        String height = this.getName() + " Height";
        Dimension d = this.getSize();
        trace.out("wh", "store size for " + this.getName() + " d = " + d);
        this.getServer().getPreferencesModel().setIntegerValue(width, new Integer(d.width));
        this.getServer().getPreferencesModel().setIntegerValue(height, new Integer(d.height));
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
        this.storeLocation();
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.storeSize();
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    private CTAT_Launcher getServer() {
        return this.server;
    }
}

