/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.Utilities;

import java.io.PrintStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

public class trace {
    public static final String ALL_CODES = "all";
    protected static int tracelevel = 0;
    protected static PrintStream outStream = System.out;
    protected static PrintStream errStream = System.err;
    protected static int traceNumber = 0;
    protected static int traceNumber2 = 0;
    protected static Set<String> debugCodes = new HashSet<String>();
    protected static Set<String> sTraceCodes = new HashSet<String>();
    private static ThreadLocal<String> lastGetDebugCode;
    private static final DateFormat dateFmt;

    public static void setOutStream(PrintStream outStream) {
        trace.outStream = outStream;
    }

    public static void setErrStream(PrintStream errStream) {
        trace.errStream = errStream;
    }

    public static void setTraceLevel(int _tracelevel) {
        tracelevel = _tracelevel;
        tracelevel = Math.max(0, tracelevel);
        trace.out(0, "trace", "new trace level = " + tracelevel);
    }

    public static boolean getDebugCode(String debugCode) {
        boolean result;
        if (debugCode == null || debugCode.length() < 1) {
            return false;
        }
        boolean bl = result = debugCodes.contains(debugCode = debugCode.toLowerCase()) || sTraceCodes.contains(debugCode);
        if (result) {
            lastGetDebugCode.set(debugCode);
        }
        return result;
    }

    public static void addDebugCodes(String codeList) {
        trace.addDebugCodes(codeList, debugCodes, "debug");
    }

    public static void addDebugCodes(String codeList, Set<String> codeSet, String codeSetName) {
        if (codeList == null) {
            return;
        }
        String[] codes = codeList.split("[, ]+");
        for (int i = 0; i < codes.length; ++i) {
            trace.addDebugCode(codes[i], codeSet, codeSetName);
        }
    }

    public static void addDebugCode(String code) {
        trace.addDebugCode(code, debugCodes, "debug");
    }

    public static void addDebugCode(String code, Set<String> codeSet, String codeSetName) {
        if (code == null) {
            return;
        }
        String key = code.toLowerCase();
        if (codeSet.contains(key)) {
            return;
        }
        codeSet.add(key);
        StackTraceElement[] stackTrace = null;
        try {
            throw new Exception();
        }
        catch (Exception e) {
            stackTrace = e.getStackTrace();
            int count = 0;
            while (stackTrace[count].getClassName().indexOf("trace") != -1) {
                ++count;
            }
            int lineNum = stackTrace[count].getLineNumber();
            String classname = stackTrace[count].getClassName();
            String traceString = new String("+trace+ Added " + codeSetName + " code " + code + " <" + classname + ":" + lineNum + ">");
            outStream.println(traceString);
            outStream.flush();
            return;
        }
    }

    public static void removeDebugCode(String code) {
        if (code == null) {
            return;
        }
        debugCodes.remove(code.toLowerCase());
        sTraceCodes.remove(code.toLowerCase());
    }

    public static void resetDebugCodes() {
        debugCodes = new HashSet<String>();
        sTraceCodes = new HashSet<String>();
    }

    public static void printStack(String debugCode) {
        trace.printStack(debugCode, null);
    }

    public static void printStack(String debugCode, String statement) {
        if (sTraceCodes.size() < 1 || !sTraceCodes.contains(ALL_CODES) && !sTraceCodes.contains(debugCode.toLowerCase())) {
            trace.out(debugCode, statement);
            return;
        }
        trace.printStackInternal(debugCode, statement);
    }

    public static void errStack(String statement, Throwable e) {
        trace.err(statement);
        e.printStackTrace(errStream);
        outStream.flush();
    }

    private static void printStackInternal(String debugCode, String statement) {
        try {
            String traceString = "printStack:\n" + new StringBuffer(dateFmt.format(new Date())) + " +" + debugCode + "+ " + ++traceNumber + (statement == null ? "" : ": " + statement + "; " + Thread.currentThread().getName());
            throw new Exception(traceString);
        }
        catch (Exception e) {
            e.printStackTrace(outStream);
            outStream.flush();
            return;
        }
    }

    public static void out(int level, Object callObject, String statement) {
        trace.out(level, callObject.toString(), statement);
    }

    public static void outln(String statement) {
        trace.out(5, "", statement + "\n");
    }

    public static void out(String statement) {
        trace.out(5, "", statement);
    }

    public static void out() {
        trace.out("");
    }

    public static void out(int num) {
        trace.out("" + num);
    }

    public static void out(int level, String statement) {
        trace.out(level, "", statement);
    }

    public static void out(int level, String callObject, String statement) {
        trace.out(level, callObject, statement, null);
    }

    public static void outln(String debugCode, String message) {
        trace.out(5, "", message + "\n", debugCode);
    }

    public static void out(String debugCode, String message) {
        trace.out(5, "", message, debugCode);
    }

    public static void outA(String message) {
        trace.out(-1, "", message, lastGetDebugCode.get());
    }

    public static void out(String traceClassName, String debugCode, String message) {
        trace.out(traceClassName, 5, "", message, debugCode);
    }

    public static void outNT(String debugCode, String message) {
        trace.outNT(5, "", message, debugCode);
    }

    public static void outANT(String message) {
        trace.outNT(-1, "", message, lastGetDebugCode.get());
    }

    public static void outNT(int level, String callObject, String statement, String debugCode) {
        if (!(debugCode == null || debugCodes.contains(ALL_CODES) || debugCodes.contains(debugCode.toLowerCase()) || debugCode.equalsIgnoreCase("error"))) {
            return;
        }
        level = Math.max(1, level);
        if (debugCode == null && level > tracelevel) {
            return;
        }
        ++traceNumber;
        StringBuffer traceString = new StringBuffer(dateFmt.format(new Date()));
        if (debugCode == null) {
            traceString.append(" +trace+ ").append(traceNumber);
        } else {
            traceString.append(" +").append(debugCode).append("+ ").append(traceNumber);
        }
        traceString.append(": ").append(statement);
        outStream.println(traceString);
        outStream.flush();
    }

    public static DateFormat getDateFmt() {
        return dateFmt;
    }

    public static void main(String[] codes) {
        for (String code : codes) {
            debugCodes.add(code.toLowerCase());
        }
        trace.outNT("tsltsp", "here's the request");
        trace.outNT("tsltstp", "here's the response");
    }

    public static void out(int level, String callObject, String statement, String debugCode) {
        trace.out(null, level, callObject, statement, debugCode);
    }

    public static void out(String traceClassName, int level, String callObject, String statement, String debugCode) {
        if (debugCode != null && level != -1 && !debugCodes.contains(ALL_CODES) && !debugCodes.contains(debugCode.toLowerCase())) {
            return;
        }
        level = Math.max(-1, level);
        if (debugCode == null && level > tracelevel) {
            return;
        }
        ++traceNumber;
        StackTraceElement[] stackTrace = null;
        try {
            throw new Exception();
        }
        catch (Exception e) {
            stackTrace = e.getStackTrace();
            int count = 0;
            while (stackTrace[count].getClassName().indexOf("trace") != -1) {
                ++count;
            }
            while (traceClassName != null && stackTrace[count].getClassName().indexOf(traceClassName) != -1) {
                ++count;
            }
            int lineNum = stackTrace[count].getLineNumber();
            String classname = stackTrace[count].getClassName();
            StringBuffer traceString = new StringBuffer(dateFmt.format(new Date()));
            traceString.append(" ");
            if (debugCode == null) {
                traceString.append(level < 0 ? "+err" : "+trace").append("+ ");
            } else {
                traceString.append("+").append(debugCode).append("+ ");
            }
            traceString.append(traceNumber).append(": ").append(statement);
            traceString.append(" <").append(classname).append(":").append(lineNum).append(">");
            traceString.append(Thread.currentThread().getName());
            if (level >= 0) {
                outStream.println(traceString.toString());
                outStream.flush();
            } else {
                errStream.println(traceString.toString());
                errStream.flush();
            }
            return;
        }
    }

    public static void err(String string) {
        trace.out(-1, "", string);
    }

    public static void printStack() {
        trace.printStackInternal("stack", "print debug stack");
    }

    public static void printStackWithStatement(String statement) {
        trace.printStackInternal("stack", statement);
    }

    public static String nh(Object c) {
        if (c == null) {
            return null;
        }
        return c.getClass().getSimpleName() + "@" + c.hashCode();
    }

    public static Set<String> getDebugCodes() {
        return debugCodes;
    }

    static {
        try {
            Properties sysProps = System.getProperties();
            for (Object sysProp : sysProps.keySet()) {
                if (sysProp == null) continue;
                String s = sysProp.toString().toLowerCase();
                if (s.startsWith("debugcode")) {
                    trace.addDebugCodes(sysProps.getProperty(sysProp.toString()), debugCodes, "debug");
                    continue;
                }
                if (!s.startsWith("stracecode")) continue;
                trace.addDebugCodes(sysProps.getProperty(sysProp.toString()), sTraceCodes, "sTrace");
            }
        }
        catch (Exception e) {
            outStream.println("Error getting system properties for trace codes: " + e + "; cause " + e.getCause());
        }
        lastGetDebugCode = new ThreadLocal<String>(){

            @Override
            protected String initialValue() {
                return "traceA";
            }
        };
        dateFmt = new SimpleDateFormat("[HH:mm:ss.SSS]");
    }
}

