/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.JavascriptBridge;

import edu.cmu.pact.BehaviorRecorder.Controller.SingleSessionLauncher;
import edu.cmu.pact.JavascriptBridge.JSProxy;
import edu.cmu.pact.JavascriptBridge.JSToolProxy;
import edu.cmu.pact.TutoringService.TSLauncherServer;
import edu.cmu.pact.TutoringService.TransactionInfo;
import edu.cmu.pact.Utilities.NtpClient;
import edu.cmu.pact.Utilities.trace;
import java.applet.Applet;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import netscape.javascript.JSObject;

public class JSBridge
extends Applet {
    private static final long serialVersionUID = -3215783702142896523L;
    private static URL codeBaseURL;
    private static final String[] DEFAULT_LAUNCHER_ARGUMENTS;
    private JSProxy jsProxy;
    private JSObject window;
    private TSLauncherServer ls = null;

    public static URL getCodeBaseURL() {
        return codeBaseURL;
    }

    public JSBridge() {
        System.out.printf("[%s] +applet+ JSBridge constructor hashCode %d\n", trace.getDateFmt().format(new Date()), this.hashCode());
    }

    @Override
    public void init() {
        codeBaseURL = this.getCodeBase();
        this.ls = new TSLauncherServer(){

            @Override
            public boolean removeSession(String guid) {
                return false;
            }

            @Override
            public void updateTimeStamp(String guid) {
            }

            @Override
            public TransactionInfo.Single createTransactionInfo(String sessionId) {
                return null;
            }

            @Override
            public void updateTransactionInfo(String sessionId, Object info) {
            }

            @Override
            public NtpClient getNtpClient() {
                return null;
            }

            @Override
            public boolean isAuthorMode() {
                return false;
            }
        };
    }

    @Override
    public void stop() {
        if (trace.getDebugCode("applet")) {
            trace.out("applet", "JSBridge.stop(): calling jsProxy.quitActionHandler(); jsProxy " + this.jsProxy + ", hashCode " + this.hashCode());
        }
        this.jsProxy.quitActionHandler();
    }

    @Override
    public void destroy() {
        if (trace.getDebugCode("applet")) {
            trace.out("applet", "JSBridge.destroy(): calling jsProxy.quitActionHandler(); jsProxy " + this.jsProxy + ", hashCode " + this.hashCode());
        }
        this.jsProxy.quitActionHandler();
    }

    @Override
    public void start() {
        String[] argv = this.makeArgv(DEFAULT_LAUNCHER_ARGUMENTS);
        this.window = JSObject.getWindow((Applet)this);
        SingleSessionLauncher launcher = new SingleSessionLauncher(null, null, argv, false, this.ls, null, this);
        this.jsProxy = (JSProxy)launcher.getController().getRemoteProxy();
        if (trace.getDebugCode("applet")) {
            trace.out("applet", "JSBridge.start(): window " + this.window + ", launcher " + launcher + ", .inAppletMode() " + launcher.inAppletMode() + ", jsProxy " + this.jsProxy + ", hashCode " + this.hashCode());
        }
        ((JSToolProxy)this.jsProxy.getToolProxy()).setBridge(this);
        Object[] args = new Object[]{this};
        this.window.call("registerTutor", args);
    }

    private String[] makeArgv(String[] defaultLauncherArguments) {
        ArrayList<String> result = new ArrayList<String>(Arrays.asList(defaultLauncherArguments));
        String debugCodes = this.getParameter("debugCodes");
        if (debugCodes != null) {
            String[] codes = debugCodes.split("[ ,]");
            result.add("-debugCodes");
            for (int j = 0; j < codes.length; ++j) {
                if (codes[j].length() <= 0) continue;
                result.add(codes[j]);
            }
        }
        if (trace.getDebugCode("applet")) {
            trace.out("applet", "JSBridge.makeArgv() result " + result);
        }
        return result.toArray(new String[result.size()]);
    }

    public void receiveFromInterface(String msg) {
        if (trace.getDebugCode("applet")) {
            trace.out("applet", "JSBridge.receiveFromInterface(\"" + msg + "\"), window " + this.window + ", hashCode() " + this.hashCode());
        }
        try {
            this.jsProxy.receiveMessageFromInterface(msg);
        }
        catch (Exception e) {
            this.sendMessage("Caught Exception: " + e.getMessage() + "\n");
            e.printStackTrace();
        }
    }

    public void sendMessage(String msg) {
        Object[] args = new Object[]{msg};
        if (trace.getDebugCode("applet")) {
            trace.out("applet", "JSBridge.sendMessage(" + msg + ") len " + (msg == null ? -1 : msg.length()) + ", window " + this.window + ", hashCode " + this.hashCode());
        }
        try {
            this.window.call("sendToInterface", args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public JSProxy getJSProxy() {
        return this.jsProxy;
    }

    static {
        DEFAULT_LAUNCHER_ARGUMENTS = new String[]{"-useJsBridge", "-debugCodes", "applet"};
    }
}

