/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.StartStateEditor;

import edu.cmu.pact.BehaviorRecorder.StartStateEditor.CTATArgument;
import edu.cmu.pact.BehaviorRecorder.StartStateEditor.CTATJTable;
import edu.cmu.pact.BehaviorRecorder.StartStateEditor.CTATSAI;
import edu.cmu.pact.BehaviorRecorder.StartStateEditor.CTATSerializable;
import edu.cmu.pact.BehaviorRecorder.StartStateEditor.CTATSerializableTableEntry;
import edu.cmu.pact.BehaviorRecorder.StartStateEditor.CTATSheetCellColor;
import edu.cmu.pact.BehaviorRecorder.StartStateEditor.CTATSheetCellRenderer;
import javax.swing.table.TableCellRenderer;

public class CTATPropertyTable
extends CTATJTable {
    private static final long serialVersionUID = -1127341907493007641L;
    private CTATSheetCellRenderer defaultRenderer = null;
    private CTATSheetCellColor colorRenderer = null;

    public CTATPropertyTable() {
        this.debug("CTATPropertyTable ()");
        this.defaultRenderer = new CTATSheetCellRenderer();
        this.colorRenderer = new CTATSheetCellColor(true);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int vColIndex) {
        return vColIndex != 0;
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        this.debug("getCellRenderer (" + row + "," + column + ")");
        if (column == 1 && this.getValueAt(row, column) != null) {
            Object tester = this.getValueAt(row, column);
            if (tester instanceof String) {
                return this.defaultRenderer;
            }
            if (tester instanceof CTATSerializableTableEntry) {
                this.debug("Table value is CTATSerializable");
                CTATSerializableTableEntry entry = (CTATSerializableTableEntry)this.getValueAt(row, column);
                CTATSerializable object = entry.getEntry();
                if (object != null) {
                    this.debug("Cell type: " + object.getType());
                    if (object.getType().equals("Color")) {
                        this.debug("Detected a color entry ...");
                        return this.colorRenderer;
                    }
                    return this.defaultRenderer;
                }
                CTATSAI sai = entry.getSAI();
                if (sai != null) {
                    if (sai.getArgumentSize() == 1 && object.getType().equals("Color")) {
                        this.debug("Detected a color entry ...");
                        return this.colorRenderer;
                    }
                    return this.defaultRenderer;
                }
                CTATArgument arg = entry.getArgument();
                if (arg != null) {
                    if (arg.getType().equals("Color")) {
                        this.debug("Detected a color entry ...");
                        return this.colorRenderer;
                    }
                    return this.defaultRenderer;
                }
                return this.defaultRenderer;
            }
        }
        return super.getCellRenderer(row, column);
    }
}

