/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher;

import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.Matcher;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.VariableTable;
import edu.cmu.pact.Utilities.trace;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Vector;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class AnyMatcher
extends Matcher {
    Element element;
    private Document doc;
    private String selectionValue;
    private String actionValue;
    private String actorValue;
    private Element selectionElement;
    private Element actionElement;
    private Element actorElement;

    public AnyMatcher(boolean concat2, int vector, String value) {
        super(concat2, vector);
    }

    public AnyMatcher() {
        this.initXML();
    }

    private void initXML() {
        this.element = new Element("matcher");
        Element type = new Element("matcherType");
        type.addContent("AnyMatcher");
        this.element.addContent((Content)type);
        this.selectionElement = new Element("matcherParameter");
        this.actionElement = new Element("matcherParameter");
        this.actorElement = new Element("matcherParameter");
        this.element.addContent((Content)this.selectionElement);
        this.element.addContent((Content)this.actionElement);
        this.element.addContent((Content)this.actorElement);
        this.doc = new Document(this.element);
    }

    @Override
    public Object clone() {
        AnyMatcher m = new AnyMatcher(this.concat, this.vector, "dummy");
        m.copyFrom(this);
        m.initXML();
        m.setSelection(this.selectionValue);
        m.setAction(this.actionValue);
        m.setActor(this.actorValue);
        return m;
    }

    @Override
    public String toXML() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            XMLOutputter outp = new XMLOutputter(Format.getPrettyFormat());
            outp.output(this.doc, (OutputStream)out);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        String newString = out.toString();
        newString = newString.substring(newString.indexOf("\n"), newString.length());
        return newString;
    }

    @Override
    public String toXML(String prefix) {
        String xml = this.toXML();
        xml = prefix + xml;
        xml = xml.replaceAll("\n", "\n" + prefix);
        return xml;
    }

    @Override
    public boolean match(Vector selection, Vector action, Vector input) {
        trace.out("mps", "any matcher: matching " + selection + ", " + action + " input = " + input);
        if (selection == null || action == null || input == null) {
            return false;
        }
        if (!selection.get(0).toString().equals(this.selectionValue) || !action.get(0).toString().equals(this.actionValue)) {
            trace.out("mps", "return false: selectionValue = " + this.selectionValue + " action value = " + this.actionValue);
            return false;
        }
        return true;
    }

    @Override
    public String getSelectionLabelText() {
        return this.selectionValue;
    }

    @Override
    public String getActionLabelText() {
        return this.actionValue;
    }

    @Override
    public String getInputLabelText() {
        return "*";
    }

    @Override
    public String getSingleLabelText() {
        return "*";
    }

    @Override
    public boolean matchForHint(Vector selection, Vector action, String actor, VariableTable vt) {
        if (trace.getDebugCode("mps")) {
            trace.out("mps", "any matcher: matching " + selection);
        }
        if (!this.matchActor(actor)) {
            return false;
        }
        if (selection == null) {
            return false;
        }
        if (!selection.get(0).toString().equals(this.selectionValue)) {
            trace.out("mps", "return false: selectionValue = " + this.selectionValue);
            return false;
        }
        return action == null || !action.get(0).toString().equals(this.actionValue);
    }

    @Override
    protected boolean matchInput(Vector v) {
        return true;
    }

    @Override
    protected boolean matchSingle(String s) {
        return true;
    }

    public void setAction(String action) {
        this.actionElement.addContent(action);
        trace.out("mps", "   set action: " + action);
        this.actionValue = action;
    }

    @Override
    public String getAction() {
        return this.actionValue;
    }

    public void setActor(String actor) {
        this.actorElement.addContent(actor);
        this.actorValue = actor;
    }

    @Override
    public String getActor() {
        return this.actorValue;
    }

    public void setSelection(String selection) {
        trace.out("mps", "   set selection: " + selection);
        this.selectionElement.addContent(selection);
        this.selectionValue = selection;
    }

    @Override
    public String getSelection() {
        return this.selectionValue;
    }

    @Override
    public void setParameterByIndex(String stringValue, int index) {
        if (index == 0) {
            this.setSelection(stringValue);
        }
        if (index == 1) {
            this.setAction(stringValue);
        }
        if (index == 2) {
            this.setActor(stringValue);
        }
    }

    @Override
    public void setParameter(Element element2, int index) {
        super.setParameter(element2, index);
        String name = element2.getAttributeValue("name");
        if (name != null && name.length() > 0) {
            if (name.equalsIgnoreCase("selection")) {
                this.setSelection(element2.getText());
                return;
            }
            if (name.equalsIgnoreCase("action")) {
                this.setAction(element2.getText());
                return;
            }
            if (name.equalsIgnoreCase("actor")) {
                this.setActor(element2.getText());
                return;
            }
        }
        this.setParameterInternal(element2, index);
    }

    @Override
    protected void setParameterInternal(Element element2, int index) {
        this.setParameterByIndex(element2.getText(), index);
    }

    @Override
    public Matcher.MatcherParameter getMatcherParameter(int index) {
        if (index == 0) {
            return new Matcher.MatcherParameter("selection", this.getParameter(index));
        }
        if (index == 1) {
            return new Matcher.MatcherParameter("action", this.getParameter(index));
        }
        if (index == 2) {
            return new Matcher.MatcherParameter("actor", this.getParameter(index));
        }
        return null;
    }

    @Override
    public Object getParameter(int index) {
        if (index == 0) {
            return this.getSelection();
        }
        if (index == 1) {
            return this.getAction();
        }
        if (index == 2) {
            return this.getActor();
        }
        return null;
    }

    @Override
    public int getParameterCount() {
        return this.single ? 0 : 3;
    }

    @Override
    public String getMatcherType() {
        return "Any Match";
    }

    @Override
    public String getMatcherTypeText() {
        return "Any";
    }

    @Override
    public String getMatcherClassType() {
        return "AnyMatcher";
    }

    @Override
    public String getActionMatcherType() {
        return "Exact";
    }

    @Override
    public String getInputMatcherType() {
        return this.getMatcherTypeText();
    }

    @Override
    public String getSelectionMatcherType() {
        return "Exact";
    }
}

