/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.ExpressionMatcher.ExpressionTree;

import edu.cmu.pact.BehaviorRecorder.ExpressionMatcher.ExpressionTree.ExpressionTreeNode;
import edu.cmu.pact.BehaviorRecorder.ExpressionMatcher.ExpressionTree.NumberNode;
import edu.cmu.pact.BehaviorRecorder.ExpressionMatcher.ExpressionTreeProperties;
import edu.cmu.pact.Utilities.trace;
import java.util.ArrayList;

public class AdditionNode
extends ExpressionTreeNode {
    public AdditionNode(ArrayList<ExpressionTreeNode> children, Boolean negated, ExpressionTreeProperties properties) {
        super(children, negated, properties);
        if (this.children.size() < 2) {
            throw new Error("AdditionNode constructor being called with children.size < 2");
        }
    }

    @Override
    public AdditionNode clone() {
        ArrayList<ExpressionTreeNode> newChildren = new ArrayList<ExpressionTreeNode>();
        for (int i = 0; i < this.children.size(); ++i) {
            newChildren.add(((ExpressionTreeNode)this.children.get(i)).clone());
        }
        return new AdditionNode(newChildren, this.negated, this.properties);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("AN ");
        if (this.stringNeedsRecreation) {
            sb.append('{');
            if (this.negated) {
                sb.append('!');
            }
            sb.append("addends").append(this.children);
            sb.append('}');
        } else {
            sb.append(this.myString);
        }
        return sb.toString();
    }

    protected ExpressionTreeNode collapseSubTree(boolean simpleTermsOnly) {
        ArrayList<ExpressionTreeNode> addends = new ArrayList<ExpressionTreeNode>();
        for (ExpressionTreeNode child : this.children) {
            if (child.getClass() == AdditionNode.class) {
                ArrayList<ExpressionTreeNode> grandKids = ((AdditionNode)child).collectAddends();
                if (child.negated) {
                    for (int i = 0; i < grandKids.size(); ++i) {
                        grandKids.get(i).negate();
                    }
                }
                addends.addAll(grandKids);
                continue;
            }
            addends.add(child);
        }
        this.children = addends;
        this.stringNeedsRecreation = true;
        ExpressionTreeNode result = this.removeIdentityOperandsAndDemote(simpleTermsOnly);
        return result;
    }

    @Override
    protected ExpressionTreeNode removeIdentityOperandsAndDemote(boolean simpleTermsOnly) {
        if (trace.getDebugCode("functions")) {
            trace.out("functions", "AN.removeIdentityOperandsAndDemote() " + this.getNegatedString() + " recursing down on " + this.children.size() + " children");
        }
        for (int i = 0; i < this.children.size(); ++i) {
            this.children.set(i, ((ExpressionTreeNode)this.children.get(i)).removeIdentityOperandsAndDemote(simpleTermsOnly));
        }
        this.stringNeedsRecreation = true;
        return this;
    }

    @Override
    protected String toCanonicalString(int callerLevel) {
        StringBuilder sb = new StringBuilder();
        if (callerLevel < this.getNodeLevel()) {
            sb.append('(');
        }
        for (int i = 0; i < this.children.size(); ++i) {
            if (i > 0) {
                sb.append('+');
            }
            sb.append('(').append(((ExpressionTreeNode)this.children.get(i)).toCanonicalString(this.getNodeLevel())).append(')');
        }
        if (callerLevel < this.getNodeLevel()) {
            sb.append(')');
        }
        return sb.toString();
    }

    @Override
    protected boolean isIdentity(ExpressionTreeNode operand, boolean[] negated) {
        if (!(operand instanceof NumberNode)) {
            return false;
        }
        if (negated != null && negated.length > 0) {
            negated[0] = false;
        }
        return ((NumberNode)operand).getNonNegatedValue() == 0.0;
    }

    @Override
    public void performBasicSimplification(boolean reorderTerms) {
        this.children = this.collectAddends();
        for (int i = 0; i < this.children.size(); ++i) {
            ((ExpressionTreeNode)this.children.get(i)).performBasicSimplification(reorderTerms);
        }
        if (reorderTerms) {
            this.orderTerms();
        }
        this.stringNeedsRecreation = true;
        if (trace.getDebugCode("functions")) {
            trace.out("functions", this.getClass().getSimpleName() + ".performBasicSimplification() result " + this);
        }
    }

    @Override
    public ExpressionTreeNode performComplexSimplification() {
        this.performBasicSimplification(true);
        ArrayList<ExpressionTreeNode> newKids = new ArrayList<ExpressionTreeNode>();
        int i = 0;
        for (i = 0; i < this.children.size(); ++i) {
            newKids.add(((ExpressionTreeNode)this.children.get(i)).performComplexSimplification());
        }
        AdditionNode cannon = new AdditionNode(newKids, this.negated, this.properties);
        cannon.orderTerms();
        ExpressionTreeNode result = cannon.combineAddends();
        return result;
    }

    public AdditionNode distribute(ExpressionTreeNode multiplyByMe) {
        ArrayList<ExpressionTreeNode> products = new ArrayList<ExpressionTreeNode>();
        for (int i = 0; i < this.children.size(); ++i) {
            if (multiplyByMe.getClass() == AdditionNode.class) {
                for (int j = 0; j < multiplyByMe.children.size(); ++j) {
                    products.add(((ExpressionTreeNode)this.children.get(i)).cloneAndMultiplyBy(multiplyByMe.children.get(j)));
                }
                continue;
            }
            products.add(((ExpressionTreeNode)this.children.get(i)).cloneAndMultiplyBy(multiplyByMe));
        }
        return new AdditionNode(products, this.negated, this.properties);
    }

    private ExpressionTreeNode combineAddends() {
        int a = 0;
        while (a < this.children.size() - 1) {
            int n = a + 1;
            Boolean removedSummator = false;
            ExpressionTreeNode sum2 = null;
            while (n < this.children.size()) {
                ExpressionTreeNode right;
                ExpressionTreeNode left = (ExpressionTreeNode)this.children.get(a);
                sum2 = left.additiveCombine(right = (ExpressionTreeNode)this.children.get(n));
                if (sum2 == null) {
                    ++n;
                    continue;
                }
                if (sum2.getNonNegatedString().equals("0.0")) {
                    this.children.remove(a);
                    this.children.remove(n - 1);
                    removedSummator = true;
                    break;
                }
                this.children.remove(n);
                this.children.set(a, sum2);
            }
            if (removedSummator.booleanValue()) continue;
            ++a;
        }
        if (this.children.size() == 0) {
            return new NumberNode("0.0", this.properties);
        }
        if (this.children.size() == 1) {
            if (this.negated) {
                ((ExpressionTreeNode)this.children.get(0)).negate();
            }
            return (ExpressionTreeNode)this.children.get(0);
        }
        return this;
    }

    public ArrayList<ExpressionTreeNode> collectAddends() {
        ArrayList<ExpressionTreeNode> addends = new ArrayList<ExpressionTreeNode>();
        for (ExpressionTreeNode child : this.children) {
            if (child.getClass() == AdditionNode.class) {
                ArrayList<ExpressionTreeNode> grandKids = ((AdditionNode)child).collectAddends();
                if (child.negated) {
                    for (int i = 0; i < grandKids.size(); ++i) {
                        grandKids.get(i).negate();
                    }
                }
                addends.addAll(grandKids);
                continue;
            }
            addends.add(child);
        }
        return addends;
    }

    @Override
    protected String getNonNegatedString(boolean preserveSimpleTerms) {
        if (!this.stringNeedsRecreation) {
            return this.myString;
        }
        String tot = "";
        tot = tot + "(";
        if (this.children.size() < 2) {
            return "ERROR";
        }
        for (int i = 0; i < this.children.size() - 1; ++i) {
            ExpressionTreeNode node = (ExpressionTreeNode)this.children.get(i);
            tot = tot + node.getNegatedString(preserveSimpleTerms) + " + ";
        }
        tot = tot + ((ExpressionTreeNode)this.children.get(this.children.size() - 1)).getNegatedString(preserveSimpleTerms) + ")";
        this.setString(tot);
        this.stringNeedsRecreation = false;
        return this.myString;
    }

    @Override
    protected Boolean eval_internal() {
        Boolean eval_success = true;
        int i = 0;
        for (i = 0; i < this.children.size(); ++i) {
            eval_success = ((ExpressionTreeNode)this.children.get(i)).eval_internal() != false && eval_success != false;
        }
        Double total = 0.0;
        if (eval_success.booleanValue()) {
            for (i = 0; i < this.children.size(); ++i) {
                total = total + ((ExpressionTreeNode)this.children.get(i)).getEvalValue();
            }
            if (this.negated) {
                total = -1.0 * total;
            }
            this.setEvalValue(total);
        }
        return eval_success;
    }
}

