/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.Dialogs;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.EdgeUpdatedEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.EdgeData;
import edu.cmu.pact.BehaviorRecorder.View.JUndo;
import edu.cmu.pact.ctat.view.ViewUtils;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.PlainDocument;

public class EditMinMaxLinkTraversals
extends JDialog
implements ActionListener,
DocumentListener {
    private JTextField minTextField;
    private JTextField maxTextField;
    private JButton okButton;
    private JButton cancelButton;
    private EdgeData edge;
    private BR_Controller controller;

    public EditMinMaxLinkTraversals(Frame owner, String title, boolean modal, EdgeData edge, BR_Controller controller) {
        super(owner, title, modal);
        this.controller = controller;
        this.edge = edge;
        JPanel mainVertPanel = new JPanel();
        mainVertPanel.setLayout(new BoxLayout(mainVertPanel, 1));
        JPanel descPanel = new JPanel();
        descPanel.setLayout(new BoxLayout(descPanel, 0));
        ViewUtils.setStandardBorder(descPanel);
        JLabel displayJLabel = new JLabel("<html>Set the minimum and maximum number of times <br>that this link can be traversed:</html>");
        descPanel.add(displayJLabel);
        mainVertPanel.add(descPanel);
        JPanel ltfPanel = new JPanel();
        ltfPanel.setLayout(new BoxLayout(ltfPanel, 0));
        ViewUtils.setStandardBorder(ltfPanel);
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new BoxLayout(labelPanel, 1));
        JPanel tfPanel = new JPanel();
        tfPanel.setLayout(new BoxLayout(tfPanel, 1));
        PlainDocument minDoc = new PlainDocument();
        this.minTextField = new JTextField(minDoc, edge.getMinTraversalsStr(), 8);
        JUndo.JTextUndoPacket jTextUndoPacket = JUndo.makeTextUndoable(this.minTextField);
        this.minTextField.setHorizontalAlignment(0);
        JLabel minLabel = new JLabel("Minimum Traversals: ");
        minLabel.setHorizontalAlignment(2);
        labelPanel.add(minLabel);
        tfPanel.add(this.minTextField);
        PlainDocument maxDoc = new PlainDocument();
        this.maxTextField = new JTextField(maxDoc, edge.getMaxTraversalsStr(), 8);
        JUndo.JTextUndoPacket jTextUndoPacket2 = JUndo.makeTextUndoable(this.maxTextField);
        this.maxTextField.setHorizontalAlignment(0);
        JLabel maxLabel = new JLabel("Maximum Traversals: ");
        maxLabel.setHorizontalAlignment(2);
        labelPanel.add(maxLabel);
        tfPanel.add(this.maxTextField);
        ltfPanel.add(labelPanel);
        ltfPanel.add(tfPanel);
        mainVertPanel.add(ltfPanel);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        ViewUtils.setStandardBorder(buttonPanel);
        this.okButton = new JButton("Ok");
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this);
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        mainVertPanel.add(buttonPanel);
        this.add(mainVertPanel);
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(owner);
        minDoc.addDocumentListener(this);
        maxDoc.addDocumentListener(this);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getSource() == this.okButton) {
            int minBefore = this.edge.getMinTraversals();
            int maxBefore = this.edge.getMaxTraversals();
            this.edge.setMinTraversalsStr(this.minTextField.getText());
            this.edge.setMaxTraversalsStr(this.maxTextField.getText());
            int minAfter = this.edge.getMinTraversals();
            int maxAfter = this.edge.getMaxTraversals();
            boolean saveCheckPoint = minBefore != minAfter || maxBefore != maxAfter;
            this.controller.getProblemModel().fireProblemModelEvent(new EdgeUpdatedEvent(this, this.edge.getEdge(), true));
            if (saveCheckPoint) {
                ActionEvent ae = new ActionEvent(this, 0, "Set min/max traversals");
                this.controller.getUndoPacket().getCheckpointAction().actionPerformed(ae);
            }
        } else if (arg0.getSource() == this.cancelButton) {
            // empty if block
        }
        this.setVisible(false);
    }

    private void stateChanged(DocumentEvent evt) {
        try {
            int min = Integer.parseInt(this.minTextField.getText());
            int max = Integer.parseInt(this.maxTextField.getText());
            this.okButton.setEnabled(min <= max);
        }
        catch (Exception e) {
            this.okButton.setEnabled(true);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent evt) {
        this.stateChanged(evt);
    }

    @Override
    public void insertUpdate(DocumentEvent evt) {
        this.stateChanged(evt);
    }

    @Override
    public void removeUpdate(DocumentEvent evt) {
        this.stateChanged(evt);
    }
}

