/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.Dialogs;

import edu.cmu.pact.BehaviorRecorder.Dialogs.BrdFilter;
import edu.cmu.pact.BehaviorRecorder.Dialogs.DialogUtilities;
import edu.cmu.pact.BehaviorRecorder.View.JUndo;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctatview.CTATtoLMS;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class CreateLMSFilesDialog
implements ActionListener,
ItemListener {
    private JFrame frame;
    private JButton create;
    private JButton cancel;
    private JButton browse;
    private JTextField filepath;
    private JTextField studentInterface;
    private JTextField platform;
    private JCheckBox excel;
    private JCheckBox xcur;
    private JCheckBox unit;
    private JCheckBox bas;
    private String defaultStudentInterface = " ";
    private String defaultPlatform = " ";
    private char[] options = new char[]{'n', 'y', 'y', 'y'};
    private static final String defaultDebugOptions = "NYY";
    private String debugOptions;

    public CreateLMSFilesDialog() {
        this(defaultDebugOptions);
    }

    public CreateLMSFilesDialog(String debugOptions) {
        this.debugOptions = debugOptions;
        JPanel mainPane = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.ipadx = 2;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        mainPane.add((Component)new JLabel("FilePath to .brd or folder"), c);
        this.browse = new JButton("Browse");
        this.browse.addActionListener(this);
        c.gridx = 3;
        c.gridy = 1;
        mainPane.add((Component)this.browse, c);
        this.filepath = new JTextField();
        JUndo.JTextUndoPacket jTextUndoPacket = JUndo.makeTextUndoable(this.filepath);
        c.gridx = 0;
        c.gridwidth = 3;
        mainPane.add((Component)this.filepath, c);
        c.gridy = 2;
        mainPane.add((Component)new JLabel("(Optional) Student Interface"), c);
        this.studentInterface = new JTextField(this.defaultStudentInterface, 15);
        jTextUndoPacket = JUndo.makeTextUndoable(this.studentInterface);
        this.studentInterface.setText("");
        c.gridy = 3;
        c.gridwidth = 3;
        mainPane.add((Component)this.studentInterface, c);
        c.gridy = 4;
        mainPane.add((Component)new JLabel("(Optional) Platform"), c);
        this.platform = new JTextField(this.defaultPlatform, 15);
        jTextUndoPacket = JUndo.makeTextUndoable(this.platform);
        this.platform.setText("");
        c.gridy = 5;
        mainPane.add((Component)this.platform, c);
        this.excel = new JCheckBox("Excel", true);
        this.excel.addItemListener(this);
        c.gridy = 6;
        mainPane.add((Component)this.excel, c);
        this.xcur = new JCheckBox("XCUR", true);
        this.xcur.addItemListener(this);
        c.gridy = 7;
        mainPane.add((Component)this.xcur, c);
        this.unit = new JCheckBox("UNIT", true);
        this.unit.addItemListener(this);
        c.gridy = 8;
        mainPane.add((Component)this.unit, c);
        this.bas = new JCheckBox("BAS", true);
        this.bas.addItemListener(this);
        c.gridy = 9;
        mainPane.add((Component)this.bas, c);
        this.create = new JButton("Create");
        this.create.addActionListener(this);
        c.gridx = 2;
        c.gridy = 10;
        c.gridwidth = 1;
        mainPane.add((Component)this.create, c);
        this.cancel = new JButton("Cancel");
        this.cancel.addActionListener(this);
        c.gridx = 3;
        mainPane.add((Component)this.cancel, c);
        this.frame = new JFrame("Create LMS Files");
        this.frame.setContentPane(mainPane);
        this.frame.setDefaultCloseOperation(2);
        this.frame.setLocationRelativeTo(null);
        this.frame.pack();
        this.frame.setResizable(false);
        this.frame.setVisible(true);
    }

    public static void main(String[] args) {
        CreateLMSFilesDialog t = new CreateLMSFilesDialog(defaultDebugOptions);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.browse) {
            File f = DialogUtilities.chooseFile(".", null, (FileFilter)new BrdFilter(), "Find files", "Open", this.frame);
            if (f != null) {
                this.filepath.setText(f.getAbsolutePath());
            }
        } else if (ae.getSource() == this.cancel) {
            this.frame.setVisible(false);
            this.frame.dispose();
        } else if (ae.getSource() == this.create) {
            String[] args = new String[5];
            args[0] = this.filepath.getText();
            args[1] = this.platform.getText();
            if (args[1] == null) {
                args[1] = " ";
            }
            args[2] = this.studentInterface.getText();
            if (args[2] == null) {
                args[2] = "";
            }
            args[3] = new String(this.options);
            args[4] = this.debugOptions;
            String status = CTATtoLMS.run(args, true);
            this.frame.setVisible(false);
            if (status != null && !status.equals("")) {
                JScrollPane jsp = new JScrollPane(new JTextArea(status));
                this.frame.setContentPane(jsp);
                this.frame.setVisible(true);
            } else {
                JOptionPane.showMessageDialog(this.frame, "Success! Please move\r\n.xcur file into \"Carnegie Learning\\2006\\Administrative\\Curricula\"\r\n.unit file(s) into \"Carnegie Learning\\2006\\Administrative\\Curricula\\Unit Data\"\r\n.bas file(s) into \"Carnegie Learning\\2006\\Administrative\\Curricula\\Problem Data\"");
                this.frame.dispose();
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent ie) {
        int choice = 0;
        int val = 0;
        if (ie.getSource() == this.excel) {
            choice = 0;
        } else if (ie.getSource() == this.xcur) {
            choice = 1;
        } else if (ie.getSource() == this.unit) {
            choice = 2;
        } else if (ie.getSource() == this.bas) {
            choice = 3;
        }
        if (ie.getStateChange() == 2) {
            val = 110;
        } else if (ie.getStateChange() == 1) {
            val = 121;
        } else {
            trace.out("Check box is messed up?");
        }
        this.options[choice] = val;
    }
}

