/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.Controller;

import edu.cmu.pact.BehaviorRecorder.Controller.AppletLauncher;
import edu.cmu.pact.Utilities.Utils;
import edu.cmu.pact.Utilities.trace;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Set;

public class AppletAdvance
implements ActionListener {
    private final AppletLauncher appletLauncher;
    private static Set<String> summaryParams = new LinkedHashSet<String>();

    public AppletAdvance(AppletLauncher appletLauncher) {
        this.appletLauncher = appletLauncher;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (trace.getDebugCode("appletLauncher")) {
            trace.outNT("appletLauncher", "AppletAdvance.actionPerformed(" + e + ":" + e.getSource() + ")");
        }
        if ("Complete all items".equalsIgnoreCase(e.getActionCommand())) {
            Runnable psTransaction = new Runnable(){

                @Override
                public void run() {
                    AppletAdvance.this.sendProblemSummary();
                    String path = null;
                    try {
                        path = AppletAdvance.this.appletLauncher.getParameter("run_problem_url");
                        URL rpURL = AppletAdvance.this.makeCodeBaseURL(path);
                        if (trace.getDebugCode("appletLauncher")) {
                            trace.outNT("appletLauncher", "AppletAdvance pausing, rpURL " + rpURL);
                            Thread.sleep(30000L);
                        }
                        String targetFrame = "_self";
                        AppletAdvance.this.appletLauncher.getAppletContext().showDocument(rpURL, targetFrame);
                    }
                    catch (Exception e) {
                        Utils.showExceptionOccuredDialog(e, "Error advancing to next problem: " + e, "Error advancing to next problem");
                    }
                }
            };
            new Thread(psTransaction, "ProblemSummaryTransaction").start();
        }
    }

    private String sendProblemSummary() {
        String postContent = this.createProblemSummaryPost();
        if (trace.getDebugCode("appletLauncher")) {
            trace.outNT("appletLauncher", "AppletAdvance.sendProblemSummary() postContent\n  " + postContent);
        }
        StringWriter result = new StringWriter();
        String path = this.appletLauncher.getParameter("curriculum_service_url");
        HttpURLConnection csConn = null;
        try {
            URL csURL = this.makeCodeBaseURL(path);
            if (trace.getDebugCode("appletLauncher")) {
                trace.outNT("appletLauncher", "AppletAdvance.sendProblemSummary() csURL " + csURL);
            }
            csConn = (HttpURLConnection)csURL.openConnection();
            csConn.setDoOutput(true);
            csConn.setDoInput(true);
            csConn.setRequestMethod("POST");
            csConn.connect();
        }
        catch (Exception e) {
            trace.errStack("Error connecting to address " + path + ": " + e + "; cause " + e.getCause(), e);
            return null;
        }
        try {
            int c;
            BufferedOutputStream os = new BufferedOutputStream(csConn.getOutputStream());
            os.write(postContent.getBytes("UTF-8"));
            os.close();
            BufferedReader is = new BufferedReader(new InputStreamReader(csConn.getInputStream(), "UTF-8"));
            while (0 <= (c = is.read())) {
                result.write(c);
            }
            is.close();
            if (trace.getDebugCode("appletLauncher")) {
                trace.outNT("appletLauncher", "AppletAdvance.sendProblemSummary() response " + result);
            }
            if (200 != csConn.getResponseCode()) {
                throw new Exception("Error from ProblemSummary response " + csConn.getResponseCode() + ": " + result);
            }
            return result.toString();
        }
        catch (Exception e) {
            trace.errStack("Error sending postContent to address " + path + ": " + e + "; cause " + e.getCause(), e);
            return null;
        }
    }

    private URL makeCodeBaseURL(String path) throws Exception {
        URL codeBase = null;
        URL result = null;
        try {
            try {
                result = new URL(path);
            }
            catch (MalformedURLException mue) {
                codeBase = this.appletLauncher.getCodeBase();
                String protocolAuthority = codeBase.getProtocol() + "://" + codeBase.getAuthority();
                result = new URL(protocolAuthority + "/" + path);
            }
            if (trace.getDebugCode("applet")) {
                trace.outNT("applet", "makeCodeBaseURL(" + path + ") returning " + result);
            }
            return result;
        }
        catch (Exception e) {
            throw new Exception("Error creating URL from codeBase " + codeBase + ", path " + path + ": " + e, e);
        }
    }

    private String createProblemSummaryPost() {
        String ps = this.appletLauncher.getProblemSummary();
        if (trace.getDebugCode("appletLauncher")) {
            trace.outNT("appletLauncher", "AppletAdvance.createProblemSummaryPost() ps " + ps);
        }
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        String[] paramInfo = new String[]{"ProblemSummary", "must URLEncode", ps};
        params.put(paramInfo[0], paramInfo);
        for (String string : this.appletLauncher.getParameterInfo()) {
            if (!summaryParams.contains(string[0])) continue;
            String[] paramInfo2 = new String[]{string[0], string[1], this.appletLauncher.getParameter(string[0])};
            params.put(paramInfo2[0], paramInfo2);
        }
        StringBuilder sb = new StringBuilder();
        for (String key : params.keySet()) {
            String[] stringArray = (String[])params.get(key);
            sb.append(this.nameValue(key, stringArray[1], stringArray[2]));
        }
        return sb.toString();
    }

    private String nameValue(String pName, String pType, String pValue) {
        StringBuffer sb = new StringBuffer();
        sb.append(pName).append('=');
        try {
            if (pValue != null) {
                if (pType.contains("must URLEncode")) {
                    sb.append(URLEncoder.encode(pValue, "UTF-8"));
                } else {
                    sb.append(pValue);
                }
            }
        }
        catch (UnsupportedEncodingException uee) {
            trace.errStack("should not happen with UTF-8", uee);
        }
        sb.append('&');
        return sb.toString();
    }

    private void setCookieUsingCookieHandler(URL csURL) {
        try {
            String[] nvPairs;
            CookieManager manager = new CookieManager();
            CookieHandler.setDefault(manager);
            CookieStore cookieJar = manager.getCookieStore();
            URI csURI = csURL.toURI();
            String rawCookieStr = this.appletLauncher.getDocumentCookies();
            for (String nvPair : nvPairs = rawCookieStr.split(";")) {
                String value;
                String[] nv = nvPair.split("=");
                String name = nv == null || nv.length < 1 ? null : nv[0];
                String string = value = nv.length > 1 ? nv[1] : null;
                if (trace.getDebugCode("appletLauncher")) {
                    trace.outNT("appletLauncher", "setCookie(" + name + ", " + value + ")");
                }
                if (name == null) continue;
                HttpCookie cookie = new HttpCookie(name, value);
                cookieJar.add(csURI, cookie);
            }
        }
        catch (Exception e) {
            trace.errStack("Error setting cookies: " + e + "; cause " + e.getCause(), e);
        }
    }

    static {
        summaryParams.add("session_id");
        summaryParams.add("authenticity_token");
        summaryParams.add("school_name");
        summaryParams.add("user_guid");
        summaryParams.add("problem_state");
    }
}

