/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.ctat.widgets;

import java.awt.Color;
import java.awt.Component;
import java.io.File;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.filechooser.FileSystemView;

class CTATFileListRenderer
extends DefaultListCellRenderer {
    private static final long serialVersionUID = -7799441088157759804L;
    private FileSystemView fileSystemView;
    private JLabel label;
    private Color textSelectionColor = Color.BLACK;
    private Color backgroundSelectionColor = Color.CYAN;
    private Color textNonSelectionColor = Color.BLACK;
    private Color backgroundNonSelectionColor = Color.WHITE;

    CTATFileListRenderer() {
        this.label = new JLabel();
        this.label.setOpaque(true);
        this.fileSystemView = FileSystemView.getFileSystemView();
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean selected, boolean expanded) {
        File file = (File)value;
        this.label.setIcon(this.fileSystemView.getSystemIcon(file));
        this.label.setText(this.fileSystemView.getSystemDisplayName(file));
        this.label.setToolTipText(file.getPath());
        if (selected) {
            this.label.setBackground(this.backgroundSelectionColor);
            this.label.setForeground(this.textSelectionColor);
        } else {
            this.label.setBackground(this.backgroundNonSelectionColor);
            this.label.setForeground(this.textNonSelectionColor);
        }
        return this.label;
    }
}

