/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.ctat;

import edu.cmu.hcii.ctat.CTATBase;
import edu.cmu.hcii.ctat.CTATSkill;
import java.util.ArrayList;

public class CTATProblem
extends CTATBase {
    public int index = -1;
    public String tutor_flag = "";
    public String problem_file = "";
    public String description = "";
    public String name = "";
    public String student_interface = "";
    public String problem_path = "";
    private Boolean active = false;
    private ArrayList<ProblemSkill> problemSkills;

    public CTATProblem() {
        this.setClassName("CTATProblem");
        this.debug("CTATProblem ()");
        this.setSkills(new ArrayList<CTATSkill>());
    }

    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public void setSkills(ArrayList<CTATSkill> skills) {
        this.problemSkills = new ArrayList(skills.size());
        for (CTATSkill skill : skills) {
            ProblemSkill problemSkill = new ProblemSkill();
            problemSkill.skill = skill;
            problemSkill.occurrences = 1;
            this.problemSkills.add(problemSkill);
        }
    }

    public void addSkill(CTATSkill skill, int occurrences) {
        ProblemSkill problemSkill = new ProblemSkill();
        problemSkill.skill = skill;
        problemSkill.occurrences = occurrences;
        this.problemSkills.add(problemSkill);
    }

    public ArrayList<CTATSkill> getSkills() {
        ArrayList<CTATSkill> returnValue = new ArrayList<CTATSkill>(this.problemSkills.size());
        for (ProblemSkill problemSkill : this.problemSkills) {
            returnValue.add(problemSkill.skill);
        }
        return returnValue;
    }

    public String getSkillsXML() {
        StringBuilder str = new StringBuilder("<Skills>");
        for (ProblemSkill problemSkill : this.problemSkills) {
            CTATSkill skill = problemSkill.skill;
            str.append("<Skill name=\"");
            if (skill.name != null) {
                str.append(skill.name);
            }
            str.append("\" category=\"");
            if (skill.category != null) {
                str.append(skill.category);
            }
            str.append("\" occurrences=\"");
            str.append(problemSkill.occurrences);
            str.append("\" pKnown=\"");
            if (skill.pKnown != null) {
                str.append(skill.pKnown);
            }
            str.append("\" pLearn=\"");
            if (skill.pLearn != null) {
                str.append(skill.pLearn);
            }
            str.append("\" description=\"");
            if (skill.description != null) {
                str.append(skill.description);
            }
            str.append("\" label=\"");
            if (skill.label != null) {
                str.append(skill.label);
            }
            str.append("\" pGuess=\"");
            if (skill.pGuess != null) {
                str.append(skill.pGuess);
            }
            str.append("\" pSlip=\"");
            if (skill.pSlip != null) {
                str.append(skill.pSlip);
            }
            str.append("\"/>");
        }
        str.append("</Skills>");
        return str.toString();
    }

    private class ProblemSkill {
        CTATSkill skill;
        int occurrences;

        private ProblemSkill() {
        }
    }
}

