/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.ctat;

import edu.cmu.hcii.ctat.CTATCurriculum;
import edu.cmu.hcii.ctat.CTATHTTPExchange;
import edu.cmu.hcii.ctat.CTATHTTPHandlerInterface;
import edu.cmu.hcii.ctat.CTATLink;
import edu.cmu.hcii.ctat.CTATOfflineHTTPHandler;
import edu.cmu.hcii.ctat.CTATUserData;
import edu.cmu.hcii.ctat.CTATWebTools;
import edu.cmu.hcii.ctat.UserProgressDatabase;
import edu.cmu.pact.Utilities.Utils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

class CTATCS2NHandler
extends CTATOfflineHTTPHandler
implements CTATHTTPHandlerInterface {
    public CTATCS2NHandler(String aLogFile, UserProgressDatabase upd, CTATCurriculum aCurriculum) throws IOException {
        super(aLogFile, upd, aCurriculum);
        this.setClassName("CTATCS2NHandler");
        this.debug("CTATCS2NHandler ()");
    }

    public boolean handle(CTATHTTPExchange arg0) {
        this.debug("handle ()");
        if (this.getCurriculum() == null) {
            this.debug("Error: curriculum object is null");
            return false;
        }
        Boolean processed = false;
        String path = arg0.getRequestURI().getPath();
        if (path.equals("/logincs2n.cgi")) {
            CTATLink.userID = this.handleLogin(arg0);
            this.debug("Handled: true");
            return true;
        }
        if (path.startsWith("/createlocal.cgi")) {
            CTATLink.userID = this.handleCreate(arg0);
            this.debug("Handled: true");
            return true;
        }
        processed = super.handle(arg0, null);
        return processed;
    }

    private boolean login(String username, String password, boolean skipPassword) {
        this.debug("login ()");
        if (username == null || password == null) {
            return false;
        }
        CTATUserData targetUser = this.localUserDB.getUser(username);
        if (targetUser == null) {
            this.debug("Error: username doesn't exists");
            return false;
        }
        if (!skipPassword && !targetUser.password.equals(password)) {
            this.debug("Error password is not correct");
            return false;
        }
        CTATLink.userID = username;
        return true;
    }

    public String createlogin(String username, String password, String firstname, String lastname, String section) {
        this.debug("createlogin (" + username + "," + password + "," + firstname + "," + lastname + "," + section + ")");
        if (username == null || password == null) {
            return "Error: username or password is not specified";
        }
        if (this.localUserDB.getUser(username.toLowerCase()) != null) {
            return "Error: username already exists";
        }
        CTATUserData newUser = this.localUserDB.addUser(username.toLowerCase());
        newUser.password = password;
        newUser.firstName = firstname;
        newUser.lastName = lastname;
        newUser.section = section;
        try {
            this.localUserDB.saveUserProgress(username.toLowerCase());
        }
        catch (IOException e) {
            e.printStackTrace();
            return "Error: unable to save user data";
        }
        return null;
    }

    public String handleLogin(CTATHTTPExchange exchange) {
        this.debug("handleLogin ()");
        String requestMethod = exchange.getRequestMethod();
        if (requestMethod.equalsIgnoreCase("GET")) {
            String password;
            String query = exchange.getRequestURI().getQuery();
            if (query == null) {
                return null;
            }
            CTATWebTools webtools = new CTATWebTools();
            Map<String, String> queryMap = webtools.parseQuery(query);
            String username = queryMap.get("username");
            if (this.login(username, password = queryMap.get("password"), false)) {
                this.sendString(exchange, "OK");
                return username;
            }
            this.sendString(exchange, "Error: The login attempt failed.");
            return null;
        }
        if (requestMethod.equalsIgnoreCase("POST")) {
            String query;
            InputStream in = exchange.getRequestBody();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                int b;
                while ((b = in.read()) != -1) {
                    baos.write(b);
                }
                in.close();
                query = baos.toString("UTF-8");
            }
            catch (IOException e) {
                return null;
            }
            CTATWebTools webtools = new CTATWebTools();
            Map<String, String> queryMap = webtools.parseQuery(query);
            String username = queryMap.get("username");
            String password = queryMap.get("password");
            if (this.login(username, password, false)) {
                this.redirectTo(exchange, "/");
                return username;
            }
            this.sendString(exchange, "The login attempt failed.");
            return null;
        }
        return null;
    }

    public String handleCreate(CTATHTTPExchange exchange) {
        this.debug("handleCreate ()");
        String requestMethod = exchange.getRequestMethod();
        if (requestMethod.equalsIgnoreCase("GET")) {
            String req = exchange.getRequestURI().toString();
            this.debug("Query: " + req);
            String path = exchange.getRequestURI().getPath();
            this.debug("Query path: " + path);
            if (req.contains("?")) {
                String section;
                String lastname;
                String firstname;
                String password;
                CTATWebTools webtools = new CTATWebTools();
                String query = req.substring(req.indexOf("?") + 1);
                Map<String, String> queryMap = webtools.parseQuery(query);
                String username = queryMap.get("username");
                String result = this.createlogin(username, password = queryMap.get("password"), firstname = queryMap.get("firstname"), lastname = queryMap.get("lastname"), section = queryMap.get("section"));
                if (result == null) {
                    this.sendString(exchange, "OK");
                    return username;
                }
                this.sendString(exchange, result);
                return null;
            }
            this.sendString(exchange, "No query string, so no login credentials were provided.");
            return null;
        }
        if (requestMethod.equalsIgnoreCase("POST")) {
            String query;
            InputStream in = exchange.getRequestBody();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                int b;
                while ((b = in.read()) != -1) {
                    baos.write(b);
                }
                in.close();
                query = baos.toString("UTF-8");
            }
            catch (IOException e) {
                return null;
            }
            CTATWebTools webtools = new CTATWebTools();
            Map<String, String> queryMap = webtools.parseQuery(query);
            String username = queryMap.get("username");
            String password = queryMap.get("password");
            String firstname = queryMap.get("firstname");
            String lastname = queryMap.get("lastname");
            String section = queryMap.get("section");
            String result = this.createlogin(username, password, firstname, lastname, section);
            if (result == null) {
                this.redirectTo(exchange, "/");
                return username;
            }
            this.sendString(exchange, result);
            return null;
        }
        return null;
    }

    protected void setUserid(String userid) {
        CTATCurriculum curr;
        if (userid == null || userid.length() < 1) {
            return;
        }
        if (this.login(userid, "", true)) {
            return;
        }
        if (CTATLink.requirePredefinedUserid && ((curr = this.getCurriculum()) == null || !curr.isUserRegistered(userid))) {
            String errMsg = "Curriculum missing or username \"" + userid + "\" not recognized";
            Utils.showExceptionOccuredDialog(null, "Username \"" + userid + "\" not recognized", "Login Failed");
            throw new IllegalArgumentException(errMsg);
        }
        String error = this.createlogin(userid, "", "offline_user", userid, "offline_class");
        if (error != null) {
            Utils.showExceptionOccuredDialog(null, "Error creating user database entry for \"" + userid + "\": " + error + ". Your work might not be saved.", "Login Error");
        } else {
            CTATLink.userID = userid;
        }
    }
}

