/*
 * Decompiled with CFR 0.152.
 */
package pact.CommWidgets;

import edu.cmu.pact.BehaviorRecorder.Dialogs.EditAudioButtonDialog;
import edu.cmu.pact.Utilities.DelayedAction;
import edu.cmu.pact.Utilities.Utils;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.MessageObject;
import edu.cmu.pact.ctat.TutorController;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Vector;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import pact.CommWidgets.JCommPicture;
import pact.CommWidgets.JCommWidget;
import pact.CommWidgets.event.StudentActionEvent;

public class JCommAudioButton
extends JCommWidget
implements ActionListener {
    protected JButton button;
    protected JPanel container;
    protected boolean changeColor;
    protected Font startFont;
    protected boolean locked;
    protected int maxNumberPlay = -1;
    protected int numberPlay = 0;
    public String imageName = "JCommAudioButton.gif";
    public String audioFileName;
    public ImageIcon defaultIcon;

    public JCommAudioButton() {
        this.setLayout(new GridLayout(1, 1));
        this.button = new JButton();
        this.button.addActionListener(this);
        this.add(this.button);
        this.backgroundNormalColor = this.button.getBackground();
        this.setActionName("PlayAudio");
        this.locked = false;
        this.changeColor = true;
        this.addFocusListener(this);
        this.originalBorder = this.button.getBorder();
        this.setIcon(JCommAudioButton.createImageIcon(this.imageName, this.imageName));
        this.setAudioFileName("JavaWelcome.wav");
    }

    protected static ImageIcon createImageIcon(String path, String description) {
        URL imageURL = JCommPicture.class.getResource(path);
        if (imageURL == null) {
            System.err.println("Resource not found: " + path);
            return null;
        }
        return new ImageIcon(imageURL, description);
    }

    @Override
    public MessageObject getDescriptionMessage() {
        if (!this.initialize(this.getController())) {
            trace.out(5, this, "ERROR!: Can't create Comm message because can't initialize.  Returning empty comm message");
            return null;
        }
        MessageObject mo = MessageObject.create("InterfaceDescription");
        mo.setVerb("SendNoteProperty");
        mo.setProperty("WidgetType", "JCommAudioButton");
        mo.setProperty("CommName", this.commName);
        mo.setProperty("UpdateEachCycle", new Boolean(this.updateEachCycle));
        Vector deftemplates = this.createJessDeftemplates();
        Vector instances = this.createJessInstances();
        if (deftemplates != null) {
            mo.setProperty("jessDeftemplates", deftemplates);
        }
        if (instances != null) {
            mo.setProperty("jessInstances", instances);
        }
        this.serializeGraphicalProperties(mo);
        return mo;
    }

    public Vector createJessDeftemplates() {
        Vector<String> deftemplates = new Vector<String>();
        String deftemplateStr = "(deftemplate audioButton (slot name))";
        deftemplates.add(deftemplateStr);
        return deftemplates;
    }

    public Vector createJessInstances() {
        Vector<String> instances = new Vector<String>();
        String instanceStr = "(assert (audioButton (name " + this.commName + ")))";
        instances.add(instanceStr);
        return instances;
    }

    @Override
    public void addMouseListener(MouseListener l) {
        if (this.button != null) {
            this.button.addMouseListener(l);
        }
    }

    @Override
    public void addMouseMotionListener(MouseMotionListener l) {
        if (this.button != null) {
            this.button.addMouseMotionListener(l);
        }
    }

    @Override
    public MouseListener[] getMouseListeners() {
        if (this.button != null) {
            return this.button.getMouseListeners();
        }
        return null;
    }

    @Override
    public MouseMotionListener[] getMouseMotionListeners() {
        if (this.button != null) {
            return this.button.getMouseMotionListeners();
        }
        return null;
    }

    @Override
    public void removeMouseMotionListener(MouseMotionListener l) {
        if (this.button != null) {
            this.button.removeMouseMotionListener(l);
        }
    }

    @Override
    public void removeMouseListener(MouseListener l) {
        if (this.button != null) {
            this.button.removeMouseListener(l);
        }
    }

    @Override
    public void doInterfaceAction(String selection, String action, String input) {
        if (action.equalsIgnoreCase("UpdateAudio")) {
            if (trace.getDebugCode("inter")) {
                trace.out("inter", "Load Audio: " + input);
            }
            this.setAudioFileName(input);
            this.numberPlay = 0;
        } else if (action.equalsIgnoreCase("UpdateIcon")) {
            if (trace.getDebugCode("inter")) {
                trace.out("inter", "Load icon: " + input);
            }
            this.setImageName(input);
        } else if (action.equalsIgnoreCase("UpdateText")) {
            if (trace.getDebugCode("inter")) {
                trace.out("inter", "UpdateText: " + input);
            }
            this.setText(input);
        } else if (action.equalsIgnoreCase("UpdateInVisible")) {
            if (trace.getDebugCode("inter")) {
                trace.out("inter", "Set InVisible: " + input);
            }
            if (input.equalsIgnoreCase("true")) {
                this.setInvisible(true);
            } else {
                this.setInvisible(false);
            }
            this.setVisible(!this.isInvisible());
        }
    }

    @Override
    public void doLISPCheckAction(String selection, String input) {
        if (this.changeColor) {
            this.button.setForeground(this.LISPCheckColor);
        }
        if (this.getController().getUniversalToolProxy().lockWidget() && !this.commName.equalsIgnoreCase("Hint") && !this.commName.equalsIgnoreCase("Help") && !this.commName.equalsIgnoreCase("Done")) {
            this.setFocusable(false);
            this.locked = true;
        }
    }

    public void setChangeButtonColor(boolean changeFlag) {
        this.changeColor = changeFlag;
    }

    public boolean getChangeButtonColor() {
        return this.changeColor;
    }

    @Override
    public void doCorrectAction(String selection, String action, String input) {
        if ("SetVisible".equalsIgnoreCase(action)) {
            if (trace.getDebugCode("inter")) {
                trace.out("inter", "SetVisible: " + input);
            }
            this.setVisible(input);
        } else {
            if (trace.getDebugCode("inter")) {
                trace.out("inter", "doCorrectAction Play Audio: " + input);
            }
            if (this.changeColor) {
                this.button.setForeground(this.correctColor);
                if (this.correctFont != null) {
                    this.button.setFont(this.correctFont);
                }
            }
            if (this.getController().getUniversalToolProxy().lockWidget() && !this.commName.equalsIgnoreCase("Hint") && !this.commName.equalsIgnoreCase("Help") && !this.commName.equalsIgnoreCase("Done")) {
                this.setFocusable(false);
                this.locked = true;
            }
            DelayedAction dA = new DelayedAction(new Runnable(){

                @Override
                public void run() {
                    JCommAudioButton.this.SimpleAudioPlayer(JCommAudioButton.this.getAudioFileName());
                    System.err.println("Play sound");
                }
            });
            dA.setDelayTime(0);
            dA.start();
            this.fireStudentAction(new StudentActionEvent(this));
        }
    }

    @Override
    public void doIncorrectAction(String selection, String input) {
        if (this.changeColor) {
            this.button.setForeground(this.incorrectColor);
            if (this.incorrectFont != null) {
                this.button.setFont(this.incorrectFont);
            }
        }
        if (this.locked) {
            this.locked = false;
        }
        this.setFocusable(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.removeHighlight(this.commName);
        ++this.numberPlay;
        if (trace.getDebugCode("br")) {
            trace.out("br", "numberPlay = " + this.numberPlay);
        }
        if (this.getController().isDefiningStartState()) {
            JFrame frame = new JFrame("Modify Label Text");
            String currentDir = System.getProperty("user.dir");
            String title = "Please set the Label for widget " + this.commName + " : ";
            EditAudioButtonDialog t = new EditAudioButtonDialog(frame, title, this.getText(), this.getIcon(), this.getAudioFileName().toString(), currentDir, this.isInvisible(), true);
            if (trace.getDebugCode("inter")) {
                trace.out("inter", ">>> " + this.getText() + " -> " + t.getNewLabel());
            }
            if (t.getIcon() != null && trace.getDebugCode("inter")) {
                trace.out("inter", ">>> " + this.getIcon() + " -> " + t.getIcon().toString());
            }
            if (t.getAudioFileName() != null && trace.getDebugCode("inter")) {
                trace.out("inter", ">>> " + this.getAudioFileName() + " -> " + t.getAudioFileName().toString());
            }
            if (t.getAudioFileName() != null) {
                this.setAudioFileName(t.getAudioFileName());
                this.dirty = true;
                this.setActionName("UpdateAudio");
                this.sendValue();
            }
            if (!t.getNewLabel().equals(this.getText())) {
                this.setText(t.getNewLabel());
                this.dirty = true;
                this.setActionName("UpdateText");
                this.sendValue();
            }
            if (t.getIcon() != null) {
                this.setIcon(t.getIcon());
                this.setImageName(t.getIcon().toString());
                this.dirty = true;
                this.setActionName("UpdateIcon");
                this.sendValue();
            }
            if (this.isInvisible() != t.isInvisible()) {
                this.setInvisible(t.isInvisible());
                this.setVisible(!this.isInvisible());
                this.dirty = true;
                this.setActionName("UpdateInVisible");
                this.sendValue();
            }
            this.setActionName("PlayAudio");
            this.numberPlay = 0;
        } else {
            if (this.getMaxNumberPlay() == -1 || this.numberPlay < this.getMaxNumberPlay()) {
                System.err.println("[ " + this.numberPlay + " , " + this.maxNumberPlay + " ]");
                this.dirty = true;
                this.sendValue();
                this.SimpleAudioPlayer(this.getAudioFileName());
                return;
            }
            System.err.println("[ " + this.numberPlay + " , " + this.maxNumberPlay + " ]");
        }
    }

    @Override
    public boolean isChangedFromResetState() {
        if (this.getImageName() != null) {
            return true;
        }
        return this.getText() != null && this.getText().length() > 0;
    }

    @Override
    public Object getValue() {
        String tempValue = this.getText();
        if (this.getActionName().equalsIgnoreCase("UpdateIcon") && this.getImageName() != null) {
            return this.imageName;
        }
        if ((this.getActionName().equalsIgnoreCase("UpdateAudio") || this.getActionName().equalsIgnoreCase("PlayAudio")) && this.getAudioFileName() != null && this.getAudioFileName().length() > 0) {
            return this.getAudioFileName().toString();
        }
        if (this.getActionName().equalsIgnoreCase("UpdateInVisible")) {
            return this.isInvisible();
        }
        if (this.commName.equalsIgnoreCase("Hint") || this.commName.equalsIgnoreCase("Help") || this.commName.equalsIgnoreCase("Done")) {
            return "-1";
        }
        return tempValue;
    }

    @Override
    public void reset(TutorController controller) {
        this.initialize(controller);
        if (this.changeColor) {
            this.button.setForeground(this.startColor);
            if (this.startFont != null) {
                this.button.setFont(this.startFont);
            }
        }
        this.locked = false;
        this.setFocusable(true);
    }

    @Override
    public boolean getLock(String selection) {
        return this.locked;
    }

    public Vector getCurrentState() {
        Vector<MessageObject> v = new Vector<MessageObject>();
        if (this.getText() != null && this.getText().length() > 0) {
            this.setActionName("UpdateText");
            v.addElement(this.getCurrentStateMessage());
        } else if (this.getAudioFileName() != null) {
            this.setActionName("UpdateAudio");
            v.addElement(this.getCurrentStateMessage());
        } else if (this.imageName != null) {
            this.setActionName("UpdateIcon");
            v.addElement(this.getCurrentStateMessage());
        } else if (this.isInvisible()) {
            this.setActionName("UpdateInVisible");
            v.addElement(this.getCurrentStateMessage());
        }
        this.setActionName("PlayAudio");
        return v;
    }

    public void setText(String text) {
        this.button.setText(text);
    }

    public String getText() {
        return this.button.getText();
    }

    @Override
    public void setToolTipText(String text) {
        this.button.setToolTipText(text);
    }

    @Override
    public String getToolTipText() {
        return this.button.getToolTipText();
    }

    @Override
    public void highlight(String subElement, Border highlightBorder) {
        this.button.setBorder(highlightBorder);
    }

    @Override
    public void removeHighlight(String subElement) {
        this.button.setBorder(this.originalBorder);
    }

    public void setImageName(String imageName) {
        this.imageName = imageName;
        if (imageName == null || imageName.length() < 1) {
            if (this.button != null) {
                this.button.setIcon(null);
            }
            return;
        }
        Image image = null;
        File imageFile = new File(imageName);
        if (imageFile.canRead()) {
            image = Toolkit.getDefaultToolkit().getImage(imageName);
        } else {
            URL imageURL = Utils.getURL(imageName, this);
            if (imageURL != null) {
                image = Toolkit.getDefaultToolkit().getImage(imageURL);
            } else {
                trace.err("Error: cannot find icon " + imageFile.getAbsolutePath());
                return;
            }
        }
        ImageIcon icon = new ImageIcon(image, imageName);
        if (this.button != null) {
            this.button.setIcon(icon);
        }
    }

    public String getImageName() {
        return this.imageName;
    }

    @Override
    public void setFocus(String subWidgetName) {
        this.button.requestFocus();
    }

    @Override
    public void setBackground(Color c) {
        if (this.button != null) {
            this.button.setBackground(c);
        }
    }

    public void setIcon(Icon icon) {
        if (this.button != null) {
            this.button.setIcon(icon);
        }
    }

    public Icon getIcon() {
        if (this.button != null) {
            return this.button.getIcon();
        }
        return null;
    }

    @Override
    public void moveFocus() {
        this.button.transferFocus();
    }

    @Override
    public void setFont(Font f) {
        this.startFont = f != null ? f : super.getFont();
        super.setFont(this.startFont);
        if (this.button != null) {
            this.button.setFont(this.startFont);
        }
    }

    @Override
    public void addFocusListener(FocusListener l) {
        super.addFocusListener(l);
        if (this.button != null) {
            this.button.addFocusListener(l);
        }
    }

    public void doClick() {
        this.button.doClick();
    }

    public String getAudioFileName() {
        return this.audioFileName;
    }

    public void setAudioFileName(String audioFileName) {
        this.audioFileName = audioFileName;
    }

    private AudioFormat getAudioFormat() {
        float sampleRate = 22050.0f;
        int sampleSizeInBits = 16;
        int channels = 1;
        boolean signed = true;
        boolean bigEndian = false;
        return new AudioFormat(sampleRate, sampleSizeInBits, channels, signed, bigEndian);
    }

    public void SimpleAudioPlayer(String audioFileName) {
        int EXTERNAL_BUFFER_SIZE = 128000;
        URL url = null;
        File soundFile = new File(audioFileName);
        AudioInputStream audioInputStream = null;
        try {
            audioInputStream = AudioSystem.getAudioInputStream(soundFile);
        }
        catch (Exception ee) {
            url = Thread.currentThread().getContextClassLoader().getResource(this.getAudioFileName());
            try {
                audioInputStream = AudioSystem.getAudioInputStream(url);
            }
            catch (Exception e2) {
                String msg = "Warning: Can't find Audio File from " + soundFile.getAbsolutePath();
                JOptionPane.showMessageDialog(null, msg, "Warning", 2);
            }
        }
        AudioFormat audioFormat = audioInputStream.getFormat();
        SourceDataLine line = null;
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
        try {
            line = (SourceDataLine)AudioSystem.getLine(info);
            line.open(audioFormat);
        }
        catch (LineUnavailableException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        line.start();
        int nBytesRead = 0;
        byte[] abData = new byte[128000];
        while (nBytesRead != -1) {
            try {
                nBytesRead = audioInputStream.read(abData, 0, abData.length);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (nBytesRead < 0) continue;
            int n = line.write(abData, 0, nBytesRead);
        }
        line.drain();
        line.close();
    }

    public int getMaxNumberPlay() {
        return this.maxNumberPlay;
    }

    public void setMaxNumberPlay(int maxNumberPlay) {
        this.maxNumberPlay = maxNumberPlay;
    }

    public void setNumberPlay(int numberPlay) {
        this.numberPlay = numberPlay;
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }
}

